/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db.expr.compare;

import java.util.Set;
import org.apache.empire.db.DBCmpType;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBExpr;
import org.apache.empire.db.expr.column.DBAbstractFuncExpr;
import org.apache.empire.db.expr.column.DBAliasExpr;
import org.apache.empire.db.expr.compare.DBCompareExpr;

public class DBCompareColExpr
extends DBCompareExpr {
    private static final long serialVersionUID = 1L;
    protected final DBColumnExpr expr;
    protected final DBCmpType cmpop;
    protected Object value;

    public DBCompareColExpr(DBColumnExpr expr, DBCmpType op, Object value) {
        this.expr = expr;
        this.cmpop = op;
        this.value = value;
    }

    @Override
    public DBDatabase getDatabase() {
        return this.expr.getDatabase();
    }

    public DBColumnExpr getColumnExpr() {
        return this.expr;
    }

    public DBCmpType getCmpop() {
        return this.cmpop;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    @Override
    public void addReferencedColumns(Set<DBColumn> list) {
        this.expr.addReferencedColumns(list);
        if (this.value instanceof DBExpr) {
            ((DBExpr)this.value).addReferencedColumns(list);
        }
    }

    public void addCompareExpr(StringBuilder buf, long context) {
        String arraySep = "+";
        DBCmpType op = this.cmpop;
        switch (op) {
            case BETWEEN: 
            case NOTBETWEEN: {
                arraySep = " AND ";
                break;
            }
            case IN: 
            case NOTIN: {
                arraySep = ", ";
                break;
            }
        }
        String valsql = this.getObjectValue(this.expr.getDataType(), this.value, context, arraySep);
        if (valsql == null || valsql.equalsIgnoreCase("null")) {
            op = DBCmpType.getNullType(op);
        }
        switch (op) {
            case EQUAL: {
                buf.append("=");
                break;
            }
            case NOTEQUAL: {
                buf.append("<>");
                break;
            }
            case LESSTHAN: {
                buf.append("<");
                break;
            }
            case MOREOREQUAL: {
                buf.append(">=");
                break;
            }
            case GREATERTHAN: {
                buf.append(">");
                break;
            }
            case LESSOREQUAL: {
                buf.append("<=");
                break;
            }
            case LIKE: {
                buf.append(" LIKE ");
                break;
            }
            case NOTLIKE: {
                buf.append(" NOT LIKE ");
                break;
            }
            case NULL: {
                buf.append(" IS NULL");
                valsql = null;
                break;
            }
            case NOTNULL: {
                buf.append(" IS NOT NULL");
                valsql = null;
                break;
            }
            case BETWEEN: {
                buf.append(" BETWEEN ");
                break;
            }
            case NOTBETWEEN: {
                buf.append(" NOT BETWEEN ");
                break;
            }
            case IN: {
                buf.append(" IN (");
                buf.append(valsql);
                buf.append(")");
                valsql = null;
                break;
            }
            case NOTIN: {
                buf.append(" NOT IN (");
                buf.append(valsql);
                buf.append(")");
                valsql = null;
                break;
            }
            default: {
                buf.append(" ");
            }
        }
        if (valsql != null) {
            buf.append(valsql);
        }
    }

    @Override
    public void addSQL(StringBuilder buf, long context) {
        if ((context & 4L) == 0L) {
            this.expr.addSQL(buf, context);
            return;
        }
        if ((context & 1L) == 0L) {
            String valsql = this.getObjectValue(this.expr.getDataType(), this.value, context, "+");
            buf.append(valsql != null ? valsql : "null");
            return;
        }
        this.expr.addSQL(buf, context);
        this.addCompareExpr(buf, context);
    }

    @Override
    public boolean isMutuallyExclusive(DBCompareExpr other) {
        if (other instanceof DBCompareColExpr) {
            DBCompareColExpr o = (DBCompareColExpr)other;
            DBColumnExpr oexpr = o.getColumnExpr();
            if (this.expr.equals(oexpr)) {
                return true;
            }
            DBColumnExpr texpr = this.expr;
            if (texpr instanceof DBAliasExpr) {
                texpr = ((DBAliasExpr)texpr).getExpr();
            }
            if (oexpr instanceof DBAliasExpr) {
                oexpr = ((DBAliasExpr)oexpr).getExpr();
            }
            boolean tfunc = texpr instanceof DBAbstractFuncExpr;
            boolean ofunc = oexpr instanceof DBAbstractFuncExpr;
            if (tfunc || ofunc) {
                if (tfunc && ofunc) {
                    return ((DBAbstractFuncExpr)texpr).isMutuallyExclusive((DBAbstractFuncExpr)oexpr);
                }
                return false;
            }
            DBColumn tcol = texpr.getUpdateColumn();
            DBColumn ocol = oexpr.getUpdateColumn();
            return tcol != null ? tcol.equals(ocol) : false;
        }
        return false;
    }
}

