/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db.expr.column;

import java.util.Set;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.data.DataType;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBDatabaseDriver;
import org.apache.empire.db.DBExpr;
import org.apache.empire.xml.XMLUtil;
import org.w3c.dom.Element;

public class DBValueExpr
extends DBColumnExpr {
    private static final long serialVersionUID = 1L;
    public final DBDatabase db;
    public final DataType type;
    public final DBColumnExpr column;
    protected Object value;

    public DBValueExpr(DBDatabase db, Object value, DataType type) {
        this.db = db;
        this.type = type;
        this.column = null;
        this.value = value;
    }

    public DBValueExpr(DBColumnExpr col, Object value) {
        this.column = col;
        this.type = col.getDataType();
        this.db = col.getDatabase();
        this.value = value;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    @Override
    public DBDatabase getDatabase() {
        return this.db;
    }

    @Override
    public DataType getDataType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.column != null ? this.column.getName() : null;
    }

    @Override
    public Element addXml(Element parent, long flags) {
        Element elem;
        if (this.column != null) {
            elem = this.column.addXml(parent, flags);
        } else {
            elem = XMLUtil.addElement(parent, "column");
            String name = this.getName();
            if (name != null) {
                elem.setAttribute("name", this.getName());
            }
            if (this.attributes != null) {
                this.attributes.addXml(elem, flags);
            }
            if (this.options != null) {
                this.options.addXml(elem, flags);
            }
        }
        elem.setAttribute("function", "value");
        return elem;
    }

    @Override
    public DBColumn getUpdateColumn() {
        return this.column != null ? this.column.getUpdateColumn() : null;
    }

    @Override
    public boolean isAggregate() {
        return false;
    }

    @Override
    public void addSQL(StringBuilder buf, long context) {
        if (this.value instanceof DBExpr) {
            ((DBExpr)this.value).addSQL(buf, context);
        } else {
            DBDatabaseDriver driver;
            DataType dataType = this.getDataType();
            Object dataValue = this.value;
            if (dataValue instanceof Enum) {
                dataValue = ObjectUtils.getEnumValue((Enum)dataValue, dataType.isNumeric());
            }
            String text = (driver = this.db.getDriver()) != null ? driver.getValueString(dataValue, dataType) : ObjectUtils.getString(dataValue);
            buf.append(text);
        }
    }

    @Override
    public void addReferencedColumns(Set<DBColumn> list) {
    }
}

