/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db.derby;

import org.apache.empire.data.DataType;
import org.apache.empire.db.DBDDLGenerator;
import org.apache.empire.db.DBTableColumn;
import org.apache.empire.db.derby.DBDatabaseDriverDerby;

public class DerbyDDLGenerator
extends DBDDLGenerator<DBDatabaseDriverDerby> {
    public DerbyDDLGenerator(DBDatabaseDriverDerby driver) {
        super(driver);
        this.initDataTypes();
    }

    private void initDataTypes() {
        this.DATATYPE_BOOLEAN = "SMALLINT";
    }

    @Override
    protected boolean appendColumnDataType(DataType type, double size, DBTableColumn c, StringBuilder sql) {
        switch (type) {
            case AUTOINC: {
                super.appendColumnDataType(type, size, c, sql);
                if (((DBDatabaseDriverDerby)this.driver).isUseSequenceTable()) break;
                sql.append(" GENERATED ALWAYS AS IDENTITY");
                break;
            }
            default: {
                return super.appendColumnDataType(type, size, c, sql);
            }
        }
        return true;
    }

    @Override
    protected void appendColumnDesc(DBTableColumn c, boolean alter, StringBuilder sql) {
        c.addSQL(sql, 1L);
        if (alter) {
            sql.append(" SET DATA TYPE ");
        } else {
            sql.append(" ");
        }
        if (!this.appendColumnDataType(c.getDataType(), c.getSize(), c, sql)) {
            return;
        }
        if (((DBDatabaseDriverDerby)this.driver).isDDLColumnDefaults() && !c.isAutoGenerated() && c.getDefaultValue() != null) {
            sql.append(" DEFAULT ");
            sql.append(((DBDatabaseDriverDerby)this.driver).getValueString(c.getDefaultValue(), c.getDataType()));
        }
        if (c.isRequired() || c.isAutoGenerated()) {
            sql.append(" NOT NULL");
        }
    }
}

