/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db.derby;

import java.sql.Connection;
import java.sql.Timestamp;
import java.util.GregorianCalendar;
import org.apache.empire.data.DataType;
import org.apache.empire.db.DBCmdType;
import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.DBCommand;
import org.apache.empire.db.DBDDLGenerator;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBDatabaseDriver;
import org.apache.empire.db.DBDriverFeature;
import org.apache.empire.db.DBObject;
import org.apache.empire.db.DBSQLScript;
import org.apache.empire.db.DBTable;
import org.apache.empire.db.DBTableColumn;
import org.apache.empire.db.derby.DerbyDDLGenerator;
import org.apache.empire.exceptions.NotSupportedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBDatabaseDriverDerby
extends DBDatabaseDriver {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(DBDatabaseDriverDerby.class);
    private String databaseName = null;
    private boolean useSequenceTable = false;
    private String sequenceTableName = "Sequences";
    private DBDDLGenerator<?> ddlGenerator = null;

    public DBDatabaseDriverDerby() {
        this.reservedSQLKeywords.add("count");
        this.reservedSQLKeywords.add("year");
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public boolean isUseSequenceTable() {
        return this.useSequenceTable;
    }

    public void setUseSequenceTable(boolean useSequenceTable) {
        this.useSequenceTable = useSequenceTable;
    }

    public String getSequenceTableName() {
        return this.sequenceTableName;
    }

    public void setSequenceTableName(String sequenceTableName) {
        this.sequenceTableName = sequenceTableName;
    }

    @Override
    public DBCommand createCommand(DBDatabase db) {
        if (db == null) {
            return null;
        }
        return new DBCommandDerby(db);
    }

    @Override
    public boolean isSupported(DBDriverFeature type) {
        switch (type) {
            case CREATE_SCHEMA: {
                return true;
            }
            case SEQUENCES: {
                return this.useSequenceTable;
            }
        }
        return false;
    }

    @Override
    public String getSQLPhrase(int phrase) {
        switch (phrase) {
            case 1: {
                return "null";
            }
            case 2: {
                return " ? ";
            }
            case 3: {
                return " ";
            }
            case 4: {
                return " AS ";
            }
            case 5: {
                return "@";
            }
            case 6: {
                return "\"";
            }
            case 7: {
                return "\"";
            }
            case 8: {
                return "? || {0}";
            }
            case 10: {
                return "1";
            }
            case 11: {
                return "0";
            }
            case 20: {
                return "CURRENT_DATE()";
            }
            case 21: {
                return "yyyy-MM-dd";
            }
            case 22: {
                return "'{0}'";
            }
            case 23: {
                return "yyyy-MM-dd HH:mm:ss";
            }
            case 24: {
                return "'{0}'";
            }
            case 25: {
                return "CURRENT_TIMESTAMP";
            }
            case 26: {
                return "yyyy-MM-dd HH:mm:ss";
            }
            case 27: {
                return "'{0}'";
            }
            case 100: {
                return "coalesce(?, {0})";
            }
            case 101: {
                return "substr(?, {0})";
            }
            case 102: {
                return "substr(?, {0}, {1})";
            }
            case 103: {
                return "replace(?, {0}, {1})";
            }
            case 104: {
                return "reverse_not_available_in_derby(?)";
            }
            case 105: {
                return "locate({0}, ?)";
            }
            case 106: {
                return "locate({0}, ?, {1})";
            }
            case 107: {
                return "length(?)";
            }
            case 110: {
                return "upper(?)";
            }
            case 111: {
                return "lower(?)";
            }
            case 112: {
                return "trim(?)";
            }
            case 113: {
                return "ltrim(?)";
            }
            case 114: {
                return "rtrim(?)";
            }
            case 119: {
                return "? escape '{0}'";
            }
            case 120: {
                return "abs(?)";
            }
            case 121: {
                return "round(?,{0})";
            }
            case 122: {
                return "truncate(?,{0})";
            }
            case 124: {
                return "ceiling(?)";
            }
            case 123: {
                return "floor(?)";
            }
            case 125: {
                return "mod(?,{0})";
            }
            case 126: {
                return "format(?, {0:VARCHAR})";
            }
            case 132: {
                return "day(?)";
            }
            case 133: {
                return "month(?)";
            }
            case 134: {
                return "year(?)";
            }
            case 140: {
                return "sum(?)";
            }
            case 142: {
                return "max(?)";
            }
            case 143: {
                return "min(?)";
            }
            case 144: {
                return "avg(?)";
            }
            case 150: {
                return "case ? {0} end";
            }
            case 151: {
                return " ";
            }
            case 152: {
                return "when {0} then {1}";
            }
            case 153: {
                return "else {0}";
            }
        }
        log.error("SQL phrase " + phrase + " is not defined!");
        return "";
    }

    @Override
    public String getConvertPhrase(DataType destType, DataType srcType, Object format) {
        switch (destType) {
            case BOOL: {
                return "CAST(? AS UNSIGNED)";
            }
            case INTEGER: {
                return "CAST(? AS SIGNED)";
            }
            case DECIMAL: {
                return "CAST(? AS DECIMAL)";
            }
            case FLOAT: {
                return "CAST(? AS DECIMAL)";
            }
            case DATE: {
                return "CAST(? AS DATE)";
            }
            case DATETIME: 
            case TIMESTAMP: {
                return "CAST(? AS TIMESTAMP)";
            }
            case TEXT: 
            case VARCHAR: 
            case CHAR: {
                return "CAST(? AS CHAR)";
            }
            case BLOB: {
                return "CAST(? AS BLOB)";
            }
        }
        log.error("getConvertPhrase: unknown type " + (Object)((Object)destType));
        return "?";
    }

    @Override
    public Object getNextSequenceValue(DBDatabase db, String seqName, int minValue, Connection conn) {
        if (this.useSequenceTable) {
            DBTable t = db.getTable(this.sequenceTableName);
            return ((DBDatabaseDriver.DBSeqTable)t).getNextValue(seqName, minValue, conn);
        }
        return null;
    }

    @Override
    public DBColumnExpr getNextSequenceValueExpr(DBTableColumn column) {
        throw new NotSupportedException(this, "getNextSequenceValueExpr");
    }

    @Override
    public Timestamp getUpdateTimestamp(Connection conn) {
        GregorianCalendar cal = new GregorianCalendar();
        return new Timestamp(cal.getTimeInMillis());
    }

    @Override
    public void getDDLScript(DBCmdType type, DBObject dbo, DBSQLScript script) {
        if (this.ddlGenerator == null) {
            this.ddlGenerator = new DerbyDDLGenerator(this);
        }
        this.ddlGenerator.getDDLScript(type, dbo, script);
    }

    public static class DBCommandDerby
    extends DBCommand {
        private static final long serialVersionUID = 1L;

        public DBCommandDerby(DBDatabase db) {
            super(db);
        }
    }
}

