/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db;

import java.util.ArrayList;
import java.util.Set;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.DBCommandExpr;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.expr.order.DBOrderByExpr;

public class DBCombinedCmd
extends DBCommandExpr {
    private static final long serialVersionUID = 1L;
    protected DBCommandExpr left;
    protected DBCommandExpr right;
    protected String keyWord;

    public DBCombinedCmd(DBCommandExpr left, String keyWord, DBCommandExpr right) {
        this.left = left;
        this.right = right;
        this.keyWord = keyWord;
    }

    @Override
    public boolean isValid() {
        return this.left.isValid() && this.right.isValid();
    }

    @Override
    public DBDatabase getDatabase() {
        return this.left.getDatabase();
    }

    @Override
    public void addReferencedColumns(Set<DBColumn> list) {
        this.left.addReferencedColumns(list);
        this.right.addReferencedColumns(list);
    }

    @Override
    public DBColumnExpr[] getSelectExprList() {
        return this.left.getSelectExprList();
    }

    @Override
    public Object[] getParamValues() {
        int i;
        Object[] leftParams = this.left.getParamValues();
        Object[] rightParams = this.right.getParamValues();
        if (leftParams == null) {
            return rightParams;
        }
        if (rightParams == null) {
            return leftParams;
        }
        Object[] allParams = new Object[leftParams.length + rightParams.length];
        for (i = 0; i < leftParams.length; ++i) {
            allParams[i] = leftParams[i];
        }
        for (i = 0; i < rightParams.length; ++i) {
            allParams[leftParams.length + i] = rightParams[i];
        }
        return allParams;
    }

    @Override
    public void getSelect(StringBuilder buf) {
        this.left.clearOrderBy();
        if (!(this.left instanceof DBCombinedCmd)) {
            buf.append("(");
            this.left.getSelect(buf);
            buf.append(")");
        } else {
            this.left.getSelect(buf);
        }
        buf.append("\r\n");
        buf.append(this.keyWord);
        buf.append("\r\n");
        this.right.clearOrderBy();
        if (!(this.right instanceof DBCombinedCmd)) {
            buf.append("(");
            this.right.getSelect(buf);
            buf.append(")");
        } else {
            this.right.getSelect(buf);
        }
        if (this.orderBy != null) {
            buf.append("\r\nORDER BY ");
            this.addListExpr(buf, this.orderBy, 7L, ", ");
        }
    }

    @Override
    public void orderBy(DBOrderByExpr ... exprs) {
        if (this.orderBy == null) {
            this.orderBy = new ArrayList();
        }
        for (DBOrderByExpr obe : exprs) {
            DBColumnExpr c = this.getCmdColumn(obe.getColumnExpr());
            this.orderBy.add(new DBOrderByExpr(c, obe.isDescending()));
        }
    }
}

