/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.data.bean;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.util.ArrayList;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.DBCommand;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBReader;
import org.apache.empire.db.DBRowSet;
import org.apache.empire.exceptions.BeanIncompatibleException;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanResult<T>
extends ArrayList<T> {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(BeanResult.class);
    private DBCommand cmd;
    private Class<T> clazz;

    public BeanResult(Class<T> clazz, DBCommand cmd) {
        this.clazz = clazz;
        this.cmd = cmd;
        if (cmd == null || cmd.hasSelectExpr()) {
            throw new InvalidArgumentException("cmd", cmd);
        }
    }

    public BeanResult(Class<T> clazz, DBRowSet rowset) {
        this.clazz = clazz;
        DBDatabase db = rowset.getDatabase();
        this.cmd = db.createCommand();
        int count = 0;
        Method[] methods = clazz.getMethods();
        for (DBColumn col : rowset.getColumns()) {
            String property = col.getBeanPropertyName();
            if (!this.isPropertyAcessible(methods, property)) {
                log.debug("Unable to access the property {} on {}. Column will be ignored.", (Object)property, (Object)clazz.getName());
                continue;
            }
            this.cmd.select((DBColumnExpr)col);
            ++count;
        }
        if (count == 0) {
            throw new BeanIncompatibleException(clazz, rowset);
        }
    }

    private boolean isPropertyAcessible(Method[] methods, String property) {
        property = "et" + property.substring(0, 1).toUpperCase() + property.substring(1);
        for (int i = 0; i < methods.length; ++i) {
            String name = methods[i].getName();
            if (!name.endsWith(property)) continue;
            return true;
        }
        return false;
    }

    public DBCommand getCommand() {
        return this.cmd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int fetch(Connection conn, int maxItems) {
        this.clear();
        DBReader reader = new DBReader();
        try {
            reader.open(this.cmd, conn);
            reader.getBeanList(this, this.clazz, maxItems);
            int n = this.size();
            return n;
        }
        finally {
            reader.close();
        }
    }

    public final int fetch(Connection conn) {
        return this.fetch(conn, -1);
    }
}

