/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.commons;

public class StringUtils {
    public static final String EMPTY = "";
    public static final String SPACE = " ";

    private StringUtils() {
    }

    public static String toString(Object value, String defValue) {
        return value != null ? value.toString() : defValue;
    }

    public static String toString(Object value) {
        return StringUtils.toString(value, null);
    }

    public static String toString(Object[] array, String defValue) {
        String s = StringUtils.arrayToString(array, "/");
        return s != null ? s : defValue;
    }

    public static String toString(Object[] array) {
        return StringUtils.toString(array, null);
    }

    public static String valueOf(Object value) {
        return StringUtils.toString(value, "null");
    }

    public static String valueOf(Object[] array) {
        return StringUtils.toString(array, "null");
    }

    public static String coalesce(String preferred, String alternative) {
        return StringUtils.isNotEmpty(preferred) ? preferred : alternative;
    }

    public static String nullIfEmpty(Object value) {
        if (value == null) {
            return null;
        }
        String strval = value.toString();
        return strval.length() == 0 ? null : strval;
    }

    public static boolean contains(String value, String substring) {
        if (value == null || substring == null) {
            return false;
        }
        return value.indexOf(substring) >= 0;
    }

    public static boolean notContains(String value, String substring) {
        if (value == null || substring == null) {
            return true;
        }
        return value.indexOf(substring) < 0;
    }

    public static String arrayToString(Object[] array, String separator) {
        if (array == null || array.length < 1) {
            return null;
        }
        if (array.length > 1) {
            StringBuilder buf = new StringBuilder();
            for (int i = 0; i < array.length; ++i) {
                if (i > 0 && separator != null) {
                    buf.append(separator);
                }
                buf.append(array[i]);
            }
            return buf.toString();
        }
        return String.valueOf(array[0]);
    }

    public static boolean isEmpty(String s) {
        if (s != null) {
            for (int i = 0; i < s.length(); ++i) {
                if (s.charAt(i) <= ' ') continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isNotEmpty(String s) {
        return !StringUtils.isEmpty(s);
    }

    public static boolean compareEqual(String s1, String s2, boolean ignoreCase) {
        if (s1 == null || s2 == null) {
            return s1 == s2;
        }
        if (StringUtils.isEmpty(s1) && StringUtils.isEmpty(s2)) {
            return true;
        }
        return ignoreCase ? s1.equalsIgnoreCase(s2) : s1.equals(s2);
    }

    public static boolean compareEqual(String s1, String s2) {
        if (s1 == s2) {
            return true;
        }
        if (StringUtils.isEmpty(s1)) {
            return StringUtils.isEmpty(s2);
        }
        if (StringUtils.isEmpty(s2)) {
            return false;
        }
        return s1.equals(s2);
    }

    public static boolean compareNotEqual(String s1, String s2, boolean ignoreCase) {
        return !StringUtils.compareEqual(s1, s2, ignoreCase);
    }

    public static boolean compareNotEqual(String s1, String s2) {
        return !StringUtils.compareEqual(s1, s2);
    }

    public static String validate(String s) {
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).length() == 0) {
            return null;
        }
        return s;
    }

    public static String replace(String source, String find, String replace) {
        if (source == null || find == null || find.length() == 0) {
            return source;
        }
        int index = source.indexOf(find);
        if (index < 0) {
            return source;
        }
        if (replace == null) {
            replace = EMPTY;
        }
        int len = find.length();
        return source.substring(0, index) + replace + StringUtils.replace(source.substring(index + len), find, replace);
    }

    public static String replaceAll(String s, String find, String replace) {
        if (s == null) {
            return null;
        }
        if (replace == null) {
            replace = EMPTY;
        }
        if (find == null || EMPTY.equals(find) || find.equals(replace)) {
            return s;
        }
        int start = s.indexOf(find);
        if (start < 0) {
            return s;
        }
        StringBuilder b = new StringBuilder(s.length());
        char[] origChars = s.toCharArray();
        int findLength = find.length();
        int copyFrom = 0;
        while (start >= 0) {
            b.append(origChars, copyFrom, start - copyFrom);
            if (replace.length() > 0) {
                b.append(replace);
            }
            copyFrom = start + findLength;
            start = s.indexOf(find, copyFrom);
        }
        if (origChars.length > copyFrom) {
            b.append(origChars, copyFrom, origChars.length - copyFrom);
        }
        return b.toString();
    }

    public static String remove(String s, String remove) {
        return StringUtils.replaceAll(s, remove, null);
    }

    public static String remove(String s, char c) {
        return StringUtils.replaceAll(s, String.valueOf(c), null);
    }

    public static String removeBlanks(String s) {
        return StringUtils.remove(s, SPACE);
    }

    public static boolean isCharBetween(char c, char beg, char end) {
        return c >= beg && c <= end;
    }

    public static boolean isNumber(char c) {
        return c >= '0' && c <= '9';
    }

    public static boolean isNumber(String s) {
        if (StringUtils.isEmpty(s)) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (StringUtils.isNumber(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNumeric(char c, boolean decimal) {
        if (c == '+' || c == '-') {
            return true;
        }
        if (decimal && (c == '.' || c == ',')) {
            return true;
        }
        return StringUtils.isNumber(c);
    }

    public static boolean isNumeric(String s, boolean decimal) {
        if (StringUtils.isEmpty(s)) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if ((c == '+' || c == '-') && i > 0) {
                return false;
            }
            if (StringUtils.isNumeric(c, decimal)) continue;
            return false;
        }
        return true;
    }

    public static boolean isUpper(char c) {
        return c >= 'A' && c <= 'Z' || c >= '\u00c0' && c <= '\u00dd';
    }

    public static boolean isUpper(String s, int count) {
        if (StringUtils.isEmpty(s)) {
            return false;
        }
        if (count > s.length()) {
            count = s.length();
        }
        for (int i = 0; i < count; ++i) {
            if (!StringUtils.isLower(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isLower(char c) {
        return c >= 'a' && c <= 'z' || c >= '\u00df' && c <= '\u00ff';
    }

    public static boolean isLower(String s, int count) {
        if (StringUtils.isEmpty(s)) {
            return false;
        }
        if (count > s.length()) {
            count = s.length();
        }
        for (int i = 0; i < count; ++i) {
            if (!StringUtils.isUpper(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String toUpper(String s, int count) {
        if (StringUtils.isEmpty(s)) {
            return s;
        }
        if (s.length() <= count) {
            return s.toUpperCase();
        }
        String start = s.substring(0, count);
        return start.toUpperCase() + s.substring(count);
    }

    public static String toLower(String s, int count) {
        if (StringUtils.isEmpty(s)) {
            return s;
        }
        if (s.length() <= count) {
            return s.toLowerCase();
        }
        String start = s.substring(0, count);
        return start.toLowerCase() + s.substring(count);
    }

    public static String truncate(String s, int maxChar) {
        if (StringUtils.isEmpty(s)) {
            return EMPTY;
        }
        if (maxChar < 1 || s.length() < maxChar) {
            return s;
        }
        return s.substring(0, maxChar);
    }
}

