/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.struts2.web;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.inject.Container;
import java.util.Iterator;
import java.util.Map;
import org.apache.empire.struts2.web.RequestContext;
import org.apache.empire.struts2.web.ResponseContext;
import org.apache.struts2.views.util.UrlHelper;

public class UrlHelperEx
extends UrlHelper {
    private static final int DEFAULT_HTTP_PORT = 80;
    private static final int DEFAULT_HTTPS_PORT = 443;

    public static String buildUrl(String action, RequestContext request, ResponseContext response, Map params) {
        return UrlHelperEx.buildUrl(action, request, response, params, null, true, true);
    }

    public static String buildUrl(String action, RequestContext request, ResponseContext response, Map params, String scheme, boolean includeContext, boolean encodeResult) {
        return UrlHelperEx.buildUrl(action, request, response, params, scheme, includeContext, encodeResult, false);
    }

    public static String buildUrl(String action, RequestContext request, ResponseContext response, Map params, String scheme, boolean includeContext, boolean encodeResult, boolean forceAddSchemeHostAndPort) {
        return UrlHelperEx.buildUrl(action, request, response, params, scheme, includeContext, encodeResult, forceAddSchemeHostAndPort, true);
    }

    public static String buildUrl(String action, RequestContext request, ResponseContext response, Map params, String scheme, boolean includeContext, boolean encodeResult, boolean forceAddSchemeHostAndPort, boolean escapeAmp) {
        StringBuilder link = new StringBuilder();
        boolean changedScheme = false;
        Container cont = ActionContext.getContext().getContainer();
        int httpPort = Integer.parseInt((String)cont.getInstance(String.class, "struts.url.http.port"));
        int httpsPort = Integer.parseInt((String)cont.getInstance(String.class, "struts.url.https.port"));
        if (forceAddSchemeHostAndPort) {
            String reqScheme = request.getScheme();
            changedScheme = true;
            link.append(scheme != null ? scheme : reqScheme);
            link.append("://");
            link.append(request.getServerName());
            if (scheme != null) {
                if (!scheme.equals(reqScheme)) {
                    if (scheme.equals("http") && httpPort != 80 || scheme.equals("https") && httpsPort != 443) {
                        link.append(":");
                        link.append(scheme.equals("http") ? httpPort : httpsPort);
                    }
                } else {
                    int reqPort = request.getServerPort();
                    if (scheme.equals("http") && reqPort != 80 || scheme.equals("https") && reqPort != 443) {
                        link.append(":");
                        link.append(reqPort);
                    }
                }
            }
        } else if (scheme != null && !scheme.equals(request.getScheme())) {
            changedScheme = true;
            link.append(scheme);
            link.append("://");
            link.append(request.getServerName());
            if (scheme.equals("http") && httpPort != 80 || scheme.equals("https") && httpsPort != 443) {
                link.append(":");
                link.append(scheme.equals("http") ? httpPort : httpsPort);
            }
        }
        if (action != null) {
            if (action.startsWith("/") && includeContext) {
                String contextPath = request.getContextPath();
                if (!contextPath.equals("/")) {
                    link.append(contextPath);
                }
            } else if (changedScheme) {
                String uri = (String)request.getAttribute("javax.servlet.forward.request_uri");
                if (uri == null) {
                    uri = request.getRequestURI();
                }
                link.append(uri.substring(0, uri.lastIndexOf(47) + 1));
            }
            link.append(action);
        } else {
            String requestURI = (String)request.getAttribute("struts.request_uri");
            if (requestURI == null) {
                requestURI = (String)request.getAttribute("javax.servlet.forward.request_uri");
            }
            if (requestURI == null) {
                requestURI = request.getRequestURI();
            }
            link.append(requestURI);
        }
        if (escapeAmp) {
            UrlHelperEx.buildParametersString((Map)params, (StringBuilder)link);
        } else {
            UrlHelperEx.buildParametersString(params, link, "&");
        }
        String result = link.toString();
        while (result.indexOf("<script>") > 0) {
            result = result.replaceAll("<script>", "script");
        }
        try {
            result = encodeResult ? response.encodeURL(result) : result;
        }
        catch (Exception ex) {
            result = link.toString();
        }
        return result;
    }

    public static void buildParametersString(Map params, StringBuilder link, String paramSeparator) {
        if (params != null && params.size() > 0) {
            if (link.toString().indexOf("?") == -1) {
                link.append("?");
            } else {
                link.append(paramSeparator);
            }
            Iterator iter = params.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                String name = (String)entry.getKey();
                Object value = entry.getValue();
                if (value instanceof Iterable) {
                    Iterator iterator = ((Iterable)value).iterator();
                    while (iterator.hasNext()) {
                        Object paramValue = iterator.next();
                        link.append(UrlHelperEx.buildParameterSubstring(name, paramValue.toString()));
                        if (!iterator.hasNext()) continue;
                        link.append(paramSeparator);
                    }
                } else if (value instanceof Object[]) {
                    Object[] array = (Object[])value;
                    for (int i = 0; i < array.length; ++i) {
                        Object paramValue = array[i];
                        link.append(UrlHelperEx.buildParameterSubstring(name, paramValue.toString()));
                        if (i >= array.length - 1) continue;
                        link.append(paramSeparator);
                    }
                } else {
                    link.append(UrlHelperEx.buildParameterSubstring(name, value != null ? value.toString() : ""));
                }
                if (!iter.hasNext()) continue;
                link.append(paramSeparator);
            }
        }
    }

    private static String buildParameterSubstring(String name, String value) {
        StringBuilder builder = new StringBuilder();
        builder.append(UrlHelperEx.translateAndEncode((String)name));
        builder.append('=');
        builder.append(UrlHelperEx.translateAndEncode((String)value));
        return builder.toString();
    }
}

