/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.struts2.jsp.controls;

import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Currency;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.lang.xwork.StringEscapeUtils;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.commons.Options;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.Column;
import org.apache.empire.data.DataType;
import org.apache.empire.struts2.html.HtmlWriter;
import org.apache.empire.struts2.jsp.controls.InputControl;
import org.apache.empire.struts2.web.FieldErrors;

public class TextInputControl
extends InputControl {
    public static final String FORMAT_UNIT = "unit:";

    @Override
    protected Object parseValue(String value, Locale locale, Column column) {
        DataType type = column.getDataType();
        if (type.isText()) {
            return value;
        }
        if (type == DataType.INTEGER) {
            return this.parseInteger(value);
        }
        if (type == DataType.DECIMAL) {
            return this.parseDecimal(value, this.getNumberFormat(column.getDataType(), locale, column));
        }
        if (type == DataType.DATE || type == DataType.DATETIME || type == DataType.TIMESTAMP) {
            return this.parseDate(value, this.getDateFormat(column.getDataType(), locale, column));
        }
        if (type == DataType.AUTOINC) {
            log.error("Autoinc-value cannot be changed.");
            return NO_VALUE;
        }
        return value;
    }

    @Override
    protected Object validate(Object o, Locale locale, Column column, String s) {
        if (o instanceof Number) {
            Number n;
            Object min = column.getAttribute("minValue");
            Object max = column.getAttribute("maxValue");
            if (min != null && max != null && ((n = (Number)o).intValue() < ObjectUtils.getInteger((Object)min) || n.intValue() > ObjectUtils.getInteger((Object)max))) {
                return this.error(FieldErrors.InputValueOutOfRange, new String[]{min.toString(), max.toString()}, s);
            }
        }
        return o;
    }

    @Override
    protected String formatValue(Object value, InputControl.ValueInfo vi, boolean hasError) {
        Options options = vi.getOptions();
        if (options != null && !options.isEmpty()) {
            String text = options.get(value);
            if (text != null) {
                return vi.getTranslation(text);
            }
            log.error("The element '" + String.valueOf(value) + "' is not part of the supplied option list.");
        }
        if (value == null) {
            if (value != vi.getNullValue()) {
                return this.formatValue(vi.getNullValue(), vi, false);
            }
            return "";
        }
        Column column = vi.getColumn();
        DataType dataType = this.getValueType(value, column != null ? column.getDataType() : DataType.UNKNOWN);
        if (dataType.isText() || dataType == DataType.UNKNOWN) {
            String s = String.valueOf(value);
            if (this.hasFormatOption(vi, "noencode")) {
                return s;
            }
            return StringEscapeUtils.escapeHtml((String)s);
        }
        if (dataType == DataType.INTEGER || dataType == DataType.AUTOINC) {
            NumberFormat nf = NumberFormat.getIntegerInstance(vi.getUserLocale());
            nf.setGroupingUsed(false);
            return nf.format(value);
        }
        if (dataType == DataType.DECIMAL || dataType == DataType.FLOAT) {
            NumberFormat nf = this.getNumberFormat(dataType, vi.getUserLocale(), column);
            return nf.format(value);
        }
        if (dataType == DataType.DATE || dataType == DataType.DATETIME || dataType == DataType.TIMESTAMP) {
            if (dataType != DataType.DATE && this.hasFormatOption(vi, "notime")) {
                dataType = DataType.DATE;
            }
            DateFormat df = this.getDateFormat(dataType, vi.getUserLocale(), column);
            return df.format(value);
        }
        return StringEscapeUtils.escapeHtml((String)String.valueOf(value));
    }

    protected String formatValue(InputControl.ValueInfo vi, boolean appendUnit) {
        String unit;
        String text = super.formatValue(vi);
        if (appendUnit && text != null && text.length() > 0 && (unit = this.getUnitString(vi)) != null) {
            text = text + " " + unit;
        }
        return text;
    }

    @Override
    protected void internalRenderText(HtmlWriter writer, InputControl.ValueInfo vi) {
        String text = this.formatValue(vi, true);
        this.printText(writer, text, "&nbsp;");
    }

    @Override
    public void renderInput(HtmlWriter writer, InputControl.ControlInfo ci) {
        String unit;
        int maxLength;
        HtmlWriter.HtmlTag input = writer.startTag("input");
        input.addAttribute("type", "text");
        input.addAttribute("id", ci.getId());
        input.addAttribute("class", ci.getCssClass());
        input.addAttribute("style", ci.getCssStyle());
        if (!ci.getDisabled()) {
            input.addAttribute("name", ci.getName());
            maxLength = this.getMaxInputLength(ci.getColumn());
            if (maxLength > 0) {
                input.addAttribute("maxlength", maxLength);
                input.addAttribute("size", String.valueOf(Math.min(maxLength, ci.getHSize())));
            }
        } else {
            input.addAttribute("disabled");
            maxLength = this.getMaxInputLength(ci.getColumn());
            if (maxLength > 0) {
                input.addAttribute("size", String.valueOf(Math.min(maxLength, ci.getHSize())));
            }
        }
        input.addAttribute("value", this.formatValue(ci, ci.getDisabled()));
        input.addAttribute("onclick", ci.getOnclick());
        input.addAttribute("onchange", ci.getOnchange());
        input.addAttribute("onfocus", ci.getOnfocus());
        input.addAttribute("onblur", ci.getOnblur());
        input.endTag();
        if (!ci.getDisabled() && (unit = this.getUnitString(ci)) != null) {
            writer.print(" ");
            writer.print(unit);
        }
    }

    protected int getMaxInputLength(Column col) {
        DataType type = col.getDataType();
        if (type == DataType.AUTOINC || type == DataType.INTEGER) {
            return 10;
        }
        if (type == DataType.FLOAT) {
            return 18;
        }
        if (type == DataType.DECIMAL) {
            double size = col.getSize();
            int len = (int)size;
            if ((int)(size = (size - (double)len) * 10.0) > 0) {
                len += (int)size + 1;
            }
            return len;
        }
        if (type == DataType.BOOL) {
            return 1;
        }
        if (type == DataType.DATE) {
            return 10;
        }
        if (type == DataType.DATETIME || type == DataType.TIMESTAMP) {
            return 16;
        }
        if (type == DataType.CLOB) {
            return 0;
        }
        return (int)col.getSize();
    }

    protected DataType getValueType(Object value, DataType desiredType) {
        if (value instanceof String) {
            return DataType.VARCHAR;
        }
        if (value instanceof Number) {
            if (desiredType == DataType.AUTOINC || desiredType == DataType.INTEGER || desiredType == DataType.FLOAT || desiredType == DataType.DECIMAL) {
                return desiredType;
            }
            if (value instanceof Integer || value instanceof Long || value instanceof Short) {
                return DataType.INTEGER;
            }
            if (value instanceof Float || value instanceof Double) {
                return DataType.FLOAT;
            }
            return DataType.DECIMAL;
        }
        if (value instanceof Date) {
            if (desiredType == DataType.TIMESTAMP || desiredType == DataType.DATETIME || desiredType == DataType.DATE) {
                return desiredType;
            }
            if (value instanceof Timestamp) {
                return DataType.DATETIME;
            }
            return DataType.DATE;
        }
        if (value instanceof Boolean) {
            return DataType.BOOL;
        }
        return DataType.UNKNOWN;
    }

    protected NumberFormat getNumberFormat(DataType dataType, Locale locale, Column column) {
        Object fractDigit;
        if (column == null) {
            return NumberFormat.getNumberInstance(locale);
        }
        String type = StringUtils.valueOf((Object)column.getAttribute("numberFormat"));
        NumberFormat nf = null;
        nf = type.equalsIgnoreCase("Integer") ? NumberFormat.getIntegerInstance(locale) : NumberFormat.getNumberInstance(locale);
        Object groupSep = column.getAttribute("numberGroupSeparator");
        if (groupSep != null) {
            nf.setGroupingUsed(ObjectUtils.getBoolean((Object)groupSep));
        }
        if ((fractDigit = column.getAttribute("numberFractionDigits")) != null) {
            int fractionDigits = ObjectUtils.getInteger((Object)fractDigit);
            nf.setMaximumFractionDigits(fractionDigits);
            nf.setMinimumFractionDigits(fractionDigits);
        }
        return nf;
    }

    protected DateFormat getDateFormat(DataType dataType, Locale locale, Column column) {
        DateFormat df = dataType == DataType.DATE ? DateFormat.getDateInstance(2, locale) : DateFormat.getDateTimeInstance(2, 2, locale);
        return df;
    }

    private String getUnitString(InputControl.ValueInfo vi) {
        String numberType;
        String format = this.getFormatOption(vi, FORMAT_UNIT);
        if (format != null) {
            return format;
        }
        Column column = vi.getColumn();
        if (column != null && column.getDataType() == DataType.DECIMAL && (numberType = StringUtils.toString((Object)column.getAttribute("numberFormat"))) != null) {
            if (numberType.equalsIgnoreCase("Currency")) {
                String currencyCode = StringUtils.toString((Object)column.getAttribute("currencyCode"));
                if (currencyCode != null) {
                    Currency currency = Currency.getInstance(currencyCode);
                    return currency != null ? currency.getSymbol() : null;
                }
            } else if (numberType.equalsIgnoreCase("Percent")) {
                return "%";
            }
        }
        return null;
    }

    protected Object parseInteger(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (Exception e) {
            return this.error(FieldErrors.InputNoIntegerFormat, null, s);
        }
    }

    protected Object parseDecimal(String s, NumberFormat nf) {
        try {
            for (int i = 0; i < s.length(); ++i) {
                if (s.charAt(i) < 'A') continue;
                return this.error(FieldErrors.InputNoNumberFormat, null, s);
            }
            return nf.parseObject(s);
        }
        catch (Exception e) {
            return this.error(FieldErrors.InputNoNumberFormat, null, s);
        }
    }

    protected Object parseDate(String s, DateFormat df) {
        try {
            df.setLenient(true);
            return df.parseObject(s);
        }
        catch (Exception e) {
            return this.error(FieldErrors.InputNoDateFormat, null, s);
        }
    }
}

