/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.struts2.actionsupport;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.Column;
import org.apache.empire.data.ColumnExpr;
import org.apache.empire.data.Record;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.DBCommand;
import org.apache.empire.db.DBCommandExpr;
import org.apache.empire.db.DBIndex;
import org.apache.empire.db.DBReader;
import org.apache.empire.db.DBRecord;
import org.apache.empire.db.DBRowSet;
import org.apache.empire.db.DBTable;
import org.apache.empire.db.exceptions.InvalidKeyException;
import org.apache.empire.db.exceptions.NoPrimaryKeyException;
import org.apache.empire.db.exceptions.QueryNoResultException;
import org.apache.empire.db.expr.compare.DBCompareColExpr;
import org.apache.empire.db.expr.compare.DBCompareExpr;
import org.apache.empire.exceptions.EmpireException;
import org.apache.empire.exceptions.ItemNotFoundException;
import org.apache.empire.exceptions.NotSupportedException;
import org.apache.empire.exceptions.ObjectNotValidException;
import org.apache.empire.struts2.actionsupport.ActionBase;
import org.apache.empire.struts2.actionsupport.RecordFormActionSupport;
import org.apache.empire.struts2.actionsupport.SessionPersistence;
import org.apache.empire.struts2.exceptions.InvalidFormDataException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordActionSupport
extends RecordFormActionSupport {
    protected static Logger log = LoggerFactory.getLogger(RecordActionSupport.class);
    protected DBRowSet rowset;
    protected DBRecord record;
    private boolean loadBeforeDelete = false;

    public RecordActionSupport(ActionBase action, DBRowSet rowset, DBRecord record, SessionPersistence persistence, String propertyName) {
        super(action, persistence, propertyName);
        this.rowset = rowset;
        this.record = record;
    }

    public RecordActionSupport(ActionBase action, DBRowSet rowset, DBRecord record, SessionPersistence persistence) {
        this(action, rowset, record, persistence, action.getItemPropertyName());
    }

    @Deprecated
    public RecordActionSupport(ActionBase action, DBRowSet rowset, DBRecord record, SessionPersistance persistence, String propertyName) {
        this(action, rowset, record, SessionPersistance.convert(persistence), propertyName);
    }

    @Deprecated
    public RecordActionSupport(ActionBase action, DBRowSet rowset, DBRecord record, SessionPersistance persistence) {
        this(action, rowset, record, SessionPersistance.convert(persistence), action.getItemPropertyName());
    }

    public DBRecord getRecord() {
        return this.record;
    }

    public DBRowSet getRowset() {
        return this.rowset;
    }

    public boolean isLoadBeforeDelete() {
        return this.loadBeforeDelete;
    }

    public void setLoadBeforeDelete(boolean loadBeforeDelete) {
        this.loadBeforeDelete = loadBeforeDelete;
    }

    @Deprecated
    public SessionPersistance getPersistance() {
        switch (this.getPersistence()) {
            case Key: {
                return SessionPersistance.Key;
            }
            case Data: {
                return SessionPersistance.Data;
            }
        }
        return SessionPersistance.None;
    }

    public boolean createRecord() {
        try {
            this.record.create(this.rowset, this.action.getConnection());
            this.persistOnSession();
            return true;
        }
        catch (Exception e) {
            this.action.setActionError(e);
            return false;
        }
    }

    public void initReferenceColumns() {
        Map refs = this.rowset.getColumnReferences();
        if (refs != null) {
            for (DBColumn column : refs.keySet()) {
                String name = column.getName();
                String value = this.action.getRequestParam(name);
                if (value != null) {
                    if (!StringUtils.isNotEmpty((String)value)) continue;
                    this.record.setValue((Column)column, (Object)value);
                    continue;
                }
                if (!column.isRequired()) continue;
                log.warn("Value for reference column has not been provided!");
                throw new ItemNotFoundException((Object)name);
            }
        }
    }

    public void loadRecord(Object[] recKey) {
        if (recKey == null || recKey.length == 0) {
            throw new InvalidKeyException(this.rowset, recKey);
        }
        this.record.read(this.rowset, recKey, this.action.getConnection());
        this.persistOnSession();
    }

    public boolean loadRecord() {
        try {
            Object[] key = this.getActionParamKey();
            if (key == null && this.persistence == SessionPersistence.Data) {
                this.reloadRecord();
                return true;
            }
            this.loadRecord(key);
            return true;
        }
        catch (Exception e) {
            this.action.setActionError(e);
            return false;
        }
    }

    public void reloadRecord() {
        switch (this.persistence) {
            case Key: {
                String stKey = StringUtils.toString((Object)this.action.getActionObject(this.getRecordPropertyName()));
                Object[] key = this.action.getRecordKeyFromString(stKey);
                this.loadRecord(key);
            }
            case Data: {
                Record rec = this.getRecordFromSession();
                if (rec != null && rec instanceof DBRecord) {
                    if (((DBRecord)rec).getRowSet() != this.rowset) {
                        throw new ObjectNotValidException((Object)rec);
                    }
                    this.record = (DBRecord)rec;
                }
                throw new ItemNotFoundException((Object)this.rowset.getName());
            }
        }
        throw new NotSupportedException((Object)this, "reloadRecord[] " + String.valueOf((Object)this.persistence));
    }

    public boolean deleteRecord(Object[] recKey, boolean newRec) {
        try {
            if (recKey == null || recKey.length == 0) {
                throw new InvalidKeyException(this.rowset, recKey);
            }
            if (newRec) {
                this.record.close();
                return true;
            }
            if (this.loadBeforeDelete) {
                this.record.read(this.rowset, recKey, this.action.getConnection());
                this.record.delete(this.action.getConnection());
            } else {
                this.rowset.deleteRecord(recKey, this.action.getConnection());
            }
            this.removeFromSession();
            return true;
        }
        catch (Exception e) {
            this.action.setActionError(e);
            return false;
        }
    }

    public final boolean deleteRecord() {
        Object[] recKey = this.getActionParamKey();
        boolean newRec = this.getActionParamNewFlag();
        return this.deleteRecord(recKey, newRec);
    }

    public boolean loadFormData(Object[] recKey, boolean insert) {
        try {
            if (recKey == null || recKey.length == 0) {
                throw new InvalidKeyException(this.rowset, recKey);
            }
            Connection conn = this.action.getConnection();
            this.initUpdateRecord(recKey, insert, conn);
            this.setUpdateFields((Record)this.record);
            this.persistOnSession();
            return true;
        }
        catch (Exception e) {
            this.action.setActionError(e);
            return false;
        }
    }

    @Override
    public boolean loadFormData() {
        Object[] recKey = this.getActionParamKey();
        boolean insert = this.getActionParamNewFlag();
        return this.loadFormData(recKey, insert);
    }

    public boolean saveChanges() {
        try {
            if (!this.record.isValid()) {
                log.error("Cannot save changes: record ist not valid");
                throw new ObjectNotValidException((Object)this.record);
            }
            this.updateRecord(this.action.getConnection());
            this.persistOnSession();
            return true;
        }
        catch (Exception e) {
            this.action.setActionError(e);
            return false;
        }
    }

    public void closeRecord() {
        this.record.close();
        this.removeFromSession();
    }

    public DBRecord detachRecord() {
        DBRecord rec = this.record;
        this.record = null;
        return rec;
    }

    public final List<DBIndex> findChangedIndexes() {
        if (!(this.rowset instanceof DBTable)) {
            return null;
        }
        if (!this.record.isValid() || !this.record.isModified()) {
            return null;
        }
        DBTable table = (DBTable)this.rowset;
        List avail = table.getIndexes();
        if (avail == null) {
            return null;
        }
        ArrayList<DBIndex> changed = null;
        block0: for (DBIndex idx : avail) {
            DBColumn[] idxColumns = idx.getColumns();
            for (int i = 0; i < idxColumns.length; ++i) {
                if (!this.record.wasModified((Column)idxColumns[i])) continue;
                if (changed == null) {
                    changed = new ArrayList<DBIndex>();
                }
                changed.add(idx);
                continue block0;
            }
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object[] findAnyConflictRecord() {
        List<DBIndex> changed = this.findChangedIndexes();
        if (changed == null) {
            return null;
        }
        DBColumn[] keyColumns = this.rowset.getKeyColumns();
        for (DBIndex idx : changed) {
            int i;
            DBCommand cmd = this.rowset.getDatabase().createCommand();
            cmd.select((DBColumnExpr[])keyColumns);
            boolean allNull = true;
            DBColumn[] idxColumns = idx.getColumns();
            for (int i2 = 0; i2 < idxColumns.length; ++i2) {
                Object value = this.record.getValue((ColumnExpr)idxColumns[i2]);
                cmd.where((DBCompareExpr)idxColumns[i2].is(value));
                if (value == null) continue;
                allNull = false;
            }
            if (allNull) continue;
            if (!this.record.isNew()) {
                if (keyColumns.length > 1) {
                    Object value = this.record.getValue((ColumnExpr)keyColumns[0]);
                    DBCompareColExpr notExpr = keyColumns[0].is(value);
                    for (i = 1; i < keyColumns.length; ++i) {
                        cmd.where((DBCompareExpr)keyColumns[i].is(value));
                    }
                    cmd.where(notExpr.not());
                } else {
                    Object value = this.record.getValue((ColumnExpr)keyColumns[0]);
                    cmd.where((DBCompareExpr)keyColumns[0].isNot(value));
                }
            }
            DBReader reader = new DBReader();
            try {
                reader.getRecordData((DBCommandExpr)cmd, this.action.getConnection());
                Object[] key = new Object[keyColumns.length];
                for (i = 0; i < keyColumns.length; ++i) {
                    key[i] = reader.getValue(i);
                }
                Object[] objectArray = key;
                return objectArray;
            }
            catch (QueryNoResultException queryNoResultException) {}
            continue;
            finally {
                reader.close();
            }
        }
        return null;
    }

    protected void updateRecord(Connection conn) {
        if (!this.record.isModified()) {
            return;
        }
        this.record.fillMissingDefaults(null);
        this.record.update(conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean setRecordFieldValue(int i, Object value, boolean verify) {
        if (verify) {
            try {
                this.record.setValue(i, value);
                return true;
            }
            catch (EmpireException e) {
                log.info("setRecordFieldValue failed. Message is {}.", (Object)e.getMessage());
                return false;
            }
        }
        boolean validate = this.record.isValidateFieldValues();
        try {
            this.record.setValidateFieldValues(false);
            this.record.setValue(i, value);
        }
        finally {
            this.record.setValidateFieldValues(validate);
        }
        return true;
    }

    private void initUpdateRecord(Object[] keyValues, boolean insert, Connection conn) {
        DBColumn[] keyColumns = this.rowset.getKeyColumns();
        if (keyColumns == null || keyColumns.length < 1) {
            throw new NoPrimaryKeyException(this.rowset);
        }
        if (keyValues == null || keyValues.length != keyColumns.length) {
            throw new InvalidKeyException(this.rowset, keyValues);
        }
        if (this.persistence == SessionPersistence.Data) {
            Record rec = this.getRecordFromSession();
            if (rec == null || !(rec instanceof DBRecord)) {
                throw new InvalidFormDataException();
            }
            this.record = (DBRecord)rec;
        }
        if (this.record.isValid()) {
            Object[] currentKey = this.record.getKeyValues();
            if (!this.compareKey(currentKey, keyValues)) {
                throw new InvalidFormDataException();
            }
            return;
        }
        if (insert) {
            this.record.init(this.rowset, keyValues, insert);
            log.debug("Record '" + this.rowset.getName() + "' prepared for Insert!");
        } else {
            this.record.read(this.rowset, keyValues, conn);
            log.debug("Record '" + this.rowset.getName() + "' prepared for Update!");
        }
    }

    @Deprecated
    public static enum SessionPersistance {
        None,
        Key,
        Data;


        static SessionPersistence convert(SessionPersistance sp) {
            switch (sp) {
                case Key: {
                    return SessionPersistence.Key;
                }
                case Data: {
                    return SessionPersistence.Data;
                }
            }
            return SessionPersistence.None;
        }
    }
}

