/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.struts2.actionsupport;

import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.Column;
import org.apache.empire.struts2.action.ErrorInfo;
import org.apache.empire.struts2.actionsupport.ActionBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FormActionSupport {
    protected static Logger log = LoggerFactory.getLogger(FormActionSupport.class);
    protected ActionBase action;
    protected String propertyName;
    private boolean enableFieldErrors = true;

    protected FormActionSupport(ActionBase action, String propertyName) {
        this.action = action;
        this.propertyName = propertyName;
        if (propertyName == null || propertyName.length() == 0) {
            log.warn("No property name has been specified for FormActionSupport! Using default 'item'.");
            propertyName = "item";
        }
    }

    public final boolean isEnableFieldErrors() {
        return this.enableFieldErrors;
    }

    public final void setEnableFieldErrors(boolean enableFieldErrors) {
        this.enableFieldErrors = enableFieldErrors;
    }

    public String getRecordPropertyName() {
        if (this.propertyName != null) {
            return this.propertyName;
        }
        return this.action.getItemPropertyName();
    }

    protected String getActionParam(String name, boolean persist) {
        String item = this.action.getRequestParam(name);
        if (persist) {
            if (item == null) {
                return StringUtils.toString((Object)this.action.getActionObject(name));
            }
            this.action.putActionObject(name, item);
        }
        return item;
    }

    public abstract boolean loadFormData();

    protected void addFieldError(String name, Column column, ErrorInfo error, Object value) {
        if (this.enableFieldErrors) {
            this.action.addFieldError(name, column, error);
        }
    }
}

