/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.jsf2.pages;

import java.io.Serializable;
import java.sql.Connection;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBObject;
import org.apache.empire.db.DBRowSet;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.jsf2.pages.Page;

public class PageElement
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Page page;
    private final String propertyName;

    protected PageElement(Page page, String propertyName) {
        if (page == null) {
            throw new InvalidArgumentException("page", (Object)page);
        }
        if (StringUtils.isEmpty((String)propertyName)) {
            throw new InvalidArgumentException("propertyName", (Object)propertyName);
        }
        this.page = page;
        this.propertyName = propertyName;
        page.registerPageElement(this);
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public Page getPage() {
        return this.page;
    }

    protected void onInitPage() {
    }

    protected void onRefreshPage() {
    }

    protected <T> T getSessionObject(Class<T> type) {
        String beanName = this.page.getPageName() + "." + this.propertyName + "." + type.getSimpleName();
        Map map = FacesContext.getCurrentInstance().getExternalContext().getSessionMap();
        return (T)map.get(beanName);
    }

    protected <T> void setSessionObject(Class<T> type, T object) {
        String beanName = this.page.getPageName() + "." + this.propertyName + "." + type.getSimpleName();
        Map map = FacesContext.getCurrentInstance().getExternalContext().getSessionMap();
        if (object != null) {
            map.put(beanName, object);
        } else {
            map.remove(beanName);
        }
    }

    protected <T> void removeSessionObject(Class<T> type) {
        this.setSessionObject(type, null);
    }

    public Connection getConnection(DBDatabase db) {
        return this.page.getConnection(db);
    }

    public Connection getConnection(DBObject dbo) {
        if (dbo == null) {
            throw new InvalidArgumentException("dbo", (Object)dbo);
        }
        return this.page.getConnection(dbo.getDatabase());
    }

    protected static String getDefaultPropertyName(DBRowSet rowset) {
        String name = rowset.getName();
        if (name == null) {
            return "unknown";
        }
        name = name.toLowerCase();
        String res = "";
        int beg = 0;
        while (beg < name.length()) {
            int end = name.indexOf(95, beg);
            if (end < 0) {
                end = name.length();
            }
            if (end > beg) {
                if (beg == 0) {
                    res = name.substring(beg, end);
                } else {
                    res = res + name.substring(beg, beg + 1).toUpperCase();
                    if (end - beg > 1) {
                        res = res + name.substring(beg + 1, end);
                    }
                }
            }
            beg = end + 1;
        }
        return res;
    }
}

