/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.jsf2.app;

import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.servlet.http.HttpServletResponse;
import org.apache.empire.jsf2.app.WebApplication;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FacesRequestPhaseListener
implements PhaseListener {
    private static final long serialVersionUID = 1L;
    final Logger log = LoggerFactory.getLogger(FacesRequestPhaseListener.class);

    public PhaseId getPhaseId() {
        return PhaseId.ANY_PHASE;
    }

    public void beforePhase(PhaseEvent pe) {
        if (pe.getPhaseId() != PhaseId.RENDER_RESPONSE) {
            return;
        }
        FacesContext facesContext = pe.getFacesContext();
        HttpServletResponse response = (HttpServletResponse)facesContext.getExternalContext().getResponse();
        response.addHeader("Pragma", "no-cache");
        response.addHeader("Cache-Control", "no-cache");
        response.addHeader("Cache-Control", "no-store");
        response.addHeader("Cache-Control", "must-revalidate");
    }

    public void afterPhase(PhaseEvent pe) {
        FacesContext ctx = pe.getFacesContext();
        if (pe.getPhaseId() == PhaseId.RENDER_RESPONSE || ctx.getResponseComplete()) {
            WebApplication app = WebApplication.getInstance();
            if (app != null) {
                app.onRequestComplete(ctx);
            } else {
                this.log.warn("No WebApplication available to complete and cleanup request. Please create a managed bean of name " + WebApplication.APPLICATION_BEAN_NAME);
            }
        }
    }
}

