/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.exceptions;

import java.text.MessageFormat;
import org.apache.empire.commons.ErrorType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmpireException
extends RuntimeException {
    private static final Logger log = LoggerFactory.getLogger(EmpireException.class);
    private static final long serialVersionUID = 1L;
    private final ErrorType errorType;
    private final String[] errorParams;

    public static String formatErrorMessage(ErrorType errType, String pattern, String[] params) {
        try {
            int paramCount;
            if (pattern == null) {
                pattern = errType.getMessagePattern();
            }
            Object[] formatArgs = params;
            int patParamCount = errType.getNumParams();
            int n = paramCount = params != null ? params.length : 0;
            if (paramCount < patParamCount) {
                log.warn("Invalid Number of arguments supplied for error " + errType.getKey() + "\nArguments supplied= " + String.valueOf(paramCount) + "; Arguments expected= " + String.valueOf(errType.getNumParams()));
                return pattern;
            }
            if (paramCount > patParamCount) {
                if (pattern.contains("{*}")) {
                    pattern = pattern.replace("{*}", "{" + String.valueOf(patParamCount) + "}");
                    ++patParamCount;
                }
                if (patParamCount > 0) {
                    int i;
                    formatArgs = new String[patParamCount];
                    for (i = 0; i < patParamCount - 1; ++i) {
                        formatArgs[i] = params[i];
                    }
                    StringBuilder b = new StringBuilder();
                    while (i < paramCount) {
                        if (b.length() > 0) {
                            b.append(", ");
                        }
                        b.append(String.valueOf(params[i]));
                        ++i;
                    }
                    formatArgs[patParamCount - 1] = b.toString();
                }
            }
            String msg = MessageFormat.format(pattern, formatArgs);
            return msg;
        }
        catch (Exception e) {
            log.error("Unable to format error message: " + pattern, (Throwable)e);
            return pattern;
        }
    }

    protected EmpireException(ErrorType errType, String[] params, Throwable cause) {
        super(EmpireException.formatErrorMessage(errType, null, params), cause);
        this.errorType = errType;
        this.errorParams = params;
        this.log();
    }

    protected EmpireException(ErrorType errType, String[] params) {
        this(errType, params, null);
    }

    protected void log() {
        if (log.isInfoEnabled()) {
            log.info("An Error occured. Message is: {}", (Object)this.getMessage());
        }
    }

    public ErrorType getErrorType() {
        return this.errorType;
    }

    public String[] getErrorParams() {
        return this.errorParams;
    }
}

