/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db.sqlite;

import java.util.Map;
import org.apache.empire.data.DataType;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBDDLGenerator;
import org.apache.empire.db.DBIndex;
import org.apache.empire.db.DBRelation;
import org.apache.empire.db.DBSQLScript;
import org.apache.empire.db.DBTable;
import org.apache.empire.db.DBTableColumn;
import org.apache.empire.db.sqlite.DBDatabaseDriverSQLite;

public class SQLiteDDLGenerator
extends DBDDLGenerator<DBDatabaseDriverSQLite> {
    public SQLiteDDLGenerator(DBDatabaseDriverSQLite driver) {
        super(driver);
        this.initDataTypes();
    }

    private void initDataTypes() {
        this.DATATYPE_INTEGER = "INTEGER";
        this.DATATYPE_BOOLEAN = "BOOLEAN";
        this.DATATYPE_TIMESTAMP = "DATETIME DEFAULT CURRENT_TIMESTAMP";
    }

    @Override
    protected void createTable(DBTable t, DBSQLScript script) {
        DBIndex pk;
        StringBuilder sql = new StringBuilder();
        sql.append("-- creating table ");
        sql.append(t.getName());
        sql.append(" --\r\n");
        sql.append("CREATE TABLE ");
        t.addSQL(sql, 2L);
        sql.append(" (");
        boolean addSeparator = false;
        for (DBTableColumn dBTableColumn : t.getColumns()) {
            if (dBTableColumn.getDataType() == DataType.UNKNOWN) continue;
            sql.append(addSeparator ? ",\r\n   " : "\r\n   ");
            this.appendColumnDesc(dBTableColumn, false, sql);
            addSeparator = true;
        }
        Map<DBColumn, DBColumn> map = t.getColumnReferences();
        if (map != null) {
            DBColumn source = null;
            DBColumn target = null;
            for (Map.Entry<DBColumn, DBColumn> entry : map.entrySet()) {
                source = entry.getKey();
                target = entry.getValue();
                sql.append(addSeparator ? ",\r\n   " : "\r\n   ");
                sql.append("FOREIGN KEY (");
                source.addSQL(sql, 1L);
                sql.append(") REFERENCES ");
                sql.append(target.getRowSet().getName());
                sql.append(" (");
                target.addSQL(sql, 1L);
                sql.append(")");
            }
        }
        if ((pk = t.getPrimaryKey()) != null) {
            sql.append(",\r\n");
            if (this.namePrimaryKeyConstraint) {
                sql.append(" CONSTRAINT ");
                this.appendElementName(sql, pk.getName());
            }
            sql.append(" PRIMARY KEY (");
            addSeparator = false;
            DBColumn[] keyColumns = pk.getColumns();
            for (int i = 0; i < keyColumns.length; ++i) {
                sql.append(addSeparator ? ", " : "");
                keyColumns[i].addSQL(sql, 1L);
                addSeparator = true;
            }
            sql.append(")");
        }
        sql.append(")");
        this.addCreateTableStmt(t, sql, script);
        this.createTableIndexes(t, pk, script);
    }

    @Override
    protected void createRelation(DBRelation r, DBSQLScript script) {
    }
}

