/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db.hsql;

import java.sql.Connection;
import java.sql.Timestamp;
import java.util.GregorianCalendar;
import org.apache.empire.data.DataType;
import org.apache.empire.db.DBCmdType;
import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.DBCommand;
import org.apache.empire.db.DBDDLGenerator;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBDatabaseDriver;
import org.apache.empire.db.DBDriverFeature;
import org.apache.empire.db.DBObject;
import org.apache.empire.db.DBSQLScript;
import org.apache.empire.db.DBTableColumn;
import org.apache.empire.db.hsql.HSqlDDLGenerator;
import org.apache.empire.exceptions.NotSupportedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBDatabaseDriverHSql
extends DBDatabaseDriver {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(DBDatabaseDriverHSql.class);
    private DBDDLGenerator<?> ddlGenerator = null;

    public DBDatabaseDriverHSql() {
        this.reservedSQLKeywords.add("count");
    }

    @Override
    public DBCommand createCommand(DBDatabase db) {
        if (db == null) {
            return null;
        }
        return new DBCommandHSql(db);
    }

    @Override
    public boolean isSupported(DBDriverFeature type) {
        switch (type) {
            case CREATE_SCHEMA: {
                return false;
            }
            case SEQUENCES: {
                return true;
            }
        }
        return false;
    }

    @Override
    public String getSQLPhrase(int phrase) {
        switch (phrase) {
            case 1: {
                return "null";
            }
            case 2: {
                return " ? ";
            }
            case 3: {
                return " ";
            }
            case 4: {
                return " AS ";
            }
            case 5: {
                return "@";
            }
            case 6: {
                return "\"";
            }
            case 7: {
                return "\"";
            }
            case 8: {
                return "concat(?, {0})";
            }
            case 10: {
                return String.valueOf(Boolean.TRUE);
            }
            case 11: {
                return String.valueOf(Boolean.FALSE);
            }
            case 20: {
                return "CURRENT_DATE";
            }
            case 21: {
                return "yyyy-MM-dd";
            }
            case 22: {
                return "'{0}'";
            }
            case 23: {
                return "yyyy-MM-dd HH:mm:ss.S";
            }
            case 24: {
                return "'{0}'";
            }
            case 25: {
                return "CURRENT_TIMESTAMP";
            }
            case 26: {
                return "yyyy-MM-dd HH:mm:ss.S";
            }
            case 27: {
                return "'{0}'";
            }
            case 100: {
                return "coalesce(?, {0})";
            }
            case 101: {
                return "substr(?, {0})";
            }
            case 102: {
                return "substr(?, {0}, {1})";
            }
            case 103: {
                return "replace(?, {0}, {1})";
            }
            case 104: {
                return "?";
            }
            case 105: {
                return "locate({0}, ?)";
            }
            case 106: {
                return "locate({0}, ?, {1})";
            }
            case 110: {
                return "ucase(?)";
            }
            case 111: {
                return "lcase(?)";
            }
            case 107: {
                return "length(?)";
            }
            case 112: {
                return "trim(?)";
            }
            case 113: {
                return "ltrim(?)";
            }
            case 114: {
                return "rtrim(?)";
            }
            case 119: {
                return "? escape '{0}'";
            }
            case 120: {
                return "abs(?)";
            }
            case 121: {
                return "round(?,{0})";
            }
            case 122: {
                return "truncate(?,{0})";
            }
            case 124: {
                return "ceiling(?)";
            }
            case 123: {
                return "floor(?)";
            }
            case 125: {
                return "mod(?,{0})";
            }
            case 126: {
                return "TO_CHAR(?, {0:VARCHAR})";
            }
            case 132: {
                return "day(?)";
            }
            case 133: {
                return "month(?)";
            }
            case 134: {
                return "year(?)";
            }
            case 140: {
                return "sum(?)";
            }
            case 142: {
                return "max(?)";
            }
            case 143: {
                return "min(?)";
            }
            case 144: {
                return "avg(?)";
            }
            case 150: {
                return "case ?{0} end";
            }
            case 151: {
                return " ";
            }
            case 152: {
                return "when {0} then {1}";
            }
            case 153: {
                return "else {0}";
            }
        }
        log.error("SQL phrase " + phrase + " is not defined!");
        return "";
    }

    @Override
    public String getConvertPhrase(DataType destType, DataType srcType, Object format) {
        switch (destType) {
            case TEXT: 
            case VARCHAR: 
            case CHAR: {
                if (format != null) {
                    if (srcType == DataType.INTEGER || srcType == DataType.AUTOINC) {
                        log.error("getConvertPhrase: unknown type " + (Object)((Object)destType));
                        return "?";
                    }
                    return "to_char(?, '" + format.toString() + "')";
                }
                return "convert(?, CHAR)";
            }
            case INTEGER: {
                return "convert(?, BIGINT)";
            }
            case DECIMAL: {
                return "convert(?, DECIMAL)";
            }
            case FLOAT: {
                return "convert(?, DOUBLE)";
            }
        }
        log.error("getConvertPhrase: unknown type (" + String.valueOf((Object)destType));
        return "?";
    }

    @Override
    public Object getNextSequenceValue(DBDatabase db, String seqName, int minValue, Connection conn) {
        StringBuilder sql = new StringBuilder(80);
        sql.append("SELECT ");
        sql.append("NEXT VALUE FOR ");
        db.appendQualifiedName(sql, seqName, this.detectQuoteName(seqName));
        sql.append(" FROM INFORMATION_SCHEMA.SYSTEM_SEQUENCES WHERE SEQUENCE_NAME='").append(seqName).append("'");
        Object val = db.querySingleValue(sql.toString(), null, conn);
        if (val == null) {
            log.error("getNextSequenceValue: Invalid sequence value for sequence " + seqName);
        }
        return val;
    }

    @Override
    public DBColumnExpr getNextSequenceValueExpr(DBTableColumn column) {
        throw new NotSupportedException(this, "getNextSequenceValueExpr");
    }

    @Override
    public Timestamp getUpdateTimestamp(Connection conn) {
        GregorianCalendar cal = new GregorianCalendar();
        return new Timestamp(cal.getTimeInMillis());
    }

    @Override
    public void getDDLScript(DBCmdType type, DBObject dbo, DBSQLScript script) {
        if (this.ddlGenerator == null) {
            this.ddlGenerator = new HSqlDDLGenerator(this);
        }
        this.ddlGenerator.getDDLScript(type, dbo, script);
    }

    public static class DBCommandHSql
    extends DBCommand {
        private static final long serialVersionUID = 1L;

        public DBCommandHSql(DBDatabase db) {
            super(db);
        }
    }
}

