/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db.h2;

import org.apache.empire.data.DataType;
import org.apache.empire.db.DBDDLGenerator;
import org.apache.empire.db.DBTableColumn;
import org.apache.empire.db.h2.DBDatabaseDriverH2;

public class H2DDLGenerator
extends DBDDLGenerator<DBDatabaseDriverH2> {
    public H2DDLGenerator(DBDatabaseDriverH2 driver) {
        super(driver);
        this.initDataTypes();
    }

    private void initDataTypes() {
        this.DATATYPE_FLOAT = "DOUBLE";
        this.DATATYPE_CLOB = "LONGTEXT";
    }

    @Override
    protected boolean appendColumnDataType(DataType type, double size, DBTableColumn c, StringBuilder sql) {
        switch (type) {
            case AUTOINC: {
                super.appendColumnDataType(type, size, c, sql);
                if (((DBDatabaseDriverH2)this.driver).isUseSequenceTable()) break;
                sql.append(" AUTO_INCREMENT");
                break;
            }
            default: {
                return super.appendColumnDataType(type, size, c, sql);
            }
        }
        return true;
    }
}

