/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db.expr.column;

import java.util.Map;
import java.util.Set;
import org.apache.empire.data.DataType;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.expr.compare.DBCompareExpr;
import org.apache.empire.xml.XMLUtil;
import org.w3c.dom.Element;

public class DBCaseWhenExpr
extends DBColumnExpr {
    private static final long serialVersionUID = 1L;
    private final Map<DBCompareExpr, DBColumnExpr> whenMap;
    private final DBColumnExpr elseExpr;

    public DBCaseWhenExpr(Map<DBCompareExpr, DBColumnExpr> whenMap, DBColumnExpr elseExpr) {
        this.whenMap = whenMap;
        this.elseExpr = elseExpr;
    }

    @Override
    public DBDatabase getDatabase() {
        return this.getFirstColumnExpr().getDatabase();
    }

    @Override
    public DataType getDataType() {
        DBColumnExpr cexp = this.getFirstColumnExpr();
        return cexp.getDataType();
    }

    @Override
    public String getName() {
        DBCompareExpr firstCmpExpr = this.whenMap.keySet().iterator().next();
        StringBuilder b = new StringBuilder("CASE_");
        firstCmpExpr.addSQL(b, 1L);
        return b.toString();
    }

    @Override
    public DBColumn getUpdateColumn() {
        return null;
    }

    @Override
    public boolean isAggregate() {
        return this.getFirstColumnExpr().isAggregate();
    }

    @Override
    public void addReferencedColumns(Set<DBColumn> list) {
        for (Map.Entry<DBCompareExpr, DBColumnExpr> entry : this.whenMap.entrySet()) {
            if (entry.getKey() != null) {
                entry.getKey().addReferencedColumns(list);
            }
            if (entry.getValue() == null) continue;
            entry.getValue().addReferencedColumns(list);
        }
        if (this.elseExpr != null) {
            this.elseExpr.addReferencedColumns(list);
        }
    }

    @Override
    public void addSQL(StringBuilder sql, long context) {
        context &= 0xFFFFFFFFFFFFFFF7L;
        if (!this.whenMap.isEmpty()) {
            sql.append("CASE");
            for (Map.Entry<DBCompareExpr, DBColumnExpr> entry : this.whenMap.entrySet()) {
                sql.append(" WHEN ");
                DBCompareExpr compExpr = entry.getKey();
                compExpr.addSQL(sql, context);
                sql.append(" THEN ");
                DBColumnExpr trueExpr = entry.getValue();
                if (trueExpr != null) {
                    trueExpr.addSQL(sql, context);
                    continue;
                }
                sql.append("NULL");
            }
            sql.append(" ELSE ");
        }
        if (this.elseExpr != null) {
            this.elseExpr.addSQL(sql, context);
        } else {
            sql.append("NULL");
        }
        if (!this.whenMap.isEmpty()) {
            sql.append(" END");
        }
    }

    @Override
    public Element addXml(Element parent, long flags) {
        Element elem = XMLUtil.addElement(parent, "column");
        elem.setAttribute("name", this.getName());
        if (this.attributes != null) {
            this.attributes.addXml(elem, flags);
        }
        if (this.options != null) {
            this.options.addXml(elem, flags);
        }
        elem.setAttribute("function", "case");
        return elem;
    }

    private DBColumnExpr getFirstColumnExpr() {
        for (DBColumnExpr expr : this.whenMap.values()) {
            if (expr == null) continue;
            return expr;
        }
        return this.elseExpr;
    }
}

