/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db.expr.column;

import java.util.Set;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.DataType;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBDatabaseDriver;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.xml.XMLUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public abstract class DBAbstractFuncExpr
extends DBColumnExpr {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(DBAbstractFuncExpr.class);
    protected final DBColumnExpr expr;
    protected final DBColumn updateColumn;
    protected final boolean isAggregate;
    protected final DataType dataType;

    public DBAbstractFuncExpr(DBColumnExpr expr, DBColumn updateColumn, boolean isAggregate, DataType dataType) {
        this.expr = expr;
        this.updateColumn = updateColumn;
        this.isAggregate = isAggregate;
        this.dataType = dataType;
    }

    protected abstract String getFunctionName();

    protected final DBDatabaseDriver getDatabaseDriver() {
        DBDatabase db = this.getDatabase();
        return db != null ? db.getDriver() : null;
    }

    @Override
    public DBDatabase getDatabase() {
        return this.expr.getDatabase();
    }

    @Override
    public DataType getDataType() {
        return this.dataType;
    }

    @Override
    public String getName() {
        return this.expr.getName();
    }

    @Override
    public DBColumn getUpdateColumn() {
        return this.updateColumn;
    }

    @Override
    public boolean isAggregate() {
        return this.isAggregate || this.expr.isAggregate();
    }

    @Override
    public void addReferencedColumns(Set<DBColumn> list) {
        this.expr.addReferencedColumns(list);
    }

    public boolean isMutuallyExclusive(DBAbstractFuncExpr other) {
        String oname;
        String tname = this.getFunctionName();
        if (StringUtils.compareNotEqual(tname, oname = other.getFunctionName())) {
            return false;
        }
        DBColumn tcol = this.getUpdateColumn();
        DBColumn ocol = other.getUpdateColumn();
        return tcol != null ? tcol.equals(ocol) : false;
    }

    public final void addSQL(StringBuilder sql, String template, Object[] params, long context) {
        block3: {
            if (params == null) break block3;
            for (int i = 0; i < params.length; ++i) {
                int end;
                int idx;
                String ph;
                DataType paramDataType;
                block5: {
                    block4: {
                        DataType dataType;
                        paramDataType = this.expr.getDataType();
                        ph = "{" + String.valueOf(i);
                        idx = template.indexOf(ph);
                        if (idx < 0) break block4;
                        end = template.indexOf(125, idx += ph.length());
                        if (end < idx) {
                            throw new InvalidArgumentException("template", template);
                        }
                        if (template.charAt(idx) != ':') break block5;
                        String typeName = end >= idx ? template.substring(idx + 1, end) : null;
                        DataType dataType2 = dataType = typeName != null ? DataType.valueOf(typeName) : null;
                        if (dataType == null) break block5;
                        paramDataType = dataType;
                        break block5;
                    }
                    log.warn("No placeholder found in template {} for paramter {}", (Object)template, (Object)i);
                    continue;
                }
                ph = ph + template.substring(idx, end + 1);
                String paramAsString = this.getObjectValue(paramDataType, params[i], 7L, ",");
                template = StringUtils.replaceAll(template, ph, paramAsString);
            }
        }
        String prefix = template;
        String postfix = "";
        int sep = template.indexOf("?");
        if (sep >= 0) {
            prefix = template.substring(0, sep);
            postfix = template.substring(sep + 1);
        }
        sql.append(prefix);
        this.expr.addSQL(sql, context & 0xFFFFFFFFFFFFFFF7L);
        sql.append(postfix);
    }

    @Override
    public Element addXml(Element parent, long flags) {
        Element elem;
        if (this.updateColumn != null) {
            elem = this.updateColumn.addXml(parent, flags);
        } else {
            elem = XMLUtil.addElement(parent, "column");
            elem.setAttribute("name", this.getName());
            if (this.attributes != null) {
                this.attributes.addXml(elem, flags);
            }
            if (this.options != null) {
                this.options.addXml(elem, flags);
            }
        }
        elem.setAttribute("function", this.getFunctionName());
        return elem;
    }
}

