/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db.exceptions;

import java.sql.SQLException;
import org.apache.empire.commons.ErrorType;
import org.apache.empire.db.DBDatabaseDriver;
import org.apache.empire.db.DBObject;
import org.apache.empire.exceptions.EmpireException;

public class EmpireSQLException
extends EmpireException {
    private static final long serialVersionUID = 1L;
    public static final ErrorType errorType = new ErrorType("error.db.sqlException", "The database operation failed. Native error is: {0}");
    private final String nativeErrorMessage;

    protected static String messageFromSQLException(DBDatabaseDriver driver, SQLException sqle) {
        return driver != null ? driver.extractErrorMessage(sqle) : sqle.getMessage();
    }

    protected static DBDatabaseDriver driverFromObject(DBObject obj) {
        return obj.getDatabase() != null ? obj.getDatabase().getDriver() : (DBDatabaseDriver)null;
    }

    public EmpireSQLException(DBDatabaseDriver driver, SQLException cause) {
        super(errorType, new String[]{EmpireSQLException.messageFromSQLException(driver, cause)}, cause);
        this.nativeErrorMessage = this.getErrorParams()[0];
    }

    public EmpireSQLException(DBObject obj, SQLException cause) {
        this(EmpireSQLException.driverFromObject(obj), cause);
    }

    protected EmpireSQLException(ErrorType type, String[] params, int nativeErrorIndex, SQLException cause) {
        super(type, params, cause);
        this.nativeErrorMessage = this.getErrorParams()[nativeErrorIndex];
    }

    public String getNativeErrorMessage() {
        return this.nativeErrorMessage;
    }
}

