/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db;

import java.math.BigDecimal;
import java.sql.Connection;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.empire.commons.Attributes;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.commons.Options;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.Column;
import org.apache.empire.data.DataMode;
import org.apache.empire.data.DataType;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.DBCommandExpr;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBDatabaseDriver;
import org.apache.empire.db.DBIndex;
import org.apache.empire.db.DBRelation;
import org.apache.empire.db.DBTable;
import org.apache.empire.db.exceptions.FieldIllegalValueException;
import org.apache.empire.db.exceptions.FieldNotNullException;
import org.apache.empire.db.exceptions.FieldValueOutOfRangeException;
import org.apache.empire.db.exceptions.FieldValueTooLongException;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.exceptions.NotSupportedException;
import org.apache.empire.exceptions.PropertyReadOnlyException;
import org.apache.empire.xml.XMLUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class DBTableColumn
extends DBColumn {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(DBTableColumn.class);
    protected DataType type;
    protected double size;
    protected boolean required;
    protected boolean autoGenerated;
    protected boolean readOnly;
    protected Object defaultValue;
    protected int decimalScale = 0;

    public DBTableColumn(DBTable table, DataType type, String name, double size, boolean required, boolean autoGenerated, Object defValue) {
        super(table, name);
        this.type = type;
        this.required = required;
        this.autoGenerated = autoGenerated;
        this.readOnly = autoGenerated;
        this.defaultValue = defValue;
        this.attributes = new Attributes();
        this.options = null;
        this.setSize(size);
    }

    @Deprecated
    public DBTableColumn(DBTable table, DataType type, String name, double size, DataMode dataMode, Object defValue) {
        this(table, type, name, size, dataMode != DataMode.Nullable, dataMode == DataMode.AutoGenerated, defValue);
    }

    protected DBTableColumn(DBTable newTable, DBTableColumn other) {
        super(newTable, other.name);
        this.type = other.type;
        this.size = other.size;
        this.required = other.required;
        this.autoGenerated = other.autoGenerated;
        this.readOnly = other.readOnly;
        this.defaultValue = other.defaultValue;
        this.attributes = new Attributes();
        this.attributes.addAll(other.attributes);
        this.options = other.options;
        if (newTable != null) {
            newTable.addColumn(this);
        }
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Object defValue) {
        this.defaultValue = defValue;
    }

    public Object getRecordDefaultValue(Connection conn) {
        if (this.rowset == null) {
            return this.defaultValue;
        }
        DBDatabase db = this.rowset.getDatabase();
        if (this.isAutoGenerated()) {
            if (conn == null) {
                return null;
            }
            DBDatabaseDriver driver = db.getDriver();
            return driver.getColumnAutoValue(db, this, conn);
        }
        return this.defaultValue;
    }

    @Override
    public DataType getDataType() {
        return this.type;
    }

    @Override
    public double getSize() {
        return this.size;
    }

    public void setSize(double size) {
        if (size < 0.0) {
            if (!this.getDataType().isText()) {
                throw new InvalidArgumentException("size", size);
            }
            this.setAttribute("singleByteChars", Boolean.TRUE);
            size = Math.abs(size);
        } else if (this.attributes != null && this.attributes.contains("singleByteChars")) {
            this.attributes.remove("singleByteChars");
        }
        this.size = size;
        if (this.getDataType() == DataType.DECIMAL) {
            int reqPrec = (int)size;
            this.decimalScale = (int)(size * 10.0) - reqPrec * 10;
        }
    }

    public int getDecimalScale() {
        return this.decimalScale;
    }

    public void setDecimalScale(int scale) {
        if (this.getDataType() != DataType.DECIMAL) {
            throw new NotSupportedException(this, "setDecimalScale");
        }
        this.decimalScale = scale;
    }

    @Override
    public boolean isRequired() {
        return this.required;
    }

    @Override
    public boolean isAutoGenerated() {
        return this.autoGenerated;
    }

    public boolean isSingleByteChars() {
        if (this.attributes == null || !this.attributes.contains("singleByteChars")) {
            return false;
        }
        return ObjectUtils.getBoolean(this.attributes.get("singleByteChars"));
    }

    public void setSingleByteChars(boolean singleByteChars) {
        if (!this.getDataType().isText()) {
            throw new NotSupportedException(this, "setSingleByteChars");
        }
        this.setAttribute("singleByteChars", singleByteChars);
    }

    public void setRequired(boolean required) {
        if (this.isAutoGenerated()) {
            throw new PropertyReadOnlyException("required");
        }
        this.required = required;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public void setEnumOptions(Class<?> enumType) {
        log.debug("Adding enum options of type {} for column {}.", (Object)enumType.getName(), (Object)this.getName());
        this.options = new Options(enumType);
        this.setAttribute("enumType", enumType);
    }

    @Override
    public Object validate(Object value) {
        if (ObjectUtils.isEmpty(value)) {
            if (this.isRequired()) {
                throw new FieldNotNullException(this);
            }
            return null;
        }
        if (value instanceof DBColumnExpr) {
            DataType funcType = ((DBColumnExpr)value).getDataType();
            if (!this.type.isCompatible(funcType)) {
                log.info("Incompatible data types in expression for column {} using function {}!", (Object)this.getName(), (Object)value.toString());
                throw new FieldIllegalValueException(this, String.valueOf(value));
            }
            return value;
        }
        if (value instanceof DBCommandExpr) {
            DBColumnExpr[] exprList = ((DBCommandExpr)value).getSelectExprList();
            if (exprList.length != 1) {
                log.info("Invalid command expression for column {} using command {}!", (Object)this.getName(), (Object)((DBCommandExpr)value).getSelect());
                throw new FieldIllegalValueException(this, ((DBCommandExpr)value).getSelect());
            }
            if (!this.type.isCompatible(exprList[0].getDataType())) {
                log.info("Incompatible data types in expression for column {} using function {}!", (Object)this.getName(), (Object)value.toString());
                throw new FieldIllegalValueException(this, String.valueOf(value));
            }
            return value;
        }
        switch (this.type) {
            case DATE: 
            case DATETIME: 
            case TIMESTAMP: {
                if (value instanceof Date || DBDatabase.SYSDATE.equals(value)) break;
                String dateValue = value.toString();
                if (dateValue.length() == 0) {
                    return null;
                }
                String datePattern = StringUtils.coalesce(StringUtils.toString(this.getAttribute("dateTimePattern")), "yyyy-MM-dd HH:mm:ss");
                if ((this.type == DataType.DATE || dateValue.length() <= 12) && datePattern.indexOf(32) > 0) {
                    datePattern = datePattern.substring(0, datePattern.indexOf(32));
                }
                try {
                    SimpleDateFormat sdFormat = new SimpleDateFormat(datePattern);
                    sdFormat.setLenient(true);
                    value = sdFormat.parse(dateValue);
                    break;
                }
                catch (ParseException e) {
                    log.info("Parsing '{}' to Date (" + datePattern + ") failed for column {}. Message is " + e.toString(), value, (Object)this.getName());
                    throw new FieldIllegalValueException((Column)this, String.valueOf(value), (Throwable)e);
                }
            }
            case DECIMAL: {
                if (value.getClass().isEnum()) {
                    value = ((Enum)value).ordinal();
                }
                if (!(value instanceof Number)) {
                    try {
                        value = ObjectUtils.toDecimal(value);
                    }
                    catch (NumberFormatException e) {
                        log.info("Parsing '{}' to Decimal failed for column {}. Message is " + e.toString(), value, (Object)this.getName());
                        throw new FieldIllegalValueException((Column)this, String.valueOf(value), (Throwable)e);
                    }
                }
                this.validateNumber(this.type, (Number)value);
                break;
            }
            case FLOAT: {
                if (!(value instanceof Number)) {
                    try {
                        value = ObjectUtils.toDouble(value);
                    }
                    catch (NumberFormatException e) {
                        log.info("Parsing '{}' to Double failed for column {}. Message is " + e.toString(), value, (Object)this.getName());
                        throw new FieldIllegalValueException((Column)this, String.valueOf(value), (Throwable)e);
                    }
                }
                this.validateNumber(this.type, (Number)value);
                break;
            }
            case INTEGER: {
                if (value.getClass().isEnum()) {
                    value = ((Enum)value).ordinal();
                }
                if (!(value instanceof Number)) {
                    try {
                        value = ObjectUtils.toLong(value);
                    }
                    catch (NumberFormatException e) {
                        log.info("Parsing '{}' to Integer failed for column {}. Message is " + e.toString(), value, (Object)this.getName());
                        throw new FieldIllegalValueException((Column)this, String.valueOf(value), (Throwable)e);
                    }
                }
                this.validateNumber(this.type, (Number)value);
                break;
            }
            case TEXT: 
            case VARCHAR: 
            case CHAR: {
                if (value.getClass().isEnum()) {
                    value = ((Enum)value).name();
                }
                if (!((double)value.toString().length() > this.size)) break;
                throw new FieldValueTooLongException(this);
            }
            default: {
                if (!log.isDebugEnabled()) break;
                log.debug("No column validation has been implemented for data type " + (Object)((Object)this.type));
            }
        }
        return value;
    }

    protected void validateNumber(DataType type, Number n) {
        int reqScale;
        double size;
        int reqPrec;
        int scale;
        BigDecimal dv;
        int prec;
        long minVal;
        Object min = this.getAttribute("minValue");
        Object max = this.getAttribute("maxValue");
        if (min != null && max != null) {
            minVal = ObjectUtils.getLong(min);
            long maxVal = ObjectUtils.getLong(max);
            if (n.longValue() < minVal || n.longValue() > maxVal) {
                throw new FieldValueOutOfRangeException((Column)this, (Number)minVal, maxVal);
            }
        } else if (min != null) {
            minVal = ObjectUtils.getLong(min);
            if (n.longValue() < minVal) {
                throw new FieldValueOutOfRangeException((Column)this, (Number)minVal, false);
            }
        } else if (max != null) {
            long maxVal = ObjectUtils.getLong(max);
            if (n.longValue() > maxVal) {
                throw new FieldValueOutOfRangeException((Column)this, (Number)maxVal, true);
            }
        }
        if (type == DataType.DECIMAL && ((prec = (dv = ObjectUtils.toDecimal(n)).precision()) - (scale = dv.scale()) > (reqPrec = (int)(size = this.getSize())) - (reqScale = this.getDecimalScale()) || scale > reqScale)) {
            throw new FieldValueOutOfRangeException(this);
        }
    }

    public DBRelation.DBReference referenceOn(DBTableColumn target) {
        return new DBRelation.DBReference(this, target);
    }

    @Override
    public Element addXml(Element parent, long flags) {
        int keyIndex;
        Element elem = XMLUtil.addElement(parent, "column");
        elem.setAttribute("name", this.name);
        DBIndex primaryKey = ((DBTable)this.rowset).getPrimaryKey();
        if (primaryKey != null && (keyIndex = ((DBTable)this.rowset).getPrimaryKey().getColumnPos(this)) >= 0) {
            elem.setAttribute("key", String.valueOf(keyIndex + 1));
        }
        if (this.size > 0.0) {
            elem.setAttribute("size", String.valueOf((int)this.size));
            if (this.getDataType() == DataType.DECIMAL) {
                elem.setAttribute("decimals", String.valueOf((int)(this.size * 10.0) % 10));
            }
        }
        if (this.isRequired()) {
            elem.setAttribute("mandatory", String.valueOf(Boolean.TRUE));
        }
        if (this.attributes != null) {
            this.attributes.addXml(elem, flags);
        }
        if (this.options != null) {
            this.options.addXml(elem, flags);
        }
        return elem;
    }

    public String getSequenceName() {
        Object defValue = this.getDefaultValue();
        String seqName = defValue != null ? defValue.toString() : (this.rowset != null ? this.rowset.getName() + "." + this.name : this.name);
        return seqName;
    }
}

