/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db;

import java.lang.reflect.Field;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.empire.commons.Options;
import org.apache.empire.data.DataMode;
import org.apache.empire.data.DataType;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBCommand;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBDatabaseDriver;
import org.apache.empire.db.DBIndex;
import org.apache.empire.db.DBRecord;
import org.apache.empire.db.DBRelation;
import org.apache.empire.db.DBRowSet;
import org.apache.empire.db.DBTableColumn;
import org.apache.empire.db.exceptions.NoPrimaryKeyException;
import org.apache.empire.db.exceptions.RecordDeleteFailedException;
import org.apache.empire.db.exceptions.RecordUpdateInvalidException;
import org.apache.empire.db.expr.compare.DBCompareExpr;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.exceptions.ItemExistsException;
import org.apache.empire.exceptions.UnexpectedReturnValueException;

public class DBTable
extends DBRowSet
implements Cloneable {
    public static final int DEFAULT = 0;
    public static final int SMALLINT = 2;
    public static final int MEDIUMINT = 4;
    public static final int BIGINT = 8;
    private static final long serialVersionUID = 1L;
    private static AtomicInteger tableCount = new AtomicInteger(0);
    private final String name;
    private String alias;
    private final List<DBIndex> indexes = new ArrayList<DBIndex>();
    private Boolean quoteName = null;
    private DBRelation.DBCascadeAction cascadeDeleteAction = DBRelation.DBCascadeAction.NONE;

    public DBTable(String name, DBDatabase db, String alias) {
        super(db);
        if (alias == null) {
            alias = "t" + String.valueOf(tableCount.incrementAndGet());
        }
        this.name = name;
        this.alias = alias;
        if (db != null) {
            db.addTable(this);
        }
    }

    public DBTable(String name, DBDatabase db) {
        this(name, db, null);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    @Override
    public boolean isUpdateable() {
        return true;
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            DBTable clone = (DBTable)super.clone();
            Class<?> colClass = ((DBColumn)this.columns.get(0)).getClass();
            Class<?> colBase = colClass.getSuperclass();
            clone.columns = new ArrayList();
            Field[] fields = this.getClass().getFields();
            for (int i = 0; i < this.columns.size(); ++i) {
                DBTableColumn srcCol = (DBTableColumn)this.columns.get(i);
                DBTableColumn newCol = new DBTableColumn(clone, srcCol);
                for (int j = 0; j < fields.length; ++j) {
                    Class<?> type = fields[j].getType();
                    if (type != colClass && type != colBase) continue;
                    try {
                        if (fields[j].get(clone) != srcCol) continue;
                        fields[j].set(clone, newCol);
                        continue;
                    }
                    catch (Exception e) {
                        String fieldName = fields[j].getName();
                        log.error("Cannot adjust declared table field: " + fieldName + ". Reason is: " + e.getMessage());
                        CloneNotSupportedException cnse = new CloneNotSupportedException("Unable to replace field reference for field " + fieldName);
                        cnse.initCause(e);
                        throw cnse;
                    }
                }
            }
            clone.alias = "t" + String.valueOf(tableCount.incrementAndGet());
            log.info("clone: Table " + this.name + " cloned! Alias old=" + this.alias + " new=" + clone.alias);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            log.error("Unable to clone table " + this.getName());
            throw new RuntimeException(e);
        }
    }

    protected void addColumn(DBTableColumn column) {
        if (column == null || column.getRowSet() != this) {
            throw new InvalidArgumentException("column", column);
        }
        if (this.getColumn(column.getName()) != null) {
            throw new ItemExistsException((Object)column.getName());
        }
        this.columns.add(column);
    }

    protected DBTableColumn crateAndAppendColumn(String columnName, DataType type, double size, boolean required, Object defValue) {
        boolean autoGenerated = type == DataType.AUTOINC || type == DataType.UNIQUEID;
        DBTableColumn column = new DBTableColumn(this, type, columnName, size, required, autoGenerated, defValue);
        this.addColumn(column);
        if (column.getDataType() == DataType.AUTOINC) {
            if (this.primaryKey == null) {
                this.setPrimaryKey(column);
            } else {
                log.warn("Table {} already has a Primary-Key! DataType of column {} should be INTEGER.", (Object)this.getName(), (Object)column.getName());
            }
        }
        if (column.getDataType() == DataType.TIMESTAMP) {
            if (this.timestampColumn == null) {
                this.setTimestampColumn(column);
            } else {
                log.warn("Table {} already has a Timestamp column. DataType of column {} should be DATETIME.", (Object)this.getName(), (Object)column.getName());
            }
        }
        return column;
    }

    @Deprecated
    public final DBTableColumn addColumn(String columnName, DataType type, double size, DataMode dataMode, Object defValue) {
        return this.addColumn(columnName, type, size, dataMode != DataMode.Nullable, defValue);
    }

    @Deprecated
    public final DBTableColumn addColumn(String columnName, DataType type, double size, DataMode dataMode) {
        return this.addColumn(columnName, type, size, dataMode != DataMode.Nullable);
    }

    public final DBTableColumn addColumn(String columnName, DataType type, double size, boolean required, Object defValue) {
        if (defValue instanceof Class) {
            log.warn("Column {}: a class object of type \"{}\" has been passed as default value. Please check!", (Object)columnName, (Object)((Class)defValue).getName());
        }
        return this.crateAndAppendColumn(columnName, type, size, required, defValue);
    }

    public final DBTableColumn addColumn(String columnName, DataType type, double size, boolean required) {
        return this.crateAndAppendColumn(columnName, type, size, required, null);
    }

    public final DBTableColumn addColumn(String columnName, DataType type, double size, boolean required, Options options) {
        DBTableColumn col = this.crateAndAppendColumn(columnName, type, size, required, null);
        col.setOptions(options);
        return col;
    }

    public final DBTableColumn addColumn(String columnName, DataType type, double size, boolean required, Options options, Object defValue) {
        if (defValue != null && !options.contains(defValue)) {
            throw new InvalidArgumentException("devValue", defValue);
        }
        DBTableColumn col = this.crateAndAppendColumn(columnName, type, size, required, defValue);
        col.setOptions(options);
        return col;
    }

    public final DBTableColumn addColumn(String columnName, DataType type, double size, boolean required, Class<?> enumType) {
        if (!enumType.isEnum()) {
            throw new InvalidArgumentException("enumType", enumType);
        }
        DBTableColumn col = this.crateAndAppendColumn(columnName, type, size, required, null);
        col.setEnumOptions(enumType);
        return col;
    }

    public final DBTableColumn addColumn(String columnName, DataType type, double size, boolean required, Enum<?> enumValue) {
        Object defValue = type.isNumeric() ? Integer.valueOf(enumValue.ordinal()) : enumValue.name();
        DBTableColumn col = this.crateAndAppendColumn(columnName, type, size, required, defValue);
        col.setEnumOptions(enumValue.getClass());
        return col;
    }

    public DBIndex getPrimaryKey() {
        return this.primaryKey;
    }

    public List<DBIndex> getIndexes() {
        return Collections.unmodifiableList(this.indexes);
    }

    public void setPrimaryKey(DBColumn ... columns) {
        if (columns == null) {
            throw new InvalidArgumentException("columns", columns);
        }
        for (int i = 0; i < columns.length; ++i) {
            if (columns[i].getRowSet() == this) continue;
            throw new InvalidArgumentException("columns[" + String.valueOf(i) + "]", columns[i].getFullName());
        }
        if (this.primaryKey != null) {
            if (this.primaryKey.compareColumns(columns)) {
                return;
            }
            this.removeIndex(this.primaryKey);
        }
        if (columns.length > 0) {
            this.primaryKey = new DBIndex(this.name + "_PK", DBIndex.DBIndexType.PRIMARY_KEY, columns);
            this.addIndex(this.primaryKey);
        } else {
            this.primaryKey = null;
        }
    }

    public DBIndex addIndex(DBIndex index) {
        if (index == null) {
            throw new InvalidArgumentException("index", null);
        }
        String name = index.getName();
        for (DBIndex i : this.indexes) {
            if (i != index && !name.equalsIgnoreCase(i.getName())) continue;
            throw new ItemExistsException((Object)name);
        }
        this.indexes.add(index);
        index.setTable(this);
        return index;
    }

    public final DBIndex addIndex(String name, DBIndex.DBIndexType type, DBColumn ... columns) {
        if (name == null || columns == null || columns.length == 0) {
            throw new InvalidArgumentException("name|columns", null);
        }
        if (type == DBIndex.DBIndexType.PRIMARY_KEY && this.primaryKey != null) {
            throw new InvalidArgumentException("type", DBIndex.DBIndexType.PRIMARY_KEY.name());
        }
        DBIndex index = new DBIndex(name, type, columns);
        this.addIndex(index);
        return index;
    }

    public final DBIndex addIndex(String name, boolean unique, DBColumn ... columns) {
        return this.addIndex(name, unique ? DBIndex.DBIndexType.UNIQUE : DBIndex.DBIndexType.STANDARD, columns);
    }

    public void removeIndex(DBIndex index) {
        if (index.getTable() != this || !this.indexes.contains(index)) {
            throw new InvalidArgumentException("index", index);
        }
        this.indexes.remove(index);
        index.setTable(null);
    }

    public DBTableColumn addTimestampColumn(String columnName) {
        DBTableColumn col = this.addColumn(columnName, DataType.TIMESTAMP, 0.0, true, (Object)DBDatabase.SYSDATE);
        if (this.timestampColumn != col) {
            this.setTimestampColumn(col);
        }
        return col;
    }

    @Override
    public void addSQL(StringBuilder buf, long context) {
        if ((context & 1L | 2L) != 0L) {
            DBDatabaseDriver driver = this.getDatabase().getDriver();
            if (this.quoteName == null) {
                this.quoteName = driver.detectQuoteName(this.name);
            }
            this.db.appendQualifiedName(buf, this.name, this.quoteName);
        }
        if ((context & 8L) != 0L && this.alias != null) {
            buf.append(this.getRenameTablePhrase());
            buf.append(this.getAlias());
        }
    }

    @Override
    public void createRecord(DBRecord rec, Connection conn) {
        this.prepareInitRecord(rec, null, true);
        int count = this.columns.size();
        for (int i = 0; i < count; ++i) {
            DBTableColumn column = (DBTableColumn)this.columns.get(i);
            Object value = column.getRecordDefaultValue(conn);
            if (value == null) continue;
            rec.modifyValue(i, value, true);
        }
        this.completeInitRecord(rec);
    }

    public DBIndex checkUniqueConstraints(DBRecord rec, Connection conn) {
        for (DBIndex idx : this.getIndexes()) {
            if (idx.getType() == DBIndex.DBIndexType.PRIMARY_KEY ? !rec.isNew() : !idx.getType().isUnique() || !rec.isNew() && !rec.wasAnyModified(idx.getColumns())) continue;
            DBCommand cmd = this.db.createCommand();
            cmd.select(this.count());
            for (DBColumn c : idx.getColumns()) {
                Object value = rec.getValue(c);
                cmd.where((DBCompareExpr)c.is(value));
            }
            int count = this.db.querySingleInt(cmd, conn);
            if (count <= 0) continue;
            return idx;
        }
        return null;
    }

    public DBRelation.DBCascadeAction getDefaultCascadeDeleteAction() {
        return this.cascadeDeleteAction;
    }

    public void setDefaultCascadeDeleteAction(DBRelation.DBCascadeAction cascadeDeleteAction) {
        this.cascadeDeleteAction = cascadeDeleteAction;
    }

    public Object[] key(Object ... keyValues) {
        if (keyValues == null || keyValues.length == 0) {
            throw new InvalidArgumentException("keyValues", keyValues);
        }
        if (this.primaryKey != null && keyValues.length != this.primaryKey.getColumnCount()) {
            throw new InvalidArgumentException("keyValues:length", keyValues.length);
        }
        return keyValues;
    }

    @Override
    public void deleteRecord(Object[] key, Connection conn) {
        if (this.primaryKey == null) {
            throw new NoPrimaryKeyException(this);
        }
        DBColumn[] keyColumns = this.primaryKey.getColumns();
        if (key == null || key.length != keyColumns.length) {
            throw new InvalidArgumentException("key", key);
        }
        this.deleteAllReferences(key, conn);
        DBCommand cmd = this.db.createCommand();
        this.setKeyConstraints(cmd, key);
        String sqlCmd = cmd.getDelete(this);
        int affected = this.db.executeSQL(sqlCmd, cmd.getParamValues(), conn);
        if (affected < 0) {
            throw new UnexpectedReturnValueException(affected, "db.executeSQL()");
        }
        if (affected == 0) {
            throw new RecordDeleteFailedException(this, key);
        }
        if (affected > 1) {
            throw new RecordUpdateInvalidException(this, key);
        }
    }

    public List<DBRelation> getForeignKeyRelations() {
        ArrayList<DBRelation> relations = new ArrayList<DBRelation>();
        for (DBRelation r : this.getDatabase().getRelations()) {
            if (!this.equals(r.getForeignKeyTable())) continue;
            relations.add(r);
        }
        return Collections.unmodifiableList(relations);
    }
}

