/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.empire.db.DBCommand;
import org.apache.empire.db.DBDatabaseDriver;
import org.apache.empire.db.DBTable;
import org.apache.empire.db.exceptions.EmpireSQLException;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBSQLScript
implements Iterable<String> {
    private static final Logger log = LoggerFactory.getLogger(DBSQLScript.class);
    private static final String DEFAULT_COMMAND_SEPARATOR = ";\r\n\r\n";
    protected String commandSeparator = ";\r\n\r\n";
    protected ArrayList<SQLStmt> sqlStmtList = new ArrayList();

    public DBSQLScript() {
    }

    public DBSQLScript(String commandSeparator) {
        this.commandSeparator = commandSeparator;
    }

    public void addStmt(String sql) {
        this.sqlStmtList.add(new SQLStmt(sql, null));
    }

    public void addStmt(String sql, Object[] params) {
        this.sqlStmtList.add(new SQLStmt(sql, params));
    }

    public final void addStmt(StringBuilder sql) {
        this.addStmt(sql.toString());
        sql.setLength(0);
    }

    public void addInsert(DBCommand cmd) {
        if (cmd == null) {
            throw new InvalidArgumentException("cmd", cmd);
        }
        this.addStmt(cmd.getInsert(), cmd.getParamValues());
    }

    public void addUpdate(DBCommand cmd) {
        if (cmd == null) {
            throw new InvalidArgumentException("cmd", cmd);
        }
        this.addStmt(cmd.getUpdate(), cmd.getParamValues());
    }

    public void addDelete(DBCommand cmd, DBTable table) {
        if (cmd == null) {
            throw new InvalidArgumentException("cmd", cmd);
        }
        this.addStmt(cmd.getDelete(table), cmd.getParamValues());
    }

    public int getCount() {
        return this.sqlStmtList.size();
    }

    public String getStmt(int i) {
        if (i < 0 || i >= this.sqlStmtList.size()) {
            throw new InvalidArgumentException("index", i);
        }
        return this.sqlStmtList.get(i).getCmd();
    }

    public Object[] getStmtParams(int i) {
        if (i < 0 || i >= this.sqlStmtList.size()) {
            throw new InvalidArgumentException("index", i);
        }
        return this.sqlStmtList.get(i).getParams();
    }

    public void insertStmt(int i, String stmt, Object[] params) {
        if (stmt == null) {
            throw new InvalidArgumentException("stmt", stmt);
        }
        if (i < 0 || i > this.sqlStmtList.size()) {
            throw new InvalidArgumentException("index", i);
        }
        this.sqlStmtList.add(i, new SQLStmt(stmt, params));
    }

    public final void insertStmt(int i, String stmt) {
        this.insertStmt(i, stmt, null);
    }

    public void replaceStmt(int i, String cmd, Object[] params) {
        if (cmd == null) {
            throw new InvalidArgumentException("cmd", cmd);
        }
        if (i < 0 || i >= this.sqlStmtList.size()) {
            throw new InvalidArgumentException("index", i);
        }
        SQLStmt stmt = this.sqlStmtList.get(i);
        stmt.setCmd(cmd);
        stmt.setParams(params);
    }

    public final void replaceStmt(int i, String cmd) {
        this.replaceStmt(i, cmd, null);
    }

    public void removeStmt(int i) {
        if (i < 0 || i >= this.sqlStmtList.size()) {
            throw new InvalidArgumentException("index", i);
        }
        this.sqlStmtList.remove(i);
    }

    public void clear() {
        this.sqlStmtList.clear();
    }

    public int executeAll(DBDatabaseDriver driver, Connection conn, boolean ignoreErrors) {
        log.debug("Running script containing " + String.valueOf(this.getCount()) + " statements.");
        int result = 0;
        for (SQLStmt stmt : this.sqlStmtList) {
            try {
                log.debug("Executing: {}", (Object)stmt.getCmd());
                int count = driver.executeSQL(stmt.getCmd(), stmt.getParams(), conn, null);
                result += count >= 0 ? count : 0;
            }
            catch (SQLException e) {
                log.error(e.toString(), (Throwable)e);
                if (!ignoreErrors) {
                    throw new EmpireSQLException(driver, e);
                }
                log.debug("Ignoring error. Continuing with script...");
            }
        }
        log.debug("Script completed. {} records affected.", (Object)result);
        return result;
    }

    public final int executeAll(DBDatabaseDriver driver, Connection conn) {
        return this.executeAll(driver, conn, false);
    }

    public int executeBatch(DBDatabaseDriver driver, Connection conn) {
        log.debug("Running batch containing " + String.valueOf(this.getCount()) + " statements.");
        try {
            int count = this.sqlStmtList.size();
            String[] cmdList = new String[count];
            Object[][] paramList = null;
            int i = 0;
            for (SQLStmt stmt : this.sqlStmtList) {
                cmdList[i] = stmt.getCmd();
                if (stmt.getParams() != null) {
                    if (paramList == null) {
                        paramList = new Object[count][];
                    }
                    paramList[i] = stmt.getParams();
                }
                ++i;
            }
            int[] res = driver.executeBatch(cmdList, paramList, conn);
            count = 0;
            for (i = 0; i < (res != null ? res.length : 0); ++i) {
                count += res[i] >= 0 ? res[i] : 0;
            }
            log.debug("Script completed. {} records affected.", (Object)count);
            return count;
        }
        catch (SQLException e) {
            log.error(e.toString(), (Throwable)e);
            throw new EmpireSQLException(driver, e);
        }
    }

    @Override
    public Iterator<String> iterator() {
        return new SQLStmtIterator(this.sqlStmtList.iterator());
    }

    public String toString() {
        StringBuilder script = new StringBuilder();
        for (SQLStmt stmt : this.sqlStmtList) {
            script.append(stmt.getCmd());
            script.append(this.commandSeparator);
        }
        return script.toString();
    }

    private static class SQLStmtIterator
    implements Iterator<String> {
        private final Iterator<SQLStmt> iterator;

        private SQLStmtIterator(Iterator<SQLStmt> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public String next() {
            return this.iterator.next().getCmd();
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }

    protected static class SQLStmt {
        private String cmd;
        private Object[] params;

        public SQLStmt(String cmd, Object[] params) {
            this.cmd = cmd;
            this.params = params;
        }

        public String getCmd() {
            return this.cmd;
        }

        public void setCmd(String cmd) {
            this.cmd = cmd;
        }

        public Object[] getParams() {
            return this.params;
        }

        public void setParams(Object[] params) {
            this.params = params;
        }
    }
}

