/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db;

import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.commons.Options;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.Column;
import org.apache.empire.data.ColumnExpr;
import org.apache.empire.data.Record;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.DBCommand;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBRecordData;
import org.apache.empire.db.DBRowSet;
import org.apache.empire.db.DBTableColumn;
import org.apache.empire.db.DBXmlDictionary;
import org.apache.empire.db.exceptions.FieldIsReadOnlyException;
import org.apache.empire.db.exceptions.FieldValueNotFetchedException;
import org.apache.empire.db.expr.compare.DBCompareExpr;
import org.apache.empire.exceptions.BeanPropertyGetException;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.exceptions.ObjectNotValidException;
import org.apache.empire.xml.XMLUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DBRecord
extends DBRecordData
implements Record,
Cloneable {
    private static final long serialVersionUID = 1L;
    protected static final Logger log = LoggerFactory.getLogger(DBRecord.class);
    private State state = State.Invalid;
    private DBRowSet rowset = null;
    private Object[] fields = null;
    private boolean[] modified = null;
    private boolean validateFieldValues = true;
    private Object rowsetData = null;

    public DBRecord() {
    }

    public DBRecord(DBRowSet initialRowset) {
        this();
        this.rowset = initialRowset;
    }

    protected void initData(DBRowSet rowset, Object rowSetData, boolean newRecord) {
        boolean rowsetChanged;
        boolean bl = rowsetChanged = this.rowset != rowset;
        if (rowsetChanged) {
            this.fields = null;
        }
        this.rowset = rowset;
        if (rowset != null) {
            int colCount = rowset.getColumns().size();
            if (this.fields == null || this.fields.length != colCount) {
                this.fields = new Object[colCount];
            } else {
                for (int i = 0; i < this.fields.length; ++i) {
                    this.fields[i] = null;
                }
            }
        }
        this.rowsetData = rowSetData;
        this.modified = null;
        this.changeState(rowset == null ? State.Invalid : (newRecord ? State.New : State.Valid));
        if (rowsetChanged) {
            this.onRowSetChanged();
        }
    }

    protected void changeState(State newState) {
        this.state = newState;
    }

    protected Object[] getFields() {
        return this.fields;
    }

    @Override
    public void close() {
        this.fields = null;
        this.modified = null;
        this.rowsetData = null;
        if (this.state != State.Invalid) {
            this.changeState(State.Invalid);
        }
    }

    public DBRecord clone() {
        try {
            DBRecord rec = (DBRecord)super.clone();
            rec.rowset = this.rowset;
            rec.state = this.state;
            if (rec.fields == this.fields && this.fields != null) {
                rec.fields = (Object[])this.fields.clone();
            }
            if (rec.modified == this.modified && this.modified != null) {
                rec.modified = (boolean[])this.modified.clone();
            }
            rec.rowsetData = this.rowsetData;
            rec.validateFieldValues = this.validateFieldValues;
            return rec;
        }
        catch (CloneNotSupportedException e) {
            log.error("Unable to clone record.", (Throwable)e);
            return null;
        }
    }

    @Override
    public DBDatabase getDatabase() {
        return this.rowset != null ? this.rowset.db : null;
    }

    public DBRowSet getRowSet() {
        return this.rowset;
    }

    public Object getRowSetData() {
        return this.rowsetData;
    }

    public State getState() {
        return this.state;
    }

    @Override
    public boolean isValid() {
        return this.state != State.Invalid;
    }

    @Override
    public boolean isReadOnly() {
        if (!this.isValid()) {
            return true;
        }
        DBRowSet rowset = this.getRowSet();
        return rowset == null || !rowset.isUpdateable();
    }

    @Override
    public boolean isModified() {
        return this.state.isEqualOrMore(State.Modified);
    }

    @Override
    public boolean isNew() {
        return this.state == State.New;
    }

    public boolean isExists() {
        return this.state == State.Valid || this.state == State.Modified;
    }

    @Override
    public int getFieldCount() {
        return this.fields != null ? this.fields.length : 0;
    }

    @Override
    public int getFieldIndex(ColumnExpr column) {
        DBColumnExpr expr = (DBColumnExpr)column;
        return this.rowset != null ? this.rowset.getColumnIndex(expr.getUpdateColumn()) : -1;
    }

    @Override
    public int getFieldIndex(String column) {
        if (this.rowset != null) {
            List<DBColumn> columns = this.rowset.getColumns();
            for (int i = 0; i < columns.size(); ++i) {
                DBColumn col = columns.get(i);
                if (!col.getName().equalsIgnoreCase(column)) continue;
                return i;
            }
        }
        return -1;
    }

    public DBColumn getDBColumn(int index) {
        return this.rowset != null ? this.rowset.getColumn(index) : null;
    }

    @Override
    public final Column getColumn(int index) {
        return this.getDBColumn(index);
    }

    @Override
    public final ColumnExpr getColumnExpr(int index) {
        return this.getDBColumn(index);
    }

    protected boolean isColumn(int index, DBColumn ... column) {
        if (index < 0 || index >= this.fields.length) {
            throw new InvalidArgumentException("index", index);
        }
        if (column == null) {
            throw new InvalidArgumentException("column", column);
        }
        Column col = this.getColumn(index);
        for (int i = 0; i < column.length; ++i) {
            if (col != column[i]) continue;
            return true;
        }
        return false;
    }

    public boolean wasModified(int index) {
        if (!this.isValid()) {
            throw new ObjectNotValidException(this);
        }
        if (index < 0 || index >= this.fields.length) {
            throw new InvalidArgumentException("index", index);
        }
        if (this.modified == null) {
            return false;
        }
        return this.modified[index];
    }

    @Override
    public final boolean wasModified(Column column) {
        return this.wasModified(this.getFieldIndex(column));
    }

    public final boolean wasAnyModified(Column ... columns) {
        for (Column c : columns) {
            if (!this.wasModified(this.getFieldIndex(c))) continue;
            return true;
        }
        return false;
    }

    public void setModified(DBColumn column, boolean isModified) {
        int index;
        if (this.state == State.Invalid) {
            throw new ObjectNotValidException(this);
        }
        if (this.modified == null) {
            this.modified = new boolean[this.fields.length];
            for (int j = 0; j < this.fields.length; ++j) {
                this.modified[j] = false;
            }
        }
        if ((index = this.getFieldIndex(column)) >= 0) {
            this.modified[index] = isModified;
        }
        if (this.state.isLess(State.Modified) && isModified) {
            this.changeState(State.Modified);
        }
        if (this.state == State.Modified && !isModified) {
            boolean recordNotModified = true;
            for (int j = 0; j < this.fields.length; ++j) {
                if (!this.modified[j]) continue;
                recordNotModified = false;
            }
            if (recordNotModified) {
                this.changeState(State.Valid);
            }
        }
    }

    @Override
    public Column[] getKeyColumns() {
        return this.rowset.getKeyColumns();
    }

    public Object[] getKeyValues() {
        return this.rowset != null ? this.rowset.getRecordKey(this) : null;
    }

    @Override
    public Object getValue(int index) {
        if (this.fields == null) {
            throw new ObjectNotValidException(this);
        }
        if (index < 0 || index >= this.fields.length) {
            throw new InvalidArgumentException("index", index);
        }
        if (this.fields[index] == ObjectUtils.NO_VALUE) {
            throw new FieldValueNotFetchedException(this.getColumn(index));
        }
        return this.fields[index];
    }

    public boolean isValueValid(int index) {
        if (this.fields == null) {
            throw new ObjectNotValidException(this);
        }
        if (index < 0 || index >= this.fields.length) {
            throw new InvalidArgumentException("index", index);
        }
        return this.fields[index] != ObjectUtils.NO_VALUE;
    }

    public Options getFieldOptions(DBColumn column) {
        return column.getOptions();
    }

    @Override
    public final Options getFieldOptions(Column column) {
        return this.getFieldOptions((DBColumn)column);
    }

    protected void modifyValue(int index, Object value, boolean fireChangeEvent) {
        if (this.state == State.Invalid) {
            throw new ObjectNotValidException(this);
        }
        if (index < 0 || index >= this.fields.length) {
            throw new InvalidArgumentException("index", index);
        }
        if (this.modified == null) {
            this.modified = new boolean[this.fields.length];
            for (int j = 0; j < this.fields.length; ++j) {
                this.modified[j] = false;
            }
        }
        this.fields[index] = value;
        this.modified[index] = true;
        if (this.state.isLess(State.Modified)) {
            this.changeState(State.Modified);
        }
        if (fireChangeEvent) {
            this.onFieldChanged(index);
        }
    }

    public void validateAllValues() {
        if (!this.isValid()) {
            throw new ObjectNotValidException(this);
        }
        if (this.modified == null) {
            return;
        }
        for (int index = 0; index < this.fields.length; ++index) {
            DBColumn column;
            if (!this.modified[index] || this.fields[index] == ObjectUtils.NO_VALUE || (column = this.rowset.getColumn(index)).isAutoGenerated()) continue;
            this.fields[index] = this.validateValue(column, this.fields[index]);
        }
    }

    @Override
    public void setValue(int index, Object value) {
        Object current;
        if (this.state == State.Invalid) {
            throw new ObjectNotValidException(this);
        }
        if (index < 0 || index >= this.fields.length) {
            throw new InvalidArgumentException("index", index);
        }
        if (value instanceof String && ((String)value).length() == 0) {
            value = null;
        }
        if ((current = this.fields[index]) == ObjectUtils.NO_VALUE) {
            throw new FieldValueNotFetchedException(this.getColumn(index));
        }
        DBColumn column = this.rowset.getColumn(index);
        if (value != null && value.getClass().isEnum()) {
            Enum enumVal = (Enum)value;
            boolean numeric = column.getDataType().isNumeric();
            Object object = value = numeric ? Integer.valueOf(enumVal.ordinal()) : enumVal.name();
        }
        if (ObjectUtils.compareEqual(current, value)) {
            return;
        }
        if (!this.allowFieldChange(column)) {
            throw new FieldIsReadOnlyException(column);
        }
        if (this.validateFieldValues) {
            value = this.validateValue(column, value);
        }
        this.modifyValue(index, value, true);
    }

    @Override
    public final void setValue(Column column, Object value) {
        if (!this.isValid()) {
            throw new ObjectNotValidException(this);
        }
        this.setValue(this.getFieldIndex(column), value);
    }

    protected boolean allowFieldChange(DBColumn column) {
        if (!(!column.isAutoGenerated() || this.isNew() && this.isNull(column))) {
            return false;
        }
        return this.isNew() || !this.rowset.isKeyColumn(column);
    }

    @Override
    public Object validateValue(Column column, Object value) {
        return column.validate(value);
    }

    public boolean isValidateFieldValues() {
        return this.validateFieldValues;
    }

    public void setValidateFieldValues(boolean validateFieldValues) {
        this.validateFieldValues = validateFieldValues;
    }

    @Override
    public boolean isFieldVisible(Column column) {
        if (this.rowset == null) {
            return false;
        }
        int index = this.rowset.getColumnIndex(column);
        if (index < 0) {
            log.warn("Column {} does not exist for record of {}", (Object)column.getName(), (Object)this.rowset.getName());
        }
        return index >= 0 && this.isValueValid(index);
    }

    @Override
    public boolean isFieldReadOnly(Column column) {
        if (this.rowset == null) {
            throw new ObjectNotValidException(this);
        }
        if (this.getFieldIndex(column) < 0) {
            throw new InvalidArgumentException("column", column);
        }
        if (this.isValid() && !this.isNew() && this.rowset.isKeyColumn((DBColumn)column)) {
            return true;
        }
        return this.rowset.isColumnReadOnly((DBColumn)column);
    }

    @Override
    public boolean isFieldRequired(Column column) {
        if (this.rowset == null) {
            throw new ObjectNotValidException(this);
        }
        if (this.rowset.getColumnIndex(column) < 0) {
            throw new InvalidArgumentException("column", column);
        }
        return column.isRequired();
    }

    public void init(DBRowSet table, Object[] keyValues, boolean insert) {
        if (table != null) {
            table.initRecord(this, keyValues, insert);
        } else {
            this.initData(null, null, false);
        }
    }

    public void create(DBRowSet table, Connection conn) {
        if (table == null) {
            throw new InvalidArgumentException("table", table);
        }
        table.createRecord(this, conn);
    }

    public final void create(DBRowSet table) {
        this.create(table, null);
    }

    public void read(DBRowSet table, Object[] key, Connection conn) {
        if (table == null) {
            throw new InvalidArgumentException("table", table);
        }
        table.readRecord(this, key, conn);
    }

    public final void read(DBRowSet table, Object id, Connection conn) {
        if (id instanceof Collection) {
            this.read(table, ((Collection)id).toArray(), conn);
        }
        this.read(table, new Object[]{id}, conn);
    }

    public void read(DBRowSet table, DBCompareExpr whereConstraints, Connection conn) {
        if (whereConstraints == null) {
            throw new InvalidArgumentException("whereConstraints", null);
        }
        HashSet<DBColumn> columns = new HashSet<DBColumn>();
        whereConstraints.addReferencedColumns(columns);
        for (DBColumn c : columns) {
            if (table.equals(c.getRowSet())) continue;
            throw new InvalidArgumentException("whereConstraints", c.getFullName());
        }
        DBCommand cmd = table.getDatabase().createCommand();
        cmd.select(table.getColumns());
        cmd.where(whereConstraints);
        table.readRecord(this, cmd, conn);
    }

    public void update(Connection conn) {
        if (!this.isValid()) {
            throw new ObjectNotValidException(this);
        }
        if (!this.isModified()) {
            return;
        }
        this.rowset.updateRecord(this, conn);
    }

    protected void updateComplete(Object rowSetData) {
        this.rowsetData = rowSetData;
        this.modified = null;
        this.changeState(State.Valid);
    }

    public void delete(Connection conn) {
        if (!this.isValid()) {
            throw new ObjectNotValidException(this);
        }
        if (!this.isNew()) {
            Object[] keys = this.rowset.getRecordKey(this);
            this.rowset.deleteRecord(keys, conn);
        }
        this.close();
    }

    @Override
    public int addColumnDesc(Element parent) {
        if (!this.isValid()) {
            throw new ObjectNotValidException(this);
        }
        int count = 0;
        List<DBColumn> columns = this.rowset.getColumns();
        for (int i = 0; i < columns.size(); ++i) {
            DBColumn column = columns.get(i);
            if (!this.isFieldVisible(column)) continue;
            column.addXml(parent, 0L);
            ++count;
        }
        return count;
    }

    @Override
    public int addRowValues(Element parent) {
        if (!this.isValid()) {
            throw new ObjectNotValidException(this);
        }
        DBColumn[] keyColumns = this.rowset.getKeyColumns();
        if (keyColumns != null && keyColumns.length > 0) {
            if (keyColumns.length > 1) {
                StringBuilder buf = new StringBuilder();
                for (int i = 0; i < keyColumns.length; ++i) {
                    if (i > 0) {
                        buf.append("/");
                    }
                    buf.append(this.getString(keyColumns[i]));
                }
                parent.setAttribute("id", buf.toString());
            } else {
                parent.setAttribute("id", this.getString(keyColumns[0]));
            }
        }
        if (this.isNew()) {
            parent.setAttribute("new", "1");
        }
        int count = 0;
        List<DBColumn> columns = this.rowset.getColumns();
        for (int i = 0; i < this.fields.length; ++i) {
            DBColumn column = columns.get(i);
            if (!this.isFieldVisible(column)) continue;
            String name = column.getName();
            if (this.fields[i] != null) {
                XMLUtil.addElement(parent, name, this.getString(i));
            } else {
                XMLUtil.addElement(parent, name).setAttribute("null", "yes");
            }
            ++count;
        }
        return count;
    }

    protected DBXmlDictionary getXmlDictionary() {
        return DBXmlDictionary.getInstance();
    }

    @Override
    public Document getXmlDocument() {
        if (!this.isValid()) {
            throw new ObjectNotValidException(this);
        }
        DBXmlDictionary xmlDic = this.getXmlDictionary();
        Element root = XMLUtil.createDocument(xmlDic.getRowSetElementName());
        if (this.rowset.getName() != null) {
            root.setAttribute("name", this.rowset.getName());
        }
        if (this.addColumnDesc(root) > 0) {
            this.addRowValues(XMLUtil.addElement(root, xmlDic.getRowElementName()));
        }
        return root.getOwnerDocument();
    }

    public int fillMissingDefaults(Connection conn) {
        int count = 0;
        for (int i = 0; i < this.fields.length; ++i) {
            DBTableColumn col;
            Object value;
            if (this.fields[i] != ObjectUtils.NO_VALUE || (value = (col = (DBTableColumn)this.rowset.getColumn(i)).getRecordDefaultValue(conn)) == null) continue;
            this.modifyValue(i, value, true);
            ++count;
        }
        return count;
    }

    protected void setRecordValue(Column column, Object bean, String property) {
        if (StringUtils.isEmpty(property)) {
            property = column.getBeanPropertyName();
        }
        try {
            PropertyUtilsBean pub = BeanUtilsBean.getInstance().getPropertyUtils();
            Object value = pub.getSimpleProperty(bean, property);
            this.setValue(column, value);
        }
        catch (IllegalAccessException e) {
            log.error(bean.getClass().getName() + ": unable to get property '" + property + "'");
            throw new BeanPropertyGetException(bean, property, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            log.error(bean.getClass().getName() + ": unable to get property '" + property + "'");
            throw new BeanPropertyGetException(bean, property, (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            log.warn(bean.getClass().getName() + ": no getter available for property '" + property + "'");
            throw new BeanPropertyGetException(bean, property, (Throwable)e);
        }
    }

    @Override
    public int setRecordValues(Object bean, Collection<Column> ignoreList) {
        int count = 0;
        for (int i = 0; i < this.getFieldCount(); ++i) {
            DBColumn column = this.getDBColumn(i);
            if (column.isReadOnly() || ignoreList != null && ignoreList.contains(column)) continue;
            String property = column.getBeanPropertyName();
            this.setRecordValue(column, bean, property);
            ++count;
        }
        return count;
    }

    @Override
    public final int setRecordValues(Object bean) {
        return this.setRecordValues(bean, null);
    }

    protected void onRowSetChanged() {
        if (log.isTraceEnabled() && this.rowset != null) {
            log.trace("Record has been attached to rowset " + this.rowset.getName());
        }
    }

    protected void onRecordChanged() {
        if (log.isTraceEnabled() && this.isValid()) {
            log.trace("Record has been changed");
        }
    }

    protected void onFieldChanged(int i) {
        if (log.isDebugEnabled()) {
            log.debug("Record field " + this.rowset.getColumn(i).getName() + " changed to " + String.valueOf(this.fields[i]));
        }
    }

    public static enum State {
        Invalid,
        Valid,
        Modified,
        New;


        boolean isLess(State other) {
            return this.ordinal() < other.ordinal();
        }

        boolean isEqualOrMore(State other) {
            return this.ordinal() >= other.ordinal();
        }
    }
}

