/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db;

import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.commons.Options;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.DataType;
import org.apache.empire.db.DBCmdParam;
import org.apache.empire.db.DBCmdType;
import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.DBCommand;
import org.apache.empire.db.DBDatabaseDriver;
import org.apache.empire.db.DBObject;
import org.apache.empire.db.DBRelation;
import org.apache.empire.db.DBRowSet;
import org.apache.empire.db.DBSQLScript;
import org.apache.empire.db.DBTable;
import org.apache.empire.db.DBView;
import org.apache.empire.db.exceptions.ConstraintViolationException;
import org.apache.empire.db.exceptions.DatabaseNotOpenException;
import org.apache.empire.db.exceptions.EmpireSQLException;
import org.apache.empire.db.exceptions.QueryFailedException;
import org.apache.empire.db.exceptions.QueryNoResultException;
import org.apache.empire.db.exceptions.StatementFailedException;
import org.apache.empire.db.expr.column.DBCaseWhenExpr;
import org.apache.empire.db.expr.column.DBValueExpr;
import org.apache.empire.db.expr.compare.DBCompareExpr;
import org.apache.empire.exceptions.InternalException;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.exceptions.ItemExistsException;
import org.apache.empire.exceptions.MiscellaneousErrorException;
import org.apache.empire.exceptions.PropertyReadOnlyException;
import org.apache.empire.exceptions.UnexpectedReturnValueException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DBDatabase
extends DBObject {
    private static final long serialVersionUID = 1L;
    protected long longRunndingStmtThreshold = 30000L;
    public static final DBSystemDate SYSDATE = new DBSystemDate();
    public static final String EMPTY_STRING = "\u0000";
    private static final Logger log = LoggerFactory.getLogger(DBDatabase.class);
    private static Map<String, WeakReference<DBDatabase>> databaseMap = new LinkedHashMap<String, WeakReference<DBDatabase>>();
    protected String schema = null;
    protected String linkName = null;
    protected List<DBTable> tables = new ArrayList<DBTable>();
    protected List<DBRelation> relations = new ArrayList<DBRelation>();
    protected List<DBView> views = new ArrayList<DBView>();
    protected DBDatabaseDriver driver = null;
    protected String instanceId;
    private boolean preparedStatementsEnabled = false;

    public static synchronized DBDatabase findById(String dbIdent) {
        WeakReference<DBDatabase> ref = databaseMap.get(dbIdent);
        if (ref == null) {
            return null;
        }
        DBDatabase db = (DBDatabase)ref.get();
        if (db == null) {
            log.warn("Database width id='{}' habe been destroyed!", (Object)dbIdent);
            databaseMap.remove(dbIdent);
        }
        return db;
    }

    public static synchronized DBDatabase findByClass(Class<? extends DBDatabase> cls) {
        for (WeakReference<DBDatabase> ref : databaseMap.values()) {
            DBDatabase db = (DBDatabase)ref.get();
            if (db == null || !cls.isInstance(db)) continue;
            return db;
        }
        log.warn("Database of class {} not found!", (Object)cls.getSimpleName());
        return null;
    }

    public DBDatabase(String schema, String linkName) {
        this.schema = schema;
        this.linkName = linkName;
        this.register(this.getClass().getSimpleName());
    }

    public DBDatabase(String schema) {
        this(schema, null);
    }

    public DBDatabase() {
        this(null, null);
    }

    public synchronized void destroy() {
        if (this.isOpen()) {
            throw new MiscellaneousErrorException("Database is open. Destroy not possible.");
        }
        databaseMap.remove(this.instanceId);
        this.instanceId = null;
        this.schema = null;
        this.linkName = null;
        this.tables.clear();
        this.relations.clear();
        this.views.clear();
    }

    protected synchronized void register(String dbid) {
        HashSet<String> invalidKeys = new HashSet<String>();
        for (Map.Entry<String, WeakReference<DBDatabase>> e : databaseMap.entrySet()) {
            DBDatabase dbInst = (DBDatabase)e.getValue().get();
            if (dbInst == this) {
                log.error("Instance of database " + this.getClass().getName() + " already registered. Not registering same instance twice!");
                throw new ItemExistsException((Object)e.getKey());
            }
            if (dbInst != null) continue;
            invalidKeys.add(e.getKey());
        }
        for (String key : invalidKeys) {
            databaseMap.remove(key);
        }
        invalidKeys.clear();
        if (DBDatabase.findById(dbid) != null) {
            int maxInstId = 1;
            String instPrefix = dbid + ":";
            for (String key : databaseMap.keySet()) {
                int instId;
                if (databaseMap.get(key).get() == null) {
                    log.warn("Database width id='{}' habe been destroyed!", (Object)key);
                    continue;
                }
                if (!key.startsWith(instPrefix) || (instId = Integer.parseInt(key.substring(instPrefix.length()))) <= maxInstId) continue;
                maxInstId = instId;
            }
            this.instanceId = dbid + ":" + String.valueOf(maxInstId + 1);
        } else {
            this.instanceId = dbid;
        }
        log.info("Instance of database {} registered with instanceid={}", (Object)this.getClass().getName(), (Object)this.instanceId);
        databaseMap.put(this.instanceId, new WeakReference<DBDatabase>(this));
    }

    protected String getDefaultId() {
        return this.getClass().getSimpleName();
    }

    public String getId() {
        return this.instanceId;
    }

    public DBDatabaseDriver getDriver() {
        return this.driver;
    }

    public boolean isPreparedStatementsEnabled() {
        return this.preparedStatementsEnabled;
    }

    public void setPreparedStatementsEnabled(boolean preparedStatementsEnabled) {
        this.preparedStatementsEnabled = preparedStatementsEnabled;
        log.info("PreparedStatementsEnabled is " + preparedStatementsEnabled);
    }

    public void open(DBDatabaseDriver driver, Connection conn) {
        if (this.isOpen()) {
            this.close(conn);
        }
        driver.attachDatabase(this, conn);
        this.driver = driver;
    }

    public void close(Connection conn) {
        if (this.driver != null) {
            this.driver.detachDatabase(this, conn);
        }
        this.driver = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void getCreateDDLScript(DBDatabaseDriver driver, DBSQLScript script) {
        DBDatabaseDriver prevDriver = this.driver;
        try {
            if (this.driver != null && this.driver != driver && driver != null) {
                throw new MiscellaneousErrorException("The database is attached to a different driver.");
            }
            if (this.driver == null) {
                this.driver = driver;
            }
            this.generateDDLScript(script);
        }
        finally {
            this.driver = prevDriver;
        }
    }

    protected void generateDDLScript(DBSQLScript script) {
        this.driver.getDDLScript(DBCmdType.CREATE, this, script);
    }

    @Override
    public DBDatabase getDatabase() {
        return this;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        if (this.driver != null) {
            throw new PropertyReadOnlyException("schema");
        }
        this.schema = schema;
    }

    public String getSchemaPrefix() {
        if (this.schema == null) {
            return "";
        }
        return this.schema + ".";
    }

    public String getLinkName() {
        return this.linkName;
    }

    public void setLinkName(String linkName) {
        if (this.driver != null) {
            throw new PropertyReadOnlyException(linkName);
        }
        this.linkName = linkName;
    }

    @Deprecated
    public String getQualifiedName(String name) {
        StringBuilder buf = new StringBuilder();
        boolean quoteName = this.driver != null ? this.driver.detectQuoteName(name) : false;
        this.appendQualifiedName(buf, name, quoteName);
        return buf.toString();
    }

    public void appendQualifiedName(StringBuilder buf, String name, boolean quoteName) {
        if (this.driver == null) {
            log.warn("No driver attached for appending qualified name {0}.", (Object)name);
            buf.append(name);
            return;
        }
        if (this.schema != null) {
            buf.append(this.schema);
            buf.append(".");
        }
        this.driver.appendElementName(buf, name, quoteName);
        if (this.linkName != null) {
            buf.append(this.driver.getSQLPhrase(5));
            buf.append(this.linkName);
        }
    }

    public DBValueExpr getSystemDateExpr() {
        return new DBValueExpr(this, SYSDATE, DataType.DATETIME);
    }

    public DBValueExpr getValueExpr(String value) {
        return new DBValueExpr(this, value, DataType.VARCHAR);
    }

    public DBValueExpr getValueExpr(boolean value) {
        return new DBValueExpr(this, value, DataType.BOOL);
    }

    public DBValueExpr getValueExpr(int value) {
        return new DBValueExpr(this, value, DataType.INTEGER);
    }

    public DBValueExpr getValueExpr(long value) {
        return new DBValueExpr(this, value, DataType.INTEGER);
    }

    public DBValueExpr getValueExpr(Object value, DataType dataType) {
        return new DBValueExpr(this, value, dataType);
    }

    public DBValueExpr getParamExpr(DBCmdParam param) {
        return new DBValueExpr(this, param, param.getDataType());
    }

    public DBValueExpr getNullExpr() {
        return new DBValueExpr(this, null, DataType.UNKNOWN);
    }

    protected void addTable(DBTable table) {
        if (table == null || table.getDatabase() != this) {
            throw new InvalidArgumentException("table", table);
        }
        if (this.tables.contains(table)) {
            throw new ItemExistsException((Object)table.getName());
        }
        DBTable existing = this.getTable(table.getName());
        if (existing != null) {
            if (existing.getClass().equals(table.getClass())) {
                return;
            }
            throw new ItemExistsException((Object)table.getName());
        }
        this.tables.add(table);
    }

    public List<DBTable> getTables() {
        return Collections.unmodifiableList(this.tables);
    }

    public DBRowSet getRowSet(String name) {
        DBRowSet rset = this.getTable(name);
        if (rset == null) {
            rset = this.getView(name);
        }
        return rset;
    }

    public DBTable getTable(String name) {
        for (int i = 0; i < this.tables.size(); ++i) {
            DBTable tab = this.tables.get(i);
            if (!tab.getName().equalsIgnoreCase(name)) continue;
            return tab;
        }
        return null;
    }

    public final DBRelation addRelation(DBRelation.DBReference reference) {
        String table = reference.getSourceColumn().getRowSet().getName();
        String col1 = reference.getSourceColumn().getName();
        String name = table.substring(0, Math.min(table.length(), 14)) + "_" + col1.substring(0, Math.min(col1.length(), 12)) + "_FK";
        return this.addRelation(name, reference);
    }

    public final DBRelation addRelation(DBRelation.DBReference ref1, DBRelation.DBReference ref2) {
        String table = ref1.getSourceColumn().getRowSet().getName();
        String col1 = ref1.getSourceColumn().getName();
        String col2 = ref2.getSourceColumn().getName();
        String name = table.substring(0, Math.min(table.length(), 9)) + "_" + col1.substring(0, Math.min(col1.length(), 9)) + "_" + col2.substring(0, Math.min(col2.length(), 9)) + "_FK";
        return this.addRelation(name, ref1, ref2);
    }

    public DBRelation addRelation(String name, DBRelation.DBReference ... references) {
        if (this.getRelation(name) != null) {
            throw new ItemExistsException((Object)name);
        }
        DBTable targetTable = (DBTable)references[0].getTargetColumn().getRowSet();
        DBRelation.DBCascadeAction deleteAction = targetTable.getDefaultCascadeDeleteAction();
        DBRelation relation = new DBRelation(this, name, references, deleteAction);
        if (this.relations.contains(relation)) {
            throw new ItemExistsException((Object)name);
        }
        for (DBRelation.DBReference ref : references) {
            DBRowSet rset = ref.getSourceColumn().getRowSet();
            rset.addColumnReference(ref.getSourceColumn(), ref.getTargetColumn());
        }
        this.relations.add(relation);
        return relation;
    }

    public void removeRelation(DBRelation relation) {
        if (relation == null || relation.getDatabase() != this) {
            throw new InvalidArgumentException("relation", relation);
        }
        this.relations.remove(relation);
    }

    public List<DBRelation> getRelations() {
        return Collections.unmodifiableList(this.relations);
    }

    public DBRelation getRelation(String relationName) {
        for (DBRelation r : this.relations) {
            String name = r.getName();
            if (relationName.compareToIgnoreCase(name) != 0) continue;
            return r;
        }
        return null;
    }

    protected void addView(DBView view) {
        if (view == null || view.getDatabase() != this) {
            throw new InvalidArgumentException("view", view);
        }
        if (this.views.contains(view)) {
            throw new ItemExistsException((Object)view.getName());
        }
        this.views.add(view);
    }

    public List<DBView> getViews() {
        return Collections.unmodifiableList(this.views);
    }

    public DBView getView(String name) {
        for (int i = 0; i < this.views.size(); ++i) {
            DBView view = this.views.get(i);
            if (!view.getName().equalsIgnoreCase(name)) continue;
            return view;
        }
        return null;
    }

    public boolean isOpen() {
        return this.driver != null;
    }

    protected void checkOpen() {
        if (!this.isOpen()) {
            throw new DatabaseNotOpenException(this);
        }
    }

    public DBCommand createCommand() {
        this.checkOpen();
        return this.driver.createCommand(this);
    }

    public Timestamp getUpdateTimestamp(Connection conn) {
        this.checkOpen();
        return this.driver.getUpdateTimestamp(conn);
    }

    public Object getNextSequenceValue(String seqName, Connection conn) {
        this.checkOpen();
        return this.driver.getNextSequenceValue(this, seqName, 1, conn);
    }

    public Object querySingleValue(String sqlCmd, Object[] sqlParams, DataType dataType, Connection conn) {
        long start;
        ResultSet rs;
        block10: {
            this.checkOpen();
            rs = null;
            start = System.currentTimeMillis();
            if (log.isDebugEnabled()) {
                log.debug("Executing: " + sqlCmd);
            }
            if ((rs = this.driver.executeQuery(sqlCmd, sqlParams, false, conn)) == null) {
                throw new UnexpectedReturnValueException(rs, "driver.executeQuery()");
            }
            if (rs.next()) break block10;
            log.debug("querySingleValue returned no result");
            ObjectUtils.NoValue noValue = ObjectUtils.NO_VALUE;
            this.closeResultSet(rs);
            return noValue;
        }
        try {
            Object result = this.driver.getResultValue(rs, 1, dataType);
            long queryTime = System.currentTimeMillis() - start;
            if (log.isDebugEnabled()) {
                log.debug("querySingleValue successful in {} ms. Result value={}.", (Object)queryTime, result);
            } else if (queryTime >= this.longRunndingStmtThreshold) {
                log.warn("Long running query took {} seconds for statement {}.", (Object)(queryTime / 1000L), (Object)sqlCmd);
            }
            Object object = result;
            this.closeResultSet(rs);
            return object;
        }
        catch (SQLException sqle) {
            try {
                throw new QueryFailedException(this, sqlCmd, sqle);
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                throw throwable;
            }
        }
    }

    public final Object querySingleValue(String sqlCmd, Object[] sqlParams, Connection conn) {
        Object value = this.querySingleValue(sqlCmd, sqlParams, DataType.UNKNOWN, conn);
        if (value == ObjectUtils.NO_VALUE) {
            throw new QueryNoResultException(sqlCmd);
        }
        return value;
    }

    public final Object querySingleValue(DBCommand cmd, DataType dataType, Connection conn) {
        Object value = this.querySingleValue(cmd.getSelect(), cmd.getParamValues(), dataType, conn);
        if (value == ObjectUtils.NO_VALUE) {
            throw new QueryNoResultException(cmd.getSelect());
        }
        return value;
    }

    public final Object querySingleValue(DBCommand cmd, Connection conn) {
        return this.querySingleValue(cmd, DataType.UNKNOWN, conn);
    }

    public final int querySingleInt(String sqlCmd, Object[] sqlParams, int defaultValue, Connection conn) {
        Object value = this.querySingleValue(sqlCmd, sqlParams, DataType.INTEGER, conn);
        return ObjectUtils.getInteger(value, defaultValue);
    }

    public final int querySingleInt(DBCommand cmd, int defaultValue, Connection conn) {
        return this.querySingleInt(cmd.getSelect(), cmd.getParamValues(), defaultValue, conn);
    }

    public final int querySingleInt(DBCommand cmd, Connection conn) {
        Object value = this.querySingleValue(cmd.getSelect(), cmd.getParamValues(), DataType.INTEGER, conn);
        if (ObjectUtils.isEmpty(value)) {
            throw new QueryNoResultException(cmd.getSelect());
        }
        return ObjectUtils.getInteger(value);
    }

    public final long querySingleLong(String sqlCmd, Object[] sqlParams, long defaultValue, Connection conn) {
        Object value = this.querySingleValue(sqlCmd, sqlParams, DataType.INTEGER, conn);
        return ObjectUtils.getLong(value, defaultValue);
    }

    public final long querySingleLong(DBCommand cmd, long defaultValue, Connection conn) {
        return this.querySingleLong(cmd.getSelect(), cmd.getParamValues(), defaultValue, conn);
    }

    public final long querySingleLong(DBCommand cmd, Connection conn) {
        Object value = this.querySingleValue(cmd.getSelect(), cmd.getParamValues(), DataType.INTEGER, conn);
        if (ObjectUtils.isEmpty(value)) {
            throw new QueryNoResultException(cmd.getSelect());
        }
        return ObjectUtils.getLong(value);
    }

    public final String querySingleString(String sqlCmd, Object[] sqlParams, String defaultValue, Connection conn) {
        Object value = this.querySingleValue(sqlCmd, sqlParams, DataType.VARCHAR, conn);
        return ObjectUtils.isEmpty(value) ? defaultValue : value.toString();
    }

    public final String querySingleString(DBCommand cmd, String defaultValue, Connection conn) {
        return this.querySingleString(cmd.getSelect(), cmd.getParamValues(), defaultValue, conn);
    }

    public final String querySingleString(DBCommand cmd, Connection conn) {
        Object value = this.querySingleValue(cmd.getSelect(), cmd.getParamValues(), DataType.VARCHAR, conn);
        if (value == ObjectUtils.NO_VALUE) {
            throw new QueryNoResultException(cmd.getSelect());
        }
        return StringUtils.toString(value, "");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> int querySimpleList(Class<T> c, String sqlCmd, Object[] sqlParams, DataType dataType, Connection conn, Collection<T> result, int maxRows) {
        int n;
        this.checkOpen();
        ResultSet rs = null;
        try {
            int count;
            long start = System.currentTimeMillis();
            if (log.isDebugEnabled()) {
                log.debug("Executing: " + sqlCmd);
            }
            if ((rs = this.driver.executeQuery(sqlCmd, sqlParams, false, conn)) == null) {
                throw new UnexpectedReturnValueException(rs, "driver.executeQuery()");
            }
            for (count = 0; rs.next() && (maxRows < 0 || count < maxRows); ++count) {
                T item = ObjectUtils.convert(c, this.driver.getResultValue(rs, 1, dataType));
                result.add(item);
            }
            long queryTime = System.currentTimeMillis() - start;
            if (log.isDebugEnabled()) {
                log.debug("querySimpleList retured {} items in {} ms.", (Object)count, (Object)queryTime);
            } else if (queryTime >= this.longRunndingStmtThreshold) {
                log.warn("Long running query took {} seconds for statement {}.", (Object)(queryTime / 1000L), (Object)sqlCmd);
            }
            n = count;
        }
        catch (ClassCastException e) {
            try {
                log.error("querySingleValue cast exception: ", (Throwable)e);
                throw new InternalException(e);
                catch (SQLException sqle) {
                    throw new QueryFailedException(this, sqlCmd, sqle);
                }
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                throw throwable;
            }
        }
        this.closeResultSet(rs);
        return n;
    }

    public final <T> int querySimpleList(Class<T> c, DBCommand cmd, Connection conn, Collection<T> result) {
        return this.querySimpleList(c, cmd.getSelect(), cmd.getParamValues(), DataType.UNKNOWN, conn, result, -1);
    }

    public final <T> List<T> querySimpleList(Class<T> c, DBCommand cmd, Connection conn) {
        ArrayList result = new ArrayList();
        if (this.querySimpleList(c, cmd, conn, result) < 0) {
            return null;
        }
        return result;
    }

    public final List<Object> querySimpleList(DBCommand cmd, Connection conn) {
        return this.querySimpleList(Object.class, cmd, conn);
    }

    public int queryOptionList(String sqlCmd, Object[] sqlParams, Connection conn, Options result) {
        this.checkOpen();
        ResultSet rs = null;
        try {
            long start = System.currentTimeMillis();
            if (log.isDebugEnabled()) {
                log.debug("Executing: " + sqlCmd);
            }
            if ((rs = this.driver.executeQuery(sqlCmd, sqlParams, false, conn)) == null) {
                throw new UnexpectedReturnValueException(rs, "driver.executeQuery()");
            }
            if (rs.getMetaData().getColumnCount() < 2) {
                throw new InvalidArgumentException("sqlCmd", sqlCmd);
            }
            int count = 0;
            while (rs.next()) {
                Object value = rs.getObject(1);
                String text = rs.getString(2);
                result.add(value, text, true);
                ++count;
            }
            long queryTime = System.currentTimeMillis() - start;
            if (log.isDebugEnabled()) {
                log.debug("queryOptionList retured {} items in {} ms.", (Object)count, (Object)queryTime);
            } else if (queryTime >= this.longRunndingStmtThreshold) {
                log.warn("Long running query took {} seconds for statement {}.", (Object)(queryTime / 1000L), (Object)sqlCmd);
            }
            int n = count;
            this.closeResultSet(rs);
            return n;
        }
        catch (SQLException sqle) {
            try {
                throw new QueryFailedException(this, sqlCmd, sqle);
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                throw throwable;
            }
        }
    }

    public final int queryOptionList(DBCommand cmd, Connection conn, Options result) {
        return this.queryOptionList(cmd.getSelect(), cmd.getParamValues(), conn, result);
    }

    public final Options queryOptionList(DBCommand cmd, Connection conn) {
        Options options = new Options();
        this.queryOptionList(cmd.getSelect(), cmd.getParamValues(), conn, options);
        return options;
    }

    public int queryObjectList(String sqlCmd, Object[] sqlParams, Connection conn, Collection<Object[]> result, int maxRows) {
        this.checkOpen();
        ResultSet rs = null;
        try {
            int count;
            long start = System.currentTimeMillis();
            if (log.isDebugEnabled()) {
                log.debug("Executing: " + sqlCmd);
            }
            if ((rs = this.driver.executeQuery(sqlCmd, sqlParams, false, conn)) == null) {
                throw new UnexpectedReturnValueException(rs, "driver.executeQuery()");
            }
            int colCount = rs.getMetaData().getColumnCount();
            for (count = 0; rs.next() && (maxRows < 0 || count < maxRows); ++count) {
                Object[] item = new Object[colCount];
                for (int i = 0; i < colCount; ++i) {
                    item[i] = this.driver.getResultValue(rs, i + 1, DataType.UNKNOWN);
                }
                result.add(item);
            }
            long queryTime = System.currentTimeMillis() - start;
            if (log.isDebugEnabled()) {
                log.debug("queryObjectList retured {} items in {} ms.", (Object)count, (Object)queryTime);
            } else if (queryTime >= this.longRunndingStmtThreshold) {
                log.warn("Long running query took {} seconds for statement {}.", (Object)(queryTime / 1000L), (Object)sqlCmd);
            }
            int n = count;
            this.closeResultSet(rs);
            return n;
        }
        catch (SQLException sqle) {
            try {
                throw new QueryFailedException(this, sqlCmd, sqle);
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                throw throwable;
            }
        }
    }

    public final int queryObjectList(DBCommand cmd, Connection conn, Collection<Object[]> result) {
        return this.queryObjectList(cmd.getSelect(), cmd.getParamValues(), conn, result, -1);
    }

    public final List<Object[]> queryObjectList(DBCommand cmd, Connection conn) {
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        this.queryObjectList(cmd.getSelect(), cmd.getParamValues(), conn, result, -1);
        return result;
    }

    public Object[] querySingleRow(String sqlCmd, Object[] sqlParams, Connection conn) {
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        this.queryObjectList(sqlCmd, sqlParams, conn, result, 1);
        if (result.size() < 1) {
            throw new QueryNoResultException(sqlCmd);
        }
        return (Object[])result.get(0);
    }

    public final Object[] querySingleRow(DBCommand cmd, Connection conn) {
        return this.querySingleRow(cmd.getSelect(), cmd.getParamValues(), conn);
    }

    public int executeSQL(String sqlCmd, Object[] sqlParams, Connection conn, DBDatabaseDriver.DBSetGenKeys setGenKeys) {
        this.checkOpen();
        try {
            if (conn == null) {
                throw new InvalidArgumentException("conn", conn);
            }
            if (log.isInfoEnabled()) {
                log.info("Executing: " + sqlCmd);
            }
            long start = System.currentTimeMillis();
            int affected = this.driver.executeSQL(sqlCmd, sqlParams, conn, setGenKeys);
            if (affected < 0) {
                throw new UnexpectedReturnValueException(affected, "driver.executeSQL()");
            }
            long execTime = System.currentTimeMillis() - start;
            if (log.isInfoEnabled()) {
                log.info("executeSQL affected {} Records in {} ms ", (Object)affected, (Object)execTime);
            } else if (execTime >= this.longRunndingStmtThreshold) {
                log.warn("Long running statement took {} seconds for statement {}.", (Object)(execTime / 1000L), (Object)sqlCmd);
            }
            return affected;
        }
        catch (SQLIntegrityConstraintViolationException sqle) {
            throw new ConstraintViolationException(this, sqlCmd, sqle);
        }
        catch (SQLException sqle) {
            throw new StatementFailedException(this, sqlCmd, sqle);
        }
    }

    public final int executeSQL(String sqlCmd, Object[] sqlParams, Connection conn) {
        return this.executeSQL(sqlCmd, sqlParams, conn, null);
    }

    @Deprecated
    public final int executeSQL(String sqlCmd, Connection conn) {
        if (this.isPreparedStatementsEnabled() && sqlCmd.indexOf("?") > 0) {
            log.warn("Command params may be missing for prepared statement. Please supply params by calling executeSQL with cmd.getParamValues()!");
        }
        return this.executeSQL(sqlCmd, null, conn);
    }

    public final int executeInsert(DBCommand cmd, Connection conn) {
        return this.executeSQL(cmd.getInsert(), cmd.getParamValues(), conn);
    }

    public final int executeInsertInto(DBTable table, DBCommand cmd, Connection conn) {
        return this.executeSQL(cmd.getInsertInto(table), cmd.getParamValues(), conn);
    }

    public final int executeUpdate(DBCommand cmd, Connection conn) {
        return this.executeSQL(cmd.getUpdate(), cmd.getParamValues(), conn);
    }

    public final int executeDelete(DBTable from, DBCommand cmd, Connection conn) {
        return this.executeSQL(cmd.getDelete(from), cmd.getParamValues(), conn);
    }

    public ResultSet executeQuery(String sqlCmd, Object[] sqlParams, boolean scrollable, Connection conn) {
        this.checkOpen();
        try {
            if (conn == null) {
                throw new InvalidArgumentException("conn", conn);
            }
            if (log.isDebugEnabled()) {
                log.debug("Executing: " + sqlCmd);
            }
            long start = System.currentTimeMillis();
            ResultSet rs = this.driver.executeQuery(sqlCmd, sqlParams, scrollable, conn);
            if (rs == null) {
                throw new UnexpectedReturnValueException(rs, "driver.executeQuery()");
            }
            long queryTime = System.currentTimeMillis() - start;
            if (log.isDebugEnabled()) {
                log.debug("executeQuery successful in {} ms", (Object)queryTime);
            } else if (queryTime >= this.longRunndingStmtThreshold) {
                log.warn("Long running query took {} seconds for statement {}.", (Object)(queryTime / 1000L), (Object)sqlCmd);
            }
            return rs;
        }
        catch (SQLException sqle) {
            throw new QueryFailedException(this, sqlCmd, sqle);
        }
    }

    public void commit(Connection conn) {
        try {
            if (conn == null) {
                throw new InvalidArgumentException("conn", conn);
            }
            if (!conn.getAutoCommit()) {
                conn.commit();
            }
            return;
        }
        catch (SQLException sqle) {
            throw new EmpireSQLException(this, sqle);
        }
    }

    public void rollback(Connection conn) {
        try {
            if (conn == null) {
                throw new InvalidArgumentException("conn", conn);
            }
            log.info("Database rollback issued!");
            conn.rollback();
            return;
        }
        catch (SQLException sqle) {
            throw new EmpireSQLException(this, sqle);
        }
    }

    public void closeStatement(Statement stmt) {
        try {
            if (stmt != null) {
                stmt.close();
            }
            return;
        }
        catch (SQLException sqle) {
            throw new EmpireSQLException(this, sqle);
        }
    }

    public void closeResultSet(ResultSet rset) {
        try {
            if (rset == null) {
                return;
            }
            Statement stmt = rset.getStatement();
            rset.close();
            if (stmt == null) {
                return;
            }
            stmt.close();
            return;
        }
        catch (SQLException sqle) {
            throw new EmpireSQLException(this, sqle);
        }
    }

    public DataType detectDataType(Object value) {
        if (value instanceof DBColumnExpr) {
            return ((DBColumnExpr)value).getDataType();
        }
        if (value instanceof String) {
            return DataType.VARCHAR;
        }
        if (value instanceof Integer || value instanceof Long) {
            return DataType.INTEGER;
        }
        if (value instanceof Number) {
            return DataType.DECIMAL;
        }
        if (value instanceof Boolean) {
            return DataType.BOOL;
        }
        if (value instanceof Date) {
            return DataType.DATETIME;
        }
        if (value instanceof Character) {
            return DataType.CHAR;
        }
        if (value instanceof byte[]) {
            return DataType.BLOB;
        }
        return DataType.UNKNOWN;
    }

    public DBColumnExpr caseWhen(DBCompareExpr condition, Object trueValue, Object falseValue) {
        DataType dataType = this.detectDataType(trueValue != null ? trueValue : falseValue);
        DBColumnExpr trueExpr = trueValue instanceof DBColumnExpr ? (DBColumnExpr)trueValue : this.getValueExpr(trueValue, dataType);
        return trueExpr.when(condition, falseValue);
    }

    public DBColumnExpr caseWhen(Map<DBCompareExpr, DBColumnExpr> whenMap, DBColumnExpr elseValue) {
        return new DBCaseWhenExpr(whenMap, elseValue);
    }

    public DBColumnExpr caseWhenNull(DBColumnExpr expr, Object trueValue, Object falseValue) {
        return this.caseWhen(expr.is(null), trueValue, falseValue);
    }

    public static final class DBSystemDate
    implements Serializable {
        private static final long serialVersionUID = 1L;

        private DBSystemDate() {
        }

        public String toString() {
            return "sysdate";
        }
    }
}

