/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.DataType;
import org.apache.empire.db.DBCmdParam;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.DBCommandExpr;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBExpr;
import org.apache.empire.db.DBJoinType;
import org.apache.empire.db.DBRowSet;
import org.apache.empire.db.DBTable;
import org.apache.empire.db.exceptions.DatabaseMismatchException;
import org.apache.empire.db.expr.compare.DBCompareColExpr;
import org.apache.empire.db.expr.compare.DBCompareExpr;
import org.apache.empire.db.expr.join.DBColumnJoinExpr;
import org.apache.empire.db.expr.join.DBCompareJoinExpr;
import org.apache.empire.db.expr.join.DBCrossJoinExpr;
import org.apache.empire.db.expr.join.DBJoinExpr;
import org.apache.empire.db.expr.set.DBSetExpr;
import org.apache.empire.exceptions.InternalException;
import org.apache.empire.exceptions.MiscellaneousErrorException;
import org.apache.empire.exceptions.ObjectNotValidException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DBCommand
extends DBCommandExpr
implements Cloneable {
    private static final long serialVersionUID = 1L;
    protected static final Logger log = LoggerFactory.getLogger(DBCommand.class);
    protected boolean selectDistinct = false;
    protected List<DBColumnExpr> select = null;
    protected List<DBSetExpr> set = null;
    protected List<DBJoinExpr> joins = null;
    protected List<DBCompareExpr> where = null;
    protected List<DBCompareExpr> having = null;
    protected List<DBColumnExpr> groupBy = null;
    protected Vector<DBCmdParam> cmdParams = null;
    private int paramUsageCount = 0;
    private transient DBDatabase db;

    protected DBCommand(DBDatabase db) {
        this.db = db;
    }

    private void writeObject(ObjectOutputStream strm) throws IOException {
        if (this.db == null) {
            strm.writeObject("");
            strm.defaultWriteObject();
            return;
        }
        String dbid = this.db.getId();
        strm.writeObject(dbid);
        if (log.isDebugEnabled()) {
            log.debug("Serialization: writing DBCommand " + dbid);
        }
        strm.defaultWriteObject();
    }

    private void readObject(ObjectInputStream strm) throws IOException, ClassNotFoundException, SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        String dbid = String.valueOf(strm.readObject());
        if (StringUtils.isNotEmpty(dbid)) {
            DBDatabase sdb;
            if (log.isDebugEnabled()) {
                log.debug("Serialization: reading DBCommand " + dbid);
            }
            if ((sdb = DBDatabase.findById(dbid)) == null) {
                throw new ClassNotFoundException(dbid);
            }
            Field f = DBCommand.class.getDeclaredField("db");
            f.setAccessible(true);
            f.set(this, sdb);
            f.setAccessible(false);
        }
        strm.defaultReadObject();
    }

    protected void resetParamUsage() {
        this.paramUsageCount = 0;
    }

    protected synchronized void notifyParamUsage(DBCmdParam param) {
        int index = this.cmdParams.indexOf(param);
        if (index < this.paramUsageCount) {
            throw new MiscellaneousErrorException("A parameter may only be used once in a command.");
        }
        if (index > this.paramUsageCount) {
            this.cmdParams.remove(index);
            this.cmdParams.insertElementAt(param, this.paramUsageCount);
        }
        ++this.paramUsageCount;
    }

    private void removeCommandParam(DBCompareColExpr cmp) {
        if (this.cmdParams != null && cmp.getValue() instanceof DBCmdParam) {
            this.cmdParams.remove(cmp.getValue());
        }
    }

    private void removeAllCommandParams(List<DBCompareExpr> list) {
        if (this.cmdParams == null) {
            return;
        }
        for (DBCompareExpr cmp : list) {
            if (!(cmp instanceof DBCompareColExpr)) continue;
            this.removeCommandParam((DBCompareColExpr)cmp);
        }
    }

    public DBCommand clone() {
        try {
            DBCommand clone = (DBCommand)super.clone();
            clone.db = this.db;
            if (this.select != null) {
                clone.select = new ArrayList<DBColumnExpr>(this.select);
            }
            if (this.set != null) {
                clone.set = new ArrayList<DBSetExpr>(this.set);
            }
            if (this.joins != null) {
                clone.joins = new ArrayList<DBJoinExpr>(this.joins);
            }
            if (this.where != null) {
                clone.where = new ArrayList<DBCompareExpr>(this.where);
            }
            if (this.groupBy != null) {
                clone.groupBy = new ArrayList<DBColumnExpr>(this.groupBy);
            }
            if (this.having != null) {
                clone.having = new ArrayList<DBCompareExpr>(this.having);
            }
            if (this.cmdParams != null) {
                clone.paramUsageCount = 0;
                clone.cmdParams = new Vector();
                for (DBCmdParam p : this.cmdParams) {
                    DBCmdParam param = new DBCmdParam(this, p.getDataType(), p.getValue());
                    clone.cmdParams.add(param);
                }
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            log.error("Cloning DBCommand object failed!", (Throwable)e);
            throw new InternalException(e);
        }
    }

    @Override
    public DBDatabase getDatabase() {
        return this.db;
    }

    @Override
    public boolean isValid() {
        return this.isValidQuery() || this.isValidUpdate();
    }

    public boolean isValidQuery() {
        return this.select != null;
    }

    public boolean isValidUpdate() {
        return this.set != null;
    }

    public void selectDistinct() {
        this.selectDistinct = true;
    }

    public boolean isSelectDistinct() {
        return this.selectDistinct;
    }

    public void select(DBColumnExpr expr) {
        this.checkDatabase(expr);
        if (this.select == null) {
            this.select = new ArrayList<DBColumnExpr>();
        }
        if (expr != null && !this.select.contains(expr)) {
            this.select.add(expr);
        }
    }

    public final void select(DBColumnExpr ... exprs) {
        for (DBColumnExpr expr : exprs) {
            this.select(expr);
        }
    }

    public final void select(Collection<? extends DBColumnExpr> columns) {
        for (DBColumnExpr dBColumnExpr : columns) {
            this.select(dBColumnExpr);
        }
    }

    public void selectQualified(DBColumn ... columns) {
        for (DBColumn col : columns) {
            this.select(col.qualified());
        }
    }

    public final void selectQualified(Collection<? extends DBColumn> columns) {
        for (DBColumn dBColumn : columns) {
            this.select(dBColumn.qualified());
        }
    }

    protected boolean isPreparedStatementsEnabled() {
        return this.db.isPreparedStatementsEnabled();
    }

    protected boolean useCmdParam(DBColumn col, Object value) {
        if (value instanceof DBExpr || value instanceof DBDatabase.DBSystemDate) {
            return false;
        }
        if (this.isPreparedStatementsEnabled()) {
            return true;
        }
        DataType dt = col.getDataType();
        return dt == DataType.BLOB || dt == DataType.CLOB;
    }

    public void set(DBSetExpr expr) {
        this.checkDatabase(expr);
        if (this.set == null) {
            this.set = new ArrayList<DBSetExpr>();
        }
        for (int i = 0; i < this.set.size(); ++i) {
            DBSetExpr chk = this.set.get(i);
            if (!chk.column.equals(expr.column)) continue;
            if (this.useCmdParam(expr.column, expr.value)) {
                if (chk.value instanceof DBCmdParam) {
                    ((DBCmdParam)chk.value).setValue(expr.value);
                } else {
                    chk.value = this.addParam(expr.column.getDataType(), expr.value);
                }
            } else {
                if (this.cmdParams != null && chk.value instanceof DBCmdParam) {
                    this.cmdParams.remove(chk.value);
                }
                chk.value = expr.value;
            }
            return;
        }
        if (this.useCmdParam(expr.column, expr.value)) {
            expr.value = this.addParam(expr.column.getDataType(), expr.value);
        }
        this.set.add(expr);
    }

    public final void set(DBSetExpr ... exprs) {
        for (int i = 0; i < exprs.length; ++i) {
            this.set(exprs[i]);
        }
    }

    protected boolean hasSetExprOn(DBColumn column) {
        if (this.set == null) {
            return false;
        }
        for (DBSetExpr chk : this.set) {
            if (!chk.column.equals(column)) continue;
            return true;
        }
        return false;
    }

    public DBCmdParam addParam(DataType type, Object value) {
        DBCmdParam param;
        if (this.cmdParams == null) {
            this.cmdParams = new Vector();
        }
        if (!this.cmdParams.add(param = new DBCmdParam(this, type, value))) {
            return null;
        }
        return param;
    }

    public final DBCmdParam addParam(DBColumnExpr colExpr, Object value) {
        return this.addParam(colExpr.getDataType(), value);
    }

    public final DBCmdParam addParam(Object value) {
        return this.addParam(DataType.UNKNOWN, value);
    }

    public final DBCmdParam addParam() {
        return this.addParam(DataType.UNKNOWN, null);
    }

    public void join(DBJoinExpr join) {
        this.checkDatabase(join);
        if (this.joins == null) {
            this.joins = new ArrayList<DBJoinExpr>();
        }
        for (int i = 0; i < this.joins.size(); ++i) {
            DBJoinExpr item = this.joins.get(i);
            if (!item.equals(join)) continue;
            return;
        }
        this.joins.add(join);
    }

    public final DBCrossJoinExpr join(DBRowSet left, DBRowSet right) {
        DBCrossJoinExpr join = new DBCrossJoinExpr(left, right);
        this.join(join);
        return join;
    }

    public final DBColumnJoinExpr join(DBColumnExpr left, DBColumnExpr right, DBJoinType joinType) {
        DBColumnJoinExpr join = new DBColumnJoinExpr(left, right, joinType);
        this.join(join);
        return join;
    }

    public final DBColumnJoinExpr join(DBColumnExpr left, DBColumn right) {
        return this.join(left, right, DBJoinType.INNER);
    }

    public final DBCompareJoinExpr join(DBRowSet rowset, DBCompareExpr cmp, DBJoinType joinType) {
        DBCompareJoinExpr join = new DBCompareJoinExpr(rowset, cmp, joinType);
        this.join(join);
        return join;
    }

    public final DBCompareJoinExpr join(DBRowSet rowset, DBCompareExpr cmp) {
        return this.join(rowset, cmp, DBJoinType.INNER);
    }

    public void addJoins(List<DBJoinExpr> joinExprList) {
        if (this.joins == null) {
            this.joins = new ArrayList<DBJoinExpr>();
        }
        this.joins.addAll(joinExprList);
    }

    public boolean hasJoinOn(DBRowSet rowset) {
        if (this.joins == null) {
            return false;
        }
        for (DBJoinExpr join : this.joins) {
            if (!join.isJoinOn(rowset)) continue;
            return true;
        }
        return false;
    }

    public boolean hasConstraintOn(DBRowSet rowset) {
        if (this.where == null && this.having == null) {
            return false;
        }
        int i = 0;
        HashSet<DBColumn> columns = new HashSet<DBColumn>();
        for (i = 0; this.where != null && i < this.where.size(); ++i) {
            ((DBExpr)this.where.get(i)).addReferencedColumns(columns);
        }
        for (i = 0; this.having != null && i < this.having.size(); ++i) {
            ((DBExpr)this.having.get(i)).addReferencedColumns(columns);
        }
        for (DBColumn col : columns) {
            DBRowSet table = col.getRowSet();
            if (!table.equals(rowset)) continue;
            return true;
        }
        return false;
    }

    public boolean hasJoinOn(DBColumn column) {
        if (this.joins == null) {
            return false;
        }
        for (DBJoinExpr join : this.joins) {
            if (!join.isJoinOn(column)) continue;
            return true;
        }
        return false;
    }

    public boolean removeJoinsOn(DBRowSet rowset) {
        if (this.joins == null) {
            return false;
        }
        int size = this.joins.size();
        for (int i = size - 1; i >= 0; --i) {
            if (!this.joins.get(i).isJoinOn(rowset)) continue;
            this.joins.remove(i);
        }
        return size != this.joins.size();
    }

    public boolean removeJoinsOn(DBColumn column) {
        if (this.joins == null) {
            return false;
        }
        int size = this.joins.size();
        for (int i = size - 1; i >= 0; --i) {
            if (!this.joins.get(i).isJoinOn(column)) continue;
            this.joins.remove(i);
        }
        return size != this.joins.size();
    }

    public void where(DBCompareExpr expr) {
        this.checkDatabase(expr);
        if (this.where == null) {
            this.where = new ArrayList<DBCompareExpr>();
        }
        this.setConstraint(this.where, expr);
    }

    public final void where(DBCompareExpr ... exprs) {
        for (int i = 0; i < exprs.length; ++i) {
            this.where(exprs[i]);
        }
    }

    public boolean hasWhereConstraints() {
        return this.where != null && this.where.size() > 0;
    }

    public List<DBCompareExpr> getWhereConstraints() {
        return this.where != null ? Collections.unmodifiableList(this.where) : null;
    }

    public void removeWhereConstraintOn(DBColumnExpr col) {
        if (this.where == null) {
            return;
        }
        this.removeConstraintOn(this.where, col);
    }

    public List<DBJoinExpr> getJoins() {
        return this.joins != null ? Collections.unmodifiableList(this.joins) : null;
    }

    public void addWhereConstraints(List<DBCompareExpr> constraints) {
        if (this.where == null) {
            this.where = new ArrayList<DBCompareExpr>();
        }
        this.where.addAll(constraints);
    }

    public void having(DBCompareExpr expr) {
        this.checkDatabase(expr);
        if (this.having == null) {
            this.having = new ArrayList<DBCompareExpr>();
        }
        this.setConstraint(this.having, expr);
    }

    public boolean hasHavingConstraints() {
        return this.having != null && this.having.size() > 0;
    }

    public List<DBCompareExpr> getHavingConstraints() {
        return this.having != null ? Collections.unmodifiableList(this.having) : null;
    }

    public void removeHavingConstraintOn(DBColumnExpr col) {
        if (this.having == null) {
            return;
        }
        this.removeConstraintOn(this.having, col);
    }

    public void groupBy(DBColumnExpr ... exprs) {
        if (this.groupBy == null) {
            this.groupBy = new ArrayList<DBColumnExpr>();
        }
        for (DBColumnExpr expr : exprs) {
            this.checkDatabase(expr);
            if (expr.isAggregate() || this.groupBy.contains(expr)) continue;
            this.groupBy.add(expr);
        }
    }

    public final void groupBy(Collection<? extends DBColumnExpr> columns) {
        for (DBColumnExpr dBColumnExpr : columns) {
            this.groupBy(dBColumnExpr);
        }
    }

    public boolean hasSelectExpr() {
        return this.select != null && this.select.size() > 0;
    }

    @Override
    public synchronized void getSelect(StringBuilder buf) {
        this.resetParamUsage();
        if (this.select == null) {
            throw new ObjectNotValidException(this);
        }
        this.addSelect(buf);
        this.addFrom(buf);
        this.addWhere(buf);
        this.addGrouping(buf);
        this.addOrder(buf);
    }

    @Override
    public DBColumnExpr[] getSelectExprList() {
        int count;
        int n = count = this.select != null ? this.select.size() : 0;
        if (count < 1) {
            return null;
        }
        DBColumnExpr[] exprList = new DBColumnExpr[count];
        for (int i = 0; i < count; ++i) {
            exprList[i] = this.select.get(i);
        }
        return exprList;
    }

    public void clearSelectDistinct() {
        this.selectDistinct = false;
    }

    public void clearSelect() {
        this.select = null;
    }

    public void clearSet() {
        this.set = null;
        this.cmdParams = null;
    }

    public void clearJoin() {
        this.joins = null;
    }

    public void clearWhere() {
        this.removeAllCommandParams(this.where);
        this.where = null;
    }

    public void clearHaving() {
        this.removeAllCommandParams(this.having);
        this.having = null;
    }

    public void clearGroupBy() {
        this.groupBy = null;
    }

    public void clear() {
        this.cmdParams = null;
        this.clearSelectDistinct();
        this.clearSelect();
        this.clearSet();
        this.clearJoin();
        this.clearWhere();
        this.clearHaving();
        this.clearGroupBy();
        this.clearOrderBy();
        this.clearLimit();
        this.resetParamUsage();
    }

    protected void setConstraint(List<DBCompareExpr> list, DBCompareExpr expr) {
        for (int i = 0; i < list.size(); ++i) {
            DBCompareExpr other = list.get(i);
            if (!expr.isMutuallyExclusive(other)) continue;
            if (other instanceof DBCompareColExpr) {
                this.removeCommandParam((DBCompareColExpr)other);
            }
            list.set(i, expr);
            return;
        }
        list.add(expr);
    }

    protected void removeConstraintOn(List<DBCompareExpr> list, DBColumnExpr col) {
        if (list == null) {
            return;
        }
        for (DBCompareExpr cmp : list) {
            if (!(cmp instanceof DBCompareColExpr)) continue;
            DBColumnExpr c = ((DBCompareColExpr)cmp).getColumnExpr();
            DBColumn udc = c.getUpdateColumn();
            if (!c.equals(col) && (udc == null || !udc.equals(col.getUpdateColumn()))) continue;
            this.removeCommandParam((DBCompareColExpr)cmp);
            list.remove(cmp);
            return;
        }
    }

    protected List<DBRowSet> getRowSetList() {
        int i = 0;
        HashSet<DBColumn> columns = new HashSet<DBColumn>();
        for (i = 0; this.select != null && i < this.select.size(); ++i) {
            ((DBExpr)this.select.get(i)).addReferencedColumns(columns);
        }
        for (i = 0; this.joins != null && i < this.joins.size(); ++i) {
            ((DBExpr)this.joins.get(i)).addReferencedColumns(columns);
        }
        for (i = 0; this.where != null && i < this.where.size(); ++i) {
            ((DBExpr)this.where.get(i)).addReferencedColumns(columns);
        }
        for (i = 0; this.groupBy != null && i < this.groupBy.size(); ++i) {
            ((DBExpr)this.groupBy.get(i)).addReferencedColumns(columns);
        }
        for (i = 0; this.having != null && i < this.having.size(); ++i) {
            ((DBExpr)this.having.get(i)).addReferencedColumns(columns);
        }
        for (i = 0; this.orderBy != null && i < this.orderBy.size(); ++i) {
            ((DBExpr)this.orderBy.get(i)).addReferencedColumns(columns);
        }
        ArrayList<DBRowSet> tables = new ArrayList<DBRowSet>();
        for (DBColumn col : columns) {
            DBRowSet table = col.getRowSet();
            if (table == this.cmdQuery) {
                log.error("Recursive Column Selection in Command!");
                continue;
            }
            if (tables.contains(table) || table == null) continue;
            tables.add(table);
        }
        return tables;
    }

    @Override
    public void addReferencedColumns(Set<DBColumn> list) {
    }

    @Override
    public Object[] getParamValues() {
        if (this.cmdParams == null || this.cmdParams.size() == 0) {
            return null;
        }
        if (this.paramUsageCount > 0 && this.paramUsageCount != this.cmdParams.size()) {
            log.warn("DBCommand parameter count (" + String.valueOf(this.cmdParams.size()) + ") does not match parameter use count (" + String.valueOf(this.paramUsageCount) + ")");
        }
        Object[] values = new Object[this.cmdParams.size()];
        for (int i = 0; i < values.length; ++i) {
            values[i] = this.cmdParams.get(i).getValue();
        }
        return values;
    }

    public synchronized String getUpdate() {
        this.resetParamUsage();
        if (this.set == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder("UPDATE ");
        DBRowSet table = this.set.get(0).getTable();
        if (this.joins != null && !this.joins.isEmpty()) {
            buf.append(table.getAlias());
            long context = 7L;
            buf.append("\r\nSET ");
            this.addListExpr(buf, this.set, context, ", ");
            this.addFrom(buf);
            this.addWhere(buf, context);
        } else {
            table.addSQL(buf, 2L);
            long context = 5L;
            buf.append("\r\nSET ");
            this.addListExpr(buf, this.set, context, ", ");
            this.addWhere(buf, context);
        }
        return buf.toString();
    }

    public synchronized String getInsert() {
        this.resetParamUsage();
        if (this.set == null || this.set.get(0) == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder("INSERT INTO ");
        DBRowSet table = this.set.get(0).getTable();
        table.addSQL(buf, 2L);
        buf.append("( ");
        ArrayList<DBCompareColExpr> compexpr = null;
        if (this.where != null && !this.where.isEmpty()) {
            compexpr = new ArrayList<DBCompareColExpr>(this.where.size());
            for (DBCompareExpr expr : this.where) {
                DBColumn column;
                if (!(expr instanceof DBCompareColExpr) || (column = ((DBCompareColExpr)expr).getColumnExpr().getUpdateColumn()) == null || this.hasSetExprOn(column)) continue;
                compexpr.add((DBCompareColExpr)expr);
            }
            if (compexpr.size() > 0) {
                this.addListExpr(buf, compexpr, 1L, ", ");
                if (this.set != null) {
                    buf.append(", ");
                }
            } else {
                compexpr = null;
            }
        }
        if (this.set != null) {
            this.addListExpr(buf, this.set, 1L, ", ");
        }
        buf.append(") VALUES ( ");
        if (compexpr != null) {
            this.addListExpr(buf, compexpr, 4L, ", ");
        }
        if (compexpr != null && this.set != null) {
            buf.append(", ");
        }
        if (this.set != null) {
            this.addListExpr(buf, this.set, 4L, ", ");
        }
        buf.append(")");
        return buf.toString();
    }

    public synchronized String getDelete(DBTable table) {
        this.resetParamUsage();
        StringBuilder buf = new StringBuilder("DELETE FROM ");
        table.addSQL(buf, 2L);
        if (this.where != null && !this.where.isEmpty()) {
            buf.append("\r\nWHERE ");
            this.addListExpr(buf, this.where, 5L, " AND ");
        }
        return buf.toString();
    }

    protected void addSelect(StringBuilder buf) {
        buf.append("SELECT ");
        if (this.selectDistinct) {
            buf.append("DISTINCT ");
        }
        this.addListExpr(buf, this.select, 15L, ", ");
    }

    protected void addFrom(StringBuilder buf) {
        int originalLength = buf.length();
        buf.append("\r\nFROM ");
        boolean sep = false;
        List<DBRowSet> tables = this.getRowSetList();
        if (this.joins != null && this.joins.size() > 0) {
            ArrayList<DBRowSet> joinTables = new ArrayList<DBRowSet>();
            for (int i = 0; i < this.joins.size(); ++i) {
                long context;
                DBJoinExpr join = this.joins.get(i);
                if (i < 1) {
                    joinTables.add(join.getLeftTable());
                    joinTables.add(join.getRightTable());
                    tables.remove(join.getLeftTable());
                    tables.remove(join.getRightTable());
                    context = 5L;
                } else {
                    if (joinTables.contains(join.getRightTable())) {
                        join.reverse();
                    }
                    joinTables.add(join.getRightTable());
                    tables.remove(join.getRightTable());
                    context = 4L;
                    buf.append("\t");
                }
                join.addSQL(buf, context);
                if (i == this.joins.size() - 1) continue;
                buf.append("\r\n");
            }
            sep = true;
        }
        for (int i = 0; i < tables.size(); ++i) {
            if (sep) {
                buf.append(", ");
            }
            DBRowSet t = tables.get(i);
            t.addSQL(buf, 15L);
            sep = true;
        }
        if (!sep) {
            String pseudoTable = this.db.getDriver().getSQLPhrase(9);
            if (StringUtils.isNotEmpty(pseudoTable)) {
                buf.append(pseudoTable);
            } else {
                buf.setLength(originalLength);
            }
        }
    }

    protected void addWhere(StringBuilder buf, long context) {
        if (this.where != null && !this.where.isEmpty()) {
            buf.append("\r\nWHERE ");
            this.addListExpr(buf, this.where, context, " AND ");
        }
    }

    protected final void addWhere(StringBuilder buf) {
        this.addWhere(buf, 7L);
    }

    protected void addGrouping(StringBuilder buf) {
        if (this.groupBy != null && !this.groupBy.isEmpty()) {
            buf.append("\r\nGROUP BY ");
            this.addListExpr(buf, this.groupBy, 7L, ", ");
        }
        if (this.having != null && !this.having.isEmpty()) {
            buf.append("\r\nHAVING ");
            this.addListExpr(buf, this.having, 7L, " AND ");
        }
    }

    protected void addOrder(StringBuilder buf) {
        if (this.orderBy != null && !this.orderBy.isEmpty()) {
            buf.append("\r\nORDER BY ");
            this.addListExpr(buf, this.orderBy, 7L, ", ");
        }
    }

    protected void checkDatabase(DBExpr expr) {
        if (this.getDatabase().equals(expr.getDatabase())) {
            return;
        }
        throw new DatabaseMismatchException(this, expr);
    }
}

