/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.empire.commons.Attributes;
import org.apache.empire.commons.OptionEntry;
import org.apache.empire.commons.Options;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.Column;
import org.apache.empire.data.ColumnExpr;
import org.apache.empire.data.DataType;
import org.apache.empire.db.DBCmpType;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBExpr;
import org.apache.empire.db.expr.column.DBAliasExpr;
import org.apache.empire.db.expr.column.DBCalcExpr;
import org.apache.empire.db.expr.column.DBCaseExpr;
import org.apache.empire.db.expr.column.DBConcatExpr;
import org.apache.empire.db.expr.column.DBConvertExpr;
import org.apache.empire.db.expr.column.DBCountExpr;
import org.apache.empire.db.expr.column.DBDecodeExpr;
import org.apache.empire.db.expr.column.DBFuncExpr;
import org.apache.empire.db.expr.column.DBValueExpr;
import org.apache.empire.db.expr.compare.DBCompareColExpr;
import org.apache.empire.db.expr.compare.DBCompareExpr;
import org.apache.empire.db.expr.order.DBOrderByExpr;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.w3c.dom.Element;

public abstract class DBColumnExpr
extends DBExpr
implements ColumnExpr {
    private static final long serialVersionUID = 1L;
    public static final String DBCOLATTR_TITLE = "title";
    public static final String DBCOLATTR_TYPE = "type";
    protected Attributes attributes = null;
    protected Options options = null;
    protected String beanPropertyName = null;

    @Override
    public abstract DataType getDataType();

    @Override
    public abstract String getName();

    public abstract boolean isAggregate();

    public abstract DBColumn getUpdateColumn();

    public abstract Element addXml(Element var1, long var2);

    @Override
    public synchronized Object getAttribute(String name) {
        if (this.attributes != null && this.attributes.indexOf(name) >= 0) {
            return this.attributes.get(name);
        }
        DBColumn column = this.getUpdateColumn();
        if (column == null || column == this) {
            return null;
        }
        return column.getAttribute(name);
    }

    public synchronized void setAttribute(String name, Object value) {
        if (this.attributes == null) {
            this.attributes = new Attributes();
        }
        this.attributes.set(name, value);
    }

    @Override
    public synchronized Options getOptions() {
        if (this.options != null) {
            return this.options;
        }
        DBColumn column = this.getUpdateColumn();
        if (column == null || column == this) {
            return null;
        }
        return column.getOptions();
    }

    public synchronized void setOptions(Options options) {
        this.options = options;
    }

    @Override
    public final String getTitle() {
        Object title = this.getAttribute(DBCOLATTR_TITLE);
        return StringUtils.toString(title);
    }

    public final void setTitle(String title) {
        this.setAttribute(DBCOLATTR_TITLE, title);
    }

    @Override
    public final String getControlType() {
        Object type = this.getAttribute(DBCOLATTR_TYPE);
        return StringUtils.toString(type);
    }

    public final void setControlType(String controlType) {
        this.setAttribute(DBCOLATTR_TYPE, controlType);
    }

    @Override
    public final Column getSourceColumn() {
        return this.getUpdateColumn();
    }

    @Override
    public String getBeanPropertyName() {
        if (this.beanPropertyName == null) {
            String name = this.getName();
            if (name == null) {
                return null;
            }
            name = name.toLowerCase();
            String res = "";
            int beg = 0;
            while (beg < name.length()) {
                int end = name.indexOf(95, beg);
                if (end < 0) {
                    end = name.length();
                }
                if (end > beg) {
                    if (beg == 0) {
                        res = name.substring(beg, end);
                    } else {
                        res = res + name.substring(beg, beg + 1).toUpperCase();
                        if (end - beg > 1) {
                            res = res + name.substring(beg + 1, end);
                        }
                    }
                }
                beg = end + 1;
            }
            this.beanPropertyName = res;
        }
        return this.beanPropertyName;
    }

    public void setBeanPropertyName(String propertyName) {
        this.beanPropertyName = propertyName;
    }

    public DBColumnExpr append(Object value) {
        return new DBConcatExpr(this, value);
    }

    public DBColumnExpr as(String alias) {
        return new DBAliasExpr(this, alias);
    }

    public final DBColumnExpr as(DBColumn column) {
        return this.as(column.getName());
    }

    public DBCompareColExpr cmp(DBCmpType op, Object value) {
        return new DBCompareColExpr(this, op, value);
    }

    public final DBCompareColExpr like(Object value) {
        return this.cmp(DBCmpType.LIKE, value);
    }

    public DBCompareColExpr likeUpper(String value) {
        DBValueExpr expr = new DBValueExpr(this.getDatabase(), value, DataType.VARCHAR);
        return new DBCompareColExpr(this.upper(), DBCmpType.LIKE, expr.upper());
    }

    public DBCompareColExpr likeLower(String value) {
        DBValueExpr expr = new DBValueExpr(this.getDatabase(), value, DataType.VARCHAR);
        return new DBCompareColExpr(this.lower(), DBCmpType.LIKE, expr.lower());
    }

    public DBCompareColExpr like(String value, char escape) {
        DBValueExpr textExpr = new DBValueExpr(this.getDatabase(), value, DataType.VARCHAR);
        DBFuncExpr escapeExpr = new DBFuncExpr((DBColumnExpr)textExpr, 119, new Object[]{String.valueOf(escape)}, this.getUpdateColumn(), false, DataType.VARCHAR);
        return this.cmp(DBCmpType.LIKE, escapeExpr);
    }

    public final DBCompareColExpr notLike(Object value) {
        return this.cmp(DBCmpType.NOTLIKE, value);
    }

    public final DBCompareColExpr is(Object value) {
        return this.cmp(DBCmpType.EQUAL, value);
    }

    public final DBCompareColExpr isNot(Object value) {
        return this.cmp(DBCmpType.NOTEQUAL, value);
    }

    public final DBCompareColExpr in(Collection<?> values) {
        if (values == null || values.isEmpty()) {
            return this.cmp(DBCmpType.EQUAL, null);
        }
        return this.cmp(DBCmpType.IN, values);
    }

    public final <T> DBCompareColExpr in(T ... values) {
        if (values == null || values.length == 0) {
            return this.cmp(DBCmpType.EQUAL, null);
        }
        return this.cmp(DBCmpType.IN, values);
    }

    public final DBCompareColExpr in(DBExpr expr) {
        return this.cmp(DBCmpType.IN, expr);
    }

    public final DBCompareColExpr notIn(Collection<?> values) {
        if (values == null || values.isEmpty()) {
            return this.cmp(DBCmpType.NOTEQUAL, null);
        }
        return this.cmp(DBCmpType.NOTIN, values);
    }

    public final <T> DBCompareColExpr notIn(T ... values) {
        if (values == null || values.length == 0) {
            return this.cmp(DBCmpType.NOTEQUAL, null);
        }
        return this.cmp(DBCmpType.NOTIN, values);
    }

    public final DBCompareColExpr notIn(DBExpr expr) {
        return this.cmp(DBCmpType.NOTIN, expr);
    }

    public final DBCompareColExpr isBetween(Object minValue, Object maxValue) {
        return this.cmp(DBCmpType.BETWEEN, new Object[]{minValue, maxValue});
    }

    public final DBCompareColExpr isNotBetween(Object minValue, Object maxValue) {
        return this.cmp(DBCmpType.NOTBETWEEN, new Object[]{minValue, maxValue});
    }

    public final DBCompareColExpr isGreaterThan(Object value) {
        return this.cmp(DBCmpType.GREATERTHAN, value);
    }

    public final DBCompareColExpr isMoreOrEqual(Object value) {
        return this.cmp(DBCmpType.MOREOREQUAL, value);
    }

    public final DBCompareColExpr isLessOrEqual(Object value) {
        return this.cmp(DBCmpType.LESSOREQUAL, value);
    }

    public final DBCompareColExpr isSmallerThan(Object value) {
        return this.cmp(DBCmpType.LESSTHAN, value);
    }

    public DBCalcExpr multiplyWith(Object value) {
        return new DBCalcExpr(this, "*", value);
    }

    public DBCalcExpr divideBy(Object value) {
        return new DBCalcExpr(this, "/", value);
    }

    public DBCalcExpr plus(Object value) {
        return new DBCalcExpr(this, "+", value);
    }

    public DBCalcExpr minus(Object value) {
        return new DBCalcExpr(this, "-", value);
    }

    public DBCalcExpr plus(int value) {
        return value >= 0 ? new DBCalcExpr(this, "+", new Integer(value)) : new DBCalcExpr(this, "-", new Integer(-value));
    }

    public DBCalcExpr minus(int value) {
        return value >= 0 ? new DBCalcExpr(this, "-", new Integer(value)) : new DBCalcExpr(this, "+", new Integer(-value));
    }

    protected DBColumnExpr getExprFromPhrase(int phrase, Object[] params, DBColumn updateColumn, boolean isAggregate, DataType dataType) {
        return new DBFuncExpr(this, phrase, params, updateColumn, isAggregate, dataType);
    }

    protected DBColumnExpr getExprFromPhrase(int phrase, Object[] params, DBColumn updateColumn, boolean isAggregate) {
        return this.getExprFromPhrase(phrase, params, updateColumn, isAggregate, this.getDataType());
    }

    public DBColumnExpr parenthesis() {
        return new DBFuncExpr(this, "(?)", null, this.getUpdateColumn(), false, this.getDataType());
    }

    public DBColumnExpr coalesce(Object nullValue) {
        return this.getExprFromPhrase(100, new Object[]{nullValue}, this.getUpdateColumn(), false);
    }

    public DBColumnExpr modulo(Object divisor) {
        return this.getExprFromPhrase(125, new Object[]{divisor}, this.getUpdateColumn(), false);
    }

    @Deprecated
    public DBColumnExpr nvl(Object nullValue) {
        return this.coalesce(nullValue);
    }

    public DBColumnExpr substring(DBExpr pos) {
        return this.getExprFromPhrase(101, new Object[]{pos}, this.getUpdateColumn(), false);
    }

    public DBColumnExpr substring(int pos) {
        return this.substring(new DBValueExpr(this.getDatabase(), pos, DataType.INTEGER));
    }

    public DBColumnExpr substring(DBExpr pos, DBExpr count) {
        return this.getExprFromPhrase(102, new Object[]{pos, count}, this.getUpdateColumn(), false);
    }

    public DBColumnExpr substring(DBExpr pos, int count) {
        return this.substring(pos, (DBExpr)new DBValueExpr(this.getDatabase(), count, DataType.INTEGER));
    }

    public DBColumnExpr substring(int pos, DBExpr count) {
        return this.substring((DBExpr)new DBValueExpr(this.getDatabase(), pos, DataType.INTEGER), count);
    }

    public DBColumnExpr substring(int pos, int count) {
        return this.substring((DBExpr)new DBValueExpr(this.getDatabase(), pos, DataType.INTEGER), (DBExpr)new DBValueExpr(this.getDatabase(), count, DataType.INTEGER));
    }

    public DBColumnExpr replace(Object match, Object replace) {
        return this.getExprFromPhrase(103, new Object[]{match, replace}, this.getUpdateColumn(), false);
    }

    public DBColumnExpr reverse() {
        return this.getExprFromPhrase(104, null, this.getUpdateColumn(), false);
    }

    public DBColumnExpr trim() {
        return this.getExprFromPhrase(112, null, this.getUpdateColumn(), false);
    }

    public DBColumnExpr trimLeft() {
        return this.getExprFromPhrase(113, null, this.getUpdateColumn(), false);
    }

    public DBColumnExpr trimRight() {
        return this.getExprFromPhrase(114, null, this.getUpdateColumn(), false);
    }

    public DBColumnExpr upper() {
        return this.getExprFromPhrase(110, null, this.getUpdateColumn(), false);
    }

    public DBColumnExpr lower() {
        return this.getExprFromPhrase(111, null, this.getUpdateColumn(), false);
    }

    public DBColumnExpr format(String format) {
        return this.getExprFromPhrase(126, new Object[]{format}, this.getUpdateColumn(), false, DataType.VARCHAR);
    }

    public DBColumnExpr length() {
        return this.getExprFromPhrase(107, null, this.getUpdateColumn(), false, DataType.INTEGER);
    }

    public DBColumnExpr indexOf(Object str) {
        return this.getExprFromPhrase(105, new Object[]{str}, this.getUpdateColumn(), false, DataType.INTEGER);
    }

    public DBColumnExpr indexOf(Object str, DBExpr fromPos) {
        return this.getExprFromPhrase(106, new Object[]{str, fromPos}, this.getUpdateColumn(), false, DataType.INTEGER);
    }

    public DBColumnExpr indexOf(Object str, int fromPos) {
        return this.indexOf(str, new DBValueExpr(this.getDatabase(), fromPos, DataType.INTEGER));
    }

    public DBColumnExpr abs() {
        return this.getExprFromPhrase(120, null, this.getUpdateColumn(), false);
    }

    public DBColumnExpr floor() {
        return this.getExprFromPhrase(123, null, this.getUpdateColumn(), false);
    }

    public DBColumnExpr ceiling() {
        return this.getExprFromPhrase(124, null, this.getUpdateColumn(), false);
    }

    public DBColumnExpr round(int decimals) {
        return this.getExprFromPhrase(121, new Object[]{new Integer(decimals)}, this.getUpdateColumn(), false);
    }

    public DBColumnExpr trunc(int decimals) {
        return this.getExprFromPhrase(122, new Object[]{new Integer(decimals)}, this.getUpdateColumn(), false);
    }

    public DBColumnExpr year() {
        return this.getExprFromPhrase(134, null, null, false);
    }

    public DBColumnExpr month() {
        return this.getExprFromPhrase(133, null, null, false);
    }

    public DBColumnExpr day() {
        return this.getExprFromPhrase(132, null, null, false);
    }

    public DBColumnExpr sum() {
        return this.getExprFromPhrase(140, null, null, true);
    }

    public DBColumnExpr min() {
        return this.getExprFromPhrase(143, null, null, true);
    }

    public DBColumnExpr max() {
        return this.getExprFromPhrase(142, null, null, true);
    }

    public DBColumnExpr avg() {
        return this.getExprFromPhrase(144, null, null, true);
    }

    public DBColumnExpr count() {
        return new DBCountExpr(this, false);
    }

    public DBColumnExpr countDistinct() {
        return new DBCountExpr(this, true);
    }

    public DBColumnExpr decodeEnum(Class<? extends Enum<?>> enumType, String otherwise) {
        if (enumType == null || !enumType.isEnum()) {
            throw new InvalidArgumentException("enumType", enumType);
        }
        boolean byOrdinal = this.getDataType().isNumeric();
        Enum<?>[] items = enumType.getEnumConstants();
        LinkedHashMap<Object, String> enumMap = new LinkedHashMap<Object, String>(items.length);
        for (int i = 0; i < items.length; ++i) {
            Object key = byOrdinal ? Integer.valueOf(items[i].ordinal()) : items[i].name();
            enumMap.put(key, items[i].toString());
        }
        return new DBDecodeExpr(this, enumMap, otherwise, DataType.VARCHAR);
    }

    public DBColumnExpr decodeSort(Class<? extends Enum<?>> enumType, boolean defaultToEnd) {
        if (enumType == null || !enumType.isEnum()) {
            throw new InvalidArgumentException("enumType", enumType);
        }
        Enum<?>[] items = enumType.getEnumConstants();
        LinkedHashMap<String, Integer> enumMap = new LinkedHashMap<String, Integer>(items.length);
        int sortOffset = defaultToEnd ? 0 : 1;
        for (int i = 0; i < items.length; ++i) {
            int sortValue = items[i].ordinal();
            enumMap.put(items[i].name(), sortValue + sortOffset);
        }
        int defaultValue = defaultToEnd ? items.length : 0;
        return new DBDecodeExpr(this, enumMap, defaultValue, DataType.INTEGER);
    }

    public DBColumnExpr decode(Map<?, ?> valueMap, Object otherwise) {
        DataType dataType = DataType.UNKNOWN;
        if (otherwise != null) {
            dataType = this.getDatabase().detectDataType(otherwise);
        }
        if (dataType == DataType.UNKNOWN) {
            for (Object v : valueMap.values()) {
                dataType = this.getDatabase().detectDataType(v);
                if (dataType == DataType.UNKNOWN) continue;
                break;
            }
        }
        return new DBDecodeExpr(this, valueMap, otherwise, dataType);
    }

    public final DBColumnExpr decode(Object key1, Object value1, Object otherwise) {
        HashMap<Object, Object> list = new HashMap<Object, Object>();
        list.put(key1, value1);
        return this.decode(list, otherwise);
    }

    public final DBColumnExpr decode(Object key1, Object value1, Object key2, Object value2, Object otherwise) {
        HashMap<Object, Object> list = new HashMap<Object, Object>();
        list.put(key1, value1);
        list.put(key2, value2);
        return this.decode(list, otherwise);
    }

    public final DBColumnExpr decode(Object key1, Object value1, Object key2, Object value2, Object key3, Object value3, Object otherwise) {
        HashMap<Object, Object> list = new HashMap<Object, Object>();
        list.put(key1, value1);
        list.put(key2, value2);
        list.put(key3, value3);
        return this.decode(list, otherwise);
    }

    public final DBColumnExpr decode(Options options, Object otherwise) {
        int size = options.size() + (otherwise != null ? 1 : 0);
        HashMap<Object, String> list = new HashMap<Object, String>(size);
        for (OptionEntry e : options) {
            list.put(e.getValue(), e.getText());
        }
        return this.decode(list, otherwise);
    }

    public final DBColumnExpr decode(Options options) {
        return this.decode(options, null);
    }

    public final DBCaseExpr when(DBCompareExpr compExpr, Object otherwise) {
        DBColumnExpr elseExpr = null;
        if (otherwise instanceof DBColumnExpr) {
            elseExpr = (DBColumnExpr)otherwise;
        } else if (otherwise != null) {
            elseExpr = new DBValueExpr(this.getDatabase(), otherwise, this.getDataType());
        }
        return new DBCaseExpr(compExpr, this, elseExpr);
    }

    public DBColumnExpr toChar() {
        return this.convertTo(DataType.VARCHAR);
    }

    public DBColumnExpr toChar(String format) {
        return this.convertTo(DataType.VARCHAR, format);
    }

    public DBColumnExpr convertTo(DataType dataType, Object format) {
        return new DBConvertExpr(this, dataType, format);
    }

    public final DBColumnExpr convertTo(DataType dataType) {
        return this.convertTo(dataType, null);
    }

    public DBOrderByExpr asc() {
        return new DBOrderByExpr(this, false);
    }

    public DBOrderByExpr desc() {
        return new DBOrderByExpr(this, true);
    }
}

