/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.commons;

import java.io.Serializable;
import org.apache.empire.commons.ObjectUtils;

public class OptionEntry
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Object value;
    private String text;
    private boolean active;

    public OptionEntry(Object value, String text, boolean active) {
        this.value = value;
        this.text = text;
        this.active = active;
    }

    public OptionEntry(Object value, String text) {
        this(value, text, true);
    }

    public Object getValue() {
        return this.value;
    }

    public boolean valueEquals(Object value) {
        return ObjectUtils.compareEqual(this.value, value);
    }

    public String getValueString() {
        if (this.value == null) {
            return "";
        }
        if (this.value.getClass().isEnum()) {
            return ((Enum)this.value).name();
        }
        return String.valueOf(this.value);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }
}

