/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.commons;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtils {
    private static final Logger log = LoggerFactory.getLogger(DateUtils.class);

    private DateUtils() {
    }

    public static Date getDateNow() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getTimeNow() {
        return Calendar.getInstance().getTime();
    }

    public static Date addDate(Date date, int years, int months, int days) {
        Calendar calendar = Calendar.getInstance();
        if (date != null) {
            calendar.setTime(date);
        }
        if (years != 0) {
            calendar.add(1, years);
        }
        if (months != 0) {
            calendar.add(2, months);
        }
        if (days != 0) {
            calendar.add(5, days);
        }
        return calendar.getTime();
    }

    public static Date setDate(Date date, int year, int month, int day) {
        Calendar calendar = Calendar.getInstance();
        if (date != null) {
            calendar.setTime(date);
        }
        if (year > 0) {
            calendar.set(1, year);
        }
        if (month >= 0) {
            calendar.set(2, month);
        }
        if (day > 0) {
            calendar.set(5, day);
        }
        return calendar.getTime();
    }

    public static Date getDate(int year, int month, int day) {
        Calendar calendar = Calendar.getInstance();
        if (year > 0) {
            calendar.set(1, year);
        }
        if (month >= 0) {
            calendar.set(2, month);
        }
        if (day > 0) {
            calendar.set(5, day);
        }
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date setTime(Date date, int hours, int minutes, int seconds, int millis) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, hours);
        calendar.set(12, minutes);
        calendar.set(13, seconds);
        calendar.set(14, millis);
        return calendar.getTime();
    }

    public static Date getDateOnly(Date date) {
        return DateUtils.setTime(date, 0, 0, 0, 0);
    }

    public static Date parseDate(String sDate, Locale locale) {
        try {
            DateFormat df = DateFormat.getDateInstance(3, DateUtils.getSafeLocale(locale));
            df.setLenient(true);
            return df.parse(sDate);
        }
        catch (ParseException e) {
            log.error("Invalid date value", (Throwable)e);
            return null;
        }
    }

    private static Locale getSafeLocale(Locale locale) {
        return locale == null ? Locale.getDefault() : locale;
    }

    public static String formatDate(Date d, Locale locale) {
        DateFormat df = DateFormat.getDateInstance(2, DateUtils.getSafeLocale(locale));
        return df.format(d);
    }

    public static String formatTime(Date d, Locale locale, boolean withSeconds) {
        int style = withSeconds ? 2 : 3;
        DateFormat df = DateFormat.getTimeInstance(style, DateUtils.getSafeLocale(locale));
        return df.format(d);
    }

    public static String formatDayOfWeek(Date d, Locale locale, boolean longFormat) {
        SimpleDateFormat sdf = new SimpleDateFormat("", DateUtils.getSafeLocale(locale));
        Calendar c = Calendar.getInstance(DateUtils.getSafeLocale(locale));
        c.setTime(d);
        int dayOfWeek = c.get(7);
        if (longFormat) {
            return sdf.getDateFormatSymbols().getWeekdays()[dayOfWeek];
        }
        return sdf.getDateFormatSymbols().getShortWeekdays()[dayOfWeek];
    }

    public static String formatMonth(Date d, Locale locale, boolean longFormat) {
        SimpleDateFormat sdf = new SimpleDateFormat("", DateUtils.getSafeLocale(locale));
        Calendar c = Calendar.getInstance(DateUtils.getSafeLocale(locale));
        c.setTime(d);
        int month = c.get(2);
        if (longFormat) {
            return sdf.getDateFormatSymbols().getMonths()[month];
        }
        return sdf.getDateFormatSymbols().getShortMonths()[month];
    }

    public static int getWeekOfYear(Date d, Locale locale) {
        Calendar c = Calendar.getInstance(DateUtils.getSafeLocale(locale));
        c.setTime(d);
        return c.get(3);
    }

    public static String formatMonth(int month, Locale locale, boolean longFormat) {
        SimpleDateFormat sdf = new SimpleDateFormat("", DateUtils.getSafeLocale(locale));
        if (longFormat) {
            return sdf.getDateFormatSymbols().getMonths()[month];
        }
        return sdf.getDateFormatSymbols().getShortMonths()[month];
    }

    public static String formatYear(Date d, Locale locale) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy", DateUtils.getSafeLocale(locale));
        Calendar c = Calendar.getInstance(DateUtils.getSafeLocale(locale));
        c.setTime(d);
        return sdf.format(d);
    }
}

