/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.spring;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.sql.DataSource;
import org.apache.empire.data.ColumnExpr;
import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.DBCommand;
import org.apache.empire.db.DBCommandExpr;
import org.apache.empire.db.DBReader;
import org.apache.empire.db.DBRecord;
import org.apache.empire.db.DBRecordData;
import org.apache.empire.db.DBRowSet;
import org.apache.empire.db.DBTable;
import org.apache.empire.db.exceptions.RecordNotFoundException;
import org.apache.empire.spring.DBReaderExtractor;
import org.apache.empire.spring.DBRecordCallbackHandler;
import org.apache.empire.spring.DBRecordMapper;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.util.Assert;

public class EmpireTemplate
implements InitializingBean {
    private JdbcTemplate jdbcTemplate;
    private ObjectFactory<DBReader> readerFactory = new ObjectFactory<DBReader>(){

        public DBReader getObject() throws BeansException {
            return new DBReader();
        }
    };
    private ObjectFactory<DBRecord> recordFactory = new ObjectFactory<DBRecord>(){

        public DBRecord getObject() throws BeansException {
            return new DBRecord();
        }
    };

    public void setDBRecordFactory(ObjectFactory<DBRecord> recordFactory) {
        this.recordFactory = recordFactory;
    }

    public void setDBRecordClass(final Class<? extends DBRecord> recordClass) {
        this.recordFactory = new ObjectFactory<DBRecord>(){

            public DBRecord getObject() throws BeansException {
                try {
                    return (DBRecord)recordClass.newInstance();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    public void setDBReaderFactory(ObjectFactory<DBReader> readerFactory) {
        this.readerFactory = readerFactory;
    }

    public void setDBReaderClass(final Class<? extends DBReader> readerClass) {
        this.readerFactory = new ObjectFactory<DBReader>(){

            public DBReader getObject() throws BeansException {
                try {
                    return (DBReader)readerClass.newInstance();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    public final void setDataSource(DataSource dataSource) {
        if (this.jdbcTemplate == null || dataSource != this.jdbcTemplate.getDataSource()) {
            this.jdbcTemplate = new JdbcTemplate(dataSource);
            this.jdbcTemplate.afterPropertiesSet();
        }
    }

    public void afterPropertiesSet() {
        if (this.getJdbcTemplate() == null) {
            throw new IllegalArgumentException("Property 'jdbcTemplate' is required, either jdbcTemplate or dataSource must be set.");
        }
    }

    public <K> List<K> query(DBCommand cmd, DBRecordMapper<K> recordMapper) {
        return (List)this.query(cmd, new DbRecordMapperExtractor<K>(recordMapper));
    }

    public <K> K queryForObject(DBCommand cmd, DBRecordMapper<K> recordMapper) {
        return (K)DataAccessUtils.uniqueResult(this.query(cmd, recordMapper));
    }

    public List<Object> queryForList(DBCommand cmd, final DBColumnExpr col) {
        class SingleValueMapper
        implements DBRecordMapper<Object> {
            SingleValueMapper() {
            }

            @Override
            public Object mapRecord(DBRecordData record, int rowNum) {
                return record.getValue((ColumnExpr)col);
            }
        }
        return this.query(cmd, new SingleValueMapper());
    }

    public Long queryForLong(DBCommand cmd, DBColumnExpr col, Long defaultValue) {
        return (Long)DataAccessUtils.uniqueResult(this.queryForLongList(cmd, col, defaultValue));
    }

    public List<Long> queryForLongList(DBCommand cmd, final DBColumnExpr col, final Long defaultValue) {
        class SingleLongMapper
        implements DBRecordMapper<Long> {
            SingleLongMapper() {
            }

            @Override
            public Long mapRecord(DBRecordData record, int rowNum) {
                return record.isNull((ColumnExpr)col) ? defaultValue.longValue() : record.getLong((ColumnExpr)col);
            }
        }
        return this.query(cmd, new SingleLongMapper());
    }

    public Integer queryForInteger(DBCommand cmd, DBColumnExpr col, Integer defaultValue) {
        return (Integer)DataAccessUtils.uniqueResult(this.queryForIntegerList(cmd, col, defaultValue));
    }

    public List<Integer> queryForIntegerList(DBCommand cmd, final DBColumnExpr col, final Integer defaultValue) {
        class SingleIntegerMapper
        implements DBRecordMapper<Integer> {
            SingleIntegerMapper() {
            }

            @Override
            public Integer mapRecord(DBRecordData record, int rowNum) {
                return record.isNull((ColumnExpr)col) ? defaultValue.intValue() : record.getInt((ColumnExpr)col);
            }
        }
        return this.query(cmd, new SingleIntegerMapper());
    }

    public String queryForString(DBCommand cmd, DBColumnExpr col) {
        return (String)DataAccessUtils.uniqueResult(this.queryForStringList(cmd, col));
    }

    public List<String> queryForStringList(DBCommand cmd, final DBColumnExpr col) {
        class SingleStringMapper
        implements DBRecordMapper<String> {
            SingleStringMapper() {
            }

            @Override
            public String mapRecord(DBRecordData record, int rowNum) {
                return record.getString((ColumnExpr)col);
            }
        }
        return this.query(cmd, new SingleStringMapper());
    }

    public <K> K query(final DBCommand cmd, final DBReaderExtractor<K> readerExtractor) {
        class QueryCallback
        implements ConnectionCallback<K> {
            QueryCallback() {
            }

            public K doInConnection(Connection connection) throws SQLException, DataAccessException {
                return EmpireTemplate.this.query(connection, cmd, readerExtractor);
            }
        }
        return (K)this.getJdbcTemplate().execute((ConnectionCallback)new QueryCallback());
    }

    public void query(DBCommand cmd, DBRecordCallbackHandler recordCallbackHandler) {
        this.query(cmd, new DbRecordCallbackHandlerExtractor(recordCallbackHandler));
    }

    public void deleteRecord(final DBRecord record) {
        class DeleteRecordCallback
        implements ConnectionCallback<Object> {
            DeleteRecordCallback() {
            }

            public Object doInConnection(Connection connection) throws SQLException, DataAccessException {
                record.delete(connection);
                return null;
            }
        }
        this.getJdbcTemplate().execute((ConnectionCallback)new DeleteRecordCallback());
    }

    public void deleteRecord(DBTable table, Object key) {
        this.deleteRecord(table, new Object[]{key});
    }

    public void deleteRecord(final DBTable table, final Object[] keys) {
        class DeleteRecordCallback
        implements ConnectionCallback<Object> {
            DeleteRecordCallback() {
            }

            public Object doInConnection(Connection connection) throws SQLException, DataAccessException {
                table.deleteRecord(keys, connection);
                return null;
            }
        }
        this.getJdbcTemplate().execute((ConnectionCallback)new DeleteRecordCallback());
    }

    public DBRecord updateRecord(final DBRecord record) {
        class UpdateRecordCallback
        implements ConnectionCallback<DBRecord> {
            UpdateRecordCallback() {
            }

            public DBRecord doInConnection(Connection connection) throws SQLException, DataAccessException {
                record.update(connection);
                return record;
            }
        }
        return (DBRecord)this.getJdbcTemplate().execute((ConnectionCallback)new UpdateRecordCallback());
    }

    public int executeUpdate(final DBCommand cmd) {
        class UpdateRecordCallback
        implements ConnectionCallback<Integer> {
            UpdateRecordCallback() {
            }

            public Integer doInConnection(Connection connection) throws SQLException, DataAccessException {
                return cmd.getDatabase().executeUpdate(cmd, connection);
            }
        }
        return (Integer)this.getJdbcTemplate().execute((ConnectionCallback)new UpdateRecordCallback());
    }

    public int executeDelete(final DBTable table, final DBCommand cmd) {
        class DeleteRecordCallback
        implements ConnectionCallback<Integer> {
            DeleteRecordCallback() {
            }

            public Integer doInConnection(Connection connection) throws SQLException, DataAccessException {
                return cmd.getDatabase().executeDelete(table, cmd, connection);
            }
        }
        return (Integer)this.getJdbcTemplate().execute((ConnectionCallback)new DeleteRecordCallback());
    }

    public int executeInsert(final DBCommand cmd) {
        class InsertRecordCallback
        implements ConnectionCallback<Integer> {
            InsertRecordCallback() {
            }

            public Integer doInConnection(Connection connection) throws SQLException, DataAccessException {
                return cmd.getDatabase().executeInsert(cmd, connection);
            }
        }
        return (Integer)this.getJdbcTemplate().execute((ConnectionCallback)new InsertRecordCallback());
    }

    public DBRecord newRecord(DBRowSet table) {
        DBRecord record = (DBRecord)this.recordFactory.getObject();
        record.create(table);
        return record;
    }

    public DBRecord openRecord(DBRowSet table, Object key) {
        return this.openRecord(table, new Object[]{key});
    }

    public DBRecord openRecord(final DBRowSet table, final Object[] keys) {
        class ReadRecordCallback
        implements ConnectionCallback<DBRecord> {
            ReadRecordCallback() {
            }

            public DBRecord doInConnection(Connection connection) throws SQLException, DataAccessException {
                DBRecord record = (DBRecord)EmpireTemplate.this.recordFactory.getObject();
                record.read(table, keys, connection);
                return record;
            }
        }
        return (DBRecord)this.getJdbcTemplate().execute((ConnectionCallback)new ReadRecordCallback());
    }

    public DBRecord getRecord(DBRowSet table, Object key) {
        return this.openRecord(table, new Object[]{key});
    }

    public DBRecord getRecord(final DBRowSet table, final Object[] keys) {
        class ReadRecordCallback
        implements ConnectionCallback<DBRecord> {
            ReadRecordCallback() {
            }

            public DBRecord doInConnection(Connection connection) throws SQLException, DataAccessException {
                DBRecord record = (DBRecord)EmpireTemplate.this.recordFactory.getObject();
                try {
                    record.read(table, keys, connection);
                }
                catch (RecordNotFoundException e) {
                    return null;
                }
                return record;
            }
        }
        return (DBRecord)this.getJdbcTemplate().execute((ConnectionCallback)new ReadRecordCallback());
    }

    public <C extends Collection<T>, T> C queryForBeanList(DBCommand cmd, final C c, final Class<T> t, final int maxCount) {
        class GetBeanListCallback
        implements DBReaderExtractor<C> {
            GetBeanListCallback() {
            }

            @Override
            public C process(DBReader reader) {
                return reader.getBeanList(c, t, maxCount);
            }
        }
        return (C)((Collection)this.query(cmd, new GetBeanListCallback()));
    }

    public <T> List<T> queryForBeanList(DBCommand cmd, Class<T> t, int maxItems) {
        return this.queryForBeanList(cmd, new ArrayList(), t, maxItems);
    }

    public <T> List<T> queryForBeanList(DBCommand cmd, Class<T> t) {
        return this.queryForBeanList(cmd, t, -1);
    }

    public <T> T queryForBean(DBCommand cmd, Class<T> t) {
        return (T)DataAccessUtils.uniqueResult(this.queryForBeanList(cmd, t, -1));
    }

    public <K> K execute(ConnectionCallback<K> connectionCallback) {
        return (K)this.getJdbcTemplate().execute(connectionCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <K> K query(Connection connection, DBCommand command, DBReaderExtractor<K> callback) {
        DBReader reader = this.newDBReader();
        try {
            reader.open((DBCommandExpr)command, connection);
            K k = callback.process(reader);
            return k;
        }
        finally {
            reader.close();
        }
    }

    private DBReader newDBReader() {
        return (DBReader)this.readerFactory.getObject();
    }

    private static class DbRecordMapperExtractor<K>
    implements DBReaderExtractor<List<K>> {
        private final DBRecordMapper<K> dataReader;

        public DbRecordMapperExtractor(DBRecordMapper<K> rowMapper) {
            Assert.notNull(rowMapper, (String)"DataReader is required");
            this.dataReader = rowMapper;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<K> process(DBReader reader) {
            try {
                ArrayList<K> results = new ArrayList<K>();
                int rowNum = 0;
                while (reader.moveNext()) {
                    results.add(this.dataReader.mapRecord((DBRecordData)reader, rowNum));
                    ++rowNum;
                }
                ArrayList<K> arrayList = results;
                return arrayList;
            }
            finally {
                reader.close();
            }
        }
    }

    private static class DbRecordCallbackHandlerExtractor
    implements DBReaderExtractor<Object> {
        private final DBRecordCallbackHandler rowCallbackHandler;

        public DbRecordCallbackHandlerExtractor(DBRecordCallbackHandler rowCallbackHandler) {
            Assert.notNull((Object)rowCallbackHandler, (String)"RowCallbackHandler is required");
            this.rowCallbackHandler = rowCallbackHandler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object process(DBReader reader) {
            try {
                while (reader.moveNext()) {
                    this.rowCallbackHandler.processRecord((DBRecordData)reader);
                }
                Object var2_2 = null;
                return var2_2;
            }
            finally {
                reader.close();
            }
        }
    }
}

