/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.spring;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBDatabaseDriver;
import org.apache.empire.spring.EmpireTemplate;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.DaoSupport;
import org.springframework.jdbc.CannotGetJdbcConnectionException;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceUtils;

public abstract class EmpireDaoSupport
extends DaoSupport {
    private EmpireTemplate empireTemplate;
    private DBDatabase database;
    private DBDatabaseDriver driver;

    public void setDriver(DBDatabaseDriver driver) {
        this.driver = driver;
    }

    protected final void checkDaoConfig() throws IllegalArgumentException {
        if (this.empireTemplate == null) {
            throw new IllegalArgumentException("Either empireTemplate or jdbcTemplate or dataSource must be set");
        }
        if (this.database == null) {
            throw new IllegalArgumentException("DBDatabase must be set");
        }
        if (!this.database.isOpen() && this.driver == null) {
            throw new RuntimeException("Database isn't open and no driver set.");
        }
    }

    protected EmpireTemplate getEmpireTemplate() {
        return this.empireTemplate;
    }

    public void setEmpireTemplate(EmpireTemplate empireTemplate) {
        this.empireTemplate = empireTemplate;
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.empireTemplate = new EmpireTemplate();
        this.empireTemplate.setJdbcTemplate(jdbcTemplate);
        this.empireTemplate.afterPropertiesSet();
    }

    public void setDataSource(DataSource dataSource) {
        this.empireTemplate = new EmpireTemplate();
        this.empireTemplate.setDataSource(dataSource);
        this.empireTemplate.afterPropertiesSet();
    }

    protected JdbcTemplate getJdbcTemplate() {
        return this.empireTemplate.getJdbcTemplate();
    }

    protected void initEmpireDao() {
    }

    protected final void initDao() throws Exception {
        super.initDao();
        this.initEmpireDao();
    }

    public void setDatabase(DBDatabase database) {
        if (this.database != null && this.database != database) {
            throw new IllegalArgumentException("setting different database not allowed");
        }
        this.database = database;
    }

    public <T extends DBDatabase> T getDatabase() {
        if (!this.database.isOpen()) {
            this.getJdbcTemplate().execute((ConnectionCallback)new ConnectionCallback<Object>(){

                public Object doInConnection(Connection con) throws SQLException, DataAccessException {
                    EmpireDaoSupport.this.database.open(EmpireDaoSupport.this.driver, con);
                    return null;
                }
            });
        }
        return (T)this.database;
    }

    public final DataSource getDataSource() {
        return this.empireTemplate != null ? this.empireTemplate.getJdbcTemplate().getDataSource() : null;
    }

    protected final Connection getConnection() throws CannotGetJdbcConnectionException {
        return DataSourceUtils.getConnection((DataSource)this.getDataSource());
    }

    protected final void releaseConnection(Connection con) {
        DataSourceUtils.releaseConnection((Connection)con, (DataSource)this.getDataSource());
    }
}

