/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.jsf2.pages;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.application.NavigationHandler;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBRowSet;
import org.apache.empire.exceptions.EmpireException;
import org.apache.empire.exceptions.InternalException;
import org.apache.empire.exceptions.ItemNotFoundException;
import org.apache.empire.exceptions.MiscellaneousErrorException;
import org.apache.empire.jsf2.app.FacesUtils;
import org.apache.empire.jsf2.app.TextResolver;
import org.apache.empire.jsf2.app.WebApplication;
import org.apache.empire.jsf2.pages.PageDefinition;
import org.apache.empire.jsf2.pages.PageElement;
import org.apache.empire.jsf2.pages.PageOutcome;
import org.apache.empire.jsf2.utils.ParameterMap;
import org.apache.empire.jsf2.utils.ParameterObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Page
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SESSION_MESSAGE = "PAGE_SESSION_MESSAGE";
    private static final Logger log = LoggerFactory.getLogger(Page.class);
    private String action = null;
    private boolean initialized = false;
    private PageDefinition pageDefinition = null;
    private List<PageElement> pageElements = null;

    protected Page() {
        if (log.isDebugEnabled()) {
            String name = this.getClass().getSimpleName();
            log.debug("PageBean {} created.", (Object)name);
        }
    }

    public String getPageName() {
        return this.pageDefinition != null ? this.pageDefinition.getPageBeanName() : "{" + this.getClass().getSimpleName() + "}";
    }

    public String getName() {
        String className = this.pageDefinition.getPageBeanClass().getName();
        int lastDot = className.lastIndexOf(".");
        String name = className.substring(lastDot + 1);
        return name;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public String getAction() {
        if (this.action == null) {
            return null;
        }
        ParameterMap pm = FacesUtils.getParameterMap(FacesUtils.getContext());
        String actionParam = pm != null ? pm.encodeString(this.action) : this.action;
        return actionParam;
    }

    public void setAction(String actionParam) {
        if (!this.initialized) {
            log.debug("Setting PageBean action {} for bean {}.", (Object)this.action, (Object)this.getPageName());
        } else {
            log.trace("Re-setting PageBeanAction {} for bean {}.", (Object)this.action, (Object)this.getPageName());
        }
        if (StringUtils.isEmpty((String)actionParam)) {
            return;
        }
        this.action = PageDefinition.decodeActionParam(actionParam);
        if (this.action == null) {
            throw new ItemNotFoundException((Object)actionParam);
        }
    }

    public PageDefinition getPageDefinition() {
        return this.pageDefinition;
    }

    public void setPageDefinition(PageDefinition pageDefinition) {
        this.pageDefinition = pageDefinition;
    }

    public PageDefinition getParentPage() {
        return this.pageDefinition.getParent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preRenderPage(FacesContext context) {
        if (this.initialized) {
            try {
                log.debug("PageBean {} is already initialized. Calling doRefresh().", (Object)this.getPageName());
                this.doRefresh();
            }
            catch (Exception e) {
                this.logAndHandleActionException("doRefresh", e);
            }
            return;
        }
        try {
            this.checkPageAccess();
            if (context.getResponseComplete()) {
                return;
            }
        }
        catch (Exception e) {
            this.logAndHandleActionException("checkAccess", e);
            if (context.getResponseComplete()) {
                return;
            }
            if (this.getParentPage() != null) {
                this.navigateTo(this.getParentOutcome(true));
            }
            return;
        }
        this.initialized = true;
        if (this.action != null && "null".equals(this.action)) {
            log.warn("Invalid action name 'null' for {}", (Object)this.getClass().getName());
            this.action = null;
        }
        if (this.action != null) {
            try {
                log.info("Processing action {} on {}.", (Object)String.valueOf(this.action), (Object)this.getPageName());
                Method method = this.getClass().getMethod(this.action, new Class[0]);
                Object result = method.invoke((Object)this, new Object[0]);
                if (result != null) {
                    String outcome = result.toString();
                    NavigationHandler navHandler = context.getApplication().getNavigationHandler();
                    navHandler.handleNavigation(context, this.action, outcome);
                    context.renderResponse();
                    return;
                }
                this.restoreSessionMessage();
            }
            catch (NoSuchMethodException nsme) {
                this.logAndHandleActionException(this.action, nsme);
            }
            catch (Exception e) {
                this.logAndHandleActionException(this.action, e.getCause());
            }
            finally {
                this.action = null;
            }
        } else {
            try {
                log.debug("Initializing PageBean {}. Calling doInit()", (Object)this.getPageName());
                this.doInit();
                this.restoreSessionMessage();
            }
            catch (Exception e) {
                this.logAndHandleActionException("doInit", e);
            }
        }
    }

    public boolean isHasMessages() {
        Iterator fmi = FacesContext.getCurrentInstance().getMessages();
        return fmi.hasNext();
    }

    protected void checkPageAccess() {
    }

    private void restoreSessionMessage() {
        ExternalContext ec = FacesContext.getCurrentInstance().getExternalContext();
        Map map = ec.getSessionMap();
        if (map.containsKey(SESSION_MESSAGE)) {
            FacesMessage errorMsg = (FacesMessage)map.get(SESSION_MESSAGE);
            FacesContext.getCurrentInstance().addMessage(this.getPageName(), errorMsg);
            map.remove(SESSION_MESSAGE);
        }
    }

    private void logAndHandleActionException(String action, Throwable e) {
        String msg = "Failed to perform action " + action + " on " + this.getPageName();
        log.error(msg, e);
        if (!this.handleActionError(action, e)) {
            if (e instanceof EmpireException) {
                throw (EmpireException)e;
            }
            throw new InternalException(e);
        }
    }

    protected void setSessionMessage(FacesMessage facesMsg) {
        ExternalContext ec = FacesContext.getCurrentInstance().getExternalContext();
        ec.getSessionMap().put(SESSION_MESSAGE, facesMsg);
    }

    protected boolean handleActionError(String action, Throwable e) {
        String msg = this.getErrorMessage(e);
        String detail = this.extractErrorMessageDetail(action, e, 1);
        log.error(msg + "\r\n" + detail);
        FacesMessage facesMsg = new FacesMessage(FacesMessage.SEVERITY_ERROR, msg, detail);
        this.setSessionMessage(facesMsg);
        PageDefinition parentPage = this.getParentPage();
        if (parentPage == null) {
            FacesContext.getCurrentInstance().addMessage(this.getPageName(), facesMsg);
            return false;
        }
        this.navigateTo(parentPage.getRedirect());
        return true;
    }

    protected void setErrorMessage(Throwable e) {
        String msg = this.getErrorMessage(e);
        String detail = this.extractErrorMessageDetail(this.action, e, 1);
        if (log.isDebugEnabled()) {
            log.debug(msg + "\r\n" + detail, e);
        }
        FacesMessage facesMsg = new FacesMessage(FacesMessage.SEVERITY_ERROR, msg, detail);
        FacesContext.getCurrentInstance().addMessage(this.getPageName(), facesMsg);
    }

    protected String getErrorMessage(Throwable e) {
        if (!(e instanceof EmpireException)) {
            e = new InternalException(e);
        }
        return this.getTextResolver().getExceptionMessage((Exception)e);
    }

    protected String extractErrorMessageDetail(String action, Throwable e, int stackTraceElements) {
        StringBuilder b = new StringBuilder();
        b.append("Error performing action '");
        b.append(action);
        b.append("' on page ");
        b.append(this.getPageName());
        b.append(": ");
        b.append(e.toString());
        b.append("\r\nat:");
        StackTraceElement[] stack = e.getStackTrace();
        int len = stack.length > stackTraceElements ? stackTraceElements : stack.length;
        for (int i = 0; i < len; ++i) {
            b.append(stack[i].toString());
            b.append("\r\n");
        }
        return b.toString();
    }

    protected void navigateTo(PageOutcome outcome) {
        if (log.isDebugEnabled()) {
            log.debug("Redirecting from page {} to page {}.", (Object)this.getPageName(), (Object)outcome.toString());
        }
        FacesContext context = FacesContext.getCurrentInstance();
        NavigationHandler navHandler = context.getApplication().getNavigationHandler();
        navHandler.handleNavigation(context, this.action, outcome.toString());
        context.renderResponse();
    }

    protected void registerPageElement(PageElement element) {
        if (this.pageElements == null) {
            this.pageElements = new ArrayList<PageElement>(1);
        }
        if (!this.pageElements.contains(element)) {
            this.pageElements.add(element);
        } else {
            log.warn("PageElement {} was registered twice!", (Object)element.getPropertyName());
        }
    }

    protected PageOutcome getParentOutcome(String action, boolean redirect) {
        PageDefinition parentPage = this.getParentPage();
        if (parentPage == null) {
            throw new MiscellaneousErrorException("No Parent Page defined for " + this.getPageName());
        }
        if (redirect) {
            return parentPage.getRedirect(action);
        }
        return parentPage.getOutcome(action);
    }

    protected PageOutcome getParentOutcome(boolean redirect) {
        return this.getParentOutcome(null, redirect);
    }

    public Connection getConnection(DBDatabase db) {
        WebApplication app = FacesUtils.getWebApplication();
        return app.getConnectionForRequest(FacesUtils.getContext(), db);
    }

    public <T extends ParameterObject> T getObjectFromParam(Class<T> paramType, String idParam) {
        FacesContext fc = FacesUtils.getContext();
        ParameterMap paramMap = FacesUtils.getParameterMap(fc);
        return paramMap.get(paramType, idParam);
    }

    public Object[] getKeyFromParam(DBRowSet rowset, String idParam) {
        FacesContext fc = FacesUtils.getContext();
        return FacesUtils.getParameterMap(fc).getKey(rowset, idParam);
    }

    public Object[] getKeyFromParam(PageDefinition page, DBRowSet rowset, String idParam) {
        FacesContext fc = FacesUtils.getContext();
        return FacesUtils.getParameterMap(fc).getKey(page, rowset, idParam);
    }

    public String getIdParamForKey(DBRowSet rowset, Object[] key) {
        FacesContext fc = FacesUtils.getContext();
        return FacesUtils.getParameterMap(fc).put(rowset, key);
    }

    public String getIdParamForKey(PageDefinition page, DBRowSet rowset, Object[] key) {
        FacesContext fc = FacesUtils.getContext();
        return FacesUtils.getParameterMap(fc).put(page, rowset, key);
    }

    public void addJavascriptCall(String function) {
        FacesContext fc = FacesUtils.getContext();
        WebApplication app = FacesUtils.getWebApplication();
        app.addJavascriptCall(fc, function);
    }

    public void addPageResource(String name, Object resource) {
        Map<String, Object> prm = FacesUtils.getPageResourceMap(FacesUtils.getContext());
        prm.put(name, this);
    }

    public Object getPageResource(String name) {
        Map<String, Object> prm = FacesUtils.getPageResourceMap(FacesUtils.getContext());
        return prm.get(name);
    }

    public void doInit() {
        if (this.pageElements != null) {
            for (PageElement pe : this.pageElements) {
                this.doInitElement(pe);
            }
        }
    }

    public void doRefresh() {
        if (this.pageElements != null) {
            for (PageElement pe : this.pageElements) {
                this.doRefreshElement(pe);
            }
        }
    }

    protected void doInitElement(PageElement pe) {
        pe.onInitPage();
    }

    protected void doRefreshElement(PageElement pe) {
        pe.onRefreshPage();
    }

    protected final TextResolver getTextResolver() {
        FacesContext fc = FacesUtils.getContext();
        return FacesUtils.getTextResolver(fc);
    }
}

