/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.jsf2.controls;

import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.html.HtmlInputTextarea;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseId;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.exceptions.UnexpectedReturnValueException;
import org.apache.empire.jsf2.controls.InputControl;
import org.apache.empire.jsf2.controls.InputControlManager;

public class TextAreaInputControl
extends InputControl {
    public static final String NAME = "textarea";
    public static final String FORMAT_COLS = "cols:";
    public static final String FORMAT_COLS_ATTRIBUTE = "format:cols";
    public static final String FORMAT_ROWS = "rows:";
    public static final String FORMAT_ROWS_ATTRIBUTE = "format:rows";
    private Class<? extends HtmlInputTextarea> inputComponentClass;

    public TextAreaInputControl(String name, Class<? extends HtmlInputTextarea> inputComponentClass) {
        super(name);
        this.inputComponentClass = inputComponentClass;
    }

    public TextAreaInputControl() {
        this(NAME, HtmlInputTextarea.class);
    }

    @Override
    protected void createInputComponents(UIComponent parent, InputControl.InputInfo ii, FacesContext context, List<UIComponent> compList) {
        int rows;
        if (!compList.isEmpty()) {
            throw new InvalidArgumentException("compList", compList);
        }
        HtmlInputTextarea input = InputControlManager.createComponent(context, this.inputComponentClass);
        this.copyAttributes(parent, ii, (UIInput)input);
        int cols = this.getFormatInteger(ii, FORMAT_COLS, FORMAT_COLS_ATTRIBUTE);
        if (cols > 0) {
            input.setCols(cols);
        }
        if ((rows = this.getFormatInteger(ii, FORMAT_ROWS, FORMAT_ROWS_ATTRIBUTE)) > 0) {
            input.setRows(rows);
        }
        compList.add((UIComponent)input);
        this.updateInputState(compList, ii, context, context.getCurrentPhaseId());
    }

    @Override
    protected void updateInputState(List<UIComponent> compList, InputControl.InputInfo ii, FacesContext context, PhaseId phaseId) {
        UIComponent comp = compList.get(0);
        if (!(comp instanceof HtmlInputTextarea)) {
            throw new UnexpectedReturnValueException((Object)comp.getClass().getName(), "compList.get(0)");
        }
        HtmlInputTextarea input = (HtmlInputTextarea)comp;
        Object dis = ii.getAttributeEx("disabled");
        if (dis != null) {
            input.setDisabled(ObjectUtils.getBoolean((Object)dis));
        }
        if (!ObjectUtils.getBoolean((Object)dis)) {
            input.setReadonly(ii.isFieldReadOnly());
        }
        if (phaseId == PhaseId.RENDER_RESPONSE) {
            this.addRemoveDisabledStyle((UIInput)input, input.isDisabled() || input.isReadonly());
            this.addRemoveInvalidStyle((UIInput)input, ii.hasError());
            this.setInputValue((UIInput)input, ii);
        }
    }

    @Override
    protected String formatValue(Object value, InputControl.ValueInfo vi) {
        String strVal = super.formatValue(value, vi);
        if (strVal.indexOf("\r\n") > 0) {
            strVal = StringUtils.replace((String)strVal, (String)"\r\n", (String)"<BR/>\n");
        } else if (strVal.indexOf(10) > 0) {
            strVal = StringUtils.replace((String)strVal, (String)"\n", (String)"<BR/>\n");
        }
        return strVal;
    }

    @Override
    protected Object parseInputValue(String value, InputControl.InputInfo ii) {
        if (!this.hasFormatOption(ii, "notrim")) {
            value = value.trim();
        }
        return value;
    }
}

