/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.jsf2.components;

import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import javax.el.ValueExpression;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.component.UIInput;
import javax.faces.component.html.HtmlSelectOneMenu;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.context.FacesContext;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.commons.Options;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.Column;
import org.apache.empire.exceptions.InvalidPropertyException;
import org.apache.empire.exceptions.NotSupportedException;
import org.apache.empire.jsf2.app.FacesUtils;
import org.apache.empire.jsf2.app.TextResolver;
import org.apache.empire.jsf2.controls.InputAttachedObjectsHandler;
import org.apache.empire.jsf2.controls.InputControl;
import org.apache.empire.jsf2.controls.InputControlManager;
import org.apache.empire.jsf2.controls.SelectInputControl;
import org.apache.empire.jsf2.utils.TagEncodingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectTag
extends UIInput
implements NamingContainer {
    private static final Logger log = LoggerFactory.getLogger(SelectTag.class);
    public static final String SELECT_COMPONENT_ID = "select";
    protected SelectInputControl control = null;
    private SelectInputInfo selectInputInfo = new SelectInputInfo();
    private String treeClientId = null;

    public SelectTag() {
        log.trace("component select created");
    }

    public String getFamily() {
        return "javax.faces.NamingContainer";
    }

    public boolean visitTree(VisitContext visitContext, VisitCallback callback) {
        FacesContext context = visitContext.getFacesContext();
        this.treeClientId = this.getClientId(context);
        return super.visitTree(visitContext, callback);
    }

    public String getClientId(FacesContext context) {
        if (this.treeClientId != null && this.control != null && this.control.isCreatingComponents()) {
            return this.treeClientId;
        }
        return super.getClientId(context);
    }

    public void encodeBegin(FacesContext context) throws IOException {
        UIInput inputComponent = null;
        TextResolver textResolver = FacesUtils.getTextResolver(context);
        if (this.getChildCount() > 0) {
            inputComponent = this.getInputComponent();
            if (inputComponent instanceof HtmlSelectOneMenu) {
                this.control = (SelectInputControl)InputControlManager.getControl(SELECT_COMPONENT_ID);
                boolean disabled = this.isDisabled();
                ((HtmlSelectOneMenu)inputComponent).setDisabled(disabled);
                this.control.syncOptions((HtmlSelectOneMenu)inputComponent, textResolver, this.selectInputInfo);
                this.setInputValue((HtmlSelectOneMenu)inputComponent);
            } else {
                log.warn("WARN: Unexpected child node for {}! Child item type is {}.", (Object)((Object)((Object)this)).getClass().getName(), (Object)inputComponent.getClass().getName());
                inputComponent = null;
            }
        }
        if (inputComponent == null) {
            inputComponent = this.createSelectOneMenu(textResolver);
            this.getChildren().add(0, inputComponent);
            this.addAttachedObjects(context, inputComponent);
        } else {
            this.updateAttachedObjects(context, inputComponent);
        }
        inputComponent.encodeAll(context);
        super.encodeBegin(context);
    }

    public void updateModel(FacesContext context) {
        if (!this.isDisabled()) {
            Object value;
            UIInput inputComponent = this.getInputComponent();
            Object object = value = inputComponent == null ? "" : inputComponent.getValue();
            if (value == null) {
                value = "";
            }
            this.setValue(value);
        }
        super.updateModel(context);
    }

    public void validate(FacesContext context) {
        UIInput inputComponent = this.getInputComponent();
        if (inputComponent == null) {
            return;
        }
        if (!inputComponent.isValid() || this.isDisabled()) {
            return;
        }
        super.validate(context);
    }

    protected UIInput getInputComponent() {
        if (this.getChildren().size() == 0) {
            return null;
        }
        return (UIInput)this.getChildren().get(0);
    }

    protected Options getOptionList() {
        Object options = this.getAttributes().get("options");
        if (!(options instanceof Options)) {
            return new Options();
        }
        return (Options)options;
    }

    protected boolean isAllowNull() {
        Object allowNull = this.getAttributes().get("allowNull");
        return ObjectUtils.getBoolean(allowNull);
    }

    protected String getNullText() {
        Object nullText = this.getAttributes().get("nullText");
        return StringUtils.toString(nullText, (String)"");
    }

    protected String getInputControl() {
        Object inputControl = this.getAttributes().get("inputControl");
        return StringUtils.toString(inputControl, (String)SELECT_COMPONENT_ID);
    }

    protected boolean isDisabled() {
        Object disabled = this.getAttributes().get("disabled");
        return ObjectUtils.getBoolean(disabled);
    }

    protected UIInput createSelectOneMenu(TextResolver textResolver) {
        InputControl inputControl = InputControlManager.getControl(this.getInputControl());
        if (inputControl == null || !(inputControl instanceof SelectInputControl)) {
            throw new InvalidPropertyException("inputControl", (Object)this.getInputControl());
        }
        this.control = (SelectInputControl)inputControl;
        HtmlSelectOneMenu input = this.control.createMenuComponent((UIComponent)this);
        String userStyle = StringUtils.toString(this.getAttributes().get("styleClass"));
        String cssStyle = TagEncodingHelper.assembleStyleClassString("eSelect", null, null, userStyle);
        input.setStyleClass(cssStyle);
        this.copyAttributes(input);
        input.setId(SELECT_COMPONENT_ID);
        this.control.initOptions(input, textResolver, this.selectInputInfo);
        boolean disabled = this.isDisabled();
        input.setDisabled(disabled);
        this.control.addRemoveDisabledStyle((UIInput)input, disabled);
        this.setInputValue(input);
        return input;
    }

    protected void setInputValue(HtmlSelectOneMenu input) {
        Object value = this.getValue();
        if (value != null) {
            value = value.getClass().isEnum() ? ((Enum)value).name() : String.valueOf(value);
        }
        input.setValue(value);
    }

    protected void copyAttributes(HtmlSelectOneMenu input) {
        Map attr;
        Object value;
        String inputId = this.getId();
        if (StringUtils.isNotEmpty((String)inputId)) {
            if (inputId.endsWith("_")) {
                inputId = inputId.substring(0, inputId.length() - 1);
            }
            input.setId(inputId);
        }
        if ((value = (attr = this.getAttributes()).get("style")) != null) {
            input.setStyle(StringUtils.toString(value));
        }
        if ((value = attr.get("tabindex")) != null) {
            input.setTabindex(StringUtils.toString(value));
        }
        if ((value = attr.get("onchange")) != null) {
            input.setOnchange(StringUtils.toString(value));
        }
    }

    protected void addAttachedObjects(FacesContext context, UIInput inputComponent) {
        InputAttachedObjectsHandler aoh = InputControlManager.getAttachedObjectsHandler();
        if (aoh != null) {
            aoh.addAttachedObjects((UIComponent)this, context, null, (UIComponentBase)inputComponent);
        }
    }

    protected void updateAttachedObjects(FacesContext context, UIInput inputComponent) {
        InputAttachedObjectsHandler aoh = InputControlManager.getAttachedObjectsHandler();
        if (aoh != null) {
            aoh.updateAttachedObjects((UIComponent)this, context, null, (UIComponentBase)inputComponent);
        }
    }

    private class SelectInputInfo
    implements InputControl.InputInfo {
        private SelectInputInfo() {
        }

        @Override
        public Column getColumn() {
            return null;
        }

        @Override
        public Options getOptions() {
            return SelectTag.this.getOptionList();
        }

        @Override
        public Object getValue(boolean evalExpression) {
            Object value = SelectTag.this.getValue();
            if (value != null) {
                value = value.getClass().isEnum() ? ((Enum)value).name() : String.valueOf(value);
            }
            return value;
        }

        @Override
        public String getFormat() {
            String nullText = SelectTag.this.getNullText();
            if (StringUtils.isEmpty((String)nullText)) {
                return null;
            }
            return "null:" + nullText;
        }

        @Override
        public Locale getLocale() {
            return null;
        }

        @Override
        public String getText(String key) {
            return null;
        }

        @Override
        public TextResolver getTextResolver() {
            return FacesUtils.getTextResolver(FacesContext.getCurrentInstance());
        }

        @Override
        public String getStyleClass(String addlStyle) {
            return null;
        }

        @Override
        public boolean isInsideUIData() {
            return false;
        }

        @Override
        public void setValue(Object value) {
            throw new NotSupportedException((Object)SelectTag.this, "setValue");
        }

        @Override
        public void validate(Object value) {
        }

        @Override
        public boolean isRequired() {
            return !SelectTag.this.isAllowNull();
        }

        @Override
        public boolean isModified() {
            Object modified = SelectTag.this.getAttributes().get("modified");
            return modified != null ? ObjectUtils.getBoolean(modified) : false;
        }

        @Override
        public boolean isDisabled() {
            return SelectTag.this.isDisabled();
        }

        @Override
        public boolean isFieldReadOnly() {
            return false;
        }

        @Override
        public String getInputId() {
            return SelectTag.SELECT_COMPONENT_ID;
        }

        @Override
        public boolean hasError() {
            return false;
        }

        @Override
        public Object getAttribute(String name) {
            return null;
        }

        @Override
        public Object getAttributeEx(String name) {
            ValueExpression ve;
            Object value = SelectTag.this.getAttributes().get(name);
            if (value == null && (ve = SelectTag.this.getValueExpression(name)) != null) {
                FacesContext ctx = FacesContext.getCurrentInstance();
                value = ve.getValue(ctx.getELContext());
            }
            return value;
        }
    }
}

