/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.struts2.jsp.components;

import com.opensymphony.xwork2.util.ValueStack;
import java.io.StringWriter;
import java.io.Writer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.empire.struts2.html.HtmlTagDictionary;
import org.apache.empire.struts2.html.HtmlWriter;
import org.apache.struts2.components.Anchor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnchorComponent
extends Anchor {
    protected static Logger log = LoggerFactory.getLogger(AnchorComponent.class);
    private String text;
    private String target;
    private boolean disabled = false;
    private String disabledTag = null;

    public AnchorComponent(ValueStack stack, HttpServletRequest req, HttpServletResponse res) {
        super(stack, req, res);
    }

    public String getUrl() {
        StringWriter sw = new StringWriter();
        this.urlRenderer.beforeRenderUrl(this.urlProvider);
        this.urlRenderer.renderUrl((Writer)sw, this.urlProvider);
        return sw.toString();
    }

    public boolean usesBody() {
        return true;
    }

    public boolean start(Writer writer) {
        this.processingTagBody = true;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean end(Writer writer, String body) {
        try {
            if (writer == null) {
                boolean bl = false;
                return bl;
            }
            HtmlWriter htmlWriter = new HtmlWriter(writer);
            if (!this.disabled) {
                String url = this.getUrl();
                HtmlWriter.HtmlTag a = htmlWriter.startTag("a");
                a.addAttribute("id", this.getId());
                a.addAttribute("href", url);
                a.addAttribute("target", this.target);
                a.addAttribute("class", this.cssClass);
                a.addAttribute("style", this.cssStyle);
                a.addAttribute("onclick", this.onclick);
                a.beginBody(this.text);
                a.endTag(body);
            } else {
                HtmlTagDictionary dic = HtmlTagDictionary.getInstance();
                if (this.disabledTag == null) {
                    this.disabledTag = dic.AnchorDisabledTag();
                }
                if (this.cssClass == null) {
                    this.cssClass = dic.AnchorDisabledClass();
                }
                HtmlWriter.HtmlTag s = htmlWriter.startTag(this.disabledTag);
                s.addAttribute("class", this.cssClass);
                s.addAttribute("style", this.cssStyle);
                s.beginBody(this.text);
                s.endTag(body);
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            log.error("error when rendering", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.popComponentStack();
        }
    }

    public void setUrlType(String urlType) {
        if (urlType != null) {
            this.urlProvider.setPortletUrlType(urlType);
        }
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public void setDisabledTag(String disabledTag) {
        this.disabledTag = disabledTag;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }
}

