/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.alibaba.dubbo.rpc.cluster;

import org.apache.dubbo.common.URL;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.RpcException;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@Deprecated
public interface Router extends org.apache.dubbo.rpc.cluster.Router{

    @Override
    com.alibaba.dubbo.common.URL getUrl();

    <T> List<com.alibaba.dubbo.rpc.Invoker<T>> route(List<com.alibaba.dubbo.rpc.Invoker<T>> invokers,
                                                     com.alibaba.dubbo.common.URL url,
                                                     com.alibaba.dubbo.rpc.Invocation invocation)
            throws com.alibaba.dubbo.rpc.RpcException;

    int compareTo(Router o);

    // Add since 2.7.0
    @Override
    default <T> List<Invoker<T>> route(List<Invoker<T>> invokers, URL url, Invocation invocation) throws RpcException {
        List<com.alibaba.dubbo.rpc.Invoker<T>> invs = invokers.stream().map(invoker -> new com.alibaba.dubbo.rpc.Invoker.CompatibleInvoker<T>(invoker)).
                collect(Collectors.toList());

        List<com.alibaba.dubbo.rpc.Invoker<T>> res = this.route(invs, new com.alibaba.dubbo.common.DelegateURL(url), new com.alibaba.dubbo.rpc.Invocation.CompatibleInvocation(invocation));

        return res.stream().map(inv -> inv.getOriginal()).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    default boolean isRuntime() {
        return true;
    }

    @Override
    default boolean isForce() {
        return false;
    }

    @Override
    default int getPriority() {
        return 1;
    }

    @Override
    default int compareTo (org.apache.dubbo.rpc.cluster.Router o) {
        if (!(o instanceof Router)) {
            return 1;
        }

        return this.compareTo((Router)o);
    }
}
