/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.alibaba.dubbo.rpc;

@Deprecated
public interface Exporter<T> extends org.apache.dubbo.rpc.Exporter<T> {

    @Override
    Invoker<T> getInvoker();

    default void register() {}

    default void unregister() {}

    class CompatibleExporter<T> implements Exporter<T> {

        private org.apache.dubbo.rpc.Exporter<T> delegate;

        public CompatibleExporter(org.apache.dubbo.rpc.Exporter<T> delegate) {
            this.delegate = delegate;
        }

        @Override
        public Invoker<T> getInvoker() {
            return new Invoker.CompatibleInvoker<>(delegate.getInvoker());
        }

        @Override
        public void unexport() {
            delegate.unexport();
        }

        @Override
        public void register() {
            delegate.register();
        }

        @Override
        public void unregister() {
            delegate.unregister();
        }
    }
}
