/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// This file is auto generated and should not be modified

// prettier-ignore
exports.SQL_DATA_TYPES = [
  [
    "CHAR",
    "STRING",
    ""
  ],
  [
    "VARCHAR",
    "STRING",
    "Druid STRING columns are reported as VARCHAR. Can include multi-value strings as well."
  ],
  [
    "DECIMAL",
    "DOUBLE",
    "DECIMAL uses floating point, not fixed point math"
  ],
  [
    "FLOAT",
    "FLOAT",
    "Druid FLOAT columns are reported as FLOAT"
  ],
  [
    "REAL",
    "DOUBLE",
    ""
  ],
  [
    "DOUBLE",
    "DOUBLE",
    "Druid DOUBLE columns are reported as DOUBLE"
  ],
  [
    "BOOLEAN",
    "LONG",
    ""
  ],
  [
    "TINYINT",
    "LONG",
    ""
  ],
  [
    "SMALLINT",
    "LONG",
    ""
  ],
  [
    "INTEGER",
    "LONG",
    ""
  ],
  [
    "BIGINT",
    "LONG",
    "Druid LONG columns (except `__time`) are reported as BIGINT"
  ],
  [
    "TIMESTAMP",
    "LONG",
    "Druid's `__time` column is reported as TIMESTAMP. Casts between string and timestamp types assume standard SQL formatting, e.g. `2000-01-02 03:04:05`, _not_ ISO8601 formatting. For handling other formats, use one of the time functions"
  ],
  [
    "DATE",
    "LONG",
    "Casting TIMESTAMP to DATE rounds down the timestamp to the nearest day. Casts between string and date types assume standard SQL formatting, e.g. `2000-01-02`. For handling other formats, use one of the time functions"
  ],
  [
    "OTHER",
    "COMPLEX",
    "May represent various Druid column types such as hyperUnique, approxHistogram, etc"
  ]
];

// prettier-ignore
exports.SQL_FUNCTIONS = [
  [
    "COUNT",
    "*",
    "Counts the number of rows."
  ],
  [
    "COUNT",
    "DISTINCT expr",
    "Counts distinct values of expr, which can be string, numeric, or hyperUnique. By default this is approximate, using a variant of HyperLogLog. To get exact counts set \"useApproximateCountDistinct\" to \"false\". If you do this, expr must be string or numeric, since exact counts are not possible using hyperUnique columns. See also APPROX_COUNT_DISTINCT(expr). In exact mode, only one distinct count per query is permitted unless useGroupingSetForExactDistinct is set to true in query contexts or broker configurations."
  ],
  [
    "SUM",
    "expr",
    "Sums numbers."
  ],
  [
    "MIN",
    "expr",
    "Takes the minimum of numbers."
  ],
  [
    "MAX",
    "expr",
    "Takes the maximum of numbers."
  ],
  [
    "AVG",
    "expr",
    "Averages numbers."
  ],
  [
    "APPROX_COUNT_DISTINCT",
    "expr",
    "_Usage note:_ consider using APPROX_COUNT_DISTINCT_DS_HLL instead, which offers better accuracy in many cases.<br/><br/>Counts distinct values of expr, which can be a regular column or a hyperUnique column. This is always approximate, regardless of the value of \"useApproximateCountDistinct\". This uses Druid's built-in \"cardinality\" or \"hyperUnique\" aggregators. See also COUNT(DISTINCT expr)."
  ],
  [
    "APPROX_COUNT_DISTINCT_DS_HLL",
    "expr, [lgK, tgtHllType]",
    "Counts distinct values of expr, which can be a regular column or an HLL sketch column. Results are always approximate, regardless of the value of useApproximateCountDistinct. The lgK and tgtHllType parameters here are, like the equivalents in the aggregator, described in the HLL sketch documentation. The DataSketches extension must be loaded to use this function.   See also COUNT(DISTINCT expr).  "
  ],
  [
    "APPROX_COUNT_DISTINCT_DS_THETA",
    "expr, [size]",
    "Counts distinct values of expr, which can be a regular column or a Theta sketch column. This is always approximate, regardless of the value of useApproximateCountDistinct.  The size parameter is described in the Theta sketch documentation. The DataSketches extension must be loaded to use this function. See also COUNT(DISTINCT expr). "
  ],
  [
    "DS_HLL",
    "expr, [lgK, tgtHllType]",
    "Creates an HLL sketch on the values of expr, which can be a regular column or a column containing HLL sketches. The lgK and tgtHllType parameters are described in the HLL sketch documentation. The DataSketches extension must be loaded to use this function."
  ],
  [
    "DS_THETA",
    "expr, [size]",
    "Creates a Theta sketch on the values of expr, which can be a regular column or a column containing Theta sketches. The size parameter is described in the Theta sketch documentation. The DataSketches extension must be loaded to use this function."
  ],
  [
    "APPROX_QUANTILE",
    "expr, probability, [resolution]",
    "_Deprecated._ Use APPROX_QUANTILE_DS instead, which provides a superior distribution-independent algorithm with formal error guarantees.<br/><br/>Computes approximate quantiles on numeric or approxHistogram exprs. The \"probability\" should be between 0 and 1 (exclusive). The \"resolution\" is the number of centroids to use for the computation. Higher resolutions will give more precise results but also have higher overhead. If not provided, the default resolution is 50. The approximate histogram extension must be loaded to use this function."
  ],
  [
    "APPROX_QUANTILE_DS",
    "expr, probability, [k]",
    "Computes approximate quantiles on numeric or Quantiles sketch exprs. Allowable \"probability\" values are between 0 and 1, exclusive. The k parameter is described in the Quantiles sketch documentation. You must load DataSketches extension to use this function.<br/><br/>See the known issue with this function."
  ],
  [
    "APPROX_QUANTILE_FIXED_BUCKETS",
    "expr, probability, numBuckets, lowerLimit, upperLimit, [outlierHandlingMode]",
    "Computes approximate quantiles on numeric or fixed buckets histogram exprs. The \"probability\" should be between 0 and 1 (exclusive). The numBuckets, lowerLimit, upperLimit, and outlierHandlingMode parameters are described in the fixed buckets histogram documentation. The approximate histogram extension must be loaded to use this function."
  ],
  [
    "DS_QUANTILES_SKETCH",
    "expr, [k]",
    "Creates a Quantiles sketch on the values of expr, which can be a regular column or a column containing quantiles sketches. The k parameter is described in the Quantiles sketch documentation. You must load the DataSketches extension to use this function.<br/><br/>See the known issue with this function."
  ],
  [
    "BLOOM_FILTER",
    "expr, numEntries",
    "Computes a bloom filter from values produced by expr, with numEntries maximum number of distinct values before false positive rate increases. See bloom filter extension documentation for additional details."
  ],
  [
    "TDIGEST_QUANTILE",
    "expr, quantileFraction, [compression]",
    "Builds a T-Digest sketch on values produced by expr and returns the value for the quantile. Compression parameter (default value 100) determines the accuracy and size of the sketch. Higher compression means higher accuracy but more space to store sketches. See t-digest extension documentation for additional details."
  ],
  [
    "TDIGEST_GENERATE_SKETCH",
    "expr, [compression]",
    "Builds a T-Digest sketch on values produced by expr. Compression parameter (default value 100) determines the accuracy and size of the sketch Higher compression means higher accuracy but more space to store sketches. See t-digest extension documentation for additional details."
  ],
  [
    "VAR_POP",
    "expr",
    "Computes variance population of expr. See stats extension documentation for additional details."
  ],
  [
    "VAR_SAMP",
    "expr",
    "Computes variance sample of expr. See stats extension documentation for additional details."
  ],
  [
    "VARIANCE",
    "expr",
    "Computes variance sample of expr. See stats extension documentation for additional details."
  ],
  [
    "STDDEV_POP",
    "expr",
    "Computes standard deviation population of expr. See stats extension documentation for additional details."
  ],
  [
    "STDDEV_SAMP",
    "expr",
    "Computes standard deviation sample of expr. See stats extension documentation for additional details."
  ],
  [
    "STDDEV",
    "expr",
    "Computes standard deviation sample of expr. See stats extension documentation for additional details."
  ],
  [
    "EARLIEST",
    "expr",
    "Returns the earliest value of expr, which must be numeric. If expr comes from a relation with a timestamp column (like a Druid datasource) then \"earliest\" is the value first encountered with the minimum overall timestamp of all values being aggregated. If expr does not come from a relation with a timestamp, then it is simply the first value encountered."
  ],
  [
    "EARLIEST",
    "expr, maxBytesPerString",
    "Like EARLIEST(expr), but for strings. The maxBytesPerString parameter determines how much aggregation space to allocate per string. Strings longer than this limit will be truncated. This parameter should be set as low as possible, since high values will lead to wasted memory."
  ],
  [
    "LATEST",
    "expr",
    "Returns the latest value of expr, which must be numeric. If expr comes from a relation with a timestamp column (like a Druid datasource) then \"latest\" is the value last encountered with the maximum overall timestamp of all values being aggregated. If expr does not come from a relation with a timestamp, then it is simply the last value encountered."
  ],
  [
    "LATEST",
    "expr, maxBytesPerString",
    "Like LATEST(expr), but for strings. The maxBytesPerString parameter determines how much aggregation space to allocate per string. Strings longer than this limit will be truncated. This parameter should be set as low as possible, since high values will lead to wasted memory."
  ],
  [
    "ANY_VALUE",
    "expr",
    "Returns any value of expr including null. expr must be numeric. This aggregator can simplify and optimize the performance by returning the first encountered value (including null)"
  ],
  [
    "ANY_VALUE",
    "expr, maxBytesPerString",
    "Like ANY_VALUE(expr), but for strings. The maxBytesPerString parameter determines how much aggregation space to allocate per string. Strings longer than this limit will be truncated. This parameter should be set as low as possible, since high values will lead to wasted memory."
  ],
  [
    "GROUPING",
    "expr, expr...",
    "Returns a number to indicate which groupBy dimension is included in a row, when using GROUPING SETS. Refer to additional documentation on how to infer this number."
  ],
  [
    "ARRAY_AGG",
    "expr, [size]",
    "Collects all values of expr into an ARRAY, including null values, with size in bytes limit on aggregation size (default of 1024 bytes). If the aggregated array grows larger than the maximum size in bytes, the query will fail. Use of ORDER BY within the ARRAY_AGG expression is not currently supported, and the ordering of results within the output array may vary depending on processing order."
  ],
  [
    "ARRAY_AGG",
    "DISTINCT expr, [size]",
    "Collects all distinct values of expr into an ARRAY, including null values, with size in bytes limit on aggregation size (default of 1024 bytes) per aggregate. If the aggregated array grows larger than the maximum size in bytes, the query will fail. Use of ORDER BY within the ARRAY_AGG expression is not currently supported, and the ordering of results within the output array may vary depending on processing order."
  ],
  [
    "STRING_AGG",
    "expr, separator, [size]",
    "Collects all values of expr into a single STRING, ignoring null values. Each value is joined by the separator which must be a literal STRING. An optional size in bytes can be supplied to limit aggregation size (default of 1024 bytes). If the aggregated string grows larger than the maximum size in bytes, the query will fail. Use of ORDER BY within the STRING_AGG expression is not currently supported, and the ordering of results within the output string may vary depending on processing order."
  ],
  [
    "STRING_AGG",
    "DISTINCT expr, separator, [size]",
    "Collects all distinct values of expr into a single STRING, ignoring null values. Each value is joined by the separator which must be a literal STRING. An optional size in bytes can be supplied to limit aggregation size (default of 1024 bytes). If the aggregated string grows larger than the maximum size in bytes, the query will fail. Use of ORDER BY within the STRING_AGG expression is not currently supported, and the ordering of results within the output string may vary depending on processing order."
  ],
  [
    "BIT_AND",
    "expr",
    "Performs a bitwise AND operation on all input values."
  ],
  [
    "BIT_OR",
    "expr",
    "Performs a bitwise OR operation on all input values."
  ],
  [
    "BIT_XOR",
    "expr",
    "Performs a bitwise XOR operation on all input values."
  ],
  [
    "ABS",
    "expr",
    "Absolute value."
  ],
  [
    "CEIL",
    "expr",
    "Ceiling."
  ],
  [
    "EXP",
    "expr",
    "e to the power of expr."
  ],
  [
    "FLOOR",
    "expr",
    "Floor."
  ],
  [
    "LN",
    "expr",
    "Logarithm (base e)."
  ],
  [
    "LOG10",
    "expr",
    "Logarithm (base 10)."
  ],
  [
    "POWER",
    "expr, power",
    "expr to a power."
  ],
  [
    "SQRT",
    "expr",
    "Square root."
  ],
  [
    "TRUNCATE",
    "expr[, digits]",
    "Truncate expr to a specific number of decimal digits. If digits is negative, then this truncates that many places to the left of the decimal point. Digits defaults to zero if not specified."
  ],
  [
    "TRUNC",
    "expr[, digits]",
    "Synonym for TRUNCATE."
  ],
  [
    "ROUND",
    "expr[, digits]",
    "ROUND(x, y) would return the value of the x rounded to the y decimal places. While x can be an integer or floating-point number, y must be an integer. The type of the return value is specified by that of x. y defaults to 0 if omitted. When y is negative, x is rounded on the left side of the y decimal points. If expr evaluates to either NaN, expr will be converted to 0. If expr is infinity, expr will be converted to the nearest finite double. "
  ],
  [
    "MOD",
    "x, y",
    "Modulo (remainder of x divided by y)."
  ],
  [
    "SIN",
    "expr",
    "Trigonometric sine of an angle expr."
  ],
  [
    "COS",
    "expr",
    "Trigonometric cosine of an angle expr."
  ],
  [
    "TAN",
    "expr",
    "Trigonometric tangent of an angle expr."
  ],
  [
    "COT",
    "expr",
    "Trigonometric cotangent of an angle expr."
  ],
  [
    "ASIN",
    "expr",
    "Arc sine of expr."
  ],
  [
    "ACOS",
    "expr",
    "Arc cosine of expr."
  ],
  [
    "ATAN",
    "expr",
    "Arc tangent of expr."
  ],
  [
    "ATAN2",
    "y, x",
    "Angle theta from the conversion of rectangular coordinates (x, y) to polar * coordinates (r, theta)."
  ],
  [
    "DEGREES",
    "expr",
    "Converts an angle measured in radians to an approximately equivalent angle measured in degrees"
  ],
  [
    "RADIANS",
    "expr",
    "Converts an angle measured in degrees to an approximately equivalent angle measured in radians"
  ],
  [
    "BITWISE_AND",
    "expr1, expr2",
    "Returns the result of expr1 & expr2. Double values will be implicitly cast to longs, use BITWISE_CONVERT_DOUBLE_TO_LONG_BITS to perform bitwise operations directly with doubles"
  ],
  [
    "BITWISE_COMPLEMENT",
    "expr",
    "Returns the result of ~expr. Double values will be implicitly cast to longs, use BITWISE_CONVERT_DOUBLE_TO_LONG_BITS to perform bitwise operations directly with doubles"
  ],
  [
    "BITWISE_CONVERT_DOUBLE_TO_LONG_BITS",
    "expr",
    "Converts the bits of an IEEE 754 floating-point double value to a long. If the input is not a double, it is implicitly cast to a double prior to conversion"
  ],
  [
    "BITWISE_CONVERT_LONG_BITS_TO_DOUBLE",
    "expr",
    "Converts a long to the IEEE 754 floating-point double specified by the bits stored in the long. If the input is not a long, it is implicitly cast to a long prior to conversion"
  ],
  [
    "BITWISE_OR",
    "expr1, expr2",
    "Returns the result of expr1 [PIPE] expr2. Double values will be implicitly cast to longs, use BITWISE_CONVERT_DOUBLE_TO_LONG_BITS to perform bitwise operations directly with doubles"
  ],
  [
    "BITWISE_SHIFT_LEFT",
    "expr1, expr2",
    "Returns the result of expr1 << expr2. Double values will be implicitly cast to longs, use BITWISE_CONVERT_DOUBLE_TO_LONG_BITS to perform bitwise operations directly with doubles"
  ],
  [
    "BITWISE_SHIFT_RIGHT",
    "expr1, expr2",
    "Returns the result of expr1 >> expr2. Double values will be implicitly cast to longs, use BITWISE_CONVERT_DOUBLE_TO_LONG_BITS to perform bitwise operations directly with doubles"
  ],
  [
    "BITWISE_XOR",
    "expr1, expr2",
    "Returns the result of expr1 ^ expr2. Double values will be implicitly cast to longs, use BITWISE_CONVERT_DOUBLE_TO_LONG_BITS to perform bitwise operations directly with doubles"
  ],
  [
    "HUMAN_READABLE_BINARY_BYTE_FORMAT",
    "value[, precision]",
    " Format a number in human-readable IEC format. For example, HUMAN_READABLE_BINARY_BYTE_FORMAT(1048576) returns 1.00 MiB. precision must be in the range of [0,3] (default: 2). "
  ],
  [
    "HUMAN_READABLE_DECIMAL_BYTE_FORMAT",
    "value[, precision]",
    " Format a number in human-readable SI format. HUMAN_READABLE_DECIMAL_BYTE_FORMAT(1048576) returns 1.04 MB. precision must be in the range of [0,3] (default: 2). precision must be in the range of [0,3] (default: 2). "
  ],
  [
    "HUMAN_READABLE_DECIMAL_FORMAT",
    "value[, precision]",
    " Format a number in human-readable SI format. For example, HUMAN_READABLE_DECIMAL_FORMAT(1048576) returns 1.04 M. precision must be in the range of [0,3] (default: 2). "
  ],
  [
    "CONCAT",
    "expr, expr...",
    "Concats a list of expressions."
  ],
  [
    "TEXTCAT",
    "expr, expr",
    "Two argument version of CONCAT."
  ],
  [
    "STRING_FORMAT",
    "pattern[, args...]",
    "Returns a string formatted in the manner of Java's String.format."
  ],
  [
    "LENGTH",
    "expr",
    "Length of expr in UTF-16 code units."
  ],
  [
    "CHAR_LENGTH",
    "expr",
    "Synonym for LENGTH."
  ],
  [
    "CHARACTER_LENGTH",
    "expr",
    "Synonym for LENGTH."
  ],
  [
    "STRLEN",
    "expr",
    "Synonym for LENGTH."
  ],
  [
    "LOOKUP",
    "expr, lookupName",
    "Look up expr in a registered query-time lookup table. Note that lookups can also be queried directly using the lookup schema."
  ],
  [
    "LOWER",
    "expr",
    "Returns expr in all lowercase."
  ],
  [
    "PARSE_LONG",
    "string[, radix]",
    "Parses a string into a long (BIGINT) with the given radix, or 10 (decimal) if a radix is not provided."
  ],
  [
    "POSITION",
    "needle IN haystack [FROM fromIndex]",
    "Returns the index of needle within haystack, with indexes starting from 1. The search will begin at fromIndex, or 1 if fromIndex is not specified. If the needle is not found, returns 0."
  ],
  [
    "REGEXP_EXTRACT",
    "expr, pattern, [index]",
    "Apply regular expression pattern to expr and extract a capture group, or NULL if there is no match. If index is unspecified or zero, returns the first substring that matched the pattern. The pattern may match anywhere inside expr; if you want to match the entire string instead, use the ^ and $ markers at the start and end of your pattern. Note: when druid.generic.useDefaultValueForNull = true, it is not possible to differentiate an empty-string match from a non-match (both will return NULL)."
  ],
  [
    "REGEXP_LIKE",
    "expr, pattern",
    "Returns whether expr matches regular expression pattern. The pattern may match anywhere inside expr; if you want to match the entire string instead, use the ^ and $ markers at the start and end of your pattern. Similar to LIKE, but uses regexps instead of LIKE patterns. Especially useful in WHERE clauses."
  ],
  [
    "CONTAINS_STRING",
    "<expr>, str",
    "Returns true if the str is a substring of expr."
  ],
  [
    "ICONTAINS_STRING",
    "<expr>, str",
    "Returns true if the str is a substring of expr. The match is case-insensitive."
  ],
  [
    "REPLACE",
    "expr, pattern, replacement",
    "Replaces pattern with replacement in expr, and returns the result."
  ],
  [
    "STRPOS",
    "haystack, needle",
    "Returns the index of needle within haystack, with indexes starting from 1. If the needle is not found, returns 0."
  ],
  [
    "SUBSTRING",
    "expr, index, [length]",
    "Returns a substring of expr starting at index, with a max length, both measured in UTF-16 code units."
  ],
  [
    "RIGHT",
    "expr, [length]",
    "Returns the rightmost length characters from expr."
  ],
  [
    "LEFT",
    "expr, [length]",
    "Returns the leftmost length characters from expr."
  ],
  [
    "SUBSTR",
    "expr, index, [length]",
    "Synonym for SUBSTRING."
  ],
  [
    "TRIM",
    "[BOTH <code>&#124;</code> LEADING <code>&#124;</code> TRAILING] [<chars> FROM] expr",
    "Returns expr with characters removed from the leading, trailing, or both ends of \"expr\" if they are in \"chars\". If \"chars\" is not provided, it defaults to \" \" (a space). If the directional argument is not provided, it defaults to \"BOTH\"."
  ],
  [
    "BTRIM",
    "expr[, chars]",
    "Alternate form of TRIM(BOTH <chars> FROM <expr>)."
  ],
  [
    "LTRIM",
    "expr[, chars]",
    "Alternate form of TRIM(LEADING <chars> FROM <expr>)."
  ],
  [
    "RTRIM",
    "expr[, chars]",
    "Alternate form of TRIM(TRAILING <chars> FROM <expr>)."
  ],
  [
    "UPPER",
    "expr",
    "Returns expr in all uppercase."
  ],
  [
    "REVERSE",
    "expr",
    "Reverses expr."
  ],
  [
    "REPEAT",
    "expr, [N]",
    "Repeats expr N times"
  ],
  [
    "LPAD",
    "expr, length[, chars]",
    "Returns a string of length from expr left-padded with chars. If length is shorter than the length of expr, the result is expr which is truncated to length. The result will be null if either expr or chars is null. If chars is an empty string, no padding is added, however expr may be trimmed if necessary."
  ],
  [
    "RPAD",
    "expr, length[, chars]",
    "Returns a string of length from expr right-padded with chars. If length is shorter than the length of expr, the result is expr which is truncated to length. The result will be null if either expr or chars is null. If chars is an empty string, no padding is added, however expr may be trimmed if necessary."
  ],
  [
    "DATE_TRUNC",
    "<unit>, <timestamp_expr>",
    "Rounds down a timestamp, returning it as a new timestamp. Unit can be 'milliseconds', 'second', 'minute', 'hour', 'day', 'week', 'month', 'quarter', 'year', 'decade', 'century', or 'millennium'."
  ],
  [
    "TIME_CEIL",
    "<timestamp_expr>, <period>, [<origin>, [<timezone>]]",
    "Rounds up a timestamp, returning it as a new timestamp. Period can be any ISO8601 period, like P3M (quarters) or PT12H (half-days). The time zone, if provided, should be a time zone name like \"America/Los_Angeles\" or offset like \"-08:00\". This function is similar to CEIL but is more flexible."
  ],
  [
    "TIME_FLOOR",
    "<timestamp_expr>, <period>, [<origin>, [<timezone>]]",
    "Rounds down a timestamp, returning it as a new timestamp. Period can be any ISO8601 period, like P3M (quarters) or PT12H (half-days). The time zone, if provided, should be a time zone name like \"America/Los_Angeles\" or offset like \"-08:00\". This function is similar to FLOOR but is more flexible."
  ],
  [
    "TIME_SHIFT",
    "<timestamp_expr>, <period>, <step>, [<timezone>]",
    "Shifts a timestamp by a period (step times), returning it as a new timestamp. Period can be any ISO8601 period. Step may be negative. The time zone, if provided, should be a time zone name like \"America/Los_Angeles\" or offset like \"-08:00\"."
  ],
  [
    "TIME_EXTRACT",
    "<timestamp_expr>, [<unit>, [<timezone>]]",
    "Extracts a time part from expr, returning it as a number. Unit can be EPOCH, SECOND, MINUTE, HOUR, DAY (day of month), DOW (day of week), DOY (day of year), WEEK (week of week year), MONTH (1 through 12), QUARTER (1 through 4), or YEAR. The time zone, if provided, should be a time zone name like \"America/Los_Angeles\" or offset like \"-08:00\". This function is similar to EXTRACT but is more flexible. Unit and time zone must be literals, and must be provided quoted, like TIME_EXTRACT(__time, 'HOUR') or TIME_EXTRACT(__time, 'HOUR', 'America/Los_Angeles')."
  ],
  [
    "TIME_PARSE",
    "<string_expr>, [<pattern>, [<timezone>]]",
    "Parses a string into a timestamp using a given Joda DateTimeFormat pattern, or ISO8601 (e.g. 2000-01-02T03:04:05Z) if the pattern is not provided. The time zone, if provided, should be a time zone name like \"America/Los_Angeles\" or offset like \"-08:00\", and will be used as the time zone for strings that do not include a time zone offset. Pattern and time zone must be literals. Strings that cannot be parsed as timestamps will be returned as NULL."
  ],
  [
    "TIME_FORMAT",
    "<timestamp_expr>, [<pattern>, [<timezone>]]",
    "Formats a timestamp as a string with a given Joda DateTimeFormat pattern, or ISO8601 (e.g. 2000-01-02T03:04:05Z) if the pattern is not provided. The time zone, if provided, should be a time zone name like \"America/Los_Angeles\" or offset like \"-08:00\". Pattern and time zone must be literals."
  ],
  [
    "MILLIS_TO_TIMESTAMP",
    "millis_expr",
    "Converts a number of milliseconds since the epoch into a timestamp."
  ],
  [
    "TIMESTAMP_TO_MILLIS",
    "timestamp_expr",
    "Converts a timestamp into a number of milliseconds since the epoch."
  ],
  [
    "EXTRACT",
    "<unit> FROM timestamp_expr",
    "Extracts a time part from expr, returning it as a number. Unit can be EPOCH, MICROSECOND, MILLISECOND, SECOND, MINUTE, HOUR, DAY (day of month), DOW (day of week), ISODOW (ISO day of week), DOY (day of year), WEEK (week of year), MONTH, QUARTER, YEAR, ISOYEAR, DECADE, CENTURY or MILLENNIUM. Units must be provided unquoted, like EXTRACT(HOUR FROM __time)."
  ],
  [
    "FLOOR",
    "timestamp_expr TO <unit>",
    "Rounds down a timestamp, returning it as a new timestamp. Unit can be SECOND, MINUTE, HOUR, DAY, WEEK, MONTH, QUARTER, or YEAR."
  ],
  [
    "CEIL",
    "timestamp_expr TO <unit>",
    "Rounds up a timestamp, returning it as a new timestamp. Unit can be SECOND, MINUTE, HOUR, DAY, WEEK, MONTH, QUARTER, or YEAR."
  ],
  [
    "TIMESTAMPADD",
    "<unit>, <count>, <timestamp>",
    "Equivalent to timestamp + count * INTERVAL '1' UNIT."
  ],
  [
    "TIMESTAMPDIFF",
    "<unit>, <timestamp1>, <timestamp2>",
    "Returns the (signed) number of unit between timestamp1 and timestamp2. Unit can be SECOND, MINUTE, HOUR, DAY, WEEK, MONTH, QUARTER, or YEAR."
  ],
  [
    "GREATEST",
    "[expr1, ...]",
    "Evaluates zero or more expressions and returns the maximum value based on comparisons as described above."
  ],
  [
    "LEAST",
    "[expr1, ...]",
    "Evaluates zero or more expressions and returns the minimum value based on comparisons as described above."
  ],
  [
    "IPV4_MATCH",
    "address, subnet",
    "Returns true if the address belongs to the subnet literal, else false. If address is not a valid IPv4 address, then false is returned. This function is more efficient if address is an integer instead of a string."
  ],
  [
    "IPV4_PARSE",
    "address",
    "Parses address into an IPv4 address stored as an integer . If address is an integer that is a valid IPv4 address, then it is passed through. Returns null if address cannot be represented as an IPv4 address."
  ],
  [
    "IPV4_STRINGIFY",
    "address",
    "Converts address into an IPv4 address dotted-decimal string. If address is a string that is a valid IPv4 address, then it is passed through. Returns null if address cannot be represented as an IPv4 address."
  ],
  [
    "HLL_SKETCH_ESTIMATE",
    "expr, [round]",
    "Returns the distinct count estimate from an HLL sketch. expr must return an HLL sketch. The optional round boolean parameter will round the estimate if set to true, with a default of false."
  ],
  [
    "HLL_SKETCH_ESTIMATE_WITH_ERROR_BOUNDS",
    "expr, [numStdDev]",
    "Returns the distinct count estimate and error bounds from an HLL sketch. expr must return an HLL sketch. An optional numStdDev argument can be provided."
  ],
  [
    "HLL_SKETCH_UNION",
    "[lgK, tgtHllType], expr0, expr1, ...",
    "Returns a union of HLL sketches, where each input expression must return an HLL sketch. The lgK and tgtHllType can be optionally specified as the first parameter; if provided, both optional parameters must be specified."
  ],
  [
    "HLL_SKETCH_TO_STRING",
    "expr",
    "Returns a human-readable string representation of an HLL sketch for debugging. expr must return an HLL sketch."
  ],
  [
    "THETA_SKETCH_ESTIMATE",
    "expr",
    "Returns the distinct count estimate from a theta sketch. expr must return a theta sketch."
  ],
  [
    "THETA_SKETCH_ESTIMATE_WITH_ERROR_BOUNDS",
    "expr, errorBoundsStdDev",
    "Returns the distinct count estimate and error bounds from a theta sketch. expr must return a theta sketch."
  ],
  [
    "THETA_SKETCH_UNION",
    "[size], expr0, expr1, ...",
    "Returns a union of theta sketches, where each input expression must return a theta sketch. The size can be optionally specified as the first parameter."
  ],
  [
    "THETA_SKETCH_INTERSECT",
    "[size], expr0, expr1, ...",
    "Returns an intersection of theta sketches, where each input expression must return a theta sketch. The size can be optionally specified as the first parameter."
  ],
  [
    "THETA_SKETCH_NOT",
    "[size], expr0, expr1, ...",
    "Returns a set difference of theta sketches, where each input expression must return a theta sketch. The size can be optionally specified as the first parameter."
  ],
  [
    "DS_GET_QUANTILE",
    "expr, fraction",
    "Returns the quantile estimate corresponding to fraction from a quantiles sketch. expr must return a quantiles sketch."
  ],
  [
    "DS_GET_QUANTILES",
    "expr, fraction0, fraction1, ...",
    "Returns a string representing an array of quantile estimates corresponding to a list of fractions from a quantiles sketch. expr must return a quantiles sketch."
  ],
  [
    "DS_HISTOGRAM",
    "expr, splitPoint0, splitPoint1, ...",
    "Returns a string representing an approximation to the histogram given a list of split points that define the histogram bins from a quantiles sketch. expr must return a quantiles sketch."
  ],
  [
    "DS_CDF",
    "expr, splitPoint0, splitPoint1, ...",
    "Returns a string representing approximation to the Cumulative Distribution Function given a list of split points that define the edges of the bins from a quantiles sketch. expr must return a quantiles sketch."
  ],
  [
    "DS_RANK",
    "expr, value",
    "Returns an approximation to the rank of a given value that is the fraction of the distribution less than that value from a quantiles sketch. expr must return a quantiles sketch."
  ],
  [
    "DS_QUANTILE_SUMMARY",
    "expr",
    "Returns a string summary of a quantiles sketch, useful for debugging. expr must return a quantiles sketch."
  ],
  [
    "CAST",
    "value AS TYPE",
    "Cast value to another type. See Data types for details about how Druid SQL handles CAST."
  ],
  [
    "NULLIF",
    "value1, value2",
    "Returns NULL if value1 and value2 match, else returns value1."
  ],
  [
    "COALESCE",
    "value1, value2, ...",
    "Returns the first value that is neither NULL nor empty string."
  ],
  [
    "NVL",
    "expr,expr-for-null",
    "Returns 'expr-for-null' if 'expr' is null (or empty string for string type)."
  ],
  [
    "BLOOM_FILTER_TEST",
    "<expr>, <serialized-filter>",
    "Returns true if the value is contained in a Base64-serialized bloom filter. See the Bloom filter extension documentation for additional details."
  ],
  [
    "MV_LENGTH",
    "arr",
    " returns length of array expression "
  ],
  [
    "MV_OFFSET",
    "arr,long",
    " returns the array element at the 0 based index supplied, or null for an out of range index"
  ],
  [
    "MV_ORDINAL",
    "arr,long",
    " returns the array element at the 1 based index supplied, or null for an out of range index "
  ],
  [
    "MV_CONTAINS",
    "arr,expr",
    " returns 1 if the array contains the element specified by expr, or contains all elements specified by expr if expr is an array, else 0 "
  ],
  [
    "MV_OVERLAP",
    "arr1,arr2",
    " returns 1 if arr1 and arr2 have any elements in common, else 0 "
  ],
  [
    "MV_OFFSET_OF",
    "arr,expr",
    " returns the 0 based index of the first occurrence of expr in the array, or -1 or null if druid.generic.useDefaultValueForNull=false if no matching elements exist in the array. "
  ],
  [
    "MV_ORDINAL_OF",
    "arr,expr",
    " returns the 1 based index of the first occurrence of expr in the array, or -1 or null if druid.generic.useDefaultValueForNull=false if no matching elements exist in the array. "
  ],
  [
    "MV_PREPEND",
    "expr,arr",
    " adds expr to arr at the beginning, the resulting array type determined by the type of the array "
  ],
  [
    "MV_APPEND",
    "arr1,expr",
    " appends expr to arr, the resulting array type determined by the type of the first array "
  ],
  [
    "MV_CONCAT",
    "arr1,arr2",
    " concatenates 2 arrays, the resulting array type determined by the type of the first array "
  ],
  [
    "MV_SLICE",
    "arr,start,end",
    " return the subarray of arr from the 0 based index start(inclusive) to end(exclusive), or null, if start is less than 0, greater than length of arr or less than end"
  ],
  [
    "MV_TO_STRING",
    "arr,str",
    " joins all elements of arr by the delimiter specified by str "
  ],
  [
    "STRING_TO_MV",
    "str1,str2",
    " splits str1 into an array on the delimiter specified by str2 "
  ]
];
