// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

suite("nereids_scalar_fn_map") {
    sql 'use regression_test_nereids_function_p0'
    sql 'set enable_nereids_planner=true'
    sql 'set enable_fallback_to_original_planner=false'

    // element_at
    order_qt_element_at_bool_tint   """ select km_bool_tint[kbool] from fn_test """
    order_qt_element_at_tint_tint   """ select km_tint_tint[ktint] from fn_test """
    order_qt_element_at_sint_tint   """ select km_sint_tint[ksint] from fn_test """
    order_qt_element_at_int_tint    """ select km_int_tint[kint] from fn_test """
    order_qt_element_at_bint_tint   """ select km_bint_tint[kbint] from fn_test """
    order_qt_element_at_lint_tint   """ select km_lint_tint[klint] from fn_test """
    order_qt_element_at_float_tint  """ select km_float_tint[kfloat] from fn_test """
    order_qt_element_at_dbl_tint    """ select km_dbl_tint[kdbl] from fn_test """
    order_qt_element_at_dcml_tint   """ select km_dcml_tint[kdcmls1] from fn_test """
    order_qt_element_at_chr_tint    """ select km_chr_tint[kchrs1] from fn_test """
    order_qt_element_at_vchr_tint   """ select km_vchr_tint[kvchrs1] from fn_test """
    order_qt_element_at_str_tint    """ select km_str_tint[kstr] from fn_test """
    order_qt_element_at_date_tint   """ select km_date_tint[kdt] from fn_test """
    order_qt_element_at_dtm_tint    """ select km_dtm_tint[kdtm] from fn_test """
    order_qt_element_at_bool_tint_notnull   """ select km_bool_tint[kbool] from fn_test_not_nullable """
    order_qt_element_at_tint_tint_notnull   """ select km_tint_tint[ktint] from fn_test_not_nullable """
    order_qt_element_at_sint_tint_notnull   """ select km_sint_tint[ksint] from fn_test_not_nullable """
    order_qt_element_at_int_tint_notnull    """ select km_int_tint[kint] from fn_test_not_nullable """
    order_qt_element_at_bint_tint_notnull   """ select km_bint_tint[kbint] from fn_test_not_nullable """
    order_qt_element_at_lint_tint_notnull   """ select km_lint_tint[klint] from fn_test_not_nullable """
    order_qt_element_at_float_tint_notnull  """ select km_float_tint[kfloat] from fn_test_not_nullable """
    order_qt_element_at_dbl_tint_notnull    """ select km_dbl_tint[kdbl] from fn_test_not_nullable """
    order_qt_element_at_dcml_tint_notnull   """ select km_dcml_tint[kdcmls1] from fn_test_not_nullable """
    order_qt_element_at_chr_tint_notnull    """ select km_chr_tint[kchrs1] from fn_test_not_nullable """
    order_qt_element_at_vchr_tint_notnull   """ select km_vchr_tint[kvchrs1] from fn_test_not_nullable """
    order_qt_element_at_str_tint_notnull    """ select km_str_tint[kstr] from fn_test_not_nullable """
    order_qt_element_at_date_tint_notnull   """ select km_date_tint[kdt] from fn_test_not_nullable """
    order_qt_element_at_dtm_tint_notnull    """ select km_dtm_tint[kdtm] from fn_test_not_nullable """

    // map size
    order_qt_map_size_bool_tint   """ select map_size(km_bool_tint) from fn_test """
    order_qt_map_size_tint_tint   """ select map_size(km_tint_tint) from fn_test """
    order_qt_map_size_sint_tint   """ select map_size(km_sint_tint) from fn_test """
    order_qt_map_size_int_tint    """ select map_size(km_int_tint) from fn_test """
    order_qt_map_size_bint_tint   """ select map_size(km_bint_tint) from fn_test """
    order_qt_map_size_lint_tint   """ select map_size(km_lint_tint) from fn_test """
    order_qt_map_size_float_tint  """ select map_size(km_float_tint) from fn_test """
    order_qt_map_size_dbl_tint    """ select map_size(km_dbl_tint) from fn_test """
    order_qt_map_size_dcml_tint   """ select map_size(km_dcml_tint) from fn_test """
    order_qt_map_size_chr_tint    """ select map_size(km_chr_tint) from fn_test """
    order_qt_map_size_vchr_tint   """ select map_size(km_vchr_tint) from fn_test """
    order_qt_map_size_str_tint    """ select map_size(km_str_tint) from fn_test """
    order_qt_map_size_date_tint   """ select map_size(km_date_tint) from fn_test """
    order_qt_map_size_dtm_tint    """ select map_size(km_dtm_tint) from fn_test """
    order_qt_map_size_tint_bool   """ select map_size(km_tint_bool) from fn_test """
    order_qt_map_size_int_int     """ select map_size(km_int_int) from fn_test """
    order_qt_map_size_tint_sint   """ select map_size(km_tint_sint) from fn_test """
    order_qt_map_size_tint_int    """ select map_size(km_tint_int) from fn_test """
    order_qt_map_size_tint_bint   """ select map_size(km_tint_bint) from fn_test """
    order_qt_map_size_tint_lint   """ select map_size(km_tint_lint) from fn_test """
    order_qt_map_size_tint_float  """ select map_size(km_tint_float) from fn_test """
    order_qt_map_size_tint_dbl    """ select map_size(km_tint_dbl) from fn_test """
    order_qt_map_size_tint_dcml   """ select map_size(km_tint_dcml) from fn_test """
    order_qt_map_size_tint_chr    """ select map_size(km_tint_chr) from fn_test """
    order_qt_map_size_tint_vchr   """ select map_size(km_tint_vchr) from fn_test """
    order_qt_map_size_tint_str    """ select map_size(km_tint_str) from fn_test """
    order_qt_map_size_tint_date   """ select map_size(km_tint_date) from fn_test """
    order_qt_map_size_tint_dtm    """ select map_size(km_tint_dtm) from fn_test """
    order_qt_map_size_bool_tint_notnull   """ select map_size(km_bool_tint) from fn_test_not_nullable """
    order_qt_map_size_tint_tint_notnull   """ select map_size(km_tint_tint) from fn_test_not_nullable """
    order_qt_map_size_sint_tint_notnull   """ select map_size(km_sint_tint) from fn_test_not_nullable """
    order_qt_map_size_int_tint_notnull    """ select map_size(km_int_tint) from fn_test_not_nullable """
    order_qt_map_size_bint_tint_notnull   """ select map_size(km_bint_tint) from fn_test_not_nullable """
    order_qt_map_size_lint_tint_notnull   """ select map_size(km_lint_tint) from fn_test_not_nullable """
    order_qt_map_size_float_tint_notnull  """ select map_size(km_float_tint) from fn_test_not_nullable """
    order_qt_map_size_dbl_tint_notnull    """ select map_size(km_dbl_tint) from fn_test_not_nullable """
    order_qt_map_size_dcml_tint_notnull   """ select map_size(km_dcml_tint) from fn_test_not_nullable """
    order_qt_map_size_chr_tint_notnull    """ select map_size(km_chr_tint) from fn_test_not_nullable """
    order_qt_map_size_vchr_tint_notnull   """ select map_size(km_vchr_tint) from fn_test_not_nullable """
    order_qt_map_size_str_tint_notnull    """ select map_size(km_str_tint) from fn_test_not_nullable """
    order_qt_map_size_date_tint_notnull   """ select map_size(km_date_tint) from fn_test_not_nullable """
    order_qt_map_size_dtm_tint_notnull    """ select map_size(km_dtm_tint) from fn_test_not_nullable """
    order_qt_map_size_tint_bool_notnull   """ select map_size(km_tint_bool) from fn_test_not_nullable """
    order_qt_map_size_int_int_notnull     """ select map_size(km_int_int) from fn_test_not_nullable """
    order_qt_map_size_tint_sint_notnull   """ select map_size(km_tint_sint) from fn_test_not_nullable """
    order_qt_map_size_tint_int_notnull    """ select map_size(km_tint_int) from fn_test_not_nullable """
    order_qt_map_size_tint_bint_notnull   """ select map_size(km_tint_bint) from fn_test_not_nullable """
    order_qt_map_size_tint_lint_notnull   """ select map_size(km_tint_lint) from fn_test_not_nullable """
    order_qt_map_size_tint_float_notnull  """ select map_size(km_tint_float) from fn_test_not_nullable """
    order_qt_map_size_tint_dbl_notnull    """ select map_size(km_tint_dbl) from fn_test_not_nullable """
    order_qt_map_size_tint_dcml_notnull   """ select map_size(km_tint_dcml) from fn_test_not_nullable """
    order_qt_map_size_tint_chr_notnull    """ select map_size(km_tint_chr) from fn_test_not_nullable """
    order_qt_map_size_tint_vchr_notnull   """ select map_size(km_tint_vchr) from fn_test_not_nullable """
    order_qt_map_size_tint_str_notnull    """ select map_size(km_tint_str) from fn_test_not_nullable """
    order_qt_map_size_tint_date_notnull   """ select map_size(km_tint_date) from fn_test_not_nullable """
    order_qt_map_size_tint_dtm_notnull    """ select map_size(km_tint_dtm) from fn_test_not_nullable """

    // size same with map_size
    order_qt_size_bool_tint   """ select size(km_bool_tint) from fn_test """
    order_qt_size_tint_tint   """ select size(km_tint_tint) from fn_test """
    order_qt_size_sint_tint   """ select size(km_sint_tint) from fn_test """
    order_qt_size_int_tint    """ select size(km_int_tint) from fn_test """
    order_qt_size_bint_tint   """ select size(km_bint_tint) from fn_test """
    order_qt_size_lint_tint   """ select size(km_lint_tint) from fn_test """
    order_qt_size_float_tint  """ select size(km_float_tint) from fn_test """
    order_qt_size_dbl_tint    """ select size(km_dbl_tint) from fn_test """
    order_qt_size_dcml_tint   """ select size(km_dcml_tint) from fn_test """
    order_qt_size_chr_tint    """ select size(km_chr_tint) from fn_test """
    order_qt_size_vchr_tint   """ select size(km_vchr_tint) from fn_test """
    order_qt_size_str_tint    """ select size(km_str_tint) from fn_test """
    order_qt_size_date_tint   """ select size(km_date_tint) from fn_test """
    order_qt_size_dtm_tint    """ select size(km_dtm_tint) from fn_test """
    order_qt_size_tint_bool   """ select size(km_tint_bool) from fn_test """
    order_qt_size_int_int     """ select size(km_int_int) from fn_test """
    order_qt_size_tint_sint   """ select size(km_tint_sint) from fn_test """
    order_qt_size_tint_int    """ select size(km_tint_int) from fn_test """
    order_qt_size_tint_bint   """ select size(km_tint_bint) from fn_test """
    order_qt_size_tint_lint   """ select size(km_tint_lint) from fn_test """
    order_qt_size_tint_float  """ select size(km_tint_float) from fn_test """
    order_qt_size_tint_dbl    """ select size(km_tint_dbl) from fn_test """
    order_qt_size_tint_dcml   """ select size(km_tint_dcml) from fn_test """
    order_qt_size_tint_chr    """ select size(km_tint_chr) from fn_test """
    order_qt_size_tint_vchr   """ select size(km_tint_vchr) from fn_test """
    order_qt_size_tint_str    """ select size(km_tint_str) from fn_test """
    order_qt_size_tint_date   """ select size(km_tint_date) from fn_test """
    order_qt_size_tint_dtm    """ select size(km_tint_dtm) from fn_test """
    order_qt_size_bool_tint_notnull   """ select size(km_bool_tint) from fn_test_not_nullable """
    order_qt_size_tint_tint_notnull   """ select size(km_tint_tint) from fn_test_not_nullable """
    order_qt_size_sint_tint_notnull   """ select size(km_sint_tint) from fn_test_not_nullable """
    order_qt_size_int_tint_notnull    """ select size(km_int_tint) from fn_test_not_nullable """
    order_qt_size_bint_tint_notnull   """ select size(km_bint_tint) from fn_test_not_nullable """
    order_qt_size_lint_tint_notnull   """ select size(km_lint_tint) from fn_test_not_nullable """
    order_qt_size_float_tint_notnull  """ select size(km_float_tint) from fn_test_not_nullable """
    order_qt_size_dbl_tint_notnull    """ select size(km_dbl_tint) from fn_test_not_nullable """
    order_qt_size_dcml_tint_notnull   """ select size(km_dcml_tint) from fn_test_not_nullable """
    order_qt_size_chr_tint_notnull    """ select size(km_chr_tint) from fn_test_not_nullable """
    order_qt_size_vchr_tint_notnull   """ select size(km_vchr_tint) from fn_test_not_nullable """
    order_qt_size_str_tint_notnull    """ select size(km_str_tint) from fn_test_not_nullable """
    order_qt_size_date_tint_notnull   """ select size(km_date_tint) from fn_test_not_nullable """
    order_qt_size_dtm_tint_notnull    """ select size(km_dtm_tint) from fn_test_not_nullable """
    order_qt_size_tint_bool_notnull   """ select size(km_tint_bool) from fn_test_not_nullable """
    order_qt_size_int_int_notnull     """ select size(km_int_int) from fn_test_not_nullable """
    order_qt_size_tint_sint_notnull   """ select size(km_tint_sint) from fn_test_not_nullable """
    order_qt_size_tint_int_notnull    """ select size(km_tint_int) from fn_test_not_nullable """
    order_qt_size_tint_bint_notnull   """ select size(km_tint_bint) from fn_test_not_nullable """
    order_qt_size_tint_lint_notnull   """ select size(km_tint_lint) from fn_test_not_nullable """
    order_qt_size_tint_float_notnull  """ select size(km_tint_float) from fn_test_not_nullable """
    order_qt_size_tint_dbl_notnull    """ select size(km_tint_dbl) from fn_test_not_nullable """
    order_qt_size_tint_dcml_notnull   """ select size(km_tint_dcml) from fn_test_not_nullable """
    order_qt_size_tint_chr_notnull    """ select size(km_tint_chr) from fn_test_not_nullable """
    order_qt_size_tint_vchr_notnull   """ select size(km_tint_vchr) from fn_test_not_nullable """
    order_qt_size_tint_str_notnull    """ select size(km_tint_str) from fn_test_not_nullable """
    order_qt_size_tint_date_notnull   """ select size(km_tint_date) from fn_test_not_nullable """
    order_qt_size_tint_dtm_notnull    """ select size(km_tint_dtm) from fn_test_not_nullable """
    
    // map_keys
    order_qt_map_keys_bool_tint   """ select map_keys(km_bool_tint) from fn_test """
    order_qt_map_keys_tint_tint   """ select map_keys(km_tint_tint) from fn_test """
    order_qt_map_keys_sint_tint   """ select map_keys(km_sint_tint) from fn_test """
    order_qt_map_keys_int_tint    """ select map_keys(km_int_tint) from fn_test """
    order_qt_map_keys_bint_tint   """ select map_keys(km_bint_tint) from fn_test """
    order_qt_map_keys_lint_tint   """ select map_keys(km_lint_tint) from fn_test """
    order_qt_map_keys_float_tint  """ select map_keys(km_float_tint) from fn_test """
    order_qt_map_keys_dbl_tint    """ select map_keys(km_dbl_tint) from fn_test """
    order_qt_map_keys_dcml_tint   """ select map_keys(km_dcml_tint) from fn_test """
    order_qt_map_keys_chr_tint    """ select map_keys(km_chr_tint) from fn_test """
    order_qt_map_keys_vchr_tint   """ select map_keys(km_vchr_tint) from fn_test """
    order_qt_map_keys_str_tint    """ select map_keys(km_str_tint) from fn_test """
    order_qt_map_keys_date_tint   """ select map_keys(km_date_tint) from fn_test """
    order_qt_map_keys_dtm_tint    """ select map_keys(km_dtm_tint) from fn_test """
    order_qt_map_keys_bool_tint_notnull   """ select map_keys(km_bool_tint) from fn_test_not_nullable """
    order_qt_map_keys_tint_tint_notnull   """ select map_keys(km_tint_tint) from fn_test_not_nullable """
    order_qt_map_keys_sint_tint_notnull   """ select map_keys(km_sint_tint) from fn_test_not_nullable """
    order_qt_map_keys_int_tint_notnull    """ select map_keys(km_int_tint) from fn_test_not_nullable """
    order_qt_map_keys_bint_tint_notnull   """ select map_keys(km_bint_tint) from fn_test_not_nullable """
    order_qt_map_keys_lint_tint_notnull   """ select map_keys(km_lint_tint) from fn_test_not_nullable """
    order_qt_map_keys_float_tint_notnull  """ select map_keys(km_float_tint) from fn_test_not_nullable """
    order_qt_map_keys_dbl_tint_notnull    """ select map_keys(km_dbl_tint) from fn_test_not_nullable """
    order_qt_map_keys_dcml_tint_notnull   """ select map_keys(km_dcml_tint) from fn_test_not_nullable """
    order_qt_map_keys_chr_tint_notnull    """ select map_keys(km_chr_tint) from fn_test_not_nullable """
    order_qt_map_keys_vchr_tint_notnull   """ select map_keys(km_vchr_tint) from fn_test_not_nullable """
    order_qt_map_keys_str_tint_notnull    """ select map_keys(km_str_tint) from fn_test_not_nullable """
    order_qt_map_keys_date_tint_notnull   """ select map_keys(km_date_tint) from fn_test_not_nullable """
    order_qt_map_keys_dtm_tint_notnull    """ select map_keys(km_dtm_tint) from fn_test_not_nullable """

    // map_values
    order_qt_map_values_tint_bool   """ select map_values(km_tint_bool) from fn_test """
    order_qt_map_values_int_int     """ select map_values(km_int_int) from fn_test """
    order_qt_map_values_tint_sint   """ select map_values(km_tint_sint) from fn_test """
    order_qt_map_values_tint_int    """ select map_values(km_tint_int) from fn_test """
    order_qt_map_values_tint_bint   """ select map_values(km_tint_bint) from fn_test """
    order_qt_map_values_tint_lint   """ select map_values(km_tint_lint) from fn_test """
    order_qt_map_values_tint_float  """ select map_values(km_tint_float) from fn_test """
    order_qt_map_values_tint_dbl    """ select map_values(km_tint_dbl) from fn_test """
    order_qt_map_values_tint_dcml   """ select map_values(km_tint_dcml) from fn_test """
    order_qt_map_values_tint_chr    """ select map_values(km_tint_chr) from fn_test """
    order_qt_map_values_tint_vchr   """ select map_values(km_tint_vchr) from fn_test """
    order_qt_map_values_tint_str    """ select map_values(km_tint_str) from fn_test """
    order_qt_map_values_tint_date   """ select map_values(km_tint_date) from fn_test """
    order_qt_map_values_tint_dtm    """ select map_values(km_tint_dtm) from fn_test """
    order_qt_map_values_tint_bool_notnull   """ select map_values(km_tint_bool) from fn_test_not_nullable """
    order_qt_map_values_int_int_notnull     """ select map_values(km_int_int) from fn_test_not_nullable """
    order_qt_map_values_tint_sint_notnull   """ select map_values(km_tint_sint) from fn_test_not_nullable """
    order_qt_map_values_tint_int_notnull    """ select map_values(km_tint_int) from fn_test_not_nullable """
    order_qt_map_values_tint_bint_notnull   """ select map_values(km_tint_bint) from fn_test_not_nullable """
    order_qt_map_values_tint_lint_notnull   """ select map_values(km_tint_lint) from fn_test_not_nullable """
    order_qt_map_values_tint_float_notnull  """ select map_values(km_tint_float) from fn_test_not_nullable """
    order_qt_map_values_tint_dbl_notnull    """ select map_values(km_tint_dbl) from fn_test_not_nullable """
    order_qt_map_values_tint_dcml_notnull   """ select map_values(km_tint_dcml) from fn_test_not_nullable """
    order_qt_map_values_tint_chr_notnull    """ select map_values(km_tint_chr) from fn_test_not_nullable """
    order_qt_map_values_tint_vchr_notnull   """ select map_values(km_tint_vchr) from fn_test_not_nullable """
    order_qt_map_values_tint_str_notnull    """ select map_values(km_tint_str) from fn_test_not_nullable """
    order_qt_map_values_tint_date_notnull   """ select map_values(km_tint_date) from fn_test_not_nullable """
    order_qt_map_values_tint_dtm_notnull    """ select map_values(km_tint_dtm) from fn_test_not_nullable """

    // map_contains_key
    order_qt_map_contains_key_bool_tint   """ select map_contains_key(km_bool_tint, kbool) from fn_test """
    order_qt_map_contains_key_tint_tint   """ select map_contains_key(km_tint_tint, ktint) from fn_test """
    order_qt_map_contains_key_sint_tint   """ select map_contains_key(km_sint_tint, ksint) from fn_test """
    order_qt_map_contains_key_int_tint    """ select map_contains_key(km_int_tint, kint) from fn_test """
    order_qt_map_contains_key_bint_tint   """ select map_contains_key(km_bint_tint, kbint) from fn_test """
    order_qt_map_contains_key_lint_tint   """ select map_contains_key(km_lint_tint, klint) from fn_test """
    order_qt_map_contains_key_float_tint  """ select map_contains_key(km_float_tint, kfloat) from fn_test """
    order_qt_map_contains_key_dbl_tint    """ select map_contains_key(km_dbl_tint, kdbl) from fn_test """
    order_qt_map_contains_key_dcml_tint   """ select map_contains_key(km_dcml_tint, kdcmls1) from fn_test """
    order_qt_map_contains_key_chr_tint    """ select map_contains_key(km_chr_tint, kchrs1) from fn_test """
    order_qt_map_contains_key_vchr_tint   """ select map_contains_key(km_vchr_tint, kvchrs1) from fn_test """
    order_qt_map_contains_key_str_tint    """ select map_contains_key(km_str_tint, kstr) from fn_test """
    order_qt_map_contains_key_date_tint   """ select map_contains_key(km_date_tint, kdt) from fn_test """
    order_qt_map_contains_key_dtm_tint    """ select map_contains_key(km_dtm_tint, kdtm) from fn_test """
    order_qt_map_contains_key_bool_tint_notnull   """ select map_contains_key(km_bool_tint, kbool) from fn_test_not_nullable """
    order_qt_map_contains_key_tint_tint_notnull   """ select map_contains_key(km_tint_tint, ktint) from fn_test_not_nullable """
    order_qt_map_contains_key_sint_tint_notnull   """ select map_contains_key(km_sint_tint, ksint) from fn_test_not_nullable """
    order_qt_map_contains_key_int_tint_notnull    """ select map_contains_key(km_int_tint, kint) from fn_test_not_nullable """
    order_qt_map_contains_key_bint_tint_notnull   """ select map_contains_key(km_bint_tint, kbint) from fn_test_not_nullable """
    order_qt_map_contains_key_lint_tint_notnull   """ select map_contains_key(km_lint_tint, klint) from fn_test_not_nullable """
    order_qt_map_contains_key_float_tint_notnull  """ select map_contains_key(km_float_tint, kfloat) from fn_test_not_nullable """
    order_qt_map_contains_key_dbl_tint_notnull    """ select map_contains_key(km_dbl_tint, kdbl) from fn_test_not_nullable """
    order_qt_map_contains_key_dcml_tint_notnull   """ select map_contains_key(km_dcml_tint, kdcmls1) from fn_test_not_nullable """
    order_qt_map_contains_key_chr_tint_notnull    """ select map_contains_key(km_chr_tint, kchrs1) from fn_test_not_nullable """
    order_qt_map_contains_key_vchr_tint_notnull   """ select map_contains_key(km_vchr_tint, kvchrs1) from fn_test_not_nullable """
    order_qt_map_contains_key_str_tint_notnull    """ select map_contains_key(km_str_tint, kstr) from fn_test_not_nullable """
    order_qt_map_contains_key_date_tint_notnull   """ select map_contains_key(km_date_tint, kdt) from fn_test_not_nullable """
    order_qt_map_contains_key_dtm_tint_notnull    """ select map_contains_key(km_dtm_tint, kdtm) from fn_test_not_nullable """

    // map_contains_value
    order_qt_map_contains_value_tint_bool   """ select map_contains_value(km_tint_bool, kbool) from fn_test """
    order_qt_map_contains_value_int_int     """ select map_contains_value(km_int_int, ktint) from fn_test """
    order_qt_map_contains_value_tint_sint   """ select map_contains_value(km_tint_sint, ksint) from fn_test """
    order_qt_map_contains_value_tint_int    """ select map_contains_value(km_tint_int, kint) from fn_test """
    order_qt_map_contains_value_tint_bint   """ select map_contains_value(km_tint_bint, kbint) from fn_test """
    order_qt_map_contains_value_tint_lint   """ select map_contains_value(km_tint_lint, klint) from fn_test """
    order_qt_map_contains_value_tint_float  """ select map_contains_value(km_tint_float, kfloat) from fn_test """
    order_qt_map_contains_value_tint_dbl    """ select map_contains_value(km_tint_dbl, kdbl) from fn_test """
    order_qt_map_contains_value_tint_dcml   """ select map_contains_value(km_tint_dcml, kdcmls1) from fn_test """
    order_qt_map_contains_value_tint_chr    """ select map_contains_value(km_tint_chr, kchrs1) from fn_test """
    order_qt_map_contains_value_tint_vchr   """ select map_contains_value(km_tint_vchr, kvchrs1) from fn_test """
    order_qt_map_contains_value_tint_str    """ select map_contains_value(km_tint_str, kstr) from fn_test """
    order_qt_map_contains_value_tint_date   """ select map_contains_value(km_tint_date, kdt) from fn_test """
    order_qt_map_contains_value_tint_dtm    """ select map_contains_value(km_tint_dtm, kdtm) from fn_test """
    order_qt_map_contains_value_tint_bool_notnull   """ select map_contains_value(km_tint_bool, kbool) from fn_test_not_nullable """
    order_qt_map_contains_value_int_int_notnull     """ select map_contains_value(km_int_int, ktint) from fn_test_not_nullable """
    order_qt_map_contains_value_tint_sint_notnull   """ select map_contains_value(km_tint_sint, ksint) from fn_test_not_nullable """
    order_qt_map_contains_value_tint_int_notnull    """ select map_contains_value(km_tint_int, kint) from fn_test_not_nullable """
    order_qt_map_contains_value_tint_bint_notnull   """ select map_contains_value(km_tint_bint, kbint) from fn_test_not_nullable """
    order_qt_map_contains_value_tint_lint_notnull   """ select map_contains_value(km_tint_lint, klint) from fn_test_not_nullable """
    order_qt_map_contains_value_tint_float_notnull  """ select map_contains_value(km_tint_float, kfloat) from fn_test_not_nullable """
    order_qt_map_contains_value_tint_dbl_notnull    """ select map_contains_value(km_tint_dbl, kdbl) from fn_test_not_nullable """
    order_qt_map_contains_value_tint_dcml_notnull   """ select map_contains_value(km_tint_dcml, kdcmls1) from fn_test_not_nullable """
    order_qt_map_contains_value_tint_chr_notnull    """ select map_contains_value(km_tint_chr, kchrs1) from fn_test_not_nullable """
    order_qt_map_contains_value_tint_vchr_notnull   """ select map_contains_value(km_tint_vchr, kvchrs1) from fn_test_not_nullable """
    order_qt_map_contains_value_tint_str_notnull    """ select map_contains_value(km_tint_str, kstr) from fn_test_not_nullable """
    order_qt_map_contains_value_tint_date_notnull   """ select map_contains_value(km_tint_date, kdt) from fn_test_not_nullable """
    order_qt_map_contains_value_tint_dtm_notnull    """ select map_contains_value(km_tint_dtm, kdtm) from fn_test_not_nullable """


}