CREATE TABLE IF NOT EXISTS visits
(
    CounterID BIGINT,
    StartDate DATE,
    UserID LARGEINT,
    VisitID LARGEINT,
    Sign TINYINT,
    IsNew SMALLINT,
    StartTime DATETIME,
    Duration BIGINT,
    UTCStartTime DATETIME,
    PageViews INT,
    Hits INT,
    IsBounce SMALLINT,
    Referer STRING,
    StartURL STRING,
    RefererDomain STRING,
    StartURLDomain STRING,
    EndURL STRING,
    LinkURL STRING,
    IsDownload SMALLINT,
    TraficSourceID TINYINT,
    SearchEngineID INT,
    SearchPhrase STRING,
    AdvEngineID SMALLINT,
    PlaceID INT,
    RefererCategories STRING,
    URLCategories STRING,
    URLRegions STRING,
    RefererRegions STRING,
    IsYandex SMALLINT,
    GoalReachesDepth INT,
    GoalReachesURL INT,
    GoalReachesAny INT,
    SocialSourceNetworkID SMALLINT,
    SocialSourcePage STRING,
    MobilePhoneModel STRING,
    ClientEventTime DATETIME,
    RegionID BIGINT,
    ClientIP BIGINT,
    ClientIP6 CHAR(50),
    RemoteIP BIGINT,
    RemoteIP6 CHAR(50),
    IPNetworkID BIGINT,
    SilverlightVersion3 BIGINT,
    CodeVersion BIGINT,
    ResolutionWidth INT,
    ResolutionHeight INT,
    UserAgentMajor INT,
    UserAgentMinor INT,
    WindowClientWidth INT,
    WindowClientHeight INT,
    SilverlightVersion2 SMALLINT,
    SilverlightVersion4 INT,
    FlashVersion3 INT,
    FlashVersion4 INT,
    ClientTimeZone SMALLINT,
    OS SMALLINT,
    UserAgent SMALLINT,
    ResolutionDepth SMALLINT,
    FlashMajor SMALLINT,
    FlashMinor SMALLINT,
    NetMajor SMALLINT,
    NetMinor SMALLINT,
    MobilePhone SMALLINT,
    SilverlightVersion1 SMALLINT,
    Age SMALLINT,
    Sex SMALLINT,
    Income SMALLINT,
    JavaEnable SMALLINT,
    CookieEnable SMALLINT,
    JavascriptEnable SMALLINT,
    IsMobile SMALLINT,
    BrowserLanguage INT,
    BrowserCountry INT,
    Interests INT,
    Robotness SMALLINT,
    GeneralInterests STRING,
    Params STRING,
    GoalsID STRING,
    GoalsSerial STRING,
    GoalsEventTime STRING,
    GoalsPrice STRING,
    GoalsOrderID STRING,
    GoalsCurrencyID STRING,
    WatchIDs STRING,
    ParamSumPrice BIGINT,
    ParamCurrency CHAR(10),
    ParamCurrencyID INT,
    ClickLogID LARGEINT,
    ClickEventID INT,
    ClickGoodEvent INT,
    ClickEventTime DATETIME,
    ClickPriorityID INT,
    ClickPhraseID INT,
    ClickPageID INT,
    ClickPlaceID INT,
    ClickTypeID INT,
    ClickResourceID INT,
    ClickCost BIGINT,
    ClickClientIP BIGINT,
    ClickDomainID BIGINT,
    ClickURL STRING,
    ClickAttempt SMALLINT,
    ClickOrderID BIGINT,
    ClickBannerID BIGINT,
    ClickMarketCategoryID BIGINT,
    ClickMarketPP BIGINT,
    ClickMarketCategoryName STRING,
    ClickMarketPPName STRING,
    ClickAWAPSCampaignName STRING,
    ClickPageName STRING,
    ClickTargetType INT,
    ClickTargetPhraseID LARGEINT,
    ClickContextType SMALLINT,
    ClickSelectType TINYINT,
    ClickOptions STRING,
    ClickGroupBannerID INT,
    OpenstatServiceName STRING,
    OpenstatCampaignID STRING,
    OpenstatAdID STRING,
    OpenstatSourceID STRING,
    UTMSource STRING,
    UTMMedium STRING,
    UTMCampaign STRING,
    UTMContent STRING,
    UTMTerm STRING,
    FromTag STRING,
    HasGCLID SMALLINT,
    FirstVisit DATETIME,
    PredLastVisit DATE,
    LastVisit DATE,
    TotalVisits BIGINT,
    TraficSourceID2 STRING,
    TraficSourceSearchEngineID STRING,
    TraficSourceAdvEngineID STRING,
    TraficSourcePlaceID STRING,
    TraficSourceSocialSourceNetworkID STRING,
    TraficSourceDomain STRING,
    TraficSourceSearchPhrase STRING,
    TraficSourceSocialSourcePage STRING,
    Attendance CHAR(50),
    CLID BIGINT,
    YCLID LARGEINT,
    NormalizedRefererHash LARGEINT,
    SearchPhraseHash LARGEINT,
    RefererDomainHash LARGEINT,
    NormalizedStartURLHash LARGEINT,
    StartURLDomainHash LARGEINT,
    NormalizedEndURLHash LARGEINT,
    TopLevelDomain LARGEINT,
    URLScheme LARGEINT,
    OpenstatServiceNameHash LARGEINT,
    OpenstatCampaignIDHash LARGEINT,
    OpenstatAdIDHash LARGEINT,
    OpenstatSourceIDHash LARGEINT,
    UTMSourceHash LARGEINT,
    UTMMediumHash LARGEINT,
    UTMCampaignHash LARGEINT,
    UTMContentHash LARGEINT,
    UTMTermHash LARGEINT,
    FromHash LARGEINT,
    WebVisorEnabled SMALLINT,
    WebVisorActivity BIGINT,
    ParsedParamsKey1 STRING,
    ParsedParamsKey2 STRING,
    ParsedParamsKey3 STRING,
    ParsedParamsKey4 STRING,
    ParsedParamsKey5 STRING,
    ParsedParamsValueDouble DOUBLE,
    MarketType STRING,
    MarketGoalID STRING,
    MarketOrderID STRING,
    MarketOrderPrice STRING,
    MarketPP STRING,
    MarketDirectPlaceID STRING,
    MarketDirectOrderID STRING,
    MarketDirectBannerID STRING,
    MarketGoodID STRING,
    MarketGoodName STRING,
    MarketGoodQuantity STRING,
    MarketGoodPrice STRING,
    IslandID CHAR(32)
) 
DUPLICATE KEY(CounterID, StartDate, UserID, VisitID)
DISTRIBUTED BY HASH(CounterID) BUCKETS 16
PROPERTIES
(
  "replication_num" = "1"
)
