// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

suite("nereids_agg_fn") {
	sql 'use regression_test_nereids_function_p0'
	sql 'set experimental_enable_nereids_planner=true'
	sql 'set enable_fallback_to_original_planner=false'
	sql '''
		select any_value(kint) from fn_test group by kbool order by kbool'''
	sql '''
		select any_value(kint) from fn_test'''
	sql '''
		select count(id), any_value(kint) from fn_test group by id order by id'''
	sql '''
		select count(distinct id), any_value(kint) from fn_test'''
	sql '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), any_value(kint) from fn_test group by kbool order by kbool'''
	sql '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), any_value(kint) from fn_test'''
	sql '''
		select any_value(kint) from fn_test_not_nullable group by kbool order by kbool'''
	sql '''
		select any_value(kint) from fn_test_not_nullable'''
	sql '''
		select count(id), any_value(kint) from fn_test_not_nullable group by id order by id'''
	sql '''
		select count(distinct id), any_value(kint) from fn_test_not_nullable'''
	sql '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), any_value(kint) from fn_test group by kbool order by kbool'''
	sql '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), any_value(kint) from fn_test'''
	// count_by_enum_string result is unstable in one line, so just check not core
	sql '''
		select count_by_enum(kstr) from fn_test group by kbool order by kbool'''
	sql '''
		select count_by_enum(kstr) from fn_test_not_nullable group by kbool order by kbool'''

	qt_sql_avg_TinyInt_gb '''
		select avg(ktint) from fn_test group by kbool order by kbool'''
	qt_sql_avg_TinyInt '''
		select avg(ktint) from fn_test'''
	qt_sql_avg_TinyInt_agg_phase_1 '''
		select count(id), avg(ktint) from fn_test group by id order by id'''
	qt_sql_avg_TinyInt_agg_phase_2 '''
		select count(distinct id), avg(ktint) from fn_test'''
	qt_sql_avg_TinyInt_agg_phase_3 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), avg(ktint) from fn_test group by kbool order by kbool'''
	qt_sql_avg_TinyInt_agg_phase_4 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), avg(ktint) from fn_test'''
	qt_sql_avg_TinyInt_gb_notnull '''
		select avg(ktint) from fn_test_not_nullable group by kbool order by kbool'''
	qt_sql_avg_TinyInt_notnull '''
		select avg(ktint) from fn_test_not_nullable'''
	qt_sql_avg_TinyInt_agg_phase_1_notnull '''
		select count(id), avg(ktint) from fn_test_not_nullable group by id order by id'''
	qt_sql_avg_TinyInt_agg_phase_2_notnull '''
		select count(distinct id), avg(ktint) from fn_test_not_nullable'''
	qt_sql_avg_TinyInt_agg_phase_3_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), avg(ktint) from fn_test group by kbool order by kbool'''
	qt_sql_avg_TinyInt_agg_phase_4_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), avg(ktint) from fn_test'''

	qt_sql_avg_SmallInt_gb '''
		select avg(ksint) from fn_test group by kbool order by kbool'''
	qt_sql_avg_SmallInt '''
		select avg(ksint) from fn_test'''
	qt_sql_avg_SmallInt_agg_phase_1 '''
		select count(id), avg(ksint) from fn_test group by id order by id'''
	qt_sql_avg_SmallInt_agg_phase_2 '''
		select count(distinct id), avg(ksint) from fn_test'''
	qt_sql_avg_SmallInt_agg_phase_3 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), avg(ksint) from fn_test group by kbool order by kbool'''
	qt_sql_avg_SmallInt_agg_phase_4 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), avg(ksint) from fn_test'''
	qt_sql_avg_SmallInt_gb_notnull '''
		select avg(ksint) from fn_test_not_nullable group by kbool order by kbool'''
	qt_sql_avg_SmallInt_notnull '''
		select avg(ksint) from fn_test_not_nullable'''
	qt_sql_avg_SmallInt_agg_phase_1_notnull '''
		select count(id), avg(ksint) from fn_test_not_nullable group by id order by id'''
	qt_sql_avg_SmallInt_agg_phase_2_notnull '''
		select count(distinct id), avg(ksint) from fn_test_not_nullable'''
	qt_sql_avg_SmallInt_agg_phase_3_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), avg(ksint) from fn_test group by kbool order by kbool'''
	qt_sql_avg_SmallInt_agg_phase_4_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), avg(ksint) from fn_test'''

	qt_sql_avg_Integer_gb '''
		select avg(kint) from fn_test group by kbool order by kbool'''
	qt_sql_avg_Integer '''
		select avg(kint) from fn_test'''
	qt_sql_avg_Integer_agg_phase_1 '''
		select count(id), avg(kint) from fn_test group by id order by id'''
	qt_sql_avg_Integer_agg_phase_2 '''
		select count(distinct id), avg(kint) from fn_test'''
	qt_sql_avg_Integer_agg_phase_3 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), avg(kint) from fn_test group by kbool order by kbool'''
	qt_sql_avg_Integer_agg_phase_4 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), avg(kint) from fn_test'''
	qt_sql_avg_Integer_gb_notnull '''
		select avg(kint) from fn_test_not_nullable group by kbool order by kbool'''
	qt_sql_avg_Integer_notnull '''
		select avg(kint) from fn_test_not_nullable'''
	qt_sql_avg_Integer_agg_phase_1_notnull '''
		select count(id), avg(kint) from fn_test_not_nullable group by id order by id'''
	qt_sql_avg_Integer_agg_phase_2_notnull '''
		select count(distinct id), avg(kint) from fn_test_not_nullable'''
	qt_sql_avg_Integer_agg_phase_3_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), avg(kint) from fn_test group by kbool order by kbool'''
	qt_sql_avg_Integer_agg_phase_4_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), avg(kint) from fn_test'''

	qt_sql_avg_BigInt_gb '''
		select avg(kbint) from fn_test group by kbool order by kbool'''
	qt_sql_avg_BigInt '''
		select avg(kbint) from fn_test'''
	qt_sql_avg_BigInt_agg_phase_1 '''
		select count(id), avg(kbint) from fn_test group by id order by id'''
	qt_sql_avg_BigInt_agg_phase_2 '''
		select count(distinct id), avg(kbint) from fn_test'''
	qt_sql_avg_BigInt_agg_phase_3 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), avg(kbint) from fn_test group by kbool order by kbool'''
	qt_sql_avg_BigInt_agg_phase_4 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), avg(kbint) from fn_test'''
	qt_sql_avg_BigInt_gb_notnull '''
		select avg(kbint) from fn_test_not_nullable group by kbool order by kbool'''
	qt_sql_avg_BigInt_notnull '''
		select avg(kbint) from fn_test_not_nullable'''
	qt_sql_avg_BigInt_agg_phase_1_notnull '''
		select count(id), avg(kbint) from fn_test_not_nullable group by id order by id'''
	qt_sql_avg_BigInt_agg_phase_2_notnull '''
		select count(distinct id), avg(kbint) from fn_test_not_nullable'''
	qt_sql_avg_BigInt_agg_phase_3_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), avg(kbint) from fn_test group by kbool order by kbool'''
	qt_sql_avg_BigInt_agg_phase_4_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), avg(kbint) from fn_test'''

	qt_sql_avg_Double_gb '''
		select avg(kdbl) from fn_test group by kbool order by kbool'''
	qt_sql_avg_Double '''
		select avg(kdbl) from fn_test'''
	qt_sql_avg_Double_agg_phase_1 '''
		select count(id), avg(kdbl) from fn_test group by id order by id'''
	qt_sql_avg_Double_agg_phase_2 '''
		select count(distinct id), avg(kdbl) from fn_test'''
	qt_sql_avg_Double_agg_phase_3 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), avg(kdbl) from fn_test group by kbool order by kbool'''
	qt_sql_avg_Double_agg_phase_4 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), avg(kdbl) from fn_test'''
	qt_sql_avg_Double_gb_notnull '''
		select avg(kdbl) from fn_test_not_nullable group by kbool order by kbool'''
	qt_sql_avg_Double_notnull '''
		select avg(kdbl) from fn_test_not_nullable'''
	qt_sql_avg_Double_agg_phase_1_notnull '''
		select count(id), avg(kdbl) from fn_test_not_nullable group by id order by id'''
	qt_sql_avg_Double_agg_phase_2_notnull '''
		select count(distinct id), avg(kdbl) from fn_test_not_nullable'''
	qt_sql_avg_Double_agg_phase_3_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), avg(kdbl) from fn_test group by kbool order by kbool'''
	qt_sql_avg_Double_agg_phase_4_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), avg(kdbl) from fn_test'''

	qt_sql_avg_DecimalV2_gb '''
		select avg(kdcmls1) from fn_test group by kbool order by kbool'''
	qt_sql_avg_DecimalV2 '''
		select avg(kdcmls1) from fn_test'''
	qt_sql_avg_DecimalV2_agg_phase_1 '''
		select count(id), avg(kdcmls1) from fn_test group by id order by id'''
	qt_sql_avg_DecimalV2_agg_phase_2 '''
		select count(distinct id), avg(kdcmls1) from fn_test'''
	qt_sql_avg_DecimalV2_agg_phase_3 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), avg(kdcmls1) from fn_test group by kbool order by kbool'''
	qt_sql_avg_DecimalV2_agg_phase_4 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), avg(kdcmls1) from fn_test'''
	qt_sql_avg_DecimalV2_gb_notnull '''
		select avg(kdcmls1) from fn_test_not_nullable group by kbool order by kbool'''
	qt_sql_avg_DecimalV2_notnull '''
		select avg(kdcmls1) from fn_test_not_nullable'''
	qt_sql_avg_DecimalV2_agg_phase_1_notnull '''
		select count(id), avg(kdcmls1) from fn_test_not_nullable group by id order by id'''
	qt_sql_avg_DecimalV2_agg_phase_2_notnull '''
		select count(distinct id), avg(kdcmls1) from fn_test_not_nullable'''
	qt_sql_avg_DecimalV2_agg_phase_3_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), avg(kdcmls1) from fn_test group by kbool order by kbool'''
	qt_sql_avg_DecimalV2_agg_phase_4_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), avg(kdcmls1) from fn_test'''

	qt_sql_avg_weighted_TinyInt_Double_gb '''
		select avg_weighted(ktint, kdbl) from fn_test group by kbool order by kbool'''
	qt_sql_avg_weighted_TinyInt_Double '''
		select avg_weighted(ktint, kdbl) from fn_test'''
	qt_sql_avg_weighted_TinyInt_Double_agg_phase_1 '''
		select count(id), avg_weighted(ktint, kdbl) from fn_test group by id order by id'''
	qt_sql_avg_weighted_TinyInt_Double_agg_phase_2 '''
		select count(distinct id), avg_weighted(ktint, kdbl) from fn_test'''
	qt_sql_avg_weighted_TinyInt_Double_agg_phase_3 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), avg_weighted(ktint, kdbl) from fn_test group by kbool order by kbool'''
	qt_sql_avg_weighted_TinyInt_Double_agg_phase_4 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), avg_weighted(ktint, kdbl) from fn_test'''
	qt_sql_avg_weighted_TinyInt_Double_gb_notnull '''
		select avg_weighted(ktint, kdbl) from fn_test_not_nullable group by kbool order by kbool'''
	qt_sql_avg_weighted_TinyInt_Double_notnull '''
		select avg_weighted(ktint, kdbl) from fn_test_not_nullable'''
	qt_sql_avg_weighted_TinyInt_Double_agg_phase_1_notnull '''
		select count(id), avg_weighted(ktint, kdbl) from fn_test_not_nullable group by id order by id'''
	qt_sql_avg_weighted_TinyInt_Double_agg_phase_2_notnull '''
		select count(distinct id), avg_weighted(ktint, kdbl) from fn_test_not_nullable'''
	qt_sql_avg_weighted_TinyInt_Double_agg_phase_3_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), avg_weighted(ktint, kdbl) from fn_test group by kbool order by kbool'''
	qt_sql_avg_weighted_TinyInt_Double_agg_phase_4_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), avg_weighted(ktint, kdbl) from fn_test'''

	qt_sql_avg_weighted_SmallInt_Double_gb '''
		select avg_weighted(ksint, kdbl) from fn_test group by kbool order by kbool'''
	qt_sql_avg_weighted_SmallInt_Double '''
		select avg_weighted(ksint, kdbl) from fn_test'''
	qt_sql_avg_weighted_SmallInt_Double_agg_phase_1 '''
		select count(id), avg_weighted(ksint, kdbl) from fn_test group by id order by id'''
	qt_sql_avg_weighted_SmallInt_Double_agg_phase_2 '''
		select count(distinct id), avg_weighted(ksint, kdbl) from fn_test'''
	qt_sql_avg_weighted_SmallInt_Double_agg_phase_3 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), avg_weighted(ksint, kdbl) from fn_test group by kbool order by kbool'''
	qt_sql_avg_weighted_SmallInt_Double_agg_phase_4 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), avg_weighted(ksint, kdbl) from fn_test'''
	qt_sql_avg_weighted_SmallInt_Double_gb_notnull '''
		select avg_weighted(ksint, kdbl) from fn_test_not_nullable group by kbool order by kbool'''
	qt_sql_avg_weighted_SmallInt_Double_notnull '''
		select avg_weighted(ksint, kdbl) from fn_test_not_nullable'''
	qt_sql_avg_weighted_SmallInt_Double_agg_phase_1_notnull '''
		select count(id), avg_weighted(ksint, kdbl) from fn_test_not_nullable group by id order by id'''
	qt_sql_avg_weighted_SmallInt_Double_agg_phase_2_notnull '''
		select count(distinct id), avg_weighted(ksint, kdbl) from fn_test_not_nullable'''
	qt_sql_avg_weighted_SmallInt_Double_agg_phase_3_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), avg_weighted(ksint, kdbl) from fn_test group by kbool order by kbool'''
	qt_sql_avg_weighted_SmallInt_Double_agg_phase_4_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), avg_weighted(ksint, kdbl) from fn_test'''

	qt_sql_avg_weighted_Integer_Double_gb '''
		select avg_weighted(kint, kdbl) from fn_test group by kbool order by kbool'''
	qt_sql_avg_weighted_Integer_Double '''
		select avg_weighted(kint, kdbl) from fn_test'''
	qt_sql_avg_weighted_Integer_Double_agg_phase_1 '''
		select count(id), avg_weighted(kint, kdbl) from fn_test group by id order by id'''
	qt_sql_avg_weighted_Integer_Double_agg_phase_2 '''
		select count(distinct id), avg_weighted(kint, kdbl) from fn_test'''
	qt_sql_avg_weighted_Integer_Double_agg_phase_3 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), avg_weighted(kint, kdbl) from fn_test group by kbool order by kbool'''
	qt_sql_avg_weighted_Integer_Double_agg_phase_4 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), avg_weighted(kint, kdbl) from fn_test'''
	qt_sql_avg_weighted_Integer_Double_gb_notnull '''
		select avg_weighted(kint, kdbl) from fn_test_not_nullable group by kbool order by kbool'''
	qt_sql_avg_weighted_Integer_Double_notnull '''
		select avg_weighted(kint, kdbl) from fn_test_not_nullable'''
	qt_sql_avg_weighted_Integer_Double_agg_phase_1_notnull '''
		select count(id), avg_weighted(kint, kdbl) from fn_test_not_nullable group by id order by id'''
	qt_sql_avg_weighted_Integer_Double_agg_phase_2_notnull '''
		select count(distinct id), avg_weighted(kint, kdbl) from fn_test_not_nullable'''
	qt_sql_avg_weighted_Integer_Double_agg_phase_3_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), avg_weighted(kint, kdbl) from fn_test group by kbool order by kbool'''
	qt_sql_avg_weighted_Integer_Double_agg_phase_4_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), avg_weighted(kint, kdbl) from fn_test'''

	qt_sql_avg_weighted_BigInt_Double_gb '''
		select avg_weighted(kbint, kdbl) from fn_test group by kbool order by kbool'''
	qt_sql_avg_weighted_BigInt_Double '''
		select avg_weighted(kbint, kdbl) from fn_test'''
	qt_sql_avg_weighted_BigInt_Double_agg_phase_1 '''
		select count(id), avg_weighted(kbint, kdbl) from fn_test group by id order by id'''
	qt_sql_avg_weighted_BigInt_Double_agg_phase_2 '''
		select count(distinct id), avg_weighted(kbint, kdbl) from fn_test'''
	qt_sql_avg_weighted_BigInt_Double_agg_phase_3 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), avg_weighted(kbint, kdbl) from fn_test group by kbool order by kbool'''
	qt_sql_avg_weighted_BigInt_Double_agg_phase_4 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), avg_weighted(kbint, kdbl) from fn_test'''
	qt_sql_avg_weighted_BigInt_Double_gb_notnull '''
		select avg_weighted(kbint, kdbl) from fn_test_not_nullable group by kbool order by kbool'''
	qt_sql_avg_weighted_BigInt_Double_notnull '''
		select avg_weighted(kbint, kdbl) from fn_test_not_nullable'''
	qt_sql_avg_weighted_BigInt_Double_agg_phase_1_notnull '''
		select count(id), avg_weighted(kbint, kdbl) from fn_test_not_nullable group by id order by id'''
	qt_sql_avg_weighted_BigInt_Double_agg_phase_2_notnull '''
		select count(distinct id), avg_weighted(kbint, kdbl) from fn_test_not_nullable'''
	qt_sql_avg_weighted_BigInt_Double_agg_phase_3_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), avg_weighted(kbint, kdbl) from fn_test group by kbool order by kbool'''
	qt_sql_avg_weighted_BigInt_Double_agg_phase_4_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), avg_weighted(kbint, kdbl) from fn_test'''

	qt_sql_avg_weighted_Float_Double_gb '''
		select avg_weighted(kfloat, kdbl) from fn_test group by kbool order by kbool'''
	qt_sql_avg_weighted_Float_Double '''
		select avg_weighted(kfloat, kdbl) from fn_test'''
	qt_sql_avg_weighted_Float_Double_agg_phase_1 '''
		select count(id), avg_weighted(kfloat, kdbl) from fn_test group by id order by id'''
	qt_sql_avg_weighted_Float_Double_agg_phase_2 '''
		select count(distinct id), avg_weighted(kfloat, kdbl) from fn_test'''
	qt_sql_avg_weighted_Float_Double_agg_phase_3 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), avg_weighted(kfloat, kdbl) from fn_test group by kbool order by kbool'''
	qt_sql_avg_weighted_Float_Double_agg_phase_4 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), avg_weighted(kfloat, kdbl) from fn_test'''
	qt_sql_avg_weighted_Float_Double_gb_notnull '''
		select avg_weighted(kfloat, kdbl) from fn_test_not_nullable group by kbool order by kbool'''
	qt_sql_avg_weighted_Float_Double_notnull '''
		select avg_weighted(kfloat, kdbl) from fn_test_not_nullable'''
	qt_sql_avg_weighted_Float_Double_agg_phase_1_notnull '''
		select count(id), avg_weighted(kfloat, kdbl) from fn_test_not_nullable group by id order by id'''
	qt_sql_avg_weighted_Float_Double_agg_phase_2_notnull '''
		select count(distinct id), avg_weighted(kfloat, kdbl) from fn_test_not_nullable'''
	qt_sql_avg_weighted_Float_Double_agg_phase_3_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), avg_weighted(kfloat, kdbl) from fn_test group by kbool order by kbool'''
	qt_sql_avg_weighted_Float_Double_agg_phase_4_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), avg_weighted(kfloat, kdbl) from fn_test'''

	qt_sql_avg_weighted_Double_Double_gb '''
		select avg_weighted(kdbl, kdbl) from fn_test group by kbool order by kbool'''
	qt_sql_avg_weighted_Double_Double '''
		select avg_weighted(kdbl, kdbl) from fn_test'''
	qt_sql_avg_weighted_Double_Double_agg_phase_1 '''
		select count(id), avg_weighted(kdbl, kdbl) from fn_test group by id order by id'''
	qt_sql_avg_weighted_Double_Double_agg_phase_2 '''
		select count(distinct id), avg_weighted(kdbl, kdbl) from fn_test'''
	qt_sql_avg_weighted_Double_Double_agg_phase_3 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), avg_weighted(kdbl, kdbl) from fn_test group by kbool order by kbool'''
	qt_sql_avg_weighted_Double_Double_agg_phase_4 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), avg_weighted(kdbl, kdbl) from fn_test'''
	qt_sql_avg_weighted_Double_Double_gb_notnull '''
		select avg_weighted(kdbl, kdbl) from fn_test_not_nullable group by kbool order by kbool'''
	qt_sql_avg_weighted_Double_Double_notnull '''
		select avg_weighted(kdbl, kdbl) from fn_test_not_nullable'''
	qt_sql_avg_weighted_Double_Double_agg_phase_1_notnull '''
		select count(id), avg_weighted(kdbl, kdbl) from fn_test_not_nullable group by id order by id'''
	qt_sql_avg_weighted_Double_Double_agg_phase_2_notnull '''
		select count(distinct id), avg_weighted(kdbl, kdbl) from fn_test_not_nullable'''
	qt_sql_avg_weighted_Double_Double_agg_phase_3_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), avg_weighted(kdbl, kdbl) from fn_test group by kbool order by kbool'''
	qt_sql_avg_weighted_Double_Double_agg_phase_4_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), avg_weighted(kdbl, kdbl) from fn_test'''

	qt_sql_avg_weighted_DecimalV2_Double_gb '''
		select avg_weighted(kdcmls1, kdbl) from fn_test group by kbool order by kbool'''
	qt_sql_avg_weighted_DecimalV2_Double '''
		select avg_weighted(kdcmls1, kdbl) from fn_test'''
	qt_sql_avg_weighted_DecimalV2_Double_agg_phase_1 '''
		select count(id), avg_weighted(kdcmls1, kdbl) from fn_test group by id order by id'''
	qt_sql_avg_weighted_DecimalV2_Double_agg_phase_2 '''
		select count(distinct id), avg_weighted(kdcmls1, kdbl) from fn_test'''
	qt_sql_avg_weighted_DecimalV2_Double_agg_phase_3 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), avg_weighted(kdcmls1, kdbl) from fn_test group by kbool order by kbool'''
	qt_sql_avg_weighted_DecimalV2_Double_agg_phase_4 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), avg_weighted(kdcmls1, kdbl) from fn_test'''
	qt_sql_avg_weighted_DecimalV2_Double_gb_notnull '''
		select avg_weighted(kdcmls1, kdbl) from fn_test_not_nullable group by kbool order by kbool'''
	qt_sql_avg_weighted_DecimalV2_Double_notnull '''
		select avg_weighted(kdcmls1, kdbl) from fn_test_not_nullable'''
	qt_sql_avg_weighted_DecimalV2_Double_agg_phase_1_notnull '''
		select count(id), avg_weighted(kdcmls1, kdbl) from fn_test_not_nullable group by id order by id'''
	qt_sql_avg_weighted_DecimalV2_Double_agg_phase_2_notnull '''
		select count(distinct id), avg_weighted(kdcmls1, kdbl) from fn_test_not_nullable'''
	qt_sql_avg_weighted_DecimalV2_Double_agg_phase_3_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), avg_weighted(kdcmls1, kdbl) from fn_test group by kbool order by kbool'''
	qt_sql_avg_weighted_DecimalV2_Double_agg_phase_4_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), avg_weighted(kdcmls1, kdbl) from fn_test'''

	qt_sql_bitmap_intersect_Bitmap_gb '''
		select bitmap_intersect(bitmap_hash(kbint)) from fn_test group by kbool order by kbool'''
	qt_sql_bitmap_intersect_Bitmap '''
		select bitmap_intersect(bitmap_hash(kbint)) from fn_test'''
	qt_sql_bitmap_intersect_Bitmap_agg_phase_1 '''
		select count(id), bitmap_intersect(bitmap_hash(kbint)) from fn_test group by id order by id'''
	qt_sql_bitmap_intersect_Bitmap_agg_phase_2 '''
		select count(distinct id), bitmap_intersect(bitmap_hash(kbint)) from fn_test'''
	qt_sql_bitmap_intersect_Bitmap_agg_phase_3 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), bitmap_intersect(bitmap_hash(kbint)) from fn_test group by kbool order by kbool'''
	qt_sql_bitmap_intersect_Bitmap_agg_phase_4 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), bitmap_intersect(bitmap_hash(kbint)) from fn_test'''
	qt_sql_bitmap_intersect_Bitmap_gb_notnull '''
		select bitmap_intersect(bitmap_hash(kbint)) from fn_test_not_nullable group by kbool order by kbool'''
	qt_sql_bitmap_intersect_Bitmap_notnull '''
		select bitmap_intersect(bitmap_hash(kbint)) from fn_test_not_nullable'''
	qt_sql_bitmap_intersect_Bitmap_agg_phase_1_notnull '''
		select count(id), bitmap_intersect(bitmap_hash(kbint)) from fn_test_not_nullable group by id order by id'''
	qt_sql_bitmap_intersect_Bitmap_agg_phase_2_notnull '''
		select count(distinct id), bitmap_intersect(bitmap_hash(kbint)) from fn_test_not_nullable'''
	qt_sql_bitmap_intersect_Bitmap_agg_phase_3_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), bitmap_intersect(bitmap_hash(kbint)) from fn_test group by kbool order by kbool'''
	qt_sql_bitmap_intersect_Bitmap_agg_phase_4_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), bitmap_intersect(bitmap_hash(kbint)) from fn_test'''

    // bitmap_agg
    qt_sql_bitmap_agg_tinyint """
        select bitmap_count(b) from (select kbool, bitmap_agg(ktint) b from fn_test group by kbool) a order by kbool
    """
    qt_sql_bitmap_agg_smallint """
        select bitmap_count(b) from (select kbool, bitmap_agg(ksint) b from fn_test group by kbool) a order by kbool
    """
    qt_sql_bitmap_agg_int """
        select bitmap_count(b) from (select kbool, bitmap_agg(kint) b from fn_test group by kbool) a order by kbool
    """
    qt_sql_bitmap_agg_bigint """
        select bitmap_count(b) from (select kbool, bitmap_agg(kbint) b from fn_test group by kbool) a order by kbool
    """

	qt_sql_bitmap_union_Bitmap_gb '''
		select bitmap_union(bitmap_hash(kbint)) from fn_test group by kbool order by kbool'''
	qt_sql_bitmap_union_Bitmap '''
		select bitmap_union(bitmap_hash(kbint)) from fn_test'''
	qt_sql_bitmap_union_Bitmap_agg_phase_1 '''
		select count(id), bitmap_union(bitmap_hash(kbint)) from fn_test group by id order by id'''
	qt_sql_bitmap_union_Bitmap_agg_phase_2 '''
		select count(distinct id), bitmap_union(bitmap_hash(kbint)) from fn_test'''
	qt_sql_bitmap_union_Bitmap_agg_phase_3 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), bitmap_union(bitmap_hash(kbint)) from fn_test group by kbool order by kbool'''
	qt_sql_bitmap_union_Bitmap_agg_phase_4 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), bitmap_union(bitmap_hash(kbint)) from fn_test'''
	qt_sql_bitmap_union_Bitmap_gb_notnull '''
		select bitmap_union(bitmap_hash(kbint)) from fn_test_not_nullable group by kbool order by kbool'''
	qt_sql_bitmap_union_Bitmap_notnull '''
		select bitmap_union(bitmap_hash(kbint)) from fn_test_not_nullable'''
	qt_sql_bitmap_union_Bitmap_agg_phase_1_notnull '''
		select count(id), bitmap_union(bitmap_hash(kbint)) from fn_test_not_nullable group by id order by id'''
	qt_sql_bitmap_union_Bitmap_agg_phase_2_notnull '''
		select count(distinct id), bitmap_union(bitmap_hash(kbint)) from fn_test_not_nullable'''
	qt_sql_bitmap_union_Bitmap_agg_phase_3_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), bitmap_union(bitmap_hash(kbint)) from fn_test group by kbool order by kbool'''
	qt_sql_bitmap_union_Bitmap_agg_phase_4_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), bitmap_union(bitmap_hash(kbint)) from fn_test'''

	qt_sql_bitmap_union_count_Bitmap_gb '''
		select bitmap_union_count(bitmap_hash(kbint)) from fn_test group by kbool order by kbool'''
	qt_sql_bitmap_union_count_Bitmap '''
		select bitmap_union_count(bitmap_hash(kbint)) from fn_test'''
	qt_sql_bitmap_union_count_Bitmap_agg_phase_1 '''
		select count(id), bitmap_union_count(bitmap_hash(kbint)) from fn_test group by id order by id'''
	qt_sql_bitmap_union_count_Bitmap_agg_phase_2 '''
		select count(distinct id), bitmap_union_count(bitmap_hash(kbint)) from fn_test'''
	qt_sql_bitmap_union_count_Bitmap_agg_phase_3 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), bitmap_union_count(bitmap_hash(kbint)) from fn_test group by kbool order by kbool'''
	qt_sql_bitmap_union_count_Bitmap_agg_phase_4 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), bitmap_union_count(bitmap_hash(kbint)) from fn_test'''
	qt_sql_bitmap_union_count_Bitmap_gb_notnull '''
		select bitmap_union_count(bitmap_hash(kbint)) from fn_test_not_nullable group by kbool order by kbool'''
	qt_sql_bitmap_union_count_Bitmap_notnull '''
		select bitmap_union_count(bitmap_hash(kbint)) from fn_test_not_nullable'''
	qt_sql_bitmap_union_count_Bitmap_agg_phase_1_notnull '''
		select count(id), bitmap_union_count(bitmap_hash(kbint)) from fn_test_not_nullable group by id order by id'''
	qt_sql_bitmap_union_count_Bitmap_agg_phase_2_notnull '''
		select count(distinct id), bitmap_union_count(bitmap_hash(kbint)) from fn_test_not_nullable'''
	qt_sql_bitmap_union_count_Bitmap_agg_phase_3_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), bitmap_union_count(bitmap_hash(kbint)) from fn_test group by kbool order by kbool'''
	qt_sql_bitmap_union_count_Bitmap_agg_phase_4_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), bitmap_union_count(bitmap_hash(kbint)) from fn_test'''

	qt_sql_bitmap_union_int_SmallInt_gb '''
		select bitmap_union_int(ksint) from fn_test group by kbool order by kbool'''
	qt_sql_bitmap_union_int_SmallInt '''
		select bitmap_union_int(ksint) from fn_test'''
	qt_sql_bitmap_union_int_SmallInt_agg_phase_1 '''
		select count(id), bitmap_union_int(ksint) from fn_test group by id order by id'''
	qt_sql_bitmap_union_int_SmallInt_agg_phase_2 '''
		select count(distinct id), bitmap_union_int(ksint) from fn_test'''
	qt_sql_bitmap_union_int_SmallInt_agg_phase_3 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), bitmap_union_int(ksint) from fn_test group by kbool order by kbool'''
	qt_sql_bitmap_union_int_SmallInt_agg_phase_4 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), bitmap_union_int(ksint) from fn_test'''
	qt_sql_bitmap_union_int_SmallInt_gb_notnull '''
		select bitmap_union_int(ksint) from fn_test_not_nullable group by kbool order by kbool'''
	qt_sql_bitmap_union_int_SmallInt_notnull '''
		select bitmap_union_int(ksint) from fn_test_not_nullable'''
	qt_sql_bitmap_union_int_SmallInt_agg_phase_1_notnull '''
		select count(id), bitmap_union_int(ksint) from fn_test_not_nullable group by id order by id'''
	qt_sql_bitmap_union_int_SmallInt_agg_phase_2_notnull '''
		select count(distinct id), bitmap_union_int(ksint) from fn_test_not_nullable'''
	qt_sql_bitmap_union_int_SmallInt_agg_phase_3_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), bitmap_union_int(ksint) from fn_test group by kbool order by kbool'''
	qt_sql_bitmap_union_int_SmallInt_agg_phase_4_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), bitmap_union_int(ksint) from fn_test'''

	qt_sql_bitmap_union_int_TinyInt_gb '''
		select bitmap_union_int(ktint) from fn_test group by kbool order by kbool'''
	qt_sql_bitmap_union_int_TinyInt '''
		select bitmap_union_int(ktint) from fn_test'''
	qt_sql_bitmap_union_int_TinyInt_agg_phase_1 '''
		select count(id), bitmap_union_int(ktint) from fn_test group by id order by id'''
	qt_sql_bitmap_union_int_TinyInt_agg_phase_2 '''
		select count(distinct id), bitmap_union_int(ktint) from fn_test'''
	qt_sql_bitmap_union_int_TinyInt_agg_phase_3 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), bitmap_union_int(ktint) from fn_test group by kbool order by kbool'''
	qt_sql_bitmap_union_int_TinyInt_agg_phase_4 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), bitmap_union_int(ktint) from fn_test'''
	qt_sql_bitmap_union_int_TinyInt_gb_notnull '''
		select bitmap_union_int(ktint) from fn_test_not_nullable group by kbool order by kbool'''
	qt_sql_bitmap_union_int_TinyInt_notnull '''
		select bitmap_union_int(ktint) from fn_test_not_nullable'''
	qt_sql_bitmap_union_int_TinyInt_agg_phase_1_notnull '''
		select count(id), bitmap_union_int(ktint) from fn_test_not_nullable group by id order by id'''
	qt_sql_bitmap_union_int_TinyInt_agg_phase_2_notnull '''
		select count(distinct id), bitmap_union_int(ktint) from fn_test_not_nullable'''
	qt_sql_bitmap_union_int_TinyInt_agg_phase_3_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), bitmap_union_int(ktint) from fn_test group by kbool order by kbool'''
	qt_sql_bitmap_union_int_TinyInt_agg_phase_4_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), bitmap_union_int(ktint) from fn_test'''

	qt_sql_bitmap_union_int_Integer_gb '''
		select bitmap_union_int(kint) from fn_test group by kbool order by kbool'''
	qt_sql_bitmap_union_int_Integer '''
		select bitmap_union_int(kint) from fn_test'''
	qt_sql_bitmap_union_int_Integer_agg_phase_1 '''
		select count(id), bitmap_union_int(kint) from fn_test group by id order by id'''
	qt_sql_bitmap_union_int_Integer_agg_phase_2 '''
		select count(distinct id), bitmap_union_int(kint) from fn_test'''
	qt_sql_bitmap_union_int_Integer_agg_phase_3 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), bitmap_union_int(kint) from fn_test group by kbool order by kbool'''
	qt_sql_bitmap_union_int_Integer_agg_phase_4 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), bitmap_union_int(kint) from fn_test'''
	qt_sql_bitmap_union_int_Integer_gb_notnull '''
		select bitmap_union_int(kint) from fn_test_not_nullable group by kbool order by kbool'''
	qt_sql_bitmap_union_int_Integer_notnull '''
		select bitmap_union_int(kint) from fn_test_not_nullable'''
	qt_sql_bitmap_union_int_Integer_agg_phase_1_notnull '''
		select count(id), bitmap_union_int(kint) from fn_test_not_nullable group by id order by id'''
	qt_sql_bitmap_union_int_Integer_agg_phase_2_notnull '''
		select count(distinct id), bitmap_union_int(kint) from fn_test_not_nullable'''
	qt_sql_bitmap_union_int_Integer_agg_phase_3_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), bitmap_union_int(kint) from fn_test group by kbool order by kbool'''
	qt_sql_bitmap_union_int_Integer_agg_phase_4_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), bitmap_union_int(kint) from fn_test'''

	qt_sql_count_gb '''
		select count() from fn_test group by kbool order by kbool'''
	qt_sql_count '''
		select count() from fn_test'''
	qt_sql_count_agg_phase_1 '''
		select count(id), count() from fn_test group by id order by id'''
	qt_sql_count_agg_phase_2 '''
		select count(distinct id), count() from fn_test'''
	qt_sql_count_agg_phase_3 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), count() from fn_test group by kbool order by kbool'''
	qt_sql_count_agg_phase_4 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), count() from fn_test'''
	qt_sql_count_gb_notnull '''
		select count() from fn_test_not_nullable group by kbool order by kbool'''
	qt_sql_count_notnull '''
		select count() from fn_test_not_nullable'''
	qt_sql_count_agg_phase_1_notnull '''
		select count(id), count() from fn_test_not_nullable group by id order by id'''
	qt_sql_count_agg_phase_2_notnull '''
		select count(distinct id), count() from fn_test_not_nullable'''
	qt_sql_count_agg_phase_3_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), count() from fn_test group by kbool order by kbool'''
	qt_sql_count_agg_phase_4_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), count() from fn_test'''

	qt_sql_count_array_gb '''
        select count(kaint) from fn_test group by kbool order by kbool'''
	qt_sql_count_AnyData_gb '''
		select count(kint) from fn_test group by kbool order by kbool'''
	qt_sql_count_AnyData '''
		select count(kint) from fn_test'''
	qt_sql_count_AnyData_agg_phase_1 '''
		select count(id), count(kint) from fn_test group by id order by id'''
	qt_sql_count_AnyData_agg_phase_2 '''
		select count(distinct id), count(kint) from fn_test'''
	qt_sql_count_AnyData_agg_phase_3 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), count(kint) from fn_test group by kbool order by kbool'''
	qt_sql_count_AnyData_agg_phase_4 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), count(kint) from fn_test'''
	qt_sql_count_AnyData_gb_notnull '''
		select count(kint) from fn_test_not_nullable group by kbool order by kbool'''
	qt_sql_count_AnyData_notnull '''
		select count(kint) from fn_test_not_nullable'''
	qt_sql_count_AnyData_agg_phase_1_notnull '''
		select count(id), count(kint) from fn_test_not_nullable group by id order by id'''
	qt_sql_count_AnyData_agg_phase_2_notnull '''
		select count(distinct id), count(kint) from fn_test_not_nullable'''
	qt_sql_count_AnyData_agg_phase_3_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), count(kint) from fn_test group by kbool order by kbool'''
	qt_sql_count_AnyData_agg_phase_4_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), count(kint) from fn_test'''
	qt_sql_group_bit_and_TinyInt_gb '''
		select group_bit_and(ktint) from fn_test group by kbool order by kbool'''
	qt_sql_group_bit_and_TinyInt '''
		select group_bit_and(ktint) from fn_test'''
	qt_sql_group_bit_and_TinyInt_agg_phase_1 '''
		select count(id), group_bit_and(ktint) from fn_test group by id order by id'''
	qt_sql_group_bit_and_TinyInt_agg_phase_2 '''
		select count(distinct id), group_bit_and(ktint) from fn_test'''
	qt_sql_group_bit_and_TinyInt_agg_phase_3 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), group_bit_and(ktint) from fn_test group by kbool order by kbool'''
	qt_sql_group_bit_and_TinyInt_agg_phase_4 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), group_bit_and(ktint) from fn_test'''
	qt_sql_group_bit_and_TinyInt_gb_notnull '''
		select group_bit_and(ktint) from fn_test_not_nullable group by kbool order by kbool'''
	qt_sql_group_bit_and_TinyInt_notnull '''
		select group_bit_and(ktint) from fn_test_not_nullable'''
	qt_sql_group_bit_and_TinyInt_agg_phase_1_notnull '''
		select count(id), group_bit_and(ktint) from fn_test_not_nullable group by id order by id'''
	qt_sql_group_bit_and_TinyInt_agg_phase_2_notnull '''
		select count(distinct id), group_bit_and(ktint) from fn_test_not_nullable'''
	qt_sql_group_bit_and_TinyInt_agg_phase_3_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), group_bit_and(ktint) from fn_test group by kbool order by kbool'''
	qt_sql_group_bit_and_TinyInt_agg_phase_4_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), group_bit_and(ktint) from fn_test'''

	qt_sql_group_bit_and_SmallInt_gb '''
		select group_bit_and(ksint) from fn_test group by kbool order by kbool'''
	qt_sql_group_bit_and_SmallInt '''
		select group_bit_and(ksint) from fn_test'''
	qt_sql_group_bit_and_SmallInt_agg_phase_1 '''
		select count(id), group_bit_and(ksint) from fn_test group by id order by id'''
	qt_sql_group_bit_and_SmallInt_agg_phase_2 '''
		select count(distinct id), group_bit_and(ksint) from fn_test'''
	qt_sql_group_bit_and_SmallInt_agg_phase_3 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), group_bit_and(ksint) from fn_test group by kbool order by kbool'''
	qt_sql_group_bit_and_SmallInt_agg_phase_4 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), group_bit_and(ksint) from fn_test'''
	qt_sql_group_bit_and_SmallInt_gb_notnull '''
		select group_bit_and(ksint) from fn_test_not_nullable group by kbool order by kbool'''
	qt_sql_group_bit_and_SmallInt_notnull '''
		select group_bit_and(ksint) from fn_test_not_nullable'''
	qt_sql_group_bit_and_SmallInt_agg_phase_1_notnull '''
		select count(id), group_bit_and(ksint) from fn_test_not_nullable group by id order by id'''
	qt_sql_group_bit_and_SmallInt_agg_phase_2_notnull '''
		select count(distinct id), group_bit_and(ksint) from fn_test_not_nullable'''
	qt_sql_group_bit_and_SmallInt_agg_phase_3_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), group_bit_and(ksint) from fn_test group by kbool order by kbool'''
	qt_sql_group_bit_and_SmallInt_agg_phase_4_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), group_bit_and(ksint) from fn_test'''

	qt_sql_group_bit_and_Integer_gb '''
		select group_bit_and(kint) from fn_test group by kbool order by kbool'''
	qt_sql_group_bit_and_Integer '''
		select group_bit_and(kint) from fn_test'''
	qt_sql_group_bit_and_Integer_agg_phase_1 '''
		select count(id), group_bit_and(kint) from fn_test group by id order by id'''
	qt_sql_group_bit_and_Integer_agg_phase_2 '''
		select count(distinct id), group_bit_and(kint) from fn_test'''
	qt_sql_group_bit_and_Integer_agg_phase_3 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), group_bit_and(kint) from fn_test group by kbool order by kbool'''
	qt_sql_group_bit_and_Integer_agg_phase_4 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), group_bit_and(kint) from fn_test'''
	qt_sql_group_bit_and_Integer_gb_notnull '''
		select group_bit_and(kint) from fn_test_not_nullable group by kbool order by kbool'''
	qt_sql_group_bit_and_Integer_notnull '''
		select group_bit_and(kint) from fn_test_not_nullable'''
	qt_sql_group_bit_and_Integer_agg_phase_1_notnull '''
		select count(id), group_bit_and(kint) from fn_test_not_nullable group by id order by id'''
	qt_sql_group_bit_and_Integer_agg_phase_2_notnull '''
		select count(distinct id), group_bit_and(kint) from fn_test_not_nullable'''
	qt_sql_group_bit_and_Integer_agg_phase_3_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), group_bit_and(kint) from fn_test group by kbool order by kbool'''
	qt_sql_group_bit_and_Integer_agg_phase_4_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), group_bit_and(kint) from fn_test'''

	qt_sql_group_bit_and_BigInt_gb '''
		select group_bit_and(kbint) from fn_test group by kbool order by kbool'''
	qt_sql_group_bit_and_BigInt '''
		select group_bit_and(kbint) from fn_test'''
	qt_sql_group_bit_and_BigInt_agg_phase_1 '''
		select count(id), group_bit_and(kbint) from fn_test group by id order by id'''
	qt_sql_group_bit_and_BigInt_agg_phase_2 '''
		select count(distinct id), group_bit_and(kbint) from fn_test'''
	qt_sql_group_bit_and_BigInt_agg_phase_3 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), group_bit_and(kbint) from fn_test group by kbool order by kbool'''
	qt_sql_group_bit_and_BigInt_agg_phase_4 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), group_bit_and(kbint) from fn_test'''
	qt_sql_group_bit_and_BigInt_gb_notnull '''
		select group_bit_and(kbint) from fn_test_not_nullable group by kbool order by kbool'''
	qt_sql_group_bit_and_BigInt_notnull '''
		select group_bit_and(kbint) from fn_test_not_nullable'''
	qt_sql_group_bit_and_BigInt_agg_phase_1_notnull '''
		select count(id), group_bit_and(kbint) from fn_test_not_nullable group by id order by id'''
	qt_sql_group_bit_and_BigInt_agg_phase_2_notnull '''
		select count(distinct id), group_bit_and(kbint) from fn_test_not_nullable'''
	qt_sql_group_bit_and_BigInt_agg_phase_3_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), group_bit_and(kbint) from fn_test group by kbool order by kbool'''
	qt_sql_group_bit_and_BigInt_agg_phase_4_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), group_bit_and(kbint) from fn_test'''

	qt_sql_group_bit_and_LargeInt_gb '''
		select group_bit_and(klint) from fn_test group by kbool order by kbool'''
	qt_sql_group_bit_and_LargeInt '''
		select group_bit_and(klint) from fn_test'''
	qt_sql_group_bit_and_LargeInt_agg_phase_1 '''
		select count(id), group_bit_and(klint) from fn_test group by id order by id'''
	qt_sql_group_bit_and_LargeInt_agg_phase_2 '''
		select count(distinct id), group_bit_and(klint) from fn_test'''
	qt_sql_group_bit_and_LargeInt_agg_phase_3 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), group_bit_and(klint) from fn_test group by kbool order by kbool'''
	qt_sql_group_bit_and_LargeInt_agg_phase_4 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), group_bit_and(klint) from fn_test'''
	qt_sql_group_bit_and_LargeInt_gb_notnull '''
		select group_bit_and(klint) from fn_test_not_nullable group by kbool order by kbool'''
	qt_sql_group_bit_and_LargeInt_notnull '''
		select group_bit_and(klint) from fn_test_not_nullable'''
	qt_sql_group_bit_and_LargeInt_agg_phase_1_notnull '''
		select count(id), group_bit_and(klint) from fn_test_not_nullable group by id order by id'''
	qt_sql_group_bit_and_LargeInt_agg_phase_2_notnull '''
		select count(distinct id), group_bit_and(klint) from fn_test_not_nullable'''
	qt_sql_group_bit_and_LargeInt_agg_phase_3_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), group_bit_and(klint) from fn_test group by kbool order by kbool'''
	qt_sql_group_bit_and_LargeInt_agg_phase_4_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), group_bit_and(klint) from fn_test'''

	qt_sql_group_bit_or_TinyInt_gb '''
		select group_bit_or(ktint) from fn_test group by kbool order by kbool'''
	qt_sql_group_bit_or_TinyInt '''
		select group_bit_or(ktint) from fn_test'''
	qt_sql_group_bit_or_TinyInt_agg_phase_1 '''
		select count(id), group_bit_or(ktint) from fn_test group by id order by id'''
	qt_sql_group_bit_or_TinyInt_agg_phase_2 '''
		select count(distinct id), group_bit_or(ktint) from fn_test'''
	qt_sql_group_bit_or_TinyInt_agg_phase_3 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), group_bit_or(ktint) from fn_test group by kbool order by kbool'''
	qt_sql_group_bit_or_TinyInt_agg_phase_4 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), group_bit_or(ktint) from fn_test'''
	qt_sql_group_bit_or_TinyInt_gb_notnull '''
		select group_bit_or(ktint) from fn_test_not_nullable group by kbool order by kbool'''
	qt_sql_group_bit_or_TinyInt_notnull '''
		select group_bit_or(ktint) from fn_test_not_nullable'''
	qt_sql_group_bit_or_TinyInt_agg_phase_1_notnull '''
		select count(id), group_bit_or(ktint) from fn_test_not_nullable group by id order by id'''
	qt_sql_group_bit_or_TinyInt_agg_phase_2_notnull '''
		select count(distinct id), group_bit_or(ktint) from fn_test_not_nullable'''
	qt_sql_group_bit_or_TinyInt_agg_phase_3_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), group_bit_or(ktint) from fn_test group by kbool order by kbool'''
	qt_sql_group_bit_or_TinyInt_agg_phase_4_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), group_bit_or(ktint) from fn_test'''

	qt_sql_group_bit_or_SmallInt_gb '''
		select group_bit_or(ksint) from fn_test group by kbool order by kbool'''
	qt_sql_group_bit_or_SmallInt '''
		select group_bit_or(ksint) from fn_test'''
	qt_sql_group_bit_or_SmallInt_agg_phase_1 '''
		select count(id), group_bit_or(ksint) from fn_test group by id order by id'''
	qt_sql_group_bit_or_SmallInt_agg_phase_2 '''
		select count(distinct id), group_bit_or(ksint) from fn_test'''
	qt_sql_group_bit_or_SmallInt_agg_phase_3 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), group_bit_or(ksint) from fn_test group by kbool order by kbool'''
	qt_sql_group_bit_or_SmallInt_agg_phase_4 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), group_bit_or(ksint) from fn_test'''
	qt_sql_group_bit_or_SmallInt_gb_notnull '''
		select group_bit_or(ksint) from fn_test_not_nullable group by kbool order by kbool'''
	qt_sql_group_bit_or_SmallInt_notnull '''
		select group_bit_or(ksint) from fn_test_not_nullable'''
	qt_sql_group_bit_or_SmallInt_agg_phase_1_notnull '''
		select count(id), group_bit_or(ksint) from fn_test_not_nullable group by id order by id'''
	qt_sql_group_bit_or_SmallInt_agg_phase_2_notnull '''
		select count(distinct id), group_bit_or(ksint) from fn_test_not_nullable'''
	qt_sql_group_bit_or_SmallInt_agg_phase_3_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), group_bit_or(ksint) from fn_test group by kbool order by kbool'''
	qt_sql_group_bit_or_SmallInt_agg_phase_4_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), group_bit_or(ksint) from fn_test'''

	qt_sql_group_bit_or_Integer_gb '''
		select group_bit_or(kint) from fn_test group by kbool order by kbool'''
	qt_sql_group_bit_or_Integer '''
		select group_bit_or(kint) from fn_test'''
	qt_sql_group_bit_or_Integer_agg_phase_1 '''
		select count(id), group_bit_or(kint) from fn_test group by id order by id'''
	qt_sql_group_bit_or_Integer_agg_phase_2 '''
		select count(distinct id), group_bit_or(kint) from fn_test'''
	qt_sql_group_bit_or_Integer_agg_phase_3 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), group_bit_or(kint) from fn_test group by kbool order by kbool'''
	qt_sql_group_bit_or_Integer_agg_phase_4 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), group_bit_or(kint) from fn_test'''
	qt_sql_group_bit_or_Integer_gb_notnull '''
		select group_bit_or(kint) from fn_test_not_nullable group by kbool order by kbool'''
	qt_sql_group_bit_or_Integer_notnull '''
		select group_bit_or(kint) from fn_test_not_nullable'''
	qt_sql_group_bit_or_Integer_agg_phase_1_notnull '''
		select count(id), group_bit_or(kint) from fn_test_not_nullable group by id order by id'''
	qt_sql_group_bit_or_Integer_agg_phase_2_notnull '''
		select count(distinct id), group_bit_or(kint) from fn_test_not_nullable'''
	qt_sql_group_bit_or_Integer_agg_phase_3_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), group_bit_or(kint) from fn_test group by kbool order by kbool'''
	qt_sql_group_bit_or_Integer_agg_phase_4_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), group_bit_or(kint) from fn_test'''

	qt_sql_group_bit_or_BigInt_gb '''
		select group_bit_or(kbint) from fn_test group by kbool order by kbool'''
	qt_sql_group_bit_or_BigInt '''
		select group_bit_or(kbint) from fn_test'''
	qt_sql_group_bit_or_BigInt_agg_phase_1 '''
		select count(id), group_bit_or(kbint) from fn_test group by id order by id'''
	qt_sql_group_bit_or_BigInt_agg_phase_2 '''
		select count(distinct id), group_bit_or(kbint) from fn_test'''
	qt_sql_group_bit_or_BigInt_agg_phase_3 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), group_bit_or(kbint) from fn_test group by kbool order by kbool'''
	qt_sql_group_bit_or_BigInt_agg_phase_4 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), group_bit_or(kbint) from fn_test'''
	qt_sql_group_bit_or_BigInt_gb_notnull '''
		select group_bit_or(kbint) from fn_test_not_nullable group by kbool order by kbool'''
	qt_sql_group_bit_or_BigInt_notnull '''
		select group_bit_or(kbint) from fn_test_not_nullable'''
	qt_sql_group_bit_or_BigInt_agg_phase_1_notnull '''
		select count(id), group_bit_or(kbint) from fn_test_not_nullable group by id order by id'''
	qt_sql_group_bit_or_BigInt_agg_phase_2_notnull '''
		select count(distinct id), group_bit_or(kbint) from fn_test_not_nullable'''
	qt_sql_group_bit_or_BigInt_agg_phase_3_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), group_bit_or(kbint) from fn_test group by kbool order by kbool'''
	qt_sql_group_bit_or_BigInt_agg_phase_4_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), group_bit_or(kbint) from fn_test'''

	qt_sql_group_bit_or_LargeInt_gb '''
		select group_bit_or(klint) from fn_test group by kbool order by kbool'''
	qt_sql_group_bit_or_LargeInt '''
		select group_bit_or(klint) from fn_test'''
	qt_sql_group_bit_or_LargeInt_agg_phase_1 '''
		select count(id), group_bit_or(klint) from fn_test group by id order by id'''
	qt_sql_group_bit_or_LargeInt_agg_phase_2 '''
		select count(distinct id), group_bit_or(klint) from fn_test'''
	qt_sql_group_bit_or_LargeInt_agg_phase_3 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), group_bit_or(klint) from fn_test group by kbool order by kbool'''
	qt_sql_group_bit_or_LargeInt_agg_phase_4 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), group_bit_or(klint) from fn_test'''
	qt_sql_group_bit_or_LargeInt_gb_notnull '''
		select group_bit_or(klint) from fn_test_not_nullable group by kbool order by kbool'''
	qt_sql_group_bit_or_LargeInt_notnull '''
		select group_bit_or(klint) from fn_test_not_nullable'''
	qt_sql_group_bit_or_LargeInt_agg_phase_1_notnull '''
		select count(id), group_bit_or(klint) from fn_test_not_nullable group by id order by id'''
	qt_sql_group_bit_or_LargeInt_agg_phase_2_notnull '''
		select count(distinct id), group_bit_or(klint) from fn_test_not_nullable'''
	qt_sql_group_bit_or_LargeInt_agg_phase_3_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), group_bit_or(klint) from fn_test group by kbool order by kbool'''
	qt_sql_group_bit_or_LargeInt_agg_phase_4_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), group_bit_or(klint) from fn_test'''

	qt_sql_group_bit_xor_TinyInt_gb '''
		select group_bit_xor(ktint) from fn_test group by kbool order by kbool'''
	qt_sql_group_bit_xor_TinyInt '''
		select group_bit_xor(ktint) from fn_test'''
	qt_sql_group_bit_xor_TinyInt_agg_phase_1 '''
		select count(id), group_bit_xor(ktint) from fn_test group by id order by id'''
	qt_sql_group_bit_xor_TinyInt_agg_phase_2 '''
		select count(distinct id), group_bit_xor(ktint) from fn_test'''
	qt_sql_group_bit_xor_TinyInt_agg_phase_3 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), group_bit_xor(ktint) from fn_test group by kbool order by kbool'''
	qt_sql_group_bit_xor_TinyInt_agg_phase_4 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), group_bit_xor(ktint) from fn_test'''
	qt_sql_group_bit_xor_TinyInt_gb_notnull '''
		select group_bit_xor(ktint) from fn_test_not_nullable group by kbool order by kbool'''
	qt_sql_group_bit_xor_TinyInt_notnull '''
		select group_bit_xor(ktint) from fn_test_not_nullable'''
	qt_sql_group_bit_xor_TinyInt_agg_phase_1_notnull '''
		select count(id), group_bit_xor(ktint) from fn_test_not_nullable group by id order by id'''
	qt_sql_group_bit_xor_TinyInt_agg_phase_2_notnull '''
		select count(distinct id), group_bit_xor(ktint) from fn_test_not_nullable'''
	qt_sql_group_bit_xor_TinyInt_agg_phase_3_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), group_bit_xor(ktint) from fn_test group by kbool order by kbool'''
	qt_sql_group_bit_xor_TinyInt_agg_phase_4_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), group_bit_xor(ktint) from fn_test'''

	qt_sql_group_bit_xor_SmallInt_gb '''
		select group_bit_xor(ksint) from fn_test group by kbool order by kbool'''
	qt_sql_group_bit_xor_SmallInt '''
		select group_bit_xor(ksint) from fn_test'''
	qt_sql_group_bit_xor_SmallInt_agg_phase_1 '''
		select count(id), group_bit_xor(ksint) from fn_test group by id order by id'''
	qt_sql_group_bit_xor_SmallInt_agg_phase_2 '''
		select count(distinct id), group_bit_xor(ksint) from fn_test'''
	qt_sql_group_bit_xor_SmallInt_agg_phase_3 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), group_bit_xor(ksint) from fn_test group by kbool order by kbool'''
	qt_sql_group_bit_xor_SmallInt_agg_phase_4 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), group_bit_xor(ksint) from fn_test'''
	qt_sql_group_bit_xor_SmallInt_gb_notnull '''
		select group_bit_xor(ksint) from fn_test_not_nullable group by kbool order by kbool'''
	qt_sql_group_bit_xor_SmallInt_notnull '''
		select group_bit_xor(ksint) from fn_test_not_nullable'''
	qt_sql_group_bit_xor_SmallInt_agg_phase_1_notnull '''
		select count(id), group_bit_xor(ksint) from fn_test_not_nullable group by id order by id'''
	qt_sql_group_bit_xor_SmallInt_agg_phase_2_notnull '''
		select count(distinct id), group_bit_xor(ksint) from fn_test_not_nullable'''
	qt_sql_group_bit_xor_SmallInt_agg_phase_3_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), group_bit_xor(ksint) from fn_test group by kbool order by kbool'''
	qt_sql_group_bit_xor_SmallInt_agg_phase_4_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), group_bit_xor(ksint) from fn_test'''

	qt_sql_group_bit_xor_Integer_gb '''
		select group_bit_xor(kint) from fn_test group by kbool order by kbool'''
	qt_sql_group_bit_xor_Integer '''
		select group_bit_xor(kint) from fn_test'''
	qt_sql_group_bit_xor_Integer_agg_phase_1 '''
		select count(id), group_bit_xor(kint) from fn_test group by id order by id'''
	qt_sql_group_bit_xor_Integer_agg_phase_2 '''
		select count(distinct id), group_bit_xor(kint) from fn_test'''
	qt_sql_group_bit_xor_Integer_agg_phase_3 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), group_bit_xor(kint) from fn_test group by kbool order by kbool'''
	qt_sql_group_bit_xor_Integer_agg_phase_4 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), group_bit_xor(kint) from fn_test'''
	qt_sql_group_bit_xor_Integer_gb_notnull '''
		select group_bit_xor(kint) from fn_test_not_nullable group by kbool order by kbool'''
	qt_sql_group_bit_xor_Integer_notnull '''
		select group_bit_xor(kint) from fn_test_not_nullable'''
	qt_sql_group_bit_xor_Integer_agg_phase_1_notnull '''
		select count(id), group_bit_xor(kint) from fn_test_not_nullable group by id order by id'''
	qt_sql_group_bit_xor_Integer_agg_phase_2_notnull '''
		select count(distinct id), group_bit_xor(kint) from fn_test_not_nullable'''
	qt_sql_group_bit_xor_Integer_agg_phase_3_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), group_bit_xor(kint) from fn_test group by kbool order by kbool'''
	qt_sql_group_bit_xor_Integer_agg_phase_4_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), group_bit_xor(kint) from fn_test'''

	qt_sql_group_bit_xor_BigInt_gb '''
		select group_bit_xor(kbint) from fn_test group by kbool order by kbool'''
	qt_sql_group_bit_xor_BigInt '''
		select group_bit_xor(kbint) from fn_test'''
	qt_sql_group_bit_xor_BigInt_agg_phase_1 '''
		select count(id), group_bit_xor(kbint) from fn_test group by id order by id'''
	qt_sql_group_bit_xor_BigInt_agg_phase_2 '''
		select count(distinct id), group_bit_xor(kbint) from fn_test'''
	qt_sql_group_bit_xor_BigInt_agg_phase_3 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), group_bit_xor(kbint) from fn_test group by kbool order by kbool'''
	qt_sql_group_bit_xor_BigInt_agg_phase_4 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), group_bit_xor(kbint) from fn_test'''
	qt_sql_group_bit_xor_BigInt_gb_notnull '''
		select group_bit_xor(kbint) from fn_test_not_nullable group by kbool order by kbool'''
	qt_sql_group_bit_xor_BigInt_notnull '''
		select group_bit_xor(kbint) from fn_test_not_nullable'''
	qt_sql_group_bit_xor_BigInt_agg_phase_1_notnull '''
		select count(id), group_bit_xor(kbint) from fn_test_not_nullable group by id order by id'''
	qt_sql_group_bit_xor_BigInt_agg_phase_2_notnull '''
		select count(distinct id), group_bit_xor(kbint) from fn_test_not_nullable'''
	qt_sql_group_bit_xor_BigInt_agg_phase_3_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), group_bit_xor(kbint) from fn_test group by kbool order by kbool'''
	qt_sql_group_bit_xor_BigInt_agg_phase_4_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), group_bit_xor(kbint) from fn_test'''

	qt_sql_group_bit_xor_LargeInt_gb '''
		select group_bit_xor(klint) from fn_test group by kbool order by kbool'''
	qt_sql_group_bit_xor_LargeInt '''
		select group_bit_xor(klint) from fn_test'''
	qt_sql_group_bit_xor_LargeInt_agg_phase_1 '''
		select count(id), group_bit_xor(klint) from fn_test group by id order by id'''
	qt_sql_group_bit_xor_LargeInt_agg_phase_2 '''
		select count(distinct id), group_bit_xor(klint) from fn_test'''
	qt_sql_group_bit_xor_LargeInt_agg_phase_3 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), group_bit_xor(klint) from fn_test group by kbool order by kbool'''
	qt_sql_group_bit_xor_LargeInt_agg_phase_4 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), group_bit_xor(klint) from fn_test'''
	qt_sql_group_bit_xor_LargeInt_gb_notnull '''
		select group_bit_xor(klint) from fn_test_not_nullable group by kbool order by kbool'''
	qt_sql_group_bit_xor_LargeInt_notnull '''
		select group_bit_xor(klint) from fn_test_not_nullable'''
	qt_sql_group_bit_xor_LargeInt_agg_phase_1_notnull '''
		select count(id), group_bit_xor(klint) from fn_test_not_nullable group by id order by id'''
	qt_sql_group_bit_xor_LargeInt_agg_phase_2_notnull '''
		select count(distinct id), group_bit_xor(klint) from fn_test_not_nullable'''
	qt_sql_group_bit_xor_LargeInt_agg_phase_3_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), group_bit_xor(klint) from fn_test group by kbool order by kbool'''
	qt_sql_group_bit_xor_LargeInt_agg_phase_4_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), group_bit_xor(klint) from fn_test'''

	qt_sql_group_bitmap_xor_Bitmap_gb '''
		select group_bitmap_xor(bitmap_hash(kbint)) from fn_test group by kbool order by kbool'''
	qt_sql_group_bitmap_xor_Bitmap '''
		select group_bitmap_xor(bitmap_hash(kbint)) from fn_test'''
	qt_sql_group_bitmap_xor_Bitmap_agg_phase_1 '''
		select count(id), group_bitmap_xor(bitmap_hash(kbint)) from fn_test group by id order by id'''
	qt_sql_group_bitmap_xor_Bitmap_agg_phase_2 '''
		select count(distinct id), group_bitmap_xor(bitmap_hash(kbint)) from fn_test'''
	qt_sql_group_bitmap_xor_Bitmap_agg_phase_3 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), group_bitmap_xor(bitmap_hash(kbint)) from fn_test group by kbool order by kbool'''
	qt_sql_group_bitmap_xor_Bitmap_agg_phase_4 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), group_bitmap_xor(bitmap_hash(kbint)) from fn_test'''
	qt_sql_group_bitmap_xor_Bitmap_gb_notnull '''
		select group_bitmap_xor(bitmap_hash(kbint)) from fn_test_not_nullable group by kbool order by kbool'''
	qt_sql_group_bitmap_xor_Bitmap_notnull '''
		select group_bitmap_xor(bitmap_hash(kbint)) from fn_test_not_nullable'''
	qt_sql_group_bitmap_xor_Bitmap_agg_phase_1_notnull '''
		select count(id), group_bitmap_xor(bitmap_hash(kbint)) from fn_test_not_nullable group by id order by id'''
	qt_sql_group_bitmap_xor_Bitmap_agg_phase_2_notnull '''
		select count(distinct id), group_bitmap_xor(bitmap_hash(kbint)) from fn_test_not_nullable'''
	qt_sql_group_bitmap_xor_Bitmap_agg_phase_3_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), group_bitmap_xor(bitmap_hash(kbint)) from fn_test group by kbool order by kbool'''
	qt_sql_group_bitmap_xor_Bitmap_agg_phase_4_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), group_bitmap_xor(bitmap_hash(kbint)) from fn_test'''

	// qt_sql_group_concat_Varchar_gb '''
	//	select group_concat(distinct cast(abs(kint) as varchar) order by abs(ksint)) from fn_test group by kbool order by kbool'''
	// qt_sql_group_concat_Varchar '''
	// 	select group_concat(distinct cast(abs(kint) as varchar) order by abs(ksint)) from fn_test'''
	// qt_sql_group_concat_Varchar_agg_phase_1 '''
	// 	select count(id), group_concat(distinct cast(abs(kint) as varchar) order by abs(ksint)) from fn_test group by id order by id'''
	// qt_sql_group_concat_Varchar_gb_notnull '''
	// 	select group_concat(distinct cast(abs(kint) as varchar) order by abs(ksint)) from fn_test_not_nullable group by kbool order by kbool'''
	// qt_sql_group_concat_Varchar_notnull '''
	// 	select group_concat(distinct cast(abs(kint) as varchar) order by abs(ksint)) from fn_test_not_nullable'''
	// qt_sql_group_concat_Varchar_agg_phase_1_notnull '''
	// 	select count(id), group_concat(distinct cast(abs(kint) as varchar) order by abs(ksint)) from fn_test_not_nullable group by id order by id'''

	// qt_sql_group_concat_Varchar_AnyData_gb '''
	// 	select group_concat(distinct cast(abs(kint) as varchar) order by abs(ksint), kdt) from fn_test group by kbool order by kbool'''
	// qt_sql_group_concat_Varchar_AnyData '''
	//	select group_concat(distinct cast(abs(kint) as varchar) order by abs(ksint), kdt) from fn_test'''
	// qt_sql_group_concat_Varchar_AnyData_agg_phase_1 '''
	//	select count(id), group_concat(distinct cast(abs(kint) as varchar) order by abs(ksint), kdt) from fn_test group by id order by id'''
	// qt_sql_group_concat_Varchar_AnyData_gb_notnull '''
	// 	select group_concat(distinct cast(abs(kint) as varchar) order by abs(ksint), kdt) from fn_test_not_nullable group by kbool order by kbool'''
	// qt_sql_group_concat_Varchar_AnyData_notnull '''
	//	select group_concat(distinct cast(abs(kint) as varchar) order by abs(ksint), kdt) from fn_test_not_nullable'''
	// qt_sql_group_concat_Varchar_AnyData_agg_phase_1_notnull '''
	// 	select count(id), group_concat(distinct cast(abs(kint) as varchar) order by abs(ksint), kdt) from fn_test_not_nullable group by id order by id'''

	// qt_sql_group_concat_Varchar_Varchar_AnyData_gb '''
	// 	select group_concat(distinct cast(abs(kint) as varchar), '_x_' order by abs(ksint), kdt) from fn_test group by kbool order by kbool'''
	// qt_sql_group_concat_Varchar_Varchar_AnyData '''
	//	select group_concat(distinct cast(abs(kint) as varchar), '_x_' order by abs(ksint), kdt) from fn_test'''
	// qt_sql_group_concat_Varchar_Varchar_AnyData_agg_phase_1 '''
	// 	select count(id), group_concat(distinct cast(abs(kint) as varchar), '_x_' order by abs(ksint), kdt) from fn_test group by id order by id'''
	// qt_sql_group_concat_Varchar_Varchar_AnyData_gb_notnull '''
	// 	select group_concat(distinct cast(abs(kint) as varchar), '_x_' order by abs(ksint), kdt) from fn_test_not_nullable group by kbool order by kbool'''
	// qt_sql_group_concat_Varchar_Varchar_AnyData_notnull '''
	//	select group_concat(distinct cast(abs(kint) as varchar), '_x_' order by abs(ksint), kdt) from fn_test_not_nullable'''
	// qt_sql_group_concat_Varchar_Varchar_AnyData_agg_phase_1_notnull '''
	//	select count(id), group_concat(distinct cast(abs(kint) as varchar), '_x_' order by abs(ksint), kdt) from fn_test_not_nullable group by id order by id'''

	sql '''
		select histogram(kbool) from fn_test group by kbool order by kbool'''
	sql '''
		select histogram(kbool) from fn_test'''
	sql '''
		select histogram(kbool, 10) from fn_test'''
	sql '''
		select histogram(kbool, 10, 10) from fn_test'''
	sql '''
		select count(id), histogram(kbool) from fn_test group by id order by id'''
	sql '''
		select count(distinct id), histogram(kbool) from fn_test'''
	sql '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), histogram(kbool) from fn_test group by kbool order by kbool'''
	sql '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), histogram(kbool) from fn_test'''
	sql '''
		select histogram(kbool) from fn_test_not_nullable group by kbool order by kbool'''
	sql '''
		select histogram(kbool) from fn_test_not_nullable'''
	sql '''
		select count(id), histogram(kbool) from fn_test_not_nullable group by id order by id'''
	sql '''
		select count(distinct id), histogram(kbool) from fn_test_not_nullable'''
	sql '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), histogram(kbool) from fn_test group by kbool order by kbool'''
	sql '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), histogram(kbool) from fn_test'''

	sql '''
		select histogram(ktint) from fn_test group by kbool order by kbool'''
	sql '''
		select histogram(ktint) from fn_test'''
	sql '''
		select count(id), histogram(ktint) from fn_test group by id order by id'''
	sql '''
		select count(distinct id), histogram(ktint) from fn_test'''
	sql '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), histogram(ktint) from fn_test group by kbool order by kbool'''
	sql '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), histogram(ktint) from fn_test'''
	sql '''
		select histogram(ktint) from fn_test_not_nullable group by kbool order by kbool'''
	sql '''
		select histogram(ktint) from fn_test_not_nullable'''
	sql '''
		select count(id), histogram(ktint) from fn_test_not_nullable group by id order by id'''
	sql '''
		select count(distinct id), histogram(ktint) from fn_test_not_nullable'''
	sql '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), histogram(ktint) from fn_test group by kbool order by kbool'''
	sql '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), histogram(ktint) from fn_test'''

	sql '''
		select histogram(ksint) from fn_test group by kbool order by kbool'''
	sql '''
		select histogram(ksint) from fn_test'''
	sql '''
		select count(id), histogram(ksint) from fn_test group by id order by id'''
	sql '''
		select count(distinct id), histogram(ksint) from fn_test'''
	sql '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), histogram(ksint) from fn_test group by kbool order by kbool'''
	sql '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), histogram(ksint) from fn_test'''
	sql '''
		select histogram(ksint) from fn_test_not_nullable group by kbool order by kbool'''
	sql '''
		select histogram(ksint) from fn_test_not_nullable'''
	sql '''
		select count(id), histogram(ksint) from fn_test_not_nullable group by id order by id'''
	sql '''
		select count(distinct id), histogram(ksint) from fn_test_not_nullable'''
	sql '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), histogram(ksint) from fn_test group by kbool order by kbool'''
	sql '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), histogram(ksint) from fn_test'''

	sql '''
		select histogram(kint) from fn_test group by kbool order by kbool'''
	sql '''
		select histogram(kint) from fn_test'''
	sql '''
		select count(id), histogram(kint) from fn_test group by id order by id'''
	sql '''
		select count(distinct id), histogram(kint) from fn_test'''
	sql '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), histogram(kint) from fn_test group by kbool order by kbool'''
	sql '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), histogram(kint) from fn_test'''
	sql '''
		select histogram(kint) from fn_test_not_nullable group by kbool order by kbool'''
	sql '''
		select histogram(kint) from fn_test_not_nullable'''
	sql '''
		select count(id), histogram(kint) from fn_test_not_nullable group by id order by id'''
	sql '''
		select count(distinct id), histogram(kint) from fn_test_not_nullable'''
	sql '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), histogram(kint) from fn_test group by kbool order by kbool'''
	sql '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), histogram(kint) from fn_test'''

	sql '''
		select histogram(kbint) from fn_test group by kbool order by kbool'''
	sql '''
		select histogram(kbint) from fn_test'''
	sql '''
		select count(id), histogram(kbint) from fn_test group by id order by id'''
	sql '''
		select count(distinct id), histogram(kbint) from fn_test'''
	sql '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), histogram(kbint) from fn_test group by kbool order by kbool'''
	sql '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), histogram(kbint) from fn_test'''
	sql '''
		select histogram(kbint) from fn_test_not_nullable group by kbool order by kbool'''
	sql '''
		select histogram(kbint) from fn_test_not_nullable'''
	sql '''
		select count(id), histogram(kbint) from fn_test_not_nullable group by id order by id'''
	sql '''
		select count(distinct id), histogram(kbint) from fn_test_not_nullable'''
	sql '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), histogram(kbint) from fn_test group by kbool order by kbool'''
	sql '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), histogram(kbint) from fn_test'''

	sql '''
		select histogram(klint) from fn_test group by kbool order by kbool'''
	sql '''
		select histogram(klint) from fn_test'''
	sql '''
		select count(id), histogram(klint) from fn_test group by id order by id'''
	sql '''
		select count(distinct id), histogram(klint) from fn_test'''
	sql '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), histogram(klint) from fn_test group by kbool order by kbool'''
	sql '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), histogram(klint) from fn_test'''
	sql '''
		select histogram(klint) from fn_test_not_nullable group by kbool order by kbool'''
	sql '''
		select histogram(klint) from fn_test_not_nullable'''
	sql '''
		select count(id), histogram(klint) from fn_test_not_nullable group by id order by id'''
	sql '''
		select count(distinct id), histogram(klint) from fn_test_not_nullable'''
	sql '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), histogram(klint) from fn_test group by kbool order by kbool'''
	sql '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), histogram(klint) from fn_test'''

	sql '''
		select histogram(kfloat) from fn_test group by kbool order by kbool'''
	sql '''
		select histogram(kfloat) from fn_test'''
	sql '''
		select count(id), histogram(kfloat) from fn_test group by id order by id'''
	sql '''
		select count(distinct id), histogram(kfloat) from fn_test'''
	sql '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), histogram(kfloat) from fn_test group by kbool order by kbool'''
	sql '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), histogram(kfloat) from fn_test'''
	sql '''
		select histogram(kfloat) from fn_test_not_nullable group by kbool order by kbool'''
	sql '''
		select histogram(kfloat) from fn_test_not_nullable'''
	sql '''
		select count(id), histogram(kfloat) from fn_test_not_nullable group by id order by id'''
	sql '''
		select count(distinct id), histogram(kfloat) from fn_test_not_nullable'''
	sql '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), histogram(kfloat) from fn_test group by kbool order by kbool'''
	sql '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), histogram(kfloat) from fn_test'''

	sql '''
		select histogram(kdbl) from fn_test group by kbool order by kbool'''
	sql '''
		select histogram(kdbl) from fn_test'''
	sql '''
		select count(id), histogram(kdbl) from fn_test group by id order by id'''
	sql '''
		select count(distinct id), histogram(kdbl) from fn_test'''
	sql '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), histogram(kdbl) from fn_test group by kbool order by kbool'''
	sql '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), histogram(kdbl) from fn_test'''
	sql '''
		select histogram(kdbl) from fn_test_not_nullable group by kbool order by kbool'''
	sql '''
		select histogram(kdbl) from fn_test_not_nullable'''
	sql '''
		select count(id), histogram(kdbl) from fn_test_not_nullable group by id order by id'''
	sql '''
		select count(distinct id), histogram(kdbl) from fn_test_not_nullable'''
	sql '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), histogram(kdbl) from fn_test group by kbool order by kbool'''
	sql '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), histogram(kdbl) from fn_test'''

	sql '''
		select histogram(kdcmls1) from fn_test group by kbool order by kbool'''
	sql '''
		select histogram(kdcmls1) from fn_test'''
	sql '''
		select count(id), histogram(kdcmls1) from fn_test group by id order by id'''
	sql '''
		select count(distinct id), histogram(kdcmls1) from fn_test'''
	sql '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), histogram(kdcmls1) from fn_test group by kbool order by kbool'''
	sql '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), histogram(kdcmls1) from fn_test'''
	sql '''
		select histogram(kdcmls1) from fn_test_not_nullable group by kbool order by kbool'''
	sql '''
		select histogram(kdcmls1) from fn_test_not_nullable'''
	sql '''
		select count(id), histogram(kdcmls1) from fn_test_not_nullable group by id order by id'''
	sql '''
		select count(distinct id), histogram(kdcmls1) from fn_test_not_nullable'''
	sql '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), histogram(kdcmls1) from fn_test group by kbool order by kbool'''
	sql '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), histogram(kdcmls1) from fn_test'''

	sql '''
		select histogram(kdt) from fn_test group by kbool order by kbool'''
	sql '''
		select histogram(kdt) from fn_test'''
	sql '''
		select count(id), histogram(kdt) from fn_test group by id order by id'''
	sql '''
		select count(distinct id), histogram(kdt) from fn_test'''
	sql '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), histogram(kdt) from fn_test group by kbool order by kbool'''
	sql '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), histogram(kdt) from fn_test'''
	sql '''
		select histogram(kdt) from fn_test_not_nullable group by kbool order by kbool'''
	sql '''
		select histogram(kdt) from fn_test_not_nullable'''
	sql '''
		select count(id), histogram(kdt) from fn_test_not_nullable group by id order by id'''
	sql '''
		select count(distinct id), histogram(kdt) from fn_test_not_nullable'''
	sql '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), histogram(kdt) from fn_test group by kbool order by kbool'''
	sql '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), histogram(kdt) from fn_test'''

	sql '''
		select histogram(kdtm) from fn_test group by kbool order by kbool'''
	sql '''
		select histogram(kdtm) from fn_test'''
	sql '''
		select count(id), histogram(kdtm) from fn_test group by id order by id'''
	sql '''
		select count(distinct id), histogram(kdtm) from fn_test'''
	sql '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), histogram(kdtm) from fn_test group by kbool order by kbool'''
	sql '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), histogram(kdtm) from fn_test'''
	sql '''
		select histogram(kdtm) from fn_test_not_nullable group by kbool order by kbool'''
	sql '''
		select histogram(kdtm) from fn_test_not_nullable'''
	sql '''
		select count(id), histogram(kdtm) from fn_test_not_nullable group by id order by id'''
	sql '''
		select count(distinct id), histogram(kdtm) from fn_test_not_nullable'''
	sql '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), histogram(kdtm) from fn_test group by kbool order by kbool'''
	sql '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), histogram(kdtm) from fn_test'''

	sql '''
		select histogram(kdtv2) from fn_test group by kbool order by kbool'''
	sql '''
		select histogram(kdtv2) from fn_test'''
	sql '''
		select count(id), histogram(kdtv2) from fn_test group by id order by id'''
	sql '''
		select count(distinct id), histogram(kdtv2) from fn_test'''
	sql '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), histogram(kdtv2) from fn_test group by kbool order by kbool'''
	sql '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), histogram(kdtv2) from fn_test'''
	sql '''
		select histogram(kdtv2) from fn_test_not_nullable group by kbool order by kbool'''
	sql '''
		select histogram(kdtv2) from fn_test_not_nullable'''
	sql '''
		select count(id), histogram(kdtv2) from fn_test_not_nullable group by id order by id'''
	sql '''
		select count(distinct id), histogram(kdtv2) from fn_test_not_nullable'''
	sql '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), histogram(kdtv2) from fn_test group by kbool order by kbool'''
	sql '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), histogram(kdtv2) from fn_test'''

	sql '''
		select histogram(kdtmv2s1) from fn_test group by kbool order by kbool'''
	sql '''
		select histogram(kdtmv2s1) from fn_test'''
	sql '''
		select count(id), histogram(kdtmv2s1) from fn_test group by id order by id'''
	sql '''
		select count(distinct id), histogram(kdtmv2s1) from fn_test'''
	sql '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), histogram(kdtmv2s1) from fn_test group by kbool order by kbool'''
	sql '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), histogram(kdtmv2s1) from fn_test'''
	sql '''
		select histogram(kdtmv2s1) from fn_test_not_nullable group by kbool order by kbool'''
	sql '''
		select histogram(kdtmv2s1) from fn_test_not_nullable'''
	sql '''
		select count(id), histogram(kdtmv2s1) from fn_test_not_nullable group by id order by id'''
	sql '''
		select count(distinct id), histogram(kdtmv2s1) from fn_test_not_nullable'''
	sql '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), histogram(kdtmv2s1) from fn_test group by kbool order by kbool'''
	sql '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), histogram(kdtmv2s1) from fn_test'''

	sql '''
		select histogram(kchrs1) from fn_test group by kbool order by kbool'''
	sql '''
		select histogram(kchrs1) from fn_test'''
	sql '''
		select count(id), histogram(kchrs1) from fn_test group by id order by id'''
	sql '''
		select count(distinct id), histogram(kchrs1) from fn_test'''
	sql '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), histogram(kchrs1) from fn_test group by kbool order by kbool'''
	sql '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), histogram(kchrs1) from fn_test'''
	sql '''
		select histogram(kchrs1) from fn_test_not_nullable group by kbool order by kbool'''
	sql '''
		select histogram(kchrs1) from fn_test_not_nullable'''
	sql '''
		select count(id), histogram(kchrs1) from fn_test_not_nullable group by id order by id'''
	sql '''
		select count(distinct id), histogram(kchrs1) from fn_test_not_nullable'''
	sql '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), histogram(kchrs1) from fn_test group by kbool order by kbool'''
	sql '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), histogram(kchrs1) from fn_test'''

	sql '''
		select histogram(kstr) from fn_test group by kbool order by kbool'''
	sql '''
		select histogram(kstr) from fn_test'''
	sql '''
		select count(id), histogram(kstr) from fn_test group by id order by id'''
	sql '''
		select count(distinct id), histogram(kstr) from fn_test'''
	sql '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), histogram(kstr) from fn_test group by kbool order by kbool'''
	sql '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), histogram(kstr) from fn_test'''
	sql '''
		select histogram(kstr) from fn_test_not_nullable group by kbool order by kbool'''
	sql '''
		select histogram(kstr) from fn_test_not_nullable'''
	sql '''
		select count(id), histogram(kstr) from fn_test_not_nullable group by id order by id'''
	sql '''
		select count(distinct id), histogram(kstr) from fn_test_not_nullable'''
	sql '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), histogram(kstr) from fn_test group by kbool order by kbool'''
	sql '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), histogram(kstr) from fn_test'''

	qt_sql_max_by_AnyData_AnyData_gb '''
		select max_by(kint, kint) from fn_test group by kbool order by kbool'''
	qt_sql_max_by_AnyData_AnyData '''
		select max_by(kint, kint) from fn_test'''
	qt_sql_max_by_AnyData_AnyData_agg_phase_1 '''
		select count(id), max_by(kint, kint) from fn_test group by id order by id'''
	qt_sql_max_by_AnyData_AnyData_agg_phase_2 '''
		select count(distinct id), max_by(kint, kint) from fn_test'''
	qt_sql_max_by_AnyData_AnyData_agg_phase_3 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), max_by(kint, kint) from fn_test group by kbool order by kbool'''
	qt_sql_max_by_AnyData_AnyData_agg_phase_4 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), max_by(kint, kint) from fn_test'''
	qt_sql_max_by_AnyData_AnyData_gb_notnull '''
		select max_by(kint, kint) from fn_test_not_nullable group by kbool order by kbool'''
	qt_sql_max_by_AnyData_AnyData_notnull '''
		select max_by(kint, kint) from fn_test_not_nullable'''
	qt_sql_max_by_AnyData_AnyData_agg_phase_1_notnull '''
		select count(id), max_by(kint, kint) from fn_test_not_nullable group by id order by id'''
	qt_sql_max_by_AnyData_AnyData_agg_phase_2_notnull '''
		select count(distinct id), max_by(kint, kint) from fn_test_not_nullable'''
	qt_sql_max_by_AnyData_AnyData_agg_phase_3_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), max_by(kint, kint) from fn_test group by kbool order by kbool'''
	qt_sql_max_by_AnyData_AnyData_agg_phase_4_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), max_by(kint, kint) from fn_test'''

	qt_sql_min_by_AnyData_AnyData_gb '''
		select min_by(kint, kint) from fn_test group by kbool order by kbool'''
	qt_sql_min_by_AnyData_AnyData '''
		select min_by(kint, kint) from fn_test'''
	qt_sql_min_by_AnyData_AnyData_agg_phase_1 '''
		select count(id), min_by(kint, kint) from fn_test group by id order by id'''
	qt_sql_min_by_AnyData_AnyData_agg_phase_2 '''
		select count(distinct id), min_by(kint, kint) from fn_test'''
	qt_sql_min_by_AnyData_AnyData_agg_phase_3 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), min_by(kint, kint) from fn_test group by kbool order by kbool'''
	qt_sql_min_by_AnyData_AnyData_agg_phase_4 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), min_by(kint, kint) from fn_test'''
	qt_sql_min_by_AnyData_AnyData_gb_notnull '''
		select min_by(kint, kint) from fn_test_not_nullable group by kbool order by kbool'''
	qt_sql_min_by_AnyData_AnyData_notnull '''
		select min_by(kint, kint) from fn_test_not_nullable'''
	qt_sql_min_by_AnyData_AnyData_agg_phase_1_notnull '''
		select count(id), min_by(kint, kint) from fn_test_not_nullable group by id order by id'''
	qt_sql_min_by_AnyData_AnyData_agg_phase_2_notnull '''
		select count(distinct id), min_by(kint, kint) from fn_test_not_nullable'''
	qt_sql_min_by_AnyData_AnyData_agg_phase_3_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), min_by(kint, kint) from fn_test group by kbool order by kbool'''
	qt_sql_min_by_AnyData_AnyData_agg_phase_4_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), min_by(kint, kint) from fn_test'''

	qt_sql_ndv_AnyData_gb '''
		select ndv(kint) from fn_test group by kbool order by kbool'''
	qt_sql_ndv_AnyData '''
		select ndv(kint) from fn_test'''
	qt_sql_ndv_AnyData_agg_phase_1 '''
		select count(id), ndv(kint) from fn_test group by id order by id'''
	qt_sql_ndv_AnyData_agg_phase_2 '''
		select count(distinct id), ndv(kint) from fn_test'''
	qt_sql_ndv_AnyData_agg_phase_3 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), ndv(kint) from fn_test group by kbool order by kbool'''
	qt_sql_ndv_AnyData_agg_phase_4 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), ndv(kint) from fn_test'''
	qt_sql_ndv_AnyData_gb_notnull '''
		select ndv(kint) from fn_test_not_nullable group by kbool order by kbool'''
	qt_sql_ndv_AnyData_notnull '''
		select ndv(kint) from fn_test_not_nullable'''
	qt_sql_ndv_AnyData_agg_phase_1_notnull '''
		select count(id), ndv(kint) from fn_test_not_nullable group by id order by id'''
	qt_sql_ndv_AnyData_agg_phase_2_notnull '''
		select count(distinct id), ndv(kint) from fn_test_not_nullable'''
	qt_sql_ndv_AnyData_agg_phase_3_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), ndv(kint) from fn_test group by kbool order by kbool'''
	qt_sql_ndv_AnyData_agg_phase_4_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), ndv(kint) from fn_test'''

    // this function result is unstable
	// qt_sql_orthogonal_bitmap_union_count_Bitmap_gb '''
	// 	select orthogonal_bitmap_union_count(bitmap_hash(kbint)) from fn_test group by kbool order by kbool'''
	qt_sql_orthogonal_bitmap_union_count_Bitmap '''
		select orthogonal_bitmap_union_count(bitmap_hash(kbint)) from fn_test'''
	qt_sql_orthogonal_bitmap_union_count_Bitmap_agg_phase_1 '''
		select count(id), orthogonal_bitmap_union_count(bitmap_hash(kbint)) from fn_test group by id order by id'''
	// qt_sql_orthogonal_bitmap_union_count_Bitmap_agg_phase_2 '''
	// 	select count(distinct id), orthogonal_bitmap_union_count(bitmap_hash(kbint)) from fn_test'''
	// qt_sql_orthogonal_bitmap_union_count_Bitmap_agg_phase_3 '''
	// 	select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), orthogonal_bitmap_union_count(bitmap_hash(kbint)) from fn_test group by kbool order by kbool'''
	qt_sql_orthogonal_bitmap_union_count_Bitmap_agg_phase_4 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), orthogonal_bitmap_union_count(bitmap_hash(kbint)) from fn_test'''
    // this function result is unstable
	// qt_sql_orthogonal_bitmap_union_count_Bitmap_gb_notnull '''
	// 	select orthogonal_bitmap_union_count(bitmap_hash(kbint)) from fn_test_not_nullable group by kbool order by kbool'''
	qt_sql_orthogonal_bitmap_union_count_Bitmap_notnull '''
		select orthogonal_bitmap_union_count(bitmap_hash(kbint)) from fn_test_not_nullable'''
	qt_sql_orthogonal_bitmap_union_count_Bitmap_agg_phase_1_notnull '''
		select count(id), orthogonal_bitmap_union_count(bitmap_hash(kbint)) from fn_test_not_nullable group by id order by id'''
	// qt_sql_orthogonal_bitmap_union_count_Bitmap_agg_phase_2_notnull '''
	// 	select count(distinct id), orthogonal_bitmap_union_count(bitmap_hash(kbint)) from fn_test_not_nullable'''
	// qt_sql_orthogonal_bitmap_union_count_Bitmap_agg_phase_3_notnull '''
	// 	select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), orthogonal_bitmap_union_count(bitmap_hash(kbint)) from fn_test group by kbool order by kbool'''
	qt_sql_orthogonal_bitmap_union_count_Bitmap_agg_phase_4_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), orthogonal_bitmap_union_count(bitmap_hash(kbint)) from fn_test'''

	qt_sql_percentile_BigInt_Double_gb '''
		select percentile(kbint, 0.6) from fn_test group by kbool order by kbool'''
	qt_sql_percentile_BigInt_Double '''
		select percentile(kbint, 0.6) from fn_test'''
	qt_sql_percentile_BigInt_Double_agg_phase_1 '''
		select count(id), percentile(kbint, 0.6) from fn_test group by id order by id'''
	qt_sql_percentile_BigInt_Double_agg_phase_2 '''
		select count(distinct id), percentile(kbint, 0.6) from fn_test'''
	qt_sql_percentile_BigInt_Double_agg_phase_3 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), percentile(kbint, 0.6) from fn_test group by kbool order by kbool'''
	qt_sql_percentile_BigInt_Double_agg_phase_4 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), percentile(kbint, 0.6) from fn_test'''
	qt_sql_percentile_BigInt_Double_gb_notnull '''
		select percentile(kbint, 0.6) from fn_test_not_nullable group by kbool order by kbool'''
	qt_sql_percentile_BigInt_Double_notnull '''
		select percentile(kbint, 0.6) from fn_test_not_nullable'''
	qt_sql_percentile_BigInt_Double_agg_phase_1_notnull '''
		select count(id), percentile(kbint, 0.6) from fn_test_not_nullable group by id order by id'''
	qt_sql_percentile_BigInt_Double_agg_phase_2_notnull '''
		select count(distinct id), percentile(kbint, 0.6) from fn_test_not_nullable'''
	qt_sql_percentile_BigInt_Double_agg_phase_3_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), percentile(kbint, 0.6) from fn_test group by kbool order by kbool'''
	qt_sql_percentile_BigInt_Double_agg_phase_4_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), percentile(kbint, 0.6) from fn_test'''

	qt_sql_percentile_approx_Double_Double_gb '''
		select percentile_approx(kdbl, 0.6) from fn_test group by kbool order by kbool'''
	qt_sql_percentile_approx_Double_Double '''
		select percentile_approx(kdbl, 0.6) from fn_test'''
	qt_sql_percentile_approx_Double_Double_agg_phase_1 '''
		select count(id), percentile_approx(kdbl, 0.6) from fn_test group by id order by id'''
	qt_sql_percentile_approx_Double_Double_agg_phase_2 '''
		select count(distinct id), percentile_approx(kdbl, 0.6) from fn_test'''
	qt_sql_percentile_approx_Double_Double_agg_phase_3 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), percentile_approx(kdbl, 0.6) from fn_test group by kbool order by kbool'''
	qt_sql_percentile_approx_Double_Double_agg_phase_4 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), percentile_approx(kdbl, 0.6) from fn_test'''
	qt_sql_percentile_approx_Double_Double_gb_notnull '''
		select percentile_approx(kdbl, 0.6) from fn_test_not_nullable group by kbool order by kbool'''
	qt_sql_percentile_approx_Double_Double_notnull '''
		select percentile_approx(kdbl, 0.6) from fn_test_not_nullable'''
	qt_sql_percentile_approx_Double_Double_agg_phase_1_notnull '''
		select count(id), percentile_approx(kdbl, 0.6) from fn_test_not_nullable group by id order by id'''
	qt_sql_percentile_approx_Double_Double_agg_phase_2_notnull '''
		select count(distinct id), percentile_approx(kdbl, 0.6) from fn_test_not_nullable'''
	qt_sql_percentile_approx_Double_Double_agg_phase_3_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), percentile_approx(kdbl, 0.6) from fn_test group by kbool order by kbool'''
	qt_sql_percentile_approx_Double_Double_agg_phase_4_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), percentile_approx(kdbl, 0.6) from fn_test'''

	qt_sql_percentile_approx_Double_Double_Double_gb '''
		select percentile_approx(kdbl, 0.6, 4096.0) from fn_test group by kbool order by kbool'''
	qt_sql_percentile_approx_Double_Double_Double '''
		select percentile_approx(kdbl, 0.6, 4096.0) from fn_test'''
	qt_sql_percentile_approx_Double_Double_Double_agg_phase_1 '''
		select count(id), percentile_approx(kdbl, 0.6, 4096.0) from fn_test group by id order by id'''
	qt_sql_percentile_approx_Double_Double_Double_agg_phase_2 '''
		select count(distinct id), percentile_approx(kdbl, 0.6, 4096.0) from fn_test'''
	qt_sql_percentile_approx_Double_Double_Double_agg_phase_3 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), percentile_approx(kdbl, 0.6, 4096.0) from fn_test group by kbool order by kbool'''
	qt_sql_percentile_approx_Double_Double_Double_agg_phase_4 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), percentile_approx(kdbl, 0.6, 4096.0) from fn_test'''
	qt_sql_percentile_approx_Double_Double_Double_gb_notnull '''
		select percentile_approx(kdbl, 0.6, 4096.0) from fn_test_not_nullable group by kbool order by kbool'''
	qt_sql_percentile_approx_Double_Double_Double_notnull '''
		select percentile_approx(kdbl, 0.6, 4096.0) from fn_test_not_nullable'''
	qt_sql_percentile_approx_Double_Double_Double_agg_phase_1_notnull '''
		select count(id), percentile_approx(kdbl, 0.6, 4096.0) from fn_test_not_nullable group by id order by id'''
	qt_sql_percentile_approx_Double_Double_Double_agg_phase_2_notnull '''
		select count(distinct id), percentile_approx(kdbl, 0.6, 4096.0) from fn_test_not_nullable'''
	qt_sql_percentile_approx_Double_Double_Double_agg_phase_3_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), percentile_approx(kdbl, 0.6, 4096.0) from fn_test group by kbool order by kbool'''
	qt_sql_percentile_approx_Double_Double_Double_agg_phase_4_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), percentile_approx(kdbl, 0.6, 4096.0) from fn_test'''

	qt_sql_sequence_count_String_DateV2_Boolean_gb '''
		select sequence_count('(?1)(?2)', kdtv2, kint = 1, kint = 2) from fn_test group by kbool order by kbool'''
	qt_sql_sequence_count_String_DateV2_Boolean '''
		select sequence_count('(?1)(?2)', kdtv2, kint = 1, kint = 2) from fn_test'''
	qt_sql_sequence_count_String_DateV2_Boolean_agg_phase_1 '''
		select count(id), sequence_count('(?1)(?2)', kdtv2, kint = 1, kint = 2) from fn_test group by id order by id'''
	qt_sql_sequence_count_String_DateV2_Boolean_agg_phase_2 '''
		select count(distinct id), sequence_count('(?1)(?2)', kdtv2, kint = 1, kint = 2) from fn_test'''
	qt_sql_sequence_count_String_DateV2_Boolean_agg_phase_3 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), sequence_count('(?1)(?2)', kdtv2, kint = 1, kint = 2) from fn_test group by kbool order by kbool'''
	qt_sql_sequence_count_String_DateV2_Boolean_agg_phase_4 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), sequence_count('(?1)(?2)', kdtv2, kint = 1, kint = 2) from fn_test'''
	qt_sql_sequence_count_String_DateV2_Boolean_gb_notnull '''
		select sequence_count('(?1)(?2)', kdtv2, kint = 1, kint = 2) from fn_test_not_nullable group by kbool order by kbool'''
	qt_sql_sequence_count_String_DateV2_Boolean_notnull '''
		select sequence_count('(?1)(?2)', kdtv2, kint = 1, kint = 2) from fn_test_not_nullable'''
	qt_sql_sequence_count_String_DateV2_Boolean_agg_phase_1_notnull '''
		select count(id), sequence_count('(?1)(?2)', kdtv2, kint = 1, kint = 2) from fn_test_not_nullable group by id order by id'''
	qt_sql_sequence_count_String_DateV2_Boolean_agg_phase_2_notnull '''
		select count(distinct id), sequence_count('(?1)(?2)', kdtv2, kint = 1, kint = 2) from fn_test_not_nullable'''
	qt_sql_sequence_count_String_DateV2_Boolean_agg_phase_3_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), sequence_count('(?1)(?2)', kdtv2, kint = 1, kint = 2) from fn_test group by kbool order by kbool'''
	qt_sql_sequence_count_String_DateV2_Boolean_agg_phase_4_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), sequence_count('(?1)(?2)', kdtv2, kint = 1, kint = 2) from fn_test'''

	qt_sql_sequence_count_String_DateTime_Boolean_gb '''
		select sequence_count('(?1)(?2)', kdtm, kint = 1, kint = 2) from fn_test group by kbool order by kbool'''
	qt_sql_sequence_count_String_DateTime_Boolean '''
		select sequence_count('(?1)(?2)', kdtm, kint = 1, kint = 2) from fn_test'''
	qt_sql_sequence_count_String_DateTime_Boolean_agg_phase_1 '''
		select count(id), sequence_count('(?1)(?2)', kdtm, kint = 1, kint = 2) from fn_test group by id order by id'''
	qt_sql_sequence_count_String_DateTime_Boolean_agg_phase_2 '''
		select count(distinct id), sequence_count('(?1)(?2)', kdtm, kint = 1, kint = 2) from fn_test'''
	qt_sql_sequence_count_String_DateTime_Boolean_agg_phase_3 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), sequence_count('(?1)(?2)', kdtm, kint = 1, kint = 2) from fn_test group by kbool order by kbool'''
	qt_sql_sequence_count_String_DateTime_Boolean_agg_phase_4 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), sequence_count('(?1)(?2)', kdtm, kint = 1, kint = 2) from fn_test'''
	qt_sql_sequence_count_String_DateTime_Boolean_gb_notnull '''
		select sequence_count('(?1)(?2)', kdtm, kint = 1, kint = 2) from fn_test_not_nullable group by kbool order by kbool'''
	qt_sql_sequence_count_String_DateTime_Boolean_notnull '''
		select sequence_count('(?1)(?2)', kdtm, kint = 1, kint = 2) from fn_test_not_nullable'''
	qt_sql_sequence_count_String_DateTime_Boolean_agg_phase_1_notnull '''
		select count(id), sequence_count('(?1)(?2)', kdtm, kint = 1, kint = 2) from fn_test_not_nullable group by id order by id'''
	qt_sql_sequence_count_String_DateTime_Boolean_agg_phase_2_notnull '''
		select count(distinct id), sequence_count('(?1)(?2)', kdtm, kint = 1, kint = 2) from fn_test_not_nullable'''
	qt_sql_sequence_count_String_DateTime_Boolean_agg_phase_3_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), sequence_count('(?1)(?2)', kdtm, kint = 1, kint = 2) from fn_test group by kbool order by kbool'''
	qt_sql_sequence_count_String_DateTime_Boolean_agg_phase_4_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), sequence_count('(?1)(?2)', kdtm, kint = 1, kint = 2) from fn_test'''

	qt_sql_sequence_count_String_DateTimeV2_Boolean_gb '''
		select sequence_count('(?1)(?2)', kdtmv2s1, kint = 1, kint = 5) from fn_test group by kbool order by kbool'''
	qt_sql_sequence_count_String_DateTimeV2_Boolean '''
		select sequence_count('(?1)(?2)', kdtmv2s1, kint = 1, kint = 5) from fn_test'''
	qt_sql_sequence_count_String_DateTimeV2_Boolean_agg_phase_1 '''
		select count(id), sequence_count('(?1)(?2)', kdtmv2s1, kint = 1, kint = 5) from fn_test group by id order by id'''
	qt_sql_sequence_count_String_DateTimeV2_Boolean_agg_phase_2 '''
		select count(distinct id), sequence_count('(?1)(?2)', kdtmv2s1, kint = 1, kint = 5) from fn_test'''
	qt_sql_sequence_count_String_DateTimeV2_Boolean_agg_phase_3 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), sequence_count('(?1)(?2)', kdtmv2s1, kint = 1, kint = 5) from fn_test group by kbool order by kbool'''
	qt_sql_sequence_count_String_DateTimeV2_Boolean_agg_phase_4 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), sequence_count('(?1)(?2)', kdtmv2s1, kint = 1, kint = 5) from fn_test'''
	qt_sql_sequence_count_String_DateTimeV2_Boolean_gb_notnull '''
		select sequence_count('(?1)(?2)', kdtmv2s1, kint = 1, kint = 5) from fn_test_not_nullable group by kbool order by kbool'''
	qt_sql_sequence_count_String_DateTimeV2_Boolean_notnull '''
		select sequence_count('(?1)(?2)', kdtmv2s1, kint = 1, kint = 5) from fn_test_not_nullable'''
	qt_sql_sequence_count_String_DateTimeV2_Boolean_agg_phase_1_notnull '''
		select count(id), sequence_count('(?1)(?2)', kdtmv2s1, kint = 1, kint = 5) from fn_test_not_nullable group by id order by id'''
	qt_sql_sequence_count_String_DateTimeV2_Boolean_agg_phase_2_notnull '''
		select count(distinct id), sequence_count('(?1)(?2)', kdtmv2s1, kint = 1, kint = 5) from fn_test_not_nullable'''
	qt_sql_sequence_count_String_DateTimeV2_Boolean_agg_phase_3_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), sequence_count('(?1)(?2)', kdtmv2s1, kint = 1, kint = 5) from fn_test group by kbool order by kbool'''
	qt_sql_sequence_count_String_DateTimeV2_Boolean_agg_phase_4_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), sequence_count('(?1)(?2)', kdtmv2s1, kint = 1, kint = 5) from fn_test'''

	qt_sql_sequence_match_String_DateV2_Boolean_gb '''
		select sequence_match('(?1)(?2)', kdtv2, kint = 1, kint = 2) from fn_test group by kbool order by kbool'''
	qt_sql_sequence_match_String_DateV2_Boolean '''
		select sequence_match('(?1)(?2)', kdtv2, kint = 1, kint = 2) from fn_test'''
	qt_sql_sequence_match_String_DateV2_Boolean_agg_phase_1 '''
		select count(id), sequence_match('(?1)(?2)', kdtv2, kint = 1, kint = 2) from fn_test group by id order by id'''
	qt_sql_sequence_match_String_DateV2_Boolean_agg_phase_2 '''
		select count(distinct id), sequence_match('(?1)(?2)', kdtv2, kint = 1, kint = 2) from fn_test'''
	qt_sql_sequence_match_String_DateV2_Boolean_agg_phase_3 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), sequence_match('(?1)(?2)', kdtv2, kint = 1, kint = 2) from fn_test group by kbool order by kbool'''
	qt_sql_sequence_match_String_DateV2_Boolean_agg_phase_4 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), sequence_match('(?1)(?2)', kdtv2, kint = 1, kint = 2) from fn_test'''
	qt_sql_sequence_match_String_DateV2_Boolean_gb_notnull '''
		select sequence_match('(?1)(?2)', kdtv2, kint = 1, kint = 2) from fn_test_not_nullable group by kbool order by kbool'''
	qt_sql_sequence_match_String_DateV2_Boolean_notnull '''
		select sequence_match('(?1)(?2)', kdtv2, kint = 1, kint = 2) from fn_test_not_nullable'''
	qt_sql_sequence_match_String_DateV2_Boolean_agg_phase_1_notnull '''
		select count(id), sequence_match('(?1)(?2)', kdtv2, kint = 1, kint = 2) from fn_test_not_nullable group by id order by id'''
	qt_sql_sequence_match_String_DateV2_Boolean_agg_phase_2_notnull '''
		select count(distinct id), sequence_match('(?1)(?2)', kdtv2, kint = 1, kint = 2) from fn_test_not_nullable'''
	qt_sql_sequence_match_String_DateV2_Boolean_agg_phase_3_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), sequence_match('(?1)(?2)', kdtv2, kint = 1, kint = 2) from fn_test group by kbool order by kbool'''
	qt_sql_sequence_match_String_DateV2_Boolean_agg_phase_4_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), sequence_match('(?1)(?2)', kdtv2, kint = 1, kint = 2) from fn_test'''

	qt_sql_sequence_match_String_DateTime_Boolean_gb '''
		select sequence_match('(?1)(?2)', kdtm, kint = 1, kint = 2) from fn_test group by kbool order by kbool'''
	qt_sql_sequence_match_String_DateTime_Boolean '''
		select sequence_match('(?1)(?2)', kdtm, kint = 1, kint = 2) from fn_test'''
	qt_sql_sequence_match_String_DateTime_Boolean_agg_phase_1 '''
		select count(id), sequence_match('(?1)(?2)', kdtm, kint = 1, kint = 2) from fn_test group by id order by id'''
	qt_sql_sequence_match_String_DateTime_Boolean_agg_phase_2 '''
		select count(distinct id), sequence_match('(?1)(?2)', kdtm, kint = 1, kint = 2) from fn_test'''
	qt_sql_sequence_match_String_DateTime_Boolean_agg_phase_3 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), sequence_match('(?1)(?2)', kdtm, kint = 1, kint = 2) from fn_test group by kbool order by kbool'''
	qt_sql_sequence_match_String_DateTime_Boolean_agg_phase_4 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), sequence_match('(?1)(?2)', kdtm, kint = 1, kint = 2) from fn_test'''
	qt_sql_sequence_match_String_DateTime_Boolean_gb_notnull '''
		select sequence_match('(?1)(?2)', kdtm, kint = 1, kint = 2) from fn_test_not_nullable group by kbool order by kbool'''
	qt_sql_sequence_match_String_DateTime_Boolean_notnull '''
		select sequence_match('(?1)(?2)', kdtm, kint = 1, kint = 2) from fn_test_not_nullable'''
	qt_sql_sequence_match_String_DateTime_Boolean_agg_phase_1_notnull '''
		select count(id), sequence_match('(?1)(?2)', kdtm, kint = 1, kint = 2) from fn_test_not_nullable group by id order by id'''
	qt_sql_sequence_match_String_DateTime_Boolean_agg_phase_2_notnull '''
		select count(distinct id), sequence_match('(?1)(?2)', kdtm, kint = 1, kint = 2) from fn_test_not_nullable'''
	qt_sql_sequence_match_String_DateTime_Boolean_agg_phase_3_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), sequence_match('(?1)(?2)', kdtm, kint = 1, kint = 2) from fn_test group by kbool order by kbool'''
	qt_sql_sequence_match_String_DateTime_Boolean_agg_phase_4_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), sequence_match('(?1)(?2)', kdtm, kint = 1, kint = 2) from fn_test'''

	qt_sql_sequence_match_String_DateTimeV2_Boolean_gb '''
		select sequence_match('(?1)(?2)', kdtmv2s1, kint = 1, kint = 2) from fn_test group by kbool order by kbool'''
	qt_sql_sequence_match_String_DateTimeV2_Boolean '''
		select sequence_match('(?1)(?2)', kdtmv2s1, kint = 1, kint = 2) from fn_test'''
	qt_sql_sequence_match_String_DateTimeV2_Boolean_agg_phase_1 '''
		select count(id), sequence_match('(?1)(?2)', kdtmv2s1, kint = 1, kint = 2) from fn_test group by id order by id'''
	qt_sql_sequence_match_String_DateTimeV2_Boolean_agg_phase_2 '''
		select count(distinct id), sequence_match('(?1)(?2)', kdtmv2s1, kint = 1, kint = 2) from fn_test'''
	qt_sql_sequence_match_String_DateTimeV2_Boolean_agg_phase_3 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), sequence_match('(?1)(?2)', kdtmv2s1, kint = 1, kint = 2) from fn_test group by kbool order by kbool'''
	qt_sql_sequence_match_String_DateTimeV2_Boolean_agg_phase_4 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), sequence_match('(?1)(?2)', kdtmv2s1, kint = 1, kint = 2) from fn_test'''
	qt_sql_sequence_match_String_DateTimeV2_Boolean_gb_notnull '''
		select sequence_match('(?1)(?2)', kdtmv2s1, kint = 1, kint = 2) from fn_test_not_nullable group by kbool order by kbool'''
	qt_sql_sequence_match_String_DateTimeV2_Boolean_notnull '''
		select sequence_match('(?1)(?2)', kdtmv2s1, kint = 1, kint = 2) from fn_test_not_nullable'''
	qt_sql_sequence_match_String_DateTimeV2_Boolean_agg_phase_1_notnull '''
		select count(id), sequence_match('(?1)(?2)', kdtmv2s1, kint = 1, kint = 2) from fn_test_not_nullable group by id order by id'''
	qt_sql_sequence_match_String_DateTimeV2_Boolean_agg_phase_2_notnull '''
		select count(distinct id), sequence_match('(?1)(?2)', kdtmv2s1, kint = 1, kint = 2) from fn_test_not_nullable'''
	qt_sql_sequence_match_String_DateTimeV2_Boolean_agg_phase_3_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), sequence_match('(?1)(?2)', kdtmv2s1, kint = 1, kint = 2) from fn_test group by kbool order by kbool'''
	qt_sql_sequence_match_String_DateTimeV2_Boolean_agg_phase_4_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), sequence_match('(?1)(?2)', kdtmv2s1, kint = 1, kint = 2) from fn_test'''

	qt_sql_stddev_TinyInt_gb '''
		select stddev(ktint) from fn_test group by kbool order by kbool'''
	qt_sql_stddev_TinyInt '''
		select stddev(ktint) from fn_test'''
	qt_sql_stddev_TinyInt_agg_phase_1 '''
		select count(id), stddev(ktint) from fn_test group by id order by id'''
	qt_sql_stddev_TinyInt_agg_phase_2 '''
		select count(distinct id), stddev(ktint) from fn_test'''
	qt_sql_stddev_TinyInt_agg_phase_3 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), stddev(ktint) from fn_test group by kbool order by kbool'''
	qt_sql_stddev_TinyInt_agg_phase_4 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), stddev(ktint) from fn_test'''
	qt_sql_stddev_TinyInt_gb_notnull '''
		select stddev(ktint) from fn_test_not_nullable group by kbool order by kbool'''
	qt_sql_stddev_TinyInt_notnull '''
		select stddev(ktint) from fn_test_not_nullable'''
	qt_sql_stddev_TinyInt_agg_phase_1_notnull '''
		select count(id), stddev(ktint) from fn_test_not_nullable group by id order by id'''
	qt_sql_stddev_TinyInt_agg_phase_2_notnull '''
		select count(distinct id), stddev(ktint) from fn_test_not_nullable'''
	qt_sql_stddev_TinyInt_agg_phase_3_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), stddev(ktint) from fn_test group by kbool order by kbool'''
	qt_sql_stddev_TinyInt_agg_phase_4_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), stddev(ktint) from fn_test'''

	qt_sql_stddev_SmallInt_gb '''
		select stddev(ksint) from fn_test group by kbool order by kbool'''
	qt_sql_stddev_SmallInt '''
		select stddev(ksint) from fn_test'''
	qt_sql_stddev_SmallInt_agg_phase_1 '''
		select count(id), stddev(ksint) from fn_test group by id order by id'''
	qt_sql_stddev_SmallInt_agg_phase_2 '''
		select count(distinct id), stddev(ksint) from fn_test'''
	qt_sql_stddev_SmallInt_agg_phase_3 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), stddev(ksint) from fn_test group by kbool order by kbool'''
	qt_sql_stddev_SmallInt_agg_phase_4 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), stddev(ksint) from fn_test'''
	qt_sql_stddev_SmallInt_gb_notnull '''
		select stddev(ksint) from fn_test_not_nullable group by kbool order by kbool'''
	qt_sql_stddev_SmallInt_notnull '''
		select stddev(ksint) from fn_test_not_nullable'''
	qt_sql_stddev_SmallInt_agg_phase_1_notnull '''
		select count(id), stddev(ksint) from fn_test_not_nullable group by id order by id'''
	qt_sql_stddev_SmallInt_agg_phase_2_notnull '''
		select count(distinct id), stddev(ksint) from fn_test_not_nullable'''
	qt_sql_stddev_SmallInt_agg_phase_3_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), stddev(ksint) from fn_test group by kbool order by kbool'''
	qt_sql_stddev_SmallInt_agg_phase_4_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), stddev(ksint) from fn_test'''

	qt_sql_stddev_Integer_gb '''
		select stddev(kint) from fn_test group by kbool order by kbool'''
	qt_sql_stddev_Integer '''
		select stddev(kint) from fn_test'''
	qt_sql_stddev_Integer_agg_phase_1 '''
		select count(id), stddev(kint) from fn_test group by id order by id'''
	qt_sql_stddev_Integer_agg_phase_2 '''
		select count(distinct id), stddev(kint) from fn_test'''
	qt_sql_stddev_Integer_agg_phase_3 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), stddev(kint) from fn_test group by kbool order by kbool'''
	qt_sql_stddev_Integer_agg_phase_4 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), stddev(kint) from fn_test'''
	qt_sql_stddev_Integer_gb_notnull '''
		select stddev(kint) from fn_test_not_nullable group by kbool order by kbool'''
	qt_sql_stddev_Integer_notnull '''
		select stddev(kint) from fn_test_not_nullable'''
	qt_sql_stddev_Integer_agg_phase_1_notnull '''
		select count(id), stddev(kint) from fn_test_not_nullable group by id order by id'''
	qt_sql_stddev_Integer_agg_phase_2_notnull '''
		select count(distinct id), stddev(kint) from fn_test_not_nullable'''
	qt_sql_stddev_Integer_agg_phase_3_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), stddev(kint) from fn_test group by kbool order by kbool'''
	qt_sql_stddev_Integer_agg_phase_4_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), stddev(kint) from fn_test'''

	qt_sql_stddev_BigInt_gb '''
		select stddev(kbint) from fn_test group by kbool order by kbool'''
	qt_sql_stddev_BigInt '''
		select stddev(kbint) from fn_test'''
	qt_sql_stddev_BigInt_agg_phase_1 '''
		select count(id), stddev(kbint) from fn_test group by id order by id'''
	qt_sql_stddev_BigInt_agg_phase_2 '''
		select count(distinct id), stddev(kbint) from fn_test'''
	qt_sql_stddev_BigInt_agg_phase_3 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), stddev(kbint) from fn_test group by kbool order by kbool'''
	qt_sql_stddev_BigInt_agg_phase_4 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), stddev(kbint) from fn_test'''
	qt_sql_stddev_BigInt_gb_notnull '''
		select stddev(kbint) from fn_test_not_nullable group by kbool order by kbool'''
	qt_sql_stddev_BigInt_notnull '''
		select stddev(kbint) from fn_test_not_nullable'''
	qt_sql_stddev_BigInt_agg_phase_1_notnull '''
		select count(id), stddev(kbint) from fn_test_not_nullable group by id order by id'''
	qt_sql_stddev_BigInt_agg_phase_2_notnull '''
		select count(distinct id), stddev(kbint) from fn_test_not_nullable'''
	qt_sql_stddev_BigInt_agg_phase_3_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), stddev(kbint) from fn_test group by kbool order by kbool'''
	qt_sql_stddev_BigInt_agg_phase_4_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), stddev(kbint) from fn_test'''

	qt_sql_stddev_Float_gb '''
		select stddev(kfloat) from fn_test group by kbool order by kbool'''
	qt_sql_stddev_Float '''
		select stddev(kfloat) from fn_test'''
	qt_sql_stddev_Float_agg_phase_1 '''
		select count(id), stddev(kfloat) from fn_test group by id order by id'''
	qt_sql_stddev_Float_agg_phase_2 '''
		select count(distinct id), stddev(kfloat) from fn_test'''
	qt_sql_stddev_Float_agg_phase_3 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), stddev(kfloat) from fn_test group by kbool order by kbool'''
	qt_sql_stddev_Float_agg_phase_4 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), stddev(kfloat) from fn_test'''
	qt_sql_stddev_Float_gb_notnull '''
		select stddev(kfloat) from fn_test_not_nullable group by kbool order by kbool'''
	qt_sql_stddev_Float_notnull '''
		select stddev(kfloat) from fn_test_not_nullable'''
	qt_sql_stddev_Float_agg_phase_1_notnull '''
		select count(id), stddev(kfloat) from fn_test_not_nullable group by id order by id'''
	qt_sql_stddev_Float_agg_phase_2_notnull '''
		select count(distinct id), stddev(kfloat) from fn_test_not_nullable'''
	qt_sql_stddev_Float_agg_phase_3_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), stddev(kfloat) from fn_test group by kbool order by kbool'''
	qt_sql_stddev_Float_agg_phase_4_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), stddev(kfloat) from fn_test'''

	qt_sql_stddev_Double_gb '''
		select stddev(kdbl) from fn_test group by kbool order by kbool'''
	qt_sql_stddev_Double '''
		select stddev(kdbl) from fn_test'''
	qt_sql_stddev_Double_agg_phase_1 '''
		select count(id), stddev(kdbl) from fn_test group by id order by id'''
	qt_sql_stddev_Double_agg_phase_2 '''
		select count(distinct id), stddev(kdbl) from fn_test'''
	qt_sql_stddev_Double_agg_phase_3 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), stddev(kdbl) from fn_test group by kbool order by kbool'''
	qt_sql_stddev_Double_agg_phase_4 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), stddev(kdbl) from fn_test'''
	qt_sql_stddev_Double_gb_notnull '''
		select stddev(kdbl) from fn_test_not_nullable group by kbool order by kbool'''
	qt_sql_stddev_Double_notnull '''
		select stddev(kdbl) from fn_test_not_nullable'''
	qt_sql_stddev_Double_agg_phase_1_notnull '''
		select count(id), stddev(kdbl) from fn_test_not_nullable group by id order by id'''
	qt_sql_stddev_Double_agg_phase_2_notnull '''
		select count(distinct id), stddev(kdbl) from fn_test_not_nullable'''
	qt_sql_stddev_Double_agg_phase_3_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), stddev(kdbl) from fn_test group by kbool order by kbool'''
	qt_sql_stddev_Double_agg_phase_4_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), stddev(kdbl) from fn_test'''

	qt_sql_stddev_DecimalV2_gb '''
		select stddev(kdcmls1) from fn_test group by kbool order by kbool'''
	// qt_sql_stddev_DecimalV2 '''
	// 	select stddev(kdcmls1) from fn_test'''
	qt_sql_stddev_DecimalV2_agg_phase_1 '''
		select count(id), stddev(kdcmls1) from fn_test group by id order by id'''
	qt_sql_stddev_DecimalV2_agg_phase_2 '''
		select count(distinct id), stddev(kdcmls1) from fn_test'''
	qt_sql_stddev_DecimalV2_agg_phase_3 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), stddev(kdcmls1) from fn_test group by kbool order by kbool'''
	qt_sql_stddev_DecimalV2_agg_phase_4 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), stddev(kdcmls1) from fn_test'''
	qt_sql_stddev_DecimalV2_gb_notnull '''
		select stddev(kdcmls1) from fn_test_not_nullable group by kbool order by kbool'''
	// qt_sql_stddev_DecimalV2_notnull '''
	// 	select stddev(kdcmls1) from fn_test_not_nullable'''
	qt_sql_stddev_DecimalV2_agg_phase_1_notnull '''
		select count(id), stddev(kdcmls1) from fn_test_not_nullable group by id order by id'''
	qt_sql_stddev_DecimalV2_agg_phase_2_notnull '''
		select count(distinct id), stddev(kdcmls1) from fn_test_not_nullable'''
	qt_sql_stddev_DecimalV2_agg_phase_3_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), stddev(kdcmls1) from fn_test group by kbool order by kbool'''
	qt_sql_stddev_DecimalV2_agg_phase_4_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), stddev(kdcmls1) from fn_test'''

	qt_sql_stddev_samp_TinyInt_gb '''
		select stddev_samp(ktint) from fn_test group by kbool order by kbool'''
	qt_sql_stddev_samp_TinyInt '''
		select stddev_samp(ktint) from fn_test'''
	qt_sql_stddev_samp_TinyInt_agg_phase_1 '''
		select count(id), stddev_samp(ktint) from fn_test group by id order by id'''
	qt_sql_stddev_samp_TinyInt_agg_phase_2 '''
		select count(distinct id), stddev_samp(ktint) from fn_test'''
	qt_sql_stddev_samp_TinyInt_agg_phase_3 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), stddev_samp(ktint) from fn_test group by kbool order by kbool'''
	qt_sql_stddev_samp_TinyInt_agg_phase_4 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), stddev_samp(ktint) from fn_test'''
	qt_sql_stddev_samp_TinyInt_gb_notnull '''
		select stddev_samp(ktint) from fn_test_not_nullable group by kbool order by kbool'''
	qt_sql_stddev_samp_TinyInt_notnull '''
		select stddev_samp(ktint) from fn_test_not_nullable'''
	qt_sql_stddev_samp_TinyInt_agg_phase_1_notnull '''
		select count(id), stddev_samp(ktint) from fn_test_not_nullable group by id order by id'''
	qt_sql_stddev_samp_TinyInt_agg_phase_2_notnull '''
		select count(distinct id), stddev_samp(ktint) from fn_test_not_nullable'''
	qt_sql_stddev_samp_TinyInt_agg_phase_3_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), stddev_samp(ktint) from fn_test group by kbool order by kbool'''
	qt_sql_stddev_samp_TinyInt_agg_phase_4_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), stddev_samp(ktint) from fn_test'''

	qt_sql_stddev_samp_SmallInt_gb '''
		select stddev_samp(ksint) from fn_test group by kbool order by kbool'''
	qt_sql_stddev_samp_SmallInt '''
		select stddev_samp(ksint) from fn_test'''
	qt_sql_stddev_samp_SmallInt_agg_phase_1 '''
		select count(id), stddev_samp(ksint) from fn_test group by id order by id'''
	qt_sql_stddev_samp_SmallInt_agg_phase_2 '''
		select count(distinct id), stddev_samp(ksint) from fn_test'''
	qt_sql_stddev_samp_SmallInt_agg_phase_3 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), stddev_samp(ksint) from fn_test group by kbool order by kbool'''
	qt_sql_stddev_samp_SmallInt_agg_phase_4 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), stddev_samp(ksint) from fn_test'''
	qt_sql_stddev_samp_SmallInt_gb_notnull '''
		select stddev_samp(ksint) from fn_test_not_nullable group by kbool order by kbool'''
	qt_sql_stddev_samp_SmallInt_notnull '''
		select stddev_samp(ksint) from fn_test_not_nullable'''
	qt_sql_stddev_samp_SmallInt_agg_phase_1_notnull '''
		select count(id), stddev_samp(ksint) from fn_test_not_nullable group by id order by id'''
	qt_sql_stddev_samp_SmallInt_agg_phase_2_notnull '''
		select count(distinct id), stddev_samp(ksint) from fn_test_not_nullable'''
	qt_sql_stddev_samp_SmallInt_agg_phase_3_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), stddev_samp(ksint) from fn_test group by kbool order by kbool'''
	qt_sql_stddev_samp_SmallInt_agg_phase_4_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), stddev_samp(ksint) from fn_test'''

	qt_sql_stddev_samp_Integer_gb '''
		select stddev_samp(kint) from fn_test group by kbool order by kbool'''
	qt_sql_stddev_samp_Integer '''
		select stddev_samp(kint) from fn_test'''
	qt_sql_stddev_samp_Integer_agg_phase_1 '''
		select count(id), stddev_samp(kint) from fn_test group by id order by id'''
	qt_sql_stddev_samp_Integer_agg_phase_2 '''
		select count(distinct id), stddev_samp(kint) from fn_test'''
	qt_sql_stddev_samp_Integer_agg_phase_3 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), stddev_samp(kint) from fn_test group by kbool order by kbool'''
	qt_sql_stddev_samp_Integer_agg_phase_4 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), stddev_samp(kint) from fn_test'''
	qt_sql_stddev_samp_Integer_gb_notnull '''
		select stddev_samp(kint) from fn_test_not_nullable group by kbool order by kbool'''
	qt_sql_stddev_samp_Integer_notnull '''
		select stddev_samp(kint) from fn_test_not_nullable'''
	qt_sql_stddev_samp_Integer_agg_phase_1_notnull '''
		select count(id), stddev_samp(kint) from fn_test_not_nullable group by id order by id'''
	qt_sql_stddev_samp_Integer_agg_phase_2_notnull '''
		select count(distinct id), stddev_samp(kint) from fn_test_not_nullable'''
	qt_sql_stddev_samp_Integer_agg_phase_3_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), stddev_samp(kint) from fn_test group by kbool order by kbool'''
	qt_sql_stddev_samp_Integer_agg_phase_4_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), stddev_samp(kint) from fn_test'''

	qt_sql_stddev_samp_BigInt_gb '''
		select stddev_samp(kbint) from fn_test group by kbool order by kbool'''
	qt_sql_stddev_samp_BigInt '''
		select stddev_samp(kbint) from fn_test'''
	qt_sql_stddev_samp_BigInt_agg_phase_1 '''
		select count(id), stddev_samp(kbint) from fn_test group by id order by id'''
	qt_sql_stddev_samp_BigInt_agg_phase_2 '''
		select count(distinct id), stddev_samp(kbint) from fn_test'''
	qt_sql_stddev_samp_BigInt_agg_phase_3 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), stddev_samp(kbint) from fn_test group by kbool order by kbool'''
	qt_sql_stddev_samp_BigInt_agg_phase_4 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), stddev_samp(kbint) from fn_test'''
	qt_sql_stddev_samp_BigInt_gb_notnull '''
		select stddev_samp(kbint) from fn_test_not_nullable group by kbool order by kbool'''
	qt_sql_stddev_samp_BigInt_notnull '''
		select stddev_samp(kbint) from fn_test_not_nullable'''
	qt_sql_stddev_samp_BigInt_agg_phase_1_notnull '''
		select count(id), stddev_samp(kbint) from fn_test_not_nullable group by id order by id'''
	qt_sql_stddev_samp_BigInt_agg_phase_2_notnull '''
		select count(distinct id), stddev_samp(kbint) from fn_test_not_nullable'''
	qt_sql_stddev_samp_BigInt_agg_phase_3_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), stddev_samp(kbint) from fn_test group by kbool order by kbool'''
	qt_sql_stddev_samp_BigInt_agg_phase_4_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), stddev_samp(kbint) from fn_test'''

	qt_sql_stddev_samp_Float_gb '''
		select stddev_samp(kfloat) from fn_test group by kbool order by kbool'''
	qt_sql_stddev_samp_Float '''
		select stddev_samp(kfloat) from fn_test'''
	qt_sql_stddev_samp_Float_agg_phase_1 '''
		select count(id), stddev_samp(kfloat) from fn_test group by id order by id'''
	qt_sql_stddev_samp_Float_agg_phase_2 '''
		select count(distinct id), stddev_samp(kfloat) from fn_test'''
	qt_sql_stddev_samp_Float_agg_phase_3 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), stddev_samp(kfloat) from fn_test group by kbool order by kbool'''
	qt_sql_stddev_samp_Float_agg_phase_4 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), stddev_samp(kfloat) from fn_test'''
	qt_sql_stddev_samp_Float_gb_notnull '''
		select stddev_samp(kfloat) from fn_test_not_nullable group by kbool order by kbool'''
	qt_sql_stddev_samp_Float_notnull '''
		select stddev_samp(kfloat) from fn_test_not_nullable'''
	qt_sql_stddev_samp_Float_agg_phase_1_notnull '''
		select count(id), stddev_samp(kfloat) from fn_test_not_nullable group by id order by id'''
	qt_sql_stddev_samp_Float_agg_phase_2_notnull '''
		select count(distinct id), stddev_samp(kfloat) from fn_test_not_nullable'''
	qt_sql_stddev_samp_Float_agg_phase_3_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), stddev_samp(kfloat) from fn_test group by kbool order by kbool'''
	qt_sql_stddev_samp_Float_agg_phase_4_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), stddev_samp(kfloat) from fn_test'''

	qt_sql_stddev_samp_Double_gb '''
		select stddev_samp(kdbl) from fn_test group by kbool order by kbool'''
	qt_sql_stddev_samp_Double '''
		select stddev_samp(kdbl) from fn_test'''
	qt_sql_stddev_samp_Double_agg_phase_1 '''
		select count(id), stddev_samp(kdbl) from fn_test group by id order by id'''
	qt_sql_stddev_samp_Double_agg_phase_2 '''
		select count(distinct id), stddev_samp(kdbl) from fn_test'''
	qt_sql_stddev_samp_Double_agg_phase_3 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), stddev_samp(kdbl) from fn_test group by kbool order by kbool'''
	qt_sql_stddev_samp_Double_agg_phase_4 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), stddev_samp(kdbl) from fn_test'''
	qt_sql_stddev_samp_Double_gb_notnull '''
		select stddev_samp(kdbl) from fn_test_not_nullable group by kbool order by kbool'''
	qt_sql_stddev_samp_Double_notnull '''
		select stddev_samp(kdbl) from fn_test_not_nullable'''
	qt_sql_stddev_samp_Double_agg_phase_1_notnull '''
		select count(id), stddev_samp(kdbl) from fn_test_not_nullable group by id order by id'''
	qt_sql_stddev_samp_Double_agg_phase_2_notnull '''
		select count(distinct id), stddev_samp(kdbl) from fn_test_not_nullable'''
	qt_sql_stddev_samp_Double_agg_phase_3_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), stddev_samp(kdbl) from fn_test group by kbool order by kbool'''
	qt_sql_stddev_samp_Double_agg_phase_4_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), stddev_samp(kdbl) from fn_test'''

	// qt_sql_stddev_samp_DecimalV2_gb '''
	// 	select stddev_samp(kdcmls1) from fn_test group by kbool order by kbool'''
	// qt_sql_stddev_samp_DecimalV2 '''
	// 	select stddev_samp(kdcmls1) from fn_test'''
	qt_sql_stddev_samp_DecimalV2_agg_phase_1 '''
		select count(id), stddev_samp(kdcmls1) from fn_test group by id order by id'''
	qt_sql_stddev_samp_DecimalV2_agg_phase_2 '''
		select count(distinct id), stddev_samp(kdcmls1) from fn_test'''
	qt_sql_stddev_samp_DecimalV2_agg_phase_3 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), stddev_samp(kdcmls1) from fn_test group by kbool order by kbool'''
	qt_sql_stddev_samp_DecimalV2_agg_phase_4 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), stddev_samp(kdcmls1) from fn_test'''
	// qt_sql_stddev_samp_DecimalV2_gb_notnull '''
	// 	select stddev_samp(kdcmls1) from fn_test_not_nullable group by kbool order by kbool'''
	// qt_sql_stddev_samp_DecimalV2_notnull '''
	// 	select stddev_samp(kdcmls1) from fn_test_not_nullable'''
	qt_sql_stddev_samp_DecimalV2_agg_phase_1_notnull '''
		select count(id), stddev_samp(kdcmls1) from fn_test_not_nullable group by id order by id'''
	qt_sql_stddev_samp_DecimalV2_agg_phase_2_notnull '''
		select count(distinct id), stddev_samp(kdcmls1) from fn_test_not_nullable'''
	qt_sql_stddev_samp_DecimalV2_agg_phase_3_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), stddev_samp(kdcmls1) from fn_test group by kbool order by kbool'''
	qt_sql_stddev_samp_DecimalV2_agg_phase_4_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), stddev_samp(kdcmls1) from fn_test'''

	qt_sql_sum_Boolean '''
		select sum(kbool) from fn_test'''
	qt_sql_sum_Boolean_gb '''
		select sum(kbool) from fn_test group by id order by id'''
	qt_sql_sum_TinyInt_gb '''
		select sum(ktint) from fn_test group by kbool order by kbool'''
	qt_sql_sum_TinyInt '''
		select sum(ktint) from fn_test'''
	qt_sql_sum_TinyInt_agg_phase_1 '''
		select count(id), sum(ktint) from fn_test group by id order by id'''
	qt_sql_sum_TinyInt_agg_phase_2 '''
		select count(distinct id), sum(ktint) from fn_test'''
	qt_sql_sum_TinyInt_agg_phase_3 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), sum(ktint) from fn_test group by kbool order by kbool'''
	qt_sql_sum_TinyInt_agg_phase_4 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), sum(ktint) from fn_test'''
	qt_sql_sum_TinyInt_gb_notnull '''
		select sum(ktint) from fn_test_not_nullable group by kbool order by kbool'''
	qt_sql_sum_TinyInt_notnull '''
		select sum(ktint) from fn_test_not_nullable'''
	qt_sql_sum_TinyInt_agg_phase_1_notnull '''
		select count(id), sum(ktint) from fn_test_not_nullable group by id order by id'''
	qt_sql_sum_TinyInt_agg_phase_2_notnull '''
		select count(distinct id), sum(ktint) from fn_test_not_nullable'''
	qt_sql_sum_TinyInt_agg_phase_3_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), sum(ktint) from fn_test group by kbool order by kbool'''
	qt_sql_sum_TinyInt_agg_phase_4_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), sum(ktint) from fn_test'''

	qt_sql_sum_SmallInt_gb '''
		select sum(ksint) from fn_test group by kbool order by kbool'''
	qt_sql_sum_SmallInt '''
		select sum(ksint) from fn_test'''
	qt_sql_sum_SmallInt_agg_phase_1 '''
		select count(id), sum(ksint) from fn_test group by id order by id'''
	qt_sql_sum_SmallInt_agg_phase_2 '''
		select count(distinct id), sum(ksint) from fn_test'''
	qt_sql_sum_SmallInt_agg_phase_3 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), sum(ksint) from fn_test group by kbool order by kbool'''
	qt_sql_sum_SmallInt_agg_phase_4 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), sum(ksint) from fn_test'''
	qt_sql_sum_SmallInt_gb_notnull '''
		select sum(ksint) from fn_test_not_nullable group by kbool order by kbool'''
	qt_sql_sum_SmallInt_notnull '''
		select sum(ksint) from fn_test_not_nullable'''
	qt_sql_sum_SmallInt_agg_phase_1_notnull '''
		select count(id), sum(ksint) from fn_test_not_nullable group by id order by id'''
	qt_sql_sum_SmallInt_agg_phase_2_notnull '''
		select count(distinct id), sum(ksint) from fn_test_not_nullable'''
	qt_sql_sum_SmallInt_agg_phase_3_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), sum(ksint) from fn_test group by kbool order by kbool'''
	qt_sql_sum_SmallInt_agg_phase_4_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), sum(ksint) from fn_test'''

	qt_sql_sum_Integer_gb '''
		select sum(kint) from fn_test group by kbool order by kbool'''
	qt_sql_sum_Integer '''
		select sum(kint) from fn_test'''
	qt_sql_sum_Integer_agg_phase_1 '''
		select count(id), sum(kint) from fn_test group by id order by id'''
	qt_sql_sum_Integer_agg_phase_2 '''
		select count(distinct id), sum(kint) from fn_test'''
	qt_sql_sum_Integer_agg_phase_3 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), sum(kint) from fn_test group by kbool order by kbool'''
	qt_sql_sum_Integer_agg_phase_4 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), sum(kint) from fn_test'''
	qt_sql_sum_Integer_gb_notnull '''
		select sum(kint) from fn_test_not_nullable group by kbool order by kbool'''
	qt_sql_sum_Integer_notnull '''
		select sum(kint) from fn_test_not_nullable'''
	qt_sql_sum_Integer_agg_phase_1_notnull '''
		select count(id), sum(kint) from fn_test_not_nullable group by id order by id'''
	qt_sql_sum_Integer_agg_phase_2_notnull '''
		select count(distinct id), sum(kint) from fn_test_not_nullable'''
	qt_sql_sum_Integer_agg_phase_3_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), sum(kint) from fn_test group by kbool order by kbool'''
	qt_sql_sum_Integer_agg_phase_4_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), sum(kint) from fn_test'''

	qt_sql_sum_BigInt_gb '''
		select sum(kbint) from fn_test group by kbool order by kbool'''
	qt_sql_sum_BigInt '''
		select sum(kbint) from fn_test'''
	qt_sql_sum_BigInt_agg_phase_1 '''
		select count(id), sum(kbint) from fn_test group by id order by id'''
	qt_sql_sum_BigInt_agg_phase_2 '''
		select count(distinct id), sum(kbint) from fn_test'''
	qt_sql_sum_BigInt_agg_phase_3 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), sum(kbint) from fn_test group by kbool order by kbool'''
	qt_sql_sum_BigInt_agg_phase_4 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), sum(kbint) from fn_test'''
	qt_sql_sum_BigInt_gb_notnull '''
		select sum(kbint) from fn_test_not_nullable group by kbool order by kbool'''
	qt_sql_sum_BigInt_notnull '''
		select sum(kbint) from fn_test_not_nullable'''
	qt_sql_sum_BigInt_agg_phase_1_notnull '''
		select count(id), sum(kbint) from fn_test_not_nullable group by id order by id'''
	qt_sql_sum_BigInt_agg_phase_2_notnull '''
		select count(distinct id), sum(kbint) from fn_test_not_nullable'''
	qt_sql_sum_BigInt_agg_phase_3_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), sum(kbint) from fn_test group by kbool order by kbool'''
	qt_sql_sum_BigInt_agg_phase_4_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), sum(kbint) from fn_test'''

	//not cast float to double
    explain {
        sql("select sum(kfloat) from fn_test;")
        contains "partial_sum(kfloat"
    }

	qt_sql_sum_Double_gb '''
		select sum(kdbl) from fn_test group by kbool order by kbool'''
	qt_sql_sum_Double '''
		select sum(kdbl) from fn_test'''
	qt_sql_sum_Double_agg_phase_1 '''
		select count(id), sum(kdbl) from fn_test group by id order by id'''
	qt_sql_sum_Double_agg_phase_2 '''
		select count(distinct id), sum(kdbl) from fn_test'''
	qt_sql_sum_Double_agg_phase_3 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), sum(kdbl) from fn_test group by kbool order by kbool'''
	qt_sql_sum_Double_agg_phase_4 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), sum(kdbl) from fn_test'''
	qt_sql_sum_Double_gb_notnull '''
		select sum(kdbl) from fn_test_not_nullable group by kbool order by kbool'''
	qt_sql_sum_Double_notnull '''
		select sum(kdbl) from fn_test_not_nullable'''
	qt_sql_sum_Double_agg_phase_1_notnull '''
		select count(id), sum(kdbl) from fn_test_not_nullable group by id order by id'''
	qt_sql_sum_Double_agg_phase_2_notnull '''
		select count(distinct id), sum(kdbl) from fn_test_not_nullable'''
	qt_sql_sum_Double_agg_phase_3_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), sum(kdbl) from fn_test group by kbool order by kbool'''
	qt_sql_sum_Double_agg_phase_4_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), sum(kdbl) from fn_test'''

	qt_sql_sum_DecimalV2_gb '''
		select sum(kdcmls1) from fn_test group by kbool order by kbool'''
	qt_sql_sum_DecimalV2 '''
		select sum(kdcmls1) from fn_test'''
	qt_sql_sum_DecimalV2_agg_phase_1 '''
		select count(id), sum(kdcmls1) from fn_test group by id order by id'''
	qt_sql_sum_DecimalV2_agg_phase_2 '''
		select count(distinct id), sum(kdcmls1) from fn_test'''
	qt_sql_sum_DecimalV2_agg_phase_3 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), sum(kdcmls1) from fn_test group by kbool order by kbool'''
	qt_sql_sum_DecimalV2_agg_phase_4 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), sum(kdcmls1) from fn_test'''
	qt_sql_sum_DecimalV2_gb_notnull '''
		select sum(kdcmls1) from fn_test_not_nullable group by kbool order by kbool'''
	qt_sql_sum_DecimalV2_notnull '''
		select sum(kdcmls1) from fn_test_not_nullable'''
	qt_sql_sum_DecimalV2_agg_phase_1_notnull '''
		select count(id), sum(kdcmls1) from fn_test_not_nullable group by id order by id'''
	qt_sql_sum_DecimalV2_agg_phase_2_notnull '''
		select count(distinct id), sum(kdcmls1) from fn_test_not_nullable'''
	qt_sql_sum_DecimalV2_agg_phase_3_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), sum(kdcmls1) from fn_test group by kbool order by kbool'''
	qt_sql_sum_DecimalV2_agg_phase_4_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), sum(kdcmls1) from fn_test'''

	qt_sql_sum_LargeInt_gb '''
		select sum(klint) from fn_test group by kbool order by kbool'''
	qt_sql_sum_LargeInt '''
		select sum(klint) from fn_test'''
	qt_sql_sum_LargeInt_agg_phase_1 '''
		select count(id), sum(klint) from fn_test group by id order by id'''
	qt_sql_sum_LargeInt_agg_phase_2 '''
		select count(distinct id), sum(klint) from fn_test'''
	qt_sql_sum_LargeInt_agg_phase_3 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), sum(klint) from fn_test group by kbool order by kbool'''
	qt_sql_sum_LargeInt_agg_phase_4 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), sum(klint) from fn_test'''
	qt_sql_sum_LargeInt_gb_notnull '''
		select sum(klint) from fn_test_not_nullable group by kbool order by kbool'''
	qt_sql_sum_LargeInt_notnull '''
		select sum(klint) from fn_test_not_nullable'''
	qt_sql_sum_LargeInt_agg_phase_1_notnull '''
		select count(id), sum(klint) from fn_test_not_nullable group by id order by id'''
	qt_sql_sum_LargeInt_agg_phase_2_notnull '''
		select count(distinct id), sum(klint) from fn_test_not_nullable'''
	qt_sql_sum_LargeInt_agg_phase_3_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), sum(klint) from fn_test group by kbool order by kbool'''
	qt_sql_sum_LargeInt_agg_phase_4_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), sum(klint) from fn_test'''

	qt_sql_topn_Varchar_Integer_gb '''
		select topn(kvchrs1, 3) from fn_test group by kbool order by kbool'''
	qt_sql_topn_Varchar_Integer '''
		select topn(kvchrs1, 3) from fn_test'''
	qt_sql_topn_Varchar_Integer_agg_phase_1 '''
		select count(id), topn(kvchrs1, 3) from fn_test group by id order by id'''
	qt_sql_topn_Varchar_Integer_agg_phase_2 '''
		select count(distinct id), topn(kvchrs1, 3) from fn_test'''
	qt_sql_topn_Varchar_Integer_agg_phase_3 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), topn(kvchrs1, 3) from fn_test group by kbool order by kbool'''
	qt_sql_topn_Varchar_Integer_agg_phase_4 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), topn(kvchrs1, 3) from fn_test'''
	qt_sql_topn_Varchar_Integer_gb_notnull '''
		select topn(kvchrs1, 3) from fn_test_not_nullable group by kbool order by kbool'''
	qt_sql_topn_Varchar_Integer_notnull '''
		select topn(kvchrs1, 3) from fn_test_not_nullable'''
	qt_sql_topn_Varchar_Integer_agg_phase_1_notnull '''
		select count(id), topn(kvchrs1, 3) from fn_test_not_nullable group by id order by id'''
	qt_sql_topn_Varchar_Integer_agg_phase_2_notnull '''
		select count(distinct id), topn(kvchrs1, 3) from fn_test_not_nullable'''
	qt_sql_topn_Varchar_Integer_agg_phase_3_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), topn(kvchrs1, 3) from fn_test group by kbool order by kbool'''
	qt_sql_topn_Varchar_Integer_agg_phase_4_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), topn(kvchrs1, 3) from fn_test'''

	qt_sql_topn_String_Integer_gb '''
		select topn(kstr, 3) from fn_test group by kbool order by kbool'''
	qt_sql_topn_String_Integer '''
		select topn(kstr, 3) from fn_test'''
	qt_sql_topn_String_Integer_agg_phase_1 '''
		select count(id), topn(kstr, 3) from fn_test group by id order by id'''
	qt_sql_topn_String_Integer_agg_phase_2 '''
		select count(distinct id), topn(kstr, 3) from fn_test'''
	qt_sql_topn_String_Integer_agg_phase_3 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), topn(kstr, 3) from fn_test group by kbool order by kbool'''
	qt_sql_topn_String_Integer_agg_phase_4 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), topn(kstr, 3) from fn_test'''
	qt_sql_topn_String_Integer_gb_notnull '''
		select topn(kstr, 3) from fn_test_not_nullable group by kbool order by kbool'''
	qt_sql_topn_String_Integer_notnull '''
		select topn(kstr, 3) from fn_test_not_nullable'''
	qt_sql_topn_String_Integer_agg_phase_1_notnull '''
		select count(id), topn(kstr, 3) from fn_test_not_nullable group by id order by id'''
	qt_sql_topn_String_Integer_agg_phase_2_notnull '''
		select count(distinct id), topn(kstr, 3) from fn_test_not_nullable'''
	qt_sql_topn_String_Integer_agg_phase_3_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), topn(kstr, 3) from fn_test group by kbool order by kbool'''
	qt_sql_topn_String_Integer_agg_phase_4_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), topn(kstr, 3) from fn_test'''

	qt_sql_topn_Varchar_Integer_Integer_gb '''
		select topn(kvchrs1, 3, 100) from fn_test group by kbool order by kbool'''
	qt_sql_topn_Varchar_Integer_Integer '''
		select topn(kvchrs1, 3, 100) from fn_test'''
	qt_sql_topn_Varchar_Integer_Integer_agg_phase_1 '''
		select count(id), topn(kvchrs1, 3, 100) from fn_test group by id order by id'''
	qt_sql_topn_Varchar_Integer_Integer_agg_phase_2 '''
		select count(distinct id), topn(kvchrs1, 3, 100) from fn_test'''
	qt_sql_topn_Varchar_Integer_Integer_agg_phase_3 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), topn(kvchrs1, 3, 100) from fn_test group by kbool order by kbool'''
	qt_sql_topn_Varchar_Integer_Integer_agg_phase_4 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), topn(kvchrs1, 3, 100) from fn_test'''
	qt_sql_topn_Varchar_Integer_Integer_gb_notnull '''
		select topn(kvchrs1, 3, 100) from fn_test_not_nullable group by kbool order by kbool'''
	qt_sql_topn_Varchar_Integer_Integer_notnull '''
		select topn(kvchrs1, 3, 100) from fn_test_not_nullable'''
	qt_sql_topn_Varchar_Integer_Integer_agg_phase_1_notnull '''
		select count(id), topn(kvchrs1, 3, 100) from fn_test_not_nullable group by id order by id'''
	qt_sql_topn_Varchar_Integer_Integer_agg_phase_2_notnull '''
		select count(distinct id), topn(kvchrs1, 3, 100) from fn_test_not_nullable'''
	qt_sql_topn_Varchar_Integer_Integer_agg_phase_3_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), topn(kvchrs1, 3, 100) from fn_test group by kbool order by kbool'''
	qt_sql_topn_Varchar_Integer_Integer_agg_phase_4_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), topn(kvchrs1, 3, 100) from fn_test'''

	qt_sql_topn_String_Integer_Integer_gb '''
		select topn(kstr, 3, 100) from fn_test group by kbool order by kbool'''
	qt_sql_topn_String_Integer_Integer '''
		select topn(kstr, 3, 100) from fn_test'''
	qt_sql_topn_String_Integer_Integer_agg_phase_1 '''
		select count(id), topn(kstr, 3, 100) from fn_test group by id order by id'''
	qt_sql_topn_String_Integer_Integer_agg_phase_2 '''
		select count(distinct id), topn(kstr, 3, 100) from fn_test'''
	qt_sql_topn_String_Integer_Integer_agg_phase_3 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), topn(kstr, 3, 100) from fn_test group by kbool order by kbool'''
	qt_sql_topn_String_Integer_Integer_agg_phase_4 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), topn(kstr, 3, 100) from fn_test'''
	qt_sql_topn_String_Integer_Integer_gb_notnull '''
		select topn(kstr, 3, 100) from fn_test_not_nullable group by kbool order by kbool'''
	qt_sql_topn_String_Integer_Integer_notnull '''
		select topn(kstr, 3, 100) from fn_test_not_nullable'''
	qt_sql_topn_String_Integer_Integer_agg_phase_1_notnull '''
		select count(id), topn(kstr, 3, 100) from fn_test_not_nullable group by id order by id'''
	qt_sql_topn_String_Integer_Integer_agg_phase_2_notnull '''
		select count(distinct id), topn(kstr, 3, 100) from fn_test_not_nullable'''
	qt_sql_topn_String_Integer_Integer_agg_phase_3_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), topn(kstr, 3, 100) from fn_test group by kbool order by kbool'''
	qt_sql_topn_String_Integer_Integer_agg_phase_4_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), topn(kstr, 3, 100) from fn_test'''

	qt_sql_variance_TinyInt_gb '''
		select variance(ktint) from fn_test group by kbool order by kbool'''
	qt_sql_variance_TinyInt '''
		select variance(ktint) from fn_test'''
	qt_sql_variance_TinyInt_agg_phase_1 '''
		select count(id), variance(ktint) from fn_test group by id order by id'''
	qt_sql_variance_TinyInt_agg_phase_2 '''
		select count(distinct id), variance(ktint) from fn_test'''
	qt_sql_variance_TinyInt_agg_phase_3 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), variance(ktint) from fn_test group by kbool order by kbool'''
	qt_sql_variance_TinyInt_agg_phase_4 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), variance(ktint) from fn_test'''
	qt_sql_variance_TinyInt_gb_notnull '''
		select variance(ktint) from fn_test_not_nullable group by kbool order by kbool'''
	qt_sql_variance_TinyInt_notnull '''
		select variance(ktint) from fn_test_not_nullable'''
	qt_sql_variance_TinyInt_agg_phase_1_notnull '''
		select count(id), variance(ktint) from fn_test_not_nullable group by id order by id'''
	qt_sql_variance_TinyInt_agg_phase_2_notnull '''
		select count(distinct id), variance(ktint) from fn_test_not_nullable'''
	qt_sql_variance_TinyInt_agg_phase_3_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), variance(ktint) from fn_test group by kbool order by kbool'''
	qt_sql_variance_TinyInt_agg_phase_4_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), variance(ktint) from fn_test'''

	qt_sql_variance_SmallInt_gb '''
		select variance(ksint) from fn_test group by kbool order by kbool'''
	qt_sql_variance_SmallInt '''
		select variance(ksint) from fn_test'''
	qt_sql_variance_SmallInt_agg_phase_1 '''
		select count(id), variance(ksint) from fn_test group by id order by id'''
	qt_sql_variance_SmallInt_agg_phase_2 '''
		select count(distinct id), variance(ksint) from fn_test'''
	qt_sql_variance_SmallInt_agg_phase_3 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), variance(ksint) from fn_test group by kbool order by kbool'''
	qt_sql_variance_SmallInt_agg_phase_4 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), variance(ksint) from fn_test'''
	qt_sql_variance_SmallInt_gb_notnull '''
		select variance(ksint) from fn_test_not_nullable group by kbool order by kbool'''
	qt_sql_variance_SmallInt_notnull '''
		select variance(ksint) from fn_test_not_nullable'''
	qt_sql_variance_SmallInt_agg_phase_1_notnull '''
		select count(id), variance(ksint) from fn_test_not_nullable group by id order by id'''
	qt_sql_variance_SmallInt_agg_phase_2_notnull '''
		select count(distinct id), variance(ksint) from fn_test_not_nullable'''
	qt_sql_variance_SmallInt_agg_phase_3_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), variance(ksint) from fn_test group by kbool order by kbool'''
	qt_sql_variance_SmallInt_agg_phase_4_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), variance(ksint) from fn_test'''

	qt_sql_variance_Integer_gb '''
		select variance(kint) from fn_test group by kbool order by kbool'''
	qt_sql_variance_Integer '''
		select variance(kint) from fn_test'''
	qt_sql_variance_Integer_agg_phase_1 '''
		select count(id), variance(kint) from fn_test group by id order by id'''
	qt_sql_variance_Integer_agg_phase_2 '''
		select count(distinct id), variance(kint) from fn_test'''
	qt_sql_variance_Integer_agg_phase_3 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), variance(kint) from fn_test group by kbool order by kbool'''
	qt_sql_variance_Integer_agg_phase_4 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), variance(kint) from fn_test'''
	qt_sql_variance_Integer_gb_notnull '''
		select variance(kint) from fn_test_not_nullable group by kbool order by kbool'''
	qt_sql_variance_Integer_notnull '''
		select variance(kint) from fn_test_not_nullable'''
	qt_sql_variance_Integer_agg_phase_1_notnull '''
		select count(id), variance(kint) from fn_test_not_nullable group by id order by id'''
	qt_sql_variance_Integer_agg_phase_2_notnull '''
		select count(distinct id), variance(kint) from fn_test_not_nullable'''
	qt_sql_variance_Integer_agg_phase_3_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), variance(kint) from fn_test group by kbool order by kbool'''
	qt_sql_variance_Integer_agg_phase_4_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), variance(kint) from fn_test'''

	qt_sql_variance_BigInt_gb '''
		select variance(kbint) from fn_test group by kbool order by kbool'''
	qt_sql_variance_BigInt '''
		select variance(kbint) from fn_test'''
	qt_sql_variance_BigInt_agg_phase_1 '''
		select count(id), variance(kbint) from fn_test group by id order by id'''
	qt_sql_variance_BigInt_agg_phase_2 '''
		select count(distinct id), variance(kbint) from fn_test'''
	qt_sql_variance_BigInt_agg_phase_3 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), variance(kbint) from fn_test group by kbool order by kbool'''
	qt_sql_variance_BigInt_agg_phase_4 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), variance(kbint) from fn_test'''
	qt_sql_variance_BigInt_gb_notnull '''
		select variance(kbint) from fn_test_not_nullable group by kbool order by kbool'''
	qt_sql_variance_BigInt_notnull '''
		select variance(kbint) from fn_test_not_nullable'''
	qt_sql_variance_BigInt_agg_phase_1_notnull '''
		select count(id), variance(kbint) from fn_test_not_nullable group by id order by id'''
	qt_sql_variance_BigInt_agg_phase_2_notnull '''
		select count(distinct id), variance(kbint) from fn_test_not_nullable'''
	qt_sql_variance_BigInt_agg_phase_3_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), variance(kbint) from fn_test group by kbool order by kbool'''
	qt_sql_variance_BigInt_agg_phase_4_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), variance(kbint) from fn_test'''

	qt_sql_variance_Float_gb '''
		select variance(kfloat) from fn_test group by kbool order by kbool'''
	qt_sql_variance_Float '''
		select variance(kfloat) from fn_test'''
	qt_sql_variance_Float_agg_phase_1 '''
		select count(id), variance(kfloat) from fn_test group by id order by id'''
	qt_sql_variance_Float_agg_phase_2 '''
		select count(distinct id), variance(kfloat) from fn_test'''
	qt_sql_variance_Float_agg_phase_3 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), variance(kfloat) from fn_test group by kbool order by kbool'''
	qt_sql_variance_Float_agg_phase_4 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), variance(kfloat) from fn_test'''
	qt_sql_variance_Float_gb_notnull '''
		select variance(kfloat) from fn_test_not_nullable group by kbool order by kbool'''
	qt_sql_variance_Float_notnull '''
		select variance(kfloat) from fn_test_not_nullable'''
	qt_sql_variance_Float_agg_phase_1_notnull '''
		select count(id), variance(kfloat) from fn_test_not_nullable group by id order by id'''
	qt_sql_variance_Float_agg_phase_2_notnull '''
		select count(distinct id), variance(kfloat) from fn_test_not_nullable'''
	qt_sql_variance_Float_agg_phase_3_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), variance(kfloat) from fn_test group by kbool order by kbool'''
	qt_sql_variance_Float_agg_phase_4_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), variance(kfloat) from fn_test'''

	qt_sql_variance_Double_gb '''
		select variance(kdbl) from fn_test group by kbool order by kbool'''
	qt_sql_variance_Double '''
		select variance(kdbl) from fn_test'''
	qt_sql_variance_Double_agg_phase_1 '''
		select count(id), variance(kdbl) from fn_test group by id order by id'''
	qt_sql_variance_Double_agg_phase_2 '''
		select count(distinct id), variance(kdbl) from fn_test'''
	qt_sql_variance_Double_agg_phase_3 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), variance(kdbl) from fn_test group by kbool order by kbool'''
	qt_sql_variance_Double_agg_phase_4 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), variance(kdbl) from fn_test'''
	qt_sql_variance_Double_gb_notnull '''
		select variance(kdbl) from fn_test_not_nullable group by kbool order by kbool'''
	qt_sql_variance_Double_notnull '''
		select variance(kdbl) from fn_test_not_nullable'''
	qt_sql_variance_Double_agg_phase_1_notnull '''
		select count(id), variance(kdbl) from fn_test_not_nullable group by id order by id'''
	qt_sql_variance_Double_agg_phase_2_notnull '''
		select count(distinct id), variance(kdbl) from fn_test_not_nullable'''
	qt_sql_variance_Double_agg_phase_3_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), variance(kdbl) from fn_test group by kbool order by kbool'''
	qt_sql_variance_Double_agg_phase_4_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), variance(kdbl) from fn_test'''

	qt_sql_variance_DecimalV2_gb '''
		select variance(kdcmls1) from fn_test group by kbool order by kbool'''
	qt_sql_variance_DecimalV2 '''
		select variance(kdcmls1) from fn_test'''
	qt_sql_variance_DecimalV2_agg_phase_1 '''
		select count(id), variance(kdcmls1) from fn_test group by id order by id'''
	qt_sql_variance_DecimalV2_agg_phase_2 '''
		select count(distinct id), variance(kdcmls1) from fn_test'''
	qt_sql_variance_DecimalV2_agg_phase_3 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), variance(kdcmls1) from fn_test group by kbool order by kbool'''
	qt_sql_variance_DecimalV2_agg_phase_4 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), variance(kdcmls1) from fn_test'''
	qt_sql_variance_DecimalV2_gb_notnull '''
		select variance(kdcmls1) from fn_test_not_nullable group by kbool order by kbool'''
	qt_sql_variance_DecimalV2_notnull '''
		select variance(kdcmls1) from fn_test_not_nullable'''
	qt_sql_variance_DecimalV2_agg_phase_1_notnull '''
		select count(id), variance(kdcmls1) from fn_test_not_nullable group by id order by id'''
	qt_sql_variance_DecimalV2_agg_phase_2_notnull '''
		select count(distinct id), variance(kdcmls1) from fn_test_not_nullable'''
	qt_sql_variance_DecimalV2_agg_phase_3_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), variance(kdcmls1) from fn_test group by kbool order by kbool'''
	qt_sql_variance_DecimalV2_agg_phase_4_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), variance(kdcmls1) from fn_test'''

	qt_sql_variance_samp_TinyInt_gb '''
		select variance_samp(ktint) from fn_test group by kbool order by kbool'''
	qt_sql_variance_samp_TinyInt '''
		select variance_samp(ktint) from fn_test'''
	qt_sql_variance_samp_TinyInt_agg_phase_1 '''
		select count(id), variance_samp(ktint) from fn_test group by id order by id'''
	qt_sql_variance_samp_TinyInt_agg_phase_2 '''
		select count(distinct id), variance_samp(ktint) from fn_test'''
	qt_sql_variance_samp_TinyInt_agg_phase_3 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), variance_samp(ktint) from fn_test group by kbool order by kbool'''
	qt_sql_variance_samp_TinyInt_agg_phase_4 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), variance_samp(ktint) from fn_test'''
	qt_sql_variance_samp_TinyInt_gb_notnull '''
		select variance_samp(ktint) from fn_test_not_nullable group by kbool order by kbool'''
	qt_sql_variance_samp_TinyInt_notnull '''
		select variance_samp(ktint) from fn_test_not_nullable'''
	qt_sql_variance_samp_TinyInt_agg_phase_1_notnull '''
		select count(id), variance_samp(ktint) from fn_test_not_nullable group by id order by id'''
	qt_sql_variance_samp_TinyInt_agg_phase_2_notnull '''
		select count(distinct id), variance_samp(ktint) from fn_test_not_nullable'''
	qt_sql_variance_samp_TinyInt_agg_phase_3_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), variance_samp(ktint) from fn_test group by kbool order by kbool'''
	qt_sql_variance_samp_TinyInt_agg_phase_4_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), variance_samp(ktint) from fn_test'''

	qt_sql_variance_samp_SmallInt_gb '''
		select variance_samp(ksint) from fn_test group by kbool order by kbool'''
	qt_sql_variance_samp_SmallInt '''
		select variance_samp(ksint) from fn_test'''
	qt_sql_variance_samp_SmallInt_agg_phase_1 '''
		select count(id), variance_samp(ksint) from fn_test group by id order by id'''
	qt_sql_variance_samp_SmallInt_agg_phase_2 '''
		select count(distinct id), variance_samp(ksint) from fn_test'''
	qt_sql_variance_samp_SmallInt_agg_phase_3 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), variance_samp(ksint) from fn_test group by kbool order by kbool'''
	qt_sql_variance_samp_SmallInt_agg_phase_4 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), variance_samp(ksint) from fn_test'''
	qt_sql_variance_samp_SmallInt_gb_notnull '''
		select variance_samp(ksint) from fn_test_not_nullable group by kbool order by kbool'''
	qt_sql_variance_samp_SmallInt_notnull '''
		select variance_samp(ksint) from fn_test_not_nullable'''
	qt_sql_variance_samp_SmallInt_agg_phase_1_notnull '''
		select count(id), variance_samp(ksint) from fn_test_not_nullable group by id order by id'''
	qt_sql_variance_samp_SmallInt_agg_phase_2_notnull '''
		select count(distinct id), variance_samp(ksint) from fn_test_not_nullable'''
	qt_sql_variance_samp_SmallInt_agg_phase_3_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), variance_samp(ksint) from fn_test group by kbool order by kbool'''
	qt_sql_variance_samp_SmallInt_agg_phase_4_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), variance_samp(ksint) from fn_test'''

	qt_sql_variance_samp_Integer_gb '''
		select variance_samp(kint) from fn_test group by kbool order by kbool'''
	qt_sql_variance_samp_Integer '''
		select variance_samp(kint) from fn_test'''
	qt_sql_variance_samp_Integer_agg_phase_1 '''
		select count(id), variance_samp(kint) from fn_test group by id order by id'''
	qt_sql_variance_samp_Integer_agg_phase_2 '''
		select count(distinct id), variance_samp(kint) from fn_test'''
	qt_sql_variance_samp_Integer_agg_phase_3 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), variance_samp(kint) from fn_test group by kbool order by kbool'''
	qt_sql_variance_samp_Integer_agg_phase_4 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), variance_samp(kint) from fn_test'''
	qt_sql_variance_samp_Integer_gb_notnull '''
		select variance_samp(kint) from fn_test_not_nullable group by kbool order by kbool'''
	qt_sql_variance_samp_Integer_notnull '''
		select variance_samp(kint) from fn_test_not_nullable'''
	qt_sql_variance_samp_Integer_agg_phase_1_notnull '''
		select count(id), variance_samp(kint) from fn_test_not_nullable group by id order by id'''
	qt_sql_variance_samp_Integer_agg_phase_2_notnull '''
		select count(distinct id), variance_samp(kint) from fn_test_not_nullable'''
	qt_sql_variance_samp_Integer_agg_phase_3_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), variance_samp(kint) from fn_test group by kbool order by kbool'''
	qt_sql_variance_samp_Integer_agg_phase_4_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), variance_samp(kint) from fn_test'''

	qt_sql_variance_samp_BigInt_gb '''
		select variance_samp(kbint) from fn_test group by kbool order by kbool'''
	qt_sql_variance_samp_BigInt '''
		select variance_samp(kbint) from fn_test'''
	qt_sql_variance_samp_BigInt_agg_phase_1 '''
		select count(id), variance_samp(kbint) from fn_test group by id order by id'''
	qt_sql_variance_samp_BigInt_agg_phase_2 '''
		select count(distinct id), variance_samp(kbint) from fn_test'''
	qt_sql_variance_samp_BigInt_agg_phase_3 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), variance_samp(kbint) from fn_test group by kbool order by kbool'''
	qt_sql_variance_samp_BigInt_agg_phase_4 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), variance_samp(kbint) from fn_test'''
	qt_sql_variance_samp_BigInt_gb_notnull '''
		select variance_samp(kbint) from fn_test_not_nullable group by kbool order by kbool'''
	qt_sql_variance_samp_BigInt_notnull '''
		select variance_samp(kbint) from fn_test_not_nullable'''
	qt_sql_variance_samp_BigInt_agg_phase_1_notnull '''
		select count(id), variance_samp(kbint) from fn_test_not_nullable group by id order by id'''
	qt_sql_variance_samp_BigInt_agg_phase_2_notnull '''
		select count(distinct id), variance_samp(kbint) from fn_test_not_nullable'''
	qt_sql_variance_samp_BigInt_agg_phase_3_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), variance_samp(kbint) from fn_test group by kbool order by kbool'''
	qt_sql_variance_samp_BigInt_agg_phase_4_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), variance_samp(kbint) from fn_test'''

	qt_sql_variance_samp_Float_gb '''
		select variance_samp(kfloat) from fn_test group by kbool order by kbool'''
	qt_sql_variance_samp_Float '''
		select variance_samp(kfloat) from fn_test'''
	qt_sql_variance_samp_Float_agg_phase_1 '''
		select count(id), variance_samp(kfloat) from fn_test group by id order by id'''
	qt_sql_variance_samp_Float_agg_phase_2 '''
		select count(distinct id), variance_samp(kfloat) from fn_test'''
	qt_sql_variance_samp_Float_agg_phase_3 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), variance_samp(kfloat) from fn_test group by kbool order by kbool'''
	qt_sql_variance_samp_Float_agg_phase_4 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), variance_samp(kfloat) from fn_test'''
	qt_sql_variance_samp_Float_gb_notnull '''
		select variance_samp(kfloat) from fn_test_not_nullable group by kbool order by kbool'''
	qt_sql_variance_samp_Float_notnull '''
		select variance_samp(kfloat) from fn_test_not_nullable'''
	qt_sql_variance_samp_Float_agg_phase_1_notnull '''
		select count(id), variance_samp(kfloat) from fn_test_not_nullable group by id order by id'''
	qt_sql_variance_samp_Float_agg_phase_2_notnull '''
		select count(distinct id), variance_samp(kfloat) from fn_test_not_nullable'''
	qt_sql_variance_samp_Float_agg_phase_3_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), variance_samp(kfloat) from fn_test group by kbool order by kbool'''
	qt_sql_variance_samp_Float_agg_phase_4_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), variance_samp(kfloat) from fn_test'''

	qt_sql_variance_samp_Double_gb '''
		select variance_samp(kdbl) from fn_test group by kbool order by kbool'''
	qt_sql_variance_samp_Double '''
		select variance_samp(kdbl) from fn_test'''
	qt_sql_variance_samp_Double_agg_phase_1 '''
		select count(id), variance_samp(kdbl) from fn_test group by id order by id'''
	qt_sql_variance_samp_Double_agg_phase_2 '''
		select count(distinct id), variance_samp(kdbl) from fn_test'''
	qt_sql_variance_samp_Double_agg_phase_3 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), variance_samp(kdbl) from fn_test group by kbool order by kbool'''
	qt_sql_variance_samp_Double_agg_phase_4 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), variance_samp(kdbl) from fn_test'''
	qt_sql_variance_samp_Double_gb_notnull '''
		select variance_samp(kdbl) from fn_test_not_nullable group by kbool order by kbool'''
	qt_sql_variance_samp_Double_notnull '''
		select variance_samp(kdbl) from fn_test_not_nullable'''
	qt_sql_variance_samp_Double_agg_phase_1_notnull '''
		select count(id), variance_samp(kdbl) from fn_test_not_nullable group by id order by id'''
	qt_sql_variance_samp_Double_agg_phase_2_notnull '''
		select count(distinct id), variance_samp(kdbl) from fn_test_not_nullable'''
	qt_sql_variance_samp_Double_agg_phase_3_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), variance_samp(kdbl) from fn_test group by kbool order by kbool'''
	qt_sql_variance_samp_Double_agg_phase_4_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), variance_samp(kdbl) from fn_test'''

	// qt_sql_variance_samp_DecimalV2_gb '''
	// 	select variance_samp(kdcmls1) from fn_test group by kbool order by kbool'''
	// qt_sql_variance_samp_DecimalV2 '''
	// 	select variance_samp(kdcmls1) from fn_test'''
	qt_sql_variance_samp_DecimalV2_agg_phase_1 '''
		select count(id), variance_samp(kdcmls1) from fn_test group by id order by id'''
	qt_sql_variance_samp_DecimalV2_agg_phase_2 '''
		select count(distinct id), variance_samp(kdcmls1) from fn_test'''
	qt_sql_variance_samp_DecimalV2_agg_phase_3 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), variance_samp(kdcmls1) from fn_test group by kbool order by kbool'''
	qt_sql_variance_samp_DecimalV2_agg_phase_4 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), variance_samp(kdcmls1) from fn_test'''
	// qt_sql_variance_samp_DecimalV2_gb_notnull '''
	// 	select variance_samp(kdcmls1) from fn_test_not_nullable group by kbool order by kbool'''
	// qt_sql_variance_samp_DecimalV2_notnull '''
	// 	select variance_samp(kdcmls1) from fn_test_not_nullable'''
	qt_sql_variance_samp_DecimalV2_agg_phase_1_notnull '''
		select count(id), variance_samp(kdcmls1) from fn_test_not_nullable group by id order by id'''
	qt_sql_variance_samp_DecimalV2_agg_phase_2_notnull '''
		select count(distinct id), variance_samp(kdcmls1) from fn_test_not_nullable'''
	qt_sql_variance_samp_DecimalV2_agg_phase_3_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), variance_samp(kdcmls1) from fn_test group by kbool order by kbool'''
	qt_sql_variance_samp_DecimalV2_agg_phase_4_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), variance_samp(kdcmls1) from fn_test'''

	qt_sql_window_funnel_BigInt_String_DateTime_Boolean_gb '''
		select window_funnel(3600 * 3, 'default', kdtm, kint = 1, kint = 2) from fn_test group by kbool order by kbool'''
	qt_sql_window_funnel_BigInt_String_DateTime_Boolean '''
		select window_funnel(3600 * 3, 'default', kdtm, kint = 1, kint = 2) from fn_test'''
	qt_sql_window_funnel_BigInt_String_DateTime_Boolean_agg_phase_1 '''
		select count(id), window_funnel(3600 * 3, 'default', kdtm, kint = 1, kint = 2) from fn_test group by id order by id'''
	qt_sql_window_funnel_BigInt_String_DateTime_Boolean_agg_phase_2 '''
		select count(distinct id), window_funnel(3600 * 3, 'default', kdtm, kint = 1, kint = 2) from fn_test'''
	qt_sql_window_funnel_BigInt_String_DateTime_Boolean_agg_phase_3 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), window_funnel(3600 * 3, 'default', kdtm, kint = 1, kint = 2) from fn_test group by kbool order by kbool'''
	qt_sql_window_funnel_BigInt_String_DateTime_Boolean_agg_phase_4 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), window_funnel(3600 * 3, 'default', kdtm, kint = 1, kint = 2) from fn_test'''
	qt_sql_window_funnel_BigInt_String_DateTime_Boolean_gb_notnull '''
		select window_funnel(3600 * 3, 'default', kdtm, kint = 1, kint = 2) from fn_test_not_nullable group by kbool order by kbool'''
	qt_sql_window_funnel_BigInt_String_DateTime_Boolean_notnull '''
		select window_funnel(3600 * 3, 'default', kdtm, kint = 1, kint = 2) from fn_test_not_nullable'''
	qt_sql_window_funnel_BigInt_String_DateTime_Boolean_agg_phase_1_notnull '''
		select count(id), window_funnel(3600 * 3, 'default', kdtm, kint = 1, kint = 2) from fn_test_not_nullable group by id order by id'''
	qt_sql_window_funnel_BigInt_String_DateTime_Boolean_agg_phase_2_notnull '''
		select count(distinct id), window_funnel(3600 * 3, 'default', kdtm, kint = 1, kint = 2) from fn_test_not_nullable'''
	qt_sql_window_funnel_BigInt_String_DateTime_Boolean_agg_phase_3_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), window_funnel(3600 * 3, 'default', kdtm, kint = 1, kint = 2) from fn_test group by kbool order by kbool'''
	qt_sql_window_funnel_BigInt_String_DateTime_Boolean_agg_phase_4_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), window_funnel(3600 * 3, 'default', kdtm, kint = 1, kint = 2) from fn_test'''

	qt_sql_window_funnel_BigInt_String_DateTimeV2_Boolean_gb '''
		select window_funnel(3600 * 3, 'default', kdtmv2s1, kint = 1, kint = 2) from fn_test group by kbool order by kbool'''
	qt_sql_window_funnel_BigInt_String_DateTimeV2_Boolean '''
		select window_funnel(3600 * 3, 'default', kdtmv2s1, kint = 1, kint = 2) from fn_test'''
	qt_sql_window_funnel_BigInt_String_DateTimeV2_Boolean_agg_phase_1 '''
		select count(id), window_funnel(3600 * 3, 'default', kdtmv2s1, kint = 1, kint = 2) from fn_test group by id order by id'''
	qt_sql_window_funnel_BigInt_String_DateTimeV2_Boolean_agg_phase_2 '''
		select count(distinct id), window_funnel(3600 * 3, 'default', kdtmv2s1, kint = 1, kint = 2) from fn_test'''
	qt_sql_window_funnel_BigInt_String_DateTimeV2_Boolean_agg_phase_3 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), window_funnel(3600 * 3, 'default', kdtmv2s1, kint = 1, kint = 2) from fn_test group by kbool order by kbool'''
	qt_sql_window_funnel_BigInt_String_DateTimeV2_Boolean_agg_phase_4 '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), window_funnel(3600 * 3, 'default', kdtmv2s1, kint = 1, kint = 2) from fn_test'''
	qt_sql_window_funnel_BigInt_String_DateTimeV2_Boolean_gb_notnull '''
		select window_funnel(3600 * 3, 'default', kdtmv2s1, kint = 1, kint = 2) from fn_test_not_nullable group by kbool order by kbool'''
	qt_sql_window_funnel_BigInt_String_DateTimeV2_Boolean_notnull '''
		select window_funnel(3600 * 3, 'default', kdtmv2s1, kint = 1, kint = 2) from fn_test_not_nullable'''
	qt_sql_window_funnel_BigInt_String_DateTimeV2_Boolean_agg_phase_1_notnull '''
		select count(id), window_funnel(3600 * 3, 'default', kdtmv2s1, kint = 1, kint = 2) from fn_test_not_nullable group by id order by id'''
	qt_sql_window_funnel_BigInt_String_DateTimeV2_Boolean_agg_phase_2_notnull '''
		select count(distinct id), window_funnel(3600 * 3, 'default', kdtmv2s1, kint = 1, kint = 2) from fn_test_not_nullable'''
	qt_sql_window_funnel_BigInt_String_DateTimeV2_Boolean_agg_phase_3_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id, kint), window_funnel(3600 * 3, 'default', kdtmv2s1, kint = 1, kint = 2) from fn_test group by kbool order by kbool'''
	qt_sql_window_funnel_BigInt_String_DateTimeV2_Boolean_agg_phase_4_notnull '''
		select /*+SET_VAR(disable_nereids_rules='THREE_PHASE_AGGREGATE_WITH_DISTINCT, TWO_PHASE_AGGREGATE_WITH_DISTINCT')*/ count(distinct id), window_funnel(3600 * 3, 'default', kdtmv2s1, kint = 1, kint = 2) from fn_test'''

	qt_max_null "select max(null) from fn_test;"

    qt_sql_map_agg '''
		select id,map_agg(kint,kstr) from fn_test group by id order by id'''

    qt_sql_map_agg_not_nullable '''
		select id,map_agg(kint,kstr) from fn_test_not_nullable group by id order by id'''

    qt_sql_array_agg '''
		select id,array_agg(kint) from fn_test group by id order by id'''

    qt_sql_array_agg_not_nullable '''
		select id,array_agg(kint) from fn_test_not_nullable group by id order by id'''

}
