// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

package org.apache.doris.catalog;

import org.apache.doris.nereids.trees.expressions.Like;
import org.apache.doris.nereids.trees.expressions.Regexp;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Abs;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Acos;
import org.apache.doris.nereids.trees.expressions.functions.scalar.AesDecrypt;
import org.apache.doris.nereids.trees.expressions.functions.scalar.AesDecryptV2;
import org.apache.doris.nereids.trees.expressions.functions.scalar.AesEncrypt;
import org.apache.doris.nereids.trees.expressions.functions.scalar.AesEncryptV2;
import org.apache.doris.nereids.trees.expressions.functions.scalar.AppendTrailingCharIfAbsent;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Array;
import org.apache.doris.nereids.trees.expressions.functions.scalar.ArrayApply;
import org.apache.doris.nereids.trees.expressions.functions.scalar.ArrayAvg;
import org.apache.doris.nereids.trees.expressions.functions.scalar.ArrayCompact;
import org.apache.doris.nereids.trees.expressions.functions.scalar.ArrayConcat;
import org.apache.doris.nereids.trees.expressions.functions.scalar.ArrayContains;
import org.apache.doris.nereids.trees.expressions.functions.scalar.ArrayCount;
import org.apache.doris.nereids.trees.expressions.functions.scalar.ArrayCumSum;
import org.apache.doris.nereids.trees.expressions.functions.scalar.ArrayDifference;
import org.apache.doris.nereids.trees.expressions.functions.scalar.ArrayDistinct;
import org.apache.doris.nereids.trees.expressions.functions.scalar.ArrayEnumerate;
import org.apache.doris.nereids.trees.expressions.functions.scalar.ArrayEnumerateUniq;
import org.apache.doris.nereids.trees.expressions.functions.scalar.ArrayExcept;
import org.apache.doris.nereids.trees.expressions.functions.scalar.ArrayExists;
import org.apache.doris.nereids.trees.expressions.functions.scalar.ArrayFilter;
import org.apache.doris.nereids.trees.expressions.functions.scalar.ArrayFirst;
import org.apache.doris.nereids.trees.expressions.functions.scalar.ArrayFirstIndex;
import org.apache.doris.nereids.trees.expressions.functions.scalar.ArrayIntersect;
import org.apache.doris.nereids.trees.expressions.functions.scalar.ArrayJoin;
import org.apache.doris.nereids.trees.expressions.functions.scalar.ArrayLast;
import org.apache.doris.nereids.trees.expressions.functions.scalar.ArrayLastIndex;
import org.apache.doris.nereids.trees.expressions.functions.scalar.ArrayMap;
import org.apache.doris.nereids.trees.expressions.functions.scalar.ArrayMax;
import org.apache.doris.nereids.trees.expressions.functions.scalar.ArrayMin;
import org.apache.doris.nereids.trees.expressions.functions.scalar.ArrayPopBack;
import org.apache.doris.nereids.trees.expressions.functions.scalar.ArrayPopFront;
import org.apache.doris.nereids.trees.expressions.functions.scalar.ArrayPosition;
import org.apache.doris.nereids.trees.expressions.functions.scalar.ArrayProduct;
import org.apache.doris.nereids.trees.expressions.functions.scalar.ArrayPushBack;
import org.apache.doris.nereids.trees.expressions.functions.scalar.ArrayPushFront;
import org.apache.doris.nereids.trees.expressions.functions.scalar.ArrayRange;
import org.apache.doris.nereids.trees.expressions.functions.scalar.ArrayRemove;
import org.apache.doris.nereids.trees.expressions.functions.scalar.ArrayRepeat;
import org.apache.doris.nereids.trees.expressions.functions.scalar.ArrayReverseSort;
import org.apache.doris.nereids.trees.expressions.functions.scalar.ArrayShuffle;
import org.apache.doris.nereids.trees.expressions.functions.scalar.ArraySlice;
import org.apache.doris.nereids.trees.expressions.functions.scalar.ArraySort;
import org.apache.doris.nereids.trees.expressions.functions.scalar.ArraySortBy;
import org.apache.doris.nereids.trees.expressions.functions.scalar.ArraySum;
import org.apache.doris.nereids.trees.expressions.functions.scalar.ArrayUnion;
import org.apache.doris.nereids.trees.expressions.functions.scalar.ArrayWithConstant;
import org.apache.doris.nereids.trees.expressions.functions.scalar.ArrayZip;
import org.apache.doris.nereids.trees.expressions.functions.scalar.ArraysOverlap;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Ascii;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Asin;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Atan;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Atan2;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Bin;
import org.apache.doris.nereids.trees.expressions.functions.scalar.BitCount;
import org.apache.doris.nereids.trees.expressions.functions.scalar.BitLength;
import org.apache.doris.nereids.trees.expressions.functions.scalar.BitShiftLeft;
import org.apache.doris.nereids.trees.expressions.functions.scalar.BitShiftRight;
import org.apache.doris.nereids.trees.expressions.functions.scalar.BitmapAnd;
import org.apache.doris.nereids.trees.expressions.functions.scalar.BitmapAndCount;
import org.apache.doris.nereids.trees.expressions.functions.scalar.BitmapAndNot;
import org.apache.doris.nereids.trees.expressions.functions.scalar.BitmapAndNotAlias;
import org.apache.doris.nereids.trees.expressions.functions.scalar.BitmapAndNotCount;
import org.apache.doris.nereids.trees.expressions.functions.scalar.BitmapAndNotCountAlias;
import org.apache.doris.nereids.trees.expressions.functions.scalar.BitmapContains;
import org.apache.doris.nereids.trees.expressions.functions.scalar.BitmapCount;
import org.apache.doris.nereids.trees.expressions.functions.scalar.BitmapEmpty;
import org.apache.doris.nereids.trees.expressions.functions.scalar.BitmapFromArray;
import org.apache.doris.nereids.trees.expressions.functions.scalar.BitmapFromBase64;
import org.apache.doris.nereids.trees.expressions.functions.scalar.BitmapFromString;
import org.apache.doris.nereids.trees.expressions.functions.scalar.BitmapHasAll;
import org.apache.doris.nereids.trees.expressions.functions.scalar.BitmapHasAny;
import org.apache.doris.nereids.trees.expressions.functions.scalar.BitmapHash;
import org.apache.doris.nereids.trees.expressions.functions.scalar.BitmapHash64;
import org.apache.doris.nereids.trees.expressions.functions.scalar.BitmapMax;
import org.apache.doris.nereids.trees.expressions.functions.scalar.BitmapMin;
import org.apache.doris.nereids.trees.expressions.functions.scalar.BitmapNot;
import org.apache.doris.nereids.trees.expressions.functions.scalar.BitmapOr;
import org.apache.doris.nereids.trees.expressions.functions.scalar.BitmapOrCount;
import org.apache.doris.nereids.trees.expressions.functions.scalar.BitmapRemove;
import org.apache.doris.nereids.trees.expressions.functions.scalar.BitmapSubsetInRange;
import org.apache.doris.nereids.trees.expressions.functions.scalar.BitmapSubsetLimit;
import org.apache.doris.nereids.trees.expressions.functions.scalar.BitmapToArray;
import org.apache.doris.nereids.trees.expressions.functions.scalar.BitmapToBase64;
import org.apache.doris.nereids.trees.expressions.functions.scalar.BitmapToString;
import org.apache.doris.nereids.trees.expressions.functions.scalar.BitmapXor;
import org.apache.doris.nereids.trees.expressions.functions.scalar.BitmapXorCount;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Cardinality;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Cbrt;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Ceil;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Char;
import org.apache.doris.nereids.trees.expressions.functions.scalar.CharacterLength;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Coalesce;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Concat;
import org.apache.doris.nereids.trees.expressions.functions.scalar.ConcatWs;
import org.apache.doris.nereids.trees.expressions.functions.scalar.ConnectionId;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Conv;
import org.apache.doris.nereids.trees.expressions.functions.scalar.ConvertTo;
import org.apache.doris.nereids.trees.expressions.functions.scalar.ConvertTz;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Cos;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Cosh;
import org.apache.doris.nereids.trees.expressions.functions.scalar.CosineDistance;
import org.apache.doris.nereids.trees.expressions.functions.scalar.CountEqual;
import org.apache.doris.nereids.trees.expressions.functions.scalar.CreateMap;
import org.apache.doris.nereids.trees.expressions.functions.scalar.CreateNamedStruct;
import org.apache.doris.nereids.trees.expressions.functions.scalar.CreateStruct;
import org.apache.doris.nereids.trees.expressions.functions.scalar.CurrentCatalog;
import org.apache.doris.nereids.trees.expressions.functions.scalar.CurrentDate;
import org.apache.doris.nereids.trees.expressions.functions.scalar.CurrentTime;
import org.apache.doris.nereids.trees.expressions.functions.scalar.CurrentUser;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Database;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Date;
import org.apache.doris.nereids.trees.expressions.functions.scalar.DateDiff;
import org.apache.doris.nereids.trees.expressions.functions.scalar.DateFormat;
import org.apache.doris.nereids.trees.expressions.functions.scalar.DateTrunc;
import org.apache.doris.nereids.trees.expressions.functions.scalar.DateV2;
import org.apache.doris.nereids.trees.expressions.functions.scalar.DayCeil;
import org.apache.doris.nereids.trees.expressions.functions.scalar.DayFloor;
import org.apache.doris.nereids.trees.expressions.functions.scalar.DayName;
import org.apache.doris.nereids.trees.expressions.functions.scalar.DayOfMonth;
import org.apache.doris.nereids.trees.expressions.functions.scalar.DayOfWeek;
import org.apache.doris.nereids.trees.expressions.functions.scalar.DayOfYear;
import org.apache.doris.nereids.trees.expressions.functions.scalar.DaysAdd;
import org.apache.doris.nereids.trees.expressions.functions.scalar.DaysDiff;
import org.apache.doris.nereids.trees.expressions.functions.scalar.DaysSub;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Dceil;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Degrees;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Dexp;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Dfloor;
import org.apache.doris.nereids.trees.expressions.functions.scalar.DigitalMasking;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Dlog1;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Dlog10;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Domain;
import org.apache.doris.nereids.trees.expressions.functions.scalar.DomainWithoutWww;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Dpow;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Dround;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Dsqrt;
import org.apache.doris.nereids.trees.expressions.functions.scalar.E;
import org.apache.doris.nereids.trees.expressions.functions.scalar.ElementAt;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Elt;
import org.apache.doris.nereids.trees.expressions.functions.scalar.EndsWith;
import org.apache.doris.nereids.trees.expressions.functions.scalar.EsQuery;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Exp;
import org.apache.doris.nereids.trees.expressions.functions.scalar.ExtractUrlParameter;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Field;
import org.apache.doris.nereids.trees.expressions.functions.scalar.FindInSet;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Floor;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Fmod;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Fpow;
import org.apache.doris.nereids.trees.expressions.functions.scalar.FromBase64;
import org.apache.doris.nereids.trees.expressions.functions.scalar.FromDays;
import org.apache.doris.nereids.trees.expressions.functions.scalar.FromMicrosecond;
import org.apache.doris.nereids.trees.expressions.functions.scalar.FromMillisecond;
import org.apache.doris.nereids.trees.expressions.functions.scalar.FromSecond;
import org.apache.doris.nereids.trees.expressions.functions.scalar.FromUnixtime;
import org.apache.doris.nereids.trees.expressions.functions.scalar.G;
import org.apache.doris.nereids.trees.expressions.functions.scalar.GetJsonBigInt;
import org.apache.doris.nereids.trees.expressions.functions.scalar.GetJsonDouble;
import org.apache.doris.nereids.trees.expressions.functions.scalar.GetJsonInt;
import org.apache.doris.nereids.trees.expressions.functions.scalar.GetJsonString;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Greatest;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Grouping;
import org.apache.doris.nereids.trees.expressions.functions.scalar.GroupingId;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Hex;
import org.apache.doris.nereids.trees.expressions.functions.scalar.HllCardinality;
import org.apache.doris.nereids.trees.expressions.functions.scalar.HllEmpty;
import org.apache.doris.nereids.trees.expressions.functions.scalar.HllHash;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Hour;
import org.apache.doris.nereids.trees.expressions.functions.scalar.HourCeil;
import org.apache.doris.nereids.trees.expressions.functions.scalar.HourFloor;
import org.apache.doris.nereids.trees.expressions.functions.scalar.HoursAdd;
import org.apache.doris.nereids.trees.expressions.functions.scalar.HoursDiff;
import org.apache.doris.nereids.trees.expressions.functions.scalar.HoursSub;
import org.apache.doris.nereids.trees.expressions.functions.scalar.If;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Ignore;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Initcap;
import org.apache.doris.nereids.trees.expressions.functions.scalar.InnerProduct;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Instr;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Ipv4CIDRToRange;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Ipv4NumToString;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Ipv4StringToNum;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Ipv4StringToNumOrDefault;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Ipv4StringToNumOrNull;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Ipv6CIDRToRange;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Ipv6NumToString;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Ipv6StringToNum;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Ipv6StringToNumOrDefault;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Ipv6StringToNumOrNull;
import org.apache.doris.nereids.trees.expressions.functions.scalar.IsIpAddressInRange;
import org.apache.doris.nereids.trees.expressions.functions.scalar.IsIpv4Compat;
import org.apache.doris.nereids.trees.expressions.functions.scalar.IsIpv4Mapped;
import org.apache.doris.nereids.trees.expressions.functions.scalar.IsIpv4String;
import org.apache.doris.nereids.trees.expressions.functions.scalar.IsIpv6String;
import org.apache.doris.nereids.trees.expressions.functions.scalar.JsonArray;
import org.apache.doris.nereids.trees.expressions.functions.scalar.JsonContains;
import org.apache.doris.nereids.trees.expressions.functions.scalar.JsonExtract;
import org.apache.doris.nereids.trees.expressions.functions.scalar.JsonInsert;
import org.apache.doris.nereids.trees.expressions.functions.scalar.JsonLength;
import org.apache.doris.nereids.trees.expressions.functions.scalar.JsonObject;
import org.apache.doris.nereids.trees.expressions.functions.scalar.JsonQuote;
import org.apache.doris.nereids.trees.expressions.functions.scalar.JsonReplace;
import org.apache.doris.nereids.trees.expressions.functions.scalar.JsonSet;
import org.apache.doris.nereids.trees.expressions.functions.scalar.JsonUnQuote;
import org.apache.doris.nereids.trees.expressions.functions.scalar.JsonbExistsPath;
import org.apache.doris.nereids.trees.expressions.functions.scalar.JsonbExtract;
import org.apache.doris.nereids.trees.expressions.functions.scalar.JsonbExtractBigint;
import org.apache.doris.nereids.trees.expressions.functions.scalar.JsonbExtractBool;
import org.apache.doris.nereids.trees.expressions.functions.scalar.JsonbExtractDouble;
import org.apache.doris.nereids.trees.expressions.functions.scalar.JsonbExtractInt;
import org.apache.doris.nereids.trees.expressions.functions.scalar.JsonbExtractIsnull;
import org.apache.doris.nereids.trees.expressions.functions.scalar.JsonbExtractLargeint;
import org.apache.doris.nereids.trees.expressions.functions.scalar.JsonbExtractString;
import org.apache.doris.nereids.trees.expressions.functions.scalar.JsonbParse;
import org.apache.doris.nereids.trees.expressions.functions.scalar.JsonbParseErrorToInvalid;
import org.apache.doris.nereids.trees.expressions.functions.scalar.JsonbParseErrorToNull;
import org.apache.doris.nereids.trees.expressions.functions.scalar.JsonbParseErrorToValue;
import org.apache.doris.nereids.trees.expressions.functions.scalar.JsonbParseNotnull;
import org.apache.doris.nereids.trees.expressions.functions.scalar.JsonbParseNotnullErrorToInvalid;
import org.apache.doris.nereids.trees.expressions.functions.scalar.JsonbParseNotnullErrorToValue;
import org.apache.doris.nereids.trees.expressions.functions.scalar.JsonbParseNullable;
import org.apache.doris.nereids.trees.expressions.functions.scalar.JsonbParseNullableErrorToInvalid;
import org.apache.doris.nereids.trees.expressions.functions.scalar.JsonbParseNullableErrorToNull;
import org.apache.doris.nereids.trees.expressions.functions.scalar.JsonbParseNullableErrorToValue;
import org.apache.doris.nereids.trees.expressions.functions.scalar.JsonbType;
import org.apache.doris.nereids.trees.expressions.functions.scalar.JsonbValid;
import org.apache.doris.nereids.trees.expressions.functions.scalar.L1Distance;
import org.apache.doris.nereids.trees.expressions.functions.scalar.L2Distance;
import org.apache.doris.nereids.trees.expressions.functions.scalar.LastDay;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Least;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Left;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Length;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Ln;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Locate;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Log;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Log10;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Log2;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Lower;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Lpad;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Ltrim;
import org.apache.doris.nereids.trees.expressions.functions.scalar.MakeDate;
import org.apache.doris.nereids.trees.expressions.functions.scalar.MapContainsKey;
import org.apache.doris.nereids.trees.expressions.functions.scalar.MapContainsValue;
import org.apache.doris.nereids.trees.expressions.functions.scalar.MapKeys;
import org.apache.doris.nereids.trees.expressions.functions.scalar.MapSize;
import org.apache.doris.nereids.trees.expressions.functions.scalar.MapValues;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Mask;
import org.apache.doris.nereids.trees.expressions.functions.scalar.MaskFirstN;
import org.apache.doris.nereids.trees.expressions.functions.scalar.MaskLastN;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Md5;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Md5Sum;
import org.apache.doris.nereids.trees.expressions.functions.scalar.MicroSecondTimestamp;
import org.apache.doris.nereids.trees.expressions.functions.scalar.MicroSecondsAdd;
import org.apache.doris.nereids.trees.expressions.functions.scalar.MicroSecondsDiff;
import org.apache.doris.nereids.trees.expressions.functions.scalar.MicroSecondsSub;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Microsecond;
import org.apache.doris.nereids.trees.expressions.functions.scalar.MilliSecondTimestamp;
import org.apache.doris.nereids.trees.expressions.functions.scalar.MilliSecondsAdd;
import org.apache.doris.nereids.trees.expressions.functions.scalar.MilliSecondsDiff;
import org.apache.doris.nereids.trees.expressions.functions.scalar.MilliSecondsSub;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Minute;
import org.apache.doris.nereids.trees.expressions.functions.scalar.MinuteCeil;
import org.apache.doris.nereids.trees.expressions.functions.scalar.MinuteFloor;
import org.apache.doris.nereids.trees.expressions.functions.scalar.MinutesAdd;
import org.apache.doris.nereids.trees.expressions.functions.scalar.MinutesDiff;
import org.apache.doris.nereids.trees.expressions.functions.scalar.MinutesSub;
import org.apache.doris.nereids.trees.expressions.functions.scalar.MoneyFormat;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Month;
import org.apache.doris.nereids.trees.expressions.functions.scalar.MonthCeil;
import org.apache.doris.nereids.trees.expressions.functions.scalar.MonthFloor;
import org.apache.doris.nereids.trees.expressions.functions.scalar.MonthName;
import org.apache.doris.nereids.trees.expressions.functions.scalar.MonthsAdd;
import org.apache.doris.nereids.trees.expressions.functions.scalar.MonthsDiff;
import org.apache.doris.nereids.trees.expressions.functions.scalar.MonthsSub;
import org.apache.doris.nereids.trees.expressions.functions.scalar.MultiMatchAny;
import org.apache.doris.nereids.trees.expressions.functions.scalar.MultiSearchAllPositions;
import org.apache.doris.nereids.trees.expressions.functions.scalar.MurmurHash332;
import org.apache.doris.nereids.trees.expressions.functions.scalar.MurmurHash364;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Negative;
import org.apache.doris.nereids.trees.expressions.functions.scalar.NonNullable;
import org.apache.doris.nereids.trees.expressions.functions.scalar.NotNullOrEmpty;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Now;
import org.apache.doris.nereids.trees.expressions.functions.scalar.NullIf;
import org.apache.doris.nereids.trees.expressions.functions.scalar.NullOrEmpty;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Nullable;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Nvl;
import org.apache.doris.nereids.trees.expressions.functions.scalar.ParseUrl;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Password;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Pi;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Pmod;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Positive;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Pow;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Power;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Protocol;
import org.apache.doris.nereids.trees.expressions.functions.scalar.QuantilePercent;
import org.apache.doris.nereids.trees.expressions.functions.scalar.QuantileStateEmpty;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Quarter;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Radians;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Random;
import org.apache.doris.nereids.trees.expressions.functions.scalar.RandomBytes;
import org.apache.doris.nereids.trees.expressions.functions.scalar.RegexpExtract;
import org.apache.doris.nereids.trees.expressions.functions.scalar.RegexpExtractAll;
import org.apache.doris.nereids.trees.expressions.functions.scalar.RegexpReplace;
import org.apache.doris.nereids.trees.expressions.functions.scalar.RegexpReplaceOne;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Repeat;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Replace;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Reverse;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Right;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Round;
import org.apache.doris.nereids.trees.expressions.functions.scalar.RoundBankers;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Rpad;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Rtrim;
import org.apache.doris.nereids.trees.expressions.functions.scalar.SecToTime;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Second;
import org.apache.doris.nereids.trees.expressions.functions.scalar.SecondCeil;
import org.apache.doris.nereids.trees.expressions.functions.scalar.SecondFloor;
import org.apache.doris.nereids.trees.expressions.functions.scalar.SecondTimestamp;
import org.apache.doris.nereids.trees.expressions.functions.scalar.SecondsAdd;
import org.apache.doris.nereids.trees.expressions.functions.scalar.SecondsDiff;
import org.apache.doris.nereids.trees.expressions.functions.scalar.SecondsSub;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Sha1;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Sha2;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Sign;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Sin;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Sleep;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Sm3;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Sm3sum;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Sm4Decrypt;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Sm4DecryptV2;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Sm4Encrypt;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Sm4EncryptV2;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Space;
import org.apache.doris.nereids.trees.expressions.functions.scalar.SplitByChar;
import org.apache.doris.nereids.trees.expressions.functions.scalar.SplitByString;
import org.apache.doris.nereids.trees.expressions.functions.scalar.SplitPart;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Sqrt;
import org.apache.doris.nereids.trees.expressions.functions.scalar.StAngle;
import org.apache.doris.nereids.trees.expressions.functions.scalar.StAngleSphere;
import org.apache.doris.nereids.trees.expressions.functions.scalar.StAreaSquareKm;
import org.apache.doris.nereids.trees.expressions.functions.scalar.StAreaSquareMeters;
import org.apache.doris.nereids.trees.expressions.functions.scalar.StAsBinary;
import org.apache.doris.nereids.trees.expressions.functions.scalar.StAstext;
import org.apache.doris.nereids.trees.expressions.functions.scalar.StAswkt;
import org.apache.doris.nereids.trees.expressions.functions.scalar.StAzimuth;
import org.apache.doris.nereids.trees.expressions.functions.scalar.StCircle;
import org.apache.doris.nereids.trees.expressions.functions.scalar.StContains;
import org.apache.doris.nereids.trees.expressions.functions.scalar.StDistanceSphere;
import org.apache.doris.nereids.trees.expressions.functions.scalar.StGeomFromWKB;
import org.apache.doris.nereids.trees.expressions.functions.scalar.StGeometryFromWKB;
import org.apache.doris.nereids.trees.expressions.functions.scalar.StGeometryfromtext;
import org.apache.doris.nereids.trees.expressions.functions.scalar.StGeomfromtext;
import org.apache.doris.nereids.trees.expressions.functions.scalar.StLinefromtext;
import org.apache.doris.nereids.trees.expressions.functions.scalar.StLinestringfromtext;
import org.apache.doris.nereids.trees.expressions.functions.scalar.StPoint;
import org.apache.doris.nereids.trees.expressions.functions.scalar.StPolyfromtext;
import org.apache.doris.nereids.trees.expressions.functions.scalar.StPolygon;
import org.apache.doris.nereids.trees.expressions.functions.scalar.StPolygonfromtext;
import org.apache.doris.nereids.trees.expressions.functions.scalar.StX;
import org.apache.doris.nereids.trees.expressions.functions.scalar.StY;
import org.apache.doris.nereids.trees.expressions.functions.scalar.StartsWith;
import org.apache.doris.nereids.trees.expressions.functions.scalar.StrLeft;
import org.apache.doris.nereids.trees.expressions.functions.scalar.StrRight;
import org.apache.doris.nereids.trees.expressions.functions.scalar.StrToDate;
import org.apache.doris.nereids.trees.expressions.functions.scalar.StructElement;
import org.apache.doris.nereids.trees.expressions.functions.scalar.SubBitmap;
import org.apache.doris.nereids.trees.expressions.functions.scalar.SubReplace;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Substring;
import org.apache.doris.nereids.trees.expressions.functions.scalar.SubstringIndex;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Tan;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Tanh;
import org.apache.doris.nereids.trees.expressions.functions.scalar.TimeDiff;
import org.apache.doris.nereids.trees.expressions.functions.scalar.TimeToSec;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Timestamp;
import org.apache.doris.nereids.trees.expressions.functions.scalar.ToBase64;
import org.apache.doris.nereids.trees.expressions.functions.scalar.ToBitmap;
import org.apache.doris.nereids.trees.expressions.functions.scalar.ToBitmapWithCheck;
import org.apache.doris.nereids.trees.expressions.functions.scalar.ToDate;
import org.apache.doris.nereids.trees.expressions.functions.scalar.ToDateV2;
import org.apache.doris.nereids.trees.expressions.functions.scalar.ToDays;
import org.apache.doris.nereids.trees.expressions.functions.scalar.ToIpv4;
import org.apache.doris.nereids.trees.expressions.functions.scalar.ToIpv4OrDefault;
import org.apache.doris.nereids.trees.expressions.functions.scalar.ToIpv4OrNull;
import org.apache.doris.nereids.trees.expressions.functions.scalar.ToIpv6;
import org.apache.doris.nereids.trees.expressions.functions.scalar.ToIpv6OrDefault;
import org.apache.doris.nereids.trees.expressions.functions.scalar.ToIpv6OrNull;
import org.apache.doris.nereids.trees.expressions.functions.scalar.ToMonday;
import org.apache.doris.nereids.trees.expressions.functions.scalar.ToQuantileState;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Tokenize;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Trim;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Truncate;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Unhex;
import org.apache.doris.nereids.trees.expressions.functions.scalar.UnixTimestamp;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Upper;
import org.apache.doris.nereids.trees.expressions.functions.scalar.UrlDecode;
import org.apache.doris.nereids.trees.expressions.functions.scalar.User;
import org.apache.doris.nereids.trees.expressions.functions.scalar.UtcTimestamp;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Uuid;
import org.apache.doris.nereids.trees.expressions.functions.scalar.UuidNumeric;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Version;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Week;
import org.apache.doris.nereids.trees.expressions.functions.scalar.WeekCeil;
import org.apache.doris.nereids.trees.expressions.functions.scalar.WeekFloor;
import org.apache.doris.nereids.trees.expressions.functions.scalar.WeekOfYear;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Weekday;
import org.apache.doris.nereids.trees.expressions.functions.scalar.WeeksAdd;
import org.apache.doris.nereids.trees.expressions.functions.scalar.WeeksDiff;
import org.apache.doris.nereids.trees.expressions.functions.scalar.WeeksSub;
import org.apache.doris.nereids.trees.expressions.functions.scalar.WidthBucket;
import org.apache.doris.nereids.trees.expressions.functions.scalar.XxHash32;
import org.apache.doris.nereids.trees.expressions.functions.scalar.XxHash64;
import org.apache.doris.nereids.trees.expressions.functions.scalar.Year;
import org.apache.doris.nereids.trees.expressions.functions.scalar.YearCeil;
import org.apache.doris.nereids.trees.expressions.functions.scalar.YearFloor;
import org.apache.doris.nereids.trees.expressions.functions.scalar.YearWeek;
import org.apache.doris.nereids.trees.expressions.functions.scalar.YearsAdd;
import org.apache.doris.nereids.trees.expressions.functions.scalar.YearsDiff;
import org.apache.doris.nereids.trees.expressions.functions.scalar.YearsSub;

import com.google.common.collect.ImmutableList;

import java.util.List;

/**
 * Builtin scalar functions.
 * <p>
 * Note: Please ensure that this class only has some lists and no procedural code.
 * It helps to be clear and concise.
 */
public class BuiltinScalarFunctions implements FunctionHelper {
    public final List<ScalarFunc> scalarFunctions = ImmutableList.of(
            scalar(Abs.class, "abs"),
            scalar(Acos.class, "acos"),
            scalar(AesDecrypt.class, "aes_decrypt"),
            scalar(AesDecryptV2.class, "aes_decrypt_v2"),
            scalar(AesEncrypt.class, "aes_encrypt"),
            scalar(AesEncryptV2.class, "aes_encrypt_v2"),
            scalar(AppendTrailingCharIfAbsent.class, "append_trailing_char_if_absent"),
            scalar(Array.class, "array"),
            scalar(ArrayApply.class, "array_apply"),
            scalar(ArrayAvg.class, "array_avg"),
            scalar(ArrayCompact.class, "array_compact"),
            scalar(ArrayConcat.class, "array_concat"),
            scalar(ArrayContains.class, "array_contains"),
            scalar(ArrayCount.class, "array_count"),
            scalar(ArrayCumSum.class, "array_cum_sum"),
            scalar(ArrayDifference.class, "array_difference"),
            scalar(ArrayDistinct.class, "array_distinct"),
            scalar(ArrayEnumerate.class, "array_enumerate"),
            scalar(ArrayEnumerateUniq.class, "array_enumerate_uniq"),
            scalar(ArrayExcept.class, "array_except"),
            scalar(ArrayExists.class, "array_exists"),
            scalar(ArrayFilter.class, "array_filter"),
            scalar(ArrayFirst.class, "array_first"),
            scalar(ArrayFirstIndex.class, "array_first_index"),
            scalar(ArrayIntersect.class, "array_intersect"),
            scalar(ArrayJoin.class, "array_join"),
            scalar(ArrayLast.class, "array_last"),
            scalar(ArrayLastIndex.class, "array_last_index"),
            scalar(ArrayMap.class, "array_map"),
            scalar(ArrayMax.class, "array_max"),
            scalar(ArrayMin.class, "array_min"),
            scalar(ArrayPopBack.class, "array_popback"),
            scalar(ArrayPopFront.class, "array_popfront"),
            scalar(ArrayPosition.class, "array_position"),
            scalar(ArrayProduct.class, "array_product"),
            scalar(ArrayPushBack.class, "Array_pushback"),
            scalar(ArrayPushFront.class, "Array_pushfront"),
            scalar(ArrayRange.class, "array_range", "sequence"),
            scalar(ArrayRemove.class, "array_remove"),
            scalar(ArrayRepeat.class, "array_repeat"),
            scalar(ArrayReverseSort.class, "array_reverse_sort"),
            scalar(ArraySlice.class, "array_slice"),
            scalar(ArraySort.class, "array_sort"),
            scalar(ArraySortBy.class, "array_sortby"),
            scalar(ArrayShuffle.class, "array_shuffle", "shuffle"),
            scalar(ArraySum.class, "array_sum"),
            scalar(ArrayUnion.class, "array_union"),
            scalar(ArrayWithConstant.class, "array_with_constant"),
            scalar(ArrayZip.class, "array_zip"),
            scalar(ArraysOverlap.class, "arrays_overlap"),
            scalar(Ascii.class, "ascii"),
            scalar(Asin.class, "asin"),
            scalar(Atan.class, "atan"),
            scalar(Atan2.class, "atan2"),
            scalar(Bin.class, "bin"),
            scalar(BitCount.class, "bit_count"),
            scalar(BitLength.class, "bit_length"),
            scalar(BitmapAnd.class, "bitmap_and"),
            scalar(BitmapAndCount.class, "bitmap_and_count"),
            scalar(BitmapAndNot.class, "bitmap_and_not"),
            scalar(BitmapAndNotAlias.class, "bitmap_andnot"),
            scalar(BitmapAndNotCount.class, "bitmap_and_not_count"),
            scalar(BitmapAndNotCountAlias.class, "bitmap_andnot_count"),
            scalar(BitmapContains.class, "bitmap_contains"),
            scalar(BitmapCount.class, "bitmap_count"),
            scalar(BitmapEmpty.class, "bitmap_empty"),
            scalar(BitmapFromArray.class, "bitmap_from_array"),
            scalar(BitmapFromBase64.class, "bitmap_from_base64"),
            scalar(BitmapFromString.class, "bitmap_from_string"),
            scalar(BitmapHasAll.class, "bitmap_has_all"),
            scalar(BitmapHasAny.class, "bitmap_has_any"),
            scalar(BitmapHash.class, "bitmap_hash"),
            scalar(BitmapHash64.class, "bitmap_hash64"),
            scalar(BitmapMax.class, "bitmap_max"),
            scalar(BitmapMin.class, "bitmap_min"),
            scalar(BitmapNot.class, "bitmap_not"),
            scalar(BitmapOr.class, "bitmap_or"),
            scalar(BitmapOrCount.class, "bitmap_or_count"),
            scalar(BitmapRemove.class, "bitmap_remove"),
            scalar(BitmapSubsetInRange.class, "bitmap_subset_in_range"),
            scalar(BitmapSubsetLimit.class, "bitmap_subset_limit"),
            scalar(BitmapToArray.class, "bitmap_to_array"),
            scalar(BitmapToBase64.class, "bitmap_to_base64"),
            scalar(BitmapToString.class, "bitmap_to_string"),
            scalar(BitmapXor.class, "bitmap_xor"),
            scalar(BitmapXorCount.class, "bitmap_xor_count"),
            scalar(BitShiftLeft.class, "bit_shift_left"),
            scalar(BitShiftRight.class, "bit_shift_right"),
            scalar(Cardinality.class, "array_size", "cardinality", "size"),
            scalar(Cbrt.class, "cbrt"),
            scalar(Ceil.class, "ceil", "ceiling"),
            scalar(Char.class, "char"),
            scalar(CharacterLength.class, "char_length", "character_length"),
            scalar(Coalesce.class, "coalesce"),
            scalar(Concat.class, "concat"),
            scalar(ConcatWs.class, "concat_ws"),
            scalar(ConnectionId.class, "connection_id"),
            scalar(Conv.class, "conv"),
            scalar(ConvertTo.class, "convert_to"),
            scalar(ConvertTz.class, "convert_tz"),
            scalar(Cos.class, "cos"),
            scalar(Cosh.class, "cosh"),
            scalar(CosineDistance.class, "cosine_distance"),
            scalar(CountEqual.class, "countequal"),
            scalar(CreateMap.class, "map"),
            scalar(CreateStruct.class, "struct"),
            scalar(CreateNamedStruct.class, "named_struct"),
            scalar(CurrentCatalog.class, "current_catalog"),
            scalar(CurrentDate.class, "curdate", "current_date"),
            scalar(CurrentTime.class, "curtime", "current_time"),
            scalar(CurrentUser.class, "current_user"),
            scalar(Database.class, "database", "schema"),
            scalar(Date.class, "date"),
            scalar(DateDiff.class, "datediff"),
            scalar(DateFormat.class, "date_format"),
            scalar(DateTrunc.class, "date_trunc"),
            scalar(DateV2.class, "datev2"),
            scalar(DayCeil.class, "day_ceil"),
            scalar(DayFloor.class, "day_floor"),
            scalar(DayName.class, "dayname"),
            scalar(DayOfMonth.class, "day", "dayofmonth"),
            scalar(DayOfWeek.class, "dayofweek"),
            scalar(DayOfYear.class, "dayofyear"),
            scalar(DaysAdd.class, "days_add", "date_add", "adddate"),
            scalar(DaysDiff.class, "days_diff"),
            scalar(DaysSub.class, "days_sub", "date_sub", "subdate"),
            scalar(Dceil.class, "dceil"),
            scalar(Degrees.class, "degrees"),
            scalar(Dexp.class, "dexp"),
            scalar(Dfloor.class, "dfloor"),
            scalar(DigitalMasking.class, "digital_masking"),
            scalar(Dlog1.class, "dlog1"),
            scalar(Dlog10.class, "dlog10"),
            scalar(Domain.class, "domain"),
            scalar(DomainWithoutWww.class, "domain_without_www"),
            scalar(Dpow.class, "dpow"),
            scalar(Dround.class, "dround"),
            scalar(Dsqrt.class, "dsqrt"),
            scalar(E.class, "e"),
            scalar(ElementAt.class, "element_at"),
            scalar(Elt.class, "elt"),
            scalar(EndsWith.class, "ends_with"),
            scalar(EsQuery.class, "esquery"),
            scalar(Exp.class, "exp"),
            scalar(ExtractUrlParameter.class, "extract_url_parameter"),
            scalar(Field.class, "field"),
            scalar(FindInSet.class, "find_in_set"),
            scalar(Floor.class, "floor"),
            scalar(Fmod.class, "fmod"),
            scalar(Fpow.class, "fpow"),
            scalar(FromBase64.class, "from_base64"),
            scalar(FromDays.class, "from_days"),
            scalar(FromUnixtime.class, "from_unixtime"),
            scalar(G.class, "g"),
            scalar(GetJsonBigInt.class, "get_json_bigint"),
            scalar(GetJsonDouble.class, "get_json_double"),
            scalar(GetJsonInt.class, "get_json_int"),
            scalar(GetJsonString.class, "get_json_string"),
            scalar(Greatest.class, "greatest"),
            scalar(Grouping.class, "grouping"),
            scalar(GroupingId.class, "grouping_id"),
            scalar(Hex.class, "hex"),
            scalar(HllCardinality.class, "hll_cardinality"),
            scalar(HllEmpty.class, "hll_empty"),
            scalar(HllHash.class, "hll_hash"),
            scalar(Hour.class, "hour"),
            scalar(HourCeil.class, "hour_ceil"),
            scalar(HourFloor.class, "hour_floor"),
            scalar(HoursAdd.class, "hours_add"),
            scalar(HoursDiff.class, "hours_diff"),
            scalar(HoursSub.class, "hours_sub"),
            scalar(If.class, "if"),
            scalar(Ignore.class, "ignore"),
            scalar(Initcap.class, "initcap"),
            scalar(InnerProduct.class, "inner_product"),
            scalar(Instr.class, "instr"),
            scalar(Ipv4NumToString.class, "ipv4_num_to_string", "inet_ntoa"),
            scalar(Ipv4StringToNum.class, "ipv4_string_to_num"),
            scalar(Ipv4StringToNumOrDefault.class, "ipv4_string_to_num_or_default"),
            scalar(Ipv4StringToNumOrNull.class, "ipv4_string_to_num_or_null", "inet_aton"),
            scalar(Ipv6NumToString.class, "ipv6_num_to_string", "inet6_ntoa"),
            scalar(Ipv6StringToNum.class, "ipv6_string_to_num"),
            scalar(Ipv6StringToNumOrDefault.class, "ipv6_string_to_num_or_default"),
            scalar(Ipv6StringToNumOrNull.class, "ipv6_string_to_num_or_null", "inet6_aton"),
            scalar(IsIpv4Compat.class, "is_ipv4_compat"),
            scalar(IsIpv4Mapped.class, "is_ipv4_mapped"),
            scalar(IsIpv4String.class, "is_ipv4_string"),
            scalar(IsIpv6String.class, "is_ipv6_string"),
            scalar(IsIpAddressInRange.class, "is_ip_address_in_range"),
            scalar(Ipv4CIDRToRange.class, "ipv4_cidr_to_range"),
            scalar(Ipv6CIDRToRange.class, "ipv6_cidr_to_range"),
            scalar(ToIpv4.class, "to_ipv4"),
            scalar(ToIpv4OrDefault.class, "to_ipv4_or_default"),
            scalar(ToIpv4OrNull.class, "to_ipv4_or_null"),
            scalar(ToIpv6.class, "to_ipv6"),
            scalar(ToIpv6OrDefault.class, "to_ipv6_or_default"),
            scalar(ToIpv6OrNull.class, "to_ipv6_or_null"),
            scalar(JsonArray.class, "json_array"),
            scalar(JsonObject.class, "json_object"),
            scalar(JsonQuote.class, "json_quote"),
            scalar(JsonUnQuote.class, "json_unquote"),
            scalar(JsonExtract.class, "json_extract"),
            scalar(JsonInsert.class, "json_insert"),
            scalar(JsonReplace.class, "json_replace"),
            scalar(JsonSet.class, "json_set"),
            scalar(JsonbExistsPath.class, "json_exists_path"),
            scalar(JsonbExistsPath.class, "jsonb_exists_path"),
            scalar(JsonbExtract.class, "jsonb_extract"),
            scalar(JsonbExtractBigint.class, "json_extract_bigint"),
            scalar(JsonbExtractBigint.class, "jsonb_extract_bigint"),
            scalar(JsonbExtractLargeint.class, "json_extract_largeint"),
            scalar(JsonbExtractLargeint.class, "jsonb_extract_largeint"),
            scalar(JsonbExtractBool.class, "json_extract_bool"),
            scalar(JsonbExtractBool.class, "jsonb_extract_bool"),
            scalar(JsonbExtractDouble.class, "json_extract_double"),
            scalar(JsonbExtractDouble.class, "jsonb_extract_double"),
            scalar(JsonbExtractInt.class, "json_extract_int"),
            scalar(JsonbExtractInt.class, "jsonb_extract_int"),
            scalar(JsonbExtractIsnull.class, "json_extract_isnull"),
            scalar(JsonbExtractIsnull.class, "jsonb_extract_isnull"),
            scalar(JsonbExtractString.class, "json_extract_string"),
            scalar(JsonbExtractString.class, "jsonb_extract_string"),
            scalar(JsonbParse.class, "json_parse"),
            scalar(JsonbParse.class, "jsonb_parse"),
            scalar(JsonbParseErrorToInvalid.class, "json_parse_error_to_invalid"),
            scalar(JsonbParseErrorToInvalid.class, "jsonb_parse_error_to_invalid"),
            scalar(JsonbParseErrorToNull.class, "json_parse_error_to_null"),
            scalar(JsonbParseErrorToNull.class, "jsonb_parse_error_to_null"),
            scalar(JsonbParseErrorToValue.class, "json_parse_error_to_value"),
            scalar(JsonbParseErrorToValue.class, "jsonb_parse_error_to_value"),
            scalar(JsonbParseNotnull.class, "json_parse_notnull"),
            scalar(JsonbParseNotnull.class, "jsonb_parse_notnull"),
            scalar(JsonbParseNotnullErrorToInvalid.class, "json_parse_notnull_error_to_invalid"),
            scalar(JsonbParseNotnullErrorToInvalid.class, "jsonb_parse_notnull_error_to_invalid"),
            scalar(JsonbParseNotnullErrorToValue.class, "json_parse_notnull_error_to_value"),
            scalar(JsonbParseNotnullErrorToValue.class, "jsonb_parse_notnull_error_to_value"),
            scalar(JsonbParseNullable.class, "json_parse_nullable"),
            scalar(JsonbParseNullable.class, "jsonb_parse_nullable"),
            scalar(JsonbParseNullableErrorToInvalid.class, "json_parse_nullable_error_to_invalid"),
            scalar(JsonbParseNullableErrorToInvalid.class, "jsonb_parse_nullable_error_to_invalid"),
            scalar(JsonbParseNullableErrorToNull.class, "json_parse_nullable_error_to_null"),
            scalar(JsonbParseNullableErrorToNull.class, "jsonb_parse_nullable_error_to_null"),
            scalar(JsonbParseNullableErrorToValue.class, "json_parse_nullable_error_to_value"),
            scalar(JsonbParseNullableErrorToValue.class, "jsonb_parse_nullable_error_to_value"),
            scalar(JsonbValid.class, "json_valid"),
            scalar(JsonbValid.class, "jsonb_valid"),
            scalar(JsonbType.class, "json_type"),
            scalar(JsonbType.class, "jsonb_type"),
            scalar(JsonLength.class, "json_length"),
            scalar(JsonContains.class, "json_contains"),
            scalar(L1Distance.class, "l1_distance"),
            scalar(L2Distance.class, "l2_distance"),
            scalar(LastDay.class, "last_day"),
            scalar(Least.class, "least"),
            scalar(Left.class, "left"),
            scalar(Length.class, "length"),
            scalar(Like.class, "like"),
            scalar(Ln.class, "ln"),
            scalar(Locate.class, "locate"),
            scalar(Log.class, "log"),
            scalar(Log10.class, "log10"),
            scalar(Log2.class, "log2"),
            scalar(Lower.class, "lcase", "lower"),
            scalar(Lpad.class, "lpad"),
            scalar(Ltrim.class, "ltrim"),
            scalar(MakeDate.class, "makedate"),
            scalar(MapContainsKey.class, "map_contains_key"),
            scalar(MapContainsValue.class, "map_contains_value"),
            scalar(MapKeys.class, "map_keys"),
            scalar(MapSize.class, "map_size"),
            scalar(MapValues.class, "map_values"),
            scalar(Mask.class, "mask"),
            scalar(MaskFirstN.class, "mask_first_n"),
            scalar(MaskLastN.class, "mask_last_n"),
            scalar(Md5.class, "md5"),
            scalar(Md5Sum.class, "md5sum"),
            scalar(Microsecond.class, "microsecond"),
            scalar(MicroSecondsAdd.class, "microseconds_add"),
            scalar(MicroSecondsDiff.class, "microseconds_diff"),
            scalar(MicroSecondsSub.class, "microseconds_sub"),
            scalar(MilliSecondsAdd.class, "milliseconds_add"),
            scalar(MilliSecondsDiff.class, "milliseconds_diff"),
            scalar(MilliSecondsSub.class, "milliseconds_sub"),
            scalar(Minute.class, "minute"),
            scalar(MinuteCeil.class, "minute_ceil"),
            scalar(MinuteFloor.class, "minute_floor"),
            scalar(MinutesAdd.class, "minutes_add"),
            scalar(MinutesDiff.class, "minutes_diff"),
            scalar(MinutesSub.class, "minutes_sub"),
            scalar(MoneyFormat.class, "money_format"),
            scalar(Month.class, "month"),
            scalar(MonthCeil.class, "month_ceil"),
            scalar(MonthFloor.class, "month_floor"),
            scalar(MonthName.class, "monthname"),
            scalar(MonthsAdd.class, "months_add", "add_months"),
            scalar(MonthsDiff.class, "months_diff"),
            scalar(MonthsSub.class, "months_sub"),
            scalar(MultiMatchAny.class, "multi_match_any"),
            scalar(MultiSearchAllPositions.class, "multi_search_all_positions"),
            scalar(MurmurHash332.class, "murmur_hash3_32"),
            scalar(MurmurHash364.class, "murmur_hash3_64"),
            scalar(Negative.class, "negative"),
            scalar(NonNullable.class, "non_nullable"),
            scalar(NotNullOrEmpty.class, "not_null_or_empty"),
            scalar(Now.class, "now", "current_timestamp", "localtime", "localtimestamp"),
            scalar(Nullable.class, "nullable"),
            scalar(NullIf.class, "nullif"),
            scalar(NullOrEmpty.class, "null_or_empty"),
            scalar(Nvl.class, "ifnull", "nvl"),
            scalar(ParseUrl.class, "parse_url"),
            scalar(Password.class, "password"),
            scalar(Pi.class, "pi"),
            scalar(Pmod.class, "pmod"),
            scalar(Positive.class, "positive"),
            scalar(Pow.class, "pow"),
            scalar(Power.class, "power"),
            scalar(Protocol.class, "protocol"),
            scalar(QuantilePercent.class, "quantile_percent"),
            scalar(QuantileStateEmpty.class, "quantile_state_empty"),
            scalar(Quarter.class, "quarter"),
            scalar(Radians.class, "radians"),
            scalar(Random.class, "rand", "random"),
            scalar(Regexp.class, "regexp"),
            scalar(RegexpExtract.class, "regexp_extract"),
            scalar(RegexpExtractAll.class, "regexp_extract_all"),
            scalar(RegexpReplace.class, "regexp_replace"),
            scalar(RegexpReplaceOne.class, "regexp_replace_one"),
            scalar(Repeat.class, "repeat"),
            scalar(Replace.class, "replace"),
            scalar(Reverse.class, "reverse"),
            scalar(Right.class, "right"),
            scalar(Round.class, "round"),
            scalar(RoundBankers.class, "round_bankers"),
            scalar(Rpad.class, "rpad"),
            scalar(Rtrim.class, "rtrim"),
            scalar(Second.class, "second"),
            scalar(SecondCeil.class, "second_ceil"),
            scalar(SecondFloor.class, "second_floor"),
            scalar(SecondsAdd.class, "seconds_add"),
            scalar(SecondsDiff.class, "seconds_diff"),
            scalar(SecondsSub.class, "seconds_sub"),
            scalar(SecToTime.class, "sec_to_time"),
            scalar(FromMicrosecond.class, "from_microsecond"),
            scalar(FromMillisecond.class, "from_millisecond"),
            scalar(FromSecond.class, "from_second"),
            scalar(SecondTimestamp.class, "second_timestamp"),
            scalar(MilliSecondTimestamp.class, "millisecond_timestamp"),
            scalar(MicroSecondTimestamp.class, "microsecond_timestamp"),
            scalar(RandomBytes.class, "random_bytes"),
            scalar(Sha1.class, "sha1", "sha"),
            scalar(Sha2.class, "sha2"),
            scalar(Sign.class, "sign"),
            scalar(Sin.class, "sin"),
            scalar(Sleep.class, "sleep"),
            scalar(StructElement.class, "struct_element"),
            scalar(Sm3.class, "sm3"),
            scalar(Sm3sum.class, "sm3sum"),
            scalar(Sm4Decrypt.class, "sm4_decrypt"),
            scalar(Sm4DecryptV2.class, "sm4_decrypt_v2"),
            scalar(Sm4Encrypt.class, "sm4_encrypt"),
            scalar(Sm4EncryptV2.class, "sm4_encrypt_v2"),
            scalar(Space.class, "space"),
            scalar(SplitByChar.class, "split_by_char"),
            scalar(SplitByString.class, "split_by_string"),
            scalar(SplitPart.class, "split_part"),
            scalar(Sqrt.class, "sqrt"),
            scalar(StAsBinary.class, "st_asbinary"),
            scalar(StAstext.class, "st_astext"),
            scalar(StAswkt.class, "st_aswkt"),
            scalar(StCircle.class, "st_circle"),
            scalar(StContains.class, "st_contains"),
            scalar(StDistanceSphere.class, "st_distance_sphere"),
            scalar(StAngleSphere.class, "st_angle_sphere"),
            scalar(StAngle.class, "st_angle"),
            scalar(StAzimuth.class, "st_azimuth"),
            scalar(StAreaSquareMeters.class, "st_area_square_meters"),
            scalar(StAreaSquareKm.class, "st_area_square_km"),
            scalar(StGeometryfromtext.class, "st_geometryfromtext"),
            scalar(StGeometryFromWKB.class, "st_geometryfromwkb"),
            scalar(StGeomfromtext.class, "st_geomfromtext"),
            scalar(StGeomFromWKB.class, "st_geomfromwkb"),
            scalar(StLinefromtext.class, "st_linefromtext"),
            scalar(StLinestringfromtext.class, "st_linestringfromtext"),
            scalar(StPoint.class, "st_point"),
            scalar(StPolyfromtext.class, "st_polyfromtext"),
            scalar(StPolygon.class, "st_polygon"),
            scalar(StPolygonfromtext.class, "st_polygonfromtext"),
            scalar(StX.class, "st_x"),
            scalar(StY.class, "st_y"),
            scalar(StartsWith.class, "starts_with"),
            scalar(StrLeft.class, "strleft"),
            scalar(StrRight.class, "strright"),
            scalar(StrToDate.class, "str_to_date"),
            scalar(SubBitmap.class, "sub_bitmap"),
            scalar(SubReplace.class, "sub_replace"),
            scalar(Substring.class, "substr", "substring"),
            scalar(SubstringIndex.class, "substring_index"),
            scalar(Tan.class, "tan"),
            scalar(Tanh.class, "tanh"),
            scalar(TimeDiff.class, "timediff"),
            scalar(TimeToSec.class, "time_to_sec"),
            scalar(Timestamp.class, "timestamp"),
            scalar(ToBase64.class, "to_base64"),
            scalar(ToBitmap.class, "to_bitmap"),
            scalar(ToBitmapWithCheck.class, "to_bitmap_with_check"),
            scalar(ToDate.class, "to_date"),
            scalar(ToDateV2.class, "to_datev2"),
            scalar(ToDays.class, "to_days"),
            scalar(Tokenize.class, "tokenize"),
            scalar(ToMonday.class, "to_monday"),
            scalar(ToQuantileState.class, "to_quantile_state"),
            scalar(Trim.class, "trim"),
            scalar(Truncate.class, "truncate"),
            scalar(Unhex.class, "unhex"),
            scalar(UnixTimestamp.class, "unix_timestamp"),
            scalar(Upper.class, "ucase", "upper"),
            scalar(UrlDecode.class, "url_decode"),
            scalar(User.class, "user"),
            scalar(UtcTimestamp.class, "utc_timestamp"),
            scalar(Uuid.class, "uuid"),
            scalar(UuidNumeric.class, "uuid_numeric"),
            scalar(Version.class, "version"),
            scalar(Week.class, "week"),
            scalar(WeekCeil.class, "week_ceil"),
            scalar(WeekFloor.class, "week_floor"),
            scalar(WeekOfYear.class, "weekofyear"),
            scalar(Weekday.class, "weekday"),
            scalar(WeeksAdd.class, "weeks_add"),
            scalar(WeeksDiff.class, "weeks_diff"),
            scalar(WeeksSub.class, "weeks_sub"),
            scalar(WidthBucket.class, "width_bucket"),
            scalar(XxHash32.class, "xxhash_32"),
            scalar(XxHash64.class, "xxhash_64"),
            scalar(Year.class, "year"),
            scalar(YearCeil.class, "year_ceil"),
            scalar(YearFloor.class, "year_floor"),
            scalar(YearWeek.class, "yearweek"),
            scalar(YearsAdd.class, "years_add"),
            scalar(YearsDiff.class, "years_diff"),
            scalar(YearsSub.class, "years_sub")
    );

    public static final BuiltinScalarFunctions INSTANCE = new BuiltinScalarFunctions();

    // Note: Do not add any code here!
    private BuiltinScalarFunctions() {}
}
