#include "test.h"

#include <CLucene.h>
#include "CLucene/analysis/standard95/StandardAnalyzer.h"
#include "CLucene/search/TermQuery.h"
#include "CLucene/store/Directory.h"
#include "CLucene/store/FSDirectory.h"

#include "roaring/roaring.hh"

static std::vector<std::string> datas = {
  "{\"@timestamp\": 893964617, \"clientip\":\"40.135.0.0\", \"request\": \"GET /images/hm_bg.jpg HTTP/1.0\", \"status\": 200, \"size\": 24736}",
  "{\"@timestamp\": 893964653, \"clientip\":\"232.0.0.0\", \"request\": \"GET /images/hm_bg.jpg HTTP/1.0\", \"status\": 200, \"size\": 24736}",
  "{\"@timestamp\": 893964672, \"clientip\":\"26.1.0.0\", \"request\": \"GET /images/hm_bg.jpg HTTP/1.0\", \"status\": 200, \"size\": 24736}",
  "{\"@timestamp\": 893964679, \"clientip\":\"247.37.0.0\", \"request\": \"GET /french/splash_inet.html HTTP/1.0\", \"status\": 200, \"size\": 3781}",
  "{\"@timestamp\": 893964682, \"clientip\":\"247.37.0.0\", \"request\": \"GET /images/hm_nbg.jpg HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893964687, \"clientip\":\"252.0.0.0\", \"request\": \"GET /images/hm_bg.jpg HTTP/1.0\", \"status\": 200, \"size\": 24736}",
  "{\"@timestamp\": 893964689, \"clientip\":\"247.37.0.0\", \"request\": \"GET /images/hm_brdl.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893964689, \"clientip\":\"247.37.0.0\", \"request\": \"GET /images/hm_arw.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893964692, \"clientip\":\"247.37.0.0\", \"request\": \"GET /images/nav_bg_top.gif HTTP/1.0\", \"status\": 200, \"size\": 929}",
  "{\"@timestamp\": 893964703, \"clientip\":\"247.37.0.0\", \"request\": \"GET /french/images/nav_venue_off.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893964704, \"clientip\":\"247.37.0.0\", \"request\": \"GET /french/images/nav_hosts_off.gif HTTP/1.0\", \"status\": 200, \"size\": 1139}",
  "{\"@timestamp\": 893964712, \"clientip\":\"2.1.0.0\", \"request\": \"GET /images/hm_bg.jpg HTTP/1.0\", \"status\": 200, \"size\": 24736}",
  "{\"@timestamp\": 893964712, \"clientip\":\"247.37.0.0\", \"request\": \"GET /french/tickets/body.html HTTP/1.0\", \"status\": 200, \"size\": 3029}",
  "{\"@timestamp\": 893964726, \"clientip\":\"120.1.0.0\", \"request\": \"GET /images/hm_bg.jpg HTTP/1.0\", \"status\": 200, \"size\": 24736}",
  "{\"@timestamp\": 893964736, \"clientip\":\"247.37.0.0\", \"request\": \"GET /french/tickets/images/ticket_hm_header.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893964736, \"clientip\":\"247.37.0.0\", \"request\": \"GET /french/tickets/images/ticket_hm_nav.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893964737, \"clientip\":\"247.37.0.0\", \"request\": \"GET /images/arw_lk.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893964750, \"clientip\":\"247.37.0.0\", \"request\": \"GET /french/tickets/tck_0804.htm HTTP/1.0\", \"status\": 200, \"size\": 14521}",
  "{\"@timestamp\": 893964753, \"clientip\":\"247.37.0.0\", \"request\": \"GET /french/tickets/images/ticket_quest_bg2.jpg HTTP/1.0\", \"status\": 200, \"size\": 11324}",
  "{\"@timestamp\": 893964755, \"clientip\":\"126.1.0.0\", \"request\": \"GET /images/hm_bg.jpg HTTP/1.0\", \"status\": 200, \"size\": 24736}",
  "{\"@timestamp\": 893964758, \"clientip\":\"247.37.0.0\", \"request\": \"GET /french/tickets/images/ticket_header.gif HTTP/1.0\", \"status\": 200, \"size\": 671}",
  "{\"@timestamp\": 893964758, \"clientip\":\"247.37.0.0\", \"request\": \"GET /french/tickets/images/ticket_bu_abroad2.gif HTTP/1.0\", \"status\": 200, \"size\": 1512}",
  "{\"@timestamp\": 893964758, \"clientip\":\"247.37.0.0\", \"request\": \"GET /french/tickets/images/ticket_bu_infrance2.gif HTTP/1.0\", \"status\": 200, \"size\": 1136}",
  "{\"@timestamp\": 893964758, \"clientip\":\"247.37.0.0\", \"request\": \"GET /french/tickets/images/hm_f98_top.gif HTTP/1.0\", \"status\": 200, \"size\": 1647}",
  "{\"@timestamp\": 893964758, \"clientip\":\"247.37.0.0\", \"request\": \"GET /french/tickets/images/ticket_bu_quest2.gif HTTP/1.0\", \"status\": 200, \"size\": 1271}",
  "{\"@timestamp\": 893964772, \"clientip\":\"247.37.0.0\", \"request\": \"GET /french/news/3004bres.htm HTTP/1.0\", \"status\": 200, \"size\": 5933}",
  "{\"@timestamp\": 893964778, \"clientip\":\"247.37.0.0\", \"request\": \"GET /french/images/hm_f98_top.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893964779, \"clientip\":\"247.37.0.0\", \"request\": \"GET /images/bord_d.gif HTTP/1.0\", \"status\": 200, \"size\": 231}",
  "{\"@timestamp\": 893964779, \"clientip\":\"247.37.0.0\", \"request\": \"GET /images/bord_g.gif HTTP/1.0\", \"status\": 200, \"size\": 231}",
  "{\"@timestamp\": 893964785, \"clientip\":\"13.1.0.0\", \"request\": \"GET /images/hm_bg.jpg HTTP/1.0\", \"status\": 200, \"size\": 24736}",
  "{\"@timestamp\": 893964789, \"clientip\":\"138.2.0.0\", \"request\": \"GET /images/hm_bg.jpg HTTP/1.0\", \"status\": 200, \"size\": 24736}",
  "{\"@timestamp\": 893964800, \"clientip\":\"28.1.0.0\", \"request\": \"GET /images/hm_bg.jpg HTTP/1.0\", \"status\": 200, \"size\": 24736}",
  "{\"@timestamp\": 893964809, \"clientip\":\"31.1.0.0\", \"request\": \"GET /images/hm_bg.jpg HTTP/1.0\", \"status\": 200, \"size\": 24736}",
  "{\"@timestamp\": 893964812, \"clientip\":\"55.0.0.0\", \"request\": \"GET /french/index.html HTTP/1.0\", \"status\": 200, \"size\": 985}",
  "{\"@timestamp\": 893964815, \"clientip\":\"29.1.0.0\", \"request\": \"GET /images/hm_bg.jpg HTTP/1.0\", \"status\": 200, \"size\": 24736}",
  "{\"@timestamp\": 893964825, \"clientip\":\"92.1.0.0\", \"request\": \"GET /images/hm_bg.jpg HTTP/1.0\", \"status\": 200, \"size\": 24736}",
  "{\"@timestamp\": 893964841, \"clientip\":\"134.1.0.0\", \"request\": \"GET /images/hm_bg.jpg HTTP/1.0\", \"status\": 200, \"size\": 24736}",
  "{\"@timestamp\": 893964844, \"clientip\":\"55.0.0.0\", \"request\": \"GET /french/index.html HTTP/1.0\", \"status\": 200, \"size\": 985}",
  "{\"@timestamp\": 893964864, \"clientip\":\"137.2.0.0\", \"request\": \"GET /images/hm_bg.jpg HTTP/1.0\", \"status\": 200, \"size\": 24736}",
  "{\"@timestamp\": 893964932, \"clientip\":\"167.2.0.0\", \"request\": \"GET /images/hm_bg.jpg HTTP/1.0\", \"status\": 200, \"size\": 24736}",
  "{\"@timestamp\": 893964936, \"clientip\":\"174.2.0.0\", \"request\": \"GET /images/hm_bg.jpg HTTP/1.0\", \"status\": 200, \"size\": 24736}",
  "{\"@timestamp\": 893964961, \"clientip\":\"97.1.0.0\", \"request\": \"GET /images/hm_bg.jpg HTTP/1.0\", \"status\": 200, \"size\": 24736}",
  "{\"@timestamp\": 893964973, \"clientip\":\"174.1.0.0\", \"request\": \"GET /images/hm_bg.jpg HTTP/1.0\", \"status\": 200, \"size\": 24736}",
  "{\"@timestamp\": 893965016, \"clientip\":\"121.1.0.0\", \"request\": \"GET /images/hm_bg.jpg HTTP/1.0\", \"status\": 200, \"size\": 24736}",
  "{\"@timestamp\": 893965036, \"clientip\":\"2.2.0.0\", \"request\": \"GET /images/hm_bg.jpg HTTP/1.0\", \"status\": 200, \"size\": 24736}",
  "{\"@timestamp\": 893965050, \"clientip\":\"91.1.0.0\", \"request\": \"GET /images/hm_bg.jpg HTTP/1.0\", \"status\": 200, \"size\": 24736}",
  "{\"@timestamp\": 893965059, \"clientip\":\"47.2.0.0\", \"request\": \"GET /images/hm_bg.jpg HTTP/1.0\", \"status\": 200, \"size\": 24736}",
  "{\"@timestamp\": 893965070, \"clientip\":\"142.1.0.0\", \"request\": \"GET /images/hm_bg.jpg HTTP/1.0\", \"status\": 200, \"size\": 24736}",
  "{\"@timestamp\": 893965084, \"clientip\":\"104.0.0.0\", \"request\": \"GET /images/hm_bg.jpg HTTP/1.0\", \"status\": 200, \"size\": 24736}",
  "{\"@timestamp\": 893965106, \"clientip\":\"40.135.0.0\", \"request\": \"GET /images/hm_bg.jpg HTTP/1.0\", \"status\": 200, \"size\": 24736}",
  "{\"@timestamp\": 893965115, \"clientip\":\"109.1.0.0\", \"request\": \"GET /images/hm_bg.jpg HTTP/1.0\", \"status\": 200, \"size\": 24736}",
  "{\"@timestamp\": 893965123, \"clientip\":\"184.0.0.0\", \"request\": \"GET /images/hm_bg.jpg HTTP/1.0\", \"status\": 200, \"size\": 24736}",
  "{\"@timestamp\": 893965139, \"clientip\":\"55.0.0.0\", \"request\": \"GET /french/index.html HTTP/1.0\", \"status\": 200, \"size\": 985}",
  "{\"@timestamp\": 893965149, \"clientip\":\"56.0.0.0\", \"request\": \"GET /images/hm_bg.jpg HTTP/1.0\", \"status\": 200, \"size\": 24736}",
  "{\"@timestamp\": 893965150, \"clientip\":\"161.0.0.0\", \"request\": \"GET /images/hm_bg.jpg HTTP/1.0\", \"status\": 200, \"size\": 24736}",
  "{\"@timestamp\": 893965150, \"clientip\":\"237.1.0.0\", \"request\": \"GET /images/hm_bg.jpg HTTP/1.0\", \"status\": 200, \"size\": 24736}",
  "{\"@timestamp\": 893965154, \"clientip\":\"41.135.0.0\", \"request\": \"GET /images/hm_bg.jpg HTTP/1.0\", \"status\": 200, \"size\": 24736}",
  "{\"@timestamp\": 893965162, \"clientip\":\"131.1.0.0\", \"request\": \"GET /images/hm_bg.jpg HTTP/1.0\", \"status\": 200, \"size\": 24736}",
  "{\"@timestamp\": 893965172, \"clientip\":\"55.0.0.0\", \"request\": \"GET /french/index.html HTTP/1.0\", \"status\": 200, \"size\": 985}",
  "{\"@timestamp\": 893965182, \"clientip\":\"42.135.0.0\", \"request\": \"GET /fth.htm HTTP/1.1\", \"status\": 200, \"size\": 190}",
  "{\"@timestamp\": 893965193, \"clientip\":\"180.0.0.0\", \"request\": \"GET /images/hm_bg.jpg HTTP/1.0\", \"status\": 200, \"size\": 24736}",
  "{\"@timestamp\": 893965198, \"clientip\":\"176.0.0.0\", \"request\": \"GET /images/hm_bg.jpg HTTP/1.0\", \"status\": 200, \"size\": 24736}",
  "{\"@timestamp\": 893965200, \"clientip\":\"192.1.0.0\", \"request\": \"GET /images/hm_bg.jpg HTTP/1.0\", \"status\": 200, \"size\": 24736}",
  "{\"@timestamp\": 893965278, \"clientip\":\"4.1.0.0\", \"request\": \"GET /images/hm_bg.jpg HTTP/1.0\", \"status\": 200, \"size\": 24736}",
  "{\"@timestamp\": 893965293, \"clientip\":\"76.6.0.0\", \"request\": \"GET /images/teams_hm_bg.jpg HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893965300, \"clientip\":\"235.0.0.0\", \"request\": \"GET /images/hm_bg.jpg HTTP/1.0\", \"status\": 200, \"size\": 24736}",
  "{\"@timestamp\": 893965310, \"clientip\":\"183.1.0.0\", \"request\": \"GET /images/hm_bg.jpg HTTP/1.0\", \"status\": 200, \"size\": 24736}",
  "{\"@timestamp\": 893965318, \"clientip\":\"248.0.0.0\", \"request\": \"GET /images/hm_bg.jpg HTTP/1.0\", \"status\": 200, \"size\": 24736}",
  "{\"@timestamp\": 893965322, \"clientip\":\"249.0.0.0\", \"request\": \"GET /images/hm_bg.jpg HTTP/1.0\", \"status\": 200, \"size\": 24736}",
  "{\"@timestamp\": 893965352, \"clientip\":\"218.0.0.0\", \"request\": \"GET /images/hm_bg.jpg HTTP/1.0\", \"status\": 200, \"size\": 24736}",
  "{\"@timestamp\": 893965382, \"clientip\":\"128.0.0.0\", \"request\": \"GET /images/hm_bg.jpg HTTP/1.0\", \"status\": 200, \"size\": 24736}",
  "{\"@timestamp\": 893965405, \"clientip\":\"139.0.0.0\", \"request\": \"GET /images/hm_bg.jpg HTTP/1.0\", \"status\": 200, \"size\": 24736}",
  "{\"@timestamp\": 893965412, \"clientip\":\"55.0.0.0\", \"request\": \"GET /french/index.html HTTP/1.0\", \"status\": 200, \"size\": 985}",
  "{\"@timestamp\": 893965424, \"clientip\":\"249.1.0.0\", \"request\": \"GET /images/hm_bg.jpg HTTP/1.0\", \"status\": 200, \"size\": 24736}",
  "{\"@timestamp\": 893965449, \"clientip\":\"55.0.0.0\", \"request\": \"GET /french/index.html HTTP/1.0\", \"status\": 200, \"size\": 985}",
  "{\"@timestamp\": 893965464, \"clientip\":\"221.0.0.0\", \"request\": \"GET /images/hm_bg.jpg HTTP/1.0\", \"status\": 200, \"size\": 24736}",
  "{\"@timestamp\": 893965467, \"clientip\":\"175.0.0.0\", \"request\": \"GET /images/hm_bg.jpg HTTP/1.0\", \"status\": 200, \"size\": 24736}",
  "{\"@timestamp\": 893965479, \"clientip\":\"43.135.0.0\", \"request\": \"GET /images/hm_bg.jpg HTTP/1.0\", \"status\": 200, \"size\": 24736}",
  "{\"@timestamp\": 893965504, \"clientip\":\"201.0.0.0\", \"request\": \"GET /images/hm_bg.jpg HTTP/1.0\", \"status\": 200, \"size\": 24736}",
  "{\"@timestamp\": 893965518, \"clientip\":\"17.1.0.0\", \"request\": \"GET /images/hm_bg.jpg HTTP/1.0\", \"status\": 200, \"size\": 24736}",
  "{\"@timestamp\": 893965550, \"clientip\":\"138.2.0.0\", \"request\": \"GET /images/hm_bg.jpg HTTP/1.0\", \"status\": 200, \"size\": 24736}",
  "{\"@timestamp\": 893965554, \"clientip\":\"232.0.0.0\", \"request\": \"GET /images/hm_bg.jpg HTTP/1.0\", \"status\": 200, \"size\": 24736}",
  "{\"@timestamp\": 893965578, \"clientip\":\"76.6.0.0\", \"request\": \"GET /images/nantes.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893965585, \"clientip\":\"252.0.0.0\", \"request\": \"GET /images/hm_bg.jpg HTTP/1.0\", \"status\": 200, \"size\": 24736}",
  "{\"@timestamp\": 893965598, \"clientip\":\"120.1.0.0\", \"request\": \"GET /images/hm_bg.jpg HTTP/1.0\", \"status\": 200, \"size\": 24736}",
  "{\"@timestamp\": 893965616, \"clientip\":\"2.1.0.0\", \"request\": \"GET /images/hm_bg.jpg HTTP/1.0\", \"status\": 200, \"size\": 24736}",
  "{\"@timestamp\": 893965622, \"clientip\":\"44.135.0.0\", \"request\": \"GET /french/index.html HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893965626, \"clientip\":\"44.135.0.0\", \"request\": \"GET /french/nav_inet.html HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893965626, \"clientip\":\"44.135.0.0\", \"request\": \"GET /french/splash_inet.html HTTP/1.0\", \"status\": 200, \"size\": 3781}",
  "{\"@timestamp\": 893965626, \"clientip\":\"44.135.0.0\", \"request\": \"GET /french/nav_top_inet.html HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893965627, \"clientip\":\"44.135.0.0\", \"request\": \"GET /images/nav_bg_top.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893965628, \"clientip\":\"44.135.0.0\", \"request\": \"GET /images/hm_nbg.jpg HTTP/1.0\", \"status\": 200, \"size\": 33665}",
  "{\"@timestamp\": 893965631, \"clientip\":\"44.135.0.0\", \"request\": \"GET /images/logo_cfo.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893965632, \"clientip\":\"44.135.0.0\", \"request\": \"GET /french/ProScroll.class HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893965634, \"clientip\":\"44.135.0.0\", \"request\": \"GET /images/nav_bg_bottom.jpg HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893965634, \"clientip\":\"44.135.0.0\", \"request\": \"GET /french/images/nav_news_off.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893965634, \"clientip\":\"44.135.0.0\", \"request\": \"GET /french/images/nav_comp_off.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893965638, \"clientip\":\"44.135.0.0\", \"request\": \"GET /french/images/nav_venue_off.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893965648, \"clientip\":\"126.1.0.0\", \"request\": \"GET /images/hm_bg.jpg HTTP/1.0\", \"status\": 200, \"size\": 24736}",
  "{\"@timestamp\": 893965649, \"clientip\":\"44.135.0.0\", \"request\": \"GET /french/images/nav_tickets_off.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893965651, \"clientip\":\"44.135.0.0\", \"request\": \"GET /french/news/3004bres.htm HTTP/1.0\", \"status\": 200, \"size\": 5933}",
  "{\"@timestamp\": 893965651, \"clientip\":\"44.135.0.0\", \"request\": \"GET /french/images/nav_field_off.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893965652, \"clientip\":\"44.135.0.0\", \"request\": \"GET /french/images/nav_history_off.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893965655, \"clientip\":\"44.135.0.0\", \"request\": \"GET /images/backnews.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893965658, \"clientip\":\"44.135.0.0\", \"request\": \"GET /french/images/nav_team_off.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893965658, \"clientip\":\"44.135.0.0\", \"request\": \"GET /french/images/nav_store_off.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893965658, \"clientip\":\"44.135.0.0\", \"request\": \"GET /french/images/nav_home_off.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893965659, \"clientip\":\"44.135.0.0\", \"request\": \"GET /french/images/nav_sitemap_off.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893965659, \"clientip\":\"44.135.0.0\", \"request\": \"GET /french/images/fpnewstop.gif HTTP/1.0\", \"status\": 200, \"size\": 1317}",
  "{\"@timestamp\": 893965660, \"clientip\":\"44.135.0.0\", \"request\": \"GET /french/images/hm_f98_top.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893965661, \"clientip\":\"44.135.0.0\", \"request\": \"GET /french/images/news_btn_letter_off.gif HTTP/1.0\", \"status\": 200, \"size\": 871}",
  "{\"@timestamp\": 893965661, \"clientip\":\"44.135.0.0\", \"request\": \"GET /french/images/news_btn_press_off.gif HTTP/1.0\", \"status\": 200, \"size\": 1795}",
  "{\"@timestamp\": 893965662, \"clientip\":\"44.135.0.0\", \"request\": \"GET /french/images/news_btn_kits_off.gif HTTP/1.0\", \"status\": 200, \"size\": 965}",
  "{\"@timestamp\": 893965662, \"clientip\":\"44.135.0.0\", \"request\": \"GET /french/images/nav_hosts_off.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893965662, \"clientip\":\"44.135.0.0\", \"request\": \"GET /french/images/nav_logo_sponsors.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893965663, \"clientip\":\"44.135.0.0\", \"request\": \"GET /images/bord_d.gif HTTP/1.0\", \"status\": 200, \"size\": 231}",
  "{\"@timestamp\": 893965664, \"clientip\":\"44.135.0.0\", \"request\": \"GET /images/bord_g.gif HTTP/1.0\", \"status\": 200, \"size\": 231}",
  "{\"@timestamp\": 893965668, \"clientip\":\"26.1.0.0\", \"request\": \"GET /images/hm_bg.jpg HTTP/1.0\", \"status\": 200, \"size\": 24736}",
  "{\"@timestamp\": 893965684, \"clientip\":\"13.1.0.0\", \"request\": \"GET /images/hm_bg.jpg HTTP/1.0\", \"status\": 200, \"size\": 24736}",
  "{\"@timestamp\": 893965700, \"clientip\":\"28.1.0.0\", \"request\": \"GET /images/hm_bg.jpg HTTP/1.0\", \"status\": 200, \"size\": 24736}",
  "{\"@timestamp\": 893965700, \"clientip\":\"44.135.0.0\", \"request\": \"GET /french/news/newsprr.htm HTTP/1.0\", \"status\": 200, \"size\": 28486}",
  "{\"@timestamp\": 893965705, \"clientip\":\"44.135.0.0\", \"request\": \"GET /french/images/space.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893965706, \"clientip\":\"44.135.0.0\", \"request\": \"GET /images/space.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893965706, \"clientip\":\"44.135.0.0\", \"request\": \"GET /french/images/news_btn_press_on.gif HTTP/1.0\", \"status\": 200, \"size\": 1757}",
  "{\"@timestamp\": 893965706, \"clientip\":\"44.135.0.0\", \"request\": \"GET /images/hm_f98_top.gif HTTP/1.0\", \"status\": 200, \"size\": 915}",
  "{\"@timestamp\": 893965708, \"clientip\":\"44.135.0.0\", \"request\": \"GET /french/images/news_hd_press.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893965708, \"clientip\":\"44.135.0.0\", \"request\": \"GET /images/news_arrow.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893965712, \"clientip\":\"55.0.0.0\", \"request\": \"GET /french/index.html HTTP/1.0\", \"status\": 200, \"size\": 985}",
  "{\"@timestamp\": 893965724, \"clientip\":\"31.1.0.0\", \"request\": \"GET /images/hm_bg.jpg HTTP/1.0\", \"status\": 200, \"size\": 24736}",
  "{\"@timestamp\": 893965727, \"clientip\":\"92.1.0.0\", \"request\": \"GET /images/hm_bg.jpg HTTP/1.0\", \"status\": 200, \"size\": 24736}",
  "{\"@timestamp\": 893965727, \"clientip\":\"134.1.0.0\", \"request\": \"GET /images/hm_bg.jpg HTTP/1.0\", \"status\": 200, \"size\": 24736}",
  "{\"@timestamp\": 893965731, \"clientip\":\"29.1.0.0\", \"request\": \"GET /images/hm_bg.jpg HTTP/1.0\", \"status\": 200, \"size\": 24736}",
  "{\"@timestamp\": 893965738, \"clientip\":\"55.0.0.0\", \"request\": \"GET /french/index.html HTTP/1.0\", \"status\": 200, \"size\": 985}",
  "{\"@timestamp\": 893965753, \"clientip\":\"237.1.0.0\", \"request\": \"GET /images/hm_bg.jpg HTTP/1.0\", \"status\": 200, \"size\": 24736}",
  "{\"@timestamp\": 893965796, \"clientip\":\"42.135.0.0\", \"request\": \"GET /fth.htm HTTP/1.1\", \"status\": 200, \"size\": 190}",
  "{\"@timestamp\": 893965849, \"clientip\":\"174.2.0.0\", \"request\": \"GET /images/hm_bg.jpg HTTP/1.0\", \"status\": 200, \"size\": 24736}",
  "{\"@timestamp\": 893965856, \"clientip\":\"167.2.0.0\", \"request\": \"GET /images/hm_bg.jpg HTTP/1.0\", \"status\": 200, \"size\": 24736}",
  "{\"@timestamp\": 893965865, \"clientip\":\"137.2.0.0\", \"request\": \"GET /images/hm_bg.jpg HTTP/1.0\", \"status\": 200, \"size\": 24736}",
  "{\"@timestamp\": 893965882, \"clientip\":\"40.135.0.0\", \"request\": \"GET /images/hm_bg.jpg HTTP/1.0\", \"status\": 200, \"size\": 24736}",
  "{\"@timestamp\": 893965883, \"clientip\":\"97.1.0.0\", \"request\": \"GET /images/hm_bg.jpg HTTP/1.0\", \"status\": 200, \"size\": 24736}",
  "{\"@timestamp\": 893965896, \"clientip\":\"45.135.0.0\", \"request\": \"GET /french/history/past_cups/argentina78.html HTTP/1.0\", \"status\": 200, \"size\": 20916}",
  "{\"@timestamp\": 893965899, \"clientip\":\"45.135.0.0\", \"request\": \"GET /french/history/images/history_hm_header.gif HTTP/1.0\", \"status\": 200, \"size\": 1034}",
  "{\"@timestamp\": 893965899, \"clientip\":\"45.135.0.0\", \"request\": \"GET /french/history/images/football.GIF HTTP/1.0\", \"status\": 200, \"size\": 1452}",
  "{\"@timestamp\": 893965899, \"clientip\":\"45.135.0.0\", \"request\": \"GET /french/history/images/france98b.GIF HTTP/1.0\", \"status\": 200, \"size\": 915}",
  "{\"@timestamp\": 893965901, \"clientip\":\"45.135.0.0\", \"request\": \"GET /french/history/images/infrance.GIF HTTP/1.0\", \"status\": 200, \"size\": 1017}",
  "{\"@timestamp\": 893965901, \"clientip\":\"45.135.0.0\", \"request\": \"GET /french/history/images/reading.GIF HTTP/1.0\", \"status\": 200, \"size\": 1094}",
  "{\"@timestamp\": 893965901, \"clientip\":\"45.135.0.0\", \"request\": \"GET /french/history/past_cups/images/past_bu_30_off.gif HTTP/1.0\", \"status\": 200, \"size\": 406}",
  "{\"@timestamp\": 893965902, \"clientip\":\"45.135.0.0\", \"request\": \"GET /french/history/past_cups/images/past_bu_38_off.gif HTTP/1.0\", \"status\": 200, \"size\": 436}",
  "{\"@timestamp\": 893965903, \"clientip\":\"45.135.0.0\", \"request\": \"GET /french/history/past_cups/images/past_bu_54_off.gif HTTP/1.0\", \"status\": 200, \"size\": 403}",
  "{\"@timestamp\": 893965904, \"clientip\":\"45.135.0.0\", \"request\": \"GET /french/history/past_cups/images/past_bu_62_off.gif HTTP/1.0\", \"status\": 200, \"size\": 437}",
  "{\"@timestamp\": 893965905, \"clientip\":\"45.135.0.0\", \"request\": \"GET /french/history/past_cups/images/past_bu_70_off.gif HTTP/1.0\", \"status\": 200, \"size\": 409}",
  "{\"@timestamp\": 893965905, \"clientip\":\"45.135.0.0\", \"request\": \"GET /french/history/past_cups/images/past_bu_78_on.gif HTTP/1.0\", \"status\": 200, \"size\": 501}",
  "{\"@timestamp\": 893965906, \"clientip\":\"45.135.0.0\", \"request\": \"GET /french/history/past_cups/images/past_bu_94_off.gif HTTP/1.0\", \"status\": 200, \"size\": 432}",
  "{\"@timestamp\": 893965906, \"clientip\":\"45.135.0.0\", \"request\": \"GET /french/history/past_cups/images/past_bu_86_off.gif HTTP/1.0\", \"status\": 200, \"size\": 409}",
  "{\"@timestamp\": 893965906, \"clientip\":\"45.135.0.0\", \"request\": \"GET /french/history/past_cups/images/posters/argentina78.gif HTTP/1.0\", \"status\": 200, \"size\": 4033}",
  "{\"@timestamp\": 893965907, \"clientip\":\"45.135.0.0\", \"request\": \"GET /images/hist7802.jpg HTTP/1.0\", \"status\": 200, \"size\": 10813}",
  "{\"@timestamp\": 893965907, \"clientip\":\"45.135.0.0\", \"request\": \"GET /french/history/past_cups/images/past_trophy2.gif HTTP/1.0\", \"status\": 200, \"size\": 443}",
  "{\"@timestamp\": 893965908, \"clientip\":\"45.135.0.0\", \"request\": \"GET /french/history/past_cups/images/past_bu_50_off.gif HTTP/1.0\", \"status\": 200, \"size\": 392}",
  "{\"@timestamp\": 893965908, \"clientip\":\"45.135.0.0\", \"request\": \"GET /french/history/past_cups/images/past_header.gif HTTP/1.0\", \"status\": 200, \"size\": 2077}",
  "{\"@timestamp\": 893965910, \"clientip\":\"45.135.0.0\", \"request\": \"GET /french/history/past_cups/images/past_bu_66_off.gif HTTP/1.0\", \"status\": 200, \"size\": 435}",
  "{\"@timestamp\": 893965911, \"clientip\":\"45.135.0.0\", \"request\": \"GET /french/history/past_cups/images/past_bu_82_off.gif HTTP/1.0\", \"status\": 200, \"size\": 433}",
  "{\"@timestamp\": 893965912, \"clientip\":\"45.135.0.0\", \"request\": \"GET /french/history/past_cups/images/past_bracket_top.gif HTTP/1.0\", \"status\": 200, \"size\": 289}",
  "{\"@timestamp\": 893965913, \"clientip\":\"45.135.0.0\", \"request\": \"GET /images/hist7801.jpg HTTP/1.0\", \"status\": 200, \"size\": 12855}",
  "{\"@timestamp\": 893965913, \"clientip\":\"45.135.0.0\", \"request\": \"GET /french/history/past_cups/images/past_bu_74_off.gif HTTP/1.0\", \"status\": 200, \"size\": 423}",
  "{\"@timestamp\": 893965913, \"clientip\":\"45.135.0.0\", \"request\": \"GET /french/history/past_cups/images/past_bu_34_off.gif HTTP/1.0\", \"status\": 200, \"size\": 397}",
  "{\"@timestamp\": 893965915, \"clientip\":\"45.135.0.0\", \"request\": \"GET /french/history/past_cups/images/past_bracket_bot.gif HTTP/1.0\", \"status\": 200, \"size\": 631}",
  "{\"@timestamp\": 893965917, \"clientip\":\"45.135.0.0\", \"request\": \"GET /french/history/past_cups/images/past_bu_58_off.gif HTTP/1.0\", \"status\": 200, \"size\": 397}",
  "{\"@timestamp\": 893965917, \"clientip\":\"45.135.0.0\", \"request\": \"GET /french/history/past_cups/images/past_bu_90_off.gif HTTP/1.0\", \"status\": 200, \"size\": 429}",
  "{\"@timestamp\": 893965917, \"clientip\":\"45.135.0.0\", \"request\": \"GET /french/history/images/thecup.GIF HTTP/1.0\", \"status\": 200, \"size\": 1036}",
  "{\"@timestamp\": 893965930, \"clientip\":\"174.1.0.0\", \"request\": \"GET /images/hm_bg.jpg HTTP/1.0\", \"status\": 200, \"size\": 24736}",
  "{\"@timestamp\": 893965932, \"clientip\":\"121.1.0.0\", \"request\": \"GET /images/hm_bg.jpg HTTP/1.0\", \"status\": 200, \"size\": 24736}",
  "{\"@timestamp\": 893965937, \"clientip\":\"91.1.0.0\", \"request\": \"GET /images/hm_bg.jpg HTTP/1.0\", \"status\": 200, \"size\": 24736}",
  "{\"@timestamp\": 893965976, \"clientip\":\"142.1.0.0\", \"request\": \"GET /images/hm_bg.jpg HTTP/1.0\", \"status\": 200, \"size\": 24736}",
  "{\"@timestamp\": 893965979, \"clientip\":\"104.0.0.0\", \"request\": \"GET /images/hm_bg.jpg HTTP/1.0\", \"status\": 200, \"size\": 24736}",
  "{\"@timestamp\": 893965988, \"clientip\":\"47.135.0.0\", \"request\": \"GET /french/index.html HTTP/1.0\", \"status\": 200, \"size\": 985}",
  "{\"@timestamp\": 893965991, \"clientip\":\"47.135.0.0\", \"request\": \"GET /french/nav_top_inet.html HTTP/1.0\", \"status\": 200, \"size\": 374}",
  "{\"@timestamp\": 893965991, \"clientip\":\"47.135.0.0\", \"request\": \"GET /french/splash_inet.html HTTP/1.0\", \"status\": 200, \"size\": 3781}",
  "{\"@timestamp\": 893965991, \"clientip\":\"47.135.0.0\", \"request\": \"GET /french/nav_inet.html HTTP/1.0\", \"status\": 200, \"size\": 2739}",
  "{\"@timestamp\": 893965992, \"clientip\":\"109.1.0.0\", \"request\": \"GET /images/hm_bg.jpg HTTP/1.0\", \"status\": 200, \"size\": 24736}",
  "{\"@timestamp\": 893965993, \"clientip\":\"47.135.0.0\", \"request\": \"GET /images/nav_bg_bottom.jpg HTTP/1.0\", \"status\": 200, \"size\": 8389}",
  "{\"@timestamp\": 893965993, \"clientip\":\"47.135.0.0\", \"request\": \"GET /images/logo_cfo.gif HTTP/1.0\", \"status\": 200, \"size\": 1504}",
  "{\"@timestamp\": 893965993, \"clientip\":\"47.135.0.0\", \"request\": \"GET /french/images/nav_team_off.gif HTTP/1.0\", \"status\": 200, \"size\": 870}",
  "{\"@timestamp\": 893965993, \"clientip\":\"47.135.0.0\", \"request\": \"GET /images/nav_bg_top.gif HTTP/1.0\", \"status\": 200, \"size\": 929}",
  "{\"@timestamp\": 893965994, \"clientip\":\"47.135.0.0\", \"request\": \"GET /french/images/nav_news_off.gif HTTP/1.0\", \"status\": 200, \"size\": 855}",
  "{\"@timestamp\": 893965994, \"clientip\":\"47.135.0.0\", \"request\": \"GET /french/images/nav_comp_off.gif HTTP/1.0\", \"status\": 200, \"size\": 995}",
  "{\"@timestamp\": 893965998, \"clientip\":\"47.135.0.0\", \"request\": \"GET /french/images/nav_sitemap_off.gif HTTP/1.0\", \"status\": 200, \"size\": 413}",
  "{\"@timestamp\": 893966000, \"clientip\":\"47.135.0.0\", \"request\": \"GET /french/images/nav_field_off.gif HTTP/1.0\", \"status\": 200, \"size\": 982}",
  "{\"@timestamp\": 893966001, \"clientip\":\"47.135.0.0\", \"request\": \"GET /french/images/nav_hosts_off.gif HTTP/1.0\", \"status\": 200, \"size\": 1139}",
  "{\"@timestamp\": 893966002, \"clientip\":\"47.135.0.0\", \"request\": \"GET /images/hm_nbg.jpg HTTP/1.0\", \"status\": 200, \"size\": 33665}",
  "{\"@timestamp\": 893966002, \"clientip\":\"47.135.0.0\", \"request\": \"GET /images/space.gif HTTP/1.0\", \"status\": 200, \"size\": 42}",
  "{\"@timestamp\": 893966003, \"clientip\":\"47.135.0.0\", \"request\": \"GET /french/images/nav_store_off.gif HTTP/1.0\", \"status\": 200, \"size\": 976}",
  "{\"@timestamp\": 893966004, \"clientip\":\"47.135.0.0\", \"request\": \"GET /french/ProScroll.class HTTP/1.0\", \"status\": 200, \"size\": 6507}",
  "{\"@timestamp\": 893966004, \"clientip\":\"47.135.0.0\", \"request\": \"GET /french/images/hm_official.gif HTTP/1.0\", \"status\": 200, \"size\": 972}",
  "{\"@timestamp\": 893966004, \"clientip\":\"47.135.0.0\", \"request\": \"GET /french/images/nav_logo_sponsors.gif HTTP/1.0\", \"status\": 200, \"size\": 1991}",
  "{\"@timestamp\": 893966004, \"clientip\":\"46.135.0.0\", \"request\": \"GET /images/space.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966005, \"clientip\":\"47.135.0.0\", \"request\": \"GET /french/images/nav_home_off.gif HTTP/1.0\", \"status\": 200, \"size\": 915}",
  "{\"@timestamp\": 893966006, \"clientip\":\"47.135.0.0\", \"request\": \"GET /french/images/nav_history_off.gif HTTP/1.0\", \"status\": 200, \"size\": 966}",
  "{\"@timestamp\": 893966008, \"clientip\":\"47.135.0.0\", \"request\": \"GET /french/images/nav_venue_off.gif HTTP/1.0\", \"status\": 200, \"size\": 945}",
  "{\"@timestamp\": 893966010, \"clientip\":\"47.135.0.0\", \"request\": \"GET /french/images/nav_tickets_off.gif HTTP/1.0\", \"status\": 200, \"size\": 965}",
  "{\"@timestamp\": 893966011, \"clientip\":\"55.0.0.0\", \"request\": \"GET /french/index.html HTTP/1.0\", \"status\": 200, \"size\": 985}",
  "{\"@timestamp\": 893966017, \"clientip\":\"47.135.0.0\", \"request\": \"GET /images/hm_anime_f.gif HTTP/1.0\", \"status\": 200, \"size\": 15529}",
  "{\"@timestamp\": 893966017, \"clientip\":\"47.135.0.0\", \"request\": \"GET /images/hm_day_f.gif HTTP/1.0\", \"status\": 200, \"size\": 574}",
  "{\"@timestamp\": 893966019, \"clientip\":\"47.135.0.0\", \"request\": \"GET /images/hm_brdl.gif HTTP/1.0\", \"status\": 200, \"size\": 208}",
  "{\"@timestamp\": 893966021, \"clientip\":\"47.135.0.0\", \"request\": \"GET /images/hm_linkf.gif HTTP/1.0\", \"status\": 200, \"size\": 123}",
  "{\"@timestamp\": 893966024, \"clientip\":\"47.135.0.0\", \"request\": \"GET /images/hm_arw.gif HTTP/1.0\", \"status\": 200, \"size\": 1050}",
  "{\"@timestamp\": 893966028, \"clientip\":\"47.135.0.0\", \"request\": \"GET /images/dot.gif HTTP/1.0\", \"status\": 200, \"size\": 43}",
  "{\"@timestamp\": 893966028, \"clientip\":\"47.135.0.0\", \"request\": \"GET /images/hm_brdr.gif HTTP/1.0\", \"status\": 200, \"size\": 235}",
  "{\"@timestamp\": 893966031, \"clientip\":\"47.135.0.0\", \"request\": \"GET /images/info.gif HTTP/1.0\", \"status\": 200, \"size\": 1251}",
  "{\"@timestamp\": 893966048, \"clientip\":\"131.1.0.0\", \"request\": \"GET /images/hm_bg.jpg HTTP/1.0\", \"status\": 200, \"size\": 24736}",
  "{\"@timestamp\": 893966055, \"clientip\":\"41.135.0.0\", \"request\": \"GET /images/hm_bg.jpg HTTP/1.0\", \"status\": 200, \"size\": 24736}",
  "{\"@timestamp\": 893966068, \"clientip\":\"161.0.0.0\", \"request\": \"GET /images/hm_bg.jpg HTTP/1.0\", \"status\": 200, \"size\": 24736}",
  "{\"@timestamp\": 893966068, \"clientip\":\"56.0.0.0\", \"request\": \"GET /images/hm_bg.jpg HTTP/1.0\", \"status\": 200, \"size\": 24736}",
  "{\"@timestamp\": 893966084, \"clientip\":\"176.0.0.0\", \"request\": \"GET /images/hm_bg.jpg HTTP/1.0\", \"status\": 200, \"size\": 24736}",
  "{\"@timestamp\": 893966085, \"clientip\":\"47.135.0.0\", \"request\": \"GET /french/frntpage.htm HTTP/1.0\", \"status\": 200, \"size\": 12824}",
  "{\"@timestamp\": 893966088, \"clientip\":\"55.0.0.0\", \"request\": \"GET /french/index.html HTTP/1.0\", \"status\": 200, \"size\": 985}",
  "{\"@timestamp\": 893966090, \"clientip\":\"47.2.0.0\", \"request\": \"GET /images/hm_bg.jpg HTTP/1.0\", \"status\": 200, \"size\": 24736}",
  "{\"@timestamp\": 893966091, \"clientip\":\"47.135.0.0\", \"request\": \"GET /images/backnews.gif HTTP/1.0\", \"status\": 200, \"size\": 4573}",
  "{\"@timestamp\": 893966091, \"clientip\":\"47.135.0.0\", \"request\": \"GET /french/images/fpnewstop.gif HTTP/1.0\", \"status\": 200, \"size\": 1317}",
  "{\"@timestamp\": 893966091, \"clientip\":\"47.135.0.0\", \"request\": \"GET /french/images/space.gif HTTP/1.0\", \"status\": 200, \"size\": 42}",
  "{\"@timestamp\": 893966092, \"clientip\":\"180.0.0.0\", \"request\": \"GET /images/hm_bg.jpg HTTP/1.0\", \"status\": 200, \"size\": 24736}",
  "{\"@timestamp\": 893966096, \"clientip\":\"47.135.0.0\", \"request\": \"GET /images/ligne1_case5.gif HTTP/1.0\", \"status\": 200, \"size\": 1018}",
  "{\"@timestamp\": 893966097, \"clientip\":\"47.135.0.0\", \"request\": \"GET /images/case5.gif HTTP/1.0\", \"status\": 200, \"size\": 1362}",
  "{\"@timestamp\": 893966097, \"clientip\":\"47.135.0.0\", \"request\": \"GET /images/dburton.jpg HTTP/1.0\", \"status\": 200, \"size\": 12009}",
  "{\"@timestamp\": 893966098, \"clientip\":\"47.135.0.0\", \"request\": \"GET /images/ligne.gif HTTP/1.0\", \"status\": 200, \"size\": 169}",
  "{\"@timestamp\": 893966100, \"clientip\":\"47.135.0.0\", \"request\": \"GET /images/ligneb.gif HTTP/1.0\", \"status\": 200, \"size\": 169}",
  "{\"@timestamp\": 893966102, \"clientip\":\"47.135.0.0\", \"request\": \"GET /images/ligneb01.gif HTTP/1.0\", \"status\": 200, \"size\": 169}",
  "{\"@timestamp\": 893966102, \"clientip\":\"47.135.0.0\", \"request\": \"GET /images/ligne01.gif HTTP/1.0\", \"status\": 200, \"size\": 169}",
  "{\"@timestamp\": 893966104, \"clientip\":\"47.135.0.0\", \"request\": \"GET /images/hm_f98_top.gif HTTP/1.0\", \"status\": 200, \"size\": 915}",
  "{\"@timestamp\": 893966104, \"clientip\":\"47.135.0.0\", \"request\": \"GET /images/base.gif HTTP/1.0\", \"status\": 200, \"size\": 366}",
  "{\"@timestamp\": 893966108, \"clientip\":\"47.135.0.0\", \"request\": \"GET /french/images/news_btn_press_off.gif HTTP/1.0\", \"status\": 200, \"size\": 1795}",
  "{\"@timestamp\": 893966109, \"clientip\":\"47.135.0.0\", \"request\": \"GET /french/images/lateb_new.gif HTTP/1.0\", \"status\": 200, \"size\": 1285}",
  "{\"@timestamp\": 893966109, \"clientip\":\"47.135.0.0\", \"request\": \"GET /french/images/today_new.gif HTTP/1.0\", \"status\": 200, \"size\": 869}",
  "{\"@timestamp\": 893966110, \"clientip\":\"47.135.0.0\", \"request\": \"GET /images/bord_stories.gif HTTP/1.0\", \"status\": 200, \"size\": 520}",
  "{\"@timestamp\": 893966111, \"clientip\":\"47.135.0.0\", \"request\": \"GET /images/ligne4_latebreak.gif HTTP/1.0\", \"status\": 200, \"size\": 1056}",
  "{\"@timestamp\": 893966112, \"clientip\":\"47.135.0.0\", \"request\": \"GET /images/bord_stories01.gif HTTP/1.0\", \"status\": 200, \"size\": 333}",
  "{\"@timestamp\": 893966113, \"clientip\":\"47.135.0.0\", \"request\": \"GET /french/images/archives.gif HTTP/1.0\", \"status\": 200, \"size\": 569}",
  "{\"@timestamp\": 893966113, \"clientip\":\"47.135.0.0\", \"request\": \"GET /french/images/top_stories.gif HTTP/1.0\", \"status\": 200, \"size\": 1078}",
  "{\"@timestamp\": 893966113, \"clientip\":\"47.135.0.0\", \"request\": \"GET /french/images/news_btn_letter_off.gif HTTP/1.0\", \"status\": 200, \"size\": 871}",
  "{\"@timestamp\": 893966115, \"clientip\":\"47.135.0.0\", \"request\": \"GET /french/images/news_btn_kits_off.gif HTTP/1.0\", \"status\": 200, \"size\": 965}",
  "{\"@timestamp\": 893966135, \"clientip\":\"184.0.0.0\", \"request\": \"GET /images/hm_bg.jpg HTTP/1.0\", \"status\": 200, \"size\": 24736}",
  "{\"@timestamp\": 893966178, \"clientip\":\"4.1.0.0\", \"request\": \"GET /images/hm_bg.jpg HTTP/1.0\", \"status\": 200, \"size\": 24736}",
  "{\"@timestamp\": 893966210, \"clientip\":\"183.1.0.0\", \"request\": \"GET /images/hm_bg.jpg HTTP/1.0\", \"status\": 200, \"size\": 24736}",
  "{\"@timestamp\": 893966218, \"clientip\":\"249.0.0.0\", \"request\": \"GET /images/hm_bg.jpg HTTP/1.0\", \"status\": 200, \"size\": 24736}",
  "{\"@timestamp\": 893966220, \"clientip\":\"235.0.0.0\", \"request\": \"GET /images/hm_bg.jpg HTTP/1.0\", \"status\": 200, \"size\": 24736}",
  "{\"@timestamp\": 893966221, \"clientip\":\"47.135.0.0\", \"request\": \"GET /french/news/3004tick.htm HTTP/1.0\", \"status\": 200, \"size\": 4234}",
  "{\"@timestamp\": 893966223, \"clientip\":\"47.135.0.0\", \"request\": \"GET /french/images/hm_f98_top.gif HTTP/1.0\", \"status\": 200, \"size\": 915}",
  "{\"@timestamp\": 893966224, \"clientip\":\"47.135.0.0\", \"request\": \"GET /images/ps_bdr_r.gif HTTP/1.0\", \"status\": 200, \"size\": 281}",
  "{\"@timestamp\": 893966224, \"clientip\":\"47.135.0.0\", \"request\": \"GET /images/ps_bdr_l.gif HTTP/1.0\", \"status\": 200, \"size\": 346}",
  "{\"@timestamp\": 893966232, \"clientip\":\"248.0.0.0\", \"request\": \"GET /images/hm_bg.jpg HTTP/1.0\", \"status\": 200, \"size\": 24736}",
  "{\"@timestamp\": 893966259, \"clientip\":\"2.2.0.0\", \"request\": \"GET /images/hm_bg.jpg HTTP/1.0\", \"status\": 200, \"size\": 24736}",
  "{\"@timestamp\": 893966273, \"clientip\":\"218.0.0.0\", \"request\": \"GET /images/hm_bg.jpg HTTP/1.0\", \"status\": 200, \"size\": 24736}",
  "{\"@timestamp\": 893966280, \"clientip\":\"48.4.0.0\", \"request\": \"GET /images/hm_bg.jpg HTTP/1.0\", \"status\": 200, \"size\": 24736}",
  "{\"@timestamp\": 893966296, \"clientip\":\"128.0.0.0\", \"request\": \"GET /images/hm_bg.jpg HTTP/1.0\", \"status\": 200, \"size\": 24736}",
  "{\"@timestamp\": 893966306, \"clientip\":\"139.0.0.0\", \"request\": \"GET /images/hm_bg.jpg HTTP/1.0\", \"status\": 200, \"size\": 24736}",
  "{\"@timestamp\": 893966310, \"clientip\":\"141.78.0.0\", \"request\": \"GET /french/index.html HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966310, \"clientip\":\"141.78.0.0\", \"request\": \"GET /french/nav_top_inet.html HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966310, \"clientip\":\"141.78.0.0\", \"request\": \"GET /french/nav_inet.html HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966311, \"clientip\":\"141.78.0.0\", \"request\": \"GET /french/splash_inet.html HTTP/1.0\", \"status\": 200, \"size\": 3781}",
  "{\"@timestamp\": 893966322, \"clientip\":\"249.1.0.0\", \"request\": \"GET /images/hm_bg.jpg HTTP/1.0\", \"status\": 200, \"size\": 24736}",
  "{\"@timestamp\": 893966327, \"clientip\":\"55.0.0.0\", \"request\": \"GET /french/index.html HTTP/1.0\", \"status\": 200, \"size\": 985}",
  "{\"@timestamp\": 893966342, \"clientip\":\"47.135.0.0\", \"request\": \"GET /french/frntpage.htm HTTP/1.0\", \"status\": 200, \"size\": 12824}",
  "{\"@timestamp\": 893966343, \"clientip\":\"141.78.0.0\", \"request\": \"GET /french/ProScroll.class HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966344, \"clientip\":\"141.78.0.0\", \"request\": \"GET /french/images/nav_history_off.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966344, \"clientip\":\"141.78.0.0\", \"request\": \"GET /french/images/nav_store_off.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966344, \"clientip\":\"141.78.0.0\", \"request\": \"GET /images/nav_bg_top.gif HTTP/1.0\", \"status\": 200, \"size\": 929}",
  "{\"@timestamp\": 893966344, \"clientip\":\"141.78.0.0\", \"request\": \"GET /french/images/nav_tickets_off.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966345, \"clientip\":\"141.78.0.0\", \"request\": \"GET /images/hm_brdr.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966345, \"clientip\":\"141.78.0.0\", \"request\": \"GET /images/hm_anime_f.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966345, \"clientip\":\"141.78.0.0\", \"request\": \"GET /images/logo_cfo.gif HTTP/1.0\", \"status\": 200, \"size\": 1504}",
  "{\"@timestamp\": 893966345, \"clientip\":\"141.78.0.0\", \"request\": \"GET /images/hm_day_f.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966346, \"clientip\":\"141.78.0.0\", \"request\": \"GET /french/images/nav_team_off.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966346, \"clientip\":\"141.78.0.0\", \"request\": \"GET /images/space.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966346, \"clientip\":\"141.78.0.0\", \"request\": \"GET /french/images/nav_history_off.gif HTTP/1.0\", \"status\": 206, \"size\": 838}",
  "{\"@timestamp\": 893966347, \"clientip\":\"141.78.0.0\", \"request\": \"GET /images/hm_brdr.gif HTTP/1.0\", \"status\": 206, \"size\": 107}",
  "{\"@timestamp\": 893966348, \"clientip\":\"141.78.0.0\", \"request\": \"GET /french/images/nav_field_off.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966348, \"clientip\":\"141.78.0.0\", \"request\": \"GET /french/images/nav_sitemap_off.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966348, \"clientip\":\"141.78.0.0\", \"request\": \"GET /french/images/nav_home_off.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966348, \"clientip\":\"141.78.0.0\", \"request\": \"GET /images/hm_brdl.gif HTTP/1.0\", \"status\": 200, \"size\": 208}",
  "{\"@timestamp\": 893966348, \"clientip\":\"141.78.0.0\", \"request\": \"GET /images/dot.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966349, \"clientip\":\"141.78.0.0\", \"request\": \"GET /french/images/nav_venue_off.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966350, \"clientip\":\"141.78.0.0\", \"request\": \"GET /french/images/nav_hosts_off.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966351, \"clientip\":\"141.78.0.0\", \"request\": \"GET /images/hm_linkf.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966351, \"clientip\":\"141.78.0.0\", \"request\": \"GET /french/images/nav_logo_sponsors.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966352, \"clientip\":\"141.78.0.0\", \"request\": \"GET /images/hm_arw.gif HTTP/1.0\", \"status\": 200, \"size\": 1050}",
  "{\"@timestamp\": 893966352, \"clientip\":\"141.78.0.0\", \"request\": \"GET /images/info.gif HTTP/1.0\", \"status\": 200, \"size\": 1251}",
  "{\"@timestamp\": 893966368, \"clientip\":\"221.0.0.0\", \"request\": \"GET /images/hm_bg.jpg HTTP/1.0\", \"status\": 200, \"size\": 24736}",
  "{\"@timestamp\": 893966381, \"clientip\":\"43.135.0.0\", \"request\": \"GET /images/hm_bg.jpg HTTP/1.0\", \"status\": 200, \"size\": 24736}",
  "{\"@timestamp\": 893966384, \"clientip\":\"175.0.0.0\", \"request\": \"GET /images/hm_bg.jpg HTTP/1.0\", \"status\": 200, \"size\": 24736}",
  "{\"@timestamp\": 893966384, \"clientip\":\"55.0.0.0\", \"request\": \"GET /french/index.html HTTP/1.0\", \"status\": 200, \"size\": 985}",
  "{\"@timestamp\": 893966386, \"clientip\":\"141.78.0.0\", \"request\": \"GET /french/competition/maincomp.htm HTTP/1.0\", \"status\": 200, \"size\": 3048}",
  "{\"@timestamp\": 893966388, \"clientip\":\"141.78.0.0\", \"request\": \"GET /images/comp_hm_brac.gif HTTP/1.0\", \"status\": 200, \"size\": 254}",
  "{\"@timestamp\": 893966388, \"clientip\":\"141.78.0.0\", \"request\": \"GET /french/images/comp_bg2_hm.jpg HTTP/1.0\", \"status\": 200, \"size\": 25676}",
  "{\"@timestamp\": 893966388, \"clientip\":\"141.78.0.0\", \"request\": \"GET /french/images/bar.jpg HTTP/1.0\", \"status\": 200, \"size\": 686}",
  "{\"@timestamp\": 893966388, \"clientip\":\"141.78.0.0\", \"request\": \"GET /french/images/comp_hm_header_shad.gif HTTP/1.0\", \"status\": 200, \"size\": 2207}",
  "{\"@timestamp\": 893966388, \"clientip\":\"141.78.0.0\", \"request\": \"GET /french/images/france98b.gif HTTP/1.0\", \"status\": 200, \"size\": 2122}",
  "{\"@timestamp\": 893966389, \"clientip\":\"141.78.0.0\", \"request\": \"GET /french/images/comp_hm_nav.gif HTTP/1.0\", \"status\": 200, \"size\": 11652}",
  "{\"@timestamp\": 893966390, \"clientip\":\"141.78.0.0\", \"request\": \"GET /images/comp_hm_archive.gif HTTP/1.0\", \"status\": 200, \"size\": 1644}",
  "{\"@timestamp\": 893966391, \"clientip\":\"141.78.0.0\", \"request\": \"GET /french/frntpage.htm HTTP/1.0\", \"status\": 200, \"size\": 12824}",
  "{\"@timestamp\": 893966392, \"clientip\":\"141.78.0.0\", \"request\": \"GET /images/backnews.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966392, \"clientip\":\"141.78.0.0\", \"request\": \"GET /french/images/fpnewstop.gif HTTP/1.0\", \"status\": 200, \"size\": 1317}",
  "{\"@timestamp\": 893966392, \"clientip\":\"141.78.0.0\", \"request\": \"GET /french/images/space.gif HTTP/1.0\", \"status\": 200, \"size\": 42}",
  "{\"@timestamp\": 893966393, \"clientip\":\"141.78.0.0\", \"request\": \"GET /french/images/news_btn_letter_off.gif HTTP/1.0\", \"status\": 200, \"size\": 871}",
  "{\"@timestamp\": 893966393, \"clientip\":\"141.78.0.0\", \"request\": \"GET /images/hm_f98_top.gif HTTP/1.0\", \"status\": 200, \"size\": 915}",
  "{\"@timestamp\": 893966393, \"clientip\":\"141.78.0.0\", \"request\": \"GET /images/ligneb.gif HTTP/1.0\", \"status\": 200, \"size\": 169}",
  "{\"@timestamp\": 893966393, \"clientip\":\"141.78.0.0\", \"request\": \"GET /french/images/today_new.gif HTTP/1.0\", \"status\": 200, \"size\": 869}",
  "{\"@timestamp\": 893966394, \"clientip\":\"141.78.0.0\", \"request\": \"GET /images/case5.gif HTTP/1.0\", \"status\": 200, \"size\": 1362}",
  "{\"@timestamp\": 893966394, \"clientip\":\"141.78.0.0\", \"request\": \"GET /images/ligne.gif HTTP/1.0\", \"status\": 200, \"size\": 169}",
  "{\"@timestamp\": 893966395, \"clientip\":\"141.78.0.0\", \"request\": \"GET /images/ligneb.gif HTTP/1.0\", \"status\": 200, \"size\": 169}",
  "{\"@timestamp\": 893966395, \"clientip\":\"141.78.0.0\", \"request\": \"GET /images/ligne01.gif HTTP/1.0\", \"status\": 200, \"size\": 169}",
  "{\"@timestamp\": 893966395, \"clientip\":\"141.78.0.0\", \"request\": \"GET /images/ligneb.gif HTTP/1.0\", \"status\": 200, \"size\": 169}",
  "{\"@timestamp\": 893966395, \"clientip\":\"141.78.0.0\", \"request\": \"GET /french/images/news_btn_press_off.gif HTTP/1.0\", \"status\": 200, \"size\": 1795}",
  "{\"@timestamp\": 893966396, \"clientip\":\"141.78.0.0\", \"request\": \"GET /images/ligne01.gif HTTP/1.0\", \"status\": 200, \"size\": 169}",
  "{\"@timestamp\": 893966397, \"clientip\":\"141.78.0.0\", \"request\": \"GET /images/bord_stories01.gif HTTP/1.0\", \"status\": 200, \"size\": 333}",
  "{\"@timestamp\": 893966397, \"clientip\":\"141.78.0.0\", \"request\": \"GET /images/dburton.jpg HTTP/1.0\", \"status\": 200, \"size\": 12009}",
  "{\"@timestamp\": 893966397, \"clientip\":\"141.78.0.0\", \"request\": \"GET /images/ligne1_case5.gif HTTP/1.0\", \"status\": 200, \"size\": 1018}",
  "{\"@timestamp\": 893966397, \"clientip\":\"141.78.0.0\", \"request\": \"GET /images/ligne4_latebreak.gif HTTP/1.0\", \"status\": 200, \"size\": 1056}",
  "{\"@timestamp\": 893966397, \"clientip\":\"42.135.0.0\", \"request\": \"GET /fth.htm HTTP/1.1\", \"status\": 200, \"size\": 190}",
  "{\"@timestamp\": 893966398, \"clientip\":\"141.78.0.0\", \"request\": \"GET /french/images/news_btn_kits_off.gif HTTP/1.0\", \"status\": 200, \"size\": 965}",
  "{\"@timestamp\": 893966398, \"clientip\":\"141.78.0.0\", \"request\": \"GET /images/ligneb01.gif HTTP/1.0\", \"status\": 200, \"size\": 169}",
  "{\"@timestamp\": 893966398, \"clientip\":\"141.78.0.0\", \"request\": \"GET /images/bord_stories.gif HTTP/1.0\", \"status\": 200, \"size\": 520}",
  "{\"@timestamp\": 893966399, \"clientip\":\"141.78.0.0\", \"request\": \"GET /images/base.gif HTTP/1.0\", \"status\": 200, \"size\": 366}",
  "{\"@timestamp\": 893966399, \"clientip\":\"141.78.0.0\", \"request\": \"GET /french/images/lateb_new.gif HTTP/1.0\", \"status\": 200, \"size\": 1285}",
  "{\"@timestamp\": 893966399, \"clientip\":\"141.78.0.0\", \"request\": \"GET /images/ligneb01.gif HTTP/1.0\", \"status\": 200, \"size\": 169}",
  "{\"@timestamp\": 893966399, \"clientip\":\"141.78.0.0\", \"request\": \"GET /french/images/archives.gif HTTP/1.0\", \"status\": 200, \"size\": 569}",
  "{\"@timestamp\": 893966400, \"clientip\":\"141.78.0.0\", \"request\": \"GET /french/images/top_stories.gif HTTP/1.0\", \"status\": 200, \"size\": 1078}",
  "{\"@timestamp\": 893966402, \"clientip\":\"0.0.0.0\", \"request\": \"GET /images/home_intro.anim.gif HTTP/1.0\", \"status\": 200, \"size\": 60349}",
  "{\"@timestamp\": 893966403, \"clientip\":\"1.0.0.0\", \"request\": \"GET /images/home_bg_stars.gif HTTP/1.0\", \"status\": 200, \"size\": 2557}",
  "{\"@timestamp\": 893966403, \"clientip\":\"1.0.0.0\", \"request\": \"GET /images/home_fr_phrase.gif HTTP/1.0\", \"status\": 200, \"size\": 2843}",
  "{\"@timestamp\": 893966403, \"clientip\":\"2.0.0.0\", \"request\": \"GET /images/nav_bg_top.gif HTTP/1.0\", \"status\": 200, \"size\": 929}",
  "{\"@timestamp\": 893966403, \"clientip\":\"1.0.0.0\", \"request\": \"GET /images/home_logo.gif HTTP/1.0\", \"status\": 200, \"size\": 3401}",
  "{\"@timestamp\": 893966404, \"clientip\":\"2.0.0.0\", \"request\": \"GET /images/logo_cfo.gif HTTP/1.0\", \"status\": 200, \"size\": 1504}",
  "{\"@timestamp\": 893966404, \"clientip\":\"1.0.0.0\", \"request\": \"GET /images/home_eng_phrase.gif HTTP/1.0\", \"status\": 200, \"size\": 2861}",
  "{\"@timestamp\": 893966404, \"clientip\":\"3.0.0.0\", \"request\": \"GET /english/index.html HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966404, \"clientip\":\"4.0.0.0\", \"request\": \"GET /english/frntpage.htm HTTP/1.0\", \"status\": 200, \"size\": 12800}",
  "{\"@timestamp\": 893966404, \"clientip\":\"5.0.0.0\", \"request\": \"GET /images/hm_f98_top.gif HTTP/1.1\", \"status\": 200, \"size\": 915}",
  "{\"@timestamp\": 893966404, \"clientip\":\"6.0.0.0\", \"request\": \"GET /images/team_hm_concacaf.gif HTTP/1.0\", \"status\": 200, \"size\": 764}",
  "{\"@timestamp\": 893966404, \"clientip\":\"6.0.0.0\", \"request\": \"GET /images/team_hm_afc.gif HTTP/1.0\", \"status\": 200, \"size\": 475}",
  "{\"@timestamp\": 893966404, \"clientip\":\"6.0.0.0\", \"request\": \"GET /images/team_hm_caf.gif HTTP/1.0\", \"status\": 200, \"size\": 473}",
  "{\"@timestamp\": 893966405, \"clientip\":\"7.0.0.0\", \"request\": \"GET /english/playing/mascot/mascot.html HTTP/1.0\", \"status\": 200, \"size\": 5521}",
  "{\"@timestamp\": 893966405, \"clientip\":\"1.0.0.0\", \"request\": \"GET /images/home_tool.gif HTTP/1.0\", \"status\": 200, \"size\": 327}",
  "{\"@timestamp\": 893966405, \"clientip\":\"8.0.0.0\", \"request\": \"GET /english/images/comp_bu_stage1n.gif HTTP/1.0\", \"status\": 200, \"size\": 1548}",
  "{\"@timestamp\": 893966405, \"clientip\":\"8.0.0.0\", \"request\": \"GET /english/images/comp_bu_stage2n_on.gif HTTP/1.0\", \"status\": 200, \"size\": 996}",
  "{\"@timestamp\": 893966405, \"clientip\":\"8.0.0.0\", \"request\": \"GET /images/comp_stage2_brc_top.gif HTTP/1.0\", \"status\": 200, \"size\": 163}",
  "{\"@timestamp\": 893966405, \"clientip\":\"8.0.0.0\", \"request\": \"GET /images/comp_stage2_brc_topr.gif HTTP/1.0\", \"status\": 200, \"size\": 163}",
  "{\"@timestamp\": 893966405, \"clientip\":\"9.0.0.0\", \"request\": \"GET /english/history/past_cups/images/posters/france38.gif HTTP/1.0\", \"status\": 200, \"size\": 4649}",
  "{\"@timestamp\": 893966405, \"clientip\":\"3.0.0.0\", \"request\": \"GET /english/nav_top_inet.html HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966405, \"clientip\":\"3.0.0.0\", \"request\": \"GET /english/nav_inet.html HTTP/1.0\", \"status\": 200, \"size\": 2672}",
  "{\"@timestamp\": 893966405, \"clientip\":\"3.0.0.0\", \"request\": \"GET /english/splash_inet.html HTTP/1.0\", \"status\": 200, \"size\": 3730}",
  "{\"@timestamp\": 893966405, \"clientip\":\"9.0.0.0\", \"request\": \"GET /english/history/past_cups/images/38-1.jpg HTTP/1.0\", \"status\": 200, \"size\": 14315}",
  "{\"@timestamp\": 893966405, \"clientip\":\"10.0.0.0\", \"request\": \"GET /images/cal_nant.gif HTTP/1.0\", \"status\": 200, \"size\": 359}",
  "{\"@timestamp\": 893966405, \"clientip\":\"9.0.0.0\", \"request\": \"GET /english/history/past_cups/images/past_bu_38_on.gif HTTP/1.0\", \"status\": 200, \"size\": 507}",
  "{\"@timestamp\": 893966405, \"clientip\":\"8.0.0.0\", \"request\": \"GET /images/comp_stage2_brc_botr.gif HTTP/1.0\", \"status\": 200, \"size\": 158}",
  "{\"@timestamp\": 893966405, \"clientip\":\"8.0.0.0\", \"request\": \"GET /images/comp_stage2_brc_bot.gif HTTP/1.0\", \"status\": 200, \"size\": 160}",
  "{\"@timestamp\": 893966405, \"clientip\":\"8.0.0.0\", \"request\": \"GET /images/comp_stage2_brc.gif HTTP/1.0\", \"status\": 200, \"size\": 82}",
  "{\"@timestamp\": 893966405, \"clientip\":\"11.0.0.0\", \"request\": \"GET /images/comp_stage2_brc_botr.gif HTTP/1.0\", \"status\": 200, \"size\": 158}",
  "{\"@timestamp\": 893966405, \"clientip\":\"12.0.0.0\", \"request\": \"GET /english/nav_top_inet.html HTTP/1.0\", \"status\": 200, \"size\": 374}",
  "{\"@timestamp\": 893966405, \"clientip\":\"10.0.0.0\", \"request\": \"GET /images/cal_lyon.gif HTTP/1.0\", \"status\": 200, \"size\": 286}",
  "{\"@timestamp\": 893966405, \"clientip\":\"12.0.0.0\", \"request\": \"GET /english/nav_inet.html HTTP/1.0\", \"status\": 200, \"size\": 2672}",
  "{\"@timestamp\": 893966405, \"clientip\":\"1.0.0.0\", \"request\": \"GET /images/home_sponsor.gif HTTP/1.0\", \"status\": 200, \"size\": 2491}",
  "{\"@timestamp\": 893966405, \"clientip\":\"12.0.0.0\", \"request\": \"GET /english/splash_inet.html HTTP/1.0\", \"status\": 200, \"size\": 3730}",
  "{\"@timestamp\": 893966405, \"clientip\":\"10.0.0.0\", \"request\": \"GET /images/cal_mars.gif HTTP/1.0\", \"status\": 200, \"size\": 377}",
  "{\"@timestamp\": 893966405, \"clientip\":\"10.0.0.0\", \"request\": \"GET /images/cal-lens.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966405, \"clientip\":\"10.0.0.0\", \"request\": \"GET /images/cal_toul.gif HTTP/1.0\", \"status\": 200, \"size\": 380}",
  "{\"@timestamp\": 893966406, \"clientip\":\"8.0.0.0\", \"request\": \"GET /english/competition/stage2.htm HTTP/1.0\", \"status\": 200, \"size\": 16606}",
  "{\"@timestamp\": 893966406, \"clientip\":\"12.0.0.0\", \"request\": \"GET /images/hm_nbg.jpg HTTP/1.0\", \"status\": 200, \"size\": 33665}",
  "{\"@timestamp\": 893966406, \"clientip\":\"10.0.0.0\", \"request\": \"GET /images/cal-lens.gif HTTP/1.0\", \"status\": 206, \"size\": 124}",
  "{\"@timestamp\": 893966406, \"clientip\":\"8.0.0.0\", \"request\": \"GET /english/images/comp_bg2_hm.jpg HTTP/1.0\", \"status\": 200, \"size\": 25676}",
  "{\"@timestamp\": 893966406, \"clientip\":\"8.0.0.0\", \"request\": \"GET /english/images/comp_hm_header.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966406, \"clientip\":\"10.0.0.0\", \"request\": \"GET /images/cal_mont.gif HTTP/1.0\", \"status\": 200, \"size\": 316}",
  "{\"@timestamp\": 893966406, \"clientip\":\"8.0.0.0\", \"request\": \"GET /english/images/space.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966406, \"clientip\":\"2.0.0.0\", \"request\": \"GET /english/images/nav_store_off.gif HTTP/1.0\", \"status\": 200, \"size\": 934}",
  "{\"@timestamp\": 893966406, \"clientip\":\"10.0.0.0\", \"request\": \"GET /images/cal_steti.gif HTTP/1.0\", \"status\": 200, \"size\": 1125}",
  "{\"@timestamp\": 893966406, \"clientip\":\"1.0.0.0\", \"request\": \"GET /images/home_eng_button.gif HTTP/1.0\", \"status\": 200, \"size\": 1927}",
  "{\"@timestamp\": 893966406, \"clientip\":\"5.0.0.0\", \"request\": \"GET /french/images/news_btn_press_off.gif HTTP/1.1\", \"status\": 200, \"size\": 1795}",
  "{\"@timestamp\": 893966406, \"clientip\":\"1.0.0.0\", \"request\": \"GET /images/home_intro.anim.gif HTTP/1.0\", \"status\": 200, \"size\": 60349}",
  "{\"@timestamp\": 893966406, \"clientip\":\"13.0.0.0\", \"request\": \"GET /english/images/comp_hm_header.gif HTTP/1.0\", \"status\": 200, \"size\": 1189}",
  "{\"@timestamp\": 893966406, \"clientip\":\"3.0.0.0\", \"request\": \"GET /images/nav_bg_top.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966406, \"clientip\":\"14.0.0.0\", \"request\": \"GET /images/logo_cfo.gif HTTP/1.1\", \"status\": 200, \"size\": 1504}",
  "{\"@timestamp\": 893966406, \"clientip\":\"3.0.0.0\", \"request\": \"GET /images/logo_cfo.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966406, \"clientip\":\"15.0.0.0\", \"request\": \"GET /cgi-bin/trivia/Trivia.pl?ENG HTTP/1.0\", \"status\": 200, \"size\": 6213}",
  "{\"@timestamp\": 893966406, \"clientip\":\"13.0.0.0\", \"request\": \"GET /english/images/france98b.gif HTTP/1.0\", \"status\": 200, \"size\": 2122}",
  "{\"@timestamp\": 893966406, \"clientip\":\"13.0.0.0\", \"request\": \"GET /english/images/comp_bu_stage1n.gif HTTP/1.0\", \"status\": 200, \"size\": 1548}",
  "{\"@timestamp\": 893966406, \"clientip\":\"16.0.0.0\", \"request\": \"GET /images/s102336.gif HTTP/1.0\", \"status\": 200, \"size\": 177}",
  "{\"@timestamp\": 893966406, \"clientip\":\"17.0.0.0\", \"request\": \"GET /english/history/images/france98b.GIF HTTP/1.0\", \"status\": 200, \"size\": 915}",
  "{\"@timestamp\": 893966406, \"clientip\":\"17.0.0.0\", \"request\": \"GET /english/history/images/football.GIF HTTP/1.0\", \"status\": 200, \"size\": 1170}",
  "{\"@timestamp\": 893966406, \"clientip\":\"18.0.0.0\", \"request\": \"GET /english/competition/headtohead78.htm HTTP/1.0\", \"status\": 200, \"size\": 20126}",
  "{\"@timestamp\": 893966406, \"clientip\":\"3.0.0.0\", \"request\": \"GET /english/images/nav_tickets_off.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966406, \"clientip\":\"12.0.0.0\", \"request\": \"GET /images/hm_anime_e.gif HTTP/1.0\", \"status\": 200, \"size\": 15609}",
  "{\"@timestamp\": 893966406, \"clientip\":\"17.0.0.0\", \"request\": \"GET /english/history/images/infrance.GIF HTTP/1.0\", \"status\": 200, \"size\": 990}",
  "{\"@timestamp\": 893966406, \"clientip\":\"19.0.0.0\", \"request\": \"GET /english/images/nav_news_off.gif HTTP/1.0\", \"status\": 200, \"size\": 853}",
  "{\"@timestamp\": 893966406, \"clientip\":\"141.78.0.0\", \"request\": \"GET /french/images/hm_f98_top.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966406, \"clientip\":\"141.78.0.0\", \"request\": \"GET /images/ps_bdr_r.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966406, \"clientip\":\"141.78.0.0\", \"request\": \"GET /french/news/3004tick.htm HTTP/1.0\", \"status\": 200, \"size\": 4234}",
  "{\"@timestamp\": 893966406, \"clientip\":\"141.78.0.0\", \"request\": \"GET /images/ps_bdr_l.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966407, \"clientip\":\"12.0.0.0\", \"request\": \"GET /images/logo_cfo.gif HTTP/1.0\", \"status\": 200, \"size\": 1504}",
  "{\"@timestamp\": 893966407, \"clientip\":\"19.0.0.0\", \"request\": \"GET /english/images/nav_comp_off.gif HTTP/1.0\", \"status\": 200, \"size\": 994}",
  "{\"@timestamp\": 893966407, \"clientip\":\"3.0.0.0\", \"request\": \"GET /images/nav_bg_bottom.jpg HTTP/1.0\", \"status\": 200, \"size\": 8389}",
  "{\"@timestamp\": 893966407, \"clientip\":\"19.0.0.0\", \"request\": \"GET /images/nav_bg_bottom.jpg HTTP/1.0\", \"status\": 200, \"size\": 8389}",
  "{\"@timestamp\": 893966407, \"clientip\":\"8.0.0.0\", \"request\": \"GET /english/images/france98b.gif HTTP/1.0\", \"status\": 200, \"size\": 2122}",
  "{\"@timestamp\": 893966407, \"clientip\":\"3.0.0.0\", \"request\": \"GET /english/images/nav_news_off.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966407, \"clientip\":\"3.0.0.0\", \"request\": \"GET /english/images/nav_comp_off.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966407, \"clientip\":\"1.0.0.0\", \"request\": \"GET /images/home_fr_button.gif HTTP/1.0\", \"status\": 200, \"size\": 2140}",
  "{\"@timestamp\": 893966407, \"clientip\":\"12.0.0.0\", \"request\": \"GET /images/space.gif HTTP/1.0\", \"status\": 200, \"size\": 42}",
  "{\"@timestamp\": 893966407, \"clientip\":\"3.0.0.0\", \"request\": \"GET /english/images/nav_team_off.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966407, \"clientip\":\"3.0.0.0\", \"request\": \"GET /english/images/nav_venue_off.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966407, \"clientip\":\"12.0.0.0\", \"request\": \"GET /english/images/hm_official.gif HTTP/1.0\", \"status\": 200, \"size\": 1807}",
  "{\"@timestamp\": 893966407, \"clientip\":\"12.0.0.0\", \"request\": \"GET /english/ProScroll.class HTTP/1.0\", \"status\": 200, \"size\": 6507}",
  "{\"@timestamp\": 893966407, \"clientip\":\"20.0.0.0\", \"request\": \"GET /images/10982.gif HTTP/1.0\", \"status\": 200, \"size\": 183}",
  "{\"@timestamp\": 893966407, \"clientip\":\"20.0.0.0\", \"request\": \"GET /images/11101.gif HTTP/1.0\", \"status\": 200, \"size\": 415}",
  "{\"@timestamp\": 893966407, \"clientip\":\"0.0.0.0\", \"request\": \"GET /images/home_sponsor.gif HTTP/1.0\", \"status\": 200, \"size\": 2491}",
  "{\"@timestamp\": 893966407, \"clientip\":\"5.0.0.0\", \"request\": \"GET /french/images/space.gif HTTP/1.1\", \"status\": 200, \"size\": 42}",
  "{\"@timestamp\": 893966407, \"clientip\":\"5.0.0.0\", \"request\": \"GET /french/images/fpnewstop.gif HTTP/1.1\", \"status\": 200, \"size\": 1317}",
  "{\"@timestamp\": 893966407, \"clientip\":\"13.0.0.0\", \"request\": \"GET /english/images/comp_bu_stage2n.gif HTTP/1.0\", \"status\": 200, \"size\": 984}",
  "{\"@timestamp\": 893966407, \"clientip\":\"2.0.0.0\", \"request\": \"GET /english/images/nav_sitemap_off.gif HTTP/1.0\", \"status\": 200, \"size\": 416}",
  "{\"@timestamp\": 893966407, \"clientip\":\"13.0.0.0\", \"request\": \"GET /english/images/comp_bu_groupsn_on.gif HTTP/1.0\", \"status\": 200, \"size\": 963}",
  "{\"@timestamp\": 893966407, \"clientip\":\"20.0.0.0\", \"request\": \"GET /images/bordeaux.gif HTTP/1.0\", \"status\": 200, \"size\": 723}",
  "{\"@timestamp\": 893966407, \"clientip\":\"10.0.0.0\", \"request\": \"GET /images/cal_bord.gif HTTP/1.0\", \"status\": 200, \"size\": 416}",
  "{\"@timestamp\": 893966407, \"clientip\":\"2.0.0.0\", \"request\": \"GET /english/images/nav_venue_off.gif HTTP/1.0\", \"status\": 200, \"size\": 870}",
  "{\"@timestamp\": 893966407, \"clientip\":\"15.0.0.0\", \"request\": \"GET /english/playing/images/trivia/banner.jpg HTTP/1.0\", \"status\": 200, \"size\": 19967}",
  "{\"@timestamp\": 893966407, \"clientip\":\"15.0.0.0\", \"request\": \"GET /english/playing/images/trivia/01test.gif HTTP/1.0\", \"status\": 200, \"size\": 1664}",
  "{\"@timestamp\": 893966407, \"clientip\":\"8.0.0.0\", \"request\": \"GET /english/images/comp_bu_stage2n_on.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966408, \"clientip\":\"8.0.0.0\", \"request\": \"GET /english/images/comp_bu_refsn.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966408, \"clientip\":\"15.0.0.0\", \"request\": \"GET /english/playing/images/trivia/quizbg.gif HTTP/1.0\", \"status\": 200, \"size\": 1460}",
  "{\"@timestamp\": 893966408, \"clientip\":\"20.0.0.0\", \"request\": \"GET /images/lyon.gif HTTP/1.0\", \"status\": 200, \"size\": 599}",
  "{\"@timestamp\": 893966408, \"clientip\":\"12.0.0.0\", \"request\": \"GET /images/hm_day_e.gif HTTP/1.0\", \"status\": 200, \"size\": 499}",
  "{\"@timestamp\": 893966408, \"clientip\":\"12.0.0.0\", \"request\": \"GET /images/info.gif HTTP/1.0\", \"status\": 200, \"size\": 1251}",
  "{\"@timestamp\": 893966408, \"clientip\":\"12.0.0.0\", \"request\": \"GET /english/images/nav_team_off.gif HTTP/1.0\", \"status\": 200, \"size\": 776}",
  "{\"@timestamp\": 893966408, \"clientip\":\"2.0.0.0\", \"request\": \"GET /images/space.gif HTTP/1.0\", \"status\": 200, \"size\": 42}",
  "{\"@timestamp\": 893966408, \"clientip\":\"12.0.0.0\", \"request\": \"GET /images/nav_bg_bottom.jpg HTTP/1.0\", \"status\": 200, \"size\": 8389}",
  "{\"@timestamp\": 893966408, \"clientip\":\"2.0.0.0\", \"request\": \"GET /english/images/hm_official.gif HTTP/1.0\", \"status\": 200, \"size\": 1807}",
  "{\"@timestamp\": 893966408, \"clientip\":\"12.0.0.0\", \"request\": \"GET /english/images/nav_comp_off.gif HTTP/1.0\", \"status\": 200, \"size\": 994}",
  "{\"@timestamp\": 893966408, \"clientip\":\"21.0.0.0\", \"request\": \"GET /english/news/11415.htm HTTP/1.1\", \"status\": 200, \"size\": 21300}",
  "{\"@timestamp\": 893966408, \"clientip\":\"8.0.0.0\", \"request\": \"GET /images/comp_stage2_brc_top.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966408, \"clientip\":\"12.0.0.0\", \"request\": \"GET /english/images/nav_field_off.gif HTTP/1.0\", \"status\": 200, \"size\": 1005}",
  "{\"@timestamp\": 893966408, \"clientip\":\"17.0.0.0\", \"request\": \"GET /english/history/images/reading.GIF HTTP/1.0\", \"status\": 200, \"size\": 1171}",
  "{\"@timestamp\": 893966408, \"clientip\":\"22.0.0.0\", \"request\": \"GET /english/teams/teamqualify124.htm HTTP/1.0\", \"status\": 200, \"size\": 3866}",
  "{\"@timestamp\": 893966408, \"clientip\":\"23.0.0.0\", \"request\": \"GET / HTTP/1.0\", \"status\": 200, \"size\": 8712}",
  "{\"@timestamp\": 893966408, \"clientip\":\"24.0.0.0\", \"request\": \"GET /images/space.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966409, \"clientip\":\"24.0.0.0\", \"request\": \"GET /english/playing/images/anim/trivia_on.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966409, \"clientip\":\"5.0.0.0\", \"request\": \"GET /french/images/today_new.gif HTTP/1.1\", \"status\": 200, \"size\": 869}",
  "{\"@timestamp\": 893966409, \"clientip\":\"20.0.0.0\", \"request\": \"GET /images/saintdenis.gif HTTP/1.0\", \"status\": 200, \"size\": 702}",
  "{\"@timestamp\": 893966409, \"clientip\":\"24.0.0.0\", \"request\": \"GET /english/playing/images/play_hm_mascot.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966409, \"clientip\":\"5.0.0.0\", \"request\": \"GET /french/images/top_stories.gif HTTP/1.1\", \"status\": 200, \"size\": 1078}",
  "{\"@timestamp\": 893966409, \"clientip\":\"5.0.0.0\", \"request\": \"GET /images/case5.gif HTTP/1.1\", \"status\": 200, \"size\": 1362}",
  "{\"@timestamp\": 893966409, \"clientip\":\"17.0.0.0\", \"request\": \"GET /english/history/past_cups/images/past_bu_30_off.gif HTTP/1.0\", \"status\": 200, \"size\": 406}",
  "{\"@timestamp\": 893966409, \"clientip\":\"20.0.0.0\", \"request\": \"GET /images/toulouse.gif HTTP/1.0\", \"status\": 200, \"size\": 704}",
  "{\"@timestamp\": 893966409, \"clientip\":\"25.0.0.0\", \"request\": \"GET /images/home_bg_stars.gif HTTP/1.1\", \"status\": 200, \"size\": 2557}",
  "{\"@timestamp\": 893966409, \"clientip\":\"26.0.0.0\", \"request\": \"GET /english/images/nav_field_off.gif HTTP/1.0\", \"status\": 200, \"size\": 1005}",
  "{\"@timestamp\": 893966409, \"clientip\":\"27.0.0.0\", \"request\": \"GET /english/images/teams_bu_group_on.gif HTTP/1.0\", \"status\": 200, \"size\": 668}",
  "{\"@timestamp\": 893966409, \"clientip\":\"13.0.0.0\", \"request\": \"GET /english/images/comp_bu_refsn.gif HTTP/1.0\", \"status\": 200, \"size\": 933}",
  "{\"@timestamp\": 893966409, \"clientip\":\"28.0.0.0\", \"request\": \"GET /english/individuals/player13893.htm HTTP/1.0\", \"status\": 200, \"size\": 6472}",
  "{\"@timestamp\": 893966409, \"clientip\":\"13.0.0.0\", \"request\": \"GET /english/images/comp_bu_calendar.gif HTTP/1.0\", \"status\": 200, \"size\": 1197}",
  "{\"@timestamp\": 893966410, \"clientip\":\"23.0.0.0\", \"request\": \"GET /images/home_fr_phrase.gif HTTP/1.0\", \"status\": 200, \"size\": 2843}",
  "{\"@timestamp\": 893966410, \"clientip\":\"12.0.0.0\", \"request\": \"GET /images/nav_bg_top.gif HTTP/1.0\", \"status\": 200, \"size\": 929}",
  "{\"@timestamp\": 893966410, \"clientip\":\"23.0.0.0\", \"request\": \"GET /images/home_logo.gif HTTP/1.0\", \"status\": 200, \"size\": 3401}",
  "{\"@timestamp\": 893966410, \"clientip\":\"15.0.0.0\", \"request\": \"GET /english/playing/images/trivia/02how.gif HTTP/1.0\", \"status\": 200, \"size\": 754}",
  "{\"@timestamp\": 893966410, \"clientip\":\"23.0.0.0\", \"request\": \"GET /images/home_eng_phrase.gif HTTP/1.0\", \"status\": 200, \"size\": 2861}",
  "{\"@timestamp\": 893966410, \"clientip\":\"23.0.0.0\", \"request\": \"GET /images/home_tool.gif HTTP/1.0\", \"status\": 200, \"size\": 327}",
  "{\"@timestamp\": 893966410, \"clientip\":\"29.0.0.0\", \"request\": \"GET /images/10511.jpg HTTP/1.0\", \"status\": 200, \"size\": 15543}",
  "{\"@timestamp\": 893966410, \"clientip\":\"20.0.0.0\", \"request\": \"GET /images/11289.jpg HTTP/1.0\", \"status\": 200, \"size\": 6444}",
  "{\"@timestamp\": 893966410, \"clientip\":\"12.0.0.0\", \"request\": \"GET /english/images/nav_logo_sponsors.gif HTTP/1.0\", \"status\": 200, \"size\": 1991}",
  "{\"@timestamp\": 893966410, \"clientip\":\"12.0.0.0\", \"request\": \"GET /images/hm_brdl.gif HTTP/1.0\", \"status\": 200, \"size\": 208}",
  "{\"@timestamp\": 893966410, \"clientip\":\"23.0.0.0\", \"request\": \"GET /images/home_sponsor.gif HTTP/1.0\", \"status\": 200, \"size\": 2491}",
  "{\"@timestamp\": 893966410, \"clientip\":\"20.0.0.0\", \"request\": \"GET /images/11288.jpg HTTP/1.0\", \"status\": 200, \"size\": 5874}",
  "{\"@timestamp\": 893966410, \"clientip\":\"23.0.0.0\", \"request\": \"GET /images/home_eng_button.gif HTTP/1.0\", \"status\": 200, \"size\": 1927}",
  "{\"@timestamp\": 893966410, \"clientip\":\"23.0.0.0\", \"request\": \"GET /images/home_fr_button.gif HTTP/1.0\", \"status\": 200, \"size\": 2140}",
  "{\"@timestamp\": 893966410, \"clientip\":\"8.0.0.0\", \"request\": \"GET /images/comp_stage2_brc.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966410, \"clientip\":\"5.0.0.0\", \"request\": \"GET /images/dburton.jpg HTTP/1.1\", \"status\": 200, \"size\": 12009}",
  "{\"@timestamp\": 893966410, \"clientip\":\"2.0.0.0\", \"request\": \"GET /images/hm_anime_e.gif HTTP/1.0\", \"status\": 200, \"size\": 15609}",
  "{\"@timestamp\": 893966410, \"clientip\":\"12.0.0.0\", \"request\": \"GET /images/hm_brdr.gif HTTP/1.0\", \"status\": 200, \"size\": 235}",
  "{\"@timestamp\": 893966410, \"clientip\":\"12.0.0.0\", \"request\": \"GET /english/images/nav_news_off.gif HTTP/1.0\", \"status\": 200, \"size\": 853}",
  "{\"@timestamp\": 893966410, \"clientip\":\"15.0.0.0\", \"request\": \"GET /english/playing/images/trivia/04luck.gif HTTP/1.0\", \"status\": 200, \"size\": 744}",
  "{\"@timestamp\": 893966410, \"clientip\":\"23.0.0.0\", \"request\": \"GET /images/home_intro.anim.gif HTTP/1.0\", \"status\": 200, \"size\": 60349}",
  "{\"@timestamp\": 893966410, \"clientip\":\"2.0.0.0\", \"request\": \"GET /english/ProScroll.class HTTP/1.0\", \"status\": 200, \"size\": 6507}",
  "{\"@timestamp\": 893966410, \"clientip\":\"5.0.0.0\", \"request\": \"GET /images/bord_stories01.gif HTTP/1.1\", \"status\": 200, \"size\": 333}",
  "{\"@timestamp\": 893966410, \"clientip\":\"12.0.0.0\", \"request\": \"GET /english/images/nav_venue_off.gif HTTP/1.0\", \"status\": 200, \"size\": 870}",
  "{\"@timestamp\": 893966411, \"clientip\":\"30.0.0.0\", \"request\": \"GET /english/playing/download/download.html HTTP/1.0\", \"status\": 200, \"size\": 13898}",
  "{\"@timestamp\": 893966411, \"clientip\":\"2.0.0.0\", \"request\": \"GET /english/images/nav_hosts_off.gif HTTP/1.0\", \"status\": 200, \"size\": 914}",
  "{\"@timestamp\": 893966411, \"clientip\":\"16.0.0.0\", \"request\": \"GET /images/s102373.gif HTTP/1.0\", \"status\": 200, \"size\": 142}",
  "{\"@timestamp\": 893966411, \"clientip\":\"3.0.0.0\", \"request\": \"GET /images/hm_day_e.gif HTTP/1.0\", \"status\": 200, \"size\": 499}",
  "{\"@timestamp\": 893966411, \"clientip\":\"3.0.0.0\", \"request\": \"GET /images/hm_nbg.jpg HTTP/1.0\", \"status\": 200, \"size\": 33665}",
  "{\"@timestamp\": 893966411, \"clientip\":\"12.0.0.0\", \"request\": \"GET /english/images/nav_tickets_off.gif HTTP/1.0\", \"status\": 200, \"size\": 937}",
  "{\"@timestamp\": 893966411, \"clientip\":\"3.0.0.0\", \"request\": \"GET /images/space.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966411, \"clientip\":\"3.0.0.0\", \"request\": \"GET /english/images/hm_official.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966411, \"clientip\":\"5.0.0.0\", \"request\": \"GET /images/bord_stories.gif HTTP/1.1\", \"status\": 200, \"size\": 520}",
  "{\"@timestamp\": 893966411, \"clientip\":\"3.0.0.0\", \"request\": \"GET /images/space.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966411, \"clientip\":\"31.0.0.0\", \"request\": \"GET /english/images/nav_store_off.gif HTTP/1.1\", \"status\": 200, \"size\": 934}",
  "{\"@timestamp\": 893966411, \"clientip\":\"15.0.0.0\", \"request\": \"GET /english/playing/images/trivia/03score.gif HTTP/1.0\", \"status\": 200, \"size\": 572}",
  "{\"@timestamp\": 893966411, \"clientip\":\"3.0.0.0\", \"request\": \"GET /english/images/nav_store_off.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966411, \"clientip\":\"31.0.0.0\", \"request\": \"GET /english/images/nav_hosts_off.gif HTTP/1.1\", \"status\": 200, \"size\": 914}",
  "{\"@timestamp\": 893966411, \"clientip\":\"32.0.0.0\", \"request\": \"GET /images/home_intro.anim.gif HTTP/1.1\", \"status\": 200, \"size\": 60349}",
  "{\"@timestamp\": 893966412, \"clientip\":\"12.0.0.0\", \"request\": \"GET /english/images/nav_sitemap_off.gif HTTP/1.0\", \"status\": 200, \"size\": 416}",
  "{\"@timestamp\": 893966412, \"clientip\":\"12.0.0.0\", \"request\": \"GET /images/hm_linkf.gif HTTP/1.0\", \"status\": 200, \"size\": 123}",
  "{\"@timestamp\": 893966412, \"clientip\":\"12.0.0.0\", \"request\": \"GET /english/images/nav_history_off.gif HTTP/1.0\", \"status\": 200, \"size\": 914}",
  "{\"@timestamp\": 893966412, \"clientip\":\"12.0.0.0\", \"request\": \"GET /images/hm_arw.gif HTTP/1.0\", \"status\": 200, \"size\": 1050}",
  "{\"@timestamp\": 893966412, \"clientip\":\"12.0.0.0\", \"request\": \"GET /english/images/nav_hosts_off.gif HTTP/1.0\", \"status\": 200, \"size\": 914}",
  "{\"@timestamp\": 893966412, \"clientip\":\"15.0.0.0\", \"request\": \"GET /english/playing/images/trivia/submit.gif HTTP/1.0\", \"status\": 200, \"size\": 1808}",
  "{\"@timestamp\": 893966412, \"clientip\":\"17.0.0.0\", \"request\": \"GET /english/history/past_cups/images/past_header.gif HTTP/1.0\", \"status\": 200, \"size\": 1989}",
  "{\"@timestamp\": 893966412, \"clientip\":\"12.0.0.0\", \"request\": \"GET /english/images/nav_store_off.gif HTTP/1.0\", \"status\": 200, \"size\": 934}",
  "{\"@timestamp\": 893966412, \"clientip\":\"23.0.0.0\", \"request\": \"GET /english/index.html HTTP/1.0\", \"status\": 200, \"size\": 892}",
  "{\"@timestamp\": 893966412, \"clientip\":\"12.0.0.0\", \"request\": \"GET /images/dot.gif HTTP/1.0\", \"status\": 200, \"size\": 43}",
  "{\"@timestamp\": 893966412, \"clientip\":\"5.0.0.0\", \"request\": \"GET /french/images/lateb_new.gif HTTP/1.1\", \"status\": 200, \"size\": 1285}",
  "{\"@timestamp\": 893966412, \"clientip\":\"19.0.0.0\", \"request\": \"GET /english/images/nav_field_off.gif HTTP/1.0\", \"status\": 200, \"size\": 1005}",
  "{\"@timestamp\": 893966412, \"clientip\":\"25.0.0.0\", \"request\": \"GET /images/home_eng_phrase.gif HTTP/1.1\", \"status\": 200, \"size\": 2861}",
  "{\"@timestamp\": 893966412, \"clientip\":\"19.0.0.0\", \"request\": \"GET /english/images/nav_venue_off.gif HTTP/1.0\", \"status\": 200, \"size\": 870}",
  "{\"@timestamp\": 893966412, \"clientip\":\"23.0.0.0\", \"request\": \"GET /english/nav_top_inet.html HTTP/1.0\", \"status\": 200, \"size\": 374}",
  "{\"@timestamp\": 893966412, \"clientip\":\"23.0.0.0\", \"request\": \"GET /english/nav_inet.html HTTP/1.0\", \"status\": 200, \"size\": 2672}",
  "{\"@timestamp\": 893966412, \"clientip\":\"33.0.0.0\", \"request\": \"GET /images/home_fr_button.gif HTTP/1.1\", \"status\": 200, \"size\": 2140}",
  "{\"@timestamp\": 893966413, \"clientip\":\"25.0.0.0\", \"request\": \"GET /images/home_fr_button.gif HTTP/1.1\", \"status\": 200, \"size\": 2140}",
  "{\"@timestamp\": 893966413, \"clientip\":\"23.0.0.0\", \"request\": \"GET /images/nav_bg_bottom.jpg HTTP/1.0\", \"status\": 200, \"size\": 8389}",
  "{\"@timestamp\": 893966413, \"clientip\":\"17.0.0.0\", \"request\": \"GET /english/history/images/thecup.GIF HTTP/1.0\", \"status\": 200, \"size\": 1293}",
  "{\"@timestamp\": 893966413, \"clientip\":\"17.0.0.0\", \"request\": \"GET /english/history/past_cups/images/past_bu_34_off.gif HTTP/1.0\", \"status\": 200, \"size\": 397}",
  "{\"@timestamp\": 893966413, \"clientip\":\"23.0.0.0\", \"request\": \"GET /english/images/nav_team_off.gif HTTP/1.0\", \"status\": 200, \"size\": 776}",
  "{\"@timestamp\": 893966413, \"clientip\":\"12.0.0.0\", \"request\": \"GET /english/images/nav_home_off.gif HTTP/1.0\", \"status\": 200, \"size\": 828}",
  "{\"@timestamp\": 893966413, \"clientip\":\"16.0.0.0\", \"request\": \"GET /images/s102338.gif HTTP/1.0\", \"status\": 200, \"size\": 138}",
  "{\"@timestamp\": 893966413, \"clientip\":\"17.0.0.0\", \"request\": \"GET /english/history/past_cups/images/past_bu_38_off.gif HTTP/1.0\", \"status\": 200, \"size\": 436}",
  "{\"@timestamp\": 893966413, \"clientip\":\"3.0.0.0\", \"request\": \"GET /english/images/nav_sitemap_off.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966413, \"clientip\":\"23.0.0.0\", \"request\": \"GET /english/images/nav_comp_off.gif HTTP/1.0\", \"status\": 200, \"size\": 994}",
  "{\"@timestamp\": 893966413, \"clientip\":\"20.0.0.0\", \"request\": \"GET /images/11103.gif HTTP/1.0\", \"status\": 200, \"size\": 513}",
  "{\"@timestamp\": 893966413, \"clientip\":\"3.0.0.0\", \"request\": \"GET /english/images/nav_field_off.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966413, \"clientip\":\"23.0.0.0\", \"request\": \"GET /english/ProScroll.class HTTP/1.0\", \"status\": 200, \"size\": 6507}",
  "{\"@timestamp\": 893966413, \"clientip\":\"3.0.0.0\", \"request\": \"GET /english/images/nav_hosts_off.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966413, \"clientip\":\"23.0.0.0\", \"request\": \"GET /english/images/nav_store_off.gif HTTP/1.0\", \"status\": 200, \"size\": 934}",
  "{\"@timestamp\": 893966413, \"clientip\":\"3.0.0.0\", \"request\": \"GET /english/ProScroll.class HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966413, \"clientip\":\"34.0.0.0\", \"request\": \"GET /english/playing/body.html HTTP/1.0\", \"status\": 200, \"size\": 5033}",
  "{\"@timestamp\": 893966413, \"clientip\":\"19.0.0.0\", \"request\": \"GET /english/images/nav_hosts_off.gif HTTP/1.0\", \"status\": 200, \"size\": 914}",
  "{\"@timestamp\": 893966413, \"clientip\":\"3.0.0.0\", \"request\": \"GET /images/hm_brdl.gif HTTP/1.0\", \"status\": 200, \"size\": 208}",
  "{\"@timestamp\": 893966414, \"clientip\":\"35.0.0.0\", \"request\": \"GET / HTTP/1.0\", \"status\": 200, \"size\": 8712}",
  "{\"@timestamp\": 893966414, \"clientip\":\"36.0.0.0\", \"request\": \"GET /english/frntpage.htm HTTP/1.0\", \"status\": 200, \"size\": 12800}",
  "{\"@timestamp\": 893966414, \"clientip\":\"23.0.0.0\", \"request\": \"GET /english/images/nav_venue_off.gif HTTP/1.0\", \"status\": 200, \"size\": 870}",
  "{\"@timestamp\": 893966414, \"clientip\":\"23.0.0.0\", \"request\": \"GET /images/space.gif HTTP/1.0\", \"status\": 200, \"size\": 42}",
  "{\"@timestamp\": 893966414, \"clientip\":\"23.0.0.0\", \"request\": \"GET /english/images/nav_sitemap_off.gif HTTP/1.0\", \"status\": 200, \"size\": 416}",
  "{\"@timestamp\": 893966414, \"clientip\":\"20.0.0.0\", \"request\": \"GET /images/marseille.gif HTTP/1.0\", \"status\": 200, \"size\": 722}",
  "{\"@timestamp\": 893966414, \"clientip\":\"5.0.0.0\", \"request\": \"GET /images/ligne4_latebreak.gif HTTP/1.1\", \"status\": 200, \"size\": 1056}",
  "{\"@timestamp\": 893966414, \"clientip\":\"23.0.0.0\", \"request\": \"GET /images/hm_linkf.gif HTTP/1.0\", \"status\": 200, \"size\": 123}",
  "{\"@timestamp\": 893966414, \"clientip\":\"23.0.0.0\", \"request\": \"GET /english/images/nav_field_off.gif HTTP/1.0\", \"status\": 200, \"size\": 1005}",
  "{\"@timestamp\": 893966414, \"clientip\":\"23.0.0.0\", \"request\": \"GET /english/images/nav_tickets_off.gif HTTP/1.0\", \"status\": 200, \"size\": 937}",
  "{\"@timestamp\": 893966414, \"clientip\":\"23.0.0.0\", \"request\": \"GET /english/images/nav_history_off.gif HTTP/1.0\", \"status\": 200, \"size\": 914}",
  "{\"@timestamp\": 893966414, \"clientip\":\"24.0.0.0\", \"request\": \"GET /cgi-bin/trivia/Trivia.pl?ENG HTTP/1.0\", \"status\": 200, \"size\": 6228}",
  "{\"@timestamp\": 893966414, \"clientip\":\"5.0.0.0\", \"request\": \"GET /images/ligneb01.gif HTTP/1.1\", \"status\": 200, \"size\": 169}",
  "{\"@timestamp\": 893966414, \"clientip\":\"12.0.0.0\", \"request\": \"GET /english/tickets/body.html HTTP/1.0\", \"status\": 200, \"size\": 2925}",
  "{\"@timestamp\": 893966414, \"clientip\":\"23.0.0.0\", \"request\": \"GET /english/images/nav_hosts_off.gif HTTP/1.0\", \"status\": 200, \"size\": 914}",
  "{\"@timestamp\": 893966414, \"clientip\":\"17.0.0.0\", \"request\": \"GET /english/history/past_cups/images/past_bu_50_on.gif HTTP/1.0\", \"status\": 200, \"size\": 455}",
  "{\"@timestamp\": 893966414, \"clientip\":\"23.0.0.0\", \"request\": \"GET /images/hm_anime_e.gif HTTP/1.0\", \"status\": 200, \"size\": 15609}",
  "{\"@timestamp\": 893966414, \"clientip\":\"3.0.0.0\", \"request\": \"GET /english/images/nav_history_off.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966414, \"clientip\":\"37.0.0.0\", \"request\": \"GET /french/competition/schedule.htm HTTP/1.0\", \"status\": 200, \"size\": 49256}",
  "{\"@timestamp\": 893966414, \"clientip\":\"3.0.0.0\", \"request\": \"GET /images/hm_brdr.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966414, \"clientip\":\"26.0.0.0\", \"request\": \"GET /english/images/nav_history_off.gif HTTP/1.0\", \"status\": 200, \"size\": 914}",
  "{\"@timestamp\": 893966414, \"clientip\":\"232.41.0.0\", \"request\": \"GET / HTTP/1.0\", \"status\": 200, \"size\": 8749}",
  "{\"@timestamp\": 893966415, \"clientip\":\"232.41.0.0\", \"request\": \"GET /images/home_tool.gif HTTP/1.0\", \"status\": 200, \"size\": 327}",
  "{\"@timestamp\": 893966415, \"clientip\":\"19.0.0.0\", \"request\": \"GET /english/images/nav_home_off.gif HTTP/1.0\", \"status\": 200, \"size\": 828}",
  "{\"@timestamp\": 893966415, \"clientip\":\"17.0.0.0\", \"request\": \"GET /english/history/past_cups/images/past_bu_58_off.gif HTTP/1.0\", \"status\": 200, \"size\": 397}",
  "{\"@timestamp\": 893966415, \"clientip\":\"12.0.0.0\", \"request\": \"GET /english/tickets/images/ticket_hm_bg.jpg HTTP/1.0\", \"status\": 200, \"size\": 20929}",
  "{\"@timestamp\": 893966415, \"clientip\":\"12.0.0.0\", \"request\": \"GET /english/tickets/images/ticket_hm_header.gif HTTP/1.0\", \"status\": 200, \"size\": 1226}",
  "{\"@timestamp\": 893966415, \"clientip\":\"12.0.0.0\", \"request\": \"GET /english/tickets/images/ticket_hm_nav.gif HTTP/1.0\", \"status\": 200, \"size\": 11253}",
  "{\"@timestamp\": 893966415, \"clientip\":\"12.0.0.0\", \"request\": \"GET /images/arw_red_lk.gif HTTP/1.0\", \"status\": 200, \"size\": 1068}",
  "{\"@timestamp\": 893966415, \"clientip\":\"23.0.0.0\", \"request\": \"GET /english/images/nav_home_off.gif HTTP/1.0\", \"status\": 200, \"size\": 828}",
  "{\"@timestamp\": 893966415, \"clientip\":\"23.0.0.0\", \"request\": \"GET /english/images/nav_logo_sponsors.gif HTTP/1.0\", \"status\": 200, \"size\": 1991}",
  "{\"@timestamp\": 893966415, \"clientip\":\"21.0.0.0\", \"request\": \"GET /english/images/news_hm_header.gif HTTP/1.1\", \"status\": 200, \"size\": 527}",
  "{\"@timestamp\": 893966415, \"clientip\":\"21.0.0.0\", \"request\": \"GET /images/bg_generic.jpg HTTP/1.1\", \"status\": 200, \"size\": 21127}",
  "{\"@timestamp\": 893966415, \"clientip\":\"38.0.0.0\", \"request\": \"GET /english/teams/teamgroup.htm HTTP/1.0\", \"status\": 200, \"size\": 11971}",
  "{\"@timestamp\": 893966415, \"clientip\":\"21.0.0.0\", \"request\": \"GET /english/images/space.gif HTTP/1.1\", \"status\": 200, \"size\": 42}",
  "{\"@timestamp\": 893966415, \"clientip\":\"23.0.0.0\", \"request\": \"GET /images/info.gif HTTP/1.0\", \"status\": 200, \"size\": 1251}",
  "{\"@timestamp\": 893966415, \"clientip\":\"34.0.0.0\", \"request\": \"GET /english/playing/images/play_hm_bg_opt1.jpg HTTP/1.0\", \"status\": 200, \"size\": 44502}",
  "{\"@timestamp\": 893966415, \"clientip\":\"5.0.0.0\", \"request\": \"GET /images/ligne.gif HTTP/1.1\", \"status\": 200, \"size\": 169}",
  "{\"@timestamp\": 893966415, \"clientip\":\"3.0.0.0\", \"request\": \"GET /english/images/nav_logo_sponsors.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966415, \"clientip\":\"12.0.0.0\", \"request\": \"GET /images/arw_lk.gif HTTP/1.0\", \"status\": 200, \"size\": 669}",
  "{\"@timestamp\": 893966415, \"clientip\":\"19.0.0.0\", \"request\": \"GET /english/images/nav_history_off.gif HTTP/1.0\", \"status\": 200, \"size\": 914}",
  "{\"@timestamp\": 893966415, \"clientip\":\"35.0.0.0\", \"request\": \"GET /images/home_bg_stars.gif HTTP/1.0\", \"status\": 200, \"size\": 2557}",
  "{\"@timestamp\": 893966416, \"clientip\":\"23.0.0.0\", \"request\": \"GET /images/hm_brdl.gif HTTP/1.0\", \"status\": 200, \"size\": 208}",
  "{\"@timestamp\": 893966416, \"clientip\":\"5.0.0.0\", \"request\": \"GET /french/images/news_btn_kits_off.gif HTTP/1.1\", \"status\": 200, \"size\": 965}",
  "{\"@timestamp\": 893966416, \"clientip\":\"23.0.0.0\", \"request\": \"GET /images/space.gif HTTP/1.0\", \"status\": 200, \"size\": 42}",
  "{\"@timestamp\": 893966416, \"clientip\":\"23.0.0.0\", \"request\": \"GET /english/images/hm_official.gif HTTP/1.0\", \"status\": 200, \"size\": 1807}",
  "{\"@timestamp\": 893966416, \"clientip\":\"23.0.0.0\", \"request\": \"GET /images/hm_arw.gif HTTP/1.0\", \"status\": 200, \"size\": 1050}",
  "{\"@timestamp\": 893966416, \"clientip\":\"19.0.0.0\", \"request\": \"GET /english/images/nav_sitemap_off.gif HTTP/1.0\", \"status\": 200, \"size\": 416}",
  "{\"@timestamp\": 893966416, \"clientip\":\"17.0.0.0\", \"request\": \"GET /english/history/past_cups/images/past_bu_62_off.gif HTTP/1.0\", \"status\": 200, \"size\": 437}",
  "{\"@timestamp\": 893966416, \"clientip\":\"23.0.0.0\", \"request\": \"GET /images/hm_day_e.gif HTTP/1.0\", \"status\": 200, \"size\": 499}",
  "{\"@timestamp\": 893966416, \"clientip\":\"17.0.0.0\", \"request\": \"GET /english/history/past_cups/images/past_bu_66_off.gif HTTP/1.0\", \"status\": 200, \"size\": 435}",
  "{\"@timestamp\": 893966416, \"clientip\":\"17.0.0.0\", \"request\": \"GET /english/history/past_cups/images/past_bu_70_off.gif HTTP/1.0\", \"status\": 200, \"size\": 409}",
  "{\"@timestamp\": 893966416, \"clientip\":\"39.0.0.0\", \"request\": \"GET /english/history/images/history_hm_header.gif HTTP/1.1\", \"status\": 200, \"size\": 688}",
  "{\"@timestamp\": 893966416, \"clientip\":\"39.0.0.0\", \"request\": \"GET /english/history/images/history_hm_posters.jpg HTTP/1.1\", \"status\": 200, \"size\": 33296}",
  "{\"@timestamp\": 893966416, \"clientip\":\"201.0.0.0\", \"request\": \"GET /images/hm_bg.jpg HTTP/1.0\", \"status\": 200, \"size\": 24736}",
  "{\"@timestamp\": 893966417, \"clientip\":\"25.0.0.0\", \"request\": \"GET /images/home_eng_button.gif HTTP/1.1\", \"status\": 200, \"size\": 1927}",
  "{\"@timestamp\": 893966417, \"clientip\":\"23.0.0.0\", \"request\": \"GET /images/dot.gif HTTP/1.0\", \"status\": 200, \"size\": 43}",
  "{\"@timestamp\": 893966417, \"clientip\":\"17.0.0.0\", \"request\": \"GET /english/history/past_cups/images/past_bu_74_off.gif HTTP/1.0\", \"status\": 200, \"size\": 423}",
  "{\"@timestamp\": 893966417, \"clientip\":\"1.0.0.0\", \"request\": \"GET /english/index.html HTTP/1.0\", \"status\": 200, \"size\": 892}",
  "{\"@timestamp\": 893966417, \"clientip\":\"5.0.0.0\", \"request\": \"GET /images/ligneb.gif HTTP/1.1\", \"status\": 200, \"size\": 169}",
  "{\"@timestamp\": 893966417, \"clientip\":\"35.0.0.0\", \"request\": \"GET /images/home_eng_phrase.gif HTTP/1.0\", \"status\": 200, \"size\": 2861}",
  "{\"@timestamp\": 893966417, \"clientip\":\"35.0.0.0\", \"request\": \"GET /images/home_fr_button.gif HTTP/1.0\", \"status\": 200, \"size\": 2140}",
  "{\"@timestamp\": 893966417, \"clientip\":\"35.0.0.0\", \"request\": \"GET /images/home_tool.gif HTTP/1.0\", \"status\": 200, \"size\": 327}",
  "{\"@timestamp\": 893966417, \"clientip\":\"35.0.0.0\", \"request\": \"GET /images/home_sponsor.gif HTTP/1.0\", \"status\": 200, \"size\": 2491}",
  "{\"@timestamp\": 893966417, \"clientip\":\"35.0.0.0\", \"request\": \"GET /images/home_eng_button.gif HTTP/1.0\", \"status\": 200, \"size\": 1927}",
  "{\"@timestamp\": 893966417, \"clientip\":\"17.0.0.0\", \"request\": \"GET /english/history/past_cups/images/past_bu_78_off.gif HTTP/1.0\", \"status\": 200, \"size\": 427}",
  "{\"@timestamp\": 893966417, \"clientip\":\"16.0.0.0\", \"request\": \"GET /english/images/team_group_header_d.gif HTTP/1.0\", \"status\": 200, \"size\": 646}",
  "{\"@timestamp\": 893966418, \"clientip\":\"17.0.0.0\", \"request\": \"GET /english/history/past_cups/images/past_bu_82_off.gif HTTP/1.0\", \"status\": 200, \"size\": 433}",
  "{\"@timestamp\": 893966418, \"clientip\":\"40.0.0.0\", \"request\": \"GET /english/history/past_cups/italy34.html HTTP/1.1\", \"status\": 200, \"size\": 13022}",
  "{\"@timestamp\": 893966418, \"clientip\":\"17.0.0.0\", \"request\": \"GET /english/history/past_cups/images/past_bu_86_off.gif HTTP/1.0\", \"status\": 200, \"size\": 409}",
  "{\"@timestamp\": 893966418, \"clientip\":\"19.0.0.0\", \"request\": \"GET /english/images/nav_store_off.gif HTTP/1.0\", \"status\": 200, \"size\": 934}",
  "{\"@timestamp\": 893966418, \"clientip\":\"1.0.0.0\", \"request\": \"GET /english/index.html HTTP/1.0\", \"status\": 200, \"size\": 892}",
  "{\"@timestamp\": 893966418, \"clientip\":\"37.0.0.0\", \"request\": \"GET /french/images/space.gif HTTP/1.0\", \"status\": 200, \"size\": 42}",
  "{\"@timestamp\": 893966418, \"clientip\":\"19.0.0.0\", \"request\": \"GET /english/images/nav_tickets_off.gif HTTP/1.0\", \"status\": 200, \"size\": 937}",
  "{\"@timestamp\": 893966418, \"clientip\":\"19.0.0.0\", \"request\": \"GET /english/images/nav_logo_sponsors.gif HTTP/1.0\", \"status\": 200, \"size\": 1991}",
  "{\"@timestamp\": 893966418, \"clientip\":\"8.0.0.0\", \"request\": \"GET /english/images/comp_bu_groupsn_on.gif HTTP/1.0\", \"status\": 200, \"size\": 963}",
  "{\"@timestamp\": 893966418, \"clientip\":\"22.0.0.0\", \"request\": \"GET /english/images/team_bu_detail2.gif HTTP/1.0\", \"status\": 200, \"size\": 1438}",
  "{\"@timestamp\": 893966418, \"clientip\":\"17.0.0.0\", \"request\": \"GET /english/history/past_cups/images/past_bu_90_off.gif HTTP/1.0\", \"status\": 200, \"size\": 429}",
  "{\"@timestamp\": 893966418, \"clientip\":\"38.0.0.0\", \"request\": \"GET /english/images/teams_bu_group_on.gif HTTP/1.0\", \"status\": 200, \"size\": 668}",
  "{\"@timestamp\": 893966419, \"clientip\":\"20.0.0.0\", \"request\": \"GET /images/nantes.gif HTTP/1.0\", \"status\": 200, \"size\": 677}",
  "{\"@timestamp\": 893966419, \"clientip\":\"16.0.0.0\", \"request\": \"GET /images/s102326.gif HTTP/1.0\", \"status\": 200, \"size\": 248}",
  "{\"@timestamp\": 893966419, \"clientip\":\"17.0.0.0\", \"request\": \"GET /english/history/past_cups/images/past_bu_94_off.gif HTTP/1.0\", \"status\": 200, \"size\": 432}",
  "{\"@timestamp\": 893966419, \"clientip\":\"1.0.0.0\", \"request\": \"GET /english/nav_top_inet.html HTTP/1.0\", \"status\": 200, \"size\": 374}",
  "{\"@timestamp\": 893966419, \"clientip\":\"17.0.0.0\", \"request\": \"GET /english/history/past_cups/images/past_bracket_top.gif HTTP/1.0\", \"status\": 200, \"size\": 289}",
  "{\"@timestamp\": 893966419, \"clientip\":\"20.0.0.0\", \"request\": \"GET /images/saintetienne.gif HTTP/1.0\", \"status\": 200, \"size\": 761}",
  "{\"@timestamp\": 893966419, \"clientip\":\"20.0.0.0\", \"request\": \"GET /images/11287.jpg HTTP/1.0\", \"status\": 200, \"size\": 6431}",
  "{\"@timestamp\": 893966420, \"clientip\":\"17.0.0.0\", \"request\": \"GET /english/history/past_cups/images/posters/brasil50.gif HTTP/1.0\", \"status\": 200, \"size\": 5003}",
  "{\"@timestamp\": 893966420, \"clientip\":\"20.0.0.0\", \"request\": \"GET /images/lens.gif HTTP/1.0\", \"status\": 200, \"size\": 582}",
  "{\"@timestamp\": 893966420, \"clientip\":\"17.0.0.0\", \"request\": \"GET /english/history/past_cups/images/past_bracket_bot.gif HTTP/1.0\", \"status\": 200, \"size\": 631}",
  "{\"@timestamp\": 893966420, \"clientip\":\"17.0.0.0\", \"request\": \"GET /english/history/past_cups/images/past_trophy.gif HTTP/1.0\", \"status\": 200, \"size\": 800}",
  "{\"@timestamp\": 893966420, \"clientip\":\"41.0.0.0\", \"request\": \"GET /images/col.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966421, \"clientip\":\"17.0.0.0\", \"request\": \"GET /english/history/past_cups/images/50-1.jpg HTTP/1.0\", \"status\": 200, \"size\": 15314}",
  "{\"@timestamp\": 893966421, \"clientip\":\"1.0.0.0\", \"request\": \"GET /images/hm_nbg.jpg HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966421, \"clientip\":\"40.0.0.0\", \"request\": \"GET /english/history/past_cups/images/past_bu_30_off.gif HTTP/1.1\", \"status\": 200, \"size\": 406}",
  "{\"@timestamp\": 893966421, \"clientip\":\"40.0.0.0\", \"request\": \"GET /english/history/past_cups/images/past_bu_34_on.gif HTTP/1.1\", \"status\": 200, \"size\": 474}",
  "{\"@timestamp\": 893966421, \"clientip\":\"16.0.0.0\", \"request\": \"GET /images/s102477.gif HTTP/1.0\", \"status\": 200, \"size\": 214}",
  "{\"@timestamp\": 893966421, \"clientip\":\"26.0.0.0\", \"request\": \"GET /english/images/nav_hosts_off.gif HTTP/1.0\", \"status\": 200, \"size\": 914}",
  "{\"@timestamp\": 893966421, \"clientip\":\"26.0.0.0\", \"request\": \"GET /english/images/nav_store_off.gif HTTP/1.0\", \"status\": 200, \"size\": 934}",
  "{\"@timestamp\": 893966421, \"clientip\":\"8.0.0.0\", \"request\": \"GET /english/teams/teamgroup.htm HTTP/1.0\", \"status\": 200, \"size\": 11971}",
  "{\"@timestamp\": 893966421, \"clientip\":\"38.0.0.0\", \"request\": \"GET /images/s102325.gif HTTP/1.0\", \"status\": 200, \"size\": 187}",
  "{\"@timestamp\": 893966422, \"clientip\":\"15.0.0.0\", \"request\": \"GET /english/playing/links.html HTTP/1.0\", \"status\": 200, \"size\": 18694}",
  "{\"@timestamp\": 893966422, \"clientip\":\"40.0.0.0\", \"request\": \"GET /english/history/past_cups/images/34-1.jpg HTTP/1.1\", \"status\": 200, \"size\": 14275}",
  "{\"@timestamp\": 893966422, \"clientip\":\"8.0.0.0\", \"request\": \"GET /images/teams_hm_bg.jpg HTTP/1.0\", \"status\": 200, \"size\": 18794}",
  "{\"@timestamp\": 893966422, \"clientip\":\"42.0.0.0\", \"request\": \"GET /english/frntpage.htm HTTP/1.0\", \"status\": 200, \"size\": 12800}",
  "{\"@timestamp\": 893966422, \"clientip\":\"25.0.0.0\", \"request\": \"GET /images/home_sponsor.gif HTTP/1.1\", \"status\": 200, \"size\": 2491}",
  "{\"@timestamp\": 893966422, \"clientip\":\"8.0.0.0\", \"request\": \"GET /english/images/team_group_header_a.gif HTTP/1.0\", \"status\": 200, \"size\": 639}",
  "{\"@timestamp\": 893966422, \"clientip\":\"8.0.0.0\", \"request\": \"GET /english/images/teams_bu_group_on.gif HTTP/1.0\", \"status\": 200, \"size\": 668}",
  "{\"@timestamp\": 893966422, \"clientip\":\"8.0.0.0\", \"request\": \"GET /english/images/teams_bu_confed_off.gif HTTP/1.0\", \"status\": 200, \"size\": 1105}",
  "{\"@timestamp\": 893966422, \"clientip\":\"43.0.0.0\", \"request\": \"GET /english/individuals/player111722.htm HTTP/1.0\", \"status\": 200, \"size\": 6523}",
  "{\"@timestamp\": 893966423, \"clientip\":\"20.0.0.0\", \"request\": \"GET /images/montpellier.gif HTTP/1.0\", \"status\": 200, \"size\": 728}",
  "{\"@timestamp\": 893966423, \"clientip\":\"12.0.0.0\", \"request\": \"GET /english/tickets/out_france.html HTTP/1.0\", \"status\": 200, \"size\": 6143}",
  "{\"@timestamp\": 893966423, \"clientip\":\"20.0.0.0\", \"request\": \"GET /images/11105.gif HTTP/1.0\", \"status\": 200, \"size\": 114}",
  "{\"@timestamp\": 893966423, \"clientip\":\"12.0.0.0\", \"request\": \"GET /english/tickets/images/ticket_quest_bg2.jpg HTTP/1.0\", \"status\": 200, \"size\": 11324}",
  "{\"@timestamp\": 893966423, \"clientip\":\"12.0.0.0\", \"request\": \"GET /english/tickets/images/ticket_header.gif HTTP/1.0\", \"status\": 200, \"size\": 453}",
  "{\"@timestamp\": 893966423, \"clientip\":\"12.0.0.0\", \"request\": \"GET /english/tickets/images/hm_f98_top.gif HTTP/1.0\", \"status\": 200, \"size\": 1647}",
  "{\"@timestamp\": 893966423, \"clientip\":\"21.0.0.0\", \"request\": \"GET /english/images/news_bu_press_off.gif HTTP/1.1\", \"status\": 200, \"size\": 847}",
  "{\"@timestamp\": 893966423, \"clientip\":\"44.0.0.0\", \"request\": \"GET /english/teams/teambio169.htm HTTP/1.1\", \"status\": 200, \"size\": 11157}",
  "{\"@timestamp\": 893966423, \"clientip\":\"38.0.0.0\", \"request\": \"GET /images/s102327.gif HTTP/1.0\", \"status\": 200, \"size\": 97}",
  "{\"@timestamp\": 893966423, \"clientip\":\"21.0.0.0\", \"request\": \"GET /english/images/news_bu_letter_off.gif HTTP/1.1\", \"status\": 200, \"size\": 940}",
  "{\"@timestamp\": 893966423, \"clientip\":\"45.0.0.0\", \"request\": \"GET /english/frntpage.htm HTTP/1.1\", \"status\": 200, \"size\": 12800}",
  "{\"@timestamp\": 893966423, \"clientip\":\"32.0.0.0\", \"request\": \"GET /english/nav_inet.html HTTP/1.1\", \"status\": 200, \"size\": 2672}",
  "{\"@timestamp\": 893966423, \"clientip\":\"15.0.0.0\", \"request\": \"GET /english/playing/images/backg.gif HTTP/1.0\", \"status\": 200, \"size\": 1462}",
  "{\"@timestamp\": 893966423, \"clientip\":\"15.0.0.0\", \"request\": \"GET /english/playing/images/play_header.gif HTTP/1.0\", \"status\": 200, \"size\": 2262}",
  "{\"@timestamp\": 893966423, \"clientip\":\"20.0.0.0\", \"request\": \"GET /images/paris_off.gif HTTP/1.0\", \"status\": 200, \"size\": 658}",
  "{\"@timestamp\": 893966423, \"clientip\":\"8.0.0.0\", \"request\": \"GET /images/teams_hm_bracket.gif HTTP/1.0\", \"status\": 200, \"size\": 655}",
  "{\"@timestamp\": 893966424, \"clientip\":\"8.0.0.0\", \"request\": \"GET /english/images/team_group_header_c.gif HTTP/1.0\", \"status\": 200, \"size\": 670}",
  "{\"@timestamp\": 893966424, \"clientip\":\"29.0.0.0\", \"request\": \"GET /images/32t49811.jpg HTTP/1.0\", \"status\": 200, \"size\": 4753}",
  "{\"@timestamp\": 893966424, \"clientip\":\"37.0.0.0\", \"request\": \"GET /images/cal-lens.gif HTTP/1.0\", \"status\": 200, \"size\": 284}",
  "{\"@timestamp\": 893966424, \"clientip\":\"40.0.0.0\", \"request\": \"GET /english/history/past_cups/images/posters/italy34.gif HTTP/1.1\", \"status\": 200, \"size\": 4474}",
  "{\"@timestamp\": 893966424, \"clientip\":\"12.0.0.0\", \"request\": \"GET /english/tickets/images/ticket_bu_quest2.gif HTTP/1.0\", \"status\": 200, \"size\": 1201}",
  "{\"@timestamp\": 893966424, \"clientip\":\"38.0.0.0\", \"request\": \"GET /images/s102424.gif HTTP/1.0\", \"status\": 200, \"size\": 164}",
  "{\"@timestamp\": 893966424, \"clientip\":\"20.0.0.0\", \"request\": \"GET /images/11102.gif HTTP/1.0\", \"status\": 200, \"size\": 417}",
  "{\"@timestamp\": 893966424, \"clientip\":\"15.0.0.0\", \"request\": \"GET /english/playing/images/france98b.GIF HTTP/1.0\", \"status\": 200, \"size\": 597}",
  "{\"@timestamp\": 893966424, \"clientip\":\"39.0.0.0\", \"request\": \"GET /english/history/images/france98b.GIF HTTP/1.1\", \"status\": 200, \"size\": 915}",
  "{\"@timestamp\": 893966424, \"clientip\":\"39.0.0.0\", \"request\": \"GET /english/history/images/football.GIF HTTP/1.1\", \"status\": 200, \"size\": 1170}",
  "{\"@timestamp\": 893966424, \"clientip\":\"46.0.0.0\", \"request\": \"GET /english/venues/venues/saint-denis.html HTTP/1.0\", \"status\": 200, \"size\": 22760}",
  "{\"@timestamp\": 893966425, \"clientip\":\"12.0.0.0\", \"request\": \"GET /english/tickets/images/ticket_bu_abroad2_on.gif HTTP/1.0\", \"status\": 200, \"size\": 2020}",
  "{\"@timestamp\": 893966425, \"clientip\":\"47.0.0.0\", \"request\": \"GET / HTTP/1.0\", \"status\": 200, \"size\": 8712}",
  "{\"@timestamp\": 893966425, \"clientip\":\"12.0.0.0\", \"request\": \"GET /english/tickets/images/ticket_abroad_header.gif HTTP/1.0\", \"status\": 200, \"size\": 3606}",
  "{\"@timestamp\": 893966425, \"clientip\":\"15.0.0.0\", \"request\": \"GET /english/playing/images/mascots.GIF HTTP/1.0\", \"status\": 200, \"size\": 1275}",
  "{\"@timestamp\": 893966425, \"clientip\":\"44.0.0.0\", \"request\": \"GET /images/10512.jpg HTTP/1.1\", \"status\": 200, \"size\": 17227}",
  "{\"@timestamp\": 893966425, \"clientip\":\"44.0.0.0\", \"request\": \"GET /images/32t49809.jpg HTTP/1.1\", \"status\": 200, \"size\": 5623}",
  "{\"@timestamp\": 893966425, \"clientip\":\"32.0.0.0\", \"request\": \"GET /images/nav_bg_bottom.jpg HTTP/1.1\", \"status\": 200, \"size\": 8389}",
  "{\"@timestamp\": 893966425, \"clientip\":\"12.0.0.0\", \"request\": \"GET /english/tickets/images/ticket_bu_infrance2.gif HTTP/1.0\", \"status\": 200, \"size\": 1134}",
  "{\"@timestamp\": 893966425, \"clientip\":\"43.0.0.0\", \"request\": \"GET /images/32p49815.jpg HTTP/1.0\", \"status\": 200, \"size\": 11735}",
  "{\"@timestamp\": 893966425, \"clientip\":\"43.0.0.0\", \"request\": \"GET /english/images/team_bu_detail_off.gif HTTP/1.0\", \"status\": 200, \"size\": 918}",
  "{\"@timestamp\": 893966425, \"clientip\":\"44.0.0.0\", \"request\": \"GET /images/esp.gif HTTP/1.1\", \"status\": 200, \"size\": 1892}",
  "{\"@timestamp\": 893966425, \"clientip\":\"38.0.0.0\", \"request\": \"GET /english/images/team_group_header_a.gif HTTP/1.0\", \"status\": 200, \"size\": 639}",
  "{\"@timestamp\": 893966425, \"clientip\":\"48.0.0.0\", \"request\": \"GET /english/help/site.html HTTP/1.0\", \"status\": 200, \"size\": 7697}",
  "{\"@timestamp\": 893966425, \"clientip\":\"15.0.0.0\", \"request\": \"GET /english/playing/images/downloads.GIF HTTP/1.0\", \"status\": 200, \"size\": 1294}",
  "{\"@timestamp\": 893966426, \"clientip\":\"37.0.0.0\", \"request\": \"GET /french/images/comp_bu_stage1n.gif HTTP/1.0\", \"status\": 200, \"size\": 1547}",
  "{\"@timestamp\": 893966426, \"clientip\":\"25.0.0.0\", \"request\": \"GET /french/index.html HTTP/1.1\", \"status\": 200, \"size\": 954}",
  "{\"@timestamp\": 893966426, \"clientip\":\"21.0.0.0\", \"request\": \"GET /english/images/news_bu_kits_off.gif HTTP/1.1\", \"status\": 200, \"size\": 1027}",
  "{\"@timestamp\": 893966426, \"clientip\":\"15.0.0.0\", \"request\": \"GET /english/playing/images/links_on.GIF HTTP/1.0\", \"status\": 200, \"size\": 1393}",
  "{\"@timestamp\": 893966426, \"clientip\":\"15.0.0.0\", \"request\": \"GET /english/playing/images/trivia.GIF HTTP/1.0\", \"status\": 200, \"size\": 999}",
  "{\"@timestamp\": 893966426, \"clientip\":\"0.0.0.0\", \"request\": \"GET /english/index.html HTTP/1.0\", \"status\": 200, \"size\": 892}",
  "{\"@timestamp\": 893966426, \"clientip\":\"32.0.0.0\", \"request\": \"GET /english/nav_top_inet.html HTTP/1.1\", \"status\": 200, \"size\": 374}",
  "{\"@timestamp\": 893966427, \"clientip\":\"46.0.0.0\", \"request\": \"GET /english/venues/cities/images/denis/venue_denn_bg.jpg HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966427, \"clientip\":\"8.0.0.0\", \"request\": \"GET /english/images/team_hm_header_shad.gif HTTP/1.0\", \"status\": 200, \"size\": 1379}",
  "{\"@timestamp\": 893966427, \"clientip\":\"46.0.0.0\", \"request\": \"GET /images/11295.jpg HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966427, \"clientip\":\"46.0.0.0\", \"request\": \"GET /images/11294.jpg HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966427, \"clientip\":\"8.0.0.0\", \"request\": \"GET /english/images/team_group_header_b.gif HTTP/1.0\", \"status\": 200, \"size\": 665}",
  "{\"@timestamp\": 893966427, \"clientip\":\"38.0.0.0\", \"request\": \"GET /images/s102330.gif HTTP/1.0\", \"status\": 200, \"size\": 259}",
  "{\"@timestamp\": 893966427, \"clientip\":\"15.0.0.0\", \"request\": \"GET /english/playing/images/banner2.gif HTTP/1.0\", \"status\": 200, \"size\": 15328}",
  "{\"@timestamp\": 893966427, \"clientip\":\"49.0.0.0\", \"request\": \"GET /english/news/2704nevi.htm HTTP/1.0\", \"status\": 200, \"size\": 3132}",
  "{\"@timestamp\": 893966427, \"clientip\":\"38.0.0.0\", \"request\": \"GET /english/images/team_group_header_b.gif HTTP/1.0\", \"status\": 200, \"size\": 665}",
  "{\"@timestamp\": 893966427, \"clientip\":\"15.0.0.0\", \"request\": \"GET /english/playing/images/fifa_logo_sm.gif HTTP/1.0\", \"status\": 200, \"size\": 2900}",
  "{\"@timestamp\": 893966427, \"clientip\":\"39.0.0.0\", \"request\": \"GET /english/history/images/infrance.GIF HTTP/1.1\", \"status\": 200, \"size\": 990}",
  "{\"@timestamp\": 893966427, \"clientip\":\"47.135.0.0\", \"request\": \"GET /french/news/3004bres.htm HTTP/1.0\", \"status\": 200, \"size\": 5933}",
  "{\"@timestamp\": 893966428, \"clientip\":\"50.0.0.0\", \"request\": \"GET /english/playing/download/images/big.bird.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966428, \"clientip\":\"8.0.0.0\", \"request\": \"GET /english/images/team_group_header_e.gif HTTP/1.0\", \"status\": 200, \"size\": 643}",
  "{\"@timestamp\": 893966429, \"clientip\":\"41.0.0.0\", \"request\": \"GET /english/images/team_bu_detail_on.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966429, \"clientip\":\"30.0.0.0\", \"request\": \"GET /english/playing/mascot/images/misc.gif HTTP/1.0\", \"status\": 200, \"size\": 2997}",
  "{\"@timestamp\": 893966429, \"clientip\":\"8.0.0.0\", \"request\": \"GET /english/images/team_group_header_g.gif HTTP/1.0\", \"status\": 200, \"size\": 641}",
  "{\"@timestamp\": 893966429, \"clientip\":\"38.0.0.0\", \"request\": \"GET /images/s102382.gif HTTP/1.0\", \"status\": 200, \"size\": 102}",
  "{\"@timestamp\": 893966429, \"clientip\":\"12.0.0.0\", \"request\": \"GET /english/tickets/10484.htm HTTP/1.0\", \"status\": 200, \"size\": 16722}",
  "{\"@timestamp\": 893966429, \"clientip\":\"8.0.0.0\", \"request\": \"GET /english/images/team_group_header_h.gif HTTP/1.0\", \"status\": 200, \"size\": 628}",
  "{\"@timestamp\": 893966429, \"clientip\":\"12.0.0.0\", \"request\": \"GET /english/tickets/images/ticket_bu_abroad2.gif HTTP/1.0\", \"status\": 200, \"size\": 1486}",
  "{\"@timestamp\": 893966430, \"clientip\":\"12.0.0.0\", \"request\": \"GET /images/11103.gif HTTP/1.0\", \"status\": 200, \"size\": 513}",
  "{\"@timestamp\": 893966430, \"clientip\":\"8.0.0.0\", \"request\": \"GET /english/images/team_group_header_d.gif HTTP/1.0\", \"status\": 200, \"size\": 646}",
  "{\"@timestamp\": 893966430, \"clientip\":\"5.0.0.0\", \"request\": \"GET /french/images/archives.gif HTTP/1.1\", \"status\": 200, \"size\": 569}",
  "{\"@timestamp\": 893966430, \"clientip\":\"39.0.0.0\", \"request\": \"GET /english/history/images/reading.GIF HTTP/1.1\", \"status\": 200, \"size\": 1171}",
  "{\"@timestamp\": 893966430, \"clientip\":\"32.0.0.0\", \"request\": \"GET /english/ProScroll.class HTTP/1.1\", \"status\": 200, \"size\": 6507}",
  "{\"@timestamp\": 893966430, \"clientip\":\"8.0.0.0\", \"request\": \"GET /english/images/team_group_header_f.gif HTTP/1.0\", \"status\": 200, \"size\": 631}",
  "{\"@timestamp\": 893966430, \"clientip\":\"26.0.0.0\", \"request\": \"GET /english/images/nav_sitemap_off.gif HTTP/1.0\", \"status\": 200, \"size\": 416}",
  "{\"@timestamp\": 893966430, \"clientip\":\"47.135.0.0\", \"request\": \"GET /images/bord_g.gif HTTP/1.0\", \"status\": 200, \"size\": 231}",
  "{\"@timestamp\": 893966430, \"clientip\":\"47.135.0.0\", \"request\": \"GET /images/bord_d.gif HTTP/1.0\", \"status\": 200, \"size\": 231}",
  "{\"@timestamp\": 893966431, \"clientip\":\"12.0.0.0\", \"request\": \"GET /images/10982.gif HTTP/1.0\", \"status\": 200, \"size\": 183}",
  "{\"@timestamp\": 893966431, \"clientip\":\"38.0.0.0\", \"request\": \"GET /images/s102373.gif HTTP/1.0\", \"status\": 200, \"size\": 142}",
  "{\"@timestamp\": 893966431, \"clientip\":\"38.0.0.0\", \"request\": \"GET /images/s102328.gif HTTP/1.0\", \"status\": 200, \"size\": 236}",
  "{\"@timestamp\": 893966431, \"clientip\":\"39.0.0.0\", \"request\": \"GET /english/history/past_cups/images/past_header.gif HTTP/1.1\", \"status\": 200, \"size\": 1989}",
  "{\"@timestamp\": 893966431, \"clientip\":\"51.0.0.0\", \"request\": \"GET /english/teams/teambio160.htm HTTP/1.1\", \"status\": 200, \"size\": 11097}",
  "{\"@timestamp\": 893966431, \"clientip\":\"38.0.0.0\", \"request\": \"GET /english/images/team_group_header_f.gif HTTP/1.0\", \"status\": 200, \"size\": 631}",
  "{\"@timestamp\": 893966431, \"clientip\":\"52.0.0.0\", \"request\": \"GET /english/member/body.html HTTP/1.1\", \"status\": 200, \"size\": 5097}",
  "{\"@timestamp\": 893966432, \"clientip\":\"10.0.0.0\", \"request\": \"GET /english/competition/stage2.htm HTTP/1.0\", \"status\": 200, \"size\": 16606}",
  "{\"@timestamp\": 893966432, \"clientip\":\"0.0.0.0\", \"request\": \"GET /english/nav_top_inet.html HTTP/1.0\", \"status\": 200, \"size\": 374}",
  "{\"@timestamp\": 893966432, \"clientip\":\"53.0.0.0\", \"request\": \"GET /english/competition/headtohead75.htm HTTP/1.1\", \"status\": 200, \"size\": 5152}",
  "{\"@timestamp\": 893966432, \"clientip\":\"25.0.0.0\", \"request\": \"GET /french/nav_top_inet.html HTTP/1.1\", \"status\": 200, \"size\": 374}",
  "{\"@timestamp\": 893966432, \"clientip\":\"0.0.0.0\", \"request\": \"GET /english/nav_inet.html HTTP/1.0\", \"status\": 200, \"size\": 2672}",
  "{\"@timestamp\": 893966432, \"clientip\":\"0.0.0.0\", \"request\": \"GET /english/splash_inet.html HTTP/1.0\", \"status\": 200, \"size\": 3730}",
  "{\"@timestamp\": 893966432, \"clientip\":\"39.0.0.0\", \"request\": \"GET /english/history/images/history_hm_header.gif HTTP/1.1\", \"status\": 200, \"size\": 688}",
  "{\"@timestamp\": 893966432, \"clientip\":\"47.0.0.0\", \"request\": \"GET /english/index.html HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966432, \"clientip\":\"37.0.0.0\", \"request\": \"GET /images/cal_nant.gif HTTP/1.0\", \"status\": 200, \"size\": 359}",
  "{\"@timestamp\": 893966432, \"clientip\":\"37.0.0.0\", \"request\": \"GET /images/cal_stdenis.gif HTTP/1.0\", \"status\": 200, \"size\": 402}",
  "{\"@timestamp\": 893966432, \"clientip\":\"41.0.0.0\", \"request\": \"GET /images/32t49807.jpg HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966433, \"clientip\":\"32.0.0.0\", \"request\": \"GET /english/images/nav_news_off.gif HTTP/1.1\", \"status\": 200, \"size\": 853}",
  "{\"@timestamp\": 893966433, \"clientip\":\"38.0.0.0\", \"request\": \"GET /images/s102320.gif HTTP/1.0\", \"status\": 200, \"size\": 259}",
  "{\"@timestamp\": 893966433, \"clientip\":\"42.0.0.0\", \"request\": \"GET /images/backnews.gif HTTP/1.0\", \"status\": 200, \"size\": 4573}",
  "{\"@timestamp\": 893966433, \"clientip\":\"38.0.0.0\", \"request\": \"GET /images/s102438.gif HTTP/1.0\", \"status\": 200, \"size\": 297}",
  "{\"@timestamp\": 893966433, \"clientip\":\"54.0.0.0\", \"request\": \"GET /english/playing/download/images/big.bird.gif HTTP/1.0\", \"status\": 200, \"size\": 4870}",
  "{\"@timestamp\": 893966433, \"clientip\":\"0.0.0.0\", \"request\": \"GET /english/images/nav_news_off.gif HTTP/1.0\", \"status\": 200, \"size\": 853}",
  "{\"@timestamp\": 893966433, \"clientip\":\"38.0.0.0\", \"request\": \"GET /images/s102329.gif HTTP/1.0\", \"status\": 200, \"size\": 159}",
  "{\"@timestamp\": 893966433, \"clientip\":\"10.0.0.0\", \"request\": \"GET /images/comp_stage2_brc_bot.gif HTTP/1.0\", \"status\": 200, \"size\": 160}",
  "{\"@timestamp\": 893966434, \"clientip\":\"26.0.0.0\", \"request\": \"GET /english/images/nav_home_off.gif HTTP/1.0\", \"status\": 200, \"size\": 828}",
  "{\"@timestamp\": 893966434, \"clientip\":\"0.0.0.0\", \"request\": \"GET /images/space.gif HTTP/1.0\", \"status\": 200, \"size\": 42}",
  "{\"@timestamp\": 893966434, \"clientip\":\"41.0.0.0\", \"request\": \"GET /english/images/team_hm_header.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966434, \"clientip\":\"32.0.0.0\", \"request\": \"GET /english/images/nav_team_off.gif HTTP/1.1\", \"status\": 200, \"size\": 776}",
  "{\"@timestamp\": 893966434, \"clientip\":\"38.0.0.0\", \"request\": \"GET /english/images/team_group_header_c.gif HTTP/1.0\", \"status\": 200, \"size\": 670}",
  "{\"@timestamp\": 893966434, \"clientip\":\"52.0.0.0\", \"request\": \"GET /english/member/images/submit.gif HTTP/1.1\", \"status\": 200, \"size\": 447}",
  "{\"@timestamp\": 893966434, \"clientip\":\"12.0.0.0\", \"request\": \"GET /images/10981.gif HTTP/1.0\", \"status\": 200, \"size\": 173}",
  "{\"@timestamp\": 893966434, \"clientip\":\"39.0.0.0\", \"request\": \"GET /english/history/past_cups/images/past_bu_34_off.gif HTTP/1.1\", \"status\": 200, \"size\": 397}",
  "{\"@timestamp\": 893966434, \"clientip\":\"38.0.0.0\", \"request\": \"GET /images/s102377.gif HTTP/1.0\", \"status\": 200, \"size\": 173}",
  "{\"@timestamp\": 893966434, \"clientip\":\"12.0.0.0\", \"request\": \"GET /images/11116.gif HTTP/1.0\", \"status\": 200, \"size\": 667}",
  "{\"@timestamp\": 893966435, \"clientip\":\"26.0.0.0\", \"request\": \"GET /english/images/nav_logo_sponsors.gif HTTP/1.0\", \"status\": 200, \"size\": 1991}",
  "{\"@timestamp\": 893966435, \"clientip\":\"12.0.0.0\", \"request\": \"GET /images/11106.gif HTTP/1.0\", \"status\": 200, \"size\": 114}",
  "{\"@timestamp\": 893966435, \"clientip\":\"12.0.0.0\", \"request\": \"GET /images/11105.gif HTTP/1.0\", \"status\": 200, \"size\": 114}",
  "{\"@timestamp\": 893966435, \"clientip\":\"12.0.0.0\", \"request\": \"GET /images/11102.gif HTTP/1.0\", \"status\": 200, \"size\": 417}",
  "{\"@timestamp\": 893966435, \"clientip\":\"39.0.0.0\", \"request\": \"GET /english/history/past_cups/images/past_bu_38_off.gif HTTP/1.1\", \"status\": 200, \"size\": 436}",
  "{\"@timestamp\": 893966435, \"clientip\":\"38.0.0.0\", \"request\": \"GET /english/images/team_group_header_h.gif HTTP/1.0\", \"status\": 200, \"size\": 628}",
  "{\"@timestamp\": 893966435, \"clientip\":\"25.0.0.0\", \"request\": \"GET /images/nav_bg_top.gif HTTP/1.1\", \"status\": 200, \"size\": 929}",
  "{\"@timestamp\": 893966435, \"clientip\":\"52.0.0.0\", \"request\": \"GET / HTTP/1.1\", \"status\": 200, \"size\": 8712}",
  "{\"@timestamp\": 893966435, \"clientip\":\"12.0.0.0\", \"request\": \"GET /images/11101.gif HTTP/1.0\", \"status\": 200, \"size\": 415}",
  "{\"@timestamp\": 893966435, \"clientip\":\"32.0.0.0\", \"request\": \"GET /english/images/nav_venue_off.gif HTTP/1.1\", \"status\": 200, \"size\": 870}",
  "{\"@timestamp\": 893966436, \"clientip\":\"55.0.0.0\", \"request\": \"GET / HTTP/1.0\", \"status\": 200, \"size\": 8712}",
  "{\"@timestamp\": 893966436, \"clientip\":\"56.0.0.0\", \"request\": \"GET /images/home_intro.anim.gif HTTP/1.0\", \"status\": 200, \"size\": 60349}",
  "{\"@timestamp\": 893966436, \"clientip\":\"38.0.0.0\", \"request\": \"GET /images/s102443.gif HTTP/1.0\", \"status\": 200, \"size\": 165}",
  "{\"@timestamp\": 893966436, \"clientip\":\"46.0.0.0\", \"request\": \"GET /images/paris.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966436, \"clientip\":\"38.0.0.0\", \"request\": \"GET /images/s140875.gif HTTP/1.0\", \"status\": 200, \"size\": 184}",
  "{\"@timestamp\": 893966436, \"clientip\":\"37.0.0.0\", \"request\": \"GET /images/cal_bord.gif HTTP/1.0\", \"status\": 200, \"size\": 416}",
  "{\"@timestamp\": 893966436, \"clientip\":\"37.0.0.0\", \"request\": \"GET /images/cal_steti.gif HTTP/1.0\", \"status\": 200, \"size\": 1125}",
  "{\"@timestamp\": 893966436, \"clientip\":\"37.0.0.0\", \"request\": \"GET /images/cal_mont.gif HTTP/1.0\", \"status\": 200, \"size\": 316}",
  "{\"@timestamp\": 893966436, \"clientip\":\"51.0.0.0\", \"request\": \"GET /images/32t49813.jpg HTTP/1.1\", \"status\": 200, \"size\": 4714}",
  "{\"@timestamp\": 893966436, \"clientip\":\"2.0.0.0\", \"request\": \"GET /english/images/hm_f98_top.gif HTTP/1.0\", \"status\": 200, \"size\": 915}",
  "{\"@timestamp\": 893966437, \"clientip\":\"23.0.0.0\", \"request\": \"GET /english/tickets/body.html HTTP/1.0\", \"status\": 200, \"size\": 2925}",
  "{\"@timestamp\": 893966437, \"clientip\":\"52.0.0.0\", \"request\": \"GET /english/member/images/cfologo.gif HTTP/1.1\", \"status\": 200, \"size\": 2820}",
  "{\"@timestamp\": 893966437, \"clientip\":\"52.0.0.0\", \"request\": \"GET /english/member/images/member_header.jpg HTTP/1.1\", \"status\": 200, \"size\": 10457}",
  "{\"@timestamp\": 893966437, \"clientip\":\"32.0.0.0\", \"request\": \"GET /english/news/3004bres.htm HTTP/1.1\", \"status\": 200, \"size\": 5765}",
  "{\"@timestamp\": 893966437, \"clientip\":\"38.0.0.0\", \"request\": \"GET /images/s102386.gif HTTP/1.0\", \"status\": 200, \"size\": 279}",
  "{\"@timestamp\": 893966437, \"clientip\":\"41.0.0.0\", \"request\": \"GET /images/news_hm_arw.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966437, \"clientip\":\"39.0.0.0\", \"request\": \"GET /english/history/past_cups/images/past_bu_54_off.gif HTTP/1.1\", \"status\": 200, \"size\": 403}",
  "{\"@timestamp\": 893966437, \"clientip\":\"38.0.0.0\", \"request\": \"GET /images/s102326.gif HTTP/1.0\", \"status\": 200, \"size\": 248}",
  "{\"@timestamp\": 893966437, \"clientip\":\"23.0.0.0\", \"request\": \"GET /english/tickets/images/ticket_hm_bg.jpg HTTP/1.0\", \"status\": 200, \"size\": 20929}",
  "{\"@timestamp\": 893966437, \"clientip\":\"23.0.0.0\", \"request\": \"GET /english/tickets/images/ticket_hm_header.gif HTTP/1.0\", \"status\": 200, \"size\": 1226}",
  "{\"@timestamp\": 893966437, \"clientip\":\"23.0.0.0\", \"request\": \"GET /english/tickets/images/ticket_hm_nav.gif HTTP/1.0\", \"status\": 200, \"size\": 11253}",
  "{\"@timestamp\": 893966438, \"clientip\":\"33.0.0.0\", \"request\": \"GET /images/home_tool.gif HTTP/1.1\", \"status\": 200, \"size\": 327}",
  "{\"@timestamp\": 893966438, \"clientip\":\"38.0.0.0\", \"request\": \"GET /english/competition/maincomp.htm HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966438, \"clientip\":\"46.0.0.0\", \"request\": \"GET /images/11291.jpg HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966438, \"clientip\":\"47.0.0.0\", \"request\": \"GET /english/ProScroll.class HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966438, \"clientip\":\"39.0.0.0\", \"request\": \"GET /english/history/past_cups/images/past_bu_58_off.gif HTTP/1.1\", \"status\": 200, \"size\": 397}",
  "{\"@timestamp\": 893966439, \"clientip\":\"25.0.0.0\", \"request\": \"GET /french/images/nav_news_off.gif HTTP/1.1\", \"status\": 200, \"size\": 855}",
  "{\"@timestamp\": 893966439, \"clientip\":\"57.0.0.0\", \"request\": \"GET /images/hm_f98_top.gif HTTP/1.0\", \"status\": 200, \"size\": 915}",
  "{\"@timestamp\": 893966439, \"clientip\":\"47.0.0.0\", \"request\": \"GET /english/images/nav_field_off.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966439, \"clientip\":\"58.0.0.0\", \"request\": \"GET /images/logo_cfo.gif HTTP/1.0\", \"status\": 200, \"size\": 1504}",
  "{\"@timestamp\": 893966439, \"clientip\":\"57.0.0.0\", \"request\": \"GET /images/ligne1_case5.gif HTTP/1.0\", \"status\": 200, \"size\": 1018}",
  "{\"@timestamp\": 893966439, \"clientip\":\"57.0.0.0\", \"request\": \"GET /english/images/top_stories.gif HTTP/1.0\", \"status\": 200, \"size\": 1210}",
  "{\"@timestamp\": 893966440, \"clientip\":\"47.0.0.0\", \"request\": \"GET /images/hm_arw.gif HTTP/1.0\", \"status\": 200, \"size\": 1050}",
  "{\"@timestamp\": 893966440, \"clientip\":\"47.0.0.0\", \"request\": \"GET /images/hm_linkf.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966440, \"clientip\":\"38.0.0.0\", \"request\": \"GET /english/images/team_hm_header_shad.gif HTTP/1.0\", \"status\": 200, \"size\": 1379}",
  "{\"@timestamp\": 893966440, \"clientip\":\"38.0.0.0\", \"request\": \"GET /english/images/comp_hm_nav.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966441, \"clientip\":\"25.0.0.0\", \"request\": \"GET /french/images/nav_venue_off.gif HTTP/1.1\", \"status\": 200, \"size\": 945}",
  "{\"@timestamp\": 893966441, \"clientip\":\"47.0.0.0\", \"request\": \"GET /images/info.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966441, \"clientip\":\"59.0.0.0\", \"request\": \"GET /english/news/2704leag.htm HTTP/1.0\", \"status\": 200, \"size\": 4801}",
  "{\"@timestamp\": 893966441, \"clientip\":\"60.0.0.0\", \"request\": \"GET /images/10531.jpg HTTP/1.0\", \"status\": 200, \"size\": 16554}",
  "{\"@timestamp\": 893966441, \"clientip\":\"47.0.0.0\", \"request\": \"GET /english/images/nav_hosts_off.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966441, \"clientip\":\"47.0.0.0\", \"request\": \"GET /images/dot.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966441, \"clientip\":\"47.0.0.0\", \"request\": \"GET /english/images/nav_home_off.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966441, \"clientip\":\"47.0.0.0\", \"request\": \"GET /images/hm_day_e.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966441, \"clientip\":\"47.0.0.0\", \"request\": \"GET /english/images/nav_store_off.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966442, \"clientip\":\"61.0.0.0\", \"request\": \"GET /english/venues/cities/montpellier.html HTTP/1.0\", \"status\": 200, \"size\": 9686}",
  "{\"@timestamp\": 893966442, \"clientip\":\"62.0.0.0\", \"request\": \"GET /english/playing/links.html HTTP/1.0\", \"status\": 200, \"size\": 18694}",
  "{\"@timestamp\": 893966442, \"clientip\":\"23.0.0.0\", \"request\": \"GET /images/arw_lk.gif HTTP/1.0\", \"status\": 200, \"size\": 669}",
  "{\"@timestamp\": 893966442, \"clientip\":\"63.0.0.0\", \"request\": \"GET /images/home_bg_stars.gif HTTP/1.0\", \"status\": 200, \"size\": 2557}",
  "{\"@timestamp\": 893966442, \"clientip\":\"63.0.0.0\", \"request\": \"GET /images/home_fr_phrase.gif HTTP/1.0\", \"status\": 200, \"size\": 2843}",
  "{\"@timestamp\": 893966442, \"clientip\":\"63.0.0.0\", \"request\": \"GET /images/home_logo.gif HTTP/1.0\", \"status\": 200, \"size\": 3401}",
  "{\"@timestamp\": 893966442, \"clientip\":\"47.0.0.0\", \"request\": \"GET /english/images/nav_tickets_off.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966442, \"clientip\":\"47.0.0.0\", \"request\": \"GET /english/images/nav_team_off.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966442, \"clientip\":\"46.0.0.0\", \"request\": \"GET /images/sdffr.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966442, \"clientip\":\"47.0.0.0\", \"request\": \"GET /english/images/nav_history_off.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966442, \"clientip\":\"39.0.0.0\", \"request\": \"GET /english/history/past_cups/images/past_bu_62_off.gif HTTP/1.1\", \"status\": 200, \"size\": 437}",
  "{\"@timestamp\": 893966442, \"clientip\":\"39.0.0.0\", \"request\": \"GET /english/history/past_cups/images/past_bu_66_off.gif HTTP/1.1\", \"status\": 200, \"size\": 435}",
  "{\"@timestamp\": 893966443, \"clientip\":\"64.0.0.0\", \"request\": \"GET /images/home_tool.gif HTTP/1.0\", \"status\": 200, \"size\": 327}",
  "{\"@timestamp\": 893966443, \"clientip\":\"38.0.0.0\", \"request\": \"GET /english/images/comp_hm_nav.gif HTTP/1.0\", \"status\": 206, \"size\": 10902}",
  "{\"@timestamp\": 893966443, \"clientip\":\"25.0.0.0\", \"request\": \"GET /french/images/nav_tickets_off.gif HTTP/1.1\", \"status\": 200, \"size\": 965}",
  "{\"@timestamp\": 893966443, \"clientip\":\"57.0.0.0\", \"request\": \"GET /images/case5.gif HTTP/1.0\", \"status\": 200, \"size\": 1362}",
  "{\"@timestamp\": 893966443, \"clientip\":\"65.0.0.0\", \"request\": \"GET /english/index.html HTTP/1.0\", \"status\": 200, \"size\": 892}",
  "{\"@timestamp\": 893966443, \"clientip\":\"30.0.0.0\", \"request\": \"GET /english/playing/mascot/images/button.03.gif HTTP/1.0\", \"status\": 200, \"size\": 893}",
  "{\"@timestamp\": 893966443, \"clientip\":\"57.0.0.0\", \"request\": \"GET /images/bord_stories.gif HTTP/1.0\", \"status\": 200, \"size\": 520}",
  "{\"@timestamp\": 893966443, \"clientip\":\"57.0.0.0\", \"request\": \"GET /images/bord_stories01.gif HTTP/1.0\", \"status\": 200, \"size\": 333}",
  "{\"@timestamp\": 893966444, \"clientip\":\"65.0.0.0\", \"request\": \"GET /english/nav_inet.html HTTP/1.0\", \"status\": 200, \"size\": 2672}",
  "{\"@timestamp\": 893966444, \"clientip\":\"65.0.0.0\", \"request\": \"GET /english/splash_inet.html HTTP/1.0\", \"status\": 200, \"size\": 3730}",
  "{\"@timestamp\": 893966444, \"clientip\":\"39.0.0.0\", \"request\": \"GET /english/history/past_cups/images/past_bu_70_off.gif HTTP/1.1\", \"status\": 200, \"size\": 409}",
  "{\"@timestamp\": 893966444, \"clientip\":\"65.0.0.0\", \"request\": \"GET /images/nav_bg_bottom.jpg HTTP/1.0\", \"status\": 200, \"size\": 8389}",
  "{\"@timestamp\": 893966444, \"clientip\":\"65.0.0.0\", \"request\": \"GET /english/images/nav_team_off.gif HTTP/1.0\", \"status\": 200, \"size\": 776}",
  "{\"@timestamp\": 893966444, \"clientip\":\"6.0.0.0\", \"request\": \"GET /french/venues/body.html HTTP/1.0\", \"status\": 200, \"size\": 2042}",
  "{\"@timestamp\": 893966444, \"clientip\":\"65.0.0.0\", \"request\": \"GET /english/images/nav_news_off.gif HTTP/1.0\", \"status\": 200, \"size\": 853}",
  "{\"@timestamp\": 893966444, \"clientip\":\"65.0.0.0\", \"request\": \"GET /images/nav_bg_top.gif HTTP/1.0\", \"status\": 200, \"size\": 929}",
  "{\"@timestamp\": 893966444, \"clientip\":\"64.0.0.0\", \"request\": \"GET /images/home_sponsor.gif HTTP/1.0\", \"status\": 200, \"size\": 2491}",
  "{\"@timestamp\": 893966444, \"clientip\":\"65.0.0.0\", \"request\": \"GET /images/logo_cfo.gif HTTP/1.0\", \"status\": 200, \"size\": 1504}",
  "{\"@timestamp\": 893966444, \"clientip\":\"65.0.0.0\", \"request\": \"GET /images/hm_nbg.jpg HTTP/1.0\", \"status\": 200, \"size\": 33665}",
  "{\"@timestamp\": 893966444, \"clientip\":\"65.0.0.0\", \"request\": \"GET /english/images/nav_comp_off.gif HTTP/1.0\", \"status\": 200, \"size\": 994}",
  "{\"@timestamp\": 893966444, \"clientip\":\"66.0.0.0\", \"request\": \"GET / HTTP/1.0\", \"status\": 200, \"size\": 8712}",
  "{\"@timestamp\": 893966444, \"clientip\":\"62.0.0.0\", \"request\": \"GET /english/playing/images/backg.gif HTTP/1.0\", \"status\": 200, \"size\": 1462}",
  "{\"@timestamp\": 893966444, \"clientip\":\"67.0.0.0\", \"request\": \"GET /english/individuals/player389.htm HTTP/1.0\", \"status\": 200, \"size\": 7001}",
  "{\"@timestamp\": 893966444, \"clientip\":\"47.0.0.0\", \"request\": \"GET /english/teams/teamgroup.htm HTTP/1.0\", \"status\": 200, \"size\": 11971}",
  "{\"@timestamp\": 893966445, \"clientip\":\"7.0.0.0\", \"request\": \"GET /english/playing/images/play_header.gif HTTP/1.0\", \"status\": 200, \"size\": 2262}",
  "{\"@timestamp\": 893966445, \"clientip\":\"30.0.0.0\", \"request\": \"GET /english/playing/mascot/images/footix.test.gif HTTP/1.0\", \"status\": 200, \"size\": 20385}",
  "{\"@timestamp\": 893966445, \"clientip\":\"6.0.0.0\", \"request\": \"GET /french/venues/images/Venue_map_mid_off.gif HTTP/1.0\", \"status\": 200, \"size\": 9911}",
  "{\"@timestamp\": 893966445, \"clientip\":\"25.0.0.0\", \"request\": \"GET /french/images/nav_field_off.gif HTTP/1.1\", \"status\": 200, \"size\": 982}",
  "{\"@timestamp\": 893966445, \"clientip\":\"64.0.0.0\", \"request\": \"GET /images/home_intro.anim.gif HTTP/1.0\", \"status\": 200, \"size\": 60349}",
  "{\"@timestamp\": 893966445, \"clientip\":\"6.0.0.0\", \"request\": \"GET /french/venues/images/Venue_map_top_off.gif HTTP/1.0\", \"status\": 200, \"size\": 8369}",
  "{\"@timestamp\": 893966445, \"clientip\":\"6.0.0.0\", \"request\": \"GET /french/venues/images/venue_hm_nav.gif HTTP/1.0\", \"status\": 200, \"size\": 7644}",
  "{\"@timestamp\": 893966445, \"clientip\":\"68.0.0.0\", \"request\": \"GET /english/venues/cities/images/montpellier/venue_mont_header.jpg HTTP/1.0\", \"status\": 200, \"size\": 11562}",
  "{\"@timestamp\": 893966445, \"clientip\":\"69.0.0.0\", \"request\": \"GET /english/history/history_of/images/cup/cup.gif HTTP/1.0\", \"status\": 200, \"size\": 5469}",
  "{\"@timestamp\": 893966445, \"clientip\":\"34.0.0.0\", \"request\": \"GET /english/history/body.html HTTP/1.0\", \"status\": 200, \"size\": 2909}",
  "{\"@timestamp\": 893966445, \"clientip\":\"70.0.0.0\", \"request\": \"GET /english/venues/cities/images/marseille/mars_c.gif HTTP/1.0\", \"status\": 200, \"size\": 369}",
  "{\"@timestamp\": 893966446, \"clientip\":\"64.0.0.0\", \"request\": \"GET /images/home_fr_button.gif HTTP/1.0\", \"status\": 200, \"size\": 2140}",
  "{\"@timestamp\": 893966446, \"clientip\":\"66.0.0.0\", \"request\": \"GET / HTTP/1.0\", \"status\": 200, \"size\": 8712}",
  "{\"@timestamp\": 893966446, \"clientip\":\"6.0.0.0\", \"request\": \"GET /french/venues/images/Venue_map_bot_off.gif HTTP/1.0\", \"status\": 200, \"size\": 7397}",
  "{\"@timestamp\": 893966446, \"clientip\":\"71.0.0.0\", \"request\": \"GET /english/teams/teambio148.htm HTTP/1.0\", \"status\": 200, \"size\": 10857}",
  "{\"@timestamp\": 893966446, \"clientip\":\"72.0.0.0\", \"request\": \"GET / HTTP/1.0\", \"status\": 200, \"size\": 8712}",
  "{\"@timestamp\": 893966446, \"clientip\":\"39.0.0.0\", \"request\": \"GET /english/history/past_cups/images/past_bu_78_off.gif HTTP/1.1\", \"status\": 200, \"size\": 427}",
  "{\"@timestamp\": 893966446, \"clientip\":\"67.0.0.0\", \"request\": \"GET /images/102373.gif HTTP/1.0\", \"status\": 200, \"size\": 1703}",
  "{\"@timestamp\": 893966446, \"clientip\":\"47.0.0.0\", \"request\": \"GET /english/images/teams_bu_group_on.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966446, \"clientip\":\"67.0.0.0\", \"request\": \"GET /images/32p49804.jpg HTTP/1.0\", \"status\": 200, \"size\": 11023}",
  "{\"@timestamp\": 893966446, \"clientip\":\"47.0.0.0\", \"request\": \"GET /english/images/teams_bu_confed_off.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966447, \"clientip\":\"71.0.0.0\", \"request\": \"GET /images/32t49812.jpg HTTP/1.0\", \"status\": 200, \"size\": 4132}",
  "{\"@timestamp\": 893966447, \"clientip\":\"71.0.0.0\", \"request\": \"GET /images/ger.gif HTTP/1.0\", \"status\": 200, \"size\": 1603}",
  "{\"@timestamp\": 893966447, \"clientip\":\"39.0.0.0\", \"request\": \"GET /english/history/past_cups/images/past_bu_82_off.gif HTTP/1.1\", \"status\": 200, \"size\": 433}",
  "{\"@timestamp\": 893966447, \"clientip\":\"25.0.0.0\", \"request\": \"GET /french/images/nav_store_off.gif HTTP/1.1\", \"status\": 200, \"size\": 976}",
  "{\"@timestamp\": 893966447, \"clientip\":\"65.0.0.0\", \"request\": \"GET /images/space.gif HTTP/1.0\", \"status\": 200, \"size\": 42}",
  "{\"@timestamp\": 893966447, \"clientip\":\"65.0.0.0\", \"request\": \"GET /english/images/hm_official.gif HTTP/1.0\", \"status\": 200, \"size\": 1807}",
  "{\"@timestamp\": 893966447, \"clientip\":\"47.0.0.0\", \"request\": \"GET /images/s102325.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966447, \"clientip\":\"65.0.0.0\", \"request\": \"GET /images/space.gif HTTP/1.0\", \"status\": 200, \"size\": 42}",
  "{\"@timestamp\": 893966447, \"clientip\":\"47.0.0.0\", \"request\": \"GET /english/images/team_group_header_a.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966447, \"clientip\":\"65.0.0.0\", \"request\": \"GET /english/images/nav_field_off.gif HTTP/1.0\", \"status\": 200, \"size\": 1005}",
  "{\"@timestamp\": 893966447, \"clientip\":\"65.0.0.0\", \"request\": \"GET /english/images/nav_history_off.gif HTTP/1.0\", \"status\": 200, \"size\": 914}",
  "{\"@timestamp\": 893966448, \"clientip\":\"65.0.0.0\", \"request\": \"GET /english/ProScroll.class HTTP/1.0\", \"status\": 200, \"size\": 6507}",
  "{\"@timestamp\": 893966448, \"clientip\":\"47.0.0.0\", \"request\": \"GET /images/s102424.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966448, \"clientip\":\"39.0.0.0\", \"request\": \"GET /english/history/past_cups/images/past_bu_86_off.gif HTTP/1.1\", \"status\": 200, \"size\": 409}",
  "{\"@timestamp\": 893966448, \"clientip\":\"47.0.0.0\", \"request\": \"GET /images/s102487.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966448, \"clientip\":\"65.0.0.0\", \"request\": \"GET /english/images/nav_hosts_off.gif HTTP/1.0\", \"status\": 200, \"size\": 914}",
  "{\"@timestamp\": 893966448, \"clientip\":\"65.0.0.0\", \"request\": \"GET /images/hm_brdl.gif HTTP/1.0\", \"status\": 200, \"size\": 208}",
  "{\"@timestamp\": 893966448, \"clientip\":\"73.0.0.0\", \"request\": \"GET / HTTP/1.1\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966448, \"clientip\":\"62.0.0.0\", \"request\": \"GET /english/playing/images/links_on.GIF HTTP/1.0\", \"status\": 200, \"size\": 1393}",
  "{\"@timestamp\": 893966448, \"clientip\":\"62.0.0.0\", \"request\": \"GET /english/playing/images/banner2.gif HTTP/1.0\", \"status\": 200, \"size\": 15328}",
  "{\"@timestamp\": 893966448, \"clientip\":\"66.0.0.0\", \"request\": \"GET /images/home_bg_stars.gif HTTP/1.0\", \"status\": 200, \"size\": 2557}",
  "{\"@timestamp\": 893966448, \"clientip\":\"57.0.0.0\", \"request\": \"GET /english/images/lateb_new.gif HTTP/1.0\", \"status\": 200, \"size\": 1431}",
  "{\"@timestamp\": 893966448, \"clientip\":\"47.0.0.0\", \"request\": \"GET /images/s102477.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966448, \"clientip\":\"65.0.0.0\", \"request\": \"GET /english/images/nav_sitemap_off.gif HTTP/1.0\", \"status\": 200, \"size\": 416}",
  "{\"@timestamp\": 893966448, \"clientip\":\"65.0.0.0\", \"request\": \"GET /english/images/nav_logo_sponsors.gif HTTP/1.0\", \"status\": 200, \"size\": 1991}",
  "{\"@timestamp\": 893966448, \"clientip\":\"47.0.0.0\", \"request\": \"GET /english/images/team_group_header_e.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966448, \"clientip\":\"65.0.0.0\", \"request\": \"GET /images/hm_linkf.gif HTTP/1.0\", \"status\": 200, \"size\": 123}",
  "{\"@timestamp\": 893966449, \"clientip\":\"65.0.0.0\", \"request\": \"GET /images/info.gif HTTP/1.0\", \"status\": 200, \"size\": 1251}",
  "{\"@timestamp\": 893966449, \"clientip\":\"74.0.0.0\", \"request\": \"GET / HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966449, \"clientip\":\"75.0.0.0\", \"request\": \"GET /english/competition/stage2.htm HTTP/1.0\", \"status\": 200, \"size\": 16606}",
  "{\"@timestamp\": 893966449, \"clientip\":\"47.0.0.0\", \"request\": \"GET /images/s102324.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966449, \"clientip\":\"25.0.0.0\", \"request\": \"GET /french/images/nav_sitemap_off.gif HTTP/1.1\", \"status\": 200, \"size\": 413}",
  "{\"@timestamp\": 893966449, \"clientip\":\"65.0.0.0\", \"request\": \"GET /images/hm_day_e.gif HTTP/1.0\", \"status\": 200, \"size\": 499}",
  "{\"@timestamp\": 893966449, \"clientip\":\"14.0.0.0\", \"request\": \"GET /images/home_bg_stars.gif HTTP/1.1\", \"status\": 200, \"size\": 2557}",
  "{\"@timestamp\": 893966449, \"clientip\":\"47.0.0.0\", \"request\": \"GET /images/s102376.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966449, \"clientip\":\"40.0.0.0\", \"request\": \"GET /english/history/past_cups/france38.html HTTP/1.1\", \"status\": 200, \"size\": 12669}",
  "{\"@timestamp\": 893966449, \"clientip\":\"73.0.0.0\", \"request\": \"GET /images/home_fr_phrase.gif HTTP/1.1\", \"status\": 200, \"size\": 2843}",
  "{\"@timestamp\": 893966449, \"clientip\":\"73.0.0.0\", \"request\": \"GET /images/home_intro.anim.gif HTTP/1.1\", \"status\": 200, \"size\": 60349}",
  "{\"@timestamp\": 893966449, \"clientip\":\"65.0.0.0\", \"request\": \"GET /images/hm_brdr.gif HTTP/1.0\", \"status\": 200, \"size\": 235}",
  "{\"@timestamp\": 893966449, \"clientip\":\"65.0.0.0\", \"request\": \"GET /english/images/nav_store_off.gif HTTP/1.0\", \"status\": 200, \"size\": 934}",
  "{\"@timestamp\": 893966449, \"clientip\":\"76.0.0.0\", \"request\": \"GET /english/competition/stage1.htm HTTP/1.1\", \"status\": 200, \"size\": 36783}",
  "{\"@timestamp\": 893966449, \"clientip\":\"65.0.0.0\", \"request\": \"GET /images/hm_arw.gif HTTP/1.0\", \"status\": 200, \"size\": 1050}",
  "{\"@timestamp\": 893966449, \"clientip\":\"53.0.0.0\", \"request\": \"GET /english/competition/headtohead76.htm HTTP/1.1\", \"status\": 200, \"size\": 16909}",
  "{\"@timestamp\": 893966449, \"clientip\":\"65.0.0.0\", \"request\": \"GET /images/dot.gif HTTP/1.0\", \"status\": 200, \"size\": 43}",
  "{\"@timestamp\": 893966449, \"clientip\":\"2.0.0.0\", \"request\": \"GET /english/images/nav_history_off.gif HTTP/1.0\", \"status\": 200, \"size\": 914}",
  "{\"@timestamp\": 893966449, \"clientip\":\"73.0.0.0\", \"request\": \"GET /images/home_eng_phrase.gif HTTP/1.1\", \"status\": 200, \"size\": 2861}",
  "{\"@timestamp\": 893966450, \"clientip\":\"2.0.0.0\", \"request\": \"GET /english/images/nav_field_off.gif HTTP/1.0\", \"status\": 200, \"size\": 1005}",
  "{\"@timestamp\": 893966450, \"clientip\":\"66.0.0.0\", \"request\": \"GET /images/home_fr_phrase.gif HTTP/1.0\", \"status\": 200, \"size\": 2843}",
  "{\"@timestamp\": 893966450, \"clientip\":\"1.0.0.0\", \"request\": \"GET /english/images/hm_official.gif HTTP/1.0\", \"status\": 200, \"size\": 1807}",
  "{\"@timestamp\": 893966450, \"clientip\":\"1.0.0.0\", \"request\": \"GET /images/nav_bg_top.gif HTTP/1.0\", \"status\": 200, \"size\": 929}",
  "{\"@timestamp\": 893966450, \"clientip\":\"66.0.0.0\", \"request\": \"GET /images/home_intro.anim.gif HTTP/1.0\", \"status\": 200, \"size\": 60349}",
  "{\"@timestamp\": 893966450, \"clientip\":\"1.0.0.0\", \"request\": \"GET /images/logo_cfo.gif HTTP/1.0\", \"status\": 200, \"size\": 1504}",
  "{\"@timestamp\": 893966450, \"clientip\":\"1.0.0.0\", \"request\": \"GET /images/space.gif HTTP/1.0\", \"status\": 200, \"size\": 42}",
  "{\"@timestamp\": 893966450, \"clientip\":\"77.0.0.0\", \"request\": \"GET /english/images/france98b.gif HTTP/1.0\", \"status\": 200, \"size\": 2122}",
  "{\"@timestamp\": 893966450, \"clientip\":\"1.0.0.0\", \"request\": \"GET /english/ProScroll.class HTTP/1.0\", \"status\": 200, \"size\": 6507}",
  "{\"@timestamp\": 893966450, \"clientip\":\"77.0.0.0\", \"request\": \"GET /english/images/space.gif HTTP/1.0\", \"status\": 200, \"size\": 42}",
  "{\"@timestamp\": 893966450, \"clientip\":\"57.0.0.0\", \"request\": \"GET /images/ligne4_latebreak.gif HTTP/1.0\", \"status\": 200, \"size\": 1056}",
  "{\"@timestamp\": 893966450, \"clientip\":\"47.0.0.0\", \"request\": \"GET /images/s102373.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966450, \"clientip\":\"47.0.0.0\", \"request\": \"GET /images/s102443.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966450, \"clientip\":\"232.0.0.0\", \"request\": \"GET /images/hm_bg.jpg HTTP/1.0\", \"status\": 200, \"size\": 24736}",
  "{\"@timestamp\": 893966451, \"clientip\":\"66.0.0.0\", \"request\": \"GET /images/home_eng_phrase.gif HTTP/1.0\", \"status\": 200, \"size\": 2861}",
  "{\"@timestamp\": 893966451, \"clientip\":\"75.0.0.0\", \"request\": \"GET /english/images/comp_bu_stage2n_on.gif HTTP/1.0\", \"status\": 200, \"size\": 996}",
  "{\"@timestamp\": 893966451, \"clientip\":\"57.0.0.0\", \"request\": \"GET /images/ligneb.gif HTTP/1.0\", \"status\": 200, \"size\": 169}",
  "{\"@timestamp\": 893966451, \"clientip\":\"39.0.0.0\", \"request\": \"GET /english/history/past_cups/images/past_bu_94_off.gif HTTP/1.1\", \"status\": 200, \"size\": 432}",
  "{\"@timestamp\": 893966451, \"clientip\":\"77.0.0.0\", \"request\": \"GET /english/images/comp_bu_stage1n.gif HTTP/1.0\", \"status\": 200, \"size\": 1548}",
  "{\"@timestamp\": 893966451, \"clientip\":\"47.0.0.0\", \"request\": \"GET /images/s140875.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966451, \"clientip\":\"47.0.0.0\", \"request\": \"GET /images/s102321.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966451, \"clientip\":\"6.0.0.0\", \"request\": \"GET /french/venues/cities/images/denis/venue_denn_bg.jpg HTTP/1.0\", \"status\": 200, \"size\": 21003}",
  "{\"@timestamp\": 893966451, \"clientip\":\"6.0.0.0\", \"request\": \"GET /french/venues/images/venue_header.gif HTTP/1.0\", \"status\": 200, \"size\": 740}",
  "{\"@timestamp\": 893966451, \"clientip\":\"75.0.0.0\", \"request\": \"GET /images/comp_stage2_brc_top.gif HTTP/1.0\", \"status\": 200, \"size\": 163}",
  "{\"@timestamp\": 893966451, \"clientip\":\"75.0.0.0\", \"request\": \"GET /images/comp_stage2_brc_topr.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966451, \"clientip\":\"25.0.0.0\", \"request\": \"GET /images/hm_nbg.jpg HTTP/1.1\", \"status\": 200, \"size\": 33665}",
  "{\"@timestamp\": 893966451, \"clientip\":\"6.0.0.0\", \"request\": \"GET /french/venues/images/venue_bu_city_on.gif HTTP/1.0\", \"status\": 200, \"size\": 1061}",
  "{\"@timestamp\": 893966451, \"clientip\":\"66.0.0.0\", \"request\": \"GET /images/home_tool.gif HTTP/1.0\", \"status\": 200, \"size\": 327}",
  "{\"@timestamp\": 893966451, \"clientip\":\"47.0.0.0\", \"request\": \"GET /english/images/team_group_header_g.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966451, \"clientip\":\"47.0.0.0\", \"request\": \"GET /images/s102357.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966451, \"clientip\":\"75.0.0.0\", \"request\": \"GET /images/comp_stage2_brc_bot.gif HTTP/1.0\", \"status\": 200, \"size\": 160}",
  "{\"@timestamp\": 893966451, \"clientip\":\"69.0.0.0\", \"request\": \"GET /english/history/history_of/images/cup/coup_du_mondtxt.gif HTTP/1.0\", \"status\": 200, \"size\": 5053}",
  "{\"@timestamp\": 893966451, \"clientip\":\"73.0.0.0\", \"request\": \"GET /images/home_fr_button.gif HTTP/1.1\", \"status\": 200, \"size\": 2140}",
  "{\"@timestamp\": 893966451, \"clientip\":\"1.0.0.0\", \"request\": \"GET /images/nav_bg_bottom.jpg HTTP/1.0\", \"status\": 200, \"size\": 8389}",
  "{\"@timestamp\": 893966451, \"clientip\":\"1.0.0.0\", \"request\": \"GET /english/images/nav_news_off.gif HTTP/1.0\", \"status\": 200, \"size\": 853}",
  "{\"@timestamp\": 893966451, \"clientip\":\"1.0.0.0\", \"request\": \"GET /english/images/nav_comp_off.gif HTTP/1.0\", \"status\": 200, \"size\": 994}",
  "{\"@timestamp\": 893966451, \"clientip\":\"47.0.0.0\", \"request\": \"GET /english/images/team_hm_header_shad.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966452, \"clientip\":\"47.0.0.0\", \"request\": \"GET /english/images/team_group_header_c.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966452, \"clientip\":\"78.0.0.0\", \"request\": \"GET /english/venues/cities/images/montpellier/12eglise.jpg HTTP/1.0\", \"status\": 200, \"size\": 3035}",
  "{\"@timestamp\": 893966452, \"clientip\":\"47.0.0.0\", \"request\": \"GET /images/s102383.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966452, \"clientip\":\"6.0.0.0\", \"request\": \"GET /french/venues/cities/images/denis/12maisons.jpg HTTP/1.0\", \"status\": 200, \"size\": 2559}",
  "{\"@timestamp\": 893966452, \"clientip\":\"75.0.0.0\", \"request\": \"GET /images/comp_stage2_brc_botr.gif HTTP/1.0\", \"status\": 200, \"size\": 158}",
  "{\"@timestamp\": 893966452, \"clientip\":\"6.0.0.0\", \"request\": \"GET /french/venues/cities/images/denis/denis_a.gif HTTP/1.0\", \"status\": 200, \"size\": 520}",
  "{\"@timestamp\": 893966452, \"clientip\":\"70.0.0.0\", \"request\": \"GET /english/venues/cities/images/montpellier/17mystery.gif HTTP/1.0\", \"status\": 200, \"size\": 542}",
  "{\"@timestamp\": 893966452, \"clientip\":\"79.0.0.0\", \"request\": \"GET /english/history/images/history_hm_bg2.jpg HTTP/1.0\", \"status\": 200, \"size\": 22515}",
  "{\"@timestamp\": 893966452, \"clientip\":\"79.0.0.0\", \"request\": \"GET /english/history/images/history_hm_header.gif HTTP/1.0\", \"status\": 200, \"size\": 688}",
  "{\"@timestamp\": 893966452, \"clientip\":\"2.0.0.0\", \"request\": \"GET /english/images/nav_home_off.gif HTTP/1.0\", \"status\": 200, \"size\": 828}",
  "{\"@timestamp\": 893966452, \"clientip\":\"1.0.0.0\", \"request\": \"GET /images/hm_day_e.gif HTTP/1.0\", \"status\": 200, \"size\": 499}",
  "{\"@timestamp\": 893966452, \"clientip\":\"70.0.0.0\", \"request\": \"GET /english/venues/cities/images/montpellier/18corum.gif HTTP/1.0\", \"status\": 200, \"size\": 650}",
  "{\"@timestamp\": 893966452, \"clientip\":\"66.0.0.0\", \"request\": \"GET /images/home_eng_button.gif HTTP/1.0\", \"status\": 200, \"size\": 1927}",
  "{\"@timestamp\": 893966452, \"clientip\":\"80.0.0.0\", \"request\": \"GET /english/news/player01.htm HTTP/1.0\", \"status\": 200, \"size\": 42591}",
  "{\"@timestamp\": 893966452, \"clientip\":\"79.0.0.0\", \"request\": \"GET /english/history/images/history_hm_3094.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966452, \"clientip\":\"79.0.0.0\", \"request\": \"GET /english/history/images/history_hm_posters.jpg HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966452, \"clientip\":\"39.0.0.0\", \"request\": \"GET /english/history/past_cups/images/past_bracket_top.gif HTTP/1.1\", \"status\": 200, \"size\": 289}",
  "{\"@timestamp\": 893966452, \"clientip\":\"2.0.0.0\", \"request\": \"GET /english/images/nav_tickets_off.gif HTTP/1.0\", \"status\": 200, \"size\": 937}",
  "{\"@timestamp\": 893966452, \"clientip\":\"47.0.0.0\", \"request\": \"GET /images/s102380.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966452, \"clientip\":\"6.0.0.0\", \"request\": \"GET /french/venues/cities/images/denis/16tradition.gif HTTP/1.0\", \"status\": 200, \"size\": 387}",
  "{\"@timestamp\": 893966452, \"clientip\":\"66.0.0.0\", \"request\": \"GET /images/home_sponsor.gif HTTP/1.0\", \"status\": 200, \"size\": 2491}",
  "{\"@timestamp\": 893966453, \"clientip\":\"70.0.0.0\", \"request\": \"GET /english/venues/cities/images/marseille/mars_t.gif HTTP/1.0\", \"status\": 200, \"size\": 353}",
  "{\"@timestamp\": 893966453, \"clientip\":\"73.0.0.0\", \"request\": \"GET /images/home_tool.gif HTTP/1.1\", \"status\": 200, \"size\": 327}",
  "{\"@timestamp\": 893966453, \"clientip\":\"81.0.0.0\", \"request\": \"GET / HTTP/1.0\", \"status\": 200, \"size\": 8712}",
  "{\"@timestamp\": 893966453, \"clientip\":\"5.0.0.0\", \"request\": \"GET /french/news/3004arge.htm HTTP/1.1\", \"status\": 200, \"size\": 4869}",
  "{\"@timestamp\": 893966453, \"clientip\":\"78.0.0.0\", \"request\": \"GET /english/venues/cities/images/marseille/mars_i.gif HTTP/1.0\", \"status\": 200, \"size\": 314}",
  "{\"@timestamp\": 893966453, \"clientip\":\"1.0.0.0\", \"request\": \"GET /images/hm_arw.gif HTTP/1.0\", \"status\": 200, \"size\": 1050}",
  "{\"@timestamp\": 893966453, \"clientip\":\"77.0.0.0\", \"request\": \"GET /english/images/comp_bu_stage2n.gif HTTP/1.0\", \"status\": 200, \"size\": 984}",
  "{\"@timestamp\": 893966453, \"clientip\":\"2.0.0.0\", \"request\": \"GET /english/images/nav_logo_sponsors.gif HTTP/1.0\", \"status\": 200, \"size\": 1991}",
  "{\"@timestamp\": 893966453, \"clientip\":\"62.0.0.0\", \"request\": \"GET /english/playing/images/fifa_logo_sm.gif HTTP/1.0\", \"status\": 200, \"size\": 2900}",
  "{\"@timestamp\": 893966453, \"clientip\":\"68.0.0.0\", \"request\": \"GET /english/venues/cities/images/marseille/mars_a.gif HTTP/1.0\", \"status\": 200, \"size\": 434}",
  "{\"@timestamp\": 893966453, \"clientip\":\"47.0.0.0\", \"request\": \"GET /images/s102320.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966453, \"clientip\":\"3.0.0.0\", \"request\": \"GET /english/images/fpnewstop.gif HTTP/1.0\", \"status\": 200, \"size\": 568}",
  "{\"@timestamp\": 893966453, \"clientip\":\"1.0.0.0\", \"request\": \"GET /english/images/nav_venue_off.gif HTTP/1.0\", \"status\": 200, \"size\": 870}",
  "{\"@timestamp\": 893966453, \"clientip\":\"3.0.0.0\", \"request\": \"GET /english/images/news_btn_letter_off.gif HTTP/1.0\", \"status\": 200, \"size\": 852}",
  "{\"@timestamp\": 893966453, \"clientip\":\"47.0.0.0\", \"request\": \"GET /images/s102353.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966453, \"clientip\":\"6.0.0.0\", \"request\": \"GET /french/venues/cities/images/denis/17commercial.gif HTTP/1.0\", \"status\": 200, \"size\": 614}",
  "{\"@timestamp\": 893966453, \"clientip\":\"57.0.0.0\", \"request\": \"GET /images/ligne.gif HTTP/1.0\", \"status\": 200, \"size\": 169}",
  "{\"@timestamp\": 893966453, \"clientip\":\"47.0.0.0\", \"request\": \"GET /images/s102329.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966453, \"clientip\":\"3.0.0.0\", \"request\": \"GET /english/images/news_btn_kits_off.gif HTTP/1.0\", \"status\": 200, \"size\": 933}",
  "{\"@timestamp\": 893966453, \"clientip\":\"57.0.0.0\", \"request\": \"GET /images/ligne01.gif HTTP/1.0\", \"status\": 200, \"size\": 169}",
  "{\"@timestamp\": 893966453, \"clientip\":\"7.0.0.0\", \"request\": \"GET /english/playing/images/links.GIF HTTP/1.0\", \"status\": 200, \"size\": 1394}",
  "{\"@timestamp\": 893966453, \"clientip\":\"47.0.0.0\", \"request\": \"GET /images/s102377.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966454, \"clientip\":\"47.0.0.0\", \"request\": \"GET /images/s102328.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966454, \"clientip\":\"66.0.0.0\", \"request\": \"GET /images/home_fr_button.gif HTTP/1.0\", \"status\": 200, \"size\": 2140}",
  "{\"@timestamp\": 893966454, \"clientip\":\"47.0.0.0\", \"request\": \"GET /images/s102323.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966454, \"clientip\":\"34.0.0.0\", \"request\": \"GET /english/history/images/history_hm_3094.gif HTTP/1.0\", \"status\": 200, \"size\": 1031}",
  "{\"@timestamp\": 893966454, \"clientip\":\"69.0.0.0\", \"request\": \"GET /english/history/history_of/images/cup/trophytxt.gif HTTP/1.0\", \"status\": 200, \"size\": 1425}",
  "{\"@timestamp\": 893966454, \"clientip\":\"6.0.0.0\", \"request\": \"GET /french/venues/cities/images/denis/19historical.gif HTTP/1.0\", \"status\": 200, \"size\": 616}",
  "{\"@timestamp\": 893966454, \"clientip\":\"57.0.0.0\", \"request\": \"GET /images/base.gif HTTP/1.0\", \"status\": 200, \"size\": 366}",
  "{\"@timestamp\": 893966454, \"clientip\":\"79.0.0.0\", \"request\": \"GET /english/history/images/history_hm_nav.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966454, \"clientip\":\"47.0.0.0\", \"request\": \"GET /english/images/team_group_header_f.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966454, \"clientip\":\"6.0.0.0\", \"request\": \"GET /french/venues/cities/images/denis/18collect.gif HTTP/1.0\", \"status\": 200, \"size\": 714}",
  "{\"@timestamp\": 893966454, \"clientip\":\"47.0.0.0\", \"request\": \"GET /images/s102442.gif HTTP/1.0\", \"status\": 304, \"size\": 0}",
  "{\"@timestamp\": 893966455, \"clientip\":\"34.0.0.0\", \"request\": \"GET /english/history/images/history_hm_nav.gif HTTP/1.0\", \"status\": 200, \"size\": 18328}"
};

static void testSearchEqual(CuTest* tc) {
  RAMDirectory dir;
  std::string name = "name";

  // index
  {
    lucene::analysis::standard95::StandardAnalyzer analyzer;
    IndexWriter w(&dir, &analyzer, true);

    w.setRAMBufferSizeMB(512);
    w.setMaxFieldLength(0x7FFFFFFFL);
    w.setMergeFactor(100000000);
    w.setUseCompoundFile(false);

    lucene::util::SStringReader<char> char_string_reader;

    lucene::document::Document doc;
    auto field_config = lucene::document::Field::STORE_NO |
                        lucene::document::Field::INDEX_NONORMS;
    field_config |= lucene::document::Field::INDEX_TOKENIZED;
    auto field_name = std::wstring(name.begin(), name.end());
    auto field =
        _CLNEW lucene::document::Field(field_name.c_str(), field_config);
    field->setOmitTermFreqAndPositions(true);
    doc.add(*field);

    for (auto& str : datas) {
      char_string_reader.init(str.data(), str.size(), false);
      auto stream = analyzer.reusableTokenStream(field->name(), &char_string_reader);
      field->setValue(stream);

      w.addDocument(&doc);
    }
    w.close();
  }

  // search
  {
    {
      std::vector<std::string> values;
      values.push_back("http");
      values.push_back("get");
      values.push_back("1.0");
      values.push_back("images");
      values.push_back("jpg");
      values.push_back("gif");
      values.push_back("html");
      values.push_back("tickets");
      values.push_back("hm");

      IndexSearcher searcher(&dir);

      for (auto& value : values) {
        roaring::Roaring result1;
        roaring::Roaring result2;
        {
          std::wstring ws = StringUtil::string_to_wstring(value);
          Term* t = _CLNEW Term(_T("name"), ws.c_str());
          Query* query = _CLNEW TermQuery(t);
          _CLLDECDELETE(t);

          searcher._search(
              query, [&result1](const int32_t docid, const float_t /*score*/) {
                result1.add(docid);
              });
          _CLLDELETE(query);
        }
        {
          std::wstring ws = StringUtil::string_to_wstring(value);
          Term* t = _CLNEW Term(_T("name"), ws.c_str());
          Query* query = _CLNEW TermQuery(t);
          _CLLDECDELETE(t);

          searcher._search(query, [&result2](DocRange* docRange) {
            if (docRange->type_ == DocRangeType::kMany) {
              result2.addMany(docRange->doc_many_size_,
                              docRange->doc_many.data());
            } else if (docRange->type_ == DocRangeType::kRange) {
              result2.addRange(docRange->doc_range.first,
                               docRange->doc_range.second);
            }
          });
          _CLLDELETE(query);
        }
        CLUCENE_ASSERT(result1 == result2);
      }
    }
  }
}

CuSuite* testSearchRange(void) {
  CuSuite* suite = CuSuiteNew(_T("CLucene search range"));

  SUITE_ADD_TEST(suite, testSearchEqual);
  return suite;
}