// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

suite('nereids_arith_p0_integer') {
	sql 'use regression_test_nereids_arith_p0'
	sql 'set enable_nereids_planner=true'
	sql 'set enable_fallback_to_original_planner=false'
	qt_sql_test_Boolean_TinyInt_0 """
		select id, kbool + ktint, kbool - ktint from expr_test order by id"""
	qt_sql_test_Boolean_TinyInt_notn_0 """
		select id, kbool + ktint, kbool - ktint from expr_test_not_nullable order by id"""
	qt_sql_test_Boolean_TinyInt_1 """
		select id, kbool * ktint, kbool / ktint, kbool % ktint from expr_test order by id"""
	qt_sql_test_Boolean_TinyInt_notn_1 """
		select id, kbool * ktint, kbool / ktint, kbool % ktint from expr_test_not_nullable order by id"""
	qt_sql_test_Boolean_TinyInt_2 """
		select id, kbool DIV ktint from expr_test order by id"""
	qt_sql_test_Boolean_TinyInt_notn_2 """
		select id, kbool DIV ktint from expr_test_not_nullable order by id"""
	qt_sql_test_Boolean_TinyInt_3 """
		select id, kbool & ktint, kbool | ktint, kbool ^ ktint from expr_test order by id"""
	qt_sql_test_Boolean_TinyInt_notn_3 """
		select id, kbool & ktint, kbool | ktint, kbool ^ ktint from expr_test_not_nullable order by id"""
	qt_sql_test_Boolean_TinyInt_4 """
		select id, BITAND(kbool, ktint), BITOR(kbool, ktint), BITXOR(kbool, ktint) from expr_test order by id"""
	qt_sql_test_Boolean_TinyInt_notn_4 """
		select id, BITAND(kbool, ktint), BITOR(kbool, ktint), BITXOR(kbool, ktint) from expr_test_not_nullable order by id"""
	qt_sql_test_Boolean_SmallInt_0 """
		select id, kbool + ksint, kbool - ksint from expr_test order by id"""
	qt_sql_test_Boolean_SmallInt_notn_0 """
		select id, kbool + ksint, kbool - ksint from expr_test_not_nullable order by id"""
	qt_sql_test_Boolean_SmallInt_1 """
		select id, kbool * ksint, kbool / ksint, kbool % ksint from expr_test order by id"""
	qt_sql_test_Boolean_SmallInt_notn_1 """
		select id, kbool * ksint, kbool / ksint, kbool % ksint from expr_test_not_nullable order by id"""
	qt_sql_test_Boolean_SmallInt_2 """
		select id, kbool DIV ksint from expr_test order by id"""
	qt_sql_test_Boolean_SmallInt_notn_2 """
		select id, kbool DIV ksint from expr_test_not_nullable order by id"""
	qt_sql_test_Boolean_SmallInt_3 """
		select id, kbool & ksint, kbool | ksint, kbool ^ ksint from expr_test order by id"""
	qt_sql_test_Boolean_SmallInt_notn_3 """
		select id, kbool & ksint, kbool | ksint, kbool ^ ksint from expr_test_not_nullable order by id"""
	qt_sql_test_Boolean_SmallInt_4 """
		select id, BITAND(kbool, ksint), BITOR(kbool, ksint), BITXOR(kbool, ksint) from expr_test order by id"""
	qt_sql_test_Boolean_SmallInt_notn_4 """
		select id, BITAND(kbool, ksint), BITOR(kbool, ksint), BITXOR(kbool, ksint) from expr_test_not_nullable order by id"""
	qt_sql_test_Boolean_Integer_0 """
		select id, kbool + kint, kbool - kint from expr_test order by id"""
	qt_sql_test_Boolean_Integer_notn_0 """
		select id, kbool + kint, kbool - kint from expr_test_not_nullable order by id"""
	qt_sql_test_Boolean_Integer_1 """
		select id, kbool * kint, kbool / kint, kbool % kint from expr_test order by id"""
	qt_sql_test_Boolean_Integer_notn_1 """
		select id, kbool * kint, kbool / kint, kbool % kint from expr_test_not_nullable order by id"""
	qt_sql_test_Boolean_Integer_2 """
		select id, kbool DIV kint from expr_test order by id"""
	qt_sql_test_Boolean_Integer_notn_2 """
		select id, kbool DIV kint from expr_test_not_nullable order by id"""
	qt_sql_test_Boolean_Integer_3 """
		select id, kbool & kint, kbool | kint, kbool ^ kint from expr_test order by id"""
	qt_sql_test_Boolean_Integer_notn_3 """
		select id, kbool & kint, kbool | kint, kbool ^ kint from expr_test_not_nullable order by id"""
	qt_sql_test_Boolean_Integer_4 """
		select id, BITAND(kbool, kint), BITOR(kbool, kint), BITXOR(kbool, kint) from expr_test order by id"""
	qt_sql_test_Boolean_Integer_notn_4 """
		select id, BITAND(kbool, kint), BITOR(kbool, kint), BITXOR(kbool, kint) from expr_test_not_nullable order by id"""
	qt_sql_test_Boolean_BigInt_0 """
		select id, kbool + kbint, kbool - kbint from expr_test order by id"""
	qt_sql_test_Boolean_BigInt_notn_0 """
		select id, kbool + kbint, kbool - kbint from expr_test_not_nullable order by id"""
	qt_sql_test_Boolean_BigInt_1 """
		select id, kbool * kbint, kbool / kbint, kbool % kbint from expr_test order by id"""
	qt_sql_test_Boolean_BigInt_notn_1 """
		select id, kbool * kbint, kbool / kbint, kbool % kbint from expr_test_not_nullable order by id"""
	qt_sql_test_Boolean_BigInt_2 """
		select id, kbool DIV kbint from expr_test order by id"""
	qt_sql_test_Boolean_BigInt_notn_2 """
		select id, kbool DIV kbint from expr_test_not_nullable order by id"""
	qt_sql_test_Boolean_BigInt_3 """
		select id, kbool & kbint, kbool | kbint, kbool ^ kbint from expr_test order by id"""
	qt_sql_test_Boolean_BigInt_notn_3 """
		select id, kbool & kbint, kbool | kbint, kbool ^ kbint from expr_test_not_nullable order by id"""
	qt_sql_test_Boolean_BigInt_4 """
		select id, BITAND(kbool, kbint), BITOR(kbool, kbint), BITXOR(kbool, kbint) from expr_test order by id"""
	qt_sql_test_Boolean_BigInt_notn_4 """
		select id, BITAND(kbool, kbint), BITOR(kbool, kbint), BITXOR(kbool, kbint) from expr_test_not_nullable order by id"""
	qt_sql_test_Boolean_LargeInt_0 """
		select id, kbool + klint, kbool - klint from expr_test order by id"""
	qt_sql_test_Boolean_LargeInt_notn_0 """
		select id, kbool + klint, kbool - klint from expr_test_not_nullable order by id"""
	qt_sql_test_Boolean_LargeInt_1 """
		select id, kbool * klint, kbool / klint, kbool % klint from expr_test order by id"""
	qt_sql_test_Boolean_LargeInt_notn_1 """
		select id, kbool * klint, kbool / klint, kbool % klint from expr_test_not_nullable order by id"""
	//original planner qt_sql_test_Boolean_LargeInt_2 """
	//original planner 	select id, kbool DIV klint from expr_test order by id"""
	//original planner qt_sql_test_Boolean_LargeInt_notn_2 """
	//original planner 	select id, kbool DIV klint from expr_test_not_nullable order by id"""
	qt_sql_test_Boolean_LargeInt_3 """
		select id, kbool & klint, kbool | klint, kbool ^ klint from expr_test order by id"""
	qt_sql_test_Boolean_LargeInt_notn_3 """
		select id, kbool & klint, kbool | klint, kbool ^ klint from expr_test_not_nullable order by id"""
	qt_sql_test_Boolean_LargeInt_4 """
		select id, BITAND(kbool, klint), BITOR(kbool, klint), BITXOR(kbool, klint) from expr_test order by id"""
	qt_sql_test_Boolean_LargeInt_notn_4 """
		select id, BITAND(kbool, klint), BITOR(kbool, klint), BITXOR(kbool, klint) from expr_test_not_nullable order by id"""
	qt_sql_test_Boolean_Float_0 """
		select id, kbool + kfloat, kbool - kfloat from expr_test order by id"""
	qt_sql_test_Boolean_Float_notn_0 """
		select id, kbool + kfloat, kbool - kfloat from expr_test_not_nullable order by id"""
	qt_sql_test_Boolean_Float_1 """
		select id, kbool * kfloat, kbool / kfloat, kbool % kfloat from expr_test order by id"""
	qt_sql_test_Boolean_Float_notn_1 """
		select id, kbool * kfloat, kbool / kfloat, kbool % kfloat from expr_test_not_nullable order by id"""
	//original planner qt_sql_test_Boolean_Float_2 """
	//original planner 	select id, kbool DIV kfloat from expr_test order by id"""
	//original planner qt_sql_test_Boolean_Float_notn_2 """
	//original planner 	select id, kbool DIV kfloat from expr_test_not_nullable order by id"""
	qt_sql_test_Boolean_Float_3 """
		select id, kbool & kfloat, kbool | kfloat, kbool ^ kfloat from expr_test order by id"""
	qt_sql_test_Boolean_Float_notn_3 """
		select id, kbool & kfloat, kbool | kfloat, kbool ^ kfloat from expr_test_not_nullable order by id"""
	qt_sql_test_Boolean_Float_4 """
		select id, BITAND(kbool, kfloat), BITOR(kbool, kfloat), BITXOR(kbool, kfloat) from expr_test order by id"""
	qt_sql_test_Boolean_Float_notn_4 """
		select id, BITAND(kbool, kfloat), BITOR(kbool, kfloat), BITXOR(kbool, kfloat) from expr_test_not_nullable order by id"""
	qt_sql_test_Boolean_Double_0 """
		select id, kbool + kdbl, kbool - kdbl from expr_test order by id"""
	qt_sql_test_Boolean_Double_notn_0 """
		select id, kbool + kdbl, kbool - kdbl from expr_test_not_nullable order by id"""
	qt_sql_test_Boolean_Double_1 """
		select id, kbool * kdbl, kbool / kdbl, kbool % kdbl from expr_test order by id"""
	qt_sql_test_Boolean_Double_notn_1 """
		select id, kbool * kdbl, kbool / kdbl, kbool % kdbl from expr_test_not_nullable order by id"""
	//original planner qt_sql_test_Boolean_Double_2 """
	//original planner 	select id, kbool DIV kdbl from expr_test order by id"""
	//original planner qt_sql_test_Boolean_Double_notn_2 """
	//original planner 	select id, kbool DIV kdbl from expr_test_not_nullable order by id"""
	qt_sql_test_Boolean_Double_3 """
		select id, kbool & kdbl, kbool | kdbl, kbool ^ kdbl from expr_test order by id"""
	qt_sql_test_Boolean_Double_notn_3 """
		select id, kbool & kdbl, kbool | kdbl, kbool ^ kdbl from expr_test_not_nullable order by id"""
	qt_sql_test_Boolean_Double_4 """
		select id, BITAND(kbool, kdbl), BITOR(kbool, kdbl), BITXOR(kbool, kdbl) from expr_test order by id"""
	qt_sql_test_Boolean_Double_notn_4 """
		select id, BITAND(kbool, kdbl), BITOR(kbool, kdbl), BITXOR(kbool, kdbl) from expr_test_not_nullable order by id"""
	qt_sql_test_Boolean_DecimalV2_0 """
		select id, kbool + kdcml, kbool - kdcml from expr_test order by id"""
	qt_sql_test_Boolean_DecimalV2_notn_0 """
		select id, kbool + kdcml, kbool - kdcml from expr_test_not_nullable order by id"""
	qt_sql_test_Boolean_DecimalV2_1 """
		select id, kbool * kdcml, kbool / kdcml, kbool % kdcml from expr_test order by id"""
	qt_sql_test_Boolean_DecimalV2_notn_1 """
		select id, kbool * kdcml, kbool / kdcml, kbool % kdcml from expr_test_not_nullable order by id"""
	qt_sql_test_Boolean_DecimalV2_2 """
		select id, kbool DIV kdcml from expr_test order by id"""
	qt_sql_test_Boolean_DecimalV2_notn_2 """
		select id, kbool DIV kdcml from expr_test_not_nullable order by id"""
	qt_sql_test_Boolean_DecimalV2_3 """
		select id, kbool & kdcml, kbool | kdcml, kbool ^ kdcml from expr_test order by id"""
	qt_sql_test_Boolean_DecimalV2_notn_3 """
		select id, kbool & kdcml, kbool | kdcml, kbool ^ kdcml from expr_test_not_nullable order by id"""
	// qt_sql_test_Boolean_DecimalV2_4 """
	// 	select id, BITAND(kbool, kdcml), BITOR(kbool, kdcml), BITXOR(kbool, kdcml) from expr_test order by id"""
	// qt_sql_test_Boolean_DecimalV2_notn_4 """
	// 	select id, BITAND(kbool, kdcml), BITOR(kbool, kdcml), BITXOR(kbool, kdcml) from expr_test_not_nullable order by id"""
	qt_sql_test_Boolean_Decimal32V3_0 """
		select id, kbool + kdcml32v3, kbool - kdcml32v3 from expr_test order by id"""
	qt_sql_test_Boolean_Decimal32V3_notn_0 """
		select id, kbool + kdcml32v3, kbool - kdcml32v3 from expr_test_not_nullable order by id"""
	//original planner qt_sql_test_Boolean_Decimal32V3_1 """
	//original planner 	select id, kbool * kdcml32v3, kbool / kdcml32v3, kbool % kdcml32v3 from expr_test order by id"""
	//original planner qt_sql_test_Boolean_Decimal32V3_notn_1 """
	//original planner 	select id, kbool * kdcml32v3, kbool / kdcml32v3, kbool % kdcml32v3 from expr_test_not_nullable order by id"""
	qt_sql_test_Boolean_Decimal32V3_2 """
		select id, kbool DIV kdcml32v3 from expr_test order by id"""
	qt_sql_test_Boolean_Decimal32V3_notn_2 """
		select id, kbool DIV kdcml32v3 from expr_test_not_nullable order by id"""
	qt_sql_test_Boolean_Decimal32V3_3 """
		select id, kbool & kdcml32v3, kbool | kdcml32v3, kbool ^ kdcml32v3 from expr_test order by id"""
	qt_sql_test_Boolean_Decimal32V3_notn_3 """
		select id, kbool & kdcml32v3, kbool | kdcml32v3, kbool ^ kdcml32v3 from expr_test_not_nullable order by id"""
	// qt_sql_test_Boolean_Decimal32V3_4 """
	// 	select id, BITAND(kbool, kdcml32v3), BITOR(kbool, kdcml32v3), BITXOR(kbool, kdcml32v3) from expr_test order by id"""
	// qt_sql_test_Boolean_Decimal32V3_notn_4 """
	// 	select id, BITAND(kbool, kdcml32v3), BITOR(kbool, kdcml32v3), BITXOR(kbool, kdcml32v3) from expr_test_not_nullable order by id"""
	qt_sql_test_Boolean_Decimal64V3_0 """
		select id, kbool + kdcml64v3, kbool - kdcml64v3 from expr_test order by id"""
	qt_sql_test_Boolean_Decimal64V3_notn_0 """
		select id, kbool + kdcml64v3, kbool - kdcml64v3 from expr_test_not_nullable order by id"""
	//original planner qt_sql_test_Boolean_Decimal64V3_1 """
	//original planner 	select id, kbool * kdcml64v3, kbool / kdcml64v3, kbool % kdcml64v3 from expr_test order by id"""
	//original planner qt_sql_test_Boolean_Decimal64V3_notn_1 """
	//original planner 	select id, kbool * kdcml64v3, kbool / kdcml64v3, kbool % kdcml64v3 from expr_test_not_nullable order by id"""
	qt_sql_test_Boolean_Decimal64V3_2 """
		select id, kbool DIV kdcml64v3 from expr_test order by id"""
	qt_sql_test_Boolean_Decimal64V3_notn_2 """
		select id, kbool DIV kdcml64v3 from expr_test_not_nullable order by id"""
	qt_sql_test_Boolean_Decimal64V3_3 """
		select id, kbool & kdcml64v3, kbool | kdcml64v3, kbool ^ kdcml64v3 from expr_test order by id"""
	qt_sql_test_Boolean_Decimal64V3_notn_3 """
		select id, kbool & kdcml64v3, kbool | kdcml64v3, kbool ^ kdcml64v3 from expr_test_not_nullable order by id"""
	// qt_sql_test_Boolean_Decimal64V3_4 """
	// 	select id, BITAND(kbool, kdcml64v3), BITOR(kbool, kdcml64v3), BITXOR(kbool, kdcml64v3) from expr_test order by id"""
	// qt_sql_test_Boolean_Decimal64V3_notn_4 """
	// 	select id, BITAND(kbool, kdcml64v3), BITOR(kbool, kdcml64v3), BITXOR(kbool, kdcml64v3) from expr_test_not_nullable order by id"""
	qt_sql_test_Boolean_Decimal128V3_0 """
		select id, kbool + kdcml128v3, kbool - kdcml128v3 from expr_test order by id"""
	qt_sql_test_Boolean_Decimal128V3_notn_0 """
		select id, kbool + kdcml128v3, kbool - kdcml128v3 from expr_test_not_nullable order by id"""
	//original planner qt_sql_test_Boolean_Decimal128V3_1 """
	//original planner 	select id, kbool * kdcml128v3, kbool / kdcml128v3, kbool % kdcml128v3 from expr_test order by id"""
	//original planner qt_sql_test_Boolean_Decimal128V3_notn_1 """
	//original planner 	select id, kbool * kdcml128v3, kbool / kdcml128v3, kbool % kdcml128v3 from expr_test_not_nullable order by id"""
	qt_sql_test_Boolean_Decimal128V3_2 """
		select id, kbool DIV kdcml128v3 from expr_test order by id"""
	qt_sql_test_Boolean_Decimal128V3_notn_2 """
		select id, kbool DIV kdcml128v3 from expr_test_not_nullable order by id"""
	qt_sql_test_Boolean_Decimal128V3_3 """
		select id, kbool & kdcml128v3, kbool | kdcml128v3, kbool ^ kdcml128v3 from expr_test order by id"""
	qt_sql_test_Boolean_Decimal128V3_notn_3 """
		select id, kbool & kdcml128v3, kbool | kdcml128v3, kbool ^ kdcml128v3 from expr_test_not_nullable order by id"""
	// qt_sql_test_Boolean_Decimal128V3_4 """
	// 	select id, BITAND(kbool, kdcml128v3), BITOR(kbool, kdcml128v3), BITXOR(kbool, kdcml128v3) from expr_test order by id"""
	// qt_sql_test_Boolean_Decimal128V3_notn_4 """
	// 	select id, BITAND(kbool, kdcml128v3), BITOR(kbool, kdcml128v3), BITXOR(kbool, kdcml128v3) from expr_test_not_nullable order by id"""
	qt_sql_test_Boolean_Char_0 """
		select id, kbool + kchr, kbool - kchr from expr_test order by id"""
	qt_sql_test_Boolean_Char_notn_0 """
		select id, kbool + kchr, kbool - kchr from expr_test_not_nullable order by id"""
	qt_sql_test_Boolean_Char_1 """
		select id, kbool * kchr, kbool / kchr, kbool % kchr from expr_test order by id"""
	qt_sql_test_Boolean_Char_notn_1 """
		select id, kbool * kchr, kbool / kchr, kbool % kchr from expr_test_not_nullable order by id"""
	//original planner qt_sql_test_Boolean_Char_2 """
	//original planner 	select id, kbool DIV kchr from expr_test order by id"""
	//original planner qt_sql_test_Boolean_Char_notn_2 """
	//original planner 	select id, kbool DIV kchr from expr_test_not_nullable order by id"""
	qt_sql_test_Boolean_Char_3 """
		select id, kbool & kchr, kbool | kchr, kbool ^ kchr from expr_test order by id"""
	qt_sql_test_Boolean_Char_notn_3 """
		select id, kbool & kchr, kbool | kchr, kbool ^ kchr from expr_test_not_nullable order by id"""
	// qt_sql_test_Boolean_Char_4 """
	// 	select id, BITAND(kbool, kchr), BITOR(kbool, kchr), BITXOR(kbool, kchr) from expr_test order by id"""
	// qt_sql_test_Boolean_Char_notn_4 """
	// 	select id, BITAND(kbool, kchr), BITOR(kbool, kchr), BITXOR(kbool, kchr) from expr_test_not_nullable order by id"""
	qt_sql_test_Boolean_Varchar_0 """
		select id, kbool + kvchr, kbool - kvchr from expr_test order by id"""
	qt_sql_test_Boolean_Varchar_notn_0 """
		select id, kbool + kvchr, kbool - kvchr from expr_test_not_nullable order by id"""
	qt_sql_test_Boolean_Varchar_1 """
		select id, kbool * kvchr, kbool / kvchr, kbool % kvchr from expr_test order by id"""
	qt_sql_test_Boolean_Varchar_notn_1 """
		select id, kbool * kvchr, kbool / kvchr, kbool % kvchr from expr_test_not_nullable order by id"""
	//original planner qt_sql_test_Boolean_Varchar_2 """
	//original planner 	select id, kbool DIV kvchr from expr_test order by id"""
	//original planner qt_sql_test_Boolean_Varchar_notn_2 """
	//original planner 	select id, kbool DIV kvchr from expr_test_not_nullable order by id"""
	qt_sql_test_Boolean_Varchar_3 """
		select id, kbool & kvchr, kbool | kvchr, kbool ^ kvchr from expr_test order by id"""
	qt_sql_test_Boolean_Varchar_notn_3 """
		select id, kbool & kvchr, kbool | kvchr, kbool ^ kvchr from expr_test_not_nullable order by id"""
	// qt_sql_test_Boolean_Varchar_4 """
	// 	select id, BITAND(kbool, kvchr), BITOR(kbool, kvchr), BITXOR(kbool, kvchr) from expr_test order by id"""
	// qt_sql_test_Boolean_Varchar_notn_4 """
	// 	select id, BITAND(kbool, kvchr), BITOR(kbool, kvchr), BITXOR(kbool, kvchr) from expr_test_not_nullable order by id"""
	qt_sql_test_Boolean_String_0 """
		select id, kbool + kstr, kbool - kstr from expr_test order by id"""
	qt_sql_test_Boolean_String_notn_0 """
		select id, kbool + kstr, kbool - kstr from expr_test_not_nullable order by id"""
	qt_sql_test_Boolean_String_1 """
		select id, kbool * kstr, kbool / kstr, kbool % kstr from expr_test order by id"""
	qt_sql_test_Boolean_String_notn_1 """
		select id, kbool * kstr, kbool / kstr, kbool % kstr from expr_test_not_nullable order by id"""
	//original planner qt_sql_test_Boolean_String_2 """
	//original planner 	select id, kbool DIV kstr from expr_test order by id"""
	//original planner qt_sql_test_Boolean_String_notn_2 """
	//original planner 	select id, kbool DIV kstr from expr_test_not_nullable order by id"""
	qt_sql_test_Boolean_String_3 """
		select id, kbool & kstr, kbool | kstr, kbool ^ kstr from expr_test order by id"""
	qt_sql_test_Boolean_String_notn_3 """
		select id, kbool & kstr, kbool | kstr, kbool ^ kstr from expr_test_not_nullable order by id"""
	// qt_sql_test_Boolean_String_4 """
	// 	select id, BITAND(kbool, kstr), BITOR(kbool, kstr), BITXOR(kbool, kstr) from expr_test order by id"""
	// qt_sql_test_Boolean_String_notn_4 """
	// 	select id, BITAND(kbool, kstr), BITOR(kbool, kstr), BITXOR(kbool, kstr) from expr_test_not_nullable order by id"""
	qt_sql_test_Boolean_Date_0 """
		select id, kbool + kdt, kbool - kdt from expr_test order by id"""
	qt_sql_test_Boolean_Date_notn_0 """
		select id, kbool + kdt, kbool - kdt from expr_test_not_nullable order by id"""
	qt_sql_test_Boolean_Date_1 """
		select id, kbool * kdt, kbool / kdt, kbool % kdt from expr_test order by id"""
	qt_sql_test_Boolean_Date_notn_1 """
		select id, kbool * kdt, kbool / kdt, kbool % kdt from expr_test_not_nullable order by id"""
	qt_sql_test_Boolean_Date_2 """
		select id, kbool DIV kdt from expr_test order by id"""
	qt_sql_test_Boolean_Date_notn_2 """
		select id, kbool DIV kdt from expr_test_not_nullable order by id"""
	qt_sql_test_Boolean_Date_3 """
		select id, kbool & kdt, kbool | kdt, kbool ^ kdt from expr_test order by id"""
	qt_sql_test_Boolean_Date_notn_3 """
		select id, kbool & kdt, kbool | kdt, kbool ^ kdt from expr_test_not_nullable order by id"""
	qt_sql_test_Boolean_Date_4 """
		select id, BITAND(kbool, kdt), BITOR(kbool, kdt), BITXOR(kbool, kdt) from expr_test order by id"""
	qt_sql_test_Boolean_Date_notn_4 """
		select id, BITAND(kbool, kdt), BITOR(kbool, kdt), BITXOR(kbool, kdt) from expr_test_not_nullable order by id"""
	qt_sql_test_Boolean_DateTime_0 """
		select id, kbool + kdtm, kbool - kdtm from expr_test order by id"""
	qt_sql_test_Boolean_DateTime_notn_0 """
		select id, kbool + kdtm, kbool - kdtm from expr_test_not_nullable order by id"""
	qt_sql_test_Boolean_DateTime_1 """
		select id, kbool * kdtm, kbool / kdtm, kbool % kdtm from expr_test order by id"""
	qt_sql_test_Boolean_DateTime_notn_1 """
		select id, kbool * kdtm, kbool / kdtm, kbool % kdtm from expr_test_not_nullable order by id"""
	qt_sql_test_Boolean_DateTime_2 """
		select id, kbool DIV kdtm from expr_test order by id"""
	qt_sql_test_Boolean_DateTime_notn_2 """
		select id, kbool DIV kdtm from expr_test_not_nullable order by id"""
	qt_sql_test_Boolean_DateTime_3 """
		select id, kbool & kdtm, kbool | kdtm, kbool ^ kdtm from expr_test order by id"""
	qt_sql_test_Boolean_DateTime_notn_3 """
		select id, kbool & kdtm, kbool | kdtm, kbool ^ kdtm from expr_test_not_nullable order by id"""
	qt_sql_test_Boolean_DateTime_4 """
		select id, BITAND(kbool, kdtm), BITOR(kbool, kdtm), BITXOR(kbool, kdtm) from expr_test order by id"""
	qt_sql_test_Boolean_DateTime_notn_4 """
		select id, BITAND(kbool, kdtm), BITOR(kbool, kdtm), BITXOR(kbool, kdtm) from expr_test_not_nullable order by id"""
	qt_sql_test_Boolean_DateV2_0 """
		select id, kbool + kdtv2, kbool - kdtv2 from expr_test order by id"""
	qt_sql_test_Boolean_DateV2_notn_0 """
		select id, kbool + kdtv2, kbool - kdtv2 from expr_test_not_nullable order by id"""
	qt_sql_test_Boolean_DateV2_1 """
		select id, kbool * kdtv2, kbool / kdtv2, kbool % kdtv2 from expr_test order by id"""
	qt_sql_test_Boolean_DateV2_notn_1 """
		select id, kbool * kdtv2, kbool / kdtv2, kbool % kdtv2 from expr_test_not_nullable order by id"""
	qt_sql_test_Boolean_DateV2_2 """
		select id, kbool DIV kdtv2 from expr_test order by id"""
	qt_sql_test_Boolean_DateV2_notn_2 """
		select id, kbool DIV kdtv2 from expr_test_not_nullable order by id"""
	qt_sql_test_Boolean_DateV2_3 """
		select id, kbool & kdtv2, kbool | kdtv2, kbool ^ kdtv2 from expr_test order by id"""
	qt_sql_test_Boolean_DateV2_notn_3 """
		select id, kbool & kdtv2, kbool | kdtv2, kbool ^ kdtv2 from expr_test_not_nullable order by id"""
	qt_sql_test_Boolean_DateV2_4 """
		select id, BITAND(kbool, kdtv2), BITOR(kbool, kdtv2), BITXOR(kbool, kdtv2) from expr_test order by id"""
	qt_sql_test_Boolean_DateV2_notn_4 """
		select id, BITAND(kbool, kdtv2), BITOR(kbool, kdtv2), BITXOR(kbool, kdtv2) from expr_test_not_nullable order by id"""
	qt_sql_test_Boolean_DateTimeV2_0 """
		select id, kbool + kdtmv2, kbool - kdtmv2 from expr_test order by id"""
	qt_sql_test_Boolean_DateTimeV2_notn_0 """
		select id, kbool + kdtmv2, kbool - kdtmv2 from expr_test_not_nullable order by id"""
	qt_sql_test_Boolean_DateTimeV2_1 """
		select id, kbool * kdtmv2, kbool / kdtmv2, kbool % kdtmv2 from expr_test order by id"""
	qt_sql_test_Boolean_DateTimeV2_notn_1 """
		select id, kbool * kdtmv2, kbool / kdtmv2, kbool % kdtmv2 from expr_test_not_nullable order by id"""
	qt_sql_test_Boolean_DateTimeV2_2 """
		select id, kbool DIV kdtmv2 from expr_test order by id"""
	qt_sql_test_Boolean_DateTimeV2_notn_2 """
		select id, kbool DIV kdtmv2 from expr_test_not_nullable order by id"""
	qt_sql_test_Boolean_DateTimeV2_3 """
		select id, kbool & kdtmv2, kbool | kdtmv2, kbool ^ kdtmv2 from expr_test order by id"""
	qt_sql_test_Boolean_DateTimeV2_notn_3 """
		select id, kbool & kdtmv2, kbool | kdtmv2, kbool ^ kdtmv2 from expr_test_not_nullable order by id"""
	qt_sql_test_Boolean_DateTimeV2_4 """
		select id, BITAND(kbool, kdtmv2), BITOR(kbool, kdtmv2), BITXOR(kbool, kdtmv2) from expr_test order by id"""
	qt_sql_test_Boolean_DateTimeV2_notn_4 """
		select id, BITAND(kbool, kdtmv2), BITOR(kbool, kdtmv2), BITXOR(kbool, kdtmv2) from expr_test_not_nullable order by id"""
	qt_sql_test_Boolean_Boolean_0 """
		select id, kbool + kbool, kbool - kbool from expr_test order by id"""
	qt_sql_test_Boolean_Boolean_notn_0 """
		select id, kbool + kbool, kbool - kbool from expr_test_not_nullable order by id"""
	qt_sql_test_Boolean_Boolean_1 """
		select id, kbool * kbool, kbool / kbool, kbool % kbool from expr_test order by id"""
	qt_sql_test_Boolean_Boolean_notn_1 """
		select id, kbool * kbool, kbool / kbool, kbool % kbool from expr_test_not_nullable order by id"""
	qt_sql_test_Boolean_Boolean_2 """
		select id, kbool DIV kbool from expr_test order by id"""
	qt_sql_test_Boolean_Boolean_notn_2 """
		select id, kbool DIV kbool from expr_test_not_nullable order by id"""
	qt_sql_test_Boolean_Boolean_3 """
		select id, kbool & kbool, kbool | kbool, kbool ^ kbool from expr_test order by id"""
	qt_sql_test_Boolean_Boolean_notn_3 """
		select id, kbool & kbool, kbool | kbool, kbool ^ kbool from expr_test_not_nullable order by id"""
	qt_sql_test_Boolean_Boolean_4 """
		select id, BITAND(kbool, kbool), BITOR(kbool, kbool), BITXOR(kbool, kbool) from expr_test order by id"""
	qt_sql_test_Boolean_Boolean_notn_4 """
		select id, BITAND(kbool, kbool), BITOR(kbool, kbool), BITXOR(kbool, kbool) from expr_test_not_nullable order by id"""
	qt_sql_test_TinyInt_TinyInt_0 """
		select id, ktint + ktint, ktint - ktint from expr_test order by id"""
	qt_sql_test_TinyInt_TinyInt_notn_0 """
		select id, ktint + ktint, ktint - ktint from expr_test_not_nullable order by id"""
	qt_sql_test_TinyInt_TinyInt_1 """
		select id, ktint * ktint, ktint / ktint, ktint % ktint from expr_test order by id"""
	qt_sql_test_TinyInt_TinyInt_notn_1 """
		select id, ktint * ktint, ktint / ktint, ktint % ktint from expr_test_not_nullable order by id"""
	qt_sql_test_TinyInt_TinyInt_2 """
		select id, ktint DIV ktint from expr_test order by id"""
	qt_sql_test_TinyInt_TinyInt_notn_2 """
		select id, ktint DIV ktint from expr_test_not_nullable order by id"""
	qt_sql_test_TinyInt_TinyInt_3 """
		select id, ktint & ktint, ktint | ktint, ktint ^ ktint from expr_test order by id"""
	qt_sql_test_TinyInt_TinyInt_notn_3 """
		select id, ktint & ktint, ktint | ktint, ktint ^ ktint from expr_test_not_nullable order by id"""
	qt_sql_test_TinyInt_TinyInt_4 """
		select id, BITAND(ktint, ktint), BITOR(ktint, ktint), BITXOR(ktint, ktint) from expr_test order by id"""
	qt_sql_test_TinyInt_TinyInt_notn_4 """
		select id, BITAND(ktint, ktint), BITOR(ktint, ktint), BITXOR(ktint, ktint) from expr_test_not_nullable order by id"""
	qt_sql_test_TinyInt_SmallInt_0 """
		select id, ktint + ksint, ktint - ksint from expr_test order by id"""
	qt_sql_test_TinyInt_SmallInt_notn_0 """
		select id, ktint + ksint, ktint - ksint from expr_test_not_nullable order by id"""
	qt_sql_test_TinyInt_SmallInt_1 """
		select id, ktint * ksint, ktint / ksint, ktint % ksint from expr_test order by id"""
	qt_sql_test_TinyInt_SmallInt_notn_1 """
		select id, ktint * ksint, ktint / ksint, ktint % ksint from expr_test_not_nullable order by id"""
	//original planner qt_sql_test_TinyInt_SmallInt_2 """
	//original planner 	select id, ktint DIV ksint from expr_test order by id"""
	//original planner qt_sql_test_TinyInt_SmallInt_notn_2 """
	//original planner 	select id, ktint DIV ksint from expr_test_not_nullable order by id"""
	qt_sql_test_TinyInt_SmallInt_3 """
		select id, ktint & ksint, ktint | ksint, ktint ^ ksint from expr_test order by id"""
	qt_sql_test_TinyInt_SmallInt_notn_3 """
		select id, ktint & ksint, ktint | ksint, ktint ^ ksint from expr_test_not_nullable order by id"""
	qt_sql_test_TinyInt_SmallInt_4 """
		select id, BITAND(ktint, ksint), BITOR(ktint, ksint), BITXOR(ktint, ksint) from expr_test order by id"""
	qt_sql_test_TinyInt_SmallInt_notn_4 """
		select id, BITAND(ktint, ksint), BITOR(ktint, ksint), BITXOR(ktint, ksint) from expr_test_not_nullable order by id"""
	qt_sql_test_TinyInt_Integer_0 """
		select id, ktint + kint, ktint - kint from expr_test order by id"""
	qt_sql_test_TinyInt_Integer_notn_0 """
		select id, ktint + kint, ktint - kint from expr_test_not_nullable order by id"""
	qt_sql_test_TinyInt_Integer_1 """
		select id, ktint * kint, ktint / kint, ktint % kint from expr_test order by id"""
	qt_sql_test_TinyInt_Integer_notn_1 """
		select id, ktint * kint, ktint / kint, ktint % kint from expr_test_not_nullable order by id"""
	//original planner qt_sql_test_TinyInt_Integer_2 """
	//original planner 	select id, ktint DIV kint from expr_test order by id"""
	//original planner qt_sql_test_TinyInt_Integer_notn_2 """
	//original planner 	select id, ktint DIV kint from expr_test_not_nullable order by id"""
	qt_sql_test_TinyInt_Integer_3 """
		select id, ktint & kint, ktint | kint, ktint ^ kint from expr_test order by id"""
	qt_sql_test_TinyInt_Integer_notn_3 """
		select id, ktint & kint, ktint | kint, ktint ^ kint from expr_test_not_nullable order by id"""
	qt_sql_test_TinyInt_Integer_4 """
		select id, BITAND(ktint, kint), BITOR(ktint, kint), BITXOR(ktint, kint) from expr_test order by id"""
	qt_sql_test_TinyInt_Integer_notn_4 """
		select id, BITAND(ktint, kint), BITOR(ktint, kint), BITXOR(ktint, kint) from expr_test_not_nullable order by id"""
	qt_sql_test_TinyInt_BigInt_0 """
		select id, ktint + kbint, ktint - kbint from expr_test order by id"""
	qt_sql_test_TinyInt_BigInt_notn_0 """
		select id, ktint + kbint, ktint - kbint from expr_test_not_nullable order by id"""
	qt_sql_test_TinyInt_BigInt_1 """
		select id, ktint * kbint, ktint / kbint, ktint % kbint from expr_test order by id"""
	qt_sql_test_TinyInt_BigInt_notn_1 """
		select id, ktint * kbint, ktint / kbint, ktint % kbint from expr_test_not_nullable order by id"""
	//original planner qt_sql_test_TinyInt_BigInt_2 """
	//original planner 	select id, ktint DIV kbint from expr_test order by id"""
	//original planner qt_sql_test_TinyInt_BigInt_notn_2 """
	//original planner 	select id, ktint DIV kbint from expr_test_not_nullable order by id"""
	qt_sql_test_TinyInt_BigInt_3 """
		select id, ktint & kbint, ktint | kbint, ktint ^ kbint from expr_test order by id"""
	qt_sql_test_TinyInt_BigInt_notn_3 """
		select id, ktint & kbint, ktint | kbint, ktint ^ kbint from expr_test_not_nullable order by id"""
	qt_sql_test_TinyInt_BigInt_4 """
		select id, BITAND(ktint, kbint), BITOR(ktint, kbint), BITXOR(ktint, kbint) from expr_test order by id"""
	qt_sql_test_TinyInt_BigInt_notn_4 """
		select id, BITAND(ktint, kbint), BITOR(ktint, kbint), BITXOR(ktint, kbint) from expr_test_not_nullable order by id"""
	qt_sql_test_TinyInt_LargeInt_0 """
		select id, ktint + klint, ktint - klint from expr_test order by id"""
	qt_sql_test_TinyInt_LargeInt_notn_0 """
		select id, ktint + klint, ktint - klint from expr_test_not_nullable order by id"""
	qt_sql_test_TinyInt_LargeInt_1 """
		select id, ktint * klint, ktint / klint, ktint % klint from expr_test order by id"""
	qt_sql_test_TinyInt_LargeInt_notn_1 """
		select id, ktint * klint, ktint / klint, ktint % klint from expr_test_not_nullable order by id"""
	//original planner qt_sql_test_TinyInt_LargeInt_2 """
	//original planner 	select id, ktint DIV klint from expr_test order by id"""
	//original planner qt_sql_test_TinyInt_LargeInt_notn_2 """
	//original planner 	select id, ktint DIV klint from expr_test_not_nullable order by id"""
	qt_sql_test_TinyInt_LargeInt_3 """
		select id, ktint & klint, ktint | klint, ktint ^ klint from expr_test order by id"""
	qt_sql_test_TinyInt_LargeInt_notn_3 """
		select id, ktint & klint, ktint | klint, ktint ^ klint from expr_test_not_nullable order by id"""
	qt_sql_test_TinyInt_LargeInt_4 """
		select id, BITAND(ktint, klint), BITOR(ktint, klint), BITXOR(ktint, klint) from expr_test order by id"""
	qt_sql_test_TinyInt_LargeInt_notn_4 """
		select id, BITAND(ktint, klint), BITOR(ktint, klint), BITXOR(ktint, klint) from expr_test_not_nullable order by id"""
	qt_sql_test_TinyInt_Float_0 """
		select id, ktint + kfloat, ktint - kfloat from expr_test order by id"""
	qt_sql_test_TinyInt_Float_notn_0 """
		select id, ktint + kfloat, ktint - kfloat from expr_test_not_nullable order by id"""
	qt_sql_test_TinyInt_Float_1 """
		select id, ktint * kfloat, ktint / kfloat, ktint % kfloat from expr_test order by id"""
	qt_sql_test_TinyInt_Float_notn_1 """
		select id, ktint * kfloat, ktint / kfloat, ktint % kfloat from expr_test_not_nullable order by id"""
	//original planner qt_sql_test_TinyInt_Float_2 """
	//original planner 	select id, ktint DIV kfloat from expr_test order by id"""
	//original planner qt_sql_test_TinyInt_Float_notn_2 """
	//original planner 	select id, ktint DIV kfloat from expr_test_not_nullable order by id"""
	qt_sql_test_TinyInt_Float_3 """
		select id, ktint & kfloat, ktint | kfloat, ktint ^ kfloat from expr_test order by id"""
	qt_sql_test_TinyInt_Float_notn_3 """
		select id, ktint & kfloat, ktint | kfloat, ktint ^ kfloat from expr_test_not_nullable order by id"""
	qt_sql_test_TinyInt_Float_4 """
		select id, BITAND(ktint, kfloat), BITOR(ktint, kfloat), BITXOR(ktint, kfloat) from expr_test order by id"""
	qt_sql_test_TinyInt_Float_notn_4 """
		select id, BITAND(ktint, kfloat), BITOR(ktint, kfloat), BITXOR(ktint, kfloat) from expr_test_not_nullable order by id"""
	qt_sql_test_TinyInt_Double_0 """
		select id, ktint + kdbl, ktint - kdbl from expr_test order by id"""
	qt_sql_test_TinyInt_Double_notn_0 """
		select id, ktint + kdbl, ktint - kdbl from expr_test_not_nullable order by id"""
	qt_sql_test_TinyInt_Double_1 """
		select id, ktint * kdbl, ktint / kdbl, ktint % kdbl from expr_test order by id"""
	qt_sql_test_TinyInt_Double_notn_1 """
		select id, ktint * kdbl, ktint / kdbl, ktint % kdbl from expr_test_not_nullable order by id"""
	//original planner qt_sql_test_TinyInt_Double_2 """
	//original planner 	select id, ktint DIV kdbl from expr_test order by id"""
	//original planner qt_sql_test_TinyInt_Double_notn_2 """
	//original planner 	select id, ktint DIV kdbl from expr_test_not_nullable order by id"""
	qt_sql_test_TinyInt_Double_3 """
		select id, ktint & kdbl, ktint | kdbl, ktint ^ kdbl from expr_test order by id"""
	qt_sql_test_TinyInt_Double_notn_3 """
		select id, ktint & kdbl, ktint | kdbl, ktint ^ kdbl from expr_test_not_nullable order by id"""
	qt_sql_test_TinyInt_Double_4 """
		select id, BITAND(ktint, kdbl), BITOR(ktint, kdbl), BITXOR(ktint, kdbl) from expr_test order by id"""
	qt_sql_test_TinyInt_Double_notn_4 """
		select id, BITAND(ktint, kdbl), BITOR(ktint, kdbl), BITXOR(ktint, kdbl) from expr_test_not_nullable order by id"""
	qt_sql_test_TinyInt_DecimalV2_0 """
		select id, ktint + kdcml, ktint - kdcml from expr_test order by id"""
	qt_sql_test_TinyInt_DecimalV2_notn_0 """
		select id, ktint + kdcml, ktint - kdcml from expr_test_not_nullable order by id"""
	qt_sql_test_TinyInt_DecimalV2_1 """
		select id, ktint * kdcml, ktint / kdcml, ktint % kdcml from expr_test order by id"""
	qt_sql_test_TinyInt_DecimalV2_notn_1 """
		select id, ktint * kdcml, ktint / kdcml, ktint % kdcml from expr_test_not_nullable order by id"""
	qt_sql_test_TinyInt_DecimalV2_2 """
		select id, ktint DIV kdcml from expr_test order by id"""
	qt_sql_test_TinyInt_DecimalV2_notn_2 """
		select id, ktint DIV kdcml from expr_test_not_nullable order by id"""
	qt_sql_test_TinyInt_DecimalV2_3 """
		select id, ktint & kdcml, ktint | kdcml, ktint ^ kdcml from expr_test order by id"""
	qt_sql_test_TinyInt_DecimalV2_notn_3 """
		select id, ktint & kdcml, ktint | kdcml, ktint ^ kdcml from expr_test_not_nullable order by id"""
	// qt_sql_test_TinyInt_DecimalV2_4 """
	// 	select id, BITAND(ktint, kdcml), BITOR(ktint, kdcml), BITXOR(ktint, kdcml) from expr_test order by id"""
	// qt_sql_test_TinyInt_DecimalV2_notn_4 """
	// 	select id, BITAND(ktint, kdcml), BITOR(ktint, kdcml), BITXOR(ktint, kdcml) from expr_test_not_nullable order by id"""
	qt_sql_test_TinyInt_Decimal32V3_0 """
		select id, ktint + kdcml32v3, ktint - kdcml32v3 from expr_test order by id"""
	qt_sql_test_TinyInt_Decimal32V3_notn_0 """
		select id, ktint + kdcml32v3, ktint - kdcml32v3 from expr_test_not_nullable order by id"""
	//original planner qt_sql_test_TinyInt_Decimal32V3_1 """
	//original planner 	select id, ktint * kdcml32v3, ktint / kdcml32v3, ktint % kdcml32v3 from expr_test order by id"""
	//original planner qt_sql_test_TinyInt_Decimal32V3_notn_1 """
	//original planner 	select id, ktint * kdcml32v3, ktint / kdcml32v3, ktint % kdcml32v3 from expr_test_not_nullable order by id"""
	qt_sql_test_TinyInt_Decimal32V3_2 """
		select id, ktint DIV kdcml32v3 from expr_test order by id"""
	qt_sql_test_TinyInt_Decimal32V3_notn_2 """
		select id, ktint DIV kdcml32v3 from expr_test_not_nullable order by id"""
	qt_sql_test_TinyInt_Decimal32V3_3 """
		select id, ktint & kdcml32v3, ktint | kdcml32v3, ktint ^ kdcml32v3 from expr_test order by id"""
	qt_sql_test_TinyInt_Decimal32V3_notn_3 """
		select id, ktint & kdcml32v3, ktint | kdcml32v3, ktint ^ kdcml32v3 from expr_test_not_nullable order by id"""
	// qt_sql_test_TinyInt_Decimal32V3_4 """
	// 	select id, BITAND(ktint, kdcml32v3), BITOR(ktint, kdcml32v3), BITXOR(ktint, kdcml32v3) from expr_test order by id"""
	// qt_sql_test_TinyInt_Decimal32V3_notn_4 """
	// 	select id, BITAND(ktint, kdcml32v3), BITOR(ktint, kdcml32v3), BITXOR(ktint, kdcml32v3) from expr_test_not_nullable order by id"""
	qt_sql_test_TinyInt_Decimal64V3_0 """
		select id, ktint + kdcml64v3, ktint - kdcml64v3 from expr_test order by id"""
	qt_sql_test_TinyInt_Decimal64V3_notn_0 """
		select id, ktint + kdcml64v3, ktint - kdcml64v3 from expr_test_not_nullable order by id"""
	//original planner qt_sql_test_TinyInt_Decimal64V3_1 """
	//original planner 	select id, ktint * kdcml64v3, ktint / kdcml64v3, ktint % kdcml64v3 from expr_test order by id"""
	//original planner qt_sql_test_TinyInt_Decimal64V3_notn_1 """
	//original planner 	select id, ktint * kdcml64v3, ktint / kdcml64v3, ktint % kdcml64v3 from expr_test_not_nullable order by id"""
	qt_sql_test_TinyInt_Decimal64V3_2 """
		select id, ktint DIV kdcml64v3 from expr_test order by id"""
	qt_sql_test_TinyInt_Decimal64V3_notn_2 """
		select id, ktint DIV kdcml64v3 from expr_test_not_nullable order by id"""
	qt_sql_test_TinyInt_Decimal64V3_3 """
		select id, ktint & kdcml64v3, ktint | kdcml64v3, ktint ^ kdcml64v3 from expr_test order by id"""
	qt_sql_test_TinyInt_Decimal64V3_notn_3 """
		select id, ktint & kdcml64v3, ktint | kdcml64v3, ktint ^ kdcml64v3 from expr_test_not_nullable order by id"""
	// qt_sql_test_TinyInt_Decimal64V3_4 """
	// 	select id, BITAND(ktint, kdcml64v3), BITOR(ktint, kdcml64v3), BITXOR(ktint, kdcml64v3) from expr_test order by id"""
	// qt_sql_test_TinyInt_Decimal64V3_notn_4 """
	// 	select id, BITAND(ktint, kdcml64v3), BITOR(ktint, kdcml64v3), BITXOR(ktint, kdcml64v3) from expr_test_not_nullable order by id"""
	qt_sql_test_TinyInt_Decimal128V3_0 """
		select id, ktint + kdcml128v3, ktint - kdcml128v3 from expr_test order by id"""
	qt_sql_test_TinyInt_Decimal128V3_notn_0 """
		select id, ktint + kdcml128v3, ktint - kdcml128v3 from expr_test_not_nullable order by id"""
	//original planner qt_sql_test_TinyInt_Decimal128V3_1 """
	//original planner 	select id, ktint * kdcml128v3, ktint / kdcml128v3, ktint % kdcml128v3 from expr_test order by id"""
	//original planner qt_sql_test_TinyInt_Decimal128V3_notn_1 """
	//original planner 	select id, ktint * kdcml128v3, ktint / kdcml128v3, ktint % kdcml128v3 from expr_test_not_nullable order by id"""
	qt_sql_test_TinyInt_Decimal128V3_2 """
		select id, ktint DIV kdcml128v3 from expr_test order by id"""
	qt_sql_test_TinyInt_Decimal128V3_notn_2 """
		select id, ktint DIV kdcml128v3 from expr_test_not_nullable order by id"""
	qt_sql_test_TinyInt_Decimal128V3_3 """
		select id, ktint & kdcml128v3, ktint | kdcml128v3, ktint ^ kdcml128v3 from expr_test order by id"""
	qt_sql_test_TinyInt_Decimal128V3_notn_3 """
		select id, ktint & kdcml128v3, ktint | kdcml128v3, ktint ^ kdcml128v3 from expr_test_not_nullable order by id"""
	// qt_sql_test_TinyInt_Decimal128V3_4 """
	// 	select id, BITAND(ktint, kdcml128v3), BITOR(ktint, kdcml128v3), BITXOR(ktint, kdcml128v3) from expr_test order by id"""
	// qt_sql_test_TinyInt_Decimal128V3_notn_4 """
	// 	select id, BITAND(ktint, kdcml128v3), BITOR(ktint, kdcml128v3), BITXOR(ktint, kdcml128v3) from expr_test_not_nullable order by id"""
	qt_sql_test_TinyInt_Char_0 """
		select id, ktint + kchr, ktint - kchr from expr_test order by id"""
	qt_sql_test_TinyInt_Char_notn_0 """
		select id, ktint + kchr, ktint - kchr from expr_test_not_nullable order by id"""
	qt_sql_test_TinyInt_Char_1 """
		select id, ktint * kchr, ktint / kchr, ktint % kchr from expr_test order by id"""
	qt_sql_test_TinyInt_Char_notn_1 """
		select id, ktint * kchr, ktint / kchr, ktint % kchr from expr_test_not_nullable order by id"""
	//original planner qt_sql_test_TinyInt_Char_2 """
	//original planner 	select id, ktint DIV kchr from expr_test order by id"""
	//original planner qt_sql_test_TinyInt_Char_notn_2 """
	//original planner 	select id, ktint DIV kchr from expr_test_not_nullable order by id"""
	qt_sql_test_TinyInt_Char_3 """
		select id, ktint & kchr, ktint | kchr, ktint ^ kchr from expr_test order by id"""
	qt_sql_test_TinyInt_Char_notn_3 """
		select id, ktint & kchr, ktint | kchr, ktint ^ kchr from expr_test_not_nullable order by id"""
	// qt_sql_test_TinyInt_Char_4 """
	// 	select id, BITAND(ktint, kchr), BITOR(ktint, kchr), BITXOR(ktint, kchr) from expr_test order by id"""
	// qt_sql_test_TinyInt_Char_notn_4 """
	// 	select id, BITAND(ktint, kchr), BITOR(ktint, kchr), BITXOR(ktint, kchr) from expr_test_not_nullable order by id"""
	qt_sql_test_TinyInt_Varchar_0 """
		select id, ktint + kvchr, ktint - kvchr from expr_test order by id"""
	qt_sql_test_TinyInt_Varchar_notn_0 """
		select id, ktint + kvchr, ktint - kvchr from expr_test_not_nullable order by id"""
	qt_sql_test_TinyInt_Varchar_1 """
		select id, ktint * kvchr, ktint / kvchr, ktint % kvchr from expr_test order by id"""
	qt_sql_test_TinyInt_Varchar_notn_1 """
		select id, ktint * kvchr, ktint / kvchr, ktint % kvchr from expr_test_not_nullable order by id"""
	//original planner qt_sql_test_TinyInt_Varchar_2 """
	//original planner 	select id, ktint DIV kvchr from expr_test order by id"""
	//original planner qt_sql_test_TinyInt_Varchar_notn_2 """
	//original planner 	select id, ktint DIV kvchr from expr_test_not_nullable order by id"""
	qt_sql_test_TinyInt_Varchar_3 """
		select id, ktint & kvchr, ktint | kvchr, ktint ^ kvchr from expr_test order by id"""
	qt_sql_test_TinyInt_Varchar_notn_3 """
		select id, ktint & kvchr, ktint | kvchr, ktint ^ kvchr from expr_test_not_nullable order by id"""
	// qt_sql_test_TinyInt_Varchar_4 """
	// 	select id, BITAND(ktint, kvchr), BITOR(ktint, kvchr), BITXOR(ktint, kvchr) from expr_test order by id"""
	// qt_sql_test_TinyInt_Varchar_notn_4 """
	// 	select id, BITAND(ktint, kvchr), BITOR(ktint, kvchr), BITXOR(ktint, kvchr) from expr_test_not_nullable order by id"""
	qt_sql_test_TinyInt_String_0 """
		select id, ktint + kstr, ktint - kstr from expr_test order by id"""
	qt_sql_test_TinyInt_String_notn_0 """
		select id, ktint + kstr, ktint - kstr from expr_test_not_nullable order by id"""
	qt_sql_test_TinyInt_String_1 """
		select id, ktint * kstr, ktint / kstr, ktint % kstr from expr_test order by id"""
	qt_sql_test_TinyInt_String_notn_1 """
		select id, ktint * kstr, ktint / kstr, ktint % kstr from expr_test_not_nullable order by id"""
	//original planner qt_sql_test_TinyInt_String_2 """
	//original planner 	select id, ktint DIV kstr from expr_test order by id"""
	//original planner qt_sql_test_TinyInt_String_notn_2 """
	//original planner 	select id, ktint DIV kstr from expr_test_not_nullable order by id"""
	qt_sql_test_TinyInt_String_3 """
		select id, ktint & kstr, ktint | kstr, ktint ^ kstr from expr_test order by id"""
	qt_sql_test_TinyInt_String_notn_3 """
		select id, ktint & kstr, ktint | kstr, ktint ^ kstr from expr_test_not_nullable order by id"""
	// qt_sql_test_TinyInt_String_4 """
	// 	select id, BITAND(ktint, kstr), BITOR(ktint, kstr), BITXOR(ktint, kstr) from expr_test order by id"""
	// qt_sql_test_TinyInt_String_notn_4 """
	// 	select id, BITAND(ktint, kstr), BITOR(ktint, kstr), BITXOR(ktint, kstr) from expr_test_not_nullable order by id"""
	qt_sql_test_TinyInt_Date_0 """
		select id, ktint + kdt, ktint - kdt from expr_test order by id"""
	qt_sql_test_TinyInt_Date_notn_0 """
		select id, ktint + kdt, ktint - kdt from expr_test_not_nullable order by id"""
	qt_sql_test_TinyInt_Date_1 """
		select id, ktint * kdt, ktint / kdt, ktint % kdt from expr_test order by id"""
	qt_sql_test_TinyInt_Date_notn_1 """
		select id, ktint * kdt, ktint / kdt, ktint % kdt from expr_test_not_nullable order by id"""
	//original planner qt_sql_test_TinyInt_Date_2 """
	//original planner 	select id, ktint DIV kdt from expr_test order by id"""
	//original planner qt_sql_test_TinyInt_Date_notn_2 """
	//original planner 	select id, ktint DIV kdt from expr_test_not_nullable order by id"""
	qt_sql_test_TinyInt_Date_3 """
		select id, ktint & kdt, ktint | kdt, ktint ^ kdt from expr_test order by id"""
	qt_sql_test_TinyInt_Date_notn_3 """
		select id, ktint & kdt, ktint | kdt, ktint ^ kdt from expr_test_not_nullable order by id"""
	qt_sql_test_TinyInt_Date_4 """
		select id, BITAND(ktint, kdt), BITOR(ktint, kdt), BITXOR(ktint, kdt) from expr_test order by id"""
	qt_sql_test_TinyInt_Date_notn_4 """
		select id, BITAND(ktint, kdt), BITOR(ktint, kdt), BITXOR(ktint, kdt) from expr_test_not_nullable order by id"""
	qt_sql_test_TinyInt_DateTime_0 """
		select id, ktint + kdtm, ktint - kdtm from expr_test order by id"""
	qt_sql_test_TinyInt_DateTime_notn_0 """
		select id, ktint + kdtm, ktint - kdtm from expr_test_not_nullable order by id"""
	qt_sql_test_TinyInt_DateTime_1 """
		select id, ktint * kdtm, ktint / kdtm, ktint % kdtm from expr_test order by id"""
	qt_sql_test_TinyInt_DateTime_notn_1 """
		select id, ktint * kdtm, ktint / kdtm, ktint % kdtm from expr_test_not_nullable order by id"""
	//original planner qt_sql_test_TinyInt_DateTime_2 """
	//original planner 	select id, ktint DIV kdtm from expr_test order by id"""
	//original planner qt_sql_test_TinyInt_DateTime_notn_2 """
	//original planner 	select id, ktint DIV kdtm from expr_test_not_nullable order by id"""
	qt_sql_test_TinyInt_DateTime_3 """
		select id, ktint & kdtm, ktint | kdtm, ktint ^ kdtm from expr_test order by id"""
	qt_sql_test_TinyInt_DateTime_notn_3 """
		select id, ktint & kdtm, ktint | kdtm, ktint ^ kdtm from expr_test_not_nullable order by id"""
	qt_sql_test_TinyInt_DateTime_4 """
		select id, BITAND(ktint, kdtm), BITOR(ktint, kdtm), BITXOR(ktint, kdtm) from expr_test order by id"""
	qt_sql_test_TinyInt_DateTime_notn_4 """
		select id, BITAND(ktint, kdtm), BITOR(ktint, kdtm), BITXOR(ktint, kdtm) from expr_test_not_nullable order by id"""
	qt_sql_test_TinyInt_DateV2_0 """
		select id, ktint + kdtv2, ktint - kdtv2 from expr_test order by id"""
	qt_sql_test_TinyInt_DateV2_notn_0 """
		select id, ktint + kdtv2, ktint - kdtv2 from expr_test_not_nullable order by id"""
	qt_sql_test_TinyInt_DateV2_1 """
		select id, ktint * kdtv2, ktint / kdtv2, ktint % kdtv2 from expr_test order by id"""
	qt_sql_test_TinyInt_DateV2_notn_1 """
		select id, ktint * kdtv2, ktint / kdtv2, ktint % kdtv2 from expr_test_not_nullable order by id"""
	//original planner qt_sql_test_TinyInt_DateV2_2 """
	//original planner 	select id, ktint DIV kdtv2 from expr_test order by id"""
	//original planner qt_sql_test_TinyInt_DateV2_notn_2 """
	//original planner 	select id, ktint DIV kdtv2 from expr_test_not_nullable order by id"""
	qt_sql_test_TinyInt_DateV2_3 """
		select id, ktint & kdtv2, ktint | kdtv2, ktint ^ kdtv2 from expr_test order by id"""
	qt_sql_test_TinyInt_DateV2_notn_3 """
		select id, ktint & kdtv2, ktint | kdtv2, ktint ^ kdtv2 from expr_test_not_nullable order by id"""
	qt_sql_test_TinyInt_DateV2_4 """
		select id, BITAND(ktint, kdtv2), BITOR(ktint, kdtv2), BITXOR(ktint, kdtv2) from expr_test order by id"""
	qt_sql_test_TinyInt_DateV2_notn_4 """
		select id, BITAND(ktint, kdtv2), BITOR(ktint, kdtv2), BITXOR(ktint, kdtv2) from expr_test_not_nullable order by id"""
	qt_sql_test_TinyInt_DateTimeV2_0 """
		select id, ktint + kdtmv2, ktint - kdtmv2 from expr_test order by id"""
	qt_sql_test_TinyInt_DateTimeV2_notn_0 """
		select id, ktint + kdtmv2, ktint - kdtmv2 from expr_test_not_nullable order by id"""
	qt_sql_test_TinyInt_DateTimeV2_1 """
		select id, ktint * kdtmv2, ktint / kdtmv2, ktint % kdtmv2 from expr_test order by id"""
	qt_sql_test_TinyInt_DateTimeV2_notn_1 """
		select id, ktint * kdtmv2, ktint / kdtmv2, ktint % kdtmv2 from expr_test_not_nullable order by id"""
	//original planner qt_sql_test_TinyInt_DateTimeV2_2 """
	//original planner 	select id, ktint DIV kdtmv2 from expr_test order by id"""
	//original planner qt_sql_test_TinyInt_DateTimeV2_notn_2 """
	//original planner 	select id, ktint DIV kdtmv2 from expr_test_not_nullable order by id"""
	qt_sql_test_TinyInt_DateTimeV2_3 """
		select id, ktint & kdtmv2, ktint | kdtmv2, ktint ^ kdtmv2 from expr_test order by id"""
	qt_sql_test_TinyInt_DateTimeV2_notn_3 """
		select id, ktint & kdtmv2, ktint | kdtmv2, ktint ^ kdtmv2 from expr_test_not_nullable order by id"""
	qt_sql_test_TinyInt_DateTimeV2_4 """
		select id, BITAND(ktint, kdtmv2), BITOR(ktint, kdtmv2), BITXOR(ktint, kdtmv2) from expr_test order by id"""
	qt_sql_test_TinyInt_DateTimeV2_notn_4 """
		select id, BITAND(ktint, kdtmv2), BITOR(ktint, kdtmv2), BITXOR(ktint, kdtmv2) from expr_test_not_nullable order by id"""
	qt_sql_test_TinyInt_Boolean_0 """
		select id, ktint + kbool, ktint - kbool from expr_test order by id"""
	qt_sql_test_TinyInt_Boolean_notn_0 """
		select id, ktint + kbool, ktint - kbool from expr_test_not_nullable order by id"""
	qt_sql_test_TinyInt_Boolean_1 """
		select id, ktint * kbool, ktint / kbool, ktint % kbool from expr_test order by id"""
	qt_sql_test_TinyInt_Boolean_notn_1 """
		select id, ktint * kbool, ktint / kbool, ktint % kbool from expr_test_not_nullable order by id"""
	//original planner qt_sql_test_TinyInt_Boolean_2 """
	//original planner 	select id, ktint DIV kbool from expr_test order by id"""
	//original planner qt_sql_test_TinyInt_Boolean_notn_2 """
	//original planner 	select id, ktint DIV kbool from expr_test_not_nullable order by id"""
	qt_sql_test_TinyInt_Boolean_3 """
		select id, ktint & kbool, ktint | kbool, ktint ^ kbool from expr_test order by id"""
	qt_sql_test_TinyInt_Boolean_notn_3 """
		select id, ktint & kbool, ktint | kbool, ktint ^ kbool from expr_test_not_nullable order by id"""
	qt_sql_test_TinyInt_Boolean_4 """
		select id, BITAND(ktint, kbool), BITOR(ktint, kbool), BITXOR(ktint, kbool) from expr_test order by id"""
	qt_sql_test_TinyInt_Boolean_notn_4 """
		select id, BITAND(ktint, kbool), BITOR(ktint, kbool), BITXOR(ktint, kbool) from expr_test_not_nullable order by id"""
	qt_sql_test_SmallInt_TinyInt_0 """
		select id, ksint + ktint, ksint - ktint from expr_test order by id"""
	qt_sql_test_SmallInt_TinyInt_notn_0 """
		select id, ksint + ktint, ksint - ktint from expr_test_not_nullable order by id"""
	qt_sql_test_SmallInt_TinyInt_1 """
		select id, ksint * ktint, ksint / ktint, ksint % ktint from expr_test order by id"""
	qt_sql_test_SmallInt_TinyInt_notn_1 """
		select id, ksint * ktint, ksint / ktint, ksint % ktint from expr_test_not_nullable order by id"""
	qt_sql_test_SmallInt_TinyInt_2 """
		select id, ksint DIV ktint from expr_test order by id"""
	qt_sql_test_SmallInt_TinyInt_notn_2 """
		select id, ksint DIV ktint from expr_test_not_nullable order by id"""
	qt_sql_test_SmallInt_TinyInt_3 """
		select id, ksint & ktint, ksint | ktint, ksint ^ ktint from expr_test order by id"""
	qt_sql_test_SmallInt_TinyInt_notn_3 """
		select id, ksint & ktint, ksint | ktint, ksint ^ ktint from expr_test_not_nullable order by id"""
	qt_sql_test_SmallInt_TinyInt_4 """
		select id, BITAND(ksint, ktint), BITOR(ksint, ktint), BITXOR(ksint, ktint) from expr_test order by id"""
	qt_sql_test_SmallInt_TinyInt_notn_4 """
		select id, BITAND(ksint, ktint), BITOR(ksint, ktint), BITXOR(ksint, ktint) from expr_test_not_nullable order by id"""
	qt_sql_test_SmallInt_SmallInt_0 """
		select id, ksint + ksint, ksint - ksint from expr_test order by id"""
	qt_sql_test_SmallInt_SmallInt_notn_0 """
		select id, ksint + ksint, ksint - ksint from expr_test_not_nullable order by id"""
	qt_sql_test_SmallInt_SmallInt_1 """
		select id, ksint * ksint, ksint / ksint, ksint % ksint from expr_test order by id"""
	qt_sql_test_SmallInt_SmallInt_notn_1 """
		select id, ksint * ksint, ksint / ksint, ksint % ksint from expr_test_not_nullable order by id"""
	qt_sql_test_SmallInt_SmallInt_2 """
		select id, ksint DIV ksint from expr_test order by id"""
	qt_sql_test_SmallInt_SmallInt_notn_2 """
		select id, ksint DIV ksint from expr_test_not_nullable order by id"""
	qt_sql_test_SmallInt_SmallInt_3 """
		select id, ksint & ksint, ksint | ksint, ksint ^ ksint from expr_test order by id"""
	qt_sql_test_SmallInt_SmallInt_notn_3 """
		select id, ksint & ksint, ksint | ksint, ksint ^ ksint from expr_test_not_nullable order by id"""
	qt_sql_test_SmallInt_SmallInt_4 """
		select id, BITAND(ksint, ksint), BITOR(ksint, ksint), BITXOR(ksint, ksint) from expr_test order by id"""
	qt_sql_test_SmallInt_SmallInt_notn_4 """
		select id, BITAND(ksint, ksint), BITOR(ksint, ksint), BITXOR(ksint, ksint) from expr_test_not_nullable order by id"""
	qt_sql_test_SmallInt_Integer_0 """
		select id, ksint + kint, ksint - kint from expr_test order by id"""
	qt_sql_test_SmallInt_Integer_notn_0 """
		select id, ksint + kint, ksint - kint from expr_test_not_nullable order by id"""
	qt_sql_test_SmallInt_Integer_1 """
		select id, ksint * kint, ksint / kint, ksint % kint from expr_test order by id"""
	qt_sql_test_SmallInt_Integer_notn_1 """
		select id, ksint * kint, ksint / kint, ksint % kint from expr_test_not_nullable order by id"""
	//original planner qt_sql_test_SmallInt_Integer_2 """
	//original planner 	select id, ksint DIV kint from expr_test order by id"""
	//original planner qt_sql_test_SmallInt_Integer_notn_2 """
	//original planner 	select id, ksint DIV kint from expr_test_not_nullable order by id"""
	qt_sql_test_SmallInt_Integer_3 """
		select id, ksint & kint, ksint | kint, ksint ^ kint from expr_test order by id"""
	qt_sql_test_SmallInt_Integer_notn_3 """
		select id, ksint & kint, ksint | kint, ksint ^ kint from expr_test_not_nullable order by id"""
	qt_sql_test_SmallInt_Integer_4 """
		select id, BITAND(ksint, kint), BITOR(ksint, kint), BITXOR(ksint, kint) from expr_test order by id"""
	qt_sql_test_SmallInt_Integer_notn_4 """
		select id, BITAND(ksint, kint), BITOR(ksint, kint), BITXOR(ksint, kint) from expr_test_not_nullable order by id"""
	qt_sql_test_SmallInt_BigInt_0 """
		select id, ksint + kbint, ksint - kbint from expr_test order by id"""
	qt_sql_test_SmallInt_BigInt_notn_0 """
		select id, ksint + kbint, ksint - kbint from expr_test_not_nullable order by id"""
	qt_sql_test_SmallInt_BigInt_1 """
		select id, ksint * kbint, ksint / kbint, ksint % kbint from expr_test order by id"""
	qt_sql_test_SmallInt_BigInt_notn_1 """
		select id, ksint * kbint, ksint / kbint, ksint % kbint from expr_test_not_nullable order by id"""
	//original planner qt_sql_test_SmallInt_BigInt_2 """
	//original planner 	select id, ksint DIV kbint from expr_test order by id"""
	//original planner qt_sql_test_SmallInt_BigInt_notn_2 """
	//original planner 	select id, ksint DIV kbint from expr_test_not_nullable order by id"""
	qt_sql_test_SmallInt_BigInt_3 """
		select id, ksint & kbint, ksint | kbint, ksint ^ kbint from expr_test order by id"""
	qt_sql_test_SmallInt_BigInt_notn_3 """
		select id, ksint & kbint, ksint | kbint, ksint ^ kbint from expr_test_not_nullable order by id"""
	qt_sql_test_SmallInt_BigInt_4 """
		select id, BITAND(ksint, kbint), BITOR(ksint, kbint), BITXOR(ksint, kbint) from expr_test order by id"""
	qt_sql_test_SmallInt_BigInt_notn_4 """
		select id, BITAND(ksint, kbint), BITOR(ksint, kbint), BITXOR(ksint, kbint) from expr_test_not_nullable order by id"""
	qt_sql_test_SmallInt_LargeInt_0 """
		select id, ksint + klint, ksint - klint from expr_test order by id"""
	qt_sql_test_SmallInt_LargeInt_notn_0 """
		select id, ksint + klint, ksint - klint from expr_test_not_nullable order by id"""
	qt_sql_test_SmallInt_LargeInt_1 """
		select id, ksint * klint, ksint / klint, ksint % klint from expr_test order by id"""
	qt_sql_test_SmallInt_LargeInt_notn_1 """
		select id, ksint * klint, ksint / klint, ksint % klint from expr_test_not_nullable order by id"""
	//original planner qt_sql_test_SmallInt_LargeInt_2 """
	//original planner 	select id, ksint DIV klint from expr_test order by id"""
	//original planner qt_sql_test_SmallInt_LargeInt_notn_2 """
	//original planner 	select id, ksint DIV klint from expr_test_not_nullable order by id"""
	qt_sql_test_SmallInt_LargeInt_3 """
		select id, ksint & klint, ksint | klint, ksint ^ klint from expr_test order by id"""
	qt_sql_test_SmallInt_LargeInt_notn_3 """
		select id, ksint & klint, ksint | klint, ksint ^ klint from expr_test_not_nullable order by id"""
	qt_sql_test_SmallInt_LargeInt_4 """
		select id, BITAND(ksint, klint), BITOR(ksint, klint), BITXOR(ksint, klint) from expr_test order by id"""
	qt_sql_test_SmallInt_LargeInt_notn_4 """
		select id, BITAND(ksint, klint), BITOR(ksint, klint), BITXOR(ksint, klint) from expr_test_not_nullable order by id"""
	qt_sql_test_SmallInt_Float_0 """
		select id, ksint + kfloat, ksint - kfloat from expr_test order by id"""
	qt_sql_test_SmallInt_Float_notn_0 """
		select id, ksint + kfloat, ksint - kfloat from expr_test_not_nullable order by id"""
	qt_sql_test_SmallInt_Float_1 """
		select id, ksint * kfloat, ksint / kfloat, ksint % kfloat from expr_test order by id"""
	qt_sql_test_SmallInt_Float_notn_1 """
		select id, ksint * kfloat, ksint / kfloat, ksint % kfloat from expr_test_not_nullable order by id"""
	//original planner qt_sql_test_SmallInt_Float_2 """
	//original planner 	select id, ksint DIV kfloat from expr_test order by id"""
	//original planner qt_sql_test_SmallInt_Float_notn_2 """
	//original planner 	select id, ksint DIV kfloat from expr_test_not_nullable order by id"""
	qt_sql_test_SmallInt_Float_3 """
		select id, ksint & kfloat, ksint | kfloat, ksint ^ kfloat from expr_test order by id"""
	qt_sql_test_SmallInt_Float_notn_3 """
		select id, ksint & kfloat, ksint | kfloat, ksint ^ kfloat from expr_test_not_nullable order by id"""
	// qt_sql_test_SmallInt_Float_4 """
	// 	select id, BITAND(ksint, kfloat), BITOR(ksint, kfloat), BITXOR(ksint, kfloat) from expr_test order by id"""
	// qt_sql_test_SmallInt_Float_notn_4 """
	// 	select id, BITAND(ksint, kfloat), BITOR(ksint, kfloat), BITXOR(ksint, kfloat) from expr_test_not_nullable order by id"""
	qt_sql_test_SmallInt_Double_0 """
		select id, ksint + kdbl, ksint - kdbl from expr_test order by id"""
	qt_sql_test_SmallInt_Double_notn_0 """
		select id, ksint + kdbl, ksint - kdbl from expr_test_not_nullable order by id"""
	qt_sql_test_SmallInt_Double_1 """
		select id, ksint * kdbl, ksint / kdbl, ksint % kdbl from expr_test order by id"""
	qt_sql_test_SmallInt_Double_notn_1 """
		select id, ksint * kdbl, ksint / kdbl, ksint % kdbl from expr_test_not_nullable order by id"""
	//original planner qt_sql_test_SmallInt_Double_2 """
	//original planner 	select id, ksint DIV kdbl from expr_test order by id"""
	//original planner qt_sql_test_SmallInt_Double_notn_2 """
	//original planner 	select id, ksint DIV kdbl from expr_test_not_nullable order by id"""
	qt_sql_test_SmallInt_Double_3 """
		select id, ksint & kdbl, ksint | kdbl, ksint ^ kdbl from expr_test order by id"""
	qt_sql_test_SmallInt_Double_notn_3 """
		select id, ksint & kdbl, ksint | kdbl, ksint ^ kdbl from expr_test_not_nullable order by id"""
	// qt_sql_test_SmallInt_Double_4 """
	// 	select id, BITAND(ksint, kdbl), BITOR(ksint, kdbl), BITXOR(ksint, kdbl) from expr_test order by id"""
	// qt_sql_test_SmallInt_Double_notn_4 """
	// 	select id, BITAND(ksint, kdbl), BITOR(ksint, kdbl), BITXOR(ksint, kdbl) from expr_test_not_nullable order by id"""
	qt_sql_test_SmallInt_DecimalV2_0 """
		select id, ksint + kdcml, ksint - kdcml from expr_test order by id"""
	qt_sql_test_SmallInt_DecimalV2_notn_0 """
		select id, ksint + kdcml, ksint - kdcml from expr_test_not_nullable order by id"""
	qt_sql_test_SmallInt_DecimalV2_1 """
		select id, ksint * kdcml, ksint / kdcml, ksint % kdcml from expr_test order by id"""
	qt_sql_test_SmallInt_DecimalV2_notn_1 """
		select id, ksint * kdcml, ksint / kdcml, ksint % kdcml from expr_test_not_nullable order by id"""
	qt_sql_test_SmallInt_DecimalV2_2 """
		select id, ksint DIV kdcml from expr_test order by id"""
	qt_sql_test_SmallInt_DecimalV2_notn_2 """
		select id, ksint DIV kdcml from expr_test_not_nullable order by id"""
	qt_sql_test_SmallInt_DecimalV2_3 """
		select id, ksint & kdcml, ksint | kdcml, ksint ^ kdcml from expr_test order by id"""
	qt_sql_test_SmallInt_DecimalV2_notn_3 """
		select id, ksint & kdcml, ksint | kdcml, ksint ^ kdcml from expr_test_not_nullable order by id"""
	// qt_sql_test_SmallInt_DecimalV2_4 """
	// 	select id, BITAND(ksint, kdcml), BITOR(ksint, kdcml), BITXOR(ksint, kdcml) from expr_test order by id"""
	// qt_sql_test_SmallInt_DecimalV2_notn_4 """
	// 	select id, BITAND(ksint, kdcml), BITOR(ksint, kdcml), BITXOR(ksint, kdcml) from expr_test_not_nullable order by id"""
	qt_sql_test_SmallInt_Decimal32V3_0 """
		select id, ksint + kdcml32v3, ksint - kdcml32v3 from expr_test order by id"""
	qt_sql_test_SmallInt_Decimal32V3_notn_0 """
		select id, ksint + kdcml32v3, ksint - kdcml32v3 from expr_test_not_nullable order by id"""
	//original planner qt_sql_test_SmallInt_Decimal32V3_1 """
	//original planner 	select id, ksint * kdcml32v3, ksint / kdcml32v3, ksint % kdcml32v3 from expr_test order by id"""
	//original planner qt_sql_test_SmallInt_Decimal32V3_notn_1 """
	//original planner 	select id, ksint * kdcml32v3, ksint / kdcml32v3, ksint % kdcml32v3 from expr_test_not_nullable order by id"""
	//original planner qt_sql_test_SmallInt_Decimal32V3_2 """
	//original planner 	select id, ksint DIV kdcml32v3 from expr_test order by id"""
	//original planner qt_sql_test_SmallInt_Decimal32V3_notn_2 """
	//original planner 	select id, ksint DIV kdcml32v3 from expr_test_not_nullable order by id"""
	qt_sql_test_SmallInt_Decimal32V3_3 """
		select id, ksint & kdcml32v3, ksint | kdcml32v3, ksint ^ kdcml32v3 from expr_test order by id"""
	qt_sql_test_SmallInt_Decimal32V3_notn_3 """
		select id, ksint & kdcml32v3, ksint | kdcml32v3, ksint ^ kdcml32v3 from expr_test_not_nullable order by id"""
	// qt_sql_test_SmallInt_Decimal32V3_4 """
	// 	select id, BITAND(ksint, kdcml32v3), BITOR(ksint, kdcml32v3), BITXOR(ksint, kdcml32v3) from expr_test order by id"""
	// qt_sql_test_SmallInt_Decimal32V3_notn_4 """
	// 	select id, BITAND(ksint, kdcml32v3), BITOR(ksint, kdcml32v3), BITXOR(ksint, kdcml32v3) from expr_test_not_nullable order by id"""
	qt_sql_test_SmallInt_Decimal64V3_0 """
		select id, ksint + kdcml64v3, ksint - kdcml64v3 from expr_test order by id"""
	qt_sql_test_SmallInt_Decimal64V3_notn_0 """
		select id, ksint + kdcml64v3, ksint - kdcml64v3 from expr_test_not_nullable order by id"""
	//original planner qt_sql_test_SmallInt_Decimal64V3_1 """
	//original planner 	select id, ksint * kdcml64v3, ksint / kdcml64v3, ksint % kdcml64v3 from expr_test order by id"""
	//original planner qt_sql_test_SmallInt_Decimal64V3_notn_1 """
	//original planner 	select id, ksint * kdcml64v3, ksint / kdcml64v3, ksint % kdcml64v3 from expr_test_not_nullable order by id"""
	//original planner qt_sql_test_SmallInt_Decimal64V3_2 """
	//original planner 	select id, ksint DIV kdcml64v3 from expr_test order by id"""
	//original planner qt_sql_test_SmallInt_Decimal64V3_notn_2 """
	//original planner 	select id, ksint DIV kdcml64v3 from expr_test_not_nullable order by id"""
	qt_sql_test_SmallInt_Decimal64V3_3 """
		select id, ksint & kdcml64v3, ksint | kdcml64v3, ksint ^ kdcml64v3 from expr_test order by id"""
	qt_sql_test_SmallInt_Decimal64V3_notn_3 """
		select id, ksint & kdcml64v3, ksint | kdcml64v3, ksint ^ kdcml64v3 from expr_test_not_nullable order by id"""
	// qt_sql_test_SmallInt_Decimal64V3_4 """
	// 	select id, BITAND(ksint, kdcml64v3), BITOR(ksint, kdcml64v3), BITXOR(ksint, kdcml64v3) from expr_test order by id"""
	// qt_sql_test_SmallInt_Decimal64V3_notn_4 """
	// 	select id, BITAND(ksint, kdcml64v3), BITOR(ksint, kdcml64v3), BITXOR(ksint, kdcml64v3) from expr_test_not_nullable order by id"""
	qt_sql_test_SmallInt_Decimal128V3_0 """
		select id, ksint + kdcml128v3, ksint - kdcml128v3 from expr_test order by id"""
	qt_sql_test_SmallInt_Decimal128V3_notn_0 """
		select id, ksint + kdcml128v3, ksint - kdcml128v3 from expr_test_not_nullable order by id"""
	//original planner qt_sql_test_SmallInt_Decimal128V3_1 """
	//original planner 	select id, ksint * kdcml128v3, ksint / kdcml128v3, ksint % kdcml128v3 from expr_test order by id"""
	//original planner qt_sql_test_SmallInt_Decimal128V3_notn_1 """
	//original planner 	select id, ksint * kdcml128v3, ksint / kdcml128v3, ksint % kdcml128v3 from expr_test_not_nullable order by id"""
	//original planner qt_sql_test_SmallInt_Decimal128V3_2 """
	//original planner 	select id, ksint DIV kdcml128v3 from expr_test order by id"""
	//original planner qt_sql_test_SmallInt_Decimal128V3_notn_2 """
	//original planner 	select id, ksint DIV kdcml128v3 from expr_test_not_nullable order by id"""
	qt_sql_test_SmallInt_Decimal128V3_3 """
		select id, ksint & kdcml128v3, ksint | kdcml128v3, ksint ^ kdcml128v3 from expr_test order by id"""
	qt_sql_test_SmallInt_Decimal128V3_notn_3 """
		select id, ksint & kdcml128v3, ksint | kdcml128v3, ksint ^ kdcml128v3 from expr_test_not_nullable order by id"""
	// qt_sql_test_SmallInt_Decimal128V3_4 """
	// 	select id, BITAND(ksint, kdcml128v3), BITOR(ksint, kdcml128v3), BITXOR(ksint, kdcml128v3) from expr_test order by id"""
	// qt_sql_test_SmallInt_Decimal128V3_notn_4 """
	// 	select id, BITAND(ksint, kdcml128v3), BITOR(ksint, kdcml128v3), BITXOR(ksint, kdcml128v3) from expr_test_not_nullable order by id"""
	qt_sql_test_SmallInt_Char_0 """
		select id, ksint + kchr, ksint - kchr from expr_test order by id"""
	qt_sql_test_SmallInt_Char_notn_0 """
		select id, ksint + kchr, ksint - kchr from expr_test_not_nullable order by id"""
	qt_sql_test_SmallInt_Char_1 """
		select id, ksint * kchr, ksint / kchr, ksint % kchr from expr_test order by id"""
	qt_sql_test_SmallInt_Char_notn_1 """
		select id, ksint * kchr, ksint / kchr, ksint % kchr from expr_test_not_nullable order by id"""
	//original planner qt_sql_test_SmallInt_Char_2 """
	//original planner 	select id, ksint DIV kchr from expr_test order by id"""
	//original planner qt_sql_test_SmallInt_Char_notn_2 """
	//original planner 	select id, ksint DIV kchr from expr_test_not_nullable order by id"""
	qt_sql_test_SmallInt_Char_3 """
		select id, ksint & kchr, ksint | kchr, ksint ^ kchr from expr_test order by id"""
	qt_sql_test_SmallInt_Char_notn_3 """
		select id, ksint & kchr, ksint | kchr, ksint ^ kchr from expr_test_not_nullable order by id"""
	// qt_sql_test_SmallInt_Char_4 """
	// 	select id, BITAND(ksint, kchr), BITOR(ksint, kchr), BITXOR(ksint, kchr) from expr_test order by id"""
	// qt_sql_test_SmallInt_Char_notn_4 """
	// 	select id, BITAND(ksint, kchr), BITOR(ksint, kchr), BITXOR(ksint, kchr) from expr_test_not_nullable order by id"""
	qt_sql_test_SmallInt_Varchar_0 """
		select id, ksint + kvchr, ksint - kvchr from expr_test order by id"""
	qt_sql_test_SmallInt_Varchar_notn_0 """
		select id, ksint + kvchr, ksint - kvchr from expr_test_not_nullable order by id"""
	qt_sql_test_SmallInt_Varchar_1 """
		select id, ksint * kvchr, ksint / kvchr, ksint % kvchr from expr_test order by id"""
	qt_sql_test_SmallInt_Varchar_notn_1 """
		select id, ksint * kvchr, ksint / kvchr, ksint % kvchr from expr_test_not_nullable order by id"""
	//original planner qt_sql_test_SmallInt_Varchar_2 """
	//original planner 	select id, ksint DIV kvchr from expr_test order by id"""
	//original planner qt_sql_test_SmallInt_Varchar_notn_2 """
	//original planner 	select id, ksint DIV kvchr from expr_test_not_nullable order by id"""
	qt_sql_test_SmallInt_Varchar_3 """
		select id, ksint & kvchr, ksint | kvchr, ksint ^ kvchr from expr_test order by id"""
	qt_sql_test_SmallInt_Varchar_notn_3 """
		select id, ksint & kvchr, ksint | kvchr, ksint ^ kvchr from expr_test_not_nullable order by id"""
	// qt_sql_test_SmallInt_Varchar_4 """
	// 	select id, BITAND(ksint, kvchr), BITOR(ksint, kvchr), BITXOR(ksint, kvchr) from expr_test order by id"""
	// qt_sql_test_SmallInt_Varchar_notn_4 """
	// 	select id, BITAND(ksint, kvchr), BITOR(ksint, kvchr), BITXOR(ksint, kvchr) from expr_test_not_nullable order by id"""
	qt_sql_test_SmallInt_String_0 """
		select id, ksint + kstr, ksint - kstr from expr_test order by id"""
	qt_sql_test_SmallInt_String_notn_0 """
		select id, ksint + kstr, ksint - kstr from expr_test_not_nullable order by id"""
	qt_sql_test_SmallInt_String_1 """
		select id, ksint * kstr, ksint / kstr, ksint % kstr from expr_test order by id"""
	qt_sql_test_SmallInt_String_notn_1 """
		select id, ksint * kstr, ksint / kstr, ksint % kstr from expr_test_not_nullable order by id"""
	//original planner qt_sql_test_SmallInt_String_2 """
	//original planner 	select id, ksint DIV kstr from expr_test order by id"""
	//original planner qt_sql_test_SmallInt_String_notn_2 """
	//original planner 	select id, ksint DIV kstr from expr_test_not_nullable order by id"""
	qt_sql_test_SmallInt_String_3 """
		select id, ksint & kstr, ksint | kstr, ksint ^ kstr from expr_test order by id"""
	qt_sql_test_SmallInt_String_notn_3 """
		select id, ksint & kstr, ksint | kstr, ksint ^ kstr from expr_test_not_nullable order by id"""
	// qt_sql_test_SmallInt_String_4 """
	// 	select id, BITAND(ksint, kstr), BITOR(ksint, kstr), BITXOR(ksint, kstr) from expr_test order by id"""
	// qt_sql_test_SmallInt_String_notn_4 """
	// 	select id, BITAND(ksint, kstr), BITOR(ksint, kstr), BITXOR(ksint, kstr) from expr_test_not_nullable order by id"""
	qt_sql_test_SmallInt_Date_0 """
		select id, ksint + kdt, ksint - kdt from expr_test order by id"""
	qt_sql_test_SmallInt_Date_notn_0 """
		select id, ksint + kdt, ksint - kdt from expr_test_not_nullable order by id"""
	qt_sql_test_SmallInt_Date_1 """
		select id, ksint * kdt, ksint / kdt, ksint % kdt from expr_test order by id"""
	qt_sql_test_SmallInt_Date_notn_1 """
		select id, ksint * kdt, ksint / kdt, ksint % kdt from expr_test_not_nullable order by id"""
	//original planner qt_sql_test_SmallInt_Date_2 """
	//original planner 	select id, ksint DIV kdt from expr_test order by id"""
	//original planner qt_sql_test_SmallInt_Date_notn_2 """
	//original planner 	select id, ksint DIV kdt from expr_test_not_nullable order by id"""
	qt_sql_test_SmallInt_Date_3 """
		select id, ksint & kdt, ksint | kdt, ksint ^ kdt from expr_test order by id"""
	qt_sql_test_SmallInt_Date_notn_3 """
		select id, ksint & kdt, ksint | kdt, ksint ^ kdt from expr_test_not_nullable order by id"""
	qt_sql_test_SmallInt_Date_4 """
		select id, BITAND(ksint, kdt), BITOR(ksint, kdt), BITXOR(ksint, kdt) from expr_test order by id"""
	qt_sql_test_SmallInt_Date_notn_4 """
		select id, BITAND(ksint, kdt), BITOR(ksint, kdt), BITXOR(ksint, kdt) from expr_test_not_nullable order by id"""
	qt_sql_test_SmallInt_DateTime_0 """
		select id, ksint + kdtm, ksint - kdtm from expr_test order by id"""
	qt_sql_test_SmallInt_DateTime_notn_0 """
		select id, ksint + kdtm, ksint - kdtm from expr_test_not_nullable order by id"""
	qt_sql_test_SmallInt_DateTime_1 """
		select id, ksint * kdtm, ksint / kdtm, ksint % kdtm from expr_test order by id"""
	qt_sql_test_SmallInt_DateTime_notn_1 """
		select id, ksint * kdtm, ksint / kdtm, ksint % kdtm from expr_test_not_nullable order by id"""
	//original planner qt_sql_test_SmallInt_DateTime_2 """
	//original planner 	select id, ksint DIV kdtm from expr_test order by id"""
	//original planner qt_sql_test_SmallInt_DateTime_notn_2 """
	//original planner 	select id, ksint DIV kdtm from expr_test_not_nullable order by id"""
	qt_sql_test_SmallInt_DateTime_3 """
		select id, ksint & kdtm, ksint | kdtm, ksint ^ kdtm from expr_test order by id"""
	qt_sql_test_SmallInt_DateTime_notn_3 """
		select id, ksint & kdtm, ksint | kdtm, ksint ^ kdtm from expr_test_not_nullable order by id"""
	qt_sql_test_SmallInt_DateTime_4 """
		select id, BITAND(ksint, kdtm), BITOR(ksint, kdtm), BITXOR(ksint, kdtm) from expr_test order by id"""
	qt_sql_test_SmallInt_DateTime_notn_4 """
		select id, BITAND(ksint, kdtm), BITOR(ksint, kdtm), BITXOR(ksint, kdtm) from expr_test_not_nullable order by id"""
	qt_sql_test_SmallInt_DateV2_0 """
		select id, ksint + kdtv2, ksint - kdtv2 from expr_test order by id"""
	qt_sql_test_SmallInt_DateV2_notn_0 """
		select id, ksint + kdtv2, ksint - kdtv2 from expr_test_not_nullable order by id"""
	qt_sql_test_SmallInt_DateV2_1 """
		select id, ksint * kdtv2, ksint / kdtv2, ksint % kdtv2 from expr_test order by id"""
	qt_sql_test_SmallInt_DateV2_notn_1 """
		select id, ksint * kdtv2, ksint / kdtv2, ksint % kdtv2 from expr_test_not_nullable order by id"""
	//original planner qt_sql_test_SmallInt_DateV2_2 """
	//original planner 	select id, ksint DIV kdtv2 from expr_test order by id"""
	//original planner qt_sql_test_SmallInt_DateV2_notn_2 """
	//original planner 	select id, ksint DIV kdtv2 from expr_test_not_nullable order by id"""
	qt_sql_test_SmallInt_DateV2_3 """
		select id, ksint & kdtv2, ksint | kdtv2, ksint ^ kdtv2 from expr_test order by id"""
	qt_sql_test_SmallInt_DateV2_notn_3 """
		select id, ksint & kdtv2, ksint | kdtv2, ksint ^ kdtv2 from expr_test_not_nullable order by id"""
	qt_sql_test_SmallInt_DateV2_4 """
		select id, BITAND(ksint, kdtv2), BITOR(ksint, kdtv2), BITXOR(ksint, kdtv2) from expr_test order by id"""
	qt_sql_test_SmallInt_DateV2_notn_4 """
		select id, BITAND(ksint, kdtv2), BITOR(ksint, kdtv2), BITXOR(ksint, kdtv2) from expr_test_not_nullable order by id"""
	qt_sql_test_SmallInt_DateTimeV2_0 """
		select id, ksint + kdtmv2, ksint - kdtmv2 from expr_test order by id"""
	qt_sql_test_SmallInt_DateTimeV2_notn_0 """
		select id, ksint + kdtmv2, ksint - kdtmv2 from expr_test_not_nullable order by id"""
	qt_sql_test_SmallInt_DateTimeV2_1 """
		select id, ksint * kdtmv2, ksint / kdtmv2, ksint % kdtmv2 from expr_test order by id"""
	qt_sql_test_SmallInt_DateTimeV2_notn_1 """
		select id, ksint * kdtmv2, ksint / kdtmv2, ksint % kdtmv2 from expr_test_not_nullable order by id"""
	//original planner qt_sql_test_SmallInt_DateTimeV2_2 """
	//original planner 	select id, ksint DIV kdtmv2 from expr_test order by id"""
	//original planner qt_sql_test_SmallInt_DateTimeV2_notn_2 """
	//original planner 	select id, ksint DIV kdtmv2 from expr_test_not_nullable order by id"""
	qt_sql_test_SmallInt_DateTimeV2_3 """
		select id, ksint & kdtmv2, ksint | kdtmv2, ksint ^ kdtmv2 from expr_test order by id"""
	qt_sql_test_SmallInt_DateTimeV2_notn_3 """
		select id, ksint & kdtmv2, ksint | kdtmv2, ksint ^ kdtmv2 from expr_test_not_nullable order by id"""
	qt_sql_test_SmallInt_DateTimeV2_4 """
		select id, BITAND(ksint, kdtmv2), BITOR(ksint, kdtmv2), BITXOR(ksint, kdtmv2) from expr_test order by id"""
	qt_sql_test_SmallInt_DateTimeV2_notn_4 """
		select id, BITAND(ksint, kdtmv2), BITOR(ksint, kdtmv2), BITXOR(ksint, kdtmv2) from expr_test_not_nullable order by id"""
	qt_sql_test_SmallInt_Boolean_0 """
		select id, ksint + kbool, ksint - kbool from expr_test order by id"""
	qt_sql_test_SmallInt_Boolean_notn_0 """
		select id, ksint + kbool, ksint - kbool from expr_test_not_nullable order by id"""
	qt_sql_test_SmallInt_Boolean_1 """
		select id, ksint * kbool, ksint / kbool, ksint % kbool from expr_test order by id"""
	qt_sql_test_SmallInt_Boolean_notn_1 """
		select id, ksint * kbool, ksint / kbool, ksint % kbool from expr_test_not_nullable order by id"""
	//original planner qt_sql_test_SmallInt_Boolean_2 """
	//original planner 	select id, ksint DIV kbool from expr_test order by id"""
	//original planner qt_sql_test_SmallInt_Boolean_notn_2 """
	//original planner 	select id, ksint DIV kbool from expr_test_not_nullable order by id"""
	qt_sql_test_SmallInt_Boolean_3 """
		select id, ksint & kbool, ksint | kbool, ksint ^ kbool from expr_test order by id"""
	qt_sql_test_SmallInt_Boolean_notn_3 """
		select id, ksint & kbool, ksint | kbool, ksint ^ kbool from expr_test_not_nullable order by id"""
	qt_sql_test_SmallInt_Boolean_4 """
		select id, BITAND(ksint, kbool), BITOR(ksint, kbool), BITXOR(ksint, kbool) from expr_test order by id"""
	qt_sql_test_SmallInt_Boolean_notn_4 """
		select id, BITAND(ksint, kbool), BITOR(ksint, kbool), BITXOR(ksint, kbool) from expr_test_not_nullable order by id"""
	qt_sql_test_Integer_TinyInt_0 """
		select id, kint + ktint, kint - ktint from expr_test order by id"""
	qt_sql_test_Integer_TinyInt_notn_0 """
		select id, kint + ktint, kint - ktint from expr_test_not_nullable order by id"""
	qt_sql_test_Integer_TinyInt_1 """
		select id, kint * ktint, kint / ktint, kint % ktint from expr_test order by id"""
	qt_sql_test_Integer_TinyInt_notn_1 """
		select id, kint * ktint, kint / ktint, kint % ktint from expr_test_not_nullable order by id"""
	qt_sql_test_Integer_TinyInt_2 """
		select id, kint DIV ktint from expr_test order by id"""
	qt_sql_test_Integer_TinyInt_notn_2 """
		select id, kint DIV ktint from expr_test_not_nullable order by id"""
	qt_sql_test_Integer_TinyInt_3 """
		select id, kint & ktint, kint | ktint, kint ^ ktint from expr_test order by id"""
	qt_sql_test_Integer_TinyInt_notn_3 """
		select id, kint & ktint, kint | ktint, kint ^ ktint from expr_test_not_nullable order by id"""
	qt_sql_test_Integer_TinyInt_4 """
		select id, BITAND(kint, ktint), BITOR(kint, ktint), BITXOR(kint, ktint) from expr_test order by id"""
	qt_sql_test_Integer_TinyInt_notn_4 """
		select id, BITAND(kint, ktint), BITOR(kint, ktint), BITXOR(kint, ktint) from expr_test_not_nullable order by id"""
	qt_sql_test_Integer_SmallInt_0 """
		select id, kint + ksint, kint - ksint from expr_test order by id"""
	qt_sql_test_Integer_SmallInt_notn_0 """
		select id, kint + ksint, kint - ksint from expr_test_not_nullable order by id"""
	qt_sql_test_Integer_SmallInt_1 """
		select id, kint * ksint, kint / ksint, kint % ksint from expr_test order by id"""
	qt_sql_test_Integer_SmallInt_notn_1 """
		select id, kint * ksint, kint / ksint, kint % ksint from expr_test_not_nullable order by id"""
	qt_sql_test_Integer_SmallInt_2 """
		select id, kint DIV ksint from expr_test order by id"""
	qt_sql_test_Integer_SmallInt_notn_2 """
		select id, kint DIV ksint from expr_test_not_nullable order by id"""
	qt_sql_test_Integer_SmallInt_3 """
		select id, kint & ksint, kint | ksint, kint ^ ksint from expr_test order by id"""
	qt_sql_test_Integer_SmallInt_notn_3 """
		select id, kint & ksint, kint | ksint, kint ^ ksint from expr_test_not_nullable order by id"""
	qt_sql_test_Integer_SmallInt_4 """
		select id, BITAND(kint, ksint), BITOR(kint, ksint), BITXOR(kint, ksint) from expr_test order by id"""
	qt_sql_test_Integer_SmallInt_notn_4 """
		select id, BITAND(kint, ksint), BITOR(kint, ksint), BITXOR(kint, ksint) from expr_test_not_nullable order by id"""
	qt_sql_test_Integer_Integer_0 """
		select id, kint + kint, kint - kint from expr_test order by id"""
	qt_sql_test_Integer_Integer_notn_0 """
		select id, kint + kint, kint - kint from expr_test_not_nullable order by id"""
	qt_sql_test_Integer_Integer_1 """
		select id, kint * kint, kint / kint, kint % kint from expr_test order by id"""
	qt_sql_test_Integer_Integer_notn_1 """
		select id, kint * kint, kint / kint, kint % kint from expr_test_not_nullable order by id"""
	qt_sql_test_Integer_Integer_2 """
		select id, kint DIV kint from expr_test order by id"""
	qt_sql_test_Integer_Integer_notn_2 """
		select id, kint DIV kint from expr_test_not_nullable order by id"""
	qt_sql_test_Integer_Integer_3 """
		select id, kint & kint, kint | kint, kint ^ kint from expr_test order by id"""
	qt_sql_test_Integer_Integer_notn_3 """
		select id, kint & kint, kint | kint, kint ^ kint from expr_test_not_nullable order by id"""
	qt_sql_test_Integer_Integer_4 """
		select id, BITAND(kint, kint), BITOR(kint, kint), BITXOR(kint, kint) from expr_test order by id"""
	qt_sql_test_Integer_Integer_notn_4 """
		select id, BITAND(kint, kint), BITOR(kint, kint), BITXOR(kint, kint) from expr_test_not_nullable order by id"""
	qt_sql_test_Integer_BigInt_0 """
		select id, kint + kbint, kint - kbint from expr_test order by id"""
	qt_sql_test_Integer_BigInt_notn_0 """
		select id, kint + kbint, kint - kbint from expr_test_not_nullable order by id"""
	qt_sql_test_Integer_BigInt_1 """
		select id, kint * kbint, kint / kbint, kint % kbint from expr_test order by id"""
	qt_sql_test_Integer_BigInt_notn_1 """
		select id, kint * kbint, kint / kbint, kint % kbint from expr_test_not_nullable order by id"""
	//original planner qt_sql_test_Integer_BigInt_2 """
	//original planner 	select id, kint DIV kbint from expr_test order by id"""
	//original planner qt_sql_test_Integer_BigInt_notn_2 """
	//original planner 	select id, kint DIV kbint from expr_test_not_nullable order by id"""
	qt_sql_test_Integer_BigInt_3 """
		select id, kint & kbint, kint | kbint, kint ^ kbint from expr_test order by id"""
	qt_sql_test_Integer_BigInt_notn_3 """
		select id, kint & kbint, kint | kbint, kint ^ kbint from expr_test_not_nullable order by id"""
	qt_sql_test_Integer_BigInt_4 """
		select id, BITAND(kint, kbint), BITOR(kint, kbint), BITXOR(kint, kbint) from expr_test order by id"""
	qt_sql_test_Integer_BigInt_notn_4 """
		select id, BITAND(kint, kbint), BITOR(kint, kbint), BITXOR(kint, kbint) from expr_test_not_nullable order by id"""
	qt_sql_test_Integer_LargeInt_0 """
		select id, kint + klint, kint - klint from expr_test order by id"""
	qt_sql_test_Integer_LargeInt_notn_0 """
		select id, kint + klint, kint - klint from expr_test_not_nullable order by id"""
	qt_sql_test_Integer_LargeInt_1 """
		select id, kint * klint, kint / klint, kint % klint from expr_test order by id"""
	qt_sql_test_Integer_LargeInt_notn_1 """
		select id, kint * klint, kint / klint, kint % klint from expr_test_not_nullable order by id"""
	//original planner qt_sql_test_Integer_LargeInt_2 """
	//original planner 	select id, kint DIV klint from expr_test order by id"""
	//original planner qt_sql_test_Integer_LargeInt_notn_2 """
	//original planner 	select id, kint DIV klint from expr_test_not_nullable order by id"""
	qt_sql_test_Integer_LargeInt_3 """
		select id, kint & klint, kint | klint, kint ^ klint from expr_test order by id"""
	qt_sql_test_Integer_LargeInt_notn_3 """
		select id, kint & klint, kint | klint, kint ^ klint from expr_test_not_nullable order by id"""
	qt_sql_test_Integer_LargeInt_4 """
		select id, BITAND(kint, klint), BITOR(kint, klint), BITXOR(kint, klint) from expr_test order by id"""
	qt_sql_test_Integer_LargeInt_notn_4 """
		select id, BITAND(kint, klint), BITOR(kint, klint), BITXOR(kint, klint) from expr_test_not_nullable order by id"""
	qt_sql_test_Integer_Float_0 """
		select id, kint + kfloat, kint - kfloat from expr_test order by id"""
	qt_sql_test_Integer_Float_notn_0 """
		select id, kint + kfloat, kint - kfloat from expr_test_not_nullable order by id"""
	qt_sql_test_Integer_Float_1 """
		select id, kint * kfloat, kint / kfloat, kint % kfloat from expr_test order by id"""
	qt_sql_test_Integer_Float_notn_1 """
		select id, kint * kfloat, kint / kfloat, kint % kfloat from expr_test_not_nullable order by id"""
	//original planner qt_sql_test_Integer_Float_2 """
	//original planner 	select id, kint DIV kfloat from expr_test order by id"""
	//original planner qt_sql_test_Integer_Float_notn_2 """
	//original planner 	select id, kint DIV kfloat from expr_test_not_nullable order by id"""
	qt_sql_test_Integer_Float_3 """
		select id, kint & kfloat, kint | kfloat, kint ^ kfloat from expr_test order by id"""
	qt_sql_test_Integer_Float_notn_3 """
		select id, kint & kfloat, kint | kfloat, kint ^ kfloat from expr_test_not_nullable order by id"""
	// qt_sql_test_Integer_Float_4 """
	// 	select id, BITAND(kint, kfloat), BITOR(kint, kfloat), BITXOR(kint, kfloat) from expr_test order by id"""
	// qt_sql_test_Integer_Float_notn_4 """
	// 	select id, BITAND(kint, kfloat), BITOR(kint, kfloat), BITXOR(kint, kfloat) from expr_test_not_nullable order by id"""
	qt_sql_test_Integer_Double_0 """
		select id, kint + kdbl, kint - kdbl from expr_test order by id"""
	qt_sql_test_Integer_Double_notn_0 """
		select id, kint + kdbl, kint - kdbl from expr_test_not_nullable order by id"""
	qt_sql_test_Integer_Double_1 """
		select id, kint * kdbl, kint / kdbl, kint % kdbl from expr_test order by id"""
	qt_sql_test_Integer_Double_notn_1 """
		select id, kint * kdbl, kint / kdbl, kint % kdbl from expr_test_not_nullable order by id"""
	//original planner qt_sql_test_Integer_Double_2 """
	//original planner 	select id, kint DIV kdbl from expr_test order by id"""
	//original planner qt_sql_test_Integer_Double_notn_2 """
	//original planner 	select id, kint DIV kdbl from expr_test_not_nullable order by id"""
	qt_sql_test_Integer_Double_3 """
		select id, kint & kdbl, kint | kdbl, kint ^ kdbl from expr_test order by id"""
	qt_sql_test_Integer_Double_notn_3 """
		select id, kint & kdbl, kint | kdbl, kint ^ kdbl from expr_test_not_nullable order by id"""
	// qt_sql_test_Integer_Double_4 """
	// 	select id, BITAND(kint, kdbl), BITOR(kint, kdbl), BITXOR(kint, kdbl) from expr_test order by id"""
	// qt_sql_test_Integer_Double_notn_4 """
	// 	select id, BITAND(kint, kdbl), BITOR(kint, kdbl), BITXOR(kint, kdbl) from expr_test_not_nullable order by id"""
	qt_sql_test_Integer_DecimalV2_0 """
		select id, kint + kdcml, kint - kdcml from expr_test order by id"""
	qt_sql_test_Integer_DecimalV2_notn_0 """
		select id, kint + kdcml, kint - kdcml from expr_test_not_nullable order by id"""
	qt_sql_test_Integer_DecimalV2_1 """
		select id, kint * kdcml, kint / kdcml, kint % kdcml from expr_test order by id"""
	qt_sql_test_Integer_DecimalV2_notn_1 """
		select id, kint * kdcml, kint / kdcml, kint % kdcml from expr_test_not_nullable order by id"""
	qt_sql_test_Integer_DecimalV2_2 """
		select id, kint DIV kdcml from expr_test order by id"""
	qt_sql_test_Integer_DecimalV2_notn_2 """
		select id, kint DIV kdcml from expr_test_not_nullable order by id"""
	qt_sql_test_Integer_DecimalV2_3 """
		select id, kint & kdcml, kint | kdcml, kint ^ kdcml from expr_test order by id"""
	qt_sql_test_Integer_DecimalV2_notn_3 """
		select id, kint & kdcml, kint | kdcml, kint ^ kdcml from expr_test_not_nullable order by id"""
	// qt_sql_test_Integer_DecimalV2_4 """
	// 	select id, BITAND(kint, kdcml), BITOR(kint, kdcml), BITXOR(kint, kdcml) from expr_test order by id"""
	// qt_sql_test_Integer_DecimalV2_notn_4 """
	// 	select id, BITAND(kint, kdcml), BITOR(kint, kdcml), BITXOR(kint, kdcml) from expr_test_not_nullable order by id"""
	qt_sql_test_Integer_Decimal32V3_0 """
		select id, kint + kdcml32v3, kint - kdcml32v3 from expr_test order by id"""
	qt_sql_test_Integer_Decimal32V3_notn_0 """
		select id, kint + kdcml32v3, kint - kdcml32v3 from expr_test_not_nullable order by id"""
	//original planner qt_sql_test_Integer_Decimal32V3_1 """
	//original planner 	select id, kint * kdcml32v3, kint / kdcml32v3, kint % kdcml32v3 from expr_test order by id"""
	//original planner qt_sql_test_Integer_Decimal32V3_notn_1 """
	//original planner 	select id, kint * kdcml32v3, kint / kdcml32v3, kint % kdcml32v3 from expr_test_not_nullable order by id"""
	//original planner qt_sql_test_Integer_Decimal32V3_2 """
	//original planner 	select id, kint DIV kdcml32v3 from expr_test order by id"""
	//original planner qt_sql_test_Integer_Decimal32V3_notn_2 """
	//original planner 	select id, kint DIV kdcml32v3 from expr_test_not_nullable order by id"""
	qt_sql_test_Integer_Decimal32V3_3 """
		select id, kint & kdcml32v3, kint | kdcml32v3, kint ^ kdcml32v3 from expr_test order by id"""
	qt_sql_test_Integer_Decimal32V3_notn_3 """
		select id, kint & kdcml32v3, kint | kdcml32v3, kint ^ kdcml32v3 from expr_test_not_nullable order by id"""
	// qt_sql_test_Integer_Decimal32V3_4 """
	// 	select id, BITAND(kint, kdcml32v3), BITOR(kint, kdcml32v3), BITXOR(kint, kdcml32v3) from expr_test order by id"""
	// qt_sql_test_Integer_Decimal32V3_notn_4 """
	// 	select id, BITAND(kint, kdcml32v3), BITOR(kint, kdcml32v3), BITXOR(kint, kdcml32v3) from expr_test_not_nullable order by id"""
	qt_sql_test_Integer_Decimal64V3_0 """
		select id, kint + kdcml64v3, kint - kdcml64v3 from expr_test order by id"""
	qt_sql_test_Integer_Decimal64V3_notn_0 """
		select id, kint + kdcml64v3, kint - kdcml64v3 from expr_test_not_nullable order by id"""
	//original planner qt_sql_test_Integer_Decimal64V3_1 """
	//original planner 	select id, kint * kdcml64v3, kint / kdcml64v3, kint % kdcml64v3 from expr_test order by id"""
	//original planner qt_sql_test_Integer_Decimal64V3_notn_1 """
	//original planner 	select id, kint * kdcml64v3, kint / kdcml64v3, kint % kdcml64v3 from expr_test_not_nullable order by id"""
	//original planner qt_sql_test_Integer_Decimal64V3_2 """
	//original planner 	select id, kint DIV kdcml64v3 from expr_test order by id"""
	//original planner qt_sql_test_Integer_Decimal64V3_notn_2 """
	//original planner 	select id, kint DIV kdcml64v3 from expr_test_not_nullable order by id"""
	qt_sql_test_Integer_Decimal64V3_3 """
		select id, kint & kdcml64v3, kint | kdcml64v3, kint ^ kdcml64v3 from expr_test order by id"""
	qt_sql_test_Integer_Decimal64V3_notn_3 """
		select id, kint & kdcml64v3, kint | kdcml64v3, kint ^ kdcml64v3 from expr_test_not_nullable order by id"""
	// qt_sql_test_Integer_Decimal64V3_4 """
	// 	select id, BITAND(kint, kdcml64v3), BITOR(kint, kdcml64v3), BITXOR(kint, kdcml64v3) from expr_test order by id"""
	// qt_sql_test_Integer_Decimal64V3_notn_4 """
	// 	select id, BITAND(kint, kdcml64v3), BITOR(kint, kdcml64v3), BITXOR(kint, kdcml64v3) from expr_test_not_nullable order by id"""
	qt_sql_test_Integer_Decimal128V3_0 """
		select id, kint + kdcml128v3, kint - kdcml128v3 from expr_test order by id"""
	qt_sql_test_Integer_Decimal128V3_notn_0 """
		select id, kint + kdcml128v3, kint - kdcml128v3 from expr_test_not_nullable order by id"""
	//original planner qt_sql_test_Integer_Decimal128V3_1 """
	//original planner 	select id, kint * kdcml128v3, kint / kdcml128v3, kint % kdcml128v3 from expr_test order by id"""
	//original planner qt_sql_test_Integer_Decimal128V3_notn_1 """
	//original planner 	select id, kint * kdcml128v3, kint / kdcml128v3, kint % kdcml128v3 from expr_test_not_nullable order by id"""
	//original planner qt_sql_test_Integer_Decimal128V3_2 """
	//original planner 	select id, kint DIV kdcml128v3 from expr_test order by id"""
	//original planner qt_sql_test_Integer_Decimal128V3_notn_2 """
	//original planner 	select id, kint DIV kdcml128v3 from expr_test_not_nullable order by id"""
	qt_sql_test_Integer_Decimal128V3_3 """
		select id, kint & kdcml128v3, kint | kdcml128v3, kint ^ kdcml128v3 from expr_test order by id"""
	qt_sql_test_Integer_Decimal128V3_notn_3 """
		select id, kint & kdcml128v3, kint | kdcml128v3, kint ^ kdcml128v3 from expr_test_not_nullable order by id"""
	// qt_sql_test_Integer_Decimal128V3_4 """
	// 	select id, BITAND(kint, kdcml128v3), BITOR(kint, kdcml128v3), BITXOR(kint, kdcml128v3) from expr_test order by id"""
	// qt_sql_test_Integer_Decimal128V3_notn_4 """
	// 	select id, BITAND(kint, kdcml128v3), BITOR(kint, kdcml128v3), BITXOR(kint, kdcml128v3) from expr_test_not_nullable order by id"""
	qt_sql_test_Integer_Char_0 """
		select id, kint + kchr, kint - kchr from expr_test order by id"""
	qt_sql_test_Integer_Char_notn_0 """
		select id, kint + kchr, kint - kchr from expr_test_not_nullable order by id"""
	qt_sql_test_Integer_Char_1 """
		select id, kint * kchr, kint / kchr, kint % kchr from expr_test order by id"""
	qt_sql_test_Integer_Char_notn_1 """
		select id, kint * kchr, kint / kchr, kint % kchr from expr_test_not_nullable order by id"""
	//original planner qt_sql_test_Integer_Char_2 """
	//original planner 	select id, kint DIV kchr from expr_test order by id"""
	//original planner qt_sql_test_Integer_Char_notn_2 """
	//original planner 	select id, kint DIV kchr from expr_test_not_nullable order by id"""
	qt_sql_test_Integer_Char_3 """
		select id, kint & kchr, kint | kchr, kint ^ kchr from expr_test order by id"""
	qt_sql_test_Integer_Char_notn_3 """
		select id, kint & kchr, kint | kchr, kint ^ kchr from expr_test_not_nullable order by id"""
	// qt_sql_test_Integer_Char_4 """
	// 	select id, BITAND(kint, kchr), BITOR(kint, kchr), BITXOR(kint, kchr) from expr_test order by id"""
	// qt_sql_test_Integer_Char_notn_4 """
	// 	select id, BITAND(kint, kchr), BITOR(kint, kchr), BITXOR(kint, kchr) from expr_test_not_nullable order by id"""
	qt_sql_test_Integer_Varchar_0 """
		select id, kint + kvchr, kint - kvchr from expr_test order by id"""
	qt_sql_test_Integer_Varchar_notn_0 """
		select id, kint + kvchr, kint - kvchr from expr_test_not_nullable order by id"""
	qt_sql_test_Integer_Varchar_1 """
		select id, kint * kvchr, kint / kvchr, kint % kvchr from expr_test order by id"""
	qt_sql_test_Integer_Varchar_notn_1 """
		select id, kint * kvchr, kint / kvchr, kint % kvchr from expr_test_not_nullable order by id"""
	//original planner qt_sql_test_Integer_Varchar_2 """
	//original planner 	select id, kint DIV kvchr from expr_test order by id"""
	//original planner qt_sql_test_Integer_Varchar_notn_2 """
	//original planner 	select id, kint DIV kvchr from expr_test_not_nullable order by id"""
	qt_sql_test_Integer_Varchar_3 """
		select id, kint & kvchr, kint | kvchr, kint ^ kvchr from expr_test order by id"""
	qt_sql_test_Integer_Varchar_notn_3 """
		select id, kint & kvchr, kint | kvchr, kint ^ kvchr from expr_test_not_nullable order by id"""
	// qt_sql_test_Integer_Varchar_4 """
	// 	select id, BITAND(kint, kvchr), BITOR(kint, kvchr), BITXOR(kint, kvchr) from expr_test order by id"""
	// qt_sql_test_Integer_Varchar_notn_4 """
	// 	select id, BITAND(kint, kvchr), BITOR(kint, kvchr), BITXOR(kint, kvchr) from expr_test_not_nullable order by id"""
	qt_sql_test_Integer_String_0 """
		select id, kint + kstr, kint - kstr from expr_test order by id"""
	qt_sql_test_Integer_String_notn_0 """
		select id, kint + kstr, kint - kstr from expr_test_not_nullable order by id"""
	qt_sql_test_Integer_String_1 """
		select id, kint * kstr, kint / kstr, kint % kstr from expr_test order by id"""
	qt_sql_test_Integer_String_notn_1 """
		select id, kint * kstr, kint / kstr, kint % kstr from expr_test_not_nullable order by id"""
	//original planner qt_sql_test_Integer_String_2 """
	//original planner 	select id, kint DIV kstr from expr_test order by id"""
	//original planner qt_sql_test_Integer_String_notn_2 """
	//original planner 	select id, kint DIV kstr from expr_test_not_nullable order by id"""
	qt_sql_test_Integer_String_3 """
		select id, kint & kstr, kint | kstr, kint ^ kstr from expr_test order by id"""
	qt_sql_test_Integer_String_notn_3 """
		select id, kint & kstr, kint | kstr, kint ^ kstr from expr_test_not_nullable order by id"""
	// qt_sql_test_Integer_String_4 """
	// 	select id, BITAND(kint, kstr), BITOR(kint, kstr), BITXOR(kint, kstr) from expr_test order by id"""
	// qt_sql_test_Integer_String_notn_4 """
	// 	select id, BITAND(kint, kstr), BITOR(kint, kstr), BITXOR(kint, kstr) from expr_test_not_nullable order by id"""
	qt_sql_test_Integer_Date_0 """
		select id, kint + kdt, kint - kdt from expr_test order by id"""
	qt_sql_test_Integer_Date_notn_0 """
		select id, kint + kdt, kint - kdt from expr_test_not_nullable order by id"""
	qt_sql_test_Integer_Date_1 """
		select id, kint * kdt, kint / kdt, kint % kdt from expr_test order by id"""
	qt_sql_test_Integer_Date_notn_1 """
		select id, kint * kdt, kint / kdt, kint % kdt from expr_test_not_nullable order by id"""
	//original planner qt_sql_test_Integer_Date_2 """
	//original planner 	select id, kint DIV kdt from expr_test order by id"""
	//original planner qt_sql_test_Integer_Date_notn_2 """
	//original planner 	select id, kint DIV kdt from expr_test_not_nullable order by id"""
	qt_sql_test_Integer_Date_3 """
		select id, kint & kdt, kint | kdt, kint ^ kdt from expr_test order by id"""
	qt_sql_test_Integer_Date_notn_3 """
		select id, kint & kdt, kint | kdt, kint ^ kdt from expr_test_not_nullable order by id"""
	qt_sql_test_Integer_Date_4 """
		select id, BITAND(kint, kdt), BITOR(kint, kdt), BITXOR(kint, kdt) from expr_test order by id"""
	qt_sql_test_Integer_Date_notn_4 """
		select id, BITAND(kint, kdt), BITOR(kint, kdt), BITXOR(kint, kdt) from expr_test_not_nullable order by id"""
	qt_sql_test_Integer_DateTime_0 """
		select id, kint + kdtm, kint - kdtm from expr_test order by id"""
	qt_sql_test_Integer_DateTime_notn_0 """
		select id, kint + kdtm, kint - kdtm from expr_test_not_nullable order by id"""
	qt_sql_test_Integer_DateTime_1 """
		select id, kint * kdtm, kint / kdtm, kint % kdtm from expr_test order by id"""
	qt_sql_test_Integer_DateTime_notn_1 """
		select id, kint * kdtm, kint / kdtm, kint % kdtm from expr_test_not_nullable order by id"""
	//original planner qt_sql_test_Integer_DateTime_2 """
	//original planner 	select id, kint DIV kdtm from expr_test order by id"""
	//original planner qt_sql_test_Integer_DateTime_notn_2 """
	//original planner 	select id, kint DIV kdtm from expr_test_not_nullable order by id"""
	qt_sql_test_Integer_DateTime_3 """
		select id, kint & kdtm, kint | kdtm, kint ^ kdtm from expr_test order by id"""
	qt_sql_test_Integer_DateTime_notn_3 """
		select id, kint & kdtm, kint | kdtm, kint ^ kdtm from expr_test_not_nullable order by id"""
	qt_sql_test_Integer_DateTime_4 """
		select id, BITAND(kint, kdtm), BITOR(kint, kdtm), BITXOR(kint, kdtm) from expr_test order by id"""
	qt_sql_test_Integer_DateTime_notn_4 """
		select id, BITAND(kint, kdtm), BITOR(kint, kdtm), BITXOR(kint, kdtm) from expr_test_not_nullable order by id"""
	qt_sql_test_Integer_DateV2_0 """
		select id, kint + kdtv2, kint - kdtv2 from expr_test order by id"""
	qt_sql_test_Integer_DateV2_notn_0 """
		select id, kint + kdtv2, kint - kdtv2 from expr_test_not_nullable order by id"""
	qt_sql_test_Integer_DateV2_1 """
		select id, kint * kdtv2, kint / kdtv2, kint % kdtv2 from expr_test order by id"""
	qt_sql_test_Integer_DateV2_notn_1 """
		select id, kint * kdtv2, kint / kdtv2, kint % kdtv2 from expr_test_not_nullable order by id"""
	//original planner qt_sql_test_Integer_DateV2_2 """
	//original planner 	select id, kint DIV kdtv2 from expr_test order by id"""
	//original planner qt_sql_test_Integer_DateV2_notn_2 """
	//original planner 	select id, kint DIV kdtv2 from expr_test_not_nullable order by id"""
	qt_sql_test_Integer_DateV2_3 """
		select id, kint & kdtv2, kint | kdtv2, kint ^ kdtv2 from expr_test order by id"""
	qt_sql_test_Integer_DateV2_notn_3 """
		select id, kint & kdtv2, kint | kdtv2, kint ^ kdtv2 from expr_test_not_nullable order by id"""
	qt_sql_test_Integer_DateV2_4 """
		select id, BITAND(kint, kdtv2), BITOR(kint, kdtv2), BITXOR(kint, kdtv2) from expr_test order by id"""
	qt_sql_test_Integer_DateV2_notn_4 """
		select id, BITAND(kint, kdtv2), BITOR(kint, kdtv2), BITXOR(kint, kdtv2) from expr_test_not_nullable order by id"""
	qt_sql_test_Integer_DateTimeV2_0 """
		select id, kint + kdtmv2, kint - kdtmv2 from expr_test order by id"""
	qt_sql_test_Integer_DateTimeV2_notn_0 """
		select id, kint + kdtmv2, kint - kdtmv2 from expr_test_not_nullable order by id"""
	qt_sql_test_Integer_DateTimeV2_1 """
		select id, kint * kdtmv2, kint / kdtmv2, kint % kdtmv2 from expr_test order by id"""
	qt_sql_test_Integer_DateTimeV2_notn_1 """
		select id, kint * kdtmv2, kint / kdtmv2, kint % kdtmv2 from expr_test_not_nullable order by id"""
	//original planner qt_sql_test_Integer_DateTimeV2_2 """
	//original planner 	select id, kint DIV kdtmv2 from expr_test order by id"""
	//original planner qt_sql_test_Integer_DateTimeV2_notn_2 """
	//original planner 	select id, kint DIV kdtmv2 from expr_test_not_nullable order by id"""
	qt_sql_test_Integer_DateTimeV2_3 """
		select id, kint & kdtmv2, kint | kdtmv2, kint ^ kdtmv2 from expr_test order by id"""
	qt_sql_test_Integer_DateTimeV2_notn_3 """
		select id, kint & kdtmv2, kint | kdtmv2, kint ^ kdtmv2 from expr_test_not_nullable order by id"""
	qt_sql_test_Integer_DateTimeV2_4 """
		select id, BITAND(kint, kdtmv2), BITOR(kint, kdtmv2), BITXOR(kint, kdtmv2) from expr_test order by id"""
	qt_sql_test_Integer_DateTimeV2_notn_4 """
		select id, BITAND(kint, kdtmv2), BITOR(kint, kdtmv2), BITXOR(kint, kdtmv2) from expr_test_not_nullable order by id"""
	qt_sql_test_Integer_Boolean_0 """
		select id, kint + kbool, kint - kbool from expr_test order by id"""
	qt_sql_test_Integer_Boolean_notn_0 """
		select id, kint + kbool, kint - kbool from expr_test_not_nullable order by id"""
	qt_sql_test_Integer_Boolean_1 """
		select id, kint * kbool, kint / kbool, kint % kbool from expr_test order by id"""
	qt_sql_test_Integer_Boolean_notn_1 """
		select id, kint * kbool, kint / kbool, kint % kbool from expr_test_not_nullable order by id"""
	//original planner qt_sql_test_Integer_Boolean_2 """
	//original planner 	select id, kint DIV kbool from expr_test order by id"""
	//original planner qt_sql_test_Integer_Boolean_notn_2 """
	//original planner 	select id, kint DIV kbool from expr_test_not_nullable order by id"""
	qt_sql_test_Integer_Boolean_3 """
		select id, kint & kbool, kint | kbool, kint ^ kbool from expr_test order by id"""
	qt_sql_test_Integer_Boolean_notn_3 """
		select id, kint & kbool, kint | kbool, kint ^ kbool from expr_test_not_nullable order by id"""
	qt_sql_test_Integer_Boolean_4 """
		select id, BITAND(kint, kbool), BITOR(kint, kbool), BITXOR(kint, kbool) from expr_test order by id"""
	qt_sql_test_Integer_Boolean_notn_4 """
		select id, BITAND(kint, kbool), BITOR(kint, kbool), BITXOR(kint, kbool) from expr_test_not_nullable order by id"""
	qt_sql_test_BigInt_TinyInt_0 """
		select id, kbint + ktint, kbint - ktint from expr_test order by id"""
	qt_sql_test_BigInt_TinyInt_notn_0 """
		select id, kbint + ktint, kbint - ktint from expr_test_not_nullable order by id"""
	qt_sql_test_BigInt_TinyInt_1 """
		select id, kbint * ktint, kbint / ktint, kbint % ktint from expr_test order by id"""
	qt_sql_test_BigInt_TinyInt_notn_1 """
		select id, kbint * ktint, kbint / ktint, kbint % ktint from expr_test_not_nullable order by id"""
	qt_sql_test_BigInt_TinyInt_2 """
		select id, kbint DIV ktint from expr_test order by id"""
	qt_sql_test_BigInt_TinyInt_notn_2 """
		select id, kbint DIV ktint from expr_test_not_nullable order by id"""
	qt_sql_test_BigInt_TinyInt_3 """
		select id, kbint & ktint, kbint | ktint, kbint ^ ktint from expr_test order by id"""
	qt_sql_test_BigInt_TinyInt_notn_3 """
		select id, kbint & ktint, kbint | ktint, kbint ^ ktint from expr_test_not_nullable order by id"""
	qt_sql_test_BigInt_TinyInt_4 """
		select id, BITAND(kbint, ktint), BITOR(kbint, ktint), BITXOR(kbint, ktint) from expr_test order by id"""
	qt_sql_test_BigInt_TinyInt_notn_4 """
		select id, BITAND(kbint, ktint), BITOR(kbint, ktint), BITXOR(kbint, ktint) from expr_test_not_nullable order by id"""
	qt_sql_test_BigInt_SmallInt_0 """
		select id, kbint + ksint, kbint - ksint from expr_test order by id"""
	qt_sql_test_BigInt_SmallInt_notn_0 """
		select id, kbint + ksint, kbint - ksint from expr_test_not_nullable order by id"""
	qt_sql_test_BigInt_SmallInt_1 """
		select id, kbint * ksint, kbint / ksint, kbint % ksint from expr_test order by id"""
	qt_sql_test_BigInt_SmallInt_notn_1 """
		select id, kbint * ksint, kbint / ksint, kbint % ksint from expr_test_not_nullable order by id"""
	qt_sql_test_BigInt_SmallInt_2 """
		select id, kbint DIV ksint from expr_test order by id"""
	qt_sql_test_BigInt_SmallInt_notn_2 """
		select id, kbint DIV ksint from expr_test_not_nullable order by id"""
	qt_sql_test_BigInt_SmallInt_3 """
		select id, kbint & ksint, kbint | ksint, kbint ^ ksint from expr_test order by id"""
	qt_sql_test_BigInt_SmallInt_notn_3 """
		select id, kbint & ksint, kbint | ksint, kbint ^ ksint from expr_test_not_nullable order by id"""
	qt_sql_test_BigInt_SmallInt_4 """
		select id, BITAND(kbint, ksint), BITOR(kbint, ksint), BITXOR(kbint, ksint) from expr_test order by id"""
	qt_sql_test_BigInt_SmallInt_notn_4 """
		select id, BITAND(kbint, ksint), BITOR(kbint, ksint), BITXOR(kbint, ksint) from expr_test_not_nullable order by id"""
	qt_sql_test_BigInt_Integer_0 """
		select id, kbint + kint, kbint - kint from expr_test order by id"""
	qt_sql_test_BigInt_Integer_notn_0 """
		select id, kbint + kint, kbint - kint from expr_test_not_nullable order by id"""
	qt_sql_test_BigInt_Integer_1 """
		select id, kbint * kint, kbint / kint, kbint % kint from expr_test order by id"""
	qt_sql_test_BigInt_Integer_notn_1 """
		select id, kbint * kint, kbint / kint, kbint % kint from expr_test_not_nullable order by id"""
	qt_sql_test_BigInt_Integer_2 """
		select id, kbint DIV kint from expr_test order by id"""
	qt_sql_test_BigInt_Integer_notn_2 """
		select id, kbint DIV kint from expr_test_not_nullable order by id"""
	qt_sql_test_BigInt_Integer_3 """
		select id, kbint & kint, kbint | kint, kbint ^ kint from expr_test order by id"""
	qt_sql_test_BigInt_Integer_notn_3 """
		select id, kbint & kint, kbint | kint, kbint ^ kint from expr_test_not_nullable order by id"""
	qt_sql_test_BigInt_Integer_4 """
		select id, BITAND(kbint, kint), BITOR(kbint, kint), BITXOR(kbint, kint) from expr_test order by id"""
	qt_sql_test_BigInt_Integer_notn_4 """
		select id, BITAND(kbint, kint), BITOR(kbint, kint), BITXOR(kbint, kint) from expr_test_not_nullable order by id"""
	qt_sql_test_BigInt_BigInt_0 """
		select id, kbint + kbint, kbint - kbint from expr_test order by id"""
	qt_sql_test_BigInt_BigInt_notn_0 """
		select id, kbint + kbint, kbint - kbint from expr_test_not_nullable order by id"""
	qt_sql_test_BigInt_BigInt_1 """
		select id, kbint * kbint, kbint / kbint, kbint % kbint from expr_test order by id"""
	qt_sql_test_BigInt_BigInt_notn_1 """
		select id, kbint * kbint, kbint / kbint, kbint % kbint from expr_test_not_nullable order by id"""
	qt_sql_test_BigInt_BigInt_2 """
		select id, kbint DIV kbint from expr_test order by id"""
	qt_sql_test_BigInt_BigInt_notn_2 """
		select id, kbint DIV kbint from expr_test_not_nullable order by id"""
	qt_sql_test_BigInt_BigInt_3 """
		select id, kbint & kbint, kbint | kbint, kbint ^ kbint from expr_test order by id"""
	qt_sql_test_BigInt_BigInt_notn_3 """
		select id, kbint & kbint, kbint | kbint, kbint ^ kbint from expr_test_not_nullable order by id"""
	qt_sql_test_BigInt_BigInt_4 """
		select id, BITAND(kbint, kbint), BITOR(kbint, kbint), BITXOR(kbint, kbint) from expr_test order by id"""
	qt_sql_test_BigInt_BigInt_notn_4 """
		select id, BITAND(kbint, kbint), BITOR(kbint, kbint), BITXOR(kbint, kbint) from expr_test_not_nullable order by id"""
	qt_sql_test_BigInt_LargeInt_0 """
		select id, kbint + klint, kbint - klint from expr_test order by id"""
	qt_sql_test_BigInt_LargeInt_notn_0 """
		select id, kbint + klint, kbint - klint from expr_test_not_nullable order by id"""
	qt_sql_test_BigInt_LargeInt_1 """
		select id, kbint * klint, kbint / klint, kbint % klint from expr_test order by id"""
	qt_sql_test_BigInt_LargeInt_notn_1 """
		select id, kbint * klint, kbint / klint, kbint % klint from expr_test_not_nullable order by id"""
	//original planner qt_sql_test_BigInt_LargeInt_2 """
	//original planner 	select id, kbint DIV klint from expr_test order by id"""
	//original planner qt_sql_test_BigInt_LargeInt_notn_2 """
	//original planner 	select id, kbint DIV klint from expr_test_not_nullable order by id"""
	qt_sql_test_BigInt_LargeInt_3 """
		select id, kbint & klint, kbint | klint, kbint ^ klint from expr_test order by id"""
	qt_sql_test_BigInt_LargeInt_notn_3 """
		select id, kbint & klint, kbint | klint, kbint ^ klint from expr_test_not_nullable order by id"""
	qt_sql_test_BigInt_LargeInt_4 """
		select id, BITAND(kbint, klint), BITOR(kbint, klint), BITXOR(kbint, klint) from expr_test order by id"""
	qt_sql_test_BigInt_LargeInt_notn_4 """
		select id, BITAND(kbint, klint), BITOR(kbint, klint), BITXOR(kbint, klint) from expr_test_not_nullable order by id"""
	qt_sql_test_BigInt_Float_0 """
		select id, kbint + kfloat, kbint - kfloat from expr_test order by id"""
	qt_sql_test_BigInt_Float_notn_0 """
		select id, kbint + kfloat, kbint - kfloat from expr_test_not_nullable order by id"""
	// qt_sql_test_BigInt_Float_1 """
	// // 	select id, kbint * kfloat, kbint / kfloat, kbint % kfloat from expr_test order by id"""
	// qt_sql_test_BigInt_Float_notn_1 """
	// 	select id, kbint * kfloat, kbint / kfloat, kbint % kfloat from expr_test_not_nullable order by id"""
	//original planner qt_sql_test_BigInt_Float_2 """
	//original planner 	select id, kbint DIV kfloat from expr_test order by id"""
	//original planner qt_sql_test_BigInt_Float_notn_2 """
	//original planner 	select id, kbint DIV kfloat from expr_test_not_nullable order by id"""
	qt_sql_test_BigInt_Float_3 """
		select id, kbint & kfloat, kbint | kfloat, kbint ^ kfloat from expr_test order by id"""
	qt_sql_test_BigInt_Float_notn_3 """
		select id, kbint & kfloat, kbint | kfloat, kbint ^ kfloat from expr_test_not_nullable order by id"""
	// qt_sql_test_BigInt_Float_4 """
	// 	select id, BITAND(kbint, kfloat), BITOR(kbint, kfloat), BITXOR(kbint, kfloat) from expr_test order by id"""
	// qt_sql_test_BigInt_Float_notn_4 """
	// 	select id, BITAND(kbint, kfloat), BITOR(kbint, kfloat), BITXOR(kbint, kfloat) from expr_test_not_nullable order by id"""
	qt_sql_test_BigInt_Double_0 """
		select id, kbint + kdbl, kbint - kdbl from expr_test order by id"""
	qt_sql_test_BigInt_Double_notn_0 """
		select id, kbint + kdbl, kbint - kdbl from expr_test_not_nullable order by id"""
	qt_sql_test_BigInt_Double_1 """
		select id, kbint * kdbl, kbint / kdbl, kbint % kdbl from expr_test order by id"""
	qt_sql_test_BigInt_Double_notn_1 """
		select id, kbint * kdbl, kbint / kdbl, kbint % kdbl from expr_test_not_nullable order by id"""
	//original planner qt_sql_test_BigInt_Double_2 """
	//original planner 	select id, kbint DIV kdbl from expr_test order by id"""
	//original planner qt_sql_test_BigInt_Double_notn_2 """
	//original planner 	select id, kbint DIV kdbl from expr_test_not_nullable order by id"""
	qt_sql_test_BigInt_Double_3 """
		select id, kbint & kdbl, kbint | kdbl, kbint ^ kdbl from expr_test order by id"""
	qt_sql_test_BigInt_Double_notn_3 """
		select id, kbint & kdbl, kbint | kdbl, kbint ^ kdbl from expr_test_not_nullable order by id"""
	// qt_sql_test_BigInt_Double_4 """
	// 	select id, BITAND(kbint, kdbl), BITOR(kbint, kdbl), BITXOR(kbint, kdbl) from expr_test order by id"""
	// qt_sql_test_BigInt_Double_notn_4 """
	// 	select id, BITAND(kbint, kdbl), BITOR(kbint, kdbl), BITXOR(kbint, kdbl) from expr_test_not_nullable order by id"""
	qt_sql_test_BigInt_DecimalV2_0 """
		select id, kbint + kdcml, kbint - kdcml from expr_test order by id"""
	qt_sql_test_BigInt_DecimalV2_notn_0 """
		select id, kbint + kdcml, kbint - kdcml from expr_test_not_nullable order by id"""
	qt_sql_test_BigInt_DecimalV2_1 """
		select id, kbint * kdcml, kbint / kdcml, kbint % kdcml from expr_test order by id"""
	qt_sql_test_BigInt_DecimalV2_notn_1 """
		select id, kbint * kdcml, kbint / kdcml, kbint % kdcml from expr_test_not_nullable order by id"""
	qt_sql_test_BigInt_DecimalV2_2 """
		select id, kbint DIV kdcml from expr_test order by id"""
	qt_sql_test_BigInt_DecimalV2_notn_2 """
		select id, kbint DIV kdcml from expr_test_not_nullable order by id"""
	qt_sql_test_BigInt_DecimalV2_3 """
		select id, kbint & kdcml, kbint | kdcml, kbint ^ kdcml from expr_test order by id"""
	qt_sql_test_BigInt_DecimalV2_notn_3 """
		select id, kbint & kdcml, kbint | kdcml, kbint ^ kdcml from expr_test_not_nullable order by id"""
	// qt_sql_test_BigInt_DecimalV2_4 """
	// 	select id, BITAND(kbint, kdcml), BITOR(kbint, kdcml), BITXOR(kbint, kdcml) from expr_test order by id"""
	// qt_sql_test_BigInt_DecimalV2_notn_4 """
	// 	select id, BITAND(kbint, kdcml), BITOR(kbint, kdcml), BITXOR(kbint, kdcml) from expr_test_not_nullable order by id"""
	qt_sql_test_BigInt_Decimal32V3_0 """
		select id, kbint + kdcml32v3, kbint - kdcml32v3 from expr_test order by id"""
	qt_sql_test_BigInt_Decimal32V3_notn_0 """
		select id, kbint + kdcml32v3, kbint - kdcml32v3 from expr_test_not_nullable order by id"""
	//original planner qt_sql_test_BigInt_Decimal32V3_1 """
	//original planner 	select id, kbint * kdcml32v3, kbint / kdcml32v3, kbint % kdcml32v3 from expr_test order by id"""
	//original planner qt_sql_test_BigInt_Decimal32V3_notn_1 """
	//original planner 	select id, kbint * kdcml32v3, kbint / kdcml32v3, kbint % kdcml32v3 from expr_test_not_nullable order by id"""
	qt_sql_test_BigInt_Decimal32V3_2 """
		select id, kbint DIV kdcml32v3 from expr_test order by id"""
	qt_sql_test_BigInt_Decimal32V3_notn_2 """
		select id, kbint DIV kdcml32v3 from expr_test_not_nullable order by id"""
	qt_sql_test_BigInt_Decimal32V3_3 """
		select id, kbint & kdcml32v3, kbint | kdcml32v3, kbint ^ kdcml32v3 from expr_test order by id"""
	qt_sql_test_BigInt_Decimal32V3_notn_3 """
		select id, kbint & kdcml32v3, kbint | kdcml32v3, kbint ^ kdcml32v3 from expr_test_not_nullable order by id"""
	// qt_sql_test_BigInt_Decimal32V3_4 """
	// 	select id, BITAND(kbint, kdcml32v3), BITOR(kbint, kdcml32v3), BITXOR(kbint, kdcml32v3) from expr_test order by id"""
	// qt_sql_test_BigInt_Decimal32V3_notn_4 """
	// 	select id, BITAND(kbint, kdcml32v3), BITOR(kbint, kdcml32v3), BITXOR(kbint, kdcml32v3) from expr_test_not_nullable order by id"""
	qt_sql_test_BigInt_Decimal64V3_0 """
		select id, kbint + kdcml64v3, kbint - kdcml64v3 from expr_test order by id"""
	qt_sql_test_BigInt_Decimal64V3_notn_0 """
		select id, kbint + kdcml64v3, kbint - kdcml64v3 from expr_test_not_nullable order by id"""
	//original planner qt_sql_test_BigInt_Decimal64V3_1 """
	//original planner 	select id, kbint * kdcml64v3, kbint / kdcml64v3, kbint % kdcml64v3 from expr_test order by id"""
	//original planner qt_sql_test_BigInt_Decimal64V3_notn_1 """
	//original planner 	select id, kbint * kdcml64v3, kbint / kdcml64v3, kbint % kdcml64v3 from expr_test_not_nullable order by id"""
	qt_sql_test_BigInt_Decimal64V3_2 """
		select id, kbint DIV kdcml64v3 from expr_test order by id"""
	qt_sql_test_BigInt_Decimal64V3_notn_2 """
		select id, kbint DIV kdcml64v3 from expr_test_not_nullable order by id"""
	qt_sql_test_BigInt_Decimal64V3_3 """
		select id, kbint & kdcml64v3, kbint | kdcml64v3, kbint ^ kdcml64v3 from expr_test order by id"""
	qt_sql_test_BigInt_Decimal64V3_notn_3 """
		select id, kbint & kdcml64v3, kbint | kdcml64v3, kbint ^ kdcml64v3 from expr_test_not_nullable order by id"""
	// qt_sql_test_BigInt_Decimal64V3_4 """
	// 	select id, BITAND(kbint, kdcml64v3), BITOR(kbint, kdcml64v3), BITXOR(kbint, kdcml64v3) from expr_test order by id"""
	// qt_sql_test_BigInt_Decimal64V3_notn_4 """
	// 	select id, BITAND(kbint, kdcml64v3), BITOR(kbint, kdcml64v3), BITXOR(kbint, kdcml64v3) from expr_test_not_nullable order by id"""
	qt_sql_test_BigInt_Decimal128V3_0 """
		select id, kbint + kdcml128v3, kbint - kdcml128v3 from expr_test order by id"""
	qt_sql_test_BigInt_Decimal128V3_notn_0 """
		select id, kbint + kdcml128v3, kbint - kdcml128v3 from expr_test_not_nullable order by id"""
	//original planner qt_sql_test_BigInt_Decimal128V3_1 """
	//original planner 	select id, kbint * kdcml128v3, kbint / kdcml128v3, kbint % kdcml128v3 from expr_test order by id"""
	//original planner qt_sql_test_BigInt_Decimal128V3_notn_1 """
	//original planner 	select id, kbint * kdcml128v3, kbint / kdcml128v3, kbint % kdcml128v3 from expr_test_not_nullable order by id"""
	qt_sql_test_BigInt_Decimal128V3_2 """
		select id, kbint DIV kdcml128v3 from expr_test order by id"""
	qt_sql_test_BigInt_Decimal128V3_notn_2 """
		select id, kbint DIV kdcml128v3 from expr_test_not_nullable order by id"""
	qt_sql_test_BigInt_Decimal128V3_3 """
		select id, kbint & kdcml128v3, kbint | kdcml128v3, kbint ^ kdcml128v3 from expr_test order by id"""
	qt_sql_test_BigInt_Decimal128V3_notn_3 """
		select id, kbint & kdcml128v3, kbint | kdcml128v3, kbint ^ kdcml128v3 from expr_test_not_nullable order by id"""
	// qt_sql_test_BigInt_Decimal128V3_4 """
	// 	select id, BITAND(kbint, kdcml128v3), BITOR(kbint, kdcml128v3), BITXOR(kbint, kdcml128v3) from expr_test order by id"""
	// qt_sql_test_BigInt_Decimal128V3_notn_4 """
	// 	select id, BITAND(kbint, kdcml128v3), BITOR(kbint, kdcml128v3), BITXOR(kbint, kdcml128v3) from expr_test_not_nullable order by id"""
	qt_sql_test_BigInt_Char_0 """
		select id, kbint + kchr, kbint - kchr from expr_test order by id"""
	qt_sql_test_BigInt_Char_notn_0 """
		select id, kbint + kchr, kbint - kchr from expr_test_not_nullable order by id"""
	qt_sql_test_BigInt_Char_1 """
		select id, kbint * kchr, kbint / kchr, kbint % kchr from expr_test order by id"""
	qt_sql_test_BigInt_Char_notn_1 """
		select id, kbint * kchr, kbint / kchr, kbint % kchr from expr_test_not_nullable order by id"""
	//original planner qt_sql_test_BigInt_Char_2 """
	//original planner 	select id, kbint DIV kchr from expr_test order by id"""
	//original planner qt_sql_test_BigInt_Char_notn_2 """
	//original planner 	select id, kbint DIV kchr from expr_test_not_nullable order by id"""
	qt_sql_test_BigInt_Char_3 """
		select id, kbint & kchr, kbint | kchr, kbint ^ kchr from expr_test order by id"""
	qt_sql_test_BigInt_Char_notn_3 """
		select id, kbint & kchr, kbint | kchr, kbint ^ kchr from expr_test_not_nullable order by id"""
	// qt_sql_test_BigInt_Char_4 """
	// 	select id, BITAND(kbint, kchr), BITOR(kbint, kchr), BITXOR(kbint, kchr) from expr_test order by id"""
	// qt_sql_test_BigInt_Char_notn_4 """
	// 	select id, BITAND(kbint, kchr), BITOR(kbint, kchr), BITXOR(kbint, kchr) from expr_test_not_nullable order by id"""
	qt_sql_test_BigInt_Varchar_0 """
		select id, kbint + kvchr, kbint - kvchr from expr_test order by id"""
	qt_sql_test_BigInt_Varchar_notn_0 """
		select id, kbint + kvchr, kbint - kvchr from expr_test_not_nullable order by id"""
	qt_sql_test_BigInt_Varchar_1 """
		select id, kbint * kvchr, kbint / kvchr, kbint % kvchr from expr_test order by id"""
	qt_sql_test_BigInt_Varchar_notn_1 """
		select id, kbint * kvchr, kbint / kvchr, kbint % kvchr from expr_test_not_nullable order by id"""
	//original planner qt_sql_test_BigInt_Varchar_2 """
	//original planner 	select id, kbint DIV kvchr from expr_test order by id"""
	//original planner qt_sql_test_BigInt_Varchar_notn_2 """
	//original planner 	select id, kbint DIV kvchr from expr_test_not_nullable order by id"""
	qt_sql_test_BigInt_Varchar_3 """
		select id, kbint & kvchr, kbint | kvchr, kbint ^ kvchr from expr_test order by id"""
	qt_sql_test_BigInt_Varchar_notn_3 """
		select id, kbint & kvchr, kbint | kvchr, kbint ^ kvchr from expr_test_not_nullable order by id"""
	// qt_sql_test_BigInt_Varchar_4 """
	// 	select id, BITAND(kbint, kvchr), BITOR(kbint, kvchr), BITXOR(kbint, kvchr) from expr_test order by id"""
	// qt_sql_test_BigInt_Varchar_notn_4 """
	// 	select id, BITAND(kbint, kvchr), BITOR(kbint, kvchr), BITXOR(kbint, kvchr) from expr_test_not_nullable order by id"""
	qt_sql_test_BigInt_String_0 """
		select id, kbint + kstr, kbint - kstr from expr_test order by id"""
	qt_sql_test_BigInt_String_notn_0 """
		select id, kbint + kstr, kbint - kstr from expr_test_not_nullable order by id"""
	qt_sql_test_BigInt_String_1 """
		select id, kbint * kstr, kbint / kstr, kbint % kstr from expr_test order by id"""
	qt_sql_test_BigInt_String_notn_1 """
		select id, kbint * kstr, kbint / kstr, kbint % kstr from expr_test_not_nullable order by id"""
	//original planner qt_sql_test_BigInt_String_2 """
	//original planner 	select id, kbint DIV kstr from expr_test order by id"""
	//original planner qt_sql_test_BigInt_String_notn_2 """
	//original planner 	select id, kbint DIV kstr from expr_test_not_nullable order by id"""
	qt_sql_test_BigInt_String_3 """
		select id, kbint & kstr, kbint | kstr, kbint ^ kstr from expr_test order by id"""
	qt_sql_test_BigInt_String_notn_3 """
		select id, kbint & kstr, kbint | kstr, kbint ^ kstr from expr_test_not_nullable order by id"""
	// qt_sql_test_BigInt_String_4 """
	// 	select id, BITAND(kbint, kstr), BITOR(kbint, kstr), BITXOR(kbint, kstr) from expr_test order by id"""
	// qt_sql_test_BigInt_String_notn_4 """
	// 	select id, BITAND(kbint, kstr), BITOR(kbint, kstr), BITXOR(kbint, kstr) from expr_test_not_nullable order by id"""
	qt_sql_test_BigInt_Date_0 """
		select id, kbint + kdt, kbint - kdt from expr_test order by id"""
	qt_sql_test_BigInt_Date_notn_0 """
		select id, kbint + kdt, kbint - kdt from expr_test_not_nullable order by id"""
	qt_sql_test_BigInt_Date_1 """
		select id, kbint * kdt, kbint / kdt, kbint % kdt from expr_test order by id"""
	qt_sql_test_BigInt_Date_notn_1 """
		select id, kbint * kdt, kbint / kdt, kbint % kdt from expr_test_not_nullable order by id"""
	qt_sql_test_BigInt_Date_2 """
		select id, kbint DIV kdt from expr_test order by id"""
	qt_sql_test_BigInt_Date_notn_2 """
		select id, kbint DIV kdt from expr_test_not_nullable order by id"""
	qt_sql_test_BigInt_Date_3 """
		select id, kbint & kdt, kbint | kdt, kbint ^ kdt from expr_test order by id"""
	qt_sql_test_BigInt_Date_notn_3 """
		select id, kbint & kdt, kbint | kdt, kbint ^ kdt from expr_test_not_nullable order by id"""
	qt_sql_test_BigInt_Date_4 """
		select id, BITAND(kbint, kdt), BITOR(kbint, kdt), BITXOR(kbint, kdt) from expr_test order by id"""
	qt_sql_test_BigInt_Date_notn_4 """
		select id, BITAND(kbint, kdt), BITOR(kbint, kdt), BITXOR(kbint, kdt) from expr_test_not_nullable order by id"""
	qt_sql_test_BigInt_DateTime_0 """
		select id, kbint + kdtm, kbint - kdtm from expr_test order by id"""
	qt_sql_test_BigInt_DateTime_notn_0 """
		select id, kbint + kdtm, kbint - kdtm from expr_test_not_nullable order by id"""
	qt_sql_test_BigInt_DateTime_1 """
		select id, kbint * kdtm, kbint / kdtm, kbint % kdtm from expr_test order by id"""
	qt_sql_test_BigInt_DateTime_notn_1 """
		select id, kbint * kdtm, kbint / kdtm, kbint % kdtm from expr_test_not_nullable order by id"""
	qt_sql_test_BigInt_DateTime_2 """
		select id, kbint DIV kdtm from expr_test order by id"""
	qt_sql_test_BigInt_DateTime_notn_2 """
		select id, kbint DIV kdtm from expr_test_not_nullable order by id"""
	qt_sql_test_BigInt_DateTime_3 """
		select id, kbint & kdtm, kbint | kdtm, kbint ^ kdtm from expr_test order by id"""
	qt_sql_test_BigInt_DateTime_notn_3 """
		select id, kbint & kdtm, kbint | kdtm, kbint ^ kdtm from expr_test_not_nullable order by id"""
	qt_sql_test_BigInt_DateTime_4 """
		select id, BITAND(kbint, kdtm), BITOR(kbint, kdtm), BITXOR(kbint, kdtm) from expr_test order by id"""
	qt_sql_test_BigInt_DateTime_notn_4 """
		select id, BITAND(kbint, kdtm), BITOR(kbint, kdtm), BITXOR(kbint, kdtm) from expr_test_not_nullable order by id"""
	qt_sql_test_BigInt_DateV2_0 """
		select id, kbint + kdtv2, kbint - kdtv2 from expr_test order by id"""
	qt_sql_test_BigInt_DateV2_notn_0 """
		select id, kbint + kdtv2, kbint - kdtv2 from expr_test_not_nullable order by id"""
	qt_sql_test_BigInt_DateV2_1 """
		select id, kbint * kdtv2, kbint / kdtv2, kbint % kdtv2 from expr_test order by id"""
	qt_sql_test_BigInt_DateV2_notn_1 """
		select id, kbint * kdtv2, kbint / kdtv2, kbint % kdtv2 from expr_test_not_nullable order by id"""
	qt_sql_test_BigInt_DateV2_2 """
		select id, kbint DIV kdtv2 from expr_test order by id"""
	qt_sql_test_BigInt_DateV2_notn_2 """
		select id, kbint DIV kdtv2 from expr_test_not_nullable order by id"""
	qt_sql_test_BigInt_DateV2_3 """
		select id, kbint & kdtv2, kbint | kdtv2, kbint ^ kdtv2 from expr_test order by id"""
	qt_sql_test_BigInt_DateV2_notn_3 """
		select id, kbint & kdtv2, kbint | kdtv2, kbint ^ kdtv2 from expr_test_not_nullable order by id"""
	qt_sql_test_BigInt_DateV2_4 """
		select id, BITAND(kbint, kdtv2), BITOR(kbint, kdtv2), BITXOR(kbint, kdtv2) from expr_test order by id"""
	qt_sql_test_BigInt_DateV2_notn_4 """
		select id, BITAND(kbint, kdtv2), BITOR(kbint, kdtv2), BITXOR(kbint, kdtv2) from expr_test_not_nullable order by id"""
	qt_sql_test_BigInt_DateTimeV2_0 """
		select id, kbint + kdtmv2, kbint - kdtmv2 from expr_test order by id"""
	qt_sql_test_BigInt_DateTimeV2_notn_0 """
		select id, kbint + kdtmv2, kbint - kdtmv2 from expr_test_not_nullable order by id"""
	qt_sql_test_BigInt_DateTimeV2_1 """
		select id, kbint * kdtmv2, kbint / kdtmv2, kbint % kdtmv2 from expr_test order by id"""
	qt_sql_test_BigInt_DateTimeV2_notn_1 """
		select id, kbint * kdtmv2, kbint / kdtmv2, kbint % kdtmv2 from expr_test_not_nullable order by id"""
	qt_sql_test_BigInt_DateTimeV2_2 """
		select id, kbint DIV kdtmv2 from expr_test order by id"""
	qt_sql_test_BigInt_DateTimeV2_notn_2 """
		select id, kbint DIV kdtmv2 from expr_test_not_nullable order by id"""
	qt_sql_test_BigInt_DateTimeV2_3 """
		select id, kbint & kdtmv2, kbint | kdtmv2, kbint ^ kdtmv2 from expr_test order by id"""
	qt_sql_test_BigInt_DateTimeV2_notn_3 """
		select id, kbint & kdtmv2, kbint | kdtmv2, kbint ^ kdtmv2 from expr_test_not_nullable order by id"""
	qt_sql_test_BigInt_DateTimeV2_4 """
		select id, BITAND(kbint, kdtmv2), BITOR(kbint, kdtmv2), BITXOR(kbint, kdtmv2) from expr_test order by id"""
	qt_sql_test_BigInt_DateTimeV2_notn_4 """
		select id, BITAND(kbint, kdtmv2), BITOR(kbint, kdtmv2), BITXOR(kbint, kdtmv2) from expr_test_not_nullable order by id"""
	qt_sql_test_BigInt_Boolean_0 """
		select id, kbint + kbool, kbint - kbool from expr_test order by id"""
	qt_sql_test_BigInt_Boolean_notn_0 """
		select id, kbint + kbool, kbint - kbool from expr_test_not_nullable order by id"""
	qt_sql_test_BigInt_Boolean_1 """
		select id, kbint * kbool, kbint / kbool, kbint % kbool from expr_test order by id"""
	qt_sql_test_BigInt_Boolean_notn_1 """
		select id, kbint * kbool, kbint / kbool, kbint % kbool from expr_test_not_nullable order by id"""
	qt_sql_test_BigInt_Boolean_2 """
		select id, kbint DIV kbool from expr_test order by id"""
	qt_sql_test_BigInt_Boolean_notn_2 """
		select id, kbint DIV kbool from expr_test_not_nullable order by id"""
	qt_sql_test_BigInt_Boolean_3 """
		select id, kbint & kbool, kbint | kbool, kbint ^ kbool from expr_test order by id"""
	qt_sql_test_BigInt_Boolean_notn_3 """
		select id, kbint & kbool, kbint | kbool, kbint ^ kbool from expr_test_not_nullable order by id"""
	qt_sql_test_BigInt_Boolean_4 """
		select id, BITAND(kbint, kbool), BITOR(kbint, kbool), BITXOR(kbint, kbool) from expr_test order by id"""
	qt_sql_test_BigInt_Boolean_notn_4 """
		select id, BITAND(kbint, kbool), BITOR(kbint, kbool), BITXOR(kbint, kbool) from expr_test_not_nullable order by id"""
	qt_sql_test_LargeInt_TinyInt_0 """
		select id, klint + ktint, klint - ktint from expr_test order by id"""
	qt_sql_test_LargeInt_TinyInt_notn_0 """
		select id, klint + ktint, klint - ktint from expr_test_not_nullable order by id"""
	qt_sql_test_LargeInt_TinyInt_1 """
		select id, klint * ktint, klint / ktint, klint % ktint from expr_test order by id"""
	qt_sql_test_LargeInt_TinyInt_notn_1 """
		select id, klint * ktint, klint / ktint, klint % ktint from expr_test_not_nullable order by id"""
	qt_sql_test_LargeInt_TinyInt_2 """
		select id, klint DIV ktint from expr_test order by id"""
	qt_sql_test_LargeInt_TinyInt_notn_2 """
		select id, klint DIV ktint from expr_test_not_nullable order by id"""
	qt_sql_test_LargeInt_TinyInt_3 """
		select id, klint & ktint, klint | ktint, klint ^ ktint from expr_test order by id"""
	qt_sql_test_LargeInt_TinyInt_notn_3 """
		select id, klint & ktint, klint | ktint, klint ^ ktint from expr_test_not_nullable order by id"""
	qt_sql_test_LargeInt_TinyInt_4 """
		select id, BITAND(klint, ktint), BITOR(klint, ktint), BITXOR(klint, ktint) from expr_test order by id"""
	qt_sql_test_LargeInt_TinyInt_notn_4 """
		select id, BITAND(klint, ktint), BITOR(klint, ktint), BITXOR(klint, ktint) from expr_test_not_nullable order by id"""
	qt_sql_test_LargeInt_SmallInt_0 """
		select id, klint + ksint, klint - ksint from expr_test order by id"""
	qt_sql_test_LargeInt_SmallInt_notn_0 """
		select id, klint + ksint, klint - ksint from expr_test_not_nullable order by id"""
	qt_sql_test_LargeInt_SmallInt_1 """
		select id, klint * ksint, klint / ksint, klint % ksint from expr_test order by id"""
	qt_sql_test_LargeInt_SmallInt_notn_1 """
		select id, klint * ksint, klint / ksint, klint % ksint from expr_test_not_nullable order by id"""
	qt_sql_test_LargeInt_SmallInt_2 """
		select id, klint DIV ksint from expr_test order by id"""
	qt_sql_test_LargeInt_SmallInt_notn_2 """
		select id, klint DIV ksint from expr_test_not_nullable order by id"""
	qt_sql_test_LargeInt_SmallInt_3 """
		select id, klint & ksint, klint | ksint, klint ^ ksint from expr_test order by id"""
	qt_sql_test_LargeInt_SmallInt_notn_3 """
		select id, klint & ksint, klint | ksint, klint ^ ksint from expr_test_not_nullable order by id"""
	qt_sql_test_LargeInt_SmallInt_4 """
		select id, BITAND(klint, ksint), BITOR(klint, ksint), BITXOR(klint, ksint) from expr_test order by id"""
	qt_sql_test_LargeInt_SmallInt_notn_4 """
		select id, BITAND(klint, ksint), BITOR(klint, ksint), BITXOR(klint, ksint) from expr_test_not_nullable order by id"""
	qt_sql_test_LargeInt_Integer_0 """
		select id, klint + kint, klint - kint from expr_test order by id"""
	qt_sql_test_LargeInt_Integer_notn_0 """
		select id, klint + kint, klint - kint from expr_test_not_nullable order by id"""
	qt_sql_test_LargeInt_Integer_1 """
		select id, klint * kint, klint / kint, klint % kint from expr_test order by id"""
	qt_sql_test_LargeInt_Integer_notn_1 """
		select id, klint * kint, klint / kint, klint % kint from expr_test_not_nullable order by id"""
	qt_sql_test_LargeInt_Integer_2 """
		select id, klint DIV kint from expr_test order by id"""
	qt_sql_test_LargeInt_Integer_notn_2 """
		select id, klint DIV kint from expr_test_not_nullable order by id"""
	qt_sql_test_LargeInt_Integer_3 """
		select id, klint & kint, klint | kint, klint ^ kint from expr_test order by id"""
	qt_sql_test_LargeInt_Integer_notn_3 """
		select id, klint & kint, klint | kint, klint ^ kint from expr_test_not_nullable order by id"""
	qt_sql_test_LargeInt_Integer_4 """
		select id, BITAND(klint, kint), BITOR(klint, kint), BITXOR(klint, kint) from expr_test order by id"""
	qt_sql_test_LargeInt_Integer_notn_4 """
		select id, BITAND(klint, kint), BITOR(klint, kint), BITXOR(klint, kint) from expr_test_not_nullable order by id"""
	qt_sql_test_LargeInt_BigInt_0 """
		select id, klint + kbint, klint - kbint from expr_test order by id"""
	qt_sql_test_LargeInt_BigInt_notn_0 """
		select id, klint + kbint, klint - kbint from expr_test_not_nullable order by id"""
	qt_sql_test_LargeInt_BigInt_1 """
		select id, klint * kbint, klint / kbint, klint % kbint from expr_test order by id"""
	qt_sql_test_LargeInt_BigInt_notn_1 """
		select id, klint * kbint, klint / kbint, klint % kbint from expr_test_not_nullable order by id"""
	qt_sql_test_LargeInt_BigInt_2 """
		select id, klint DIV kbint from expr_test order by id"""
	qt_sql_test_LargeInt_BigInt_notn_2 """
		select id, klint DIV kbint from expr_test_not_nullable order by id"""
	qt_sql_test_LargeInt_BigInt_3 """
		select id, klint & kbint, klint | kbint, klint ^ kbint from expr_test order by id"""
	qt_sql_test_LargeInt_BigInt_notn_3 """
		select id, klint & kbint, klint | kbint, klint ^ kbint from expr_test_not_nullable order by id"""
	qt_sql_test_LargeInt_BigInt_4 """
		select id, BITAND(klint, kbint), BITOR(klint, kbint), BITXOR(klint, kbint) from expr_test order by id"""
	qt_sql_test_LargeInt_BigInt_notn_4 """
		select id, BITAND(klint, kbint), BITOR(klint, kbint), BITXOR(klint, kbint) from expr_test_not_nullable order by id"""
	qt_sql_test_LargeInt_LargeInt_0 """
		select id, klint + klint, klint - klint from expr_test order by id"""
	qt_sql_test_LargeInt_LargeInt_notn_0 """
		select id, klint + klint, klint - klint from expr_test_not_nullable order by id"""
	qt_sql_test_LargeInt_LargeInt_1 """
		select id, klint * klint, klint / klint, klint % klint from expr_test order by id"""
	qt_sql_test_LargeInt_LargeInt_notn_1 """
		select id, klint * klint, klint / klint, klint % klint from expr_test_not_nullable order by id"""
	qt_sql_test_LargeInt_LargeInt_2 """
		select id, klint DIV klint from expr_test order by id"""
	qt_sql_test_LargeInt_LargeInt_notn_2 """
		select id, klint DIV klint from expr_test_not_nullable order by id"""
	qt_sql_test_LargeInt_LargeInt_3 """
		select id, klint & klint, klint | klint, klint ^ klint from expr_test order by id"""
	qt_sql_test_LargeInt_LargeInt_notn_3 """
		select id, klint & klint, klint | klint, klint ^ klint from expr_test_not_nullable order by id"""
	qt_sql_test_LargeInt_LargeInt_4 """
		select id, BITAND(klint, klint), BITOR(klint, klint), BITXOR(klint, klint) from expr_test order by id"""
	qt_sql_test_LargeInt_LargeInt_notn_4 """
		select id, BITAND(klint, klint), BITOR(klint, klint), BITXOR(klint, klint) from expr_test_not_nullable order by id"""
	qt_sql_test_LargeInt_Float_0 """
		select id, klint + kfloat, klint - kfloat from expr_test order by id"""
	qt_sql_test_LargeInt_Float_notn_0 """
		select id, klint + kfloat, klint - kfloat from expr_test_not_nullable order by id"""
	// qt_sql_test_LargeInt_Float_1 """
	// 	select id, klint * kfloat, klint / kfloat, klint % kfloat from expr_test order by id"""
	// qt_sql_test_LargeInt_Float_notn_1 """
	// 	select id, klint * kfloat, klint / kfloat, klint % kfloat from expr_test_not_nullable order by id"""
	//original planner qt_sql_test_LargeInt_Float_2 """
	//original planner 	select id, klint DIV kfloat from expr_test order by id"""
	//original planner qt_sql_test_LargeInt_Float_notn_2 """
	//original planner 	select id, klint DIV kfloat from expr_test_not_nullable order by id"""
	qt_sql_test_LargeInt_Float_3 """
		select id, klint & kfloat, klint | kfloat, klint ^ kfloat from expr_test order by id"""
	qt_sql_test_LargeInt_Float_notn_3 """
		select id, klint & kfloat, klint | kfloat, klint ^ kfloat from expr_test_not_nullable order by id"""
	// qt_sql_test_LargeInt_Float_4 """
	// 	select id, BITAND(klint, kfloat), BITOR(klint, kfloat), BITXOR(klint, kfloat) from expr_test order by id"""
	// qt_sql_test_LargeInt_Float_notn_4 """
	// 	select id, BITAND(klint, kfloat), BITOR(klint, kfloat), BITXOR(klint, kfloat) from expr_test_not_nullable order by id"""
	qt_sql_test_LargeInt_Double_0 """
		select id, klint + kdbl, klint - kdbl from expr_test order by id"""
	qt_sql_test_LargeInt_Double_notn_0 """
		select id, klint + kdbl, klint - kdbl from expr_test_not_nullable order by id"""
	qt_sql_test_LargeInt_Double_1 """
		select id, klint * kdbl, klint / kdbl, klint % kdbl from expr_test order by id"""
	qt_sql_test_LargeInt_Double_notn_1 """
		select id, klint * kdbl, klint / kdbl, klint % kdbl from expr_test_not_nullable order by id"""
	//original planner qt_sql_test_LargeInt_Double_2 """
	//original planner 	select id, klint DIV kdbl from expr_test order by id"""
	//original planner qt_sql_test_LargeInt_Double_notn_2 """
	//original planner 	select id, klint DIV kdbl from expr_test_not_nullable order by id"""
	qt_sql_test_LargeInt_Double_3 """
		select id, klint & kdbl, klint | kdbl, klint ^ kdbl from expr_test order by id"""
	qt_sql_test_LargeInt_Double_notn_3 """
		select id, klint & kdbl, klint | kdbl, klint ^ kdbl from expr_test_not_nullable order by id"""
	// qt_sql_test_LargeInt_Double_4 """
	// 	select id, BITAND(klint, kdbl), BITOR(klint, kdbl), BITXOR(klint, kdbl) from expr_test order by id"""
	// qt_sql_test_LargeInt_Double_notn_4 """
	// 	select id, BITAND(klint, kdbl), BITOR(klint, kdbl), BITXOR(klint, kdbl) from expr_test_not_nullable order by id"""
	qt_sql_test_LargeInt_DecimalV2_0 """
		select id, klint + kdcml, klint - kdcml from expr_test order by id"""
	qt_sql_test_LargeInt_DecimalV2_notn_0 """
		select id, klint + kdcml, klint - kdcml from expr_test_not_nullable order by id"""
	qt_sql_test_LargeInt_DecimalV2_1 """
		select id, klint * kdcml, klint / kdcml, klint % kdcml from expr_test order by id"""
	qt_sql_test_LargeInt_DecimalV2_notn_1 """
		select id, klint * kdcml, klint / kdcml, klint % kdcml from expr_test_not_nullable order by id"""
	qt_sql_test_LargeInt_DecimalV2_2 """
		select id, klint DIV kdcml from expr_test order by id"""
	qt_sql_test_LargeInt_DecimalV2_notn_2 """
		select id, klint DIV kdcml from expr_test_not_nullable order by id"""
	qt_sql_test_LargeInt_DecimalV2_3 """
		select id, klint & kdcml, klint | kdcml, klint ^ kdcml from expr_test order by id"""
	qt_sql_test_LargeInt_DecimalV2_notn_3 """
		select id, klint & kdcml, klint | kdcml, klint ^ kdcml from expr_test_not_nullable order by id"""
	// qt_sql_test_LargeInt_DecimalV2_4 """
	// 	select id, BITAND(klint, kdcml), BITOR(klint, kdcml), BITXOR(klint, kdcml) from expr_test order by id"""
	// qt_sql_test_LargeInt_DecimalV2_notn_4 """
	// 	select id, BITAND(klint, kdcml), BITOR(klint, kdcml), BITXOR(klint, kdcml) from expr_test_not_nullable order by id"""
	qt_sql_test_LargeInt_Decimal32V3_0 """
		select id, klint + kdcml32v3, klint - kdcml32v3 from expr_test order by id"""
	qt_sql_test_LargeInt_Decimal32V3_notn_0 """
		select id, klint + kdcml32v3, klint - kdcml32v3 from expr_test_not_nullable order by id"""
	//original planner qt_sql_test_LargeInt_Decimal32V3_1 """
	//original planner 	select id, klint * kdcml32v3, klint / kdcml32v3, klint % kdcml32v3 from expr_test order by id"""
	//original planner qt_sql_test_LargeInt_Decimal32V3_notn_1 """
	//original planner 	select id, klint * kdcml32v3, klint / kdcml32v3, klint % kdcml32v3 from expr_test_not_nullable order by id"""
	qt_sql_test_LargeInt_Decimal32V3_2 """
		select id, klint DIV kdcml32v3 from expr_test order by id"""
	qt_sql_test_LargeInt_Decimal32V3_notn_2 """
		select id, klint DIV kdcml32v3 from expr_test_not_nullable order by id"""
	qt_sql_test_LargeInt_Decimal32V3_3 """
		select id, klint & kdcml32v3, klint | kdcml32v3, klint ^ kdcml32v3 from expr_test order by id"""
	qt_sql_test_LargeInt_Decimal32V3_notn_3 """
		select id, klint & kdcml32v3, klint | kdcml32v3, klint ^ kdcml32v3 from expr_test_not_nullable order by id"""
	// qt_sql_test_LargeInt_Decimal32V3_4 """
	// 	select id, BITAND(klint, kdcml32v3), BITOR(klint, kdcml32v3), BITXOR(klint, kdcml32v3) from expr_test order by id"""
	// qt_sql_test_LargeInt_Decimal32V3_notn_4 """
	// 	select id, BITAND(klint, kdcml32v3), BITOR(klint, kdcml32v3), BITXOR(klint, kdcml32v3) from expr_test_not_nullable order by id"""
	qt_sql_test_LargeInt_Decimal64V3_0 """
		select id, klint + kdcml64v3, klint - kdcml64v3 from expr_test order by id"""
	qt_sql_test_LargeInt_Decimal64V3_notn_0 """
		select id, klint + kdcml64v3, klint - kdcml64v3 from expr_test_not_nullable order by id"""
	//original planner qt_sql_test_LargeInt_Decimal64V3_1 """
	//original planner 	select id, klint * kdcml64v3, klint / kdcml64v3, klint % kdcml64v3 from expr_test order by id"""
	//original planner qt_sql_test_LargeInt_Decimal64V3_notn_1 """
	//original planner 	select id, klint * kdcml64v3, klint / kdcml64v3, klint % kdcml64v3 from expr_test_not_nullable order by id"""
	qt_sql_test_LargeInt_Decimal64V3_2 """
		select id, klint DIV kdcml64v3 from expr_test order by id"""
	qt_sql_test_LargeInt_Decimal64V3_notn_2 """
		select id, klint DIV kdcml64v3 from expr_test_not_nullable order by id"""
	qt_sql_test_LargeInt_Decimal64V3_3 """
		select id, klint & kdcml64v3, klint | kdcml64v3, klint ^ kdcml64v3 from expr_test order by id"""
	qt_sql_test_LargeInt_Decimal64V3_notn_3 """
		select id, klint & kdcml64v3, klint | kdcml64v3, klint ^ kdcml64v3 from expr_test_not_nullable order by id"""
	// qt_sql_test_LargeInt_Decimal64V3_4 """
	// 	select id, BITAND(klint, kdcml64v3), BITOR(klint, kdcml64v3), BITXOR(klint, kdcml64v3) from expr_test order by id"""
	// qt_sql_test_LargeInt_Decimal64V3_notn_4 """
	// 	select id, BITAND(klint, kdcml64v3), BITOR(klint, kdcml64v3), BITXOR(klint, kdcml64v3) from expr_test_not_nullable order by id"""
	qt_sql_test_LargeInt_Decimal128V3_0 """
		select id, klint + kdcml128v3, klint - kdcml128v3 from expr_test order by id"""
	qt_sql_test_LargeInt_Decimal128V3_notn_0 """
		select id, klint + kdcml128v3, klint - kdcml128v3 from expr_test_not_nullable order by id"""
	//original planner qt_sql_test_LargeInt_Decimal128V3_1 """
	//original planner 	select id, klint * kdcml128v3, klint / kdcml128v3, klint % kdcml128v3 from expr_test order by id"""
	//original planner qt_sql_test_LargeInt_Decimal128V3_notn_1 """
	//original planner 	select id, klint * kdcml128v3, klint / kdcml128v3, klint % kdcml128v3 from expr_test_not_nullable order by id"""
	qt_sql_test_LargeInt_Decimal128V3_2 """
		select id, klint DIV kdcml128v3 from expr_test order by id"""
	qt_sql_test_LargeInt_Decimal128V3_notn_2 """
		select id, klint DIV kdcml128v3 from expr_test_not_nullable order by id"""
	qt_sql_test_LargeInt_Decimal128V3_3 """
		select id, klint & kdcml128v3, klint | kdcml128v3, klint ^ kdcml128v3 from expr_test order by id"""
	qt_sql_test_LargeInt_Decimal128V3_notn_3 """
		select id, klint & kdcml128v3, klint | kdcml128v3, klint ^ kdcml128v3 from expr_test_not_nullable order by id"""
	// qt_sql_test_LargeInt_Decimal128V3_4 """
	// 	select id, BITAND(klint, kdcml128v3), BITOR(klint, kdcml128v3), BITXOR(klint, kdcml128v3) from expr_test order by id"""
	// qt_sql_test_LargeInt_Decimal128V3_notn_4 """
	// 	select id, BITAND(klint, kdcml128v3), BITOR(klint, kdcml128v3), BITXOR(klint, kdcml128v3) from expr_test_not_nullable order by id"""
	qt_sql_test_LargeInt_Char_0 """
		select id, klint + kchr, klint - kchr from expr_test order by id"""
	qt_sql_test_LargeInt_Char_notn_0 """
		select id, klint + kchr, klint - kchr from expr_test_not_nullable order by id"""
	qt_sql_test_LargeInt_Char_1 """
		select id, klint * kchr, klint / kchr, klint % kchr from expr_test order by id"""
	qt_sql_test_LargeInt_Char_notn_1 """
		select id, klint * kchr, klint / kchr, klint % kchr from expr_test_not_nullable order by id"""
	//original planner qt_sql_test_LargeInt_Char_2 """
	//original planner 	select id, klint DIV kchr from expr_test order by id"""
	//original planner qt_sql_test_LargeInt_Char_notn_2 """
	//original planner 	select id, klint DIV kchr from expr_test_not_nullable order by id"""
	qt_sql_test_LargeInt_Char_3 """
		select id, klint & kchr, klint | kchr, klint ^ kchr from expr_test order by id"""
	qt_sql_test_LargeInt_Char_notn_3 """
		select id, klint & kchr, klint | kchr, klint ^ kchr from expr_test_not_nullable order by id"""
	// qt_sql_test_LargeInt_Char_4 """
	// 	select id, BITAND(klint, kchr), BITOR(klint, kchr), BITXOR(klint, kchr) from expr_test order by id"""
	// qt_sql_test_LargeInt_Char_notn_4 """
	// 	select id, BITAND(klint, kchr), BITOR(klint, kchr), BITXOR(klint, kchr) from expr_test_not_nullable order by id"""
	qt_sql_test_LargeInt_Varchar_0 """
		select id, klint + kvchr, klint - kvchr from expr_test order by id"""
	qt_sql_test_LargeInt_Varchar_notn_0 """
		select id, klint + kvchr, klint - kvchr from expr_test_not_nullable order by id"""
	qt_sql_test_LargeInt_Varchar_1 """
		select id, klint * kvchr, klint / kvchr, klint % kvchr from expr_test order by id"""
	qt_sql_test_LargeInt_Varchar_notn_1 """
		select id, klint * kvchr, klint / kvchr, klint % kvchr from expr_test_not_nullable order by id"""
	//original planner qt_sql_test_LargeInt_Varchar_2 """
	//original planner 	select id, klint DIV kvchr from expr_test order by id"""
	//original planner qt_sql_test_LargeInt_Varchar_notn_2 """
	//original planner 	select id, klint DIV kvchr from expr_test_not_nullable order by id"""
	qt_sql_test_LargeInt_Varchar_3 """
		select id, klint & kvchr, klint | kvchr, klint ^ kvchr from expr_test order by id"""
	qt_sql_test_LargeInt_Varchar_notn_3 """
		select id, klint & kvchr, klint | kvchr, klint ^ kvchr from expr_test_not_nullable order by id"""
	// qt_sql_test_LargeInt_Varchar_4 """
	// 	select id, BITAND(klint, kvchr), BITOR(klint, kvchr), BITXOR(klint, kvchr) from expr_test order by id"""
	// qt_sql_test_LargeInt_Varchar_notn_4 """
	// 	select id, BITAND(klint, kvchr), BITOR(klint, kvchr), BITXOR(klint, kvchr) from expr_test_not_nullable order by id"""
	qt_sql_test_LargeInt_String_0 """
		select id, klint + kstr, klint - kstr from expr_test order by id"""
	qt_sql_test_LargeInt_String_notn_0 """
		select id, klint + kstr, klint - kstr from expr_test_not_nullable order by id"""
	qt_sql_test_LargeInt_String_1 """
		select id, klint * kstr, klint / kstr, klint % kstr from expr_test order by id"""
	qt_sql_test_LargeInt_String_notn_1 """
		select id, klint * kstr, klint / kstr, klint % kstr from expr_test_not_nullable order by id"""
	//original planner qt_sql_test_LargeInt_String_2 """
	//original planner 	select id, klint DIV kstr from expr_test order by id"""
	//original planner qt_sql_test_LargeInt_String_notn_2 """
	//original planner 	select id, klint DIV kstr from expr_test_not_nullable order by id"""
	qt_sql_test_LargeInt_String_3 """
		select id, klint & kstr, klint | kstr, klint ^ kstr from expr_test order by id"""
	qt_sql_test_LargeInt_String_notn_3 """
		select id, klint & kstr, klint | kstr, klint ^ kstr from expr_test_not_nullable order by id"""
	// qt_sql_test_LargeInt_String_4 """
	// 	select id, BITAND(klint, kstr), BITOR(klint, kstr), BITXOR(klint, kstr) from expr_test order by id"""
	// qt_sql_test_LargeInt_String_notn_4 """
	// 	select id, BITAND(klint, kstr), BITOR(klint, kstr), BITXOR(klint, kstr) from expr_test_not_nullable order by id"""
	qt_sql_test_LargeInt_Date_0 """
		select id, klint + kdt, klint - kdt from expr_test order by id"""
	qt_sql_test_LargeInt_Date_notn_0 """
		select id, klint + kdt, klint - kdt from expr_test_not_nullable order by id"""
	qt_sql_test_LargeInt_Date_1 """
		select id, klint * kdt, klint / kdt, klint % kdt from expr_test order by id"""
	qt_sql_test_LargeInt_Date_notn_1 """
		select id, klint * kdt, klint / kdt, klint % kdt from expr_test_not_nullable order by id"""
	qt_sql_test_LargeInt_Date_2 """
		select id, klint DIV kdt from expr_test order by id"""
	qt_sql_test_LargeInt_Date_notn_2 """
		select id, klint DIV kdt from expr_test_not_nullable order by id"""
	qt_sql_test_LargeInt_Date_3 """
		select id, klint & kdt, klint | kdt, klint ^ kdt from expr_test order by id"""
	qt_sql_test_LargeInt_Date_notn_3 """
		select id, klint & kdt, klint | kdt, klint ^ kdt from expr_test_not_nullable order by id"""
	qt_sql_test_LargeInt_Date_4 """
		select id, BITAND(klint, kdt), BITOR(klint, kdt), BITXOR(klint, kdt) from expr_test order by id"""
	qt_sql_test_LargeInt_Date_notn_4 """
		select id, BITAND(klint, kdt), BITOR(klint, kdt), BITXOR(klint, kdt) from expr_test_not_nullable order by id"""
	qt_sql_test_LargeInt_DateTime_0 """
		select id, klint + kdtm, klint - kdtm from expr_test order by id"""
	qt_sql_test_LargeInt_DateTime_notn_0 """
		select id, klint + kdtm, klint - kdtm from expr_test_not_nullable order by id"""
	qt_sql_test_LargeInt_DateTime_1 """
		select id, klint * kdtm, klint / kdtm, klint % kdtm from expr_test order by id"""
	qt_sql_test_LargeInt_DateTime_notn_1 """
		select id, klint * kdtm, klint / kdtm, klint % kdtm from expr_test_not_nullable order by id"""
	qt_sql_test_LargeInt_DateTime_2 """
		select id, klint DIV kdtm from expr_test order by id"""
	qt_sql_test_LargeInt_DateTime_notn_2 """
		select id, klint DIV kdtm from expr_test_not_nullable order by id"""
	qt_sql_test_LargeInt_DateTime_3 """
		select id, klint & kdtm, klint | kdtm, klint ^ kdtm from expr_test order by id"""
	qt_sql_test_LargeInt_DateTime_notn_3 """
		select id, klint & kdtm, klint | kdtm, klint ^ kdtm from expr_test_not_nullable order by id"""
	qt_sql_test_LargeInt_DateTime_4 """
		select id, BITAND(klint, kdtm), BITOR(klint, kdtm), BITXOR(klint, kdtm) from expr_test order by id"""
	qt_sql_test_LargeInt_DateTime_notn_4 """
		select id, BITAND(klint, kdtm), BITOR(klint, kdtm), BITXOR(klint, kdtm) from expr_test_not_nullable order by id"""
	qt_sql_test_LargeInt_DateV2_0 """
		select id, klint + kdtv2, klint - kdtv2 from expr_test order by id"""
	qt_sql_test_LargeInt_DateV2_notn_0 """
		select id, klint + kdtv2, klint - kdtv2 from expr_test_not_nullable order by id"""
	qt_sql_test_LargeInt_DateV2_1 """
		select id, klint * kdtv2, klint / kdtv2, klint % kdtv2 from expr_test order by id"""
	qt_sql_test_LargeInt_DateV2_notn_1 """
		select id, klint * kdtv2, klint / kdtv2, klint % kdtv2 from expr_test_not_nullable order by id"""
	qt_sql_test_LargeInt_DateV2_2 """
		select id, klint DIV kdtv2 from expr_test order by id"""
	qt_sql_test_LargeInt_DateV2_notn_2 """
		select id, klint DIV kdtv2 from expr_test_not_nullable order by id"""
	qt_sql_test_LargeInt_DateV2_3 """
		select id, klint & kdtv2, klint | kdtv2, klint ^ kdtv2 from expr_test order by id"""
	qt_sql_test_LargeInt_DateV2_notn_3 """
		select id, klint & kdtv2, klint | kdtv2, klint ^ kdtv2 from expr_test_not_nullable order by id"""
	qt_sql_test_LargeInt_DateV2_4 """
		select id, BITAND(klint, kdtv2), BITOR(klint, kdtv2), BITXOR(klint, kdtv2) from expr_test order by id"""
	qt_sql_test_LargeInt_DateV2_notn_4 """
		select id, BITAND(klint, kdtv2), BITOR(klint, kdtv2), BITXOR(klint, kdtv2) from expr_test_not_nullable order by id"""
	qt_sql_test_LargeInt_DateTimeV2_0 """
		select id, klint + kdtmv2, klint - kdtmv2 from expr_test order by id"""
	qt_sql_test_LargeInt_DateTimeV2_notn_0 """
		select id, klint + kdtmv2, klint - kdtmv2 from expr_test_not_nullable order by id"""
	qt_sql_test_LargeInt_DateTimeV2_1 """
		select id, klint * kdtmv2, klint / kdtmv2, klint % kdtmv2 from expr_test order by id"""
	qt_sql_test_LargeInt_DateTimeV2_notn_1 """
		select id, klint * kdtmv2, klint / kdtmv2, klint % kdtmv2 from expr_test_not_nullable order by id"""
	qt_sql_test_LargeInt_DateTimeV2_2 """
		select id, klint DIV kdtmv2 from expr_test order by id"""
	qt_sql_test_LargeInt_DateTimeV2_notn_2 """
		select id, klint DIV kdtmv2 from expr_test_not_nullable order by id"""
	qt_sql_test_LargeInt_DateTimeV2_3 """
		select id, klint & kdtmv2, klint | kdtmv2, klint ^ kdtmv2 from expr_test order by id"""
	qt_sql_test_LargeInt_DateTimeV2_notn_3 """
		select id, klint & kdtmv2, klint | kdtmv2, klint ^ kdtmv2 from expr_test_not_nullable order by id"""
	qt_sql_test_LargeInt_DateTimeV2_4 """
		select id, BITAND(klint, kdtmv2), BITOR(klint, kdtmv2), BITXOR(klint, kdtmv2) from expr_test order by id"""
	qt_sql_test_LargeInt_DateTimeV2_notn_4 """
		select id, BITAND(klint, kdtmv2), BITOR(klint, kdtmv2), BITXOR(klint, kdtmv2) from expr_test_not_nullable order by id"""
	qt_sql_test_LargeInt_Boolean_0 """
		select id, klint + kbool, klint - kbool from expr_test order by id"""
	qt_sql_test_LargeInt_Boolean_notn_0 """
		select id, klint + kbool, klint - kbool from expr_test_not_nullable order by id"""
	qt_sql_test_LargeInt_Boolean_1 """
		select id, klint * kbool, klint / kbool, klint % kbool from expr_test order by id"""
	qt_sql_test_LargeInt_Boolean_notn_1 """
		select id, klint * kbool, klint / kbool, klint % kbool from expr_test_not_nullable order by id"""
	qt_sql_test_LargeInt_Boolean_2 """
		select id, klint DIV kbool from expr_test order by id"""
	qt_sql_test_LargeInt_Boolean_notn_2 """
		select id, klint DIV kbool from expr_test_not_nullable order by id"""
	qt_sql_test_LargeInt_Boolean_3 """
		select id, klint & kbool, klint | kbool, klint ^ kbool from expr_test order by id"""
	qt_sql_test_LargeInt_Boolean_notn_3 """
		select id, klint & kbool, klint | kbool, klint ^ kbool from expr_test_not_nullable order by id"""
	qt_sql_test_LargeInt_Boolean_4 """
		select id, BITAND(klint, kbool), BITOR(klint, kbool), BITXOR(klint, kbool) from expr_test order by id"""
	qt_sql_test_LargeInt_Boolean_notn_4 """
		select id, BITAND(klint, kbool), BITOR(klint, kbool), BITXOR(klint, kbool) from expr_test_not_nullable order by id"""
}