// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

suite('test_dynamic_partition_failed', 'nonConcurrent') {
    def old_max_dynamic_partition_num = getFeConfig('max_dynamic_partition_num')
    try {
        sql 'DROP TABLE IF EXISTS test_dynamic_partition_failed_1'
        sql '''CREATE TABLE test_dynamic_partition_failed_1
              ( `k1` datetime NULL )
              PARTITION BY RANGE (k1)()
              DISTRIBUTED BY HASH(`k1`) BUCKETS 1
              PROPERTIES
              (
                "replication_num" = "1",
                "dynamic_partition.enable" = "true",
                "dynamic_partition.end" = "3",
                "dynamic_partition.time_unit" = "day",
                "dynamic_partition.prefix" = "p",
                "dynamic_partition.buckets" = "1",
                "dynamic_partition.start" = "-99999999",
                "dynamic_partition.history_partition_num" = "5",
                "dynamic_partition.create_history_partition" = "true"
              )'''

        def partitions = sql_return_maparray "SHOW PARTITIONS FROM test_dynamic_partition_failed_1"
        assertEquals(9, partitions.size());

        setFeConfig('max_dynamic_partition_num', Integer.MAX_VALUE)

        sql 'DROP TABLE IF EXISTS test_dynamic_partition_failed_2'
        test {
            sql '''CREATE TABLE test_dynamic_partition_failed_2
                  ( `k1` datetime NULL )
                  PARTITION BY RANGE (k1)()
                  DISTRIBUTED BY HASH(`k1`) BUCKETS 1
                  PROPERTIES
                  (
                    "replication_num" = "1",
                    "dynamic_partition.enable" = "true",
                    "dynamic_partition.end" = "3",
                    "dynamic_partition.time_unit" = "day",
                    "dynamic_partition.prefix" = "p",
                    "dynamic_partition.buckets" = "1",
                    "dynamic_partition.start" = "-99999999",
                    "dynamic_partition.create_history_partition" = "true"
                  )'''
            check { result, exception, startTime, endTime ->
                assertNotNull(exception)
                def msg = exception.toString()
                logger.info("exception: " + msg)
                // 'date/datetime literal [+271768-09-11 00:00:00] is invalid'
                assertTrue(msg.contains('date/datetime literal') && msg.contains('is invalid'))
            }
        }
    } finally {
        setFeConfig('max_dynamic_partition_num', old_max_dynamic_partition_num)
        sql 'DROP TABLE IF EXISTS test_dynamic_partition_failed_1'
        sql 'DROP TABLE IF EXISTS test_dynamic_partition_failed_2'
    }
}
