// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

#pragma once

#include <gen_cpp/AgentService_types.h>

#include <map>
#include <shared_mutex>
#include <vector>

namespace doris {
class TopicListener;

class TopicSubscriber {
public:
    TopicSubscriber();
    ~TopicSubscriber();
    // Put the topic type and listener to the map
    void register_listener(TTopicType::type topic_type, TopicListener* listener);
    // Handle all updates in the request
    void handle_updates(const TAgentPublishRequest& agent_publish_request);

private:
    std::map<TTopicType::type, std::vector<TopicListener*>> _registered_listeners;
    std::shared_mutex _listener_mtx;
};
} // namespace doris
