// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

package org.apache.doris.nereids.trees.expressions.functions.scalar;

import org.apache.doris.catalog.FunctionSignature;
import org.apache.doris.nereids.trees.expressions.Expression;
import org.apache.doris.nereids.trees.expressions.functions.AlwaysNotNullable;
import org.apache.doris.nereids.trees.expressions.functions.ExplicitlyCastableSignature;
import org.apache.doris.nereids.trees.expressions.shape.BinaryExpression;
import org.apache.doris.nereids.trees.expressions.visitor.ExpressionVisitor;
import org.apache.doris.nereids.types.ArrayType;
import org.apache.doris.nereids.types.BigIntType;
import org.apache.doris.nereids.types.BooleanType;
import org.apache.doris.nereids.types.DateTimeType;
import org.apache.doris.nereids.types.DateType;
import org.apache.doris.nereids.types.DecimalV2Type;
import org.apache.doris.nereids.types.DecimalV3Type;
import org.apache.doris.nereids.types.DoubleType;
import org.apache.doris.nereids.types.FloatType;
import org.apache.doris.nereids.types.IntegerType;
import org.apache.doris.nereids.types.LargeIntType;
import org.apache.doris.nereids.types.SmallIntType;
import org.apache.doris.nereids.types.StringType;
import org.apache.doris.nereids.types.TinyIntType;
import org.apache.doris.nereids.types.VarcharType;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;

import java.util.List;

/**
 * ScalarFunction 'array_with_constant'. This class is generated by GenerateFunction.
 */
public class ArrayWithConstant extends ScalarFunction
        implements BinaryExpression, ExplicitlyCastableSignature, AlwaysNotNullable {

    public static final List<FunctionSignature> SIGNATURES = ImmutableList.of(
            FunctionSignature.ret(ArrayType.of(BooleanType.INSTANCE)).args(BigIntType.INSTANCE, BooleanType.INSTANCE),
            FunctionSignature.ret(ArrayType.of(TinyIntType.INSTANCE)).args(BigIntType.INSTANCE, TinyIntType.INSTANCE),
            FunctionSignature.ret(ArrayType.of(SmallIntType.INSTANCE)).args(BigIntType.INSTANCE, SmallIntType.INSTANCE),
            FunctionSignature.ret(ArrayType.of(IntegerType.INSTANCE)).args(BigIntType.INSTANCE, IntegerType.INSTANCE),
            FunctionSignature.ret(ArrayType.of(BigIntType.INSTANCE)).args(BigIntType.INSTANCE, BigIntType.INSTANCE),
            FunctionSignature.ret(ArrayType.of(LargeIntType.INSTANCE)).args(BigIntType.INSTANCE, LargeIntType.INSTANCE),
            FunctionSignature.ret(ArrayType.of(DateTimeType.INSTANCE)).args(BigIntType.INSTANCE, DateTimeType.INSTANCE),
            FunctionSignature.ret(ArrayType.of(DateType.INSTANCE)).args(BigIntType.INSTANCE, DateType.INSTANCE),
            FunctionSignature.ret(ArrayType.of(FloatType.INSTANCE)).args(BigIntType.INSTANCE, FloatType.INSTANCE),
            FunctionSignature.ret(ArrayType.of(DoubleType.INSTANCE)).args(BigIntType.INSTANCE, DoubleType.INSTANCE),
            FunctionSignature.ret(ArrayType.of(DecimalV2Type.SYSTEM_DEFAULT))
                    .args(BigIntType.INSTANCE, DecimalV2Type.SYSTEM_DEFAULT),
            FunctionSignature.ret(ArrayType.of(DecimalV3Type.WILDCARD))
                    .args(BigIntType.INSTANCE, DecimalV3Type.WILDCARD),
            FunctionSignature.ret(ArrayType.of(VarcharType.SYSTEM_DEFAULT))
                    .args(BigIntType.INSTANCE, VarcharType.SYSTEM_DEFAULT),
            FunctionSignature.ret(ArrayType.of(StringType.INSTANCE)).args(BigIntType.INSTANCE, StringType.INSTANCE)
    );

    /**
     * constructor with 2 arguments.
     */
    public ArrayWithConstant(Expression arg0, Expression arg1) {
        super("array_with_constant", arg0, arg1);
    }

    /**
     * withChildren.
     */
    @Override
    public ArrayWithConstant withChildren(List<Expression> children) {
        Preconditions.checkArgument(children.size() == 2);
        return new ArrayWithConstant(children.get(0), children.get(1));
    }

    @Override
    public <R, C> R accept(ExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitArrayWithConstant(this, context);
    }

    @Override
    public List<FunctionSignature> getSignatures() {
        return SIGNATURES;
    }
}
