// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

package org.apache.doris.nereids.trees.expressions.functions.scalar;

import org.apache.doris.catalog.FunctionSignature;
import org.apache.doris.nereids.trees.expressions.Expression;
import org.apache.doris.nereids.trees.expressions.functions.AlwaysNullable;
import org.apache.doris.nereids.trees.expressions.functions.ExplicitlyCastableSignature;
import org.apache.doris.nereids.trees.expressions.shape.BinaryExpression;
import org.apache.doris.nereids.trees.expressions.visitor.ExpressionVisitor;
import org.apache.doris.nereids.types.ArrayType;
import org.apache.doris.nereids.types.BigIntType;
import org.apache.doris.nereids.types.BooleanType;
import org.apache.doris.nereids.types.DateTimeType;
import org.apache.doris.nereids.types.DateTimeV2Type;
import org.apache.doris.nereids.types.DateType;
import org.apache.doris.nereids.types.DateV2Type;
import org.apache.doris.nereids.types.DecimalV2Type;
import org.apache.doris.nereids.types.DecimalV3Type;
import org.apache.doris.nereids.types.DoubleType;
import org.apache.doris.nereids.types.FloatType;
import org.apache.doris.nereids.types.IntegerType;
import org.apache.doris.nereids.types.LargeIntType;
import org.apache.doris.nereids.types.SmallIntType;
import org.apache.doris.nereids.types.StringType;
import org.apache.doris.nereids.types.TinyIntType;
import org.apache.doris.nereids.types.VarcharType;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;

import java.util.List;

/**
 * ScalarFunction 'array_position'. This class is generated by GenerateFunction.
 */
public class ArrayPosition extends ScalarFunction
        implements BinaryExpression, ExplicitlyCastableSignature, AlwaysNullable {

    public static final List<FunctionSignature> SIGNATURES = ImmutableList.of(
            FunctionSignature.ret(BigIntType.INSTANCE).args(ArrayType.of(BooleanType.INSTANCE), BooleanType.INSTANCE),
            FunctionSignature.ret(BigIntType.INSTANCE).args(ArrayType.of(TinyIntType.INSTANCE), TinyIntType.INSTANCE),
            FunctionSignature.ret(BigIntType.INSTANCE).args(ArrayType.of(SmallIntType.INSTANCE), SmallIntType.INSTANCE),
            FunctionSignature.ret(BigIntType.INSTANCE).args(ArrayType.of(IntegerType.INSTANCE), IntegerType.INSTANCE),
            FunctionSignature.ret(BigIntType.INSTANCE).args(ArrayType.of(BigIntType.INSTANCE), BigIntType.INSTANCE),
            FunctionSignature.ret(BigIntType.INSTANCE).args(ArrayType.of(LargeIntType.INSTANCE), LargeIntType.INSTANCE),
            FunctionSignature.ret(BigIntType.INSTANCE).args(ArrayType.of(DateTimeType.INSTANCE), DateTimeType.INSTANCE),
            FunctionSignature.ret(BigIntType.INSTANCE).args(ArrayType.of(DateType.INSTANCE), DateType.INSTANCE),
            FunctionSignature.ret(BigIntType.INSTANCE)
                    .args(ArrayType.of(DateTimeV2Type.SYSTEM_DEFAULT), DateTimeV2Type.SYSTEM_DEFAULT),
            FunctionSignature.ret(BigIntType.INSTANCE).args(ArrayType.of(DateV2Type.INSTANCE), DateV2Type.INSTANCE),
            FunctionSignature.ret(BigIntType.INSTANCE).args(ArrayType.of(FloatType.INSTANCE), FloatType.INSTANCE),
            FunctionSignature.ret(BigIntType.INSTANCE).args(ArrayType.of(DoubleType.INSTANCE), DoubleType.INSTANCE),
            FunctionSignature.ret(BigIntType.INSTANCE)
                    .args(ArrayType.of(DecimalV2Type.SYSTEM_DEFAULT), DecimalV2Type.SYSTEM_DEFAULT),
            FunctionSignature.ret(BigIntType.INSTANCE)
                    .args(ArrayType.of(DecimalV3Type.WILDCARD), DecimalV3Type.WILDCARD),
            FunctionSignature.ret(BigIntType.INSTANCE)
                    .args(ArrayType.of(VarcharType.SYSTEM_DEFAULT), VarcharType.SYSTEM_DEFAULT),
            FunctionSignature.ret(BigIntType.INSTANCE).args(ArrayType.of(StringType.INSTANCE), StringType.INSTANCE)
    );

    /**
     * constructor with 2 arguments.
     */
    public ArrayPosition(Expression arg0, Expression arg1) {
        super("array_position", arg0, arg1);
    }

    /**
     * withChildren.
     */
    @Override
    public ArrayPosition withChildren(List<Expression> children) {
        Preconditions.checkArgument(children.size() == 2);
        return new ArrayPosition(children.get(0), children.get(1));
    }

    @Override
    public <R, C> R accept(ExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitArrayPosition(this, context);
    }

    @Override
    public List<FunctionSignature> getSignatures() {
        return SIGNATURES;
    }
}
