// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

#pragma once

#include <string>

#include "http/http_handler.h"
#include "util/easy_json.h"

namespace doris {
class HttpRequest;

// Get BE tablets info from http API.
class TabletsInfoAction : public HttpHandler {
public:
    TabletsInfoAction();
    void handle(HttpRequest* req) override;
    EasyJson get_tablets_info(std::string tablet_num_to_return);
    std::string host() { return _host; }

private:
    std::string _host;
};
} // namespace doris
