// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

suite('nereids_arith_p0_decimal') {
	sql 'use regression_test_nereids_arith_p0'
	sql 'set enable_nereids_planner=true'
	sql 'set enable_fallback_to_original_planner=false'
	qt_sql_test_Float_TinyInt_0 """
		select id, kfloat + ktint, kfloat - ktint from expr_test order by id"""
	qt_sql_test_Float_TinyInt_notn_0 """
		select id, kfloat + ktint, kfloat - ktint from expr_test_not_nullable order by id"""
	qt_sql_test_Float_TinyInt_1 """
		select id, kfloat * ktint, kfloat / ktint, kfloat % ktint from expr_test order by id"""
	qt_sql_test_Float_TinyInt_notn_1 """
		select id, kfloat * ktint, kfloat / ktint, kfloat % ktint from expr_test_not_nullable order by id"""
	qt_sql_test_Float_TinyInt_2 """
		select id, kfloat DIV ktint from expr_test order by id"""
	qt_sql_test_Float_TinyInt_notn_2 """
		select id, kfloat DIV ktint from expr_test_not_nullable order by id"""
	qt_sql_test_Float_TinyInt_3 """
		select id, kfloat & ktint, kfloat | ktint, kfloat ^ ktint from expr_test order by id"""
	qt_sql_test_Float_TinyInt_notn_3 """
		select id, kfloat & ktint, kfloat | ktint, kfloat ^ ktint from expr_test_not_nullable order by id"""
	qt_sql_test_Float_TinyInt_4 """
		select id, BITAND(kfloat, ktint), BITOR(kfloat, ktint), BITXOR(kfloat, ktint) from expr_test order by id"""
	qt_sql_test_Float_TinyInt_notn_4 """
		select id, BITAND(kfloat, ktint), BITOR(kfloat, ktint), BITXOR(kfloat, ktint) from expr_test_not_nullable order by id"""
	qt_sql_test_Float_SmallInt_0 """
		select id, kfloat + ksint, kfloat - ksint from expr_test order by id"""
	qt_sql_test_Float_SmallInt_notn_0 """
		select id, kfloat + ksint, kfloat - ksint from expr_test_not_nullable order by id"""
	qt_sql_test_Float_SmallInt_1 """
		select id, kfloat * ksint, kfloat / ksint, kfloat % ksint from expr_test order by id"""
	qt_sql_test_Float_SmallInt_notn_1 """
		select id, kfloat * ksint, kfloat / ksint, kfloat % ksint from expr_test_not_nullable order by id"""
	qt_sql_test_Float_SmallInt_2 """
		select id, kfloat DIV ksint from expr_test order by id"""
	qt_sql_test_Float_SmallInt_notn_2 """
		select id, kfloat DIV ksint from expr_test_not_nullable order by id"""
	qt_sql_test_Float_SmallInt_3 """
		select id, kfloat & ksint, kfloat | ksint, kfloat ^ ksint from expr_test order by id"""
	qt_sql_test_Float_SmallInt_notn_3 """
		select id, kfloat & ksint, kfloat | ksint, kfloat ^ ksint from expr_test_not_nullable order by id"""
	// qt_sql_test_Float_SmallInt_4 """
	// 	select id, BITAND(kfloat, ksint), BITOR(kfloat, ksint), BITXOR(kfloat, ksint) from expr_test order by id"""
	// qt_sql_test_Float_SmallInt_notn_4 """
	// 	select id, BITAND(kfloat, ksint), BITOR(kfloat, ksint), BITXOR(kfloat, ksint) from expr_test_not_nullable order by id"""
	qt_sql_test_Float_Integer_0 """
		select id, kfloat + kint, kfloat - kint from expr_test order by id"""
	qt_sql_test_Float_Integer_notn_0 """
		select id, kfloat + kint, kfloat - kint from expr_test_not_nullable order by id"""
	qt_sql_test_Float_Integer_1 """
		select id, kfloat * kint, kfloat / kint, kfloat % kint from expr_test order by id"""
	qt_sql_test_Float_Integer_notn_1 """
		select id, kfloat * kint, kfloat / kint, kfloat % kint from expr_test_not_nullable order by id"""
	qt_sql_test_Float_Integer_2 """
		select id, kfloat DIV kint from expr_test order by id"""
	qt_sql_test_Float_Integer_notn_2 """
		select id, kfloat DIV kint from expr_test_not_nullable order by id"""
	qt_sql_test_Float_Integer_3 """
		select id, kfloat & kint, kfloat | kint, kfloat ^ kint from expr_test order by id"""
	qt_sql_test_Float_Integer_notn_3 """
		select id, kfloat & kint, kfloat | kint, kfloat ^ kint from expr_test_not_nullable order by id"""
	// qt_sql_test_Float_Integer_4 """
	// 	select id, BITAND(kfloat, kint), BITOR(kfloat, kint), BITXOR(kfloat, kint) from expr_test order by id"""
	// qt_sql_test_Float_Integer_notn_4 """
	// 	select id, BITAND(kfloat, kint), BITOR(kfloat, kint), BITXOR(kfloat, kint) from expr_test_not_nullable order by id"""
	qt_sql_test_Float_BigInt_0 """
		select id, kfloat + kbint, kfloat - kbint from expr_test order by id"""
	qt_sql_test_Float_BigInt_notn_0 """
		select id, kfloat + kbint, kfloat - kbint from expr_test_not_nullable order by id"""
	// qt_sql_test_Float_BigInt_1 """
	// 	select id, kfloat * kbint, kfloat / kbint, kfloat % kbint from expr_test order by id"""
	// qt_sql_test_Float_BigInt_notn_1 """
	// 	select id, kfloat * kbint, kfloat / kbint, kfloat % kbint from expr_test_not_nullable order by id"""
	qt_sql_test_Float_BigInt_2 """
		select id, kfloat DIV kbint from expr_test order by id"""
	qt_sql_test_Float_BigInt_notn_2 """
		select id, kfloat DIV kbint from expr_test_not_nullable order by id"""
	qt_sql_test_Float_BigInt_3 """
		select id, kfloat & kbint, kfloat | kbint, kfloat ^ kbint from expr_test order by id"""
	qt_sql_test_Float_BigInt_notn_3 """
		select id, kfloat & kbint, kfloat | kbint, kfloat ^ kbint from expr_test_not_nullable order by id"""
	// qt_sql_test_Float_BigInt_4 """
	// 	select id, BITAND(kfloat, kbint), BITOR(kfloat, kbint), BITXOR(kfloat, kbint) from expr_test order by id"""
	// qt_sql_test_Float_BigInt_notn_4 """
	// 	select id, BITAND(kfloat, kbint), BITOR(kfloat, kbint), BITXOR(kfloat, kbint) from expr_test_not_nullable order by id"""
	qt_sql_test_Float_LargeInt_0 """
		select id, kfloat + klint, kfloat - klint from expr_test order by id"""
	qt_sql_test_Float_LargeInt_notn_0 """
		select id, kfloat + klint, kfloat - klint from expr_test_not_nullable order by id"""
	// qt_sql_test_Float_LargeInt_1 """
	// 	select id, kfloat * klint, kfloat / klint, kfloat % klint from expr_test order by id"""
	// qt_sql_test_Float_LargeInt_notn_1 """
	// 	select id, kfloat * klint, kfloat / klint, kfloat % klint from expr_test_not_nullable order by id"""
	qt_sql_test_Float_LargeInt_2 """
		select id, kfloat DIV klint from expr_test order by id"""
	qt_sql_test_Float_LargeInt_notn_2 """
		select id, kfloat DIV klint from expr_test_not_nullable order by id"""
	qt_sql_test_Float_LargeInt_3 """
		select id, kfloat & klint, kfloat | klint, kfloat ^ klint from expr_test order by id"""
	qt_sql_test_Float_LargeInt_notn_3 """
		select id, kfloat & klint, kfloat | klint, kfloat ^ klint from expr_test_not_nullable order by id"""
	// qt_sql_test_Float_LargeInt_4 """
	// 	select id, BITAND(kfloat, klint), BITOR(kfloat, klint), BITXOR(kfloat, klint) from expr_test order by id"""
	// qt_sql_test_Float_LargeInt_notn_4 """
	// 	select id, BITAND(kfloat, klint), BITOR(kfloat, klint), BITXOR(kfloat, klint) from expr_test_not_nullable order by id"""
	qt_sql_test_Float_Float_0 """
		select id, kfloat + kfloat, kfloat - kfloat from expr_test order by id"""
	qt_sql_test_Float_Float_notn_0 """
		select id, kfloat + kfloat, kfloat - kfloat from expr_test_not_nullable order by id"""
	qt_sql_test_Float_Float_1 """
		select id, kfloat * kfloat, kfloat / kfloat, kfloat % kfloat from expr_test order by id"""
	qt_sql_test_Float_Float_notn_1 """
		select id, kfloat * kfloat, kfloat / kfloat, kfloat % kfloat from expr_test_not_nullable order by id"""
	qt_sql_test_Float_Float_2 """
		select id, kfloat DIV kfloat from expr_test order by id"""
	qt_sql_test_Float_Float_notn_2 """
		select id, kfloat DIV kfloat from expr_test_not_nullable order by id"""
	qt_sql_test_Float_Float_3 """
		select id, kfloat & kfloat, kfloat | kfloat, kfloat ^ kfloat from expr_test order by id"""
	qt_sql_test_Float_Float_notn_3 """
		select id, kfloat & kfloat, kfloat | kfloat, kfloat ^ kfloat from expr_test_not_nullable order by id"""
	qt_sql_test_Float_Float_4 """
		select id, BITAND(kfloat, kfloat), BITOR(kfloat, kfloat), BITXOR(kfloat, kfloat) from expr_test order by id"""
	qt_sql_test_Float_Float_notn_4 """
		select id, BITAND(kfloat, kfloat), BITOR(kfloat, kfloat), BITXOR(kfloat, kfloat) from expr_test_not_nullable order by id"""
	qt_sql_test_Float_Double_0 """
		select id, kfloat + kdbl, kfloat - kdbl from expr_test order by id"""
	qt_sql_test_Float_Double_notn_0 """
		select id, kfloat + kdbl, kfloat - kdbl from expr_test_not_nullable order by id"""
	qt_sql_test_Float_Double_1 """
		select id, kfloat * kdbl, kfloat / kdbl, kfloat % kdbl from expr_test order by id"""
	qt_sql_test_Float_Double_notn_1 """
		select id, kfloat * kdbl, kfloat / kdbl, kfloat % kdbl from expr_test_not_nullable order by id"""
	qt_sql_test_Float_Double_2 """
		select id, kfloat DIV kdbl from expr_test order by id"""
	qt_sql_test_Float_Double_notn_2 """
		select id, kfloat DIV kdbl from expr_test_not_nullable order by id"""
	qt_sql_test_Float_Double_3 """
		select id, kfloat & kdbl, kfloat | kdbl, kfloat ^ kdbl from expr_test order by id"""
	qt_sql_test_Float_Double_notn_3 """
		select id, kfloat & kdbl, kfloat | kdbl, kfloat ^ kdbl from expr_test_not_nullable order by id"""
	qt_sql_test_Float_Double_4 """
		select id, BITAND(kfloat, kdbl), BITOR(kfloat, kdbl), BITXOR(kfloat, kdbl) from expr_test order by id"""
	qt_sql_test_Float_Double_notn_4 """
		select id, BITAND(kfloat, kdbl), BITOR(kfloat, kdbl), BITXOR(kfloat, kdbl) from expr_test_not_nullable order by id"""
	qt_sql_test_Float_DecimalV2_0 """
		select id, kfloat + kdcml, kfloat - kdcml from expr_test order by id"""
	qt_sql_test_Float_DecimalV2_notn_0 """
		select id, kfloat + kdcml, kfloat - kdcml from expr_test_not_nullable order by id"""
	qt_sql_test_Float_DecimalV2_1 """
		select id, kfloat * kdcml, kfloat / kdcml, kfloat % kdcml from expr_test order by id"""
	qt_sql_test_Float_DecimalV2_notn_1 """
		select id, kfloat * kdcml, kfloat / kdcml, kfloat % kdcml from expr_test_not_nullable order by id"""
	qt_sql_test_Float_DecimalV2_2 """
		select id, kfloat DIV kdcml from expr_test order by id"""
	qt_sql_test_Float_DecimalV2_notn_2 """
		select id, kfloat DIV kdcml from expr_test_not_nullable order by id"""
	qt_sql_test_Float_DecimalV2_3 """
		select id, kfloat & kdcml, kfloat | kdcml, kfloat ^ kdcml from expr_test order by id"""
	qt_sql_test_Float_DecimalV2_notn_3 """
		select id, kfloat & kdcml, kfloat | kdcml, kfloat ^ kdcml from expr_test_not_nullable order by id"""
	// qt_sql_test_Float_DecimalV2_4 """
	// 	select id, BITAND(kfloat, kdcml), BITOR(kfloat, kdcml), BITXOR(kfloat, kdcml) from expr_test order by id"""
	// qt_sql_test_Float_DecimalV2_notn_4 """
	// 	select id, BITAND(kfloat, kdcml), BITOR(kfloat, kdcml), BITXOR(kfloat, kdcml) from expr_test_not_nullable order by id"""
	qt_sql_test_Float_Decimal32V3_0 """
		select id, kfloat + kdcml32v3, kfloat - kdcml32v3 from expr_test order by id"""
	qt_sql_test_Float_Decimal32V3_notn_0 """
		select id, kfloat + kdcml32v3, kfloat - kdcml32v3 from expr_test_not_nullable order by id"""
	// qt_sql_test_Float_Decimal32V3_1 """
	// 	select id, kfloat * kdcml32v3, kfloat / kdcml32v3, kfloat % kdcml32v3 from expr_test order by id"""
	// qt_sql_test_Float_Decimal32V3_notn_1 """
	// 	select id, kfloat * kdcml32v3, kfloat / kdcml32v3, kfloat % kdcml32v3 from expr_test_not_nullable order by id"""
	qt_sql_test_Float_Decimal32V3_2 """
		select id, kfloat DIV kdcml32v3 from expr_test order by id"""
	qt_sql_test_Float_Decimal32V3_notn_2 """
		select id, kfloat DIV kdcml32v3 from expr_test_not_nullable order by id"""
	qt_sql_test_Float_Decimal32V3_3 """
		select id, kfloat & kdcml32v3, kfloat | kdcml32v3, kfloat ^ kdcml32v3 from expr_test order by id"""
	qt_sql_test_Float_Decimal32V3_notn_3 """
		select id, kfloat & kdcml32v3, kfloat | kdcml32v3, kfloat ^ kdcml32v3 from expr_test_not_nullable order by id"""
	// qt_sql_test_Float_Decimal32V3_4 """
	// 	select id, BITAND(kfloat, kdcml32v3), BITOR(kfloat, kdcml32v3), BITXOR(kfloat, kdcml32v3) from expr_test order by id"""
	// qt_sql_test_Float_Decimal32V3_notn_4 """
	// 	select id, BITAND(kfloat, kdcml32v3), BITOR(kfloat, kdcml32v3), BITXOR(kfloat, kdcml32v3) from expr_test_not_nullable order by id"""
	qt_sql_test_Float_Decimal64V3_0 """
		select id, kfloat + kdcml64v3, kfloat - kdcml64v3 from expr_test order by id"""
	qt_sql_test_Float_Decimal64V3_notn_0 """
		select id, kfloat + kdcml64v3, kfloat - kdcml64v3 from expr_test_not_nullable order by id"""
	// qt_sql_test_Float_Decimal64V3_1 """
	// 	select id, kfloat * kdcml64v3, kfloat / kdcml64v3, kfloat % kdcml64v3 from expr_test order by id"""
	// qt_sql_test_Float_Decimal64V3_notn_1 """
	// 	select id, kfloat * kdcml64v3, kfloat / kdcml64v3, kfloat % kdcml64v3 from expr_test_not_nullable order by id"""
	qt_sql_test_Float_Decimal64V3_2 """
		select id, kfloat DIV kdcml64v3 from expr_test order by id"""
	qt_sql_test_Float_Decimal64V3_notn_2 """
		select id, kfloat DIV kdcml64v3 from expr_test_not_nullable order by id"""
	qt_sql_test_Float_Decimal64V3_3 """
		select id, kfloat & kdcml64v3, kfloat | kdcml64v3, kfloat ^ kdcml64v3 from expr_test order by id"""
	qt_sql_test_Float_Decimal64V3_notn_3 """
		select id, kfloat & kdcml64v3, kfloat | kdcml64v3, kfloat ^ kdcml64v3 from expr_test_not_nullable order by id"""
	// qt_sql_test_Float_Decimal64V3_4 """
	// 	select id, BITAND(kfloat, kdcml64v3), BITOR(kfloat, kdcml64v3), BITXOR(kfloat, kdcml64v3) from expr_test order by id"""
	// qt_sql_test_Float_Decimal64V3_notn_4 """
	// 	select id, BITAND(kfloat, kdcml64v3), BITOR(kfloat, kdcml64v3), BITXOR(kfloat, kdcml64v3) from expr_test_not_nullable order by id"""
	qt_sql_test_Float_Decimal128V3_0 """
		select id, kfloat + kdcml128v3, kfloat - kdcml128v3 from expr_test order by id"""
	qt_sql_test_Float_Decimal128V3_notn_0 """
		select id, kfloat + kdcml128v3, kfloat - kdcml128v3 from expr_test_not_nullable order by id"""
	// qt_sql_test_Float_Decimal128V3_1 """
	// 	select id, kfloat * kdcml128v3, kfloat / kdcml128v3, kfloat % kdcml128v3 from expr_test order by id"""
	// qt_sql_test_Float_Decimal128V3_notn_1 """
	// 	select id, kfloat * kdcml128v3, kfloat / kdcml128v3, kfloat % kdcml128v3 from expr_test_not_nullable order by id"""
	qt_sql_test_Float_Decimal128V3_2 """
		select id, kfloat DIV kdcml128v3 from expr_test order by id"""
	qt_sql_test_Float_Decimal128V3_notn_2 """
		select id, kfloat DIV kdcml128v3 from expr_test_not_nullable order by id"""
	qt_sql_test_Float_Decimal128V3_3 """
		select id, kfloat & kdcml128v3, kfloat | kdcml128v3, kfloat ^ kdcml128v3 from expr_test order by id"""
	qt_sql_test_Float_Decimal128V3_notn_3 """
		select id, kfloat & kdcml128v3, kfloat | kdcml128v3, kfloat ^ kdcml128v3 from expr_test_not_nullable order by id"""
	// qt_sql_test_Float_Decimal128V3_4 """
	// 	select id, BITAND(kfloat, kdcml128v3), BITOR(kfloat, kdcml128v3), BITXOR(kfloat, kdcml128v3) from expr_test order by id"""
	// qt_sql_test_Float_Decimal128V3_notn_4 """
	// 	select id, BITAND(kfloat, kdcml128v3), BITOR(kfloat, kdcml128v3), BITXOR(kfloat, kdcml128v3) from expr_test_not_nullable order by id"""
	qt_sql_test_Float_Char_0 """
		select id, kfloat + kchr, kfloat - kchr from expr_test order by id"""
	qt_sql_test_Float_Char_notn_0 """
		select id, kfloat + kchr, kfloat - kchr from expr_test_not_nullable order by id"""
	qt_sql_test_Float_Char_1 """
		select id, kfloat * kchr, kfloat / kchr, kfloat % kchr from expr_test order by id"""
	qt_sql_test_Float_Char_notn_1 """
		select id, kfloat * kchr, kfloat / kchr, kfloat % kchr from expr_test_not_nullable order by id"""
	qt_sql_test_Float_Char_2 """
		select id, kfloat DIV kchr from expr_test order by id"""
	qt_sql_test_Float_Char_notn_2 """
		select id, kfloat DIV kchr from expr_test_not_nullable order by id"""
	qt_sql_test_Float_Char_3 """
		select id, kfloat & kchr, kfloat | kchr, kfloat ^ kchr from expr_test order by id"""
	qt_sql_test_Float_Char_notn_3 """
		select id, kfloat & kchr, kfloat | kchr, kfloat ^ kchr from expr_test_not_nullable order by id"""
	// qt_sql_test_Float_Char_4 """
	// 	select id, BITAND(kfloat, kchr), BITOR(kfloat, kchr), BITXOR(kfloat, kchr) from expr_test order by id"""
	// qt_sql_test_Float_Char_notn_4 """
	// 	select id, BITAND(kfloat, kchr), BITOR(kfloat, kchr), BITXOR(kfloat, kchr) from expr_test_not_nullable order by id"""
	qt_sql_test_Float_Varchar_0 """
		select id, kfloat + kvchr, kfloat - kvchr from expr_test order by id"""
	qt_sql_test_Float_Varchar_notn_0 """
		select id, kfloat + kvchr, kfloat - kvchr from expr_test_not_nullable order by id"""
	qt_sql_test_Float_Varchar_1 """
		select id, kfloat * kvchr, kfloat / kvchr, kfloat % kvchr from expr_test order by id"""
	qt_sql_test_Float_Varchar_notn_1 """
		select id, kfloat * kvchr, kfloat / kvchr, kfloat % kvchr from expr_test_not_nullable order by id"""
	qt_sql_test_Float_Varchar_2 """
		select id, kfloat DIV kvchr from expr_test order by id"""
	qt_sql_test_Float_Varchar_notn_2 """
		select id, kfloat DIV kvchr from expr_test_not_nullable order by id"""
	qt_sql_test_Float_Varchar_3 """
		select id, kfloat & kvchr, kfloat | kvchr, kfloat ^ kvchr from expr_test order by id"""
	qt_sql_test_Float_Varchar_notn_3 """
		select id, kfloat & kvchr, kfloat | kvchr, kfloat ^ kvchr from expr_test_not_nullable order by id"""
	// qt_sql_test_Float_Varchar_4 """
	// 	select id, BITAND(kfloat, kvchr), BITOR(kfloat, kvchr), BITXOR(kfloat, kvchr) from expr_test order by id"""
	// qt_sql_test_Float_Varchar_notn_4 """
	// 	select id, BITAND(kfloat, kvchr), BITOR(kfloat, kvchr), BITXOR(kfloat, kvchr) from expr_test_not_nullable order by id"""
	qt_sql_test_Float_String_0 """
		select id, kfloat + kstr, kfloat - kstr from expr_test order by id"""
	qt_sql_test_Float_String_notn_0 """
		select id, kfloat + kstr, kfloat - kstr from expr_test_not_nullable order by id"""
	qt_sql_test_Float_String_1 """
		select id, kfloat * kstr, kfloat / kstr, kfloat % kstr from expr_test order by id"""
	qt_sql_test_Float_String_notn_1 """
		select id, kfloat * kstr, kfloat / kstr, kfloat % kstr from expr_test_not_nullable order by id"""
	qt_sql_test_Float_String_2 """
		select id, kfloat DIV kstr from expr_test order by id"""
	qt_sql_test_Float_String_notn_2 """
		select id, kfloat DIV kstr from expr_test_not_nullable order by id"""
	qt_sql_test_Float_String_3 """
		select id, kfloat & kstr, kfloat | kstr, kfloat ^ kstr from expr_test order by id"""
	qt_sql_test_Float_String_notn_3 """
		select id, kfloat & kstr, kfloat | kstr, kfloat ^ kstr from expr_test_not_nullable order by id"""
	// qt_sql_test_Float_String_4 """
	// 	select id, BITAND(kfloat, kstr), BITOR(kfloat, kstr), BITXOR(kfloat, kstr) from expr_test order by id"""
	// qt_sql_test_Float_String_notn_4 """
	// 	select id, BITAND(kfloat, kstr), BITOR(kfloat, kstr), BITXOR(kfloat, kstr) from expr_test_not_nullable order by id"""
	qt_sql_test_Float_Date_0 """
		select id, kfloat + kdt, kfloat - kdt from expr_test order by id"""
	qt_sql_test_Float_Date_notn_0 """
		select id, kfloat + kdt, kfloat - kdt from expr_test_not_nullable order by id"""
	// qt_sql_test_Float_Date_1 """
	// 	select id, kfloat * kdt, kfloat / kdt, kfloat % kdt from expr_test order by id"""
	// qt_sql_test_Float_Date_notn_1 """
	// 	select id, kfloat * kdt, kfloat / kdt, kfloat % kdt from expr_test_not_nullable order by id"""
	qt_sql_test_Float_Date_2 """
		select id, kfloat DIV kdt from expr_test order by id"""
	qt_sql_test_Float_Date_notn_2 """
		select id, kfloat DIV kdt from expr_test_not_nullable order by id"""
	qt_sql_test_Float_Date_3 """
		select id, kfloat & kdt, kfloat | kdt, kfloat ^ kdt from expr_test order by id"""
	qt_sql_test_Float_Date_notn_3 """
		select id, kfloat & kdt, kfloat | kdt, kfloat ^ kdt from expr_test_not_nullable order by id"""
	// qt_sql_test_Float_Date_4 """
	// 	select id, BITAND(kfloat, kdt), BITOR(kfloat, kdt), BITXOR(kfloat, kdt) from expr_test order by id"""
	// qt_sql_test_Float_Date_notn_4 """
	// 	select id, BITAND(kfloat, kdt), BITOR(kfloat, kdt), BITXOR(kfloat, kdt) from expr_test_not_nullable order by id"""
	qt_sql_test_Float_DateTime_0 """
		select id, kfloat + kdtm, kfloat - kdtm from expr_test order by id"""
	qt_sql_test_Float_DateTime_notn_0 """
		select id, kfloat + kdtm, kfloat - kdtm from expr_test_not_nullable order by id"""
	// qt_sql_test_Float_DateTime_1 """
	// 	select id, kfloat * kdtm, kfloat / kdtm, kfloat % kdtm from expr_test order by id"""
	// qt_sql_test_Float_DateTime_notn_1 """
	// 	select id, kfloat * kdtm, kfloat / kdtm, kfloat % kdtm from expr_test_not_nullable order by id"""
	qt_sql_test_Float_DateTime_2 """
		select id, kfloat DIV kdtm from expr_test order by id"""
	qt_sql_test_Float_DateTime_notn_2 """
		select id, kfloat DIV kdtm from expr_test_not_nullable order by id"""
	qt_sql_test_Float_DateTime_3 """
		select id, kfloat & kdtm, kfloat | kdtm, kfloat ^ kdtm from expr_test order by id"""
	qt_sql_test_Float_DateTime_notn_3 """
		select id, kfloat & kdtm, kfloat | kdtm, kfloat ^ kdtm from expr_test_not_nullable order by id"""
	// qt_sql_test_Float_DateTime_4 """
	// 	select id, BITAND(kfloat, kdtm), BITOR(kfloat, kdtm), BITXOR(kfloat, kdtm) from expr_test order by id"""
	// qt_sql_test_Float_DateTime_notn_4 """
	// 	select id, BITAND(kfloat, kdtm), BITOR(kfloat, kdtm), BITXOR(kfloat, kdtm) from expr_test_not_nullable order by id"""
	qt_sql_test_Float_DateV2_0 """
		select id, kfloat + kdtv2, kfloat - kdtv2 from expr_test order by id"""
	qt_sql_test_Float_DateV2_notn_0 """
		select id, kfloat + kdtv2, kfloat - kdtv2 from expr_test_not_nullable order by id"""
	// qt_sql_test_Float_DateV2_1 """
	// 	select id, kfloat * kdtv2, kfloat / kdtv2, kfloat % kdtv2 from expr_test order by id"""
	// qt_sql_test_Float_DateV2_notn_1 """
	// 	select id, kfloat * kdtv2, kfloat / kdtv2, kfloat % kdtv2 from expr_test_not_nullable order by id"""
	qt_sql_test_Float_DateV2_2 """
		select id, kfloat DIV kdtv2 from expr_test order by id"""
	qt_sql_test_Float_DateV2_notn_2 """
		select id, kfloat DIV kdtv2 from expr_test_not_nullable order by id"""
	qt_sql_test_Float_DateV2_3 """
		select id, kfloat & kdtv2, kfloat | kdtv2, kfloat ^ kdtv2 from expr_test order by id"""
	qt_sql_test_Float_DateV2_notn_3 """
		select id, kfloat & kdtv2, kfloat | kdtv2, kfloat ^ kdtv2 from expr_test_not_nullable order by id"""
	// qt_sql_test_Float_DateV2_4 """
	// 	select id, BITAND(kfloat, kdtv2), BITOR(kfloat, kdtv2), BITXOR(kfloat, kdtv2) from expr_test order by id"""
	// qt_sql_test_Float_DateV2_notn_4 """
	// 	select id, BITAND(kfloat, kdtv2), BITOR(kfloat, kdtv2), BITXOR(kfloat, kdtv2) from expr_test_not_nullable order by id"""
	qt_sql_test_Float_DateTimeV2_0 """
		select id, kfloat + kdtmv2, kfloat - kdtmv2 from expr_test order by id"""
	qt_sql_test_Float_DateTimeV2_notn_0 """
		select id, kfloat + kdtmv2, kfloat - kdtmv2 from expr_test_not_nullable order by id"""
	// qt_sql_test_Float_DateTimeV2_1 """
	// 	select id, kfloat * kdtmv2, kfloat / kdtmv2, kfloat % kdtmv2 from expr_test order by id"""
	// qt_sql_test_Float_DateTimeV2_notn_1 """
	// 	select id, kfloat * kdtmv2, kfloat / kdtmv2, kfloat % kdtmv2 from expr_test_not_nullable order by id"""
	qt_sql_test_Float_DateTimeV2_2 """
		select id, kfloat DIV kdtmv2 from expr_test order by id"""
	qt_sql_test_Float_DateTimeV2_notn_2 """
		select id, kfloat DIV kdtmv2 from expr_test_not_nullable order by id"""
	qt_sql_test_Float_DateTimeV2_3 """
		select id, kfloat & kdtmv2, kfloat | kdtmv2, kfloat ^ kdtmv2 from expr_test order by id"""
	qt_sql_test_Float_DateTimeV2_notn_3 """
		select id, kfloat & kdtmv2, kfloat | kdtmv2, kfloat ^ kdtmv2 from expr_test_not_nullable order by id"""
	// qt_sql_test_Float_DateTimeV2_4 """
	// 	select id, BITAND(kfloat, kdtmv2), BITOR(kfloat, kdtmv2), BITXOR(kfloat, kdtmv2) from expr_test order by id"""
	// qt_sql_test_Float_DateTimeV2_notn_4 """
	// 	select id, BITAND(kfloat, kdtmv2), BITOR(kfloat, kdtmv2), BITXOR(kfloat, kdtmv2) from expr_test_not_nullable order by id"""
	qt_sql_test_Float_Boolean_0 """
		select id, kfloat + kbool, kfloat - kbool from expr_test order by id"""
	qt_sql_test_Float_Boolean_notn_0 """
		select id, kfloat + kbool, kfloat - kbool from expr_test_not_nullable order by id"""
	// qt_sql_test_Float_Boolean_1 """
	// 	select id, kfloat * kbool, kfloat / kbool, kfloat % kbool from expr_test order by id"""
	// qt_sql_test_Float_Boolean_notn_1 """
	// 	select id, kfloat * kbool, kfloat / kbool, kfloat % kbool from expr_test_not_nullable order by id"""
	qt_sql_test_Float_Boolean_2 """
		select id, kfloat DIV kbool from expr_test order by id"""
	qt_sql_test_Float_Boolean_notn_2 """
		select id, kfloat DIV kbool from expr_test_not_nullable order by id"""
	qt_sql_test_Float_Boolean_3 """
		select id, kfloat & kbool, kfloat | kbool, kfloat ^ kbool from expr_test order by id"""
	qt_sql_test_Float_Boolean_notn_3 """
		select id, kfloat & kbool, kfloat | kbool, kfloat ^ kbool from expr_test_not_nullable order by id"""
	// qt_sql_test_Float_Boolean_4 """
	// 	select id, BITAND(kfloat, kbool), BITOR(kfloat, kbool), BITXOR(kfloat, kbool) from expr_test order by id"""
	// qt_sql_test_Float_Boolean_notn_4 """
	// 	select id, BITAND(kfloat, kbool), BITOR(kfloat, kbool), BITXOR(kfloat, kbool) from expr_test_not_nullable order by id"""
	qt_sql_test_Double_TinyInt_0 """
		select id, kdbl + ktint, kdbl - ktint from expr_test order by id"""
	qt_sql_test_Double_TinyInt_notn_0 """
		select id, kdbl + ktint, kdbl - ktint from expr_test_not_nullable order by id"""
	qt_sql_test_Double_TinyInt_1 """
		select id, kdbl * ktint, kdbl / ktint, kdbl % ktint from expr_test order by id"""
	qt_sql_test_Double_TinyInt_notn_1 """
		select id, kdbl * ktint, kdbl / ktint, kdbl % ktint from expr_test_not_nullable order by id"""
	qt_sql_test_Double_TinyInt_2 """
		select id, kdbl DIV ktint from expr_test order by id"""
	qt_sql_test_Double_TinyInt_notn_2 """
		select id, kdbl DIV ktint from expr_test_not_nullable order by id"""
	qt_sql_test_Double_TinyInt_3 """
		select id, kdbl & ktint, kdbl | ktint, kdbl ^ ktint from expr_test order by id"""
	qt_sql_test_Double_TinyInt_notn_3 """
		select id, kdbl & ktint, kdbl | ktint, kdbl ^ ktint from expr_test_not_nullable order by id"""
	qt_sql_test_Double_TinyInt_4 """
		select id, BITAND(kdbl, ktint), BITOR(kdbl, ktint), BITXOR(kdbl, ktint) from expr_test order by id"""
	qt_sql_test_Double_TinyInt_notn_4 """
		select id, BITAND(kdbl, ktint), BITOR(kdbl, ktint), BITXOR(kdbl, ktint) from expr_test_not_nullable order by id"""
	qt_sql_test_Double_SmallInt_0 """
		select id, kdbl + ksint, kdbl - ksint from expr_test order by id"""
	qt_sql_test_Double_SmallInt_notn_0 """
		select id, kdbl + ksint, kdbl - ksint from expr_test_not_nullable order by id"""
	qt_sql_test_Double_SmallInt_1 """
		select id, kdbl * ksint, kdbl / ksint, kdbl % ksint from expr_test order by id"""
	qt_sql_test_Double_SmallInt_notn_1 """
		select id, kdbl * ksint, kdbl / ksint, kdbl % ksint from expr_test_not_nullable order by id"""
	qt_sql_test_Double_SmallInt_2 """
		select id, kdbl DIV ksint from expr_test order by id"""
	qt_sql_test_Double_SmallInt_notn_2 """
		select id, kdbl DIV ksint from expr_test_not_nullable order by id"""
	qt_sql_test_Double_SmallInt_3 """
		select id, kdbl & ksint, kdbl | ksint, kdbl ^ ksint from expr_test order by id"""
	qt_sql_test_Double_SmallInt_notn_3 """
		select id, kdbl & ksint, kdbl | ksint, kdbl ^ ksint from expr_test_not_nullable order by id"""
	// qt_sql_test_Double_SmallInt_4 """
	// 	select id, BITAND(kdbl, ksint), BITOR(kdbl, ksint), BITXOR(kdbl, ksint) from expr_test order by id"""
	// qt_sql_test_Double_SmallInt_notn_4 """
	// 	select id, BITAND(kdbl, ksint), BITOR(kdbl, ksint), BITXOR(kdbl, ksint) from expr_test_not_nullable order by id"""
	qt_sql_test_Double_Integer_0 """
		select id, kdbl + kint, kdbl - kint from expr_test order by id"""
	qt_sql_test_Double_Integer_notn_0 """
		select id, kdbl + kint, kdbl - kint from expr_test_not_nullable order by id"""
	qt_sql_test_Double_Integer_1 """
		select id, kdbl * kint, kdbl / kint, kdbl % kint from expr_test order by id"""
	qt_sql_test_Double_Integer_notn_1 """
		select id, kdbl * kint, kdbl / kint, kdbl % kint from expr_test_not_nullable order by id"""
	qt_sql_test_Double_Integer_2 """
		select id, kdbl DIV kint from expr_test order by id"""
	qt_sql_test_Double_Integer_notn_2 """
		select id, kdbl DIV kint from expr_test_not_nullable order by id"""
	qt_sql_test_Double_Integer_3 """
		select id, kdbl & kint, kdbl | kint, kdbl ^ kint from expr_test order by id"""
	qt_sql_test_Double_Integer_notn_3 """
		select id, kdbl & kint, kdbl | kint, kdbl ^ kint from expr_test_not_nullable order by id"""
	// qt_sql_test_Double_Integer_4 """
	// 	select id, BITAND(kdbl, kint), BITOR(kdbl, kint), BITXOR(kdbl, kint) from expr_test order by id"""
	// qt_sql_test_Double_Integer_notn_4 """
	// 	select id, BITAND(kdbl, kint), BITOR(kdbl, kint), BITXOR(kdbl, kint) from expr_test_not_nullable order by id"""
	qt_sql_test_Double_BigInt_0 """
		select id, kdbl + kbint, kdbl - kbint from expr_test order by id"""
	qt_sql_test_Double_BigInt_notn_0 """
		select id, kdbl + kbint, kdbl - kbint from expr_test_not_nullable order by id"""
	qt_sql_test_Double_BigInt_1 """
		select id, kdbl * kbint, kdbl / kbint, kdbl % kbint from expr_test order by id"""
	qt_sql_test_Double_BigInt_notn_1 """
		select id, kdbl * kbint, kdbl / kbint, kdbl % kbint from expr_test_not_nullable order by id"""
	qt_sql_test_Double_BigInt_2 """
		select id, kdbl DIV kbint from expr_test order by id"""
	qt_sql_test_Double_BigInt_notn_2 """
		select id, kdbl DIV kbint from expr_test_not_nullable order by id"""
	qt_sql_test_Double_BigInt_3 """
		select id, kdbl & kbint, kdbl | kbint, kdbl ^ kbint from expr_test order by id"""
	qt_sql_test_Double_BigInt_notn_3 """
		select id, kdbl & kbint, kdbl | kbint, kdbl ^ kbint from expr_test_not_nullable order by id"""
	// qt_sql_test_Double_BigInt_4 """
	// 	select id, BITAND(kdbl, kbint), BITOR(kdbl, kbint), BITXOR(kdbl, kbint) from expr_test order by id"""
	// qt_sql_test_Double_BigInt_notn_4 """
	// 	select id, BITAND(kdbl, kbint), BITOR(kdbl, kbint), BITXOR(kdbl, kbint) from expr_test_not_nullable order by id"""
	qt_sql_test_Double_LargeInt_0 """
		select id, kdbl + klint, kdbl - klint from expr_test order by id"""
	qt_sql_test_Double_LargeInt_notn_0 """
		select id, kdbl + klint, kdbl - klint from expr_test_not_nullable order by id"""
	qt_sql_test_Double_LargeInt_1 """
		select id, kdbl * klint, kdbl / klint, kdbl % klint from expr_test order by id"""
	qt_sql_test_Double_LargeInt_notn_1 """
		select id, kdbl * klint, kdbl / klint, kdbl % klint from expr_test_not_nullable order by id"""
	qt_sql_test_Double_LargeInt_2 """
		select id, kdbl DIV klint from expr_test order by id"""
	qt_sql_test_Double_LargeInt_notn_2 """
		select id, kdbl DIV klint from expr_test_not_nullable order by id"""
	qt_sql_test_Double_LargeInt_3 """
		select id, kdbl & klint, kdbl | klint, kdbl ^ klint from expr_test order by id"""
	qt_sql_test_Double_LargeInt_notn_3 """
		select id, kdbl & klint, kdbl | klint, kdbl ^ klint from expr_test_not_nullable order by id"""
	// qt_sql_test_Double_LargeInt_4 """
	// 	select id, BITAND(kdbl, klint), BITOR(kdbl, klint), BITXOR(kdbl, klint) from expr_test order by id"""
	// qt_sql_test_Double_LargeInt_notn_4 """
	// 	select id, BITAND(kdbl, klint), BITOR(kdbl, klint), BITXOR(kdbl, klint) from expr_test_not_nullable order by id"""
	qt_sql_test_Double_Float_0 """
		select id, kdbl + kfloat, kdbl - kfloat from expr_test order by id"""
	qt_sql_test_Double_Float_notn_0 """
		select id, kdbl + kfloat, kdbl - kfloat from expr_test_not_nullable order by id"""
	qt_sql_test_Double_Float_1 """
		select id, kdbl * kfloat, kdbl / kfloat, kdbl % kfloat from expr_test order by id"""
	qt_sql_test_Double_Float_notn_1 """
		select id, kdbl * kfloat, kdbl / kfloat, kdbl % kfloat from expr_test_not_nullable order by id"""
	qt_sql_test_Double_Float_2 """
		select id, kdbl DIV kfloat from expr_test order by id"""
	qt_sql_test_Double_Float_notn_2 """
		select id, kdbl DIV kfloat from expr_test_not_nullable order by id"""
	qt_sql_test_Double_Float_3 """
		select id, kdbl & kfloat, kdbl | kfloat, kdbl ^ kfloat from expr_test order by id"""
	qt_sql_test_Double_Float_notn_3 """
		select id, kdbl & kfloat, kdbl | kfloat, kdbl ^ kfloat from expr_test_not_nullable order by id"""
	qt_sql_test_Double_Float_4 """
		select id, BITAND(kdbl, kfloat), BITOR(kdbl, kfloat), BITXOR(kdbl, kfloat) from expr_test order by id"""
	qt_sql_test_Double_Float_notn_4 """
		select id, BITAND(kdbl, kfloat), BITOR(kdbl, kfloat), BITXOR(kdbl, kfloat) from expr_test_not_nullable order by id"""
	qt_sql_test_Double_Double_0 """
		select id, kdbl + kdbl, kdbl - kdbl from expr_test order by id"""
	qt_sql_test_Double_Double_notn_0 """
		select id, kdbl + kdbl, kdbl - kdbl from expr_test_not_nullable order by id"""
	qt_sql_test_Double_Double_1 """
		select id, kdbl * kdbl, kdbl / kdbl, kdbl % kdbl from expr_test order by id"""
	qt_sql_test_Double_Double_notn_1 """
		select id, kdbl * kdbl, kdbl / kdbl, kdbl % kdbl from expr_test_not_nullable order by id"""
	qt_sql_test_Double_Double_2 """
		select id, kdbl DIV kdbl from expr_test order by id"""
	qt_sql_test_Double_Double_notn_2 """
		select id, kdbl DIV kdbl from expr_test_not_nullable order by id"""
	qt_sql_test_Double_Double_3 """
		select id, kdbl & kdbl, kdbl | kdbl, kdbl ^ kdbl from expr_test order by id"""
	qt_sql_test_Double_Double_notn_3 """
		select id, kdbl & kdbl, kdbl | kdbl, kdbl ^ kdbl from expr_test_not_nullable order by id"""
	qt_sql_test_Double_Double_4 """
		select id, BITAND(kdbl, kdbl), BITOR(kdbl, kdbl), BITXOR(kdbl, kdbl) from expr_test order by id"""
	qt_sql_test_Double_Double_notn_4 """
		select id, BITAND(kdbl, kdbl), BITOR(kdbl, kdbl), BITXOR(kdbl, kdbl) from expr_test_not_nullable order by id"""
	qt_sql_test_Double_DecimalV2_0 """
		select id, kdbl + kdcml, kdbl - kdcml from expr_test order by id"""
	qt_sql_test_Double_DecimalV2_notn_0 """
		select id, kdbl + kdcml, kdbl - kdcml from expr_test_not_nullable order by id"""
	qt_sql_test_Double_DecimalV2_1 """
		select id, kdbl * kdcml, kdbl / kdcml, kdbl % kdcml from expr_test order by id"""
	qt_sql_test_Double_DecimalV2_notn_1 """
		select id, kdbl * kdcml, kdbl / kdcml, kdbl % kdcml from expr_test_not_nullable order by id"""
	qt_sql_test_Double_DecimalV2_2 """
		select id, kdbl DIV kdcml from expr_test order by id"""
	qt_sql_test_Double_DecimalV2_notn_2 """
		select id, kdbl DIV kdcml from expr_test_not_nullable order by id"""
	qt_sql_test_Double_DecimalV2_3 """
		select id, kdbl & kdcml, kdbl | kdcml, kdbl ^ kdcml from expr_test order by id"""
	qt_sql_test_Double_DecimalV2_notn_3 """
		select id, kdbl & kdcml, kdbl | kdcml, kdbl ^ kdcml from expr_test_not_nullable order by id"""
	// qt_sql_test_Double_DecimalV2_4 """
	// 	select id, BITAND(kdbl, kdcml), BITOR(kdbl, kdcml), BITXOR(kdbl, kdcml) from expr_test order by id"""
	// qt_sql_test_Double_DecimalV2_notn_4 """
	// 	select id, BITAND(kdbl, kdcml), BITOR(kdbl, kdcml), BITXOR(kdbl, kdcml) from expr_test_not_nullable order by id"""
	qt_sql_test_Double_Decimal32V3_0 """
		select id, kdbl + kdcml32v3, kdbl - kdcml32v3 from expr_test order by id"""
	qt_sql_test_Double_Decimal32V3_notn_0 """
		select id, kdbl + kdcml32v3, kdbl - kdcml32v3 from expr_test_not_nullable order by id"""
	qt_sql_test_Double_Decimal32V3_1 """
		select id, kdbl * kdcml32v3, kdbl / kdcml32v3, kdbl % kdcml32v3 from expr_test order by id"""
	qt_sql_test_Double_Decimal32V3_notn_1 """
		select id, kdbl * kdcml32v3, kdbl / kdcml32v3, kdbl % kdcml32v3 from expr_test_not_nullable order by id"""
	qt_sql_test_Double_Decimal32V3_2 """
		select id, kdbl DIV kdcml32v3 from expr_test order by id"""
	qt_sql_test_Double_Decimal32V3_notn_2 """
		select id, kdbl DIV kdcml32v3 from expr_test_not_nullable order by id"""
	qt_sql_test_Double_Decimal32V3_3 """
		select id, kdbl & kdcml32v3, kdbl | kdcml32v3, kdbl ^ kdcml32v3 from expr_test order by id"""
	qt_sql_test_Double_Decimal32V3_notn_3 """
		select id, kdbl & kdcml32v3, kdbl | kdcml32v3, kdbl ^ kdcml32v3 from expr_test_not_nullable order by id"""
	// qt_sql_test_Double_Decimal32V3_4 """
	// 	select id, BITAND(kdbl, kdcml32v3), BITOR(kdbl, kdcml32v3), BITXOR(kdbl, kdcml32v3) from expr_test order by id"""
	// qt_sql_test_Double_Decimal32V3_notn_4 """
	// 	select id, BITAND(kdbl, kdcml32v3), BITOR(kdbl, kdcml32v3), BITXOR(kdbl, kdcml32v3) from expr_test_not_nullable order by id"""
	qt_sql_test_Double_Decimal64V3_0 """
		select id, kdbl + kdcml64v3, kdbl - kdcml64v3 from expr_test order by id"""
	qt_sql_test_Double_Decimal64V3_notn_0 """
		select id, kdbl + kdcml64v3, kdbl - kdcml64v3 from expr_test_not_nullable order by id"""
	qt_sql_test_Double_Decimal64V3_1 """
		select id, kdbl * kdcml64v3, kdbl / kdcml64v3, kdbl % kdcml64v3 from expr_test order by id"""
	qt_sql_test_Double_Decimal64V3_notn_1 """
		select id, kdbl * kdcml64v3, kdbl / kdcml64v3, kdbl % kdcml64v3 from expr_test_not_nullable order by id"""
	qt_sql_test_Double_Decimal64V3_2 """
		select id, kdbl DIV kdcml64v3 from expr_test order by id"""
	qt_sql_test_Double_Decimal64V3_notn_2 """
		select id, kdbl DIV kdcml64v3 from expr_test_not_nullable order by id"""
	qt_sql_test_Double_Decimal64V3_3 """
		select id, kdbl & kdcml64v3, kdbl | kdcml64v3, kdbl ^ kdcml64v3 from expr_test order by id"""
	qt_sql_test_Double_Decimal64V3_notn_3 """
		select id, kdbl & kdcml64v3, kdbl | kdcml64v3, kdbl ^ kdcml64v3 from expr_test_not_nullable order by id"""
	// qt_sql_test_Double_Decimal64V3_4 """
	// 	select id, BITAND(kdbl, kdcml64v3), BITOR(kdbl, kdcml64v3), BITXOR(kdbl, kdcml64v3) from expr_test order by id"""
	// qt_sql_test_Double_Decimal64V3_notn_4 """
	// 	select id, BITAND(kdbl, kdcml64v3), BITOR(kdbl, kdcml64v3), BITXOR(kdbl, kdcml64v3) from expr_test_not_nullable order by id"""
	qt_sql_test_Double_Decimal128V3_0 """
		select id, kdbl + kdcml128v3, kdbl - kdcml128v3 from expr_test order by id"""
	qt_sql_test_Double_Decimal128V3_notn_0 """
		select id, kdbl + kdcml128v3, kdbl - kdcml128v3 from expr_test_not_nullable order by id"""
	qt_sql_test_Double_Decimal128V3_1 """
		select id, kdbl * kdcml128v3, kdbl / kdcml128v3, kdbl % kdcml128v3 from expr_test order by id"""
	qt_sql_test_Double_Decimal128V3_notn_1 """
		select id, kdbl * kdcml128v3, kdbl / kdcml128v3, kdbl % kdcml128v3 from expr_test_not_nullable order by id"""
	qt_sql_test_Double_Decimal128V3_2 """
		select id, kdbl DIV kdcml128v3 from expr_test order by id"""
	qt_sql_test_Double_Decimal128V3_notn_2 """
		select id, kdbl DIV kdcml128v3 from expr_test_not_nullable order by id"""
	qt_sql_test_Double_Decimal128V3_3 """
		select id, kdbl & kdcml128v3, kdbl | kdcml128v3, kdbl ^ kdcml128v3 from expr_test order by id"""
	qt_sql_test_Double_Decimal128V3_notn_3 """
		select id, kdbl & kdcml128v3, kdbl | kdcml128v3, kdbl ^ kdcml128v3 from expr_test_not_nullable order by id"""
	// qt_sql_test_Double_Decimal128V3_4 """
	// 	select id, BITAND(kdbl, kdcml128v3), BITOR(kdbl, kdcml128v3), BITXOR(kdbl, kdcml128v3) from expr_test order by id"""
	// qt_sql_test_Double_Decimal128V3_notn_4 """
	// 	select id, BITAND(kdbl, kdcml128v3), BITOR(kdbl, kdcml128v3), BITXOR(kdbl, kdcml128v3) from expr_test_not_nullable order by id"""
	qt_sql_test_Double_Char_0 """
		select id, kdbl + kchr, kdbl - kchr from expr_test order by id"""
	qt_sql_test_Double_Char_notn_0 """
		select id, kdbl + kchr, kdbl - kchr from expr_test_not_nullable order by id"""
	qt_sql_test_Double_Char_1 """
		select id, kdbl * kchr, kdbl / kchr, kdbl % kchr from expr_test order by id"""
	qt_sql_test_Double_Char_notn_1 """
		select id, kdbl * kchr, kdbl / kchr, kdbl % kchr from expr_test_not_nullable order by id"""
	qt_sql_test_Double_Char_2 """
		select id, kdbl DIV kchr from expr_test order by id"""
	qt_sql_test_Double_Char_notn_2 """
		select id, kdbl DIV kchr from expr_test_not_nullable order by id"""
	qt_sql_test_Double_Char_3 """
		select id, kdbl & kchr, kdbl | kchr, kdbl ^ kchr from expr_test order by id"""
	qt_sql_test_Double_Char_notn_3 """
		select id, kdbl & kchr, kdbl | kchr, kdbl ^ kchr from expr_test_not_nullable order by id"""
	// qt_sql_test_Double_Char_4 """
	// 	select id, BITAND(kdbl, kchr), BITOR(kdbl, kchr), BITXOR(kdbl, kchr) from expr_test order by id"""
	// qt_sql_test_Double_Char_notn_4 """
	// 	select id, BITAND(kdbl, kchr), BITOR(kdbl, kchr), BITXOR(kdbl, kchr) from expr_test_not_nullable order by id"""
	qt_sql_test_Double_Varchar_0 """
		select id, kdbl + kvchr, kdbl - kvchr from expr_test order by id"""
	qt_sql_test_Double_Varchar_notn_0 """
		select id, kdbl + kvchr, kdbl - kvchr from expr_test_not_nullable order by id"""
	qt_sql_test_Double_Varchar_1 """
		select id, kdbl * kvchr, kdbl / kvchr, kdbl % kvchr from expr_test order by id"""
	qt_sql_test_Double_Varchar_notn_1 """
		select id, kdbl * kvchr, kdbl / kvchr, kdbl % kvchr from expr_test_not_nullable order by id"""
	qt_sql_test_Double_Varchar_2 """
		select id, kdbl DIV kvchr from expr_test order by id"""
	qt_sql_test_Double_Varchar_notn_2 """
		select id, kdbl DIV kvchr from expr_test_not_nullable order by id"""
	qt_sql_test_Double_Varchar_3 """
		select id, kdbl & kvchr, kdbl | kvchr, kdbl ^ kvchr from expr_test order by id"""
	qt_sql_test_Double_Varchar_notn_3 """
		select id, kdbl & kvchr, kdbl | kvchr, kdbl ^ kvchr from expr_test_not_nullable order by id"""
	// qt_sql_test_Double_Varchar_4 """
	// 	select id, BITAND(kdbl, kvchr), BITOR(kdbl, kvchr), BITXOR(kdbl, kvchr) from expr_test order by id"""
	// qt_sql_test_Double_Varchar_notn_4 """
	// 	select id, BITAND(kdbl, kvchr), BITOR(kdbl, kvchr), BITXOR(kdbl, kvchr) from expr_test_not_nullable order by id"""
	qt_sql_test_Double_String_0 """
		select id, kdbl + kstr, kdbl - kstr from expr_test order by id"""
	qt_sql_test_Double_String_notn_0 """
		select id, kdbl + kstr, kdbl - kstr from expr_test_not_nullable order by id"""
	qt_sql_test_Double_String_1 """
		select id, kdbl * kstr, kdbl / kstr, kdbl % kstr from expr_test order by id"""
	qt_sql_test_Double_String_notn_1 """
		select id, kdbl * kstr, kdbl / kstr, kdbl % kstr from expr_test_not_nullable order by id"""
	qt_sql_test_Double_String_2 """
		select id, kdbl DIV kstr from expr_test order by id"""
	qt_sql_test_Double_String_notn_2 """
		select id, kdbl DIV kstr from expr_test_not_nullable order by id"""
	qt_sql_test_Double_String_3 """
		select id, kdbl & kstr, kdbl | kstr, kdbl ^ kstr from expr_test order by id"""
	qt_sql_test_Double_String_notn_3 """
		select id, kdbl & kstr, kdbl | kstr, kdbl ^ kstr from expr_test_not_nullable order by id"""
	// qt_sql_test_Double_String_4 """
	// 	select id, BITAND(kdbl, kstr), BITOR(kdbl, kstr), BITXOR(kdbl, kstr) from expr_test order by id"""
	// qt_sql_test_Double_String_notn_4 """
	// 	select id, BITAND(kdbl, kstr), BITOR(kdbl, kstr), BITXOR(kdbl, kstr) from expr_test_not_nullable order by id"""
	qt_sql_test_Double_Date_0 """
		select id, kdbl + kdt, kdbl - kdt from expr_test order by id"""
	qt_sql_test_Double_Date_notn_0 """
		select id, kdbl + kdt, kdbl - kdt from expr_test_not_nullable order by id"""
	qt_sql_test_Double_Date_1 """
		select id, kdbl * kdt, kdbl / kdt, kdbl % kdt from expr_test order by id"""
	qt_sql_test_Double_Date_notn_1 """
		select id, kdbl * kdt, kdbl / kdt, kdbl % kdt from expr_test_not_nullable order by id"""
	qt_sql_test_Double_Date_2 """
		select id, kdbl DIV kdt from expr_test order by id"""
	qt_sql_test_Double_Date_notn_2 """
		select id, kdbl DIV kdt from expr_test_not_nullable order by id"""
	qt_sql_test_Double_Date_3 """
		select id, kdbl & kdt, kdbl | kdt, kdbl ^ kdt from expr_test order by id"""
	qt_sql_test_Double_Date_notn_3 """
		select id, kdbl & kdt, kdbl | kdt, kdbl ^ kdt from expr_test_not_nullable order by id"""
	// qt_sql_test_Double_Date_4 """
	// 	select id, BITAND(kdbl, kdt), BITOR(kdbl, kdt), BITXOR(kdbl, kdt) from expr_test order by id"""
	// qt_sql_test_Double_Date_notn_4 """
	// 	select id, BITAND(kdbl, kdt), BITOR(kdbl, kdt), BITXOR(kdbl, kdt) from expr_test_not_nullable order by id"""
	qt_sql_test_Double_DateTime_0 """
		select id, kdbl + kdtm, kdbl - kdtm from expr_test order by id"""
	qt_sql_test_Double_DateTime_notn_0 """
		select id, kdbl + kdtm, kdbl - kdtm from expr_test_not_nullable order by id"""
	qt_sql_test_Double_DateTime_1 """
		select id, kdbl * kdtm, kdbl / kdtm, kdbl % kdtm from expr_test order by id"""
	qt_sql_test_Double_DateTime_notn_1 """
		select id, kdbl * kdtm, kdbl / kdtm, kdbl % kdtm from expr_test_not_nullable order by id"""
	qt_sql_test_Double_DateTime_2 """
		select id, kdbl DIV kdtm from expr_test order by id"""
	qt_sql_test_Double_DateTime_notn_2 """
		select id, kdbl DIV kdtm from expr_test_not_nullable order by id"""
	qt_sql_test_Double_DateTime_3 """
		select id, kdbl & kdtm, kdbl | kdtm, kdbl ^ kdtm from expr_test order by id"""
	qt_sql_test_Double_DateTime_notn_3 """
		select id, kdbl & kdtm, kdbl | kdtm, kdbl ^ kdtm from expr_test_not_nullable order by id"""
	// qt_sql_test_Double_DateTime_4 """
	// 	select id, BITAND(kdbl, kdtm), BITOR(kdbl, kdtm), BITXOR(kdbl, kdtm) from expr_test order by id"""
	// qt_sql_test_Double_DateTime_notn_4 """
	// 	select id, BITAND(kdbl, kdtm), BITOR(kdbl, kdtm), BITXOR(kdbl, kdtm) from expr_test_not_nullable order by id"""
	qt_sql_test_Double_DateV2_0 """
		select id, kdbl + kdtv2, kdbl - kdtv2 from expr_test order by id"""
	qt_sql_test_Double_DateV2_notn_0 """
		select id, kdbl + kdtv2, kdbl - kdtv2 from expr_test_not_nullable order by id"""
	qt_sql_test_Double_DateV2_1 """
		select id, kdbl * kdtv2, kdbl / kdtv2, kdbl % kdtv2 from expr_test order by id"""
	qt_sql_test_Double_DateV2_notn_1 """
		select id, kdbl * kdtv2, kdbl / kdtv2, kdbl % kdtv2 from expr_test_not_nullable order by id"""
	qt_sql_test_Double_DateV2_2 """
		select id, kdbl DIV kdtv2 from expr_test order by id"""
	qt_sql_test_Double_DateV2_notn_2 """
		select id, kdbl DIV kdtv2 from expr_test_not_nullable order by id"""
	qt_sql_test_Double_DateV2_3 """
		select id, kdbl & kdtv2, kdbl | kdtv2, kdbl ^ kdtv2 from expr_test order by id"""
	qt_sql_test_Double_DateV2_notn_3 """
		select id, kdbl & kdtv2, kdbl | kdtv2, kdbl ^ kdtv2 from expr_test_not_nullable order by id"""
	// qt_sql_test_Double_DateV2_4 """
	// 	select id, BITAND(kdbl, kdtv2), BITOR(kdbl, kdtv2), BITXOR(kdbl, kdtv2) from expr_test order by id"""
	// qt_sql_test_Double_DateV2_notn_4 """
	// 	select id, BITAND(kdbl, kdtv2), BITOR(kdbl, kdtv2), BITXOR(kdbl, kdtv2) from expr_test_not_nullable order by id"""
	qt_sql_test_Double_DateTimeV2_0 """
		select id, kdbl + kdtmv2, kdbl - kdtmv2 from expr_test order by id"""
	qt_sql_test_Double_DateTimeV2_notn_0 """
		select id, kdbl + kdtmv2, kdbl - kdtmv2 from expr_test_not_nullable order by id"""
	qt_sql_test_Double_DateTimeV2_1 """
		select id, kdbl * kdtmv2, kdbl / kdtmv2, kdbl % kdtmv2 from expr_test order by id"""
	qt_sql_test_Double_DateTimeV2_notn_1 """
		select id, kdbl * kdtmv2, kdbl / kdtmv2, kdbl % kdtmv2 from expr_test_not_nullable order by id"""
	qt_sql_test_Double_DateTimeV2_2 """
		select id, kdbl DIV kdtmv2 from expr_test order by id"""
	qt_sql_test_Double_DateTimeV2_notn_2 """
		select id, kdbl DIV kdtmv2 from expr_test_not_nullable order by id"""
	qt_sql_test_Double_DateTimeV2_3 """
		select id, kdbl & kdtmv2, kdbl | kdtmv2, kdbl ^ kdtmv2 from expr_test order by id"""
	qt_sql_test_Double_DateTimeV2_notn_3 """
		select id, kdbl & kdtmv2, kdbl | kdtmv2, kdbl ^ kdtmv2 from expr_test_not_nullable order by id"""
	// qt_sql_test_Double_DateTimeV2_4 """
	// 	select id, BITAND(kdbl, kdtmv2), BITOR(kdbl, kdtmv2), BITXOR(kdbl, kdtmv2) from expr_test order by id"""
	// qt_sql_test_Double_DateTimeV2_notn_4 """
	// 	select id, BITAND(kdbl, kdtmv2), BITOR(kdbl, kdtmv2), BITXOR(kdbl, kdtmv2) from expr_test_not_nullable order by id"""
	qt_sql_test_Double_Boolean_0 """
		select id, kdbl + kbool, kdbl - kbool from expr_test order by id"""
	qt_sql_test_Double_Boolean_notn_0 """
		select id, kdbl + kbool, kdbl - kbool from expr_test_not_nullable order by id"""
	qt_sql_test_Double_Boolean_1 """
		select id, kdbl * kbool, kdbl / kbool, kdbl % kbool from expr_test order by id"""
	qt_sql_test_Double_Boolean_notn_1 """
		select id, kdbl * kbool, kdbl / kbool, kdbl % kbool from expr_test_not_nullable order by id"""
	qt_sql_test_Double_Boolean_2 """
		select id, kdbl DIV kbool from expr_test order by id"""
	qt_sql_test_Double_Boolean_notn_2 """
		select id, kdbl DIV kbool from expr_test_not_nullable order by id"""
	qt_sql_test_Double_Boolean_3 """
		select id, kdbl & kbool, kdbl | kbool, kdbl ^ kbool from expr_test order by id"""
	qt_sql_test_Double_Boolean_notn_3 """
		select id, kdbl & kbool, kdbl | kbool, kdbl ^ kbool from expr_test_not_nullable order by id"""
	// qt_sql_test_Double_Boolean_4 """
	// 	select id, BITAND(kdbl, kbool), BITOR(kdbl, kbool), BITXOR(kdbl, kbool) from expr_test order by id"""
	// qt_sql_test_Double_Boolean_notn_4 """
	// 	select id, BITAND(kdbl, kbool), BITOR(kdbl, kbool), BITXOR(kdbl, kbool) from expr_test_not_nullable order by id"""
	qt_sql_test_DecimalV2_TinyInt_0 """
		select id, kdcml + ktint, kdcml - ktint from expr_test order by id"""
	qt_sql_test_DecimalV2_TinyInt_notn_0 """
		select id, kdcml + ktint, kdcml - ktint from expr_test_not_nullable order by id"""
	qt_sql_test_DecimalV2_TinyInt_1 """
		select id, kdcml * ktint, kdcml / ktint, kdcml % ktint from expr_test order by id"""
	qt_sql_test_DecimalV2_TinyInt_notn_1 """
		select id, kdcml * ktint, kdcml / ktint, kdcml % ktint from expr_test_not_nullable order by id"""
	qt_sql_test_DecimalV2_TinyInt_2 """
		select id, kdcml DIV ktint from expr_test order by id"""
	qt_sql_test_DecimalV2_TinyInt_notn_2 """
		select id, kdcml DIV ktint from expr_test_not_nullable order by id"""
	qt_sql_test_DecimalV2_TinyInt_3 """
		select id, kdcml & ktint, kdcml | ktint, kdcml ^ ktint from expr_test order by id"""
	qt_sql_test_DecimalV2_TinyInt_notn_3 """
		select id, kdcml & ktint, kdcml | ktint, kdcml ^ ktint from expr_test_not_nullable order by id"""
	// qt_sql_test_DecimalV2_TinyInt_4 """
	// 	select id, BITAND(kdcml, ktint), BITOR(kdcml, ktint), BITXOR(kdcml, ktint) from expr_test order by id"""
	// qt_sql_test_DecimalV2_TinyInt_notn_4 """
	// 	select id, BITAND(kdcml, ktint), BITOR(kdcml, ktint), BITXOR(kdcml, ktint) from expr_test_not_nullable order by id"""
	qt_sql_test_DecimalV2_SmallInt_0 """
		select id, kdcml + ksint, kdcml - ksint from expr_test order by id"""
	qt_sql_test_DecimalV2_SmallInt_notn_0 """
		select id, kdcml + ksint, kdcml - ksint from expr_test_not_nullable order by id"""
	qt_sql_test_DecimalV2_SmallInt_1 """
		select id, kdcml * ksint, kdcml / ksint, kdcml % ksint from expr_test order by id"""
	qt_sql_test_DecimalV2_SmallInt_notn_1 """
		select id, kdcml * ksint, kdcml / ksint, kdcml % ksint from expr_test_not_nullable order by id"""
	qt_sql_test_DecimalV2_SmallInt_2 """
		select id, kdcml DIV ksint from expr_test order by id"""
	qt_sql_test_DecimalV2_SmallInt_notn_2 """
		select id, kdcml DIV ksint from expr_test_not_nullable order by id"""
	qt_sql_test_DecimalV2_SmallInt_3 """
		select id, kdcml & ksint, kdcml | ksint, kdcml ^ ksint from expr_test order by id"""
	qt_sql_test_DecimalV2_SmallInt_notn_3 """
		select id, kdcml & ksint, kdcml | ksint, kdcml ^ ksint from expr_test_not_nullable order by id"""
	// qt_sql_test_DecimalV2_SmallInt_4 """
	// 	select id, BITAND(kdcml, ksint), BITOR(kdcml, ksint), BITXOR(kdcml, ksint) from expr_test order by id"""
	// qt_sql_test_DecimalV2_SmallInt_notn_4 """
	// 	select id, BITAND(kdcml, ksint), BITOR(kdcml, ksint), BITXOR(kdcml, ksint) from expr_test_not_nullable order by id"""
	qt_sql_test_DecimalV2_Integer_0 """
		select id, kdcml + kint, kdcml - kint from expr_test order by id"""
	qt_sql_test_DecimalV2_Integer_notn_0 """
		select id, kdcml + kint, kdcml - kint from expr_test_not_nullable order by id"""
	qt_sql_test_DecimalV2_Integer_1 """
		select id, kdcml * kint, kdcml / kint, kdcml % kint from expr_test order by id"""
	qt_sql_test_DecimalV2_Integer_notn_1 """
		select id, kdcml * kint, kdcml / kint, kdcml % kint from expr_test_not_nullable order by id"""
	qt_sql_test_DecimalV2_Integer_2 """
		select id, kdcml DIV kint from expr_test order by id"""
	qt_sql_test_DecimalV2_Integer_notn_2 """
		select id, kdcml DIV kint from expr_test_not_nullable order by id"""
	qt_sql_test_DecimalV2_Integer_3 """
		select id, kdcml & kint, kdcml | kint, kdcml ^ kint from expr_test order by id"""
	qt_sql_test_DecimalV2_Integer_notn_3 """
		select id, kdcml & kint, kdcml | kint, kdcml ^ kint from expr_test_not_nullable order by id"""
	// qt_sql_test_DecimalV2_Integer_4 """
	// 	select id, BITAND(kdcml, kint), BITOR(kdcml, kint), BITXOR(kdcml, kint) from expr_test order by id"""
	// qt_sql_test_DecimalV2_Integer_notn_4 """
	// 	select id, BITAND(kdcml, kint), BITOR(kdcml, kint), BITXOR(kdcml, kint) from expr_test_not_nullable order by id"""
	qt_sql_test_DecimalV2_BigInt_0 """
		select id, kdcml + kbint, kdcml - kbint from expr_test order by id"""
	qt_sql_test_DecimalV2_BigInt_notn_0 """
		select id, kdcml + kbint, kdcml - kbint from expr_test_not_nullable order by id"""
	qt_sql_test_DecimalV2_BigInt_1 """
		select id, kdcml * kbint, kdcml / kbint, kdcml % kbint from expr_test order by id"""
	qt_sql_test_DecimalV2_BigInt_notn_1 """
		select id, kdcml * kbint, kdcml / kbint, kdcml % kbint from expr_test_not_nullable order by id"""
	qt_sql_test_DecimalV2_BigInt_2 """
		select id, kdcml DIV kbint from expr_test order by id"""
	qt_sql_test_DecimalV2_BigInt_notn_2 """
		select id, kdcml DIV kbint from expr_test_not_nullable order by id"""
	qt_sql_test_DecimalV2_BigInt_3 """
		select id, kdcml & kbint, kdcml | kbint, kdcml ^ kbint from expr_test order by id"""
	qt_sql_test_DecimalV2_BigInt_notn_3 """
		select id, kdcml & kbint, kdcml | kbint, kdcml ^ kbint from expr_test_not_nullable order by id"""
	// qt_sql_test_DecimalV2_BigInt_4 """
	// 	select id, BITAND(kdcml, kbint), BITOR(kdcml, kbint), BITXOR(kdcml, kbint) from expr_test order by id"""
	// qt_sql_test_DecimalV2_BigInt_notn_4 """
	// 	select id, BITAND(kdcml, kbint), BITOR(kdcml, kbint), BITXOR(kdcml, kbint) from expr_test_not_nullable order by id"""
	qt_sql_test_DecimalV2_LargeInt_0 """
		select id, kdcml + klint, kdcml - klint from expr_test order by id"""
	qt_sql_test_DecimalV2_LargeInt_notn_0 """
		select id, kdcml + klint, kdcml - klint from expr_test_not_nullable order by id"""
	// qt_sql_test_DecimalV2_LargeInt_1 """
	// 	select id, kdcml * klint, kdcml / klint, kdcml % klint from expr_test order by id"""
	// qt_sql_test_DecimalV2_LargeInt_notn_1 """
	// 	select id, kdcml * klint, kdcml / klint, kdcml % klint from expr_test_not_nullable order by id"""
	qt_sql_test_DecimalV2_LargeInt_2 """
		select id, kdcml DIV klint from expr_test order by id"""
	qt_sql_test_DecimalV2_LargeInt_notn_2 """
		select id, kdcml DIV klint from expr_test_not_nullable order by id"""
	qt_sql_test_DecimalV2_LargeInt_3 """
		select id, kdcml & klint, kdcml | klint, kdcml ^ klint from expr_test order by id"""
	qt_sql_test_DecimalV2_LargeInt_notn_3 """
		select id, kdcml & klint, kdcml | klint, kdcml ^ klint from expr_test_not_nullable order by id"""
	// qt_sql_test_DecimalV2_LargeInt_4 """
	// 	select id, BITAND(kdcml, klint), BITOR(kdcml, klint), BITXOR(kdcml, klint) from expr_test order by id"""
	// qt_sql_test_DecimalV2_LargeInt_notn_4 """
	// 	select id, BITAND(kdcml, klint), BITOR(kdcml, klint), BITXOR(kdcml, klint) from expr_test_not_nullable order by id"""
	qt_sql_test_DecimalV2_Float_0 """
		select id, kdcml + kfloat, kdcml - kfloat from expr_test order by id"""
	qt_sql_test_DecimalV2_Float_notn_0 """
		select id, kdcml + kfloat, kdcml - kfloat from expr_test_not_nullable order by id"""
	qt_sql_test_DecimalV2_Float_1 """
		select id, kdcml * kfloat, kdcml / kfloat, kdcml % kfloat from expr_test order by id"""
	qt_sql_test_DecimalV2_Float_notn_1 """
		select id, kdcml * kfloat, kdcml / kfloat, kdcml % kfloat from expr_test_not_nullable order by id"""
	qt_sql_test_DecimalV2_Float_2 """
		select id, kdcml DIV kfloat from expr_test order by id"""
	qt_sql_test_DecimalV2_Float_notn_2 """
		select id, kdcml DIV kfloat from expr_test_not_nullable order by id"""
	qt_sql_test_DecimalV2_Float_3 """
		select id, kdcml & kfloat, kdcml | kfloat, kdcml ^ kfloat from expr_test order by id"""
	qt_sql_test_DecimalV2_Float_notn_3 """
		select id, kdcml & kfloat, kdcml | kfloat, kdcml ^ kfloat from expr_test_not_nullable order by id"""
	// qt_sql_test_DecimalV2_Float_4 """
	// 	select id, BITAND(kdcml, kfloat), BITOR(kdcml, kfloat), BITXOR(kdcml, kfloat) from expr_test order by id"""
	// qt_sql_test_DecimalV2_Float_notn_4 """
	// 	select id, BITAND(kdcml, kfloat), BITOR(kdcml, kfloat), BITXOR(kdcml, kfloat) from expr_test_not_nullable order by id"""
	qt_sql_test_DecimalV2_Double_0 """
		select id, kdcml + kdbl, kdcml - kdbl from expr_test order by id"""
	qt_sql_test_DecimalV2_Double_notn_0 """
		select id, kdcml + kdbl, kdcml - kdbl from expr_test_not_nullable order by id"""
	qt_sql_test_DecimalV2_Double_1 """
		select id, kdcml * kdbl, kdcml / kdbl, kdcml % kdbl from expr_test order by id"""
	qt_sql_test_DecimalV2_Double_notn_1 """
		select id, kdcml * kdbl, kdcml / kdbl, kdcml % kdbl from expr_test_not_nullable order by id"""
	qt_sql_test_DecimalV2_Double_2 """
		select id, kdcml DIV kdbl from expr_test order by id"""
	qt_sql_test_DecimalV2_Double_notn_2 """
		select id, kdcml DIV kdbl from expr_test_not_nullable order by id"""
	qt_sql_test_DecimalV2_Double_3 """
		select id, kdcml & kdbl, kdcml | kdbl, kdcml ^ kdbl from expr_test order by id"""
	qt_sql_test_DecimalV2_Double_notn_3 """
		select id, kdcml & kdbl, kdcml | kdbl, kdcml ^ kdbl from expr_test_not_nullable order by id"""
	// qt_sql_test_DecimalV2_Double_4 """
	// 	select id, BITAND(kdcml, kdbl), BITOR(kdcml, kdbl), BITXOR(kdcml, kdbl) from expr_test order by id"""
	// qt_sql_test_DecimalV2_Double_notn_4 """
	// 	select id, BITAND(kdcml, kdbl), BITOR(kdcml, kdbl), BITXOR(kdcml, kdbl) from expr_test_not_nullable order by id"""
	qt_sql_test_DecimalV2_DecimalV2_0 """
		select id, kdcml + kdcml, kdcml - kdcml from expr_test order by id"""
	qt_sql_test_DecimalV2_DecimalV2_notn_0 """
		select id, kdcml + kdcml, kdcml - kdcml from expr_test_not_nullable order by id"""
	qt_sql_test_DecimalV2_DecimalV2_1 """
		select id, kdcml * kdcml, kdcml / kdcml, kdcml % kdcml from expr_test order by id"""
	qt_sql_test_DecimalV2_DecimalV2_notn_1 """
		select id, kdcml * kdcml, kdcml / kdcml, kdcml % kdcml from expr_test_not_nullable order by id"""
	qt_sql_test_DecimalV2_DecimalV2_2 """
		select id, kdcml DIV kdcml from expr_test order by id"""
	qt_sql_test_DecimalV2_DecimalV2_notn_2 """
		select id, kdcml DIV kdcml from expr_test_not_nullable order by id"""
	qt_sql_test_DecimalV2_DecimalV2_3 """
		select id, kdcml & kdcml, kdcml | kdcml, kdcml ^ kdcml from expr_test order by id"""
	qt_sql_test_DecimalV2_DecimalV2_notn_3 """
		select id, kdcml & kdcml, kdcml | kdcml, kdcml ^ kdcml from expr_test_not_nullable order by id"""
	// qt_sql_test_DecimalV2_DecimalV2_4 """
	// 	select id, BITAND(kdcml, kdcml), BITOR(kdcml, kdcml), BITXOR(kdcml, kdcml) from expr_test order by id"""
	// qt_sql_test_DecimalV2_DecimalV2_notn_4 """
	// 	select id, BITAND(kdcml, kdcml), BITOR(kdcml, kdcml), BITXOR(kdcml, kdcml) from expr_test_not_nullable order by id"""
	qt_sql_test_DecimalV2_Decimal32V3_0 """
		select id, kdcml + kdcml32v3, kdcml - kdcml32v3 from expr_test order by id"""
	qt_sql_test_DecimalV2_Decimal32V3_notn_0 """
		select id, kdcml + kdcml32v3, kdcml - kdcml32v3 from expr_test_not_nullable order by id"""
	//original planner  qt_sql_test_DecimalV2_Decimal32V3_1 """
	//original planner  	select id, kdcml * kdcml32v3, kdcml / kdcml32v3, kdcml % kdcml32v3 from expr_test order by id"""
	//original planner  qt_sql_test_DecimalV2_Decimal32V3_notn_1 """
	//original planner  	select id, kdcml * kdcml32v3, kdcml / kdcml32v3, kdcml % kdcml32v3 from expr_test_not_nullable order by id"""
	qt_sql_test_DecimalV2_Decimal32V3_2 """
		select id, kdcml DIV kdcml32v3 from expr_test order by id"""
	qt_sql_test_DecimalV2_Decimal32V3_notn_2 """
		select id, kdcml DIV kdcml32v3 from expr_test_not_nullable order by id"""
	qt_sql_test_DecimalV2_Decimal32V3_3 """
		select id, kdcml & kdcml32v3, kdcml | kdcml32v3, kdcml ^ kdcml32v3 from expr_test order by id"""
	qt_sql_test_DecimalV2_Decimal32V3_notn_3 """
		select id, kdcml & kdcml32v3, kdcml | kdcml32v3, kdcml ^ kdcml32v3 from expr_test_not_nullable order by id"""
	// qt_sql_test_DecimalV2_Decimal32V3_4 """
	// 	select id, BITAND(kdcml, kdcml32v3), BITOR(kdcml, kdcml32v3), BITXOR(kdcml, kdcml32v3) from expr_test order by id"""
	// qt_sql_test_DecimalV2_Decimal32V3_notn_4 """
	// 	select id, BITAND(kdcml, kdcml32v3), BITOR(kdcml, kdcml32v3), BITXOR(kdcml, kdcml32v3) from expr_test_not_nullable order by id"""
	qt_sql_test_DecimalV2_Decimal64V3_0 """
		select id, kdcml + kdcml64v3, kdcml - kdcml64v3 from expr_test order by id"""
	qt_sql_test_DecimalV2_Decimal64V3_notn_0 """
		select id, kdcml + kdcml64v3, kdcml - kdcml64v3 from expr_test_not_nullable order by id"""
	//original planner  qt_sql_test_DecimalV2_Decimal64V3_1 """
	//original planner  	select id, kdcml * kdcml64v3, kdcml / kdcml64v3, kdcml % kdcml64v3 from expr_test order by id"""
	//original planner  qt_sql_test_DecimalV2_Decimal64V3_notn_1 """
	//original planner  	select id, kdcml * kdcml64v3, kdcml / kdcml64v3, kdcml % kdcml64v3 from expr_test_not_nullable order by id"""
	qt_sql_test_DecimalV2_Decimal64V3_2 """
		select id, kdcml DIV kdcml64v3 from expr_test order by id"""
	qt_sql_test_DecimalV2_Decimal64V3_notn_2 """
		select id, kdcml DIV kdcml64v3 from expr_test_not_nullable order by id"""
	qt_sql_test_DecimalV2_Decimal64V3_3 """
		select id, kdcml & kdcml64v3, kdcml | kdcml64v3, kdcml ^ kdcml64v3 from expr_test order by id"""
	qt_sql_test_DecimalV2_Decimal64V3_notn_3 """
		select id, kdcml & kdcml64v3, kdcml | kdcml64v3, kdcml ^ kdcml64v3 from expr_test_not_nullable order by id"""
	// qt_sql_test_DecimalV2_Decimal64V3_4 """
	// 	select id, BITAND(kdcml, kdcml64v3), BITOR(kdcml, kdcml64v3), BITXOR(kdcml, kdcml64v3) from expr_test order by id"""
	// qt_sql_test_DecimalV2_Decimal64V3_notn_4 """
	// 	select id, BITAND(kdcml, kdcml64v3), BITOR(kdcml, kdcml64v3), BITXOR(kdcml, kdcml64v3) from expr_test_not_nullable order by id"""
	qt_sql_test_DecimalV2_Decimal128V3_0 """
		select id, kdcml + kdcml128v3, kdcml - kdcml128v3 from expr_test order by id"""
	qt_sql_test_DecimalV2_Decimal128V3_notn_0 """
		select id, kdcml + kdcml128v3, kdcml - kdcml128v3 from expr_test_not_nullable order by id"""
	//original planner  qt_sql_test_DecimalV2_Decimal128V3_1 """
	//original planner  	select id, kdcml * kdcml128v3, kdcml / kdcml128v3, kdcml % kdcml128v3 from expr_test order by id"""
	//original planner  qt_sql_test_DecimalV2_Decimal128V3_notn_1 """
	//original planner  	select id, kdcml * kdcml128v3, kdcml / kdcml128v3, kdcml % kdcml128v3 from expr_test_not_nullable order by id"""
	qt_sql_test_DecimalV2_Decimal128V3_2 """
		select id, kdcml DIV kdcml128v3 from expr_test order by id"""
	qt_sql_test_DecimalV2_Decimal128V3_notn_2 """
		select id, kdcml DIV kdcml128v3 from expr_test_not_nullable order by id"""
	qt_sql_test_DecimalV2_Decimal128V3_3 """
		select id, kdcml & kdcml128v3, kdcml | kdcml128v3, kdcml ^ kdcml128v3 from expr_test order by id"""
	qt_sql_test_DecimalV2_Decimal128V3_notn_3 """
		select id, kdcml & kdcml128v3, kdcml | kdcml128v3, kdcml ^ kdcml128v3 from expr_test_not_nullable order by id"""
	// qt_sql_test_DecimalV2_Decimal128V3_4 """
	// 	select id, BITAND(kdcml, kdcml128v3), BITOR(kdcml, kdcml128v3), BITXOR(kdcml, kdcml128v3) from expr_test order by id"""
	// qt_sql_test_DecimalV2_Decimal128V3_notn_4 """
	// 	select id, BITAND(kdcml, kdcml128v3), BITOR(kdcml, kdcml128v3), BITXOR(kdcml, kdcml128v3) from expr_test_not_nullable order by id"""
	qt_sql_test_DecimalV2_Char_0 """
		select id, kdcml + kchr, kdcml - kchr from expr_test order by id"""
	qt_sql_test_DecimalV2_Char_notn_0 """
		select id, kdcml + kchr, kdcml - kchr from expr_test_not_nullable order by id"""
	qt_sql_test_DecimalV2_Char_1 """
		select id, kdcml * kchr, kdcml / kchr, kdcml % kchr from expr_test order by id"""
	qt_sql_test_DecimalV2_Char_notn_1 """
		select id, kdcml * kchr, kdcml / kchr, kdcml % kchr from expr_test_not_nullable order by id"""
	qt_sql_test_DecimalV2_Char_2 """
		select id, kdcml DIV kchr from expr_test order by id"""
	qt_sql_test_DecimalV2_Char_notn_2 """
		select id, kdcml DIV kchr from expr_test_not_nullable order by id"""
	qt_sql_test_DecimalV2_Char_3 """
		select id, kdcml & kchr, kdcml | kchr, kdcml ^ kchr from expr_test order by id"""
	qt_sql_test_DecimalV2_Char_notn_3 """
		select id, kdcml & kchr, kdcml | kchr, kdcml ^ kchr from expr_test_not_nullable order by id"""
	// qt_sql_test_DecimalV2_Char_4 """
	// 	select id, BITAND(kdcml, kchr), BITOR(kdcml, kchr), BITXOR(kdcml, kchr) from expr_test order by id"""
	// qt_sql_test_DecimalV2_Char_notn_4 """
	// 	select id, BITAND(kdcml, kchr), BITOR(kdcml, kchr), BITXOR(kdcml, kchr) from expr_test_not_nullable order by id"""
	qt_sql_test_DecimalV2_Varchar_0 """
		select id, kdcml + kvchr, kdcml - kvchr from expr_test order by id"""
	qt_sql_test_DecimalV2_Varchar_notn_0 """
		select id, kdcml + kvchr, kdcml - kvchr from expr_test_not_nullable order by id"""
	qt_sql_test_DecimalV2_Varchar_1 """
		select id, kdcml * kvchr, kdcml / kvchr, kdcml % kvchr from expr_test order by id"""
	qt_sql_test_DecimalV2_Varchar_notn_1 """
		select id, kdcml * kvchr, kdcml / kvchr, kdcml % kvchr from expr_test_not_nullable order by id"""
	qt_sql_test_DecimalV2_Varchar_2 """
		select id, kdcml DIV kvchr from expr_test order by id"""
	qt_sql_test_DecimalV2_Varchar_notn_2 """
		select id, kdcml DIV kvchr from expr_test_not_nullable order by id"""
	qt_sql_test_DecimalV2_Varchar_3 """
		select id, kdcml & kvchr, kdcml | kvchr, kdcml ^ kvchr from expr_test order by id"""
	qt_sql_test_DecimalV2_Varchar_notn_3 """
		select id, kdcml & kvchr, kdcml | kvchr, kdcml ^ kvchr from expr_test_not_nullable order by id"""
	// qt_sql_test_DecimalV2_Varchar_4 """
	// 	select id, BITAND(kdcml, kvchr), BITOR(kdcml, kvchr), BITXOR(kdcml, kvchr) from expr_test order by id"""
	// qt_sql_test_DecimalV2_Varchar_notn_4 """
	// 	select id, BITAND(kdcml, kvchr), BITOR(kdcml, kvchr), BITXOR(kdcml, kvchr) from expr_test_not_nullable order by id"""
	qt_sql_test_DecimalV2_String_0 """
		select id, kdcml + kstr, kdcml - kstr from expr_test order by id"""
	qt_sql_test_DecimalV2_String_notn_0 """
		select id, kdcml + kstr, kdcml - kstr from expr_test_not_nullable order by id"""
	qt_sql_test_DecimalV2_String_1 """
		select id, kdcml * kstr, kdcml / kstr, kdcml % kstr from expr_test order by id"""
	qt_sql_test_DecimalV2_String_notn_1 """
		select id, kdcml * kstr, kdcml / kstr, kdcml % kstr from expr_test_not_nullable order by id"""
	qt_sql_test_DecimalV2_String_2 """
		select id, kdcml DIV kstr from expr_test order by id"""
	qt_sql_test_DecimalV2_String_notn_2 """
		select id, kdcml DIV kstr from expr_test_not_nullable order by id"""
	qt_sql_test_DecimalV2_String_3 """
		select id, kdcml & kstr, kdcml | kstr, kdcml ^ kstr from expr_test order by id"""
	qt_sql_test_DecimalV2_String_notn_3 """
		select id, kdcml & kstr, kdcml | kstr, kdcml ^ kstr from expr_test_not_nullable order by id"""
	// qt_sql_test_DecimalV2_String_4 """
	// 	select id, BITAND(kdcml, kstr), BITOR(kdcml, kstr), BITXOR(kdcml, kstr) from expr_test order by id"""
	// qt_sql_test_DecimalV2_String_notn_4 """
	// 	select id, BITAND(kdcml, kstr), BITOR(kdcml, kstr), BITXOR(kdcml, kstr) from expr_test_not_nullable order by id"""
	qt_sql_test_DecimalV2_Date_0 """
		select id, kdcml + kdt, kdcml - kdt from expr_test order by id"""
	qt_sql_test_DecimalV2_Date_notn_0 """
		select id, kdcml + kdt, kdcml - kdt from expr_test_not_nullable order by id"""
	qt_sql_test_DecimalV2_Date_1 """
		select id, kdcml * kdt, kdcml / kdt, kdcml % kdt from expr_test order by id"""
	qt_sql_test_DecimalV2_Date_notn_1 """
		select id, kdcml * kdt, kdcml / kdt, kdcml % kdt from expr_test_not_nullable order by id"""
	qt_sql_test_DecimalV2_Date_2 """
		select id, kdcml DIV kdt from expr_test order by id"""
	qt_sql_test_DecimalV2_Date_notn_2 """
		select id, kdcml DIV kdt from expr_test_not_nullable order by id"""
	qt_sql_test_DecimalV2_Date_3 """
		select id, kdcml & kdt, kdcml | kdt, kdcml ^ kdt from expr_test order by id"""
	qt_sql_test_DecimalV2_Date_notn_3 """
		select id, kdcml & kdt, kdcml | kdt, kdcml ^ kdt from expr_test_not_nullable order by id"""
	// qt_sql_test_DecimalV2_Date_4 """
	// 	select id, BITAND(kdcml, kdt), BITOR(kdcml, kdt), BITXOR(kdcml, kdt) from expr_test order by id"""
	// qt_sql_test_DecimalV2_Date_notn_4 """
	// 	select id, BITAND(kdcml, kdt), BITOR(kdcml, kdt), BITXOR(kdcml, kdt) from expr_test_not_nullable order by id"""
	qt_sql_test_DecimalV2_DateTime_0 """
		select id, kdcml + kdtm, kdcml - kdtm from expr_test order by id"""
	qt_sql_test_DecimalV2_DateTime_notn_0 """
		select id, kdcml + kdtm, kdcml - kdtm from expr_test_not_nullable order by id"""
	qt_sql_test_DecimalV2_DateTime_1 """
		select id, kdcml * kdtm, kdcml / kdtm, kdcml % kdtm from expr_test order by id"""
	qt_sql_test_DecimalV2_DateTime_notn_1 """
		select id, kdcml * kdtm, kdcml / kdtm, kdcml % kdtm from expr_test_not_nullable order by id"""
	qt_sql_test_DecimalV2_DateTime_2 """
		select id, kdcml DIV kdtm from expr_test order by id"""
	qt_sql_test_DecimalV2_DateTime_notn_2 """
		select id, kdcml DIV kdtm from expr_test_not_nullable order by id"""
	qt_sql_test_DecimalV2_DateTime_3 """
		select id, kdcml & kdtm, kdcml | kdtm, kdcml ^ kdtm from expr_test order by id"""
	qt_sql_test_DecimalV2_DateTime_notn_3 """
		select id, kdcml & kdtm, kdcml | kdtm, kdcml ^ kdtm from expr_test_not_nullable order by id"""
	// qt_sql_test_DecimalV2_DateTime_4 """
	// 	select id, BITAND(kdcml, kdtm), BITOR(kdcml, kdtm), BITXOR(kdcml, kdtm) from expr_test order by id"""
	// qt_sql_test_DecimalV2_DateTime_notn_4 """
	// 	select id, BITAND(kdcml, kdtm), BITOR(kdcml, kdtm), BITXOR(kdcml, kdtm) from expr_test_not_nullable order by id"""
	qt_sql_test_DecimalV2_DateV2_0 """
		select id, kdcml + kdtv2, kdcml - kdtv2 from expr_test order by id"""
	qt_sql_test_DecimalV2_DateV2_notn_0 """
		select id, kdcml + kdtv2, kdcml - kdtv2 from expr_test_not_nullable order by id"""
	qt_sql_test_DecimalV2_DateV2_1 """
		select id, kdcml * kdtv2, kdcml / kdtv2, kdcml % kdtv2 from expr_test order by id"""
	qt_sql_test_DecimalV2_DateV2_notn_1 """
		select id, kdcml * kdtv2, kdcml / kdtv2, kdcml % kdtv2 from expr_test_not_nullable order by id"""
	qt_sql_test_DecimalV2_DateV2_2 """
		select id, kdcml DIV kdtv2 from expr_test order by id"""
	qt_sql_test_DecimalV2_DateV2_notn_2 """
		select id, kdcml DIV kdtv2 from expr_test_not_nullable order by id"""
	qt_sql_test_DecimalV2_DateV2_3 """
		select id, kdcml & kdtv2, kdcml | kdtv2, kdcml ^ kdtv2 from expr_test order by id"""
	qt_sql_test_DecimalV2_DateV2_notn_3 """
		select id, kdcml & kdtv2, kdcml | kdtv2, kdcml ^ kdtv2 from expr_test_not_nullable order by id"""
	// qt_sql_test_DecimalV2_DateV2_4 """
	// 	select id, BITAND(kdcml, kdtv2), BITOR(kdcml, kdtv2), BITXOR(kdcml, kdtv2) from expr_test order by id"""
	// qt_sql_test_DecimalV2_DateV2_notn_4 """
	// 	select id, BITAND(kdcml, kdtv2), BITOR(kdcml, kdtv2), BITXOR(kdcml, kdtv2) from expr_test_not_nullable order by id"""
	qt_sql_test_DecimalV2_DateTimeV2_0 """
		select id, kdcml + kdtmv2, kdcml - kdtmv2 from expr_test order by id"""
	qt_sql_test_DecimalV2_DateTimeV2_notn_0 """
		select id, kdcml + kdtmv2, kdcml - kdtmv2 from expr_test_not_nullable order by id"""
	qt_sql_test_DecimalV2_DateTimeV2_1 """
		select id, kdcml * kdtmv2, kdcml / kdtmv2, kdcml % kdtmv2 from expr_test order by id"""
	qt_sql_test_DecimalV2_DateTimeV2_notn_1 """
		select id, kdcml * kdtmv2, kdcml / kdtmv2, kdcml % kdtmv2 from expr_test_not_nullable order by id"""
	qt_sql_test_DecimalV2_DateTimeV2_2 """
		select id, kdcml DIV kdtmv2 from expr_test order by id"""
	qt_sql_test_DecimalV2_DateTimeV2_notn_2 """
		select id, kdcml DIV kdtmv2 from expr_test_not_nullable order by id"""
	qt_sql_test_DecimalV2_DateTimeV2_3 """
		select id, kdcml & kdtmv2, kdcml | kdtmv2, kdcml ^ kdtmv2 from expr_test order by id"""
	qt_sql_test_DecimalV2_DateTimeV2_notn_3 """
		select id, kdcml & kdtmv2, kdcml | kdtmv2, kdcml ^ kdtmv2 from expr_test_not_nullable order by id"""
	// qt_sql_test_DecimalV2_DateTimeV2_4 """
	// 	select id, BITAND(kdcml, kdtmv2), BITOR(kdcml, kdtmv2), BITXOR(kdcml, kdtmv2) from expr_test order by id"""
	// qt_sql_test_DecimalV2_DateTimeV2_notn_4 """
	// 	select id, BITAND(kdcml, kdtmv2), BITOR(kdcml, kdtmv2), BITXOR(kdcml, kdtmv2) from expr_test_not_nullable order by id"""
	qt_sql_test_DecimalV2_Boolean_0 """
		select id, kdcml + kbool, kdcml - kbool from expr_test order by id"""
	qt_sql_test_DecimalV2_Boolean_notn_0 """
		select id, kdcml + kbool, kdcml - kbool from expr_test_not_nullable order by id"""
	qt_sql_test_DecimalV2_Boolean_1 """
		select id, kdcml * kbool, kdcml / kbool, kdcml % kbool from expr_test order by id"""
	qt_sql_test_DecimalV2_Boolean_notn_1 """
		select id, kdcml * kbool, kdcml / kbool, kdcml % kbool from expr_test_not_nullable order by id"""
	qt_sql_test_DecimalV2_Boolean_2 """
		select id, kdcml DIV kbool from expr_test order by id"""
	qt_sql_test_DecimalV2_Boolean_notn_2 """
		select id, kdcml DIV kbool from expr_test_not_nullable order by id"""
	qt_sql_test_DecimalV2_Boolean_3 """
		select id, kdcml & kbool, kdcml | kbool, kdcml ^ kbool from expr_test order by id"""
	qt_sql_test_DecimalV2_Boolean_notn_3 """
		select id, kdcml & kbool, kdcml | kbool, kdcml ^ kbool from expr_test_not_nullable order by id"""
	// qt_sql_test_DecimalV2_Boolean_4 """
	// 	select id, BITAND(kdcml, kbool), BITOR(kdcml, kbool), BITXOR(kdcml, kbool) from expr_test order by id"""
	// qt_sql_test_DecimalV2_Boolean_notn_4 """
	// 	select id, BITAND(kdcml, kbool), BITOR(kdcml, kbool), BITXOR(kdcml, kbool) from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal32V3_TinyInt_0 """
		select id, kdcml32v3 + ktint, kdcml32v3 - ktint from expr_test order by id"""
	qt_sql_test_Decimal32V3_TinyInt_notn_0 """
		select id, kdcml32v3 + ktint, kdcml32v3 - ktint from expr_test_not_nullable order by id"""
	//original planner  qt_sql_test_Decimal32V3_TinyInt_1 """
	//original planner  	select id, kdcml32v3 * ktint, kdcml32v3 / ktint, kdcml32v3 % ktint from expr_test order by id"""
	//original planner  qt_sql_test_Decimal32V3_TinyInt_notn_1 """
	//original planner  	select id, kdcml32v3 * ktint, kdcml32v3 / ktint, kdcml32v3 % ktint from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal32V3_TinyInt_2 """
		select id, kdcml32v3 DIV ktint from expr_test order by id"""
	qt_sql_test_Decimal32V3_TinyInt_notn_2 """
		select id, kdcml32v3 DIV ktint from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal32V3_TinyInt_3 """
		select id, kdcml32v3 & ktint, kdcml32v3 | ktint, kdcml32v3 ^ ktint from expr_test order by id"""
	qt_sql_test_Decimal32V3_TinyInt_notn_3 """
		select id, kdcml32v3 & ktint, kdcml32v3 | ktint, kdcml32v3 ^ ktint from expr_test_not_nullable order by id"""
	// qt_sql_test_Decimal32V3_TinyInt_4 """
	// 	select id, BITAND(kdcml32v3, ktint), BITOR(kdcml32v3, ktint), BITXOR(kdcml32v3, ktint) from expr_test order by id"""
	// qt_sql_test_Decimal32V3_TinyInt_notn_4 """
	// 	select id, BITAND(kdcml32v3, ktint), BITOR(kdcml32v3, ktint), BITXOR(kdcml32v3, ktint) from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal32V3_SmallInt_0 """
		select id, kdcml32v3 + ksint, kdcml32v3 - ksint from expr_test order by id"""
	qt_sql_test_Decimal32V3_SmallInt_notn_0 """
		select id, kdcml32v3 + ksint, kdcml32v3 - ksint from expr_test_not_nullable order by id"""
	//original planner  qt_sql_test_Decimal32V3_SmallInt_1 """
	//original planner  	select id, kdcml32v3 * ksint, kdcml32v3 / ksint, kdcml32v3 % ksint from expr_test order by id"""
	//original planner  qt_sql_test_Decimal32V3_SmallInt_notn_1 """
	//original planner  	select id, kdcml32v3 * ksint, kdcml32v3 / ksint, kdcml32v3 % ksint from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal32V3_SmallInt_2 """
		select id, kdcml32v3 DIV ksint from expr_test order by id"""
	qt_sql_test_Decimal32V3_SmallInt_notn_2 """
		select id, kdcml32v3 DIV ksint from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal32V3_SmallInt_3 """
		select id, kdcml32v3 & ksint, kdcml32v3 | ksint, kdcml32v3 ^ ksint from expr_test order by id"""
	qt_sql_test_Decimal32V3_SmallInt_notn_3 """
		select id, kdcml32v3 & ksint, kdcml32v3 | ksint, kdcml32v3 ^ ksint from expr_test_not_nullable order by id"""
	// qt_sql_test_Decimal32V3_SmallInt_4 """
	// 	select id, BITAND(kdcml32v3, ksint), BITOR(kdcml32v3, ksint), BITXOR(kdcml32v3, ksint) from expr_test order by id"""
	// qt_sql_test_Decimal32V3_SmallInt_notn_4 """
	// 	select id, BITAND(kdcml32v3, ksint), BITOR(kdcml32v3, ksint), BITXOR(kdcml32v3, ksint) from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal32V3_Integer_0 """
		select id, kdcml32v3 + kint, kdcml32v3 - kint from expr_test order by id"""
	qt_sql_test_Decimal32V3_Integer_notn_0 """
		select id, kdcml32v3 + kint, kdcml32v3 - kint from expr_test_not_nullable order by id"""
	//original planner  qt_sql_test_Decimal32V3_Integer_1 """
	//original planner  	select id, kdcml32v3 * kint, kdcml32v3 / kint, kdcml32v3 % kint from expr_test order by id"""
	//original planner  qt_sql_test_Decimal32V3_Integer_notn_1 """
	//original planner  	select id, kdcml32v3 * kint, kdcml32v3 / kint, kdcml32v3 % kint from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal32V3_Integer_2 """
		select id, kdcml32v3 DIV kint from expr_test order by id"""
	qt_sql_test_Decimal32V3_Integer_notn_2 """
		select id, kdcml32v3 DIV kint from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal32V3_Integer_3 """
		select id, kdcml32v3 & kint, kdcml32v3 | kint, kdcml32v3 ^ kint from expr_test order by id"""
	qt_sql_test_Decimal32V3_Integer_notn_3 """
		select id, kdcml32v3 & kint, kdcml32v3 | kint, kdcml32v3 ^ kint from expr_test_not_nullable order by id"""
	// qt_sql_test_Decimal32V3_Integer_4 """
	// 	select id, BITAND(kdcml32v3, kint), BITOR(kdcml32v3, kint), BITXOR(kdcml32v3, kint) from expr_test order by id"""
	// qt_sql_test_Decimal32V3_Integer_notn_4 """
	// 	select id, BITAND(kdcml32v3, kint), BITOR(kdcml32v3, kint), BITXOR(kdcml32v3, kint) from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal32V3_BigInt_0 """
		select id, kdcml32v3 + kbint, kdcml32v3 - kbint from expr_test order by id"""
	qt_sql_test_Decimal32V3_BigInt_notn_0 """
		select id, kdcml32v3 + kbint, kdcml32v3 - kbint from expr_test_not_nullable order by id"""
	//original planner  qt_sql_test_Decimal32V3_BigInt_1 """
	//original planner  	select id, kdcml32v3 * kbint, kdcml32v3 / kbint, kdcml32v3 % kbint from expr_test order by id"""
	//original planner  qt_sql_test_Decimal32V3_BigInt_notn_1 """
	//original planner  	select id, kdcml32v3 * kbint, kdcml32v3 / kbint, kdcml32v3 % kbint from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal32V3_BigInt_2 """
		select id, kdcml32v3 DIV kbint from expr_test order by id"""
	qt_sql_test_Decimal32V3_BigInt_notn_2 """
		select id, kdcml32v3 DIV kbint from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal32V3_BigInt_3 """
		select id, kdcml32v3 & kbint, kdcml32v3 | kbint, kdcml32v3 ^ kbint from expr_test order by id"""
	qt_sql_test_Decimal32V3_BigInt_notn_3 """
		select id, kdcml32v3 & kbint, kdcml32v3 | kbint, kdcml32v3 ^ kbint from expr_test_not_nullable order by id"""
	// qt_sql_test_Decimal32V3_BigInt_4 """
	// 	select id, BITAND(kdcml32v3, kbint), BITOR(kdcml32v3, kbint), BITXOR(kdcml32v3, kbint) from expr_test order by id"""
	// qt_sql_test_Decimal32V3_BigInt_notn_4 """
	// 	select id, BITAND(kdcml32v3, kbint), BITOR(kdcml32v3, kbint), BITXOR(kdcml32v3, kbint) from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal32V3_LargeInt_0 """
		select id, kdcml32v3 + klint, kdcml32v3 - klint from expr_test order by id"""
	qt_sql_test_Decimal32V3_LargeInt_notn_0 """
		select id, kdcml32v3 + klint, kdcml32v3 - klint from expr_test_not_nullable order by id"""
	//original planner  qt_sql_test_Decimal32V3_LargeInt_1 """
	//original planner  	select id, kdcml32v3 * klint, kdcml32v3 / klint, kdcml32v3 % klint from expr_test order by id"""
	//original planner  qt_sql_test_Decimal32V3_LargeInt_notn_1 """
	//original planner  	select id, kdcml32v3 * klint, kdcml32v3 / klint, kdcml32v3 % klint from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal32V3_LargeInt_2 """
		select id, kdcml32v3 DIV klint from expr_test order by id"""
	qt_sql_test_Decimal32V3_LargeInt_notn_2 """
		select id, kdcml32v3 DIV klint from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal32V3_LargeInt_3 """
		select id, kdcml32v3 & klint, kdcml32v3 | klint, kdcml32v3 ^ klint from expr_test order by id"""
	qt_sql_test_Decimal32V3_LargeInt_notn_3 """
		select id, kdcml32v3 & klint, kdcml32v3 | klint, kdcml32v3 ^ klint from expr_test_not_nullable order by id"""
	// qt_sql_test_Decimal32V3_LargeInt_4 """
	// 	select id, BITAND(kdcml32v3, klint), BITOR(kdcml32v3, klint), BITXOR(kdcml32v3, klint) from expr_test order by id"""
	// qt_sql_test_Decimal32V3_LargeInt_notn_4 """
	// 	select id, BITAND(kdcml32v3, klint), BITOR(kdcml32v3, klint), BITXOR(kdcml32v3, klint) from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal32V3_Float_0 """
		select id, kdcml32v3 + kfloat, kdcml32v3 - kfloat from expr_test order by id"""
	qt_sql_test_Decimal32V3_Float_notn_0 """
		select id, kdcml32v3 + kfloat, kdcml32v3 - kfloat from expr_test_not_nullable order by id"""
	// qt_sql_test_Decimal32V3_Float_1 """
	// 	select id, kdcml32v3 * kfloat, kdcml32v3 / kfloat, kdcml32v3 % kfloat from expr_test order by id"""
	// qt_sql_test_Decimal32V3_Float_notn_1 """
	// 	select id, kdcml32v3 * kfloat, kdcml32v3 / kfloat, kdcml32v3 % kfloat from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal32V3_Float_2 """
		select id, kdcml32v3 DIV kfloat from expr_test order by id"""
	qt_sql_test_Decimal32V3_Float_notn_2 """
		select id, kdcml32v3 DIV kfloat from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal32V3_Float_3 """
		select id, kdcml32v3 & kfloat, kdcml32v3 | kfloat, kdcml32v3 ^ kfloat from expr_test order by id"""
	qt_sql_test_Decimal32V3_Float_notn_3 """
		select id, kdcml32v3 & kfloat, kdcml32v3 | kfloat, kdcml32v3 ^ kfloat from expr_test_not_nullable order by id"""
	// qt_sql_test_Decimal32V3_Float_4 """
	// 	select id, BITAND(kdcml32v3, kfloat), BITOR(kdcml32v3, kfloat), BITXOR(kdcml32v3, kfloat) from expr_test order by id"""
	// qt_sql_test_Decimal32V3_Float_notn_4 """
	// 	select id, BITAND(kdcml32v3, kfloat), BITOR(kdcml32v3, kfloat), BITXOR(kdcml32v3, kfloat) from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal32V3_Double_0 """
		select id, kdcml32v3 + kdbl, kdcml32v3 - kdbl from expr_test order by id"""
	qt_sql_test_Decimal32V3_Double_notn_0 """
		select id, kdcml32v3 + kdbl, kdcml32v3 - kdbl from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal32V3_Double_1 """
		select id, kdcml32v3 * kdbl, kdcml32v3 / kdbl, kdcml32v3 % kdbl from expr_test order by id"""
	qt_sql_test_Decimal32V3_Double_notn_1 """
		select id, kdcml32v3 * kdbl, kdcml32v3 / kdbl, kdcml32v3 % kdbl from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal32V3_Double_2 """
		select id, kdcml32v3 DIV kdbl from expr_test order by id"""
	qt_sql_test_Decimal32V3_Double_notn_2 """
		select id, kdcml32v3 DIV kdbl from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal32V3_Double_3 """
		select id, kdcml32v3 & kdbl, kdcml32v3 | kdbl, kdcml32v3 ^ kdbl from expr_test order by id"""
	qt_sql_test_Decimal32V3_Double_notn_3 """
		select id, kdcml32v3 & kdbl, kdcml32v3 | kdbl, kdcml32v3 ^ kdbl from expr_test_not_nullable order by id"""
	// qt_sql_test_Decimal32V3_Double_4 """
	// 	select id, BITAND(kdcml32v3, kdbl), BITOR(kdcml32v3, kdbl), BITXOR(kdcml32v3, kdbl) from expr_test order by id"""
	// qt_sql_test_Decimal32V3_Double_notn_4 """
	// 	select id, BITAND(kdcml32v3, kdbl), BITOR(kdcml32v3, kdbl), BITXOR(kdcml32v3, kdbl) from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal32V3_DecimalV2_0 """
		select id, kdcml32v3 + kdcml, kdcml32v3 - kdcml from expr_test order by id"""
	qt_sql_test_Decimal32V3_DecimalV2_notn_0 """
		select id, kdcml32v3 + kdcml, kdcml32v3 - kdcml from expr_test_not_nullable order by id"""
	//original planner  qt_sql_test_Decimal32V3_DecimalV2_1 """
	//original planner  	select id, kdcml32v3 * kdcml, kdcml32v3 / kdcml, kdcml32v3 % kdcml from expr_test order by id"""
	//original planner  qt_sql_test_Decimal32V3_DecimalV2_notn_1 """
	//original planner  	select id, kdcml32v3 * kdcml, kdcml32v3 / kdcml, kdcml32v3 % kdcml from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal32V3_DecimalV2_2 """
		select id, kdcml32v3 DIV kdcml from expr_test order by id"""
	qt_sql_test_Decimal32V3_DecimalV2_notn_2 """
		select id, kdcml32v3 DIV kdcml from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal32V3_DecimalV2_3 """
		select id, kdcml32v3 & kdcml, kdcml32v3 | kdcml, kdcml32v3 ^ kdcml from expr_test order by id"""
	qt_sql_test_Decimal32V3_DecimalV2_notn_3 """
		select id, kdcml32v3 & kdcml, kdcml32v3 | kdcml, kdcml32v3 ^ kdcml from expr_test_not_nullable order by id"""
	// qt_sql_test_Decimal32V3_DecimalV2_4 """
	// 	select id, BITAND(kdcml32v3, kdcml), BITOR(kdcml32v3, kdcml), BITXOR(kdcml32v3, kdcml) from expr_test order by id"""
	// qt_sql_test_Decimal32V3_DecimalV2_notn_4 """
	// 	select id, BITAND(kdcml32v3, kdcml), BITOR(kdcml32v3, kdcml), BITXOR(kdcml32v3, kdcml) from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal32V3_Decimal32V3_0 """
		select id, kdcml32v3 + kdcml32v3, kdcml32v3 - kdcml32v3 from expr_test order by id"""
	qt_sql_test_Decimal32V3_Decimal32V3_notn_0 """
		select id, kdcml32v3 + kdcml32v3, kdcml32v3 - kdcml32v3 from expr_test_not_nullable order by id"""
	//original planner  qt_sql_test_Decimal32V3_Decimal32V3_1 """
	//original planner  	select id, kdcml32v3 * kdcml32v3, kdcml32v3 / kdcml32v3, kdcml32v3 % kdcml32v3 from expr_test order by id"""
	//original planner  qt_sql_test_Decimal32V3_Decimal32V3_notn_1 """
	//original planner  	select id, kdcml32v3 * kdcml32v3, kdcml32v3 / kdcml32v3, kdcml32v3 % kdcml32v3 from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal32V3_Decimal32V3_2 """
		select id, kdcml32v3 DIV kdcml32v3 from expr_test order by id"""
	qt_sql_test_Decimal32V3_Decimal32V3_notn_2 """
		select id, kdcml32v3 DIV kdcml32v3 from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal32V3_Decimal32V3_3 """
		select id, kdcml32v3 & kdcml32v3, kdcml32v3 | kdcml32v3, kdcml32v3 ^ kdcml32v3 from expr_test order by id"""
	qt_sql_test_Decimal32V3_Decimal32V3_notn_3 """
		select id, kdcml32v3 & kdcml32v3, kdcml32v3 | kdcml32v3, kdcml32v3 ^ kdcml32v3 from expr_test_not_nullable order by id"""
	// qt_sql_test_Decimal32V3_Decimal32V3_4 """
	// 	select id, BITAND(kdcml32v3, kdcml32v3), BITOR(kdcml32v3, kdcml32v3), BITXOR(kdcml32v3, kdcml32v3) from expr_test order by id"""
	// qt_sql_test_Decimal32V3_Decimal32V3_notn_4 """
	// 	select id, BITAND(kdcml32v3, kdcml32v3), BITOR(kdcml32v3, kdcml32v3), BITXOR(kdcml32v3, kdcml32v3) from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal32V3_Decimal64V3_0 """
		select id, kdcml32v3 + kdcml64v3, kdcml32v3 - kdcml64v3 from expr_test order by id"""
	qt_sql_test_Decimal32V3_Decimal64V3_notn_0 """
		select id, kdcml32v3 + kdcml64v3, kdcml32v3 - kdcml64v3 from expr_test_not_nullable order by id"""
	//original planner  qt_sql_test_Decimal32V3_Decimal64V3_1 """
	//original planner  	select id, kdcml32v3 * kdcml64v3, kdcml32v3 / kdcml64v3, kdcml32v3 % kdcml64v3 from expr_test order by id"""
	//original planner  qt_sql_test_Decimal32V3_Decimal64V3_notn_1 """
	//original planner  	select id, kdcml32v3 * kdcml64v3, kdcml32v3 / kdcml64v3, kdcml32v3 % kdcml64v3 from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal32V3_Decimal64V3_2 """
		select id, kdcml32v3 DIV kdcml64v3 from expr_test order by id"""
	qt_sql_test_Decimal32V3_Decimal64V3_notn_2 """
		select id, kdcml32v3 DIV kdcml64v3 from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal32V3_Decimal64V3_3 """
		select id, kdcml32v3 & kdcml64v3, kdcml32v3 | kdcml64v3, kdcml32v3 ^ kdcml64v3 from expr_test order by id"""
	qt_sql_test_Decimal32V3_Decimal64V3_notn_3 """
		select id, kdcml32v3 & kdcml64v3, kdcml32v3 | kdcml64v3, kdcml32v3 ^ kdcml64v3 from expr_test_not_nullable order by id"""
	// qt_sql_test_Decimal32V3_Decimal64V3_4 """
	// 	select id, BITAND(kdcml32v3, kdcml64v3), BITOR(kdcml32v3, kdcml64v3), BITXOR(kdcml32v3, kdcml64v3) from expr_test order by id"""
	// qt_sql_test_Decimal32V3_Decimal64V3_notn_4 """
	// 	select id, BITAND(kdcml32v3, kdcml64v3), BITOR(kdcml32v3, kdcml64v3), BITXOR(kdcml32v3, kdcml64v3) from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal32V3_Decimal128V3_0 """
		select id, kdcml32v3 + kdcml128v3, kdcml32v3 - kdcml128v3 from expr_test order by id"""
	qt_sql_test_Decimal32V3_Decimal128V3_notn_0 """
		select id, kdcml32v3 + kdcml128v3, kdcml32v3 - kdcml128v3 from expr_test_not_nullable order by id"""
	//original planner  qt_sql_test_Decimal32V3_Decimal128V3_1 """
	//original planner  	select id, kdcml32v3 * kdcml128v3, kdcml32v3 / kdcml128v3, kdcml32v3 % kdcml128v3 from expr_test order by id"""
	//original planner  qt_sql_test_Decimal32V3_Decimal128V3_notn_1 """
	//original planner  	select id, kdcml32v3 * kdcml128v3, kdcml32v3 / kdcml128v3, kdcml32v3 % kdcml128v3 from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal32V3_Decimal128V3_2 """
		select id, kdcml32v3 DIV kdcml128v3 from expr_test order by id"""
	qt_sql_test_Decimal32V3_Decimal128V3_notn_2 """
		select id, kdcml32v3 DIV kdcml128v3 from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal32V3_Decimal128V3_3 """
		select id, kdcml32v3 & kdcml128v3, kdcml32v3 | kdcml128v3, kdcml32v3 ^ kdcml128v3 from expr_test order by id"""
	qt_sql_test_Decimal32V3_Decimal128V3_notn_3 """
		select id, kdcml32v3 & kdcml128v3, kdcml32v3 | kdcml128v3, kdcml32v3 ^ kdcml128v3 from expr_test_not_nullable order by id"""
	// qt_sql_test_Decimal32V3_Decimal128V3_4 """
	// 	select id, BITAND(kdcml32v3, kdcml128v3), BITOR(kdcml32v3, kdcml128v3), BITXOR(kdcml32v3, kdcml128v3) from expr_test order by id"""
	// qt_sql_test_Decimal32V3_Decimal128V3_notn_4 """
	// 	select id, BITAND(kdcml32v3, kdcml128v3), BITOR(kdcml32v3, kdcml128v3), BITXOR(kdcml32v3, kdcml128v3) from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal32V3_Char_0 """
		select id, kdcml32v3 + kchr, kdcml32v3 - kchr from expr_test order by id"""
	qt_sql_test_Decimal32V3_Char_notn_0 """
		select id, kdcml32v3 + kchr, kdcml32v3 - kchr from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal32V3_Char_1 """
		select id, kdcml32v3 * kchr, kdcml32v3 / kchr, kdcml32v3 % kchr from expr_test order by id"""
	qt_sql_test_Decimal32V3_Char_notn_1 """
		select id, kdcml32v3 * kchr, kdcml32v3 / kchr, kdcml32v3 % kchr from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal32V3_Char_2 """
		select id, kdcml32v3 DIV kchr from expr_test order by id"""
	qt_sql_test_Decimal32V3_Char_notn_2 """
		select id, kdcml32v3 DIV kchr from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal32V3_Char_3 """
		select id, kdcml32v3 & kchr, kdcml32v3 | kchr, kdcml32v3 ^ kchr from expr_test order by id"""
	qt_sql_test_Decimal32V3_Char_notn_3 """
		select id, kdcml32v3 & kchr, kdcml32v3 | kchr, kdcml32v3 ^ kchr from expr_test_not_nullable order by id"""
	// qt_sql_test_Decimal32V3_Char_4 """
	// 	select id, BITAND(kdcml32v3, kchr), BITOR(kdcml32v3, kchr), BITXOR(kdcml32v3, kchr) from expr_test order by id"""
	// qt_sql_test_Decimal32V3_Char_notn_4 """
	// 	select id, BITAND(kdcml32v3, kchr), BITOR(kdcml32v3, kchr), BITXOR(kdcml32v3, kchr) from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal32V3_Varchar_0 """
		select id, kdcml32v3 + kvchr, kdcml32v3 - kvchr from expr_test order by id"""
	qt_sql_test_Decimal32V3_Varchar_notn_0 """
		select id, kdcml32v3 + kvchr, kdcml32v3 - kvchr from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal32V3_Varchar_1 """
		select id, kdcml32v3 * kvchr, kdcml32v3 / kvchr, kdcml32v3 % kvchr from expr_test order by id"""
	qt_sql_test_Decimal32V3_Varchar_notn_1 """
		select id, kdcml32v3 * kvchr, kdcml32v3 / kvchr, kdcml32v3 % kvchr from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal32V3_Varchar_2 """
		select id, kdcml32v3 DIV kvchr from expr_test order by id"""
	qt_sql_test_Decimal32V3_Varchar_notn_2 """
		select id, kdcml32v3 DIV kvchr from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal32V3_Varchar_3 """
		select id, kdcml32v3 & kvchr, kdcml32v3 | kvchr, kdcml32v3 ^ kvchr from expr_test order by id"""
	qt_sql_test_Decimal32V3_Varchar_notn_3 """
		select id, kdcml32v3 & kvchr, kdcml32v3 | kvchr, kdcml32v3 ^ kvchr from expr_test_not_nullable order by id"""
	// qt_sql_test_Decimal32V3_Varchar_4 """
	// 	select id, BITAND(kdcml32v3, kvchr), BITOR(kdcml32v3, kvchr), BITXOR(kdcml32v3, kvchr) from expr_test order by id"""
	// qt_sql_test_Decimal32V3_Varchar_notn_4 """
	// 	select id, BITAND(kdcml32v3, kvchr), BITOR(kdcml32v3, kvchr), BITXOR(kdcml32v3, kvchr) from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal32V3_String_0 """
		select id, kdcml32v3 + kstr, kdcml32v3 - kstr from expr_test order by id"""
	qt_sql_test_Decimal32V3_String_notn_0 """
		select id, kdcml32v3 + kstr, kdcml32v3 - kstr from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal32V3_String_1 """
		select id, kdcml32v3 * kstr, kdcml32v3 / kstr, kdcml32v3 % kstr from expr_test order by id"""
	qt_sql_test_Decimal32V3_String_notn_1 """
		select id, kdcml32v3 * kstr, kdcml32v3 / kstr, kdcml32v3 % kstr from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal32V3_String_2 """
		select id, kdcml32v3 DIV kstr from expr_test order by id"""
	qt_sql_test_Decimal32V3_String_notn_2 """
		select id, kdcml32v3 DIV kstr from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal32V3_String_3 """
		select id, kdcml32v3 & kstr, kdcml32v3 | kstr, kdcml32v3 ^ kstr from expr_test order by id"""
	qt_sql_test_Decimal32V3_String_notn_3 """
		select id, kdcml32v3 & kstr, kdcml32v3 | kstr, kdcml32v3 ^ kstr from expr_test_not_nullable order by id"""
	// qt_sql_test_Decimal32V3_String_4 """
	// 	select id, BITAND(kdcml32v3, kstr), BITOR(kdcml32v3, kstr), BITXOR(kdcml32v3, kstr) from expr_test order by id"""
	// qt_sql_test_Decimal32V3_String_notn_4 """
	// 	select id, BITAND(kdcml32v3, kstr), BITOR(kdcml32v3, kstr), BITXOR(kdcml32v3, kstr) from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal32V3_Date_0 """
		select id, kdcml32v3 + kdt, kdcml32v3 - kdt from expr_test order by id"""
	qt_sql_test_Decimal32V3_Date_notn_0 """
		select id, kdcml32v3 + kdt, kdcml32v3 - kdt from expr_test_not_nullable order by id"""
	//original planner  qt_sql_test_Decimal32V3_Date_1 """
	//original planner  	select id, kdcml32v3 * kdt, kdcml32v3 / kdt, kdcml32v3 % kdt from expr_test order by id"""
	//original planner  qt_sql_test_Decimal32V3_Date_notn_1 """
	//original planner  	select id, kdcml32v3 * kdt, kdcml32v3 / kdt, kdcml32v3 % kdt from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal32V3_Date_2 """
		select id, kdcml32v3 DIV kdt from expr_test order by id"""
	qt_sql_test_Decimal32V3_Date_notn_2 """
		select id, kdcml32v3 DIV kdt from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal32V3_Date_3 """
		select id, kdcml32v3 & kdt, kdcml32v3 | kdt, kdcml32v3 ^ kdt from expr_test order by id"""
	qt_sql_test_Decimal32V3_Date_notn_3 """
		select id, kdcml32v3 & kdt, kdcml32v3 | kdt, kdcml32v3 ^ kdt from expr_test_not_nullable order by id"""
	// qt_sql_test_Decimal32V3_Date_4 """
	// 	select id, BITAND(kdcml32v3, kdt), BITOR(kdcml32v3, kdt), BITXOR(kdcml32v3, kdt) from expr_test order by id"""
	// qt_sql_test_Decimal32V3_Date_notn_4 """
	// 	select id, BITAND(kdcml32v3, kdt), BITOR(kdcml32v3, kdt), BITXOR(kdcml32v3, kdt) from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal32V3_DateTime_0 """
		select id, kdcml32v3 + kdtm, kdcml32v3 - kdtm from expr_test order by id"""
	qt_sql_test_Decimal32V3_DateTime_notn_0 """
		select id, kdcml32v3 + kdtm, kdcml32v3 - kdtm from expr_test_not_nullable order by id"""
	//original planner  qt_sql_test_Decimal32V3_DateTime_1 """
	//original planner  	select id, kdcml32v3 * kdtm, kdcml32v3 / kdtm, kdcml32v3 % kdtm from expr_test order by id"""
	//original planner  qt_sql_test_Decimal32V3_DateTime_notn_1 """
	//original planner  	select id, kdcml32v3 * kdtm, kdcml32v3 / kdtm, kdcml32v3 % kdtm from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal32V3_DateTime_2 """
		select id, kdcml32v3 DIV kdtm from expr_test order by id"""
	qt_sql_test_Decimal32V3_DateTime_notn_2 """
		select id, kdcml32v3 DIV kdtm from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal32V3_DateTime_3 """
		select id, kdcml32v3 & kdtm, kdcml32v3 | kdtm, kdcml32v3 ^ kdtm from expr_test order by id"""
	qt_sql_test_Decimal32V3_DateTime_notn_3 """
		select id, kdcml32v3 & kdtm, kdcml32v3 | kdtm, kdcml32v3 ^ kdtm from expr_test_not_nullable order by id"""
	// qt_sql_test_Decimal32V3_DateTime_4 """
	// 	select id, BITAND(kdcml32v3, kdtm), BITOR(kdcml32v3, kdtm), BITXOR(kdcml32v3, kdtm) from expr_test order by id"""
	// qt_sql_test_Decimal32V3_DateTime_notn_4 """
	// 	select id, BITAND(kdcml32v3, kdtm), BITOR(kdcml32v3, kdtm), BITXOR(kdcml32v3, kdtm) from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal32V3_DateV2_0 """
		select id, kdcml32v3 + kdtv2, kdcml32v3 - kdtv2 from expr_test order by id"""
	qt_sql_test_Decimal32V3_DateV2_notn_0 """
		select id, kdcml32v3 + kdtv2, kdcml32v3 - kdtv2 from expr_test_not_nullable order by id"""
	//original planner  qt_sql_test_Decimal32V3_DateV2_1 """
	//original planner  	select id, kdcml32v3 * kdtv2, kdcml32v3 / kdtv2, kdcml32v3 % kdtv2 from expr_test order by id"""
	//original planner  qt_sql_test_Decimal32V3_DateV2_notn_1 """
	//original planner  	select id, kdcml32v3 * kdtv2, kdcml32v3 / kdtv2, kdcml32v3 % kdtv2 from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal32V3_DateV2_2 """
		select id, kdcml32v3 DIV kdtv2 from expr_test order by id"""
	qt_sql_test_Decimal32V3_DateV2_notn_2 """
		select id, kdcml32v3 DIV kdtv2 from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal32V3_DateV2_3 """
		select id, kdcml32v3 & kdtv2, kdcml32v3 | kdtv2, kdcml32v3 ^ kdtv2 from expr_test order by id"""
	qt_sql_test_Decimal32V3_DateV2_notn_3 """
		select id, kdcml32v3 & kdtv2, kdcml32v3 | kdtv2, kdcml32v3 ^ kdtv2 from expr_test_not_nullable order by id"""
	// qt_sql_test_Decimal32V3_DateV2_4 """
	// 	select id, BITAND(kdcml32v3, kdtv2), BITOR(kdcml32v3, kdtv2), BITXOR(kdcml32v3, kdtv2) from expr_test order by id"""
	// qt_sql_test_Decimal32V3_DateV2_notn_4 """
	// 	select id, BITAND(kdcml32v3, kdtv2), BITOR(kdcml32v3, kdtv2), BITXOR(kdcml32v3, kdtv2) from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal32V3_DateTimeV2_0 """
		select id, kdcml32v3 + kdtmv2, kdcml32v3 - kdtmv2 from expr_test order by id"""
	qt_sql_test_Decimal32V3_DateTimeV2_notn_0 """
		select id, kdcml32v3 + kdtmv2, kdcml32v3 - kdtmv2 from expr_test_not_nullable order by id"""
	//original planner  qt_sql_test_Decimal32V3_DateTimeV2_1 """
	//original planner  	select id, kdcml32v3 * kdtmv2, kdcml32v3 / kdtmv2, kdcml32v3 % kdtmv2 from expr_test order by id"""
	//original planner  qt_sql_test_Decimal32V3_DateTimeV2_notn_1 """
	//original planner  	select id, kdcml32v3 * kdtmv2, kdcml32v3 / kdtmv2, kdcml32v3 % kdtmv2 from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal32V3_DateTimeV2_2 """
		select id, kdcml32v3 DIV kdtmv2 from expr_test order by id"""
	qt_sql_test_Decimal32V3_DateTimeV2_notn_2 """
		select id, kdcml32v3 DIV kdtmv2 from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal32V3_DateTimeV2_3 """
		select id, kdcml32v3 & kdtmv2, kdcml32v3 | kdtmv2, kdcml32v3 ^ kdtmv2 from expr_test order by id"""
	qt_sql_test_Decimal32V3_DateTimeV2_notn_3 """
		select id, kdcml32v3 & kdtmv2, kdcml32v3 | kdtmv2, kdcml32v3 ^ kdtmv2 from expr_test_not_nullable order by id"""
	// qt_sql_test_Decimal32V3_DateTimeV2_4 """
	// 	select id, BITAND(kdcml32v3, kdtmv2), BITOR(kdcml32v3, kdtmv2), BITXOR(kdcml32v3, kdtmv2) from expr_test order by id"""
	// qt_sql_test_Decimal32V3_DateTimeV2_notn_4 """
	// 	select id, BITAND(kdcml32v3, kdtmv2), BITOR(kdcml32v3, kdtmv2), BITXOR(kdcml32v3, kdtmv2) from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal32V3_Boolean_0 """
		select id, kdcml32v3 + kbool, kdcml32v3 - kbool from expr_test order by id"""
	qt_sql_test_Decimal32V3_Boolean_notn_0 """
		select id, kdcml32v3 + kbool, kdcml32v3 - kbool from expr_test_not_nullable order by id"""
	//original planner  qt_sql_test_Decimal32V3_Boolean_1 """
	//original planner  	select id, kdcml32v3 * kbool, kdcml32v3 / kbool, kdcml32v3 % kbool from expr_test order by id"""
	//original planner  qt_sql_test_Decimal32V3_Boolean_notn_1 """
	//original planner  	select id, kdcml32v3 * kbool, kdcml32v3 / kbool, kdcml32v3 % kbool from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal32V3_Boolean_2 """
		select id, kdcml32v3 DIV kbool from expr_test order by id"""
	qt_sql_test_Decimal32V3_Boolean_notn_2 """
		select id, kdcml32v3 DIV kbool from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal32V3_Boolean_3 """
		select id, kdcml32v3 & kbool, kdcml32v3 | kbool, kdcml32v3 ^ kbool from expr_test order by id"""
	qt_sql_test_Decimal32V3_Boolean_notn_3 """
		select id, kdcml32v3 & kbool, kdcml32v3 | kbool, kdcml32v3 ^ kbool from expr_test_not_nullable order by id"""
	// qt_sql_test_Decimal32V3_Boolean_4 """
	// 	select id, BITAND(kdcml32v3, kbool), BITOR(kdcml32v3, kbool), BITXOR(kdcml32v3, kbool) from expr_test order by id"""
	// qt_sql_test_Decimal32V3_Boolean_notn_4 """
	// 	select id, BITAND(kdcml32v3, kbool), BITOR(kdcml32v3, kbool), BITXOR(kdcml32v3, kbool) from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal64V3_TinyInt_0 """
		select id, kdcml64v3 + ktint, kdcml64v3 - ktint from expr_test order by id"""
	qt_sql_test_Decimal64V3_TinyInt_notn_0 """
		select id, kdcml64v3 + ktint, kdcml64v3 - ktint from expr_test_not_nullable order by id"""
	//original planner  qt_sql_test_Decimal64V3_TinyInt_1 """
	//original planner  	select id, kdcml64v3 * ktint, kdcml64v3 / ktint, kdcml64v3 % ktint from expr_test order by id"""
	//original planner  qt_sql_test_Decimal64V3_TinyInt_notn_1 """
	//original planner  	select id, kdcml64v3 * ktint, kdcml64v3 / ktint, kdcml64v3 % ktint from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal64V3_TinyInt_2 """
		select id, kdcml64v3 DIV ktint from expr_test order by id"""
	qt_sql_test_Decimal64V3_TinyInt_notn_2 """
		select id, kdcml64v3 DIV ktint from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal64V3_TinyInt_3 """
		select id, kdcml64v3 & ktint, kdcml64v3 | ktint, kdcml64v3 ^ ktint from expr_test order by id"""
	qt_sql_test_Decimal64V3_TinyInt_notn_3 """
		select id, kdcml64v3 & ktint, kdcml64v3 | ktint, kdcml64v3 ^ ktint from expr_test_not_nullable order by id"""
	// qt_sql_test_Decimal64V3_TinyInt_4 """
	// 	select id, BITAND(kdcml64v3, ktint), BITOR(kdcml64v3, ktint), BITXOR(kdcml64v3, ktint) from expr_test order by id"""
	// qt_sql_test_Decimal64V3_TinyInt_notn_4 """
	// 	select id, BITAND(kdcml64v3, ktint), BITOR(kdcml64v3, ktint), BITXOR(kdcml64v3, ktint) from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal64V3_SmallInt_0 """
		select id, kdcml64v3 + ksint, kdcml64v3 - ksint from expr_test order by id"""
	qt_sql_test_Decimal64V3_SmallInt_notn_0 """
		select id, kdcml64v3 + ksint, kdcml64v3 - ksint from expr_test_not_nullable order by id"""
	//original planner  qt_sql_test_Decimal64V3_SmallInt_1 """
	//original planner  	select id, kdcml64v3 * ksint, kdcml64v3 / ksint, kdcml64v3 % ksint from expr_test order by id"""
	//original planner  qt_sql_test_Decimal64V3_SmallInt_notn_1 """
	//original planner  	select id, kdcml64v3 * ksint, kdcml64v3 / ksint, kdcml64v3 % ksint from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal64V3_SmallInt_2 """
		select id, kdcml64v3 DIV ksint from expr_test order by id"""
	qt_sql_test_Decimal64V3_SmallInt_notn_2 """
		select id, kdcml64v3 DIV ksint from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal64V3_SmallInt_3 """
		select id, kdcml64v3 & ksint, kdcml64v3 | ksint, kdcml64v3 ^ ksint from expr_test order by id"""
	qt_sql_test_Decimal64V3_SmallInt_notn_3 """
		select id, kdcml64v3 & ksint, kdcml64v3 | ksint, kdcml64v3 ^ ksint from expr_test_not_nullable order by id"""
	// qt_sql_test_Decimal64V3_SmallInt_4 """
	// 	select id, BITAND(kdcml64v3, ksint), BITOR(kdcml64v3, ksint), BITXOR(kdcml64v3, ksint) from expr_test order by id"""
	// qt_sql_test_Decimal64V3_SmallInt_notn_4 """
	// 	select id, BITAND(kdcml64v3, ksint), BITOR(kdcml64v3, ksint), BITXOR(kdcml64v3, ksint) from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal64V3_Integer_0 """
		select id, kdcml64v3 + kint, kdcml64v3 - kint from expr_test order by id"""
	qt_sql_test_Decimal64V3_Integer_notn_0 """
		select id, kdcml64v3 + kint, kdcml64v3 - kint from expr_test_not_nullable order by id"""
	//original planner  qt_sql_test_Decimal64V3_Integer_1 """
	//original planner  	select id, kdcml64v3 * kint, kdcml64v3 / kint, kdcml64v3 % kint from expr_test order by id"""
	//original planner  qt_sql_test_Decimal64V3_Integer_notn_1 """
	//original planner  	select id, kdcml64v3 * kint, kdcml64v3 / kint, kdcml64v3 % kint from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal64V3_Integer_2 """
		select id, kdcml64v3 DIV kint from expr_test order by id"""
	qt_sql_test_Decimal64V3_Integer_notn_2 """
		select id, kdcml64v3 DIV kint from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal64V3_Integer_3 """
		select id, kdcml64v3 & kint, kdcml64v3 | kint, kdcml64v3 ^ kint from expr_test order by id"""
	qt_sql_test_Decimal64V3_Integer_notn_3 """
		select id, kdcml64v3 & kint, kdcml64v3 | kint, kdcml64v3 ^ kint from expr_test_not_nullable order by id"""
	// qt_sql_test_Decimal64V3_Integer_4 """
	// 	select id, BITAND(kdcml64v3, kint), BITOR(kdcml64v3, kint), BITXOR(kdcml64v3, kint) from expr_test order by id"""
	// qt_sql_test_Decimal64V3_Integer_notn_4 """
	// 	select id, BITAND(kdcml64v3, kint), BITOR(kdcml64v3, kint), BITXOR(kdcml64v3, kint) from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal64V3_BigInt_0 """
		select id, kdcml64v3 + kbint, kdcml64v3 - kbint from expr_test order by id"""
	qt_sql_test_Decimal64V3_BigInt_notn_0 """
		select id, kdcml64v3 + kbint, kdcml64v3 - kbint from expr_test_not_nullable order by id"""
	//original planner  qt_sql_test_Decimal64V3_BigInt_1 """
	//original planner  	select id, kdcml64v3 * kbint, kdcml64v3 / kbint, kdcml64v3 % kbint from expr_test order by id"""
	//original planner  qt_sql_test_Decimal64V3_BigInt_notn_1 """
	//original planner  	select id, kdcml64v3 * kbint, kdcml64v3 / kbint, kdcml64v3 % kbint from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal64V3_BigInt_2 """
		select id, kdcml64v3 DIV kbint from expr_test order by id"""
	qt_sql_test_Decimal64V3_BigInt_notn_2 """
		select id, kdcml64v3 DIV kbint from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal64V3_BigInt_3 """
		select id, kdcml64v3 & kbint, kdcml64v3 | kbint, kdcml64v3 ^ kbint from expr_test order by id"""
	qt_sql_test_Decimal64V3_BigInt_notn_3 """
		select id, kdcml64v3 & kbint, kdcml64v3 | kbint, kdcml64v3 ^ kbint from expr_test_not_nullable order by id"""
	// qt_sql_test_Decimal64V3_BigInt_4 """
	// 	select id, BITAND(kdcml64v3, kbint), BITOR(kdcml64v3, kbint), BITXOR(kdcml64v3, kbint) from expr_test order by id"""
	// qt_sql_test_Decimal64V3_BigInt_notn_4 """
	// 	select id, BITAND(kdcml64v3, kbint), BITOR(kdcml64v3, kbint), BITXOR(kdcml64v3, kbint) from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal64V3_LargeInt_0 """
		select id, kdcml64v3 + klint, kdcml64v3 - klint from expr_test order by id"""
	qt_sql_test_Decimal64V3_LargeInt_notn_0 """
		select id, kdcml64v3 + klint, kdcml64v3 - klint from expr_test_not_nullable order by id"""
	//original planner  qt_sql_test_Decimal64V3_LargeInt_1 """
	//original planner  	select id, kdcml64v3 * klint, kdcml64v3 / klint, kdcml64v3 % klint from expr_test order by id"""
	//original planner  qt_sql_test_Decimal64V3_LargeInt_notn_1 """
	//original planner  	select id, kdcml64v3 * klint, kdcml64v3 / klint, kdcml64v3 % klint from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal64V3_LargeInt_2 """
		select id, kdcml64v3 DIV klint from expr_test order by id"""
	qt_sql_test_Decimal64V3_LargeInt_notn_2 """
		select id, kdcml64v3 DIV klint from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal64V3_LargeInt_3 """
		select id, kdcml64v3 & klint, kdcml64v3 | klint, kdcml64v3 ^ klint from expr_test order by id"""
	qt_sql_test_Decimal64V3_LargeInt_notn_3 """
		select id, kdcml64v3 & klint, kdcml64v3 | klint, kdcml64v3 ^ klint from expr_test_not_nullable order by id"""
	// qt_sql_test_Decimal64V3_LargeInt_4 """
	// 	select id, BITAND(kdcml64v3, klint), BITOR(kdcml64v3, klint), BITXOR(kdcml64v3, klint) from expr_test order by id"""
	// qt_sql_test_Decimal64V3_LargeInt_notn_4 """
	// 	select id, BITAND(kdcml64v3, klint), BITOR(kdcml64v3, klint), BITXOR(kdcml64v3, klint) from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal64V3_Float_0 """
		select id, kdcml64v3 + kfloat, kdcml64v3 - kfloat from expr_test order by id"""
	qt_sql_test_Decimal64V3_Float_notn_0 """
		select id, kdcml64v3 + kfloat, kdcml64v3 - kfloat from expr_test_not_nullable order by id"""
	// qt_sql_test_Decimal64V3_Float_1 """
	// 	select id, kdcml64v3 * kfloat, kdcml64v3 / kfloat, kdcml64v3 % kfloat from expr_test order by id"""
	// qt_sql_test_Decimal64V3_Float_notn_1 """
	// 	select id, kdcml64v3 * kfloat, kdcml64v3 / kfloat, kdcml64v3 % kfloat from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal64V3_Float_2 """
		select id, kdcml64v3 DIV kfloat from expr_test order by id"""
	qt_sql_test_Decimal64V3_Float_notn_2 """
		select id, kdcml64v3 DIV kfloat from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal64V3_Float_3 """
		select id, kdcml64v3 & kfloat, kdcml64v3 | kfloat, kdcml64v3 ^ kfloat from expr_test order by id"""
	qt_sql_test_Decimal64V3_Float_notn_3 """
		select id, kdcml64v3 & kfloat, kdcml64v3 | kfloat, kdcml64v3 ^ kfloat from expr_test_not_nullable order by id"""
	// qt_sql_test_Decimal64V3_Float_4 """
	// 	select id, BITAND(kdcml64v3, kfloat), BITOR(kdcml64v3, kfloat), BITXOR(kdcml64v3, kfloat) from expr_test order by id"""
	// qt_sql_test_Decimal64V3_Float_notn_4 """
	// 	select id, BITAND(kdcml64v3, kfloat), BITOR(kdcml64v3, kfloat), BITXOR(kdcml64v3, kfloat) from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal64V3_Double_0 """
		select id, kdcml64v3 + kdbl, kdcml64v3 - kdbl from expr_test order by id"""
	qt_sql_test_Decimal64V3_Double_notn_0 """
		select id, kdcml64v3 + kdbl, kdcml64v3 - kdbl from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal64V3_Double_1 """
		select id, kdcml64v3 * kdbl, kdcml64v3 / kdbl, kdcml64v3 % kdbl from expr_test order by id"""
	qt_sql_test_Decimal64V3_Double_notn_1 """
		select id, kdcml64v3 * kdbl, kdcml64v3 / kdbl, kdcml64v3 % kdbl from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal64V3_Double_2 """
		select id, kdcml64v3 DIV kdbl from expr_test order by id"""
	qt_sql_test_Decimal64V3_Double_notn_2 """
		select id, kdcml64v3 DIV kdbl from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal64V3_Double_3 """
		select id, kdcml64v3 & kdbl, kdcml64v3 | kdbl, kdcml64v3 ^ kdbl from expr_test order by id"""
	qt_sql_test_Decimal64V3_Double_notn_3 """
		select id, kdcml64v3 & kdbl, kdcml64v3 | kdbl, kdcml64v3 ^ kdbl from expr_test_not_nullable order by id"""
	// qt_sql_test_Decimal64V3_Double_4 """
	// 	select id, BITAND(kdcml64v3, kdbl), BITOR(kdcml64v3, kdbl), BITXOR(kdcml64v3, kdbl) from expr_test order by id"""
	// qt_sql_test_Decimal64V3_Double_notn_4 """
	// 	select id, BITAND(kdcml64v3, kdbl), BITOR(kdcml64v3, kdbl), BITXOR(kdcml64v3, kdbl) from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal64V3_DecimalV2_0 """
		select id, kdcml64v3 + kdcml, kdcml64v3 - kdcml from expr_test order by id"""
	qt_sql_test_Decimal64V3_DecimalV2_notn_0 """
		select id, kdcml64v3 + kdcml, kdcml64v3 - kdcml from expr_test_not_nullable order by id"""
	//original planner  qt_sql_test_Decimal64V3_DecimalV2_1 """
	//original planner  	select id, kdcml64v3 * kdcml, kdcml64v3 / kdcml, kdcml64v3 % kdcml from expr_test order by id"""
	//original planner  qt_sql_test_Decimal64V3_DecimalV2_notn_1 """
	//original planner  	select id, kdcml64v3 * kdcml, kdcml64v3 / kdcml, kdcml64v3 % kdcml from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal64V3_DecimalV2_2 """
		select id, kdcml64v3 DIV kdcml from expr_test order by id"""
	qt_sql_test_Decimal64V3_DecimalV2_notn_2 """
		select id, kdcml64v3 DIV kdcml from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal64V3_DecimalV2_3 """
		select id, kdcml64v3 & kdcml, kdcml64v3 | kdcml, kdcml64v3 ^ kdcml from expr_test order by id"""
	qt_sql_test_Decimal64V3_DecimalV2_notn_3 """
		select id, kdcml64v3 & kdcml, kdcml64v3 | kdcml, kdcml64v3 ^ kdcml from expr_test_not_nullable order by id"""
	// qt_sql_test_Decimal64V3_DecimalV2_4 """
	// 	select id, BITAND(kdcml64v3, kdcml), BITOR(kdcml64v3, kdcml), BITXOR(kdcml64v3, kdcml) from expr_test order by id"""
	// qt_sql_test_Decimal64V3_DecimalV2_notn_4 """
	// 	select id, BITAND(kdcml64v3, kdcml), BITOR(kdcml64v3, kdcml), BITXOR(kdcml64v3, kdcml) from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal64V3_Decimal32V3_0 """
		select id, kdcml64v3 + kdcml32v3, kdcml64v3 - kdcml32v3 from expr_test order by id"""
	qt_sql_test_Decimal64V3_Decimal32V3_notn_0 """
		select id, kdcml64v3 + kdcml32v3, kdcml64v3 - kdcml32v3 from expr_test_not_nullable order by id"""
	//original planner  qt_sql_test_Decimal64V3_Decimal32V3_1 """
	//original planner  	select id, kdcml64v3 * kdcml32v3, kdcml64v3 / kdcml32v3, kdcml64v3 % kdcml32v3 from expr_test order by id"""
	//original planner  qt_sql_test_Decimal64V3_Decimal32V3_notn_1 """
	//original planner  	select id, kdcml64v3 * kdcml32v3, kdcml64v3 / kdcml32v3, kdcml64v3 % kdcml32v3 from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal64V3_Decimal32V3_2 """
		select id, kdcml64v3 DIV kdcml32v3 from expr_test order by id"""
	qt_sql_test_Decimal64V3_Decimal32V3_notn_2 """
		select id, kdcml64v3 DIV kdcml32v3 from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal64V3_Decimal32V3_3 """
		select id, kdcml64v3 & kdcml32v3, kdcml64v3 | kdcml32v3, kdcml64v3 ^ kdcml32v3 from expr_test order by id"""
	qt_sql_test_Decimal64V3_Decimal32V3_notn_3 """
		select id, kdcml64v3 & kdcml32v3, kdcml64v3 | kdcml32v3, kdcml64v3 ^ kdcml32v3 from expr_test_not_nullable order by id"""
	// qt_sql_test_Decimal64V3_Decimal32V3_4 """
	// 	select id, BITAND(kdcml64v3, kdcml32v3), BITOR(kdcml64v3, kdcml32v3), BITXOR(kdcml64v3, kdcml32v3) from expr_test order by id"""
	// qt_sql_test_Decimal64V3_Decimal32V3_notn_4 """
	// 	select id, BITAND(kdcml64v3, kdcml32v3), BITOR(kdcml64v3, kdcml32v3), BITXOR(kdcml64v3, kdcml32v3) from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal64V3_Decimal64V3_0 """
		select id, kdcml64v3 + kdcml64v3, kdcml64v3 - kdcml64v3 from expr_test order by id"""
	qt_sql_test_Decimal64V3_Decimal64V3_notn_0 """
		select id, kdcml64v3 + kdcml64v3, kdcml64v3 - kdcml64v3 from expr_test_not_nullable order by id"""
	//original planner  qt_sql_test_Decimal64V3_Decimal64V3_1 """
	//original planner  	select id, kdcml64v3 * kdcml64v3, kdcml64v3 / kdcml64v3, kdcml64v3 % kdcml64v3 from expr_test order by id"""
	//original planner  qt_sql_test_Decimal64V3_Decimal64V3_notn_1 """
	//original planner  	select id, kdcml64v3 * kdcml64v3, kdcml64v3 / kdcml64v3, kdcml64v3 % kdcml64v3 from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal64V3_Decimal64V3_2 """
		select id, kdcml64v3 DIV kdcml64v3 from expr_test order by id"""
	qt_sql_test_Decimal64V3_Decimal64V3_notn_2 """
		select id, kdcml64v3 DIV kdcml64v3 from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal64V3_Decimal64V3_3 """
		select id, kdcml64v3 & kdcml64v3, kdcml64v3 | kdcml64v3, kdcml64v3 ^ kdcml64v3 from expr_test order by id"""
	qt_sql_test_Decimal64V3_Decimal64V3_notn_3 """
		select id, kdcml64v3 & kdcml64v3, kdcml64v3 | kdcml64v3, kdcml64v3 ^ kdcml64v3 from expr_test_not_nullable order by id"""
	// qt_sql_test_Decimal64V3_Decimal64V3_4 """
	// 	select id, BITAND(kdcml64v3, kdcml64v3), BITOR(kdcml64v3, kdcml64v3), BITXOR(kdcml64v3, kdcml64v3) from expr_test order by id"""
	// qt_sql_test_Decimal64V3_Decimal64V3_notn_4 """
	// 	select id, BITAND(kdcml64v3, kdcml64v3), BITOR(kdcml64v3, kdcml64v3), BITXOR(kdcml64v3, kdcml64v3) from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal64V3_Decimal128V3_0 """
		select id, kdcml64v3 + kdcml128v3, kdcml64v3 - kdcml128v3 from expr_test order by id"""
	qt_sql_test_Decimal64V3_Decimal128V3_notn_0 """
		select id, kdcml64v3 + kdcml128v3, kdcml64v3 - kdcml128v3 from expr_test_not_nullable order by id"""
	//original planner  qt_sql_test_Decimal64V3_Decimal128V3_1 """
	//original planner  	select id, kdcml64v3 * kdcml128v3, kdcml64v3 / kdcml128v3, kdcml64v3 % kdcml128v3 from expr_test order by id"""
	//original planner  qt_sql_test_Decimal64V3_Decimal128V3_notn_1 """
	//original planner  	select id, kdcml64v3 * kdcml128v3, kdcml64v3 / kdcml128v3, kdcml64v3 % kdcml128v3 from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal64V3_Decimal128V3_2 """
		select id, kdcml64v3 DIV kdcml128v3 from expr_test order by id"""
	qt_sql_test_Decimal64V3_Decimal128V3_notn_2 """
		select id, kdcml64v3 DIV kdcml128v3 from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal64V3_Decimal128V3_3 """
		select id, kdcml64v3 & kdcml128v3, kdcml64v3 | kdcml128v3, kdcml64v3 ^ kdcml128v3 from expr_test order by id"""
	qt_sql_test_Decimal64V3_Decimal128V3_notn_3 """
		select id, kdcml64v3 & kdcml128v3, kdcml64v3 | kdcml128v3, kdcml64v3 ^ kdcml128v3 from expr_test_not_nullable order by id"""
	// qt_sql_test_Decimal64V3_Decimal128V3_4 """
	// 	select id, BITAND(kdcml64v3, kdcml128v3), BITOR(kdcml64v3, kdcml128v3), BITXOR(kdcml64v3, kdcml128v3) from expr_test order by id"""
	// qt_sql_test_Decimal64V3_Decimal128V3_notn_4 """
	// 	select id, BITAND(kdcml64v3, kdcml128v3), BITOR(kdcml64v3, kdcml128v3), BITXOR(kdcml64v3, kdcml128v3) from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal64V3_Char_0 """
		select id, kdcml64v3 + kchr, kdcml64v3 - kchr from expr_test order by id"""
	qt_sql_test_Decimal64V3_Char_notn_0 """
		select id, kdcml64v3 + kchr, kdcml64v3 - kchr from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal64V3_Char_1 """
		select id, kdcml64v3 * kchr, kdcml64v3 / kchr, kdcml64v3 % kchr from expr_test order by id"""
	qt_sql_test_Decimal64V3_Char_notn_1 """
		select id, kdcml64v3 * kchr, kdcml64v3 / kchr, kdcml64v3 % kchr from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal64V3_Char_2 """
		select id, kdcml64v3 DIV kchr from expr_test order by id"""
	qt_sql_test_Decimal64V3_Char_notn_2 """
		select id, kdcml64v3 DIV kchr from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal64V3_Char_3 """
		select id, kdcml64v3 & kchr, kdcml64v3 | kchr, kdcml64v3 ^ kchr from expr_test order by id"""
	qt_sql_test_Decimal64V3_Char_notn_3 """
		select id, kdcml64v3 & kchr, kdcml64v3 | kchr, kdcml64v3 ^ kchr from expr_test_not_nullable order by id"""
	// qt_sql_test_Decimal64V3_Char_4 """
	// 	select id, BITAND(kdcml64v3, kchr), BITOR(kdcml64v3, kchr), BITXOR(kdcml64v3, kchr) from expr_test order by id"""
	// qt_sql_test_Decimal64V3_Char_notn_4 """
	// 	select id, BITAND(kdcml64v3, kchr), BITOR(kdcml64v3, kchr), BITXOR(kdcml64v3, kchr) from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal64V3_Varchar_0 """
		select id, kdcml64v3 + kvchr, kdcml64v3 - kvchr from expr_test order by id"""
	qt_sql_test_Decimal64V3_Varchar_notn_0 """
		select id, kdcml64v3 + kvchr, kdcml64v3 - kvchr from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal64V3_Varchar_1 """
		select id, kdcml64v3 * kvchr, kdcml64v3 / kvchr, kdcml64v3 % kvchr from expr_test order by id"""
	qt_sql_test_Decimal64V3_Varchar_notn_1 """
		select id, kdcml64v3 * kvchr, kdcml64v3 / kvchr, kdcml64v3 % kvchr from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal64V3_Varchar_2 """
		select id, kdcml64v3 DIV kvchr from expr_test order by id"""
	qt_sql_test_Decimal64V3_Varchar_notn_2 """
		select id, kdcml64v3 DIV kvchr from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal64V3_Varchar_3 """
		select id, kdcml64v3 & kvchr, kdcml64v3 | kvchr, kdcml64v3 ^ kvchr from expr_test order by id"""
	qt_sql_test_Decimal64V3_Varchar_notn_3 """
		select id, kdcml64v3 & kvchr, kdcml64v3 | kvchr, kdcml64v3 ^ kvchr from expr_test_not_nullable order by id"""
	// qt_sql_test_Decimal64V3_Varchar_4 """
	// 	select id, BITAND(kdcml64v3, kvchr), BITOR(kdcml64v3, kvchr), BITXOR(kdcml64v3, kvchr) from expr_test order by id"""
	// qt_sql_test_Decimal64V3_Varchar_notn_4 """
	// 	select id, BITAND(kdcml64v3, kvchr), BITOR(kdcml64v3, kvchr), BITXOR(kdcml64v3, kvchr) from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal64V3_String_0 """
		select id, kdcml64v3 + kstr, kdcml64v3 - kstr from expr_test order by id"""
	qt_sql_test_Decimal64V3_String_notn_0 """
		select id, kdcml64v3 + kstr, kdcml64v3 - kstr from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal64V3_String_1 """
		select id, kdcml64v3 * kstr, kdcml64v3 / kstr, kdcml64v3 % kstr from expr_test order by id"""
	qt_sql_test_Decimal64V3_String_notn_1 """
		select id, kdcml64v3 * kstr, kdcml64v3 / kstr, kdcml64v3 % kstr from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal64V3_String_2 """
		select id, kdcml64v3 DIV kstr from expr_test order by id"""
	qt_sql_test_Decimal64V3_String_notn_2 """
		select id, kdcml64v3 DIV kstr from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal64V3_String_3 """
		select id, kdcml64v3 & kstr, kdcml64v3 | kstr, kdcml64v3 ^ kstr from expr_test order by id"""
	qt_sql_test_Decimal64V3_String_notn_3 """
		select id, kdcml64v3 & kstr, kdcml64v3 | kstr, kdcml64v3 ^ kstr from expr_test_not_nullable order by id"""
	// qt_sql_test_Decimal64V3_String_4 """
	// 	select id, BITAND(kdcml64v3, kstr), BITOR(kdcml64v3, kstr), BITXOR(kdcml64v3, kstr) from expr_test order by id"""
	// qt_sql_test_Decimal64V3_String_notn_4 """
	// 	select id, BITAND(kdcml64v3, kstr), BITOR(kdcml64v3, kstr), BITXOR(kdcml64v3, kstr) from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal64V3_Date_0 """
		select id, kdcml64v3 + kdt, kdcml64v3 - kdt from expr_test order by id"""
	qt_sql_test_Decimal64V3_Date_notn_0 """
		select id, kdcml64v3 + kdt, kdcml64v3 - kdt from expr_test_not_nullable order by id"""
	//original planner  qt_sql_test_Decimal64V3_Date_1 """
	//original planner  	select id, kdcml64v3 * kdt, kdcml64v3 / kdt, kdcml64v3 % kdt from expr_test order by id"""
	//original planner  qt_sql_test_Decimal64V3_Date_notn_1 """
	//original planner  	select id, kdcml64v3 * kdt, kdcml64v3 / kdt, kdcml64v3 % kdt from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal64V3_Date_2 """
		select id, kdcml64v3 DIV kdt from expr_test order by id"""
	qt_sql_test_Decimal64V3_Date_notn_2 """
		select id, kdcml64v3 DIV kdt from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal64V3_Date_3 """
		select id, kdcml64v3 & kdt, kdcml64v3 | kdt, kdcml64v3 ^ kdt from expr_test order by id"""
	qt_sql_test_Decimal64V3_Date_notn_3 """
		select id, kdcml64v3 & kdt, kdcml64v3 | kdt, kdcml64v3 ^ kdt from expr_test_not_nullable order by id"""
	// qt_sql_test_Decimal64V3_Date_4 """
	// 	select id, BITAND(kdcml64v3, kdt), BITOR(kdcml64v3, kdt), BITXOR(kdcml64v3, kdt) from expr_test order by id"""
	// qt_sql_test_Decimal64V3_Date_notn_4 """
	// 	select id, BITAND(kdcml64v3, kdt), BITOR(kdcml64v3, kdt), BITXOR(kdcml64v3, kdt) from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal64V3_DateTime_0 """
		select id, kdcml64v3 + kdtm, kdcml64v3 - kdtm from expr_test order by id"""
	qt_sql_test_Decimal64V3_DateTime_notn_0 """
		select id, kdcml64v3 + kdtm, kdcml64v3 - kdtm from expr_test_not_nullable order by id"""
	//original planner  qt_sql_test_Decimal64V3_DateTime_1 """
	//original planner  	select id, kdcml64v3 * kdtm, kdcml64v3 / kdtm, kdcml64v3 % kdtm from expr_test order by id"""
	//original planner  qt_sql_test_Decimal64V3_DateTime_notn_1 """
	//original planner  	select id, kdcml64v3 * kdtm, kdcml64v3 / kdtm, kdcml64v3 % kdtm from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal64V3_DateTime_2 """
		select id, kdcml64v3 DIV kdtm from expr_test order by id"""
	qt_sql_test_Decimal64V3_DateTime_notn_2 """
		select id, kdcml64v3 DIV kdtm from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal64V3_DateTime_3 """
		select id, kdcml64v3 & kdtm, kdcml64v3 | kdtm, kdcml64v3 ^ kdtm from expr_test order by id"""
	qt_sql_test_Decimal64V3_DateTime_notn_3 """
		select id, kdcml64v3 & kdtm, kdcml64v3 | kdtm, kdcml64v3 ^ kdtm from expr_test_not_nullable order by id"""
	// qt_sql_test_Decimal64V3_DateTime_4 """
	// 	select id, BITAND(kdcml64v3, kdtm), BITOR(kdcml64v3, kdtm), BITXOR(kdcml64v3, kdtm) from expr_test order by id"""
	// qt_sql_test_Decimal64V3_DateTime_notn_4 """
	// 	select id, BITAND(kdcml64v3, kdtm), BITOR(kdcml64v3, kdtm), BITXOR(kdcml64v3, kdtm) from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal64V3_DateV2_0 """
		select id, kdcml64v3 + kdtv2, kdcml64v3 - kdtv2 from expr_test order by id"""
	qt_sql_test_Decimal64V3_DateV2_notn_0 """
		select id, kdcml64v3 + kdtv2, kdcml64v3 - kdtv2 from expr_test_not_nullable order by id"""
	//original planner  qt_sql_test_Decimal64V3_DateV2_1 """
	//original planner  	select id, kdcml64v3 * kdtv2, kdcml64v3 / kdtv2, kdcml64v3 % kdtv2 from expr_test order by id"""
	//original planner  qt_sql_test_Decimal64V3_DateV2_notn_1 """
	//original planner  	select id, kdcml64v3 * kdtv2, kdcml64v3 / kdtv2, kdcml64v3 % kdtv2 from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal64V3_DateV2_2 """
		select id, kdcml64v3 DIV kdtv2 from expr_test order by id"""
	qt_sql_test_Decimal64V3_DateV2_notn_2 """
		select id, kdcml64v3 DIV kdtv2 from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal64V3_DateV2_3 """
		select id, kdcml64v3 & kdtv2, kdcml64v3 | kdtv2, kdcml64v3 ^ kdtv2 from expr_test order by id"""
	qt_sql_test_Decimal64V3_DateV2_notn_3 """
		select id, kdcml64v3 & kdtv2, kdcml64v3 | kdtv2, kdcml64v3 ^ kdtv2 from expr_test_not_nullable order by id"""
	// qt_sql_test_Decimal64V3_DateV2_4 """
	// 	select id, BITAND(kdcml64v3, kdtv2), BITOR(kdcml64v3, kdtv2), BITXOR(kdcml64v3, kdtv2) from expr_test order by id"""
	// qt_sql_test_Decimal64V3_DateV2_notn_4 """
	// 	select id, BITAND(kdcml64v3, kdtv2), BITOR(kdcml64v3, kdtv2), BITXOR(kdcml64v3, kdtv2) from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal64V3_DateTimeV2_0 """
		select id, kdcml64v3 + kdtmv2, kdcml64v3 - kdtmv2 from expr_test order by id"""
	qt_sql_test_Decimal64V3_DateTimeV2_notn_0 """
		select id, kdcml64v3 + kdtmv2, kdcml64v3 - kdtmv2 from expr_test_not_nullable order by id"""
	//original planner  qt_sql_test_Decimal64V3_DateTimeV2_1 """
	//original planner  	select id, kdcml64v3 * kdtmv2, kdcml64v3 / kdtmv2, kdcml64v3 % kdtmv2 from expr_test order by id"""
	//original planner  qt_sql_test_Decimal64V3_DateTimeV2_notn_1 """
	//original planner  	select id, kdcml64v3 * kdtmv2, kdcml64v3 / kdtmv2, kdcml64v3 % kdtmv2 from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal64V3_DateTimeV2_2 """
		select id, kdcml64v3 DIV kdtmv2 from expr_test order by id"""
	qt_sql_test_Decimal64V3_DateTimeV2_notn_2 """
		select id, kdcml64v3 DIV kdtmv2 from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal64V3_DateTimeV2_3 """
		select id, kdcml64v3 & kdtmv2, kdcml64v3 | kdtmv2, kdcml64v3 ^ kdtmv2 from expr_test order by id"""
	qt_sql_test_Decimal64V3_DateTimeV2_notn_3 """
		select id, kdcml64v3 & kdtmv2, kdcml64v3 | kdtmv2, kdcml64v3 ^ kdtmv2 from expr_test_not_nullable order by id"""
	// qt_sql_test_Decimal64V3_DateTimeV2_4 """
	// 	select id, BITAND(kdcml64v3, kdtmv2), BITOR(kdcml64v3, kdtmv2), BITXOR(kdcml64v3, kdtmv2) from expr_test order by id"""
	// qt_sql_test_Decimal64V3_DateTimeV2_notn_4 """
	// 	select id, BITAND(kdcml64v3, kdtmv2), BITOR(kdcml64v3, kdtmv2), BITXOR(kdcml64v3, kdtmv2) from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal64V3_Boolean_0 """
		select id, kdcml64v3 + kbool, kdcml64v3 - kbool from expr_test order by id"""
	qt_sql_test_Decimal64V3_Boolean_notn_0 """
		select id, kdcml64v3 + kbool, kdcml64v3 - kbool from expr_test_not_nullable order by id"""
	//original planner  qt_sql_test_Decimal64V3_Boolean_1 """
	//original planner  	select id, kdcml64v3 * kbool, kdcml64v3 / kbool, kdcml64v3 % kbool from expr_test order by id"""
	//original planner  qt_sql_test_Decimal64V3_Boolean_notn_1 """
	//original planner  	select id, kdcml64v3 * kbool, kdcml64v3 / kbool, kdcml64v3 % kbool from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal64V3_Boolean_2 """
		select id, kdcml64v3 DIV kbool from expr_test order by id"""
	qt_sql_test_Decimal64V3_Boolean_notn_2 """
		select id, kdcml64v3 DIV kbool from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal64V3_Boolean_3 """
		select id, kdcml64v3 & kbool, kdcml64v3 | kbool, kdcml64v3 ^ kbool from expr_test order by id"""
	qt_sql_test_Decimal64V3_Boolean_notn_3 """
		select id, kdcml64v3 & kbool, kdcml64v3 | kbool, kdcml64v3 ^ kbool from expr_test_not_nullable order by id"""
	// qt_sql_test_Decimal64V3_Boolean_4 """
	// 	select id, BITAND(kdcml64v3, kbool), BITOR(kdcml64v3, kbool), BITXOR(kdcml64v3, kbool) from expr_test order by id"""
	// qt_sql_test_Decimal64V3_Boolean_notn_4 """
	// 	select id, BITAND(kdcml64v3, kbool), BITOR(kdcml64v3, kbool), BITXOR(kdcml64v3, kbool) from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal128V3_TinyInt_0 """
		select id, kdcml128v3 + ktint, kdcml128v3 - ktint from expr_test order by id"""
	qt_sql_test_Decimal128V3_TinyInt_notn_0 """
		select id, kdcml128v3 + ktint, kdcml128v3 - ktint from expr_test_not_nullable order by id"""
	//original planner  qt_sql_test_Decimal128V3_TinyInt_1 """
	//original planner  	select id, kdcml128v3 * ktint, kdcml128v3 / ktint, kdcml128v3 % ktint from expr_test order by id"""
	//original planner  qt_sql_test_Decimal128V3_TinyInt_notn_1 """
	//original planner  	select id, kdcml128v3 * ktint, kdcml128v3 / ktint, kdcml128v3 % ktint from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal128V3_TinyInt_2 """
		select id, kdcml128v3 DIV ktint from expr_test order by id"""
	qt_sql_test_Decimal128V3_TinyInt_notn_2 """
		select id, kdcml128v3 DIV ktint from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal128V3_TinyInt_3 """
		select id, kdcml128v3 & ktint, kdcml128v3 | ktint, kdcml128v3 ^ ktint from expr_test order by id"""
	qt_sql_test_Decimal128V3_TinyInt_notn_3 """
		select id, kdcml128v3 & ktint, kdcml128v3 | ktint, kdcml128v3 ^ ktint from expr_test_not_nullable order by id"""
	// qt_sql_test_Decimal128V3_TinyInt_4 """
	// 	select id, BITAND(kdcml128v3, ktint), BITOR(kdcml128v3, ktint), BITXOR(kdcml128v3, ktint) from expr_test order by id"""
	// qt_sql_test_Decimal128V3_TinyInt_notn_4 """
	// 	select id, BITAND(kdcml128v3, ktint), BITOR(kdcml128v3, ktint), BITXOR(kdcml128v3, ktint) from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal128V3_SmallInt_0 """
		select id, kdcml128v3 + ksint, kdcml128v3 - ksint from expr_test order by id"""
	qt_sql_test_Decimal128V3_SmallInt_notn_0 """
		select id, kdcml128v3 + ksint, kdcml128v3 - ksint from expr_test_not_nullable order by id"""
	//original planner  qt_sql_test_Decimal128V3_SmallInt_1 """
	//original planner  	select id, kdcml128v3 * ksint, kdcml128v3 / ksint, kdcml128v3 % ksint from expr_test order by id"""
	//original planner  qt_sql_test_Decimal128V3_SmallInt_notn_1 """
	//original planner  	select id, kdcml128v3 * ksint, kdcml128v3 / ksint, kdcml128v3 % ksint from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal128V3_SmallInt_2 """
		select id, kdcml128v3 DIV ksint from expr_test order by id"""
	qt_sql_test_Decimal128V3_SmallInt_notn_2 """
		select id, kdcml128v3 DIV ksint from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal128V3_SmallInt_3 """
		select id, kdcml128v3 & ksint, kdcml128v3 | ksint, kdcml128v3 ^ ksint from expr_test order by id"""
	qt_sql_test_Decimal128V3_SmallInt_notn_3 """
		select id, kdcml128v3 & ksint, kdcml128v3 | ksint, kdcml128v3 ^ ksint from expr_test_not_nullable order by id"""
	// qt_sql_test_Decimal128V3_SmallInt_4 """
	// 	select id, BITAND(kdcml128v3, ksint), BITOR(kdcml128v3, ksint), BITXOR(kdcml128v3, ksint) from expr_test order by id"""
	// qt_sql_test_Decimal128V3_SmallInt_notn_4 """
	// 	select id, BITAND(kdcml128v3, ksint), BITOR(kdcml128v3, ksint), BITXOR(kdcml128v3, ksint) from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal128V3_Integer_0 """
		select id, kdcml128v3 + kint, kdcml128v3 - kint from expr_test order by id"""
	qt_sql_test_Decimal128V3_Integer_notn_0 """
		select id, kdcml128v3 + kint, kdcml128v3 - kint from expr_test_not_nullable order by id"""
	//original planner  qt_sql_test_Decimal128V3_Integer_1 """
	//original planner  	select id, kdcml128v3 * kint, kdcml128v3 / kint, kdcml128v3 % kint from expr_test order by id"""
	//original planner  qt_sql_test_Decimal128V3_Integer_notn_1 """
	//original planner  	select id, kdcml128v3 * kint, kdcml128v3 / kint, kdcml128v3 % kint from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal128V3_Integer_2 """
		select id, kdcml128v3 DIV kint from expr_test order by id"""
	qt_sql_test_Decimal128V3_Integer_notn_2 """
		select id, kdcml128v3 DIV kint from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal128V3_Integer_3 """
		select id, kdcml128v3 & kint, kdcml128v3 | kint, kdcml128v3 ^ kint from expr_test order by id"""
	qt_sql_test_Decimal128V3_Integer_notn_3 """
		select id, kdcml128v3 & kint, kdcml128v3 | kint, kdcml128v3 ^ kint from expr_test_not_nullable order by id"""
	// qt_sql_test_Decimal128V3_Integer_4 """
	// 	select id, BITAND(kdcml128v3, kint), BITOR(kdcml128v3, kint), BITXOR(kdcml128v3, kint) from expr_test order by id"""
	// qt_sql_test_Decimal128V3_Integer_notn_4 """
	// 	select id, BITAND(kdcml128v3, kint), BITOR(kdcml128v3, kint), BITXOR(kdcml128v3, kint) from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal128V3_BigInt_0 """
		select id, kdcml128v3 + kbint, kdcml128v3 - kbint from expr_test order by id"""
	qt_sql_test_Decimal128V3_BigInt_notn_0 """
		select id, kdcml128v3 + kbint, kdcml128v3 - kbint from expr_test_not_nullable order by id"""
	//original planner  qt_sql_test_Decimal128V3_BigInt_1 """
	//original planner  	select id, kdcml128v3 * kbint, kdcml128v3 / kbint, kdcml128v3 % kbint from expr_test order by id"""
	//original planner  qt_sql_test_Decimal128V3_BigInt_notn_1 """
	//original planner  	select id, kdcml128v3 * kbint, kdcml128v3 / kbint, kdcml128v3 % kbint from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal128V3_BigInt_2 """
		select id, kdcml128v3 DIV kbint from expr_test order by id"""
	qt_sql_test_Decimal128V3_BigInt_notn_2 """
		select id, kdcml128v3 DIV kbint from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal128V3_BigInt_3 """
		select id, kdcml128v3 & kbint, kdcml128v3 | kbint, kdcml128v3 ^ kbint from expr_test order by id"""
	qt_sql_test_Decimal128V3_BigInt_notn_3 """
		select id, kdcml128v3 & kbint, kdcml128v3 | kbint, kdcml128v3 ^ kbint from expr_test_not_nullable order by id"""
	// qt_sql_test_Decimal128V3_BigInt_4 """
	// 	select id, BITAND(kdcml128v3, kbint), BITOR(kdcml128v3, kbint), BITXOR(kdcml128v3, kbint) from expr_test order by id"""
	// qt_sql_test_Decimal128V3_BigInt_notn_4 """
	// 	select id, BITAND(kdcml128v3, kbint), BITOR(kdcml128v3, kbint), BITXOR(kdcml128v3, kbint) from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal128V3_LargeInt_0 """
		select id, kdcml128v3 + klint, kdcml128v3 - klint from expr_test order by id"""
	qt_sql_test_Decimal128V3_LargeInt_notn_0 """
		select id, kdcml128v3 + klint, kdcml128v3 - klint from expr_test_not_nullable order by id"""
	//original planner  qt_sql_test_Decimal128V3_LargeInt_1 """
	//original planner  	select id, kdcml128v3 * klint, kdcml128v3 / klint, kdcml128v3 % klint from expr_test order by id"""
	//original planner  qt_sql_test_Decimal128V3_LargeInt_notn_1 """
	//original planner  	select id, kdcml128v3 * klint, kdcml128v3 / klint, kdcml128v3 % klint from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal128V3_LargeInt_2 """
		select id, kdcml128v3 DIV klint from expr_test order by id"""
	qt_sql_test_Decimal128V3_LargeInt_notn_2 """
		select id, kdcml128v3 DIV klint from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal128V3_LargeInt_3 """
		select id, kdcml128v3 & klint, kdcml128v3 | klint, kdcml128v3 ^ klint from expr_test order by id"""
	qt_sql_test_Decimal128V3_LargeInt_notn_3 """
		select id, kdcml128v3 & klint, kdcml128v3 | klint, kdcml128v3 ^ klint from expr_test_not_nullable order by id"""
	// qt_sql_test_Decimal128V3_LargeInt_4 """
	// 	select id, BITAND(kdcml128v3, klint), BITOR(kdcml128v3, klint), BITXOR(kdcml128v3, klint) from expr_test order by id"""
	// qt_sql_test_Decimal128V3_LargeInt_notn_4 """
	// 	select id, BITAND(kdcml128v3, klint), BITOR(kdcml128v3, klint), BITXOR(kdcml128v3, klint) from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal128V3_Float_0 """
		select id, kdcml128v3 + kfloat, kdcml128v3 - kfloat from expr_test order by id"""
	qt_sql_test_Decimal128V3_Float_notn_0 """
		select id, kdcml128v3 + kfloat, kdcml128v3 - kfloat from expr_test_not_nullable order by id"""
	// qt_sql_test_Decimal128V3_Float_1 """
	// 	select id, kdcml128v3 * kfloat, kdcml128v3 / kfloat, kdcml128v3 % kfloat from expr_test order by id"""
	// qt_sql_test_Decimal128V3_Float_notn_1 """
	// 	select id, kdcml128v3 * kfloat, kdcml128v3 / kfloat, kdcml128v3 % kfloat from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal128V3_Float_2 """
		select id, kdcml128v3 DIV kfloat from expr_test order by id"""
	qt_sql_test_Decimal128V3_Float_notn_2 """
		select id, kdcml128v3 DIV kfloat from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal128V3_Float_3 """
		select id, kdcml128v3 & kfloat, kdcml128v3 | kfloat, kdcml128v3 ^ kfloat from expr_test order by id"""
	qt_sql_test_Decimal128V3_Float_notn_3 """
		select id, kdcml128v3 & kfloat, kdcml128v3 | kfloat, kdcml128v3 ^ kfloat from expr_test_not_nullable order by id"""
	// qt_sql_test_Decimal128V3_Float_4 """
	// 	select id, BITAND(kdcml128v3, kfloat), BITOR(kdcml128v3, kfloat), BITXOR(kdcml128v3, kfloat) from expr_test order by id"""
	// qt_sql_test_Decimal128V3_Float_notn_4 """
	// 	select id, BITAND(kdcml128v3, kfloat), BITOR(kdcml128v3, kfloat), BITXOR(kdcml128v3, kfloat) from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal128V3_Double_0 """
		select id, kdcml128v3 + kdbl, kdcml128v3 - kdbl from expr_test order by id"""
	qt_sql_test_Decimal128V3_Double_notn_0 """
		select id, kdcml128v3 + kdbl, kdcml128v3 - kdbl from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal128V3_Double_1 """
		select id, kdcml128v3 * kdbl, kdcml128v3 / kdbl, kdcml128v3 % kdbl from expr_test order by id"""
	qt_sql_test_Decimal128V3_Double_notn_1 """
		select id, kdcml128v3 * kdbl, kdcml128v3 / kdbl, kdcml128v3 % kdbl from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal128V3_Double_2 """
		select id, kdcml128v3 DIV kdbl from expr_test order by id"""
	qt_sql_test_Decimal128V3_Double_notn_2 """
		select id, kdcml128v3 DIV kdbl from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal128V3_Double_3 """
		select id, kdcml128v3 & kdbl, kdcml128v3 | kdbl, kdcml128v3 ^ kdbl from expr_test order by id"""
	qt_sql_test_Decimal128V3_Double_notn_3 """
		select id, kdcml128v3 & kdbl, kdcml128v3 | kdbl, kdcml128v3 ^ kdbl from expr_test_not_nullable order by id"""
	// qt_sql_test_Decimal128V3_Double_4 """
	// 	select id, BITAND(kdcml128v3, kdbl), BITOR(kdcml128v3, kdbl), BITXOR(kdcml128v3, kdbl) from expr_test order by id"""
	// qt_sql_test_Decimal128V3_Double_notn_4 """
	// 	select id, BITAND(kdcml128v3, kdbl), BITOR(kdcml128v3, kdbl), BITXOR(kdcml128v3, kdbl) from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal128V3_DecimalV2_0 """
		select id, kdcml128v3 + kdcml, kdcml128v3 - kdcml from expr_test order by id"""
	qt_sql_test_Decimal128V3_DecimalV2_notn_0 """
		select id, kdcml128v3 + kdcml, kdcml128v3 - kdcml from expr_test_not_nullable order by id"""
	//original planner  qt_sql_test_Decimal128V3_DecimalV2_1 """
	//original planner  	select id, kdcml128v3 * kdcml, kdcml128v3 / kdcml, kdcml128v3 % kdcml from expr_test order by id"""
	//original planner  qt_sql_test_Decimal128V3_DecimalV2_notn_1 """
	//original planner  	select id, kdcml128v3 * kdcml, kdcml128v3 / kdcml, kdcml128v3 % kdcml from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal128V3_DecimalV2_2 """
		select id, kdcml128v3 DIV kdcml from expr_test order by id"""
	qt_sql_test_Decimal128V3_DecimalV2_notn_2 """
		select id, kdcml128v3 DIV kdcml from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal128V3_DecimalV2_3 """
		select id, kdcml128v3 & kdcml, kdcml128v3 | kdcml, kdcml128v3 ^ kdcml from expr_test order by id"""
	qt_sql_test_Decimal128V3_DecimalV2_notn_3 """
		select id, kdcml128v3 & kdcml, kdcml128v3 | kdcml, kdcml128v3 ^ kdcml from expr_test_not_nullable order by id"""
	// qt_sql_test_Decimal128V3_DecimalV2_4 """
	// 	select id, BITAND(kdcml128v3, kdcml), BITOR(kdcml128v3, kdcml), BITXOR(kdcml128v3, kdcml) from expr_test order by id"""
	// qt_sql_test_Decimal128V3_DecimalV2_notn_4 """
	// 	select id, BITAND(kdcml128v3, kdcml), BITOR(kdcml128v3, kdcml), BITXOR(kdcml128v3, kdcml) from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal128V3_Decimal32V3_0 """
		select id, kdcml128v3 + kdcml32v3, kdcml128v3 - kdcml32v3 from expr_test order by id"""
	qt_sql_test_Decimal128V3_Decimal32V3_notn_0 """
		select id, kdcml128v3 + kdcml32v3, kdcml128v3 - kdcml32v3 from expr_test_not_nullable order by id"""
	//original planner  qt_sql_test_Decimal128V3_Decimal32V3_1 """
	//original planner  	select id, kdcml128v3 * kdcml32v3, kdcml128v3 / kdcml32v3, kdcml128v3 % kdcml32v3 from expr_test order by id"""
	//original planner  qt_sql_test_Decimal128V3_Decimal32V3_notn_1 """
	//original planner  	select id, kdcml128v3 * kdcml32v3, kdcml128v3 / kdcml32v3, kdcml128v3 % kdcml32v3 from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal128V3_Decimal32V3_2 """
		select id, kdcml128v3 DIV kdcml32v3 from expr_test order by id"""
	qt_sql_test_Decimal128V3_Decimal32V3_notn_2 """
		select id, kdcml128v3 DIV kdcml32v3 from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal128V3_Decimal32V3_3 """
		select id, kdcml128v3 & kdcml32v3, kdcml128v3 | kdcml32v3, kdcml128v3 ^ kdcml32v3 from expr_test order by id"""
	qt_sql_test_Decimal128V3_Decimal32V3_notn_3 """
		select id, kdcml128v3 & kdcml32v3, kdcml128v3 | kdcml32v3, kdcml128v3 ^ kdcml32v3 from expr_test_not_nullable order by id"""
	// qt_sql_test_Decimal128V3_Decimal32V3_4 """
	// 	select id, BITAND(kdcml128v3, kdcml32v3), BITOR(kdcml128v3, kdcml32v3), BITXOR(kdcml128v3, kdcml32v3) from expr_test order by id"""
	// qt_sql_test_Decimal128V3_Decimal32V3_notn_4 """
	// 	select id, BITAND(kdcml128v3, kdcml32v3), BITOR(kdcml128v3, kdcml32v3), BITXOR(kdcml128v3, kdcml32v3) from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal128V3_Decimal64V3_0 """
		select id, kdcml128v3 + kdcml64v3, kdcml128v3 - kdcml64v3 from expr_test order by id"""
	qt_sql_test_Decimal128V3_Decimal64V3_notn_0 """
		select id, kdcml128v3 + kdcml64v3, kdcml128v3 - kdcml64v3 from expr_test_not_nullable order by id"""
	//original planner  qt_sql_test_Decimal128V3_Decimal64V3_1 """
	//original planner  	select id, kdcml128v3 * kdcml64v3, kdcml128v3 / kdcml64v3, kdcml128v3 % kdcml64v3 from expr_test order by id"""
	//original planner  qt_sql_test_Decimal128V3_Decimal64V3_notn_1 """
	//original planner  	select id, kdcml128v3 * kdcml64v3, kdcml128v3 / kdcml64v3, kdcml128v3 % kdcml64v3 from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal128V3_Decimal64V3_2 """
		select id, kdcml128v3 DIV kdcml64v3 from expr_test order by id"""
	qt_sql_test_Decimal128V3_Decimal64V3_notn_2 """
		select id, kdcml128v3 DIV kdcml64v3 from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal128V3_Decimal64V3_3 """
		select id, kdcml128v3 & kdcml64v3, kdcml128v3 | kdcml64v3, kdcml128v3 ^ kdcml64v3 from expr_test order by id"""
	qt_sql_test_Decimal128V3_Decimal64V3_notn_3 """
		select id, kdcml128v3 & kdcml64v3, kdcml128v3 | kdcml64v3, kdcml128v3 ^ kdcml64v3 from expr_test_not_nullable order by id"""
	// qt_sql_test_Decimal128V3_Decimal64V3_4 """
	// 	select id, BITAND(kdcml128v3, kdcml64v3), BITOR(kdcml128v3, kdcml64v3), BITXOR(kdcml128v3, kdcml64v3) from expr_test order by id"""
	// qt_sql_test_Decimal128V3_Decimal64V3_notn_4 """
	// 	select id, BITAND(kdcml128v3, kdcml64v3), BITOR(kdcml128v3, kdcml64v3), BITXOR(kdcml128v3, kdcml64v3) from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal128V3_Decimal128V3_0 """
		select id, kdcml128v3 + kdcml128v3, kdcml128v3 - kdcml128v3 from expr_test order by id"""
	qt_sql_test_Decimal128V3_Decimal128V3_notn_0 """
		select id, kdcml128v3 + kdcml128v3, kdcml128v3 - kdcml128v3 from expr_test_not_nullable order by id"""
	//original planner  qt_sql_test_Decimal128V3_Decimal128V3_1 """
	//original planner  	select id, kdcml128v3 * kdcml128v3, kdcml128v3 / kdcml128v3, kdcml128v3 % kdcml128v3 from expr_test order by id"""
	//original planner  qt_sql_test_Decimal128V3_Decimal128V3_notn_1 """
	//original planner  	select id, kdcml128v3 * kdcml128v3, kdcml128v3 / kdcml128v3, kdcml128v3 % kdcml128v3 from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal128V3_Decimal128V3_2 """
		select id, kdcml128v3 DIV kdcml128v3 from expr_test order by id"""
	qt_sql_test_Decimal128V3_Decimal128V3_notn_2 """
		select id, kdcml128v3 DIV kdcml128v3 from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal128V3_Decimal128V3_3 """
		select id, kdcml128v3 & kdcml128v3, kdcml128v3 | kdcml128v3, kdcml128v3 ^ kdcml128v3 from expr_test order by id"""
	qt_sql_test_Decimal128V3_Decimal128V3_notn_3 """
		select id, kdcml128v3 & kdcml128v3, kdcml128v3 | kdcml128v3, kdcml128v3 ^ kdcml128v3 from expr_test_not_nullable order by id"""
	// qt_sql_test_Decimal128V3_Decimal128V3_4 """
	// 	select id, BITAND(kdcml128v3, kdcml128v3), BITOR(kdcml128v3, kdcml128v3), BITXOR(kdcml128v3, kdcml128v3) from expr_test order by id"""
	// qt_sql_test_Decimal128V3_Decimal128V3_notn_4 """
	// 	select id, BITAND(kdcml128v3, kdcml128v3), BITOR(kdcml128v3, kdcml128v3), BITXOR(kdcml128v3, kdcml128v3) from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal128V3_Char_0 """
		select id, kdcml128v3 + kchr, kdcml128v3 - kchr from expr_test order by id"""
	qt_sql_test_Decimal128V3_Char_notn_0 """
		select id, kdcml128v3 + kchr, kdcml128v3 - kchr from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal128V3_Char_1 """
		select id, kdcml128v3 * kchr, kdcml128v3 / kchr, kdcml128v3 % kchr from expr_test order by id"""
	qt_sql_test_Decimal128V3_Char_notn_1 """
		select id, kdcml128v3 * kchr, kdcml128v3 / kchr, kdcml128v3 % kchr from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal128V3_Char_2 """
		select id, kdcml128v3 DIV kchr from expr_test order by id"""
	qt_sql_test_Decimal128V3_Char_notn_2 """
		select id, kdcml128v3 DIV kchr from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal128V3_Char_3 """
		select id, kdcml128v3 & kchr, kdcml128v3 | kchr, kdcml128v3 ^ kchr from expr_test order by id"""
	qt_sql_test_Decimal128V3_Char_notn_3 """
		select id, kdcml128v3 & kchr, kdcml128v3 | kchr, kdcml128v3 ^ kchr from expr_test_not_nullable order by id"""
	// qt_sql_test_Decimal128V3_Char_4 """
	// 	select id, BITAND(kdcml128v3, kchr), BITOR(kdcml128v3, kchr), BITXOR(kdcml128v3, kchr) from expr_test order by id"""
	// qt_sql_test_Decimal128V3_Char_notn_4 """
	// 	select id, BITAND(kdcml128v3, kchr), BITOR(kdcml128v3, kchr), BITXOR(kdcml128v3, kchr) from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal128V3_Varchar_0 """
		select id, kdcml128v3 + kvchr, kdcml128v3 - kvchr from expr_test order by id"""
	qt_sql_test_Decimal128V3_Varchar_notn_0 """
		select id, kdcml128v3 + kvchr, kdcml128v3 - kvchr from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal128V3_Varchar_1 """
		select id, kdcml128v3 * kvchr, kdcml128v3 / kvchr, kdcml128v3 % kvchr from expr_test order by id"""
	qt_sql_test_Decimal128V3_Varchar_notn_1 """
		select id, kdcml128v3 * kvchr, kdcml128v3 / kvchr, kdcml128v3 % kvchr from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal128V3_Varchar_2 """
		select id, kdcml128v3 DIV kvchr from expr_test order by id"""
	qt_sql_test_Decimal128V3_Varchar_notn_2 """
		select id, kdcml128v3 DIV kvchr from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal128V3_Varchar_3 """
		select id, kdcml128v3 & kvchr, kdcml128v3 | kvchr, kdcml128v3 ^ kvchr from expr_test order by id"""
	qt_sql_test_Decimal128V3_Varchar_notn_3 """
		select id, kdcml128v3 & kvchr, kdcml128v3 | kvchr, kdcml128v3 ^ kvchr from expr_test_not_nullable order by id"""
	// qt_sql_test_Decimal128V3_Varchar_4 """
	// 	select id, BITAND(kdcml128v3, kvchr), BITOR(kdcml128v3, kvchr), BITXOR(kdcml128v3, kvchr) from expr_test order by id"""
	// qt_sql_test_Decimal128V3_Varchar_notn_4 """
	// 	select id, BITAND(kdcml128v3, kvchr), BITOR(kdcml128v3, kvchr), BITXOR(kdcml128v3, kvchr) from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal128V3_String_0 """
		select id, kdcml128v3 + kstr, kdcml128v3 - kstr from expr_test order by id"""
	qt_sql_test_Decimal128V3_String_notn_0 """
		select id, kdcml128v3 + kstr, kdcml128v3 - kstr from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal128V3_String_1 """
		select id, kdcml128v3 * kstr, kdcml128v3 / kstr, kdcml128v3 % kstr from expr_test order by id"""
	qt_sql_test_Decimal128V3_String_notn_1 """
		select id, kdcml128v3 * kstr, kdcml128v3 / kstr, kdcml128v3 % kstr from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal128V3_String_2 """
		select id, kdcml128v3 DIV kstr from expr_test order by id"""
	qt_sql_test_Decimal128V3_String_notn_2 """
		select id, kdcml128v3 DIV kstr from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal128V3_String_3 """
		select id, kdcml128v3 & kstr, kdcml128v3 | kstr, kdcml128v3 ^ kstr from expr_test order by id"""
	qt_sql_test_Decimal128V3_String_notn_3 """
		select id, kdcml128v3 & kstr, kdcml128v3 | kstr, kdcml128v3 ^ kstr from expr_test_not_nullable order by id"""
	// qt_sql_test_Decimal128V3_String_4 """
	// 	select id, BITAND(kdcml128v3, kstr), BITOR(kdcml128v3, kstr), BITXOR(kdcml128v3, kstr) from expr_test order by id"""
	// qt_sql_test_Decimal128V3_String_notn_4 """
	// 	select id, BITAND(kdcml128v3, kstr), BITOR(kdcml128v3, kstr), BITXOR(kdcml128v3, kstr) from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal128V3_Date_0 """
		select id, kdcml128v3 + kdt, kdcml128v3 - kdt from expr_test order by id"""
	qt_sql_test_Decimal128V3_Date_notn_0 """
		select id, kdcml128v3 + kdt, kdcml128v3 - kdt from expr_test_not_nullable order by id"""
	//original planner  qt_sql_test_Decimal128V3_Date_1 """
	//original planner  	select id, kdcml128v3 * kdt, kdcml128v3 / kdt, kdcml128v3 % kdt from expr_test order by id"""
	//original planner  qt_sql_test_Decimal128V3_Date_notn_1 """
	//original planner  	select id, kdcml128v3 * kdt, kdcml128v3 / kdt, kdcml128v3 % kdt from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal128V3_Date_2 """
		select id, kdcml128v3 DIV kdt from expr_test order by id"""
	qt_sql_test_Decimal128V3_Date_notn_2 """
		select id, kdcml128v3 DIV kdt from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal128V3_Date_3 """
		select id, kdcml128v3 & kdt, kdcml128v3 | kdt, kdcml128v3 ^ kdt from expr_test order by id"""
	qt_sql_test_Decimal128V3_Date_notn_3 """
		select id, kdcml128v3 & kdt, kdcml128v3 | kdt, kdcml128v3 ^ kdt from expr_test_not_nullable order by id"""
	// qt_sql_test_Decimal128V3_Date_4 """
	// 	select id, BITAND(kdcml128v3, kdt), BITOR(kdcml128v3, kdt), BITXOR(kdcml128v3, kdt) from expr_test order by id"""
	// qt_sql_test_Decimal128V3_Date_notn_4 """
	// 	select id, BITAND(kdcml128v3, kdt), BITOR(kdcml128v3, kdt), BITXOR(kdcml128v3, kdt) from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal128V3_DateTime_0 """
		select id, kdcml128v3 + kdtm, kdcml128v3 - kdtm from expr_test order by id"""
	qt_sql_test_Decimal128V3_DateTime_notn_0 """
		select id, kdcml128v3 + kdtm, kdcml128v3 - kdtm from expr_test_not_nullable order by id"""
	//original planner  qt_sql_test_Decimal128V3_DateTime_1 """
	//original planner  	select id, kdcml128v3 * kdtm, kdcml128v3 / kdtm, kdcml128v3 % kdtm from expr_test order by id"""
	//original planner  qt_sql_test_Decimal128V3_DateTime_notn_1 """
	//original planner  	select id, kdcml128v3 * kdtm, kdcml128v3 / kdtm, kdcml128v3 % kdtm from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal128V3_DateTime_2 """
		select id, kdcml128v3 DIV kdtm from expr_test order by id"""
	qt_sql_test_Decimal128V3_DateTime_notn_2 """
		select id, kdcml128v3 DIV kdtm from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal128V3_DateTime_3 """
		select id, kdcml128v3 & kdtm, kdcml128v3 | kdtm, kdcml128v3 ^ kdtm from expr_test order by id"""
	qt_sql_test_Decimal128V3_DateTime_notn_3 """
		select id, kdcml128v3 & kdtm, kdcml128v3 | kdtm, kdcml128v3 ^ kdtm from expr_test_not_nullable order by id"""
	// qt_sql_test_Decimal128V3_DateTime_4 """
	// 	select id, BITAND(kdcml128v3, kdtm), BITOR(kdcml128v3, kdtm), BITXOR(kdcml128v3, kdtm) from expr_test order by id"""
	// qt_sql_test_Decimal128V3_DateTime_notn_4 """
	// 	select id, BITAND(kdcml128v3, kdtm), BITOR(kdcml128v3, kdtm), BITXOR(kdcml128v3, kdtm) from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal128V3_DateV2_0 """
		select id, kdcml128v3 + kdtv2, kdcml128v3 - kdtv2 from expr_test order by id"""
	qt_sql_test_Decimal128V3_DateV2_notn_0 """
		select id, kdcml128v3 + kdtv2, kdcml128v3 - kdtv2 from expr_test_not_nullable order by id"""
	//original planner  qt_sql_test_Decimal128V3_DateV2_1 """
	//original planner  	select id, kdcml128v3 * kdtv2, kdcml128v3 / kdtv2, kdcml128v3 % kdtv2 from expr_test order by id"""
	//original planner  qt_sql_test_Decimal128V3_DateV2_notn_1 """
	//original planner  	select id, kdcml128v3 * kdtv2, kdcml128v3 / kdtv2, kdcml128v3 % kdtv2 from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal128V3_DateV2_2 """
		select id, kdcml128v3 DIV kdtv2 from expr_test order by id"""
	qt_sql_test_Decimal128V3_DateV2_notn_2 """
		select id, kdcml128v3 DIV kdtv2 from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal128V3_DateV2_3 """
		select id, kdcml128v3 & kdtv2, kdcml128v3 | kdtv2, kdcml128v3 ^ kdtv2 from expr_test order by id"""
	qt_sql_test_Decimal128V3_DateV2_notn_3 """
		select id, kdcml128v3 & kdtv2, kdcml128v3 | kdtv2, kdcml128v3 ^ kdtv2 from expr_test_not_nullable order by id"""
	// qt_sql_test_Decimal128V3_DateV2_4 """
	// 	select id, BITAND(kdcml128v3, kdtv2), BITOR(kdcml128v3, kdtv2), BITXOR(kdcml128v3, kdtv2) from expr_test order by id"""
	// qt_sql_test_Decimal128V3_DateV2_notn_4 """
	// 	select id, BITAND(kdcml128v3, kdtv2), BITOR(kdcml128v3, kdtv2), BITXOR(kdcml128v3, kdtv2) from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal128V3_DateTimeV2_0 """
		select id, kdcml128v3 + kdtmv2, kdcml128v3 - kdtmv2 from expr_test order by id"""
	qt_sql_test_Decimal128V3_DateTimeV2_notn_0 """
		select id, kdcml128v3 + kdtmv2, kdcml128v3 - kdtmv2 from expr_test_not_nullable order by id"""
	//original planner  qt_sql_test_Decimal128V3_DateTimeV2_1 """
	//original planner  	select id, kdcml128v3 * kdtmv2, kdcml128v3 / kdtmv2, kdcml128v3 % kdtmv2 from expr_test order by id"""
	//original planner  qt_sql_test_Decimal128V3_DateTimeV2_notn_1 """
	//original planner  	select id, kdcml128v3 * kdtmv2, kdcml128v3 / kdtmv2, kdcml128v3 % kdtmv2 from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal128V3_DateTimeV2_2 """
		select id, kdcml128v3 DIV kdtmv2 from expr_test order by id"""
	qt_sql_test_Decimal128V3_DateTimeV2_notn_2 """
		select id, kdcml128v3 DIV kdtmv2 from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal128V3_DateTimeV2_3 """
		select id, kdcml128v3 & kdtmv2, kdcml128v3 | kdtmv2, kdcml128v3 ^ kdtmv2 from expr_test order by id"""
	qt_sql_test_Decimal128V3_DateTimeV2_notn_3 """
		select id, kdcml128v3 & kdtmv2, kdcml128v3 | kdtmv2, kdcml128v3 ^ kdtmv2 from expr_test_not_nullable order by id"""
	// qt_sql_test_Decimal128V3_DateTimeV2_4 """
	// 	select id, BITAND(kdcml128v3, kdtmv2), BITOR(kdcml128v3, kdtmv2), BITXOR(kdcml128v3, kdtmv2) from expr_test order by id"""
	// qt_sql_test_Decimal128V3_DateTimeV2_notn_4 """
	// 	select id, BITAND(kdcml128v3, kdtmv2), BITOR(kdcml128v3, kdtmv2), BITXOR(kdcml128v3, kdtmv2) from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal128V3_Boolean_0 """
		select id, kdcml128v3 + kbool, kdcml128v3 - kbool from expr_test order by id"""
	qt_sql_test_Decimal128V3_Boolean_notn_0 """
		select id, kdcml128v3 + kbool, kdcml128v3 - kbool from expr_test_not_nullable order by id"""
	//original planner  qt_sql_test_Decimal128V3_Boolean_1 """
	//original planner  	select id, kdcml128v3 * kbool, kdcml128v3 / kbool, kdcml128v3 % kbool from expr_test order by id"""
	//original planner  qt_sql_test_Decimal128V3_Boolean_notn_1 """
	//original planner  	select id, kdcml128v3 * kbool, kdcml128v3 / kbool, kdcml128v3 % kbool from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal128V3_Boolean_2 """
		select id, kdcml128v3 DIV kbool from expr_test order by id"""
	qt_sql_test_Decimal128V3_Boolean_notn_2 """
		select id, kdcml128v3 DIV kbool from expr_test_not_nullable order by id"""
	qt_sql_test_Decimal128V3_Boolean_3 """
		select id, kdcml128v3 & kbool, kdcml128v3 | kbool, kdcml128v3 ^ kbool from expr_test order by id"""
	qt_sql_test_Decimal128V3_Boolean_notn_3 """
		select id, kdcml128v3 & kbool, kdcml128v3 | kbool, kdcml128v3 ^ kbool from expr_test_not_nullable order by id"""
	// qt_sql_test_Decimal128V3_Boolean_4 """
	// 	select id, BITAND(kdcml128v3, kbool), BITOR(kdcml128v3, kbool), BITXOR(kdcml128v3, kbool) from expr_test order by id"""
	// qt_sql_test_Decimal128V3_Boolean_notn_4 """
	// 	select id, BITAND(kdcml128v3, kbool), BITOR(kdcml128v3, kbool), BITXOR(kdcml128v3, kbool) from expr_test_not_nullable order by id"""
}